/* notify.c generated by valac 0.26.1, the Vala compiler
 * generated from notify.vala, do not modify */

/* notify.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-datamodel.h"
#include <gio/gio.h>
#include "zeitgeist.h"
#include <gobject/gvaluecollector.h>


#define ZEITGEIST_TYPE_MONITOR_MANAGER (zeitgeist_monitor_manager_get_type ())
#define ZEITGEIST_MONITOR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManager))
#define ZEITGEIST_MONITOR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManagerClass))
#define ZEITGEIST_IS_MONITOR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_MONITOR_MANAGER))
#define ZEITGEIST_IS_MONITOR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_MONITOR_MANAGER))
#define ZEITGEIST_MONITOR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManagerClass))

typedef struct _ZeitgeistMonitorManager ZeitgeistMonitorManager;
typedef struct _ZeitgeistMonitorManagerClass ZeitgeistMonitorManagerClass;
typedef struct _ZeitgeistMonitorManagerPrivate ZeitgeistMonitorManagerPrivate;

#define ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR (zeitgeist_monitor_manager_monitor_get_type ())
#define ZEITGEIST_MONITOR_MANAGER_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, ZeitgeistMonitorManagerMonitor))
#define ZEITGEIST_MONITOR_MANAGER_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, ZeitgeistMonitorManagerMonitorClass))
#define ZEITGEIST_MONITOR_MANAGER_IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR))
#define ZEITGEIST_MONITOR_MANAGER_IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR))
#define ZEITGEIST_MONITOR_MANAGER_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, ZeitgeistMonitorManagerMonitorClass))

typedef struct _ZeitgeistMonitorManagerMonitor ZeitgeistMonitorManagerMonitor;
typedef struct _ZeitgeistMonitorManagerMonitorClass ZeitgeistMonitorManagerMonitorClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _zeitgeist_monitor_manager_monitor_unref0(var) ((var == NULL) ? NULL : (var = (zeitgeist_monitor_manager_monitor_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ZeitgeistMonitorManagerMonitorPrivate ZeitgeistMonitorManagerMonitorPrivate;
typedef struct _ZeitgeistMonitorManagerMonitorQueuedNotification ZeitgeistMonitorManagerMonitorQueuedNotification;

#define ZEITGEIST_MONITOR_MANAGER_MONITOR_TYPE_NOTIFICATION_TYPE (zeitgeist_monitor_manager_monitor_notification_type_get_type ())
#define __g_slist_free__zeitgeist_monitor_manager_monitor_queued_notification_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__zeitgeist_monitor_manager_monitor_queued_notification_free0_ (var), NULL)))
typedef struct _ZeitgeistMonitorManagerParamSpecMonitor ZeitgeistMonitorManagerParamSpecMonitor;

struct _ZeitgeistMonitorManager {
	GObject parent_instance;
	ZeitgeistMonitorManagerPrivate * priv;
};

struct _ZeitgeistMonitorManagerClass {
	GObjectClass parent_class;
};

struct _ZeitgeistMonitorManagerPrivate {
	GHashTable* monitors;
	GHashTable* connections;
};

struct _ZeitgeistMonitorManagerMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ZeitgeistMonitorManagerMonitorPrivate * priv;
};

struct _ZeitgeistMonitorManagerMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (ZeitgeistMonitorManagerMonitor *self);
};

struct _ZeitgeistMonitorManagerMonitorPrivate {
	GPtrArray* event_templates;
	ZeitgeistTimeRange* time_range;
	ZeitgeistRemoteMonitor* proxy_object;
	GSList* queued_notifications;
};

typedef enum  {
	ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_INSERTION,
	ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_DELETION
} ZeitgeistMonitorManagerMonitorNotificationType;

struct _ZeitgeistMonitorManagerMonitorQueuedNotification {
	ZeitgeistMonitorManagerMonitorNotificationType type;
	GVariant* time_range;
	GVariant* events;
	guint32* event_ids;
	gint event_ids_length1;
	gint _event_ids_size_;
};

struct _ZeitgeistMonitorManagerParamSpecMonitor {
	GParamSpec parent_instance;
};


static gpointer zeitgeist_monitor_manager_parent_class = NULL;
static ZeitgeistMonitorManager* zeitgeist_monitor_manager_instance;
static ZeitgeistMonitorManager* zeitgeist_monitor_manager_instance = NULL;
static gpointer zeitgeist_monitor_manager_monitor_parent_class = NULL;

GType zeitgeist_monitor_manager_get_type (void) G_GNUC_CONST;
static gpointer zeitgeist_monitor_manager_monitor_ref (gpointer instance);
static void zeitgeist_monitor_manager_monitor_unref (gpointer instance);
static GParamSpec* zeitgeist_monitor_manager_param_spec_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void zeitgeist_monitor_manager_value_set_monitor (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void zeitgeist_monitor_manager_value_take_monitor (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer zeitgeist_monitor_manager_value_get_monitor (const GValue* value) G_GNUC_UNUSED;
static GType zeitgeist_monitor_manager_monitor_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define ZEITGEIST_MONITOR_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManagerPrivate))
enum  {
	ZEITGEIST_MONITOR_MANAGER_DUMMY_PROPERTY
};
ZeitgeistMonitorManager* zeitgeist_monitor_manager_get_default (void);
static ZeitgeistMonitorManager* zeitgeist_monitor_manager_new (void);
static ZeitgeistMonitorManager* zeitgeist_monitor_manager_construct (GType object_type);
void zeitgeist_monitor_manager_install_monitor (ZeitgeistMonitorManager* self, const char* peer, const gchar* object_path, ZeitgeistTimeRange* time_range, GPtrArray* templates);
static ZeitgeistMonitorManagerMonitor* zeitgeist_monitor_manager_monitor_new (const char* peer, const gchar* object_path, ZeitgeistTimeRange* tr, GPtrArray* templates);
static ZeitgeistMonitorManagerMonitor* zeitgeist_monitor_manager_monitor_construct (GType object_type, const char* peer, const gchar* object_path, ZeitgeistTimeRange* tr, GPtrArray* templates);
static void _g_free0_ (gpointer var);
void zeitgeist_monitor_manager_remove_monitor (ZeitgeistMonitorManager* self, const char* peer, const gchar* object_path);
void zeitgeist_monitor_manager_notify_insert (ZeitgeistMonitorManager* self, ZeitgeistTimeRange* time_range, GPtrArray* events);
static void zeitgeist_monitor_manager_monitor_notify_insert (ZeitgeistMonitorManagerMonitor* self, ZeitgeistTimeRange* time_range, GPtrArray* events);
void zeitgeist_monitor_manager_notify_delete (ZeitgeistMonitorManager* self, ZeitgeistTimeRange* time_range, guint32* event_ids, int event_ids_length1);
static void zeitgeist_monitor_manager_monitor_notify_delete (ZeitgeistMonitorManagerMonitor* self, ZeitgeistTimeRange* time_range, guint32* event_ids, int event_ids_length1);
static GObject * zeitgeist_monitor_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _zeitgeist_monitor_manager_monitor_unref0_ (gpointer var);
static void _g_ptr_array_unref0_ (gpointer var);
static void _zeitgeist_monitor_manager____lambda7_ (ZeitgeistMonitorManager* self, GDBusConnection* conn, const gchar* sender, const gchar* path, const gchar* ifc_name, const gchar* sig_name, GVariant* parameters);
static void __zeitgeist_monitor_manager____lambda7__gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self);
static void zeitgeist_monitor_manager_monitor_queued_notification_free (ZeitgeistMonitorManagerMonitorQueuedNotification* self);
#define ZEITGEIST_MONITOR_MANAGER_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, ZeitgeistMonitorManagerMonitorPrivate))
enum  {
	ZEITGEIST_MONITOR_MANAGER_MONITOR_DUMMY_PROPERTY
};
static GType zeitgeist_monitor_manager_monitor_notification_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _zeitgeist_monitor_manager_monitor_queued_notification_free0_ (gpointer var);
static void _g_slist_free__zeitgeist_monitor_manager_monitor_queued_notification_free0_ (GSList* self);
static void __lambda6_ (ZeitgeistMonitorManagerMonitor* self, GObject* obj, GAsyncResult* res);
static void zeitgeist_monitor_manager_monitor_flush_notifications (ZeitgeistMonitorManagerMonitor* self);
static void zeitgeist_monitor_manager_monitor_name_owner_changed (ZeitgeistMonitorManagerMonitor* self);
static void _zeitgeist_monitor_manager_monitor_name_owner_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void zeitgeist_monitor_manager_monitor_queued_notification_send (ZeitgeistMonitorManagerMonitorQueuedNotification* self, ZeitgeistRemoteMonitor* proxy_object);
static gboolean zeitgeist_monitor_manager_monitor_matches (ZeitgeistMonitorManagerMonitor* self, ZeitgeistEvent* event);
static void _g_object_unref0_ (gpointer var);
static ZeitgeistMonitorManagerMonitorQueuedNotification* zeitgeist_monitor_manager_monitor_queued_notification_new_insertion (GVariant* time_range, GVariant* events);
static ZeitgeistMonitorManagerMonitorQueuedNotification* zeitgeist_monitor_manager_monitor_queued_notification_new_insertion (GVariant* time_range, GVariant* events);
static ZeitgeistMonitorManagerMonitorQueuedNotification* zeitgeist_monitor_manager_monitor_queued_notification_new_deletion (GVariant* time_range, guint32* event_ids, int event_ids_length1);
static ZeitgeistMonitorManagerMonitorQueuedNotification* zeitgeist_monitor_manager_monitor_queued_notification_new_deletion (GVariant* time_range, guint32* event_ids, int event_ids_length1);
static void zeitgeist_monitor_manager_monitor_queued_notification_instance_init (ZeitgeistMonitorManagerMonitorQueuedNotification * self);
static guint32* _vala_array_dup1 (guint32* self, int length);
static ZeitgeistMonitorManagerMonitorQueuedNotification* zeitgeist_monitor_manager_monitor_queued_notification_new (void);
static ZeitgeistMonitorManagerMonitorQueuedNotification* zeitgeist_monitor_manager_monitor_queued_notification_new (void);
static void zeitgeist_monitor_manager_monitor_finalize (ZeitgeistMonitorManagerMonitor* obj);
static void zeitgeist_monitor_manager_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ZeitgeistMonitorManager* zeitgeist_monitor_manager_get_default (void) {
	ZeitgeistMonitorManager* result = NULL;
	ZeitgeistMonitorManager* _tmp0_ = NULL;
	ZeitgeistMonitorManager* _tmp1_ = NULL;
	ZeitgeistMonitorManager* _tmp2_ = NULL;
	ZeitgeistMonitorManager* _tmp4_ = NULL;
	_tmp1_ = zeitgeist_monitor_manager_instance;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		ZeitgeistMonitorManager* _tmp3_ = NULL;
		_tmp3_ = zeitgeist_monitor_manager_new ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}


static ZeitgeistMonitorManager* zeitgeist_monitor_manager_construct (GType object_type) {
	ZeitgeistMonitorManager * self = NULL;
	self = (ZeitgeistMonitorManager*) g_object_new (object_type, NULL);
	return self;
}


static ZeitgeistMonitorManager* zeitgeist_monitor_manager_new (void) {
	return zeitgeist_monitor_manager_construct (ZEITGEIST_TYPE_MONITOR_MANAGER);
}


static gpointer _zeitgeist_monitor_manager_monitor_ref0 (gpointer self) {
	return self ? zeitgeist_monitor_manager_monitor_ref (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


void zeitgeist_monitor_manager_install_monitor (ZeitgeistMonitorManager* self, const char* peer, const gchar* object_path, ZeitgeistTimeRange* time_range, GPtrArray* templates) {
	gchar* hash = NULL;
	const char* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (peer != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (templates != NULL);
	_tmp0_ = peer;
	_tmp1_ = object_path;
	_tmp2_ = g_strdup_printf ("%s#%s", (const gchar*) _tmp0_, _tmp1_);
	hash = _tmp2_;
	_tmp3_ = self->priv->monitors;
	_tmp4_ = hash;
	_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
	if (((ZeitgeistMonitorManagerMonitor*) _tmp5_) == NULL) {
		ZeitgeistMonitorManagerMonitor* monitor = NULL;
		const char* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		ZeitgeistTimeRange* _tmp8_ = NULL;
		GPtrArray* _tmp9_ = NULL;
		ZeitgeistMonitorManagerMonitor* _tmp10_ = NULL;
		GHashTable* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		ZeitgeistMonitorManagerMonitor* _tmp14_ = NULL;
		ZeitgeistMonitorManagerMonitor* _tmp15_ = NULL;
		GHashTable* _tmp16_ = NULL;
		const char* _tmp17_ = NULL;
		gconstpointer _tmp18_ = NULL;
		GHashTable* _tmp23_ = NULL;
		const char* _tmp24_ = NULL;
		gconstpointer _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		const char* _tmp28_ = NULL;
		_tmp6_ = peer;
		_tmp7_ = object_path;
		_tmp8_ = time_range;
		_tmp9_ = templates;
		_tmp10_ = zeitgeist_monitor_manager_monitor_new (_tmp6_, _tmp7_, _tmp8_, _tmp9_);
		monitor = _tmp10_;
		_tmp11_ = self->priv->monitors;
		_tmp12_ = hash;
		_tmp13_ = g_strdup (_tmp12_);
		_tmp14_ = monitor;
		_tmp15_ = _zeitgeist_monitor_manager_monitor_ref0 (_tmp14_);
		g_hash_table_insert (_tmp11_, _tmp13_, _tmp15_);
		_tmp16_ = self->priv->connections;
		_tmp17_ = peer;
		_tmp18_ = g_hash_table_lookup (_tmp16_, (const gchar*) _tmp17_);
		if (((GPtrArray*) _tmp18_) == NULL) {
			GHashTable* _tmp19_ = NULL;
			const char* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			GPtrArray* _tmp22_ = NULL;
			_tmp19_ = self->priv->connections;
			_tmp20_ = peer;
			_tmp21_ = g_strdup ((gchar*) _tmp20_);
			_tmp22_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			g_hash_table_insert (_tmp19_, _tmp21_, _tmp22_);
		}
		_tmp23_ = self->priv->connections;
		_tmp24_ = peer;
		_tmp25_ = g_hash_table_lookup (_tmp23_, (const gchar*) _tmp24_);
		_tmp26_ = object_path;
		_tmp27_ = g_strdup (_tmp26_);
		g_ptr_array_add ((GPtrArray*) _tmp25_, _tmp27_);
		_tmp28_ = peer;
		g_debug ("notify.vala:290: Installed new monitor for %s", (const gchar*) _tmp28_);
		_zeitgeist_monitor_manager_monitor_unref0 (monitor);
	} else {
		const gchar* _tmp29_ = NULL;
		_tmp29_ = hash;
		g_warning ("notify.vala:294: There's already a monitor installed for %s", _tmp29_);
	}
	_g_free0 (hash);
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


void zeitgeist_monitor_manager_remove_monitor (ZeitgeistMonitorManager* self, const char* peer, const gchar* object_path) {
	const char* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* hash = NULL;
	const char* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gconstpointer _tmp7_ = NULL;
	GHashTable* _tmp11_ = NULL;
	const char* _tmp12_ = NULL;
	gconstpointer _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (peer != NULL);
	g_return_if_fail (object_path != NULL);
	_tmp0_ = peer;
	_tmp1_ = object_path;
	g_debug ("notify.vala:300: Removing monitor %s%s", (const gchar*) _tmp0_, _tmp1_);
	_tmp2_ = peer;
	_tmp3_ = object_path;
	_tmp4_ = g_strdup_printf ("%s#%s", (const gchar*) _tmp2_, _tmp3_);
	hash = _tmp4_;
	_tmp5_ = self->priv->monitors;
	_tmp6_ = hash;
	_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
	if (((ZeitgeistMonitorManagerMonitor*) _tmp7_) != NULL) {
		GHashTable* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = self->priv->monitors;
		_tmp9_ = hash;
		g_hash_table_remove (_tmp8_, _tmp9_);
	} else {
		const gchar* _tmp10_ = NULL;
		_tmp10_ = hash;
		g_warning ("notify.vala:306: There's no monitor installed for %s", _tmp10_);
	}
	_tmp11_ = self->priv->connections;
	_tmp12_ = peer;
	_tmp13_ = g_hash_table_lookup (_tmp11_, (const gchar*) _tmp12_);
	if (((GPtrArray*) _tmp13_) != NULL) {
		GPtrArray* paths = NULL;
		GHashTable* _tmp14_ = NULL;
		const char* _tmp15_ = NULL;
		gconstpointer _tmp16_ = NULL;
		GPtrArray* _tmp17_ = NULL;
		_tmp14_ = self->priv->connections;
		_tmp15_ = peer;
		_tmp16_ = g_hash_table_lookup (_tmp14_, (const gchar*) _tmp15_);
		_tmp17_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp16_);
		paths = _tmp17_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					gint _tmp20_ = 0;
					GPtrArray* _tmp21_ = NULL;
					gint _tmp22_ = 0;
					gint _tmp23_ = 0;
					GPtrArray* _tmp24_ = NULL;
					gint _tmp25_ = 0;
					gconstpointer _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					if (!_tmp18_) {
						gint _tmp19_ = 0;
						_tmp19_ = i;
						i = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					_tmp20_ = i;
					_tmp21_ = paths;
					_tmp22_ = g_ptr_array_get_length (_tmp21_);
					_tmp23_ = _tmp22_;
					if (!(_tmp20_ < _tmp23_)) {
						break;
					}
					_tmp24_ = paths;
					_tmp25_ = i;
					_tmp26_ = g_ptr_array_index (_tmp24_, (guint) _tmp25_);
					_tmp27_ = object_path;
					if (g_strcmp0 ((const gchar*) _tmp26_, _tmp27_) == 0) {
						GPtrArray* _tmp28_ = NULL;
						gint _tmp29_ = 0;
						_tmp28_ = paths;
						_tmp29_ = i;
						g_ptr_array_remove_index_fast (_tmp28_, (guint) _tmp29_);
						break;
					}
				}
			}
		}
		_g_ptr_array_unref0 (paths);
	}
	_g_free0 (hash);
}


void zeitgeist_monitor_manager_notify_insert (ZeitgeistMonitorManager* self, ZeitgeistTimeRange* time_range, GPtrArray* events) {
	GHashTable* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = self->priv->monitors;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* mon_collection = NULL;
		GList* mon_it = NULL;
		mon_collection = _tmp1_;
		for (mon_it = mon_collection; mon_it != NULL; mon_it = mon_it->next) {
			ZeitgeistMonitorManagerMonitor* mon = NULL;
			mon = (ZeitgeistMonitorManagerMonitor*) mon_it->data;
			{
				ZeitgeistMonitorManagerMonitor* _tmp2_ = NULL;
				ZeitgeistTimeRange* _tmp3_ = NULL;
				GPtrArray* _tmp4_ = NULL;
				_tmp2_ = mon;
				_tmp3_ = time_range;
				_tmp4_ = events;
				zeitgeist_monitor_manager_monitor_notify_insert (_tmp2_, _tmp3_, _tmp4_);
			}
		}
		_g_list_free0 (mon_collection);
	}
}


void zeitgeist_monitor_manager_notify_delete (ZeitgeistMonitorManager* self, ZeitgeistTimeRange* time_range, guint32* event_ids, int event_ids_length1) {
	GHashTable* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	_tmp0_ = self->priv->monitors;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* mon_collection = NULL;
		GList* mon_it = NULL;
		mon_collection = _tmp1_;
		for (mon_it = mon_collection; mon_it != NULL; mon_it = mon_it->next) {
			ZeitgeistMonitorManagerMonitor* mon = NULL;
			mon = (ZeitgeistMonitorManagerMonitor*) mon_it->data;
			{
				ZeitgeistMonitorManagerMonitor* _tmp2_ = NULL;
				ZeitgeistTimeRange* _tmp3_ = NULL;
				guint32* _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				_tmp2_ = mon;
				_tmp3_ = time_range;
				_tmp4_ = event_ids;
				_tmp4__length1 = event_ids_length1;
				zeitgeist_monitor_manager_monitor_notify_delete (_tmp2_, _tmp3_, _tmp4_, _tmp4__length1);
			}
		}
		_g_list_free0 (mon_collection);
	}
}


static void _zeitgeist_monitor_manager_monitor_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (zeitgeist_monitor_manager_monitor_unref (var), NULL));
}


static void _g_ptr_array_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}


static void _zeitgeist_monitor_manager____lambda7_ (ZeitgeistMonitorManager* self, GDBusConnection* conn, const gchar* sender, const gchar* path, const gchar* ifc_name, const gchar* sig_name, GVariant* parameters) {
	gchar* arg0 = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* arg1 = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* arg2 = NULL;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GHashTable* _tmp16_ = NULL;
	GList* _tmp17_ = NULL;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (ifc_name != NULL);
	g_return_if_fail (sig_name != NULL);
	g_return_if_fail (parameters != NULL);
	_tmp0_ = parameters;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_dup_string (_tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp2_);
	arg0 = _tmp4_;
	_tmp5_ = parameters;
	_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_dup_string (_tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_g_variant_unref0 (_tmp7_);
	arg1 = _tmp9_;
	_tmp10_ = parameters;
	_tmp11_ = g_variant_get_child_value (_tmp10_, (gsize) 2);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_dup_string (_tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_g_variant_unref0 (_tmp12_);
	arg2 = _tmp14_;
	_tmp15_ = arg2;
	if (g_strcmp0 (_tmp15_, "") != 0) {
		_g_free0 (arg2);
		_g_free0 (arg1);
		_g_free0 (arg0);
		return;
	}
	_tmp16_ = self->priv->connections;
	_tmp17_ = g_hash_table_get_keys (_tmp16_);
	{
		GList* owner_collection = NULL;
		GList* owner_it = NULL;
		owner_collection = _tmp17_;
		for (owner_it = owner_collection; owner_it != NULL; owner_it = owner_it->next) {
			const gchar* owner = NULL;
			owner = (const gchar*) owner_it->data;
			{
				gboolean _tmp18_ = FALSE;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				_tmp19_ = arg0;
				_tmp20_ = owner;
				if (g_strcmp0 (_tmp19_, _tmp20_) == 0) {
					const gchar* _tmp21_ = NULL;
					gboolean _tmp22_ = FALSE;
					_tmp21_ = arg0;
					_tmp22_ = g_dbus_is_unique_name (_tmp21_);
					_tmp18_ = _tmp22_;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					GPtrArray* paths = NULL;
					GHashTable* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					gconstpointer _tmp25_ = NULL;
					GPtrArray* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					GHashTable* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					_tmp23_ = self->priv->connections;
					_tmp24_ = arg0;
					_tmp25_ = g_hash_table_lookup (_tmp23_, _tmp24_);
					_tmp26_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp25_);
					paths = _tmp26_;
					_tmp27_ = owner;
					g_debug ("notify.vala:81: Client disconnected %s", _tmp27_);
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp28_ = FALSE;
							_tmp28_ = TRUE;
							while (TRUE) {
								gint _tmp30_ = 0;
								GPtrArray* _tmp31_ = NULL;
								gint _tmp32_ = 0;
								gint _tmp33_ = 0;
								const gchar* _tmp34_ = NULL;
								GPtrArray* _tmp35_ = NULL;
								gint _tmp36_ = 0;
								gconstpointer _tmp37_ = NULL;
								if (!_tmp28_) {
									gint _tmp29_ = 0;
									_tmp29_ = i;
									i = _tmp29_ + 1;
								}
								_tmp28_ = FALSE;
								_tmp30_ = i;
								_tmp31_ = paths;
								_tmp32_ = g_ptr_array_get_length (_tmp31_);
								_tmp33_ = _tmp32_;
								if (!(_tmp30_ < _tmp33_)) {
									break;
								}
								_tmp34_ = arg0;
								_tmp35_ = paths;
								_tmp36_ = i;
								_tmp37_ = g_ptr_array_index (_tmp35_, (guint) _tmp36_);
								zeitgeist_monitor_manager_remove_monitor (self, (const char*) _tmp34_, (const gchar*) _tmp37_);
							}
						}
					}
					_tmp38_ = self->priv->connections;
					_tmp39_ = arg0;
					g_hash_table_remove (_tmp38_, _tmp39_);
					_g_ptr_array_unref0 (paths);
				}
			}
		}
		_g_list_free0 (owner_collection);
	}
	_g_free0 (arg2);
	_g_free0 (arg1);
	_g_free0 (arg0);
}


static void __zeitgeist_monitor_manager____lambda7__gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self) {
	_zeitgeist_monitor_manager____lambda7_ ((ZeitgeistMonitorManager*) self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}


static GObject * zeitgeist_monitor_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistMonitorManager * self;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GHashFunc _tmp3_ = NULL;
	GEqualFunc _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_monitor_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManager);
	zeitgeist_monitor_manager_instance = self;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _zeitgeist_monitor_manager_monitor_unref0_);
	_g_hash_table_unref0 (self->priv->monitors);
	self->priv->monitors = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_ptr_array_unref0_);
	_g_hash_table_unref0 (self->priv->connections);
	self->priv->connections = _tmp5_;
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp6_ = NULL;
		GDBusConnection* _tmp7_ = NULL;
		_tmp6_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		connection = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch7_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp7_ = connection;
		g_dbus_connection_signal_subscribe (_tmp7_, "org.freedesktop.DBus", "org.freedesktop.DBus", "NameOwnerChanged", "/org/freedesktop/DBus", NULL, 0, __zeitgeist_monitor_manager____lambda7__gd_bus_signal_callback, g_object_ref (self), g_object_unref);
		_g_object_unref0 (connection);
	}
	goto __finally7;
	__catch7_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = err;
		_tmp9_ = _tmp8_->message;
		g_warning ("notify.vala:91: Cannot subscribe to NameOwnerChanged signal! %s", _tmp9_);
		_g_error_free0 (err);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static GType zeitgeist_monitor_manager_monitor_notification_type_get_type (void) {
	static volatile gsize zeitgeist_monitor_manager_monitor_notification_type_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_monitor_manager_monitor_notification_type_type_id__volatile)) {
		static const GEnumValue values[] = {{ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_INSERTION, "ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_INSERTION", "insertion"}, {ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_DELETION, "ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_DELETION", "deletion"}, {0, NULL, NULL}};
		GType zeitgeist_monitor_manager_monitor_notification_type_type_id;
		zeitgeist_monitor_manager_monitor_notification_type_type_id = g_enum_register_static ("ZeitgeistMonitorManagerMonitorNotificationType", values);
		g_once_init_leave (&zeitgeist_monitor_manager_monitor_notification_type_type_id__volatile, zeitgeist_monitor_manager_monitor_notification_type_type_id);
	}
	return zeitgeist_monitor_manager_monitor_notification_type_type_id__volatile;
}


static void _zeitgeist_monitor_manager_monitor_queued_notification_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (zeitgeist_monitor_manager_monitor_queued_notification_free (var), NULL));
}


static void _g_slist_free__zeitgeist_monitor_manager_monitor_queued_notification_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _zeitgeist_monitor_manager_monitor_queued_notification_free0_, NULL);
	g_slist_free (self);
}


static void _zeitgeist_monitor_manager_monitor_name_owner_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	zeitgeist_monitor_manager_monitor_name_owner_changed ((ZeitgeistMonitorManagerMonitor*) self);
}


static void __lambda6_ (ZeitgeistMonitorManagerMonitor* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ZeitgeistRemoteMonitor* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		ZeitgeistRemoteMonitor* _tmp2_ = NULL;
		ZeitgeistRemoteMonitor* _tmp3_ = NULL;
		ZeitgeistRemoteMonitor* _tmp4_ = NULL;
		ZeitgeistRemoteMonitor* _tmp5_ = NULL;
		_tmp1_ = res;
		_tmp2_ = g_async_result_get_source_object (_tmp1_);
		_tmp3_ = g_async_initable_new_finish (_tmp2_, _tmp1_, &_inner_error_);
		g_object_unref (_tmp2_);
		_tmp0_ = (ZeitgeistRemoteMonitor*) _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch8_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->proxy_object);
		self->priv->proxy_object = _tmp4_;
		zeitgeist_monitor_manager_monitor_flush_notifications (self);
		_tmp5_ = self->priv->proxy_object;
		g_signal_connect ((GObject*) _tmp5_, "notify::g-name-owner", (GCallback) _zeitgeist_monitor_manager_monitor_name_owner_changed_g_object_notify, self);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally8;
	__catch8_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning ("notify.vala:161: %s", _tmp7_);
		_g_error_free0 (err);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda6_ ((ZeitgeistMonitorManagerMonitor*) self, source_object, res);
	zeitgeist_monitor_manager_monitor_unref (self);
}


static ZeitgeistMonitorManagerMonitor* zeitgeist_monitor_manager_monitor_construct (GType object_type, const char* peer, const gchar* object_path, ZeitgeistTimeRange* tr, GPtrArray* templates) {
	ZeitgeistMonitorManagerMonitor* self = NULL;
	const char* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ZeitgeistTimeRange* _tmp2_ = NULL;
	ZeitgeistTimeRange* _tmp3_ = NULL;
	GPtrArray* _tmp4_ = NULL;
	GPtrArray* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (peer != NULL, NULL);
	g_return_val_if_fail (object_path != NULL, NULL);
	g_return_val_if_fail (tr != NULL, NULL);
	g_return_val_if_fail (templates != NULL, NULL);
	self = (ZeitgeistMonitorManagerMonitor*) g_type_create_instance (object_type);
	__g_slist_free__zeitgeist_monitor_manager_monitor_queued_notification_free0_0 (self->priv->queued_notifications);
	self->priv->queued_notifications = NULL;
	_tmp0_ = peer;
	_tmp1_ = object_path;
	g_async_initable_new_async (ZEITGEIST_TYPE_REMOTE_MONITOR_PROXY, 0, NULL, ___lambda6__gasync_ready_callback, zeitgeist_monitor_manager_monitor_ref (self), "g-flags", (G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS) | G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START, "g-name", (const gchar*) _tmp0_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _tmp1_, "g-interface-name", "org.gnome.zeitgeist.Monitor", "g-interface-info", g_type_get_qdata (ZEITGEIST_TYPE_REMOTE_MONITOR, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	_tmp2_ = tr;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->time_range);
	self->priv->time_range = _tmp3_;
	_tmp4_ = templates;
	_tmp5_ = _g_ptr_array_ref0 (_tmp4_);
	_g_ptr_array_unref0 (self->priv->event_templates);
	self->priv->event_templates = _tmp5_;
	return self;
}


static ZeitgeistMonitorManagerMonitor* zeitgeist_monitor_manager_monitor_new (const char* peer, const gchar* object_path, ZeitgeistTimeRange* tr, GPtrArray* templates) {
	return zeitgeist_monitor_manager_monitor_construct (ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, peer, object_path, tr, templates);
}


static void zeitgeist_monitor_manager_monitor_name_owner_changed (ZeitgeistMonitorManagerMonitor* self) {
	ZeitgeistRemoteMonitor* _tmp0_ = NULL;
	GDBusProxy* p = NULL;
	ZeitgeistRemoteMonitor* _tmp1_ = NULL;
	GDBusProxy* _tmp2_ = NULL;
	GDBusProxy* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->proxy_object;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->proxy_object;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, G_TYPE_DBUS_PROXY) ? ((GDBusProxy*) _tmp1_) : NULL);
	p = _tmp2_;
	_tmp3_ = p;
	g_object_get (_tmp3_, "g-name-owner", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_ != NULL;
	_g_free0 (_tmp6_);
	if (_tmp7_) {
		zeitgeist_monitor_manager_monitor_flush_notifications (self);
	}
	_g_object_unref0 (p);
}


static void zeitgeist_monitor_manager_monitor_flush_notifications (ZeitgeistMonitorManagerMonitor* self) {
	GSList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->queued_notifications = g_slist_reverse (self->priv->queued_notifications);
	_tmp0_ = self->priv->queued_notifications;
	{
		GSList* notification_collection = NULL;
		GSList* notification_it = NULL;
		notification_collection = _tmp0_;
		for (notification_it = notification_collection; notification_it != NULL; notification_it = notification_it->next) {
			ZeitgeistMonitorManagerMonitorQueuedNotification* notification = NULL;
			notification = (ZeitgeistMonitorManagerMonitorQueuedNotification*) notification_it->data;
			{
				ZeitgeistMonitorManagerMonitorQueuedNotification* _tmp1_ = NULL;
				ZeitgeistRemoteMonitor* _tmp2_ = NULL;
				_tmp1_ = notification;
				_tmp2_ = self->priv->proxy_object;
				zeitgeist_monitor_manager_monitor_queued_notification_send (_tmp1_, _tmp2_);
			}
		}
	}
	__g_slist_free__zeitgeist_monitor_manager_monitor_queued_notification_free0_0 (self->priv->queued_notifications);
	self->priv->queued_notifications = NULL;
}


static gboolean zeitgeist_monitor_manager_monitor_matches (ZeitgeistMonitorManagerMonitor* self, ZeitgeistEvent* event) {
	gboolean result = FALSE;
	GPtrArray* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->event_templates;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = TRUE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				ZeitgeistEvent* _tmp9_ = NULL;
				GPtrArray* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gconstpointer _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->event_templates;
				_tmp7_ = g_ptr_array_get_length (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp5_ < _tmp8_)) {
					break;
				}
				_tmp9_ = event;
				_tmp10_ = self->priv->event_templates;
				_tmp11_ = i;
				_tmp12_ = g_ptr_array_index (_tmp10_, (guint) _tmp11_);
				_tmp13_ = zeitgeist_event_matches_template (_tmp9_, (ZeitgeistEvent*) _tmp12_);
				if (_tmp13_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void zeitgeist_monitor_manager_monitor_notify_insert (ZeitgeistMonitorManagerMonitor* self, ZeitgeistTimeRange* time_range, GPtrArray* events) {
	ZeitgeistTimeRange* intersect_tr = NULL;
	ZeitgeistTimeRange* _tmp0_ = NULL;
	ZeitgeistTimeRange* _tmp1_ = NULL;
	ZeitgeistTimeRange* _tmp2_ = NULL;
	ZeitgeistTimeRange* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = time_range;
	_tmp1_ = self->priv->time_range;
	_tmp2_ = zeitgeist_time_range_intersect (_tmp0_, _tmp1_);
	intersect_tr = _tmp2_;
	_tmp3_ = intersect_tr;
	if (_tmp3_ != NULL) {
		GPtrArray* matching_events = NULL;
		GPtrArray* _tmp4_ = NULL;
		GPtrArray* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		_tmp4_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
		matching_events = _tmp4_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					gint _tmp7_ = 0;
					GPtrArray* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					GPtrArray* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gconstpointer _tmp16_ = NULL;
					if (!_tmp5_) {
						gint _tmp6_ = 0;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = i;
					_tmp8_ = events;
					_tmp9_ = g_ptr_array_get_length (_tmp8_);
					_tmp10_ = _tmp9_;
					if (!(_tmp7_ < _tmp10_)) {
						break;
					}
					_tmp14_ = events;
					_tmp15_ = i;
					_tmp16_ = g_ptr_array_index (_tmp14_, (guint) _tmp15_);
					if (((ZeitgeistEvent*) _tmp16_) != NULL) {
						GPtrArray* _tmp17_ = NULL;
						gint _tmp18_ = 0;
						gconstpointer _tmp19_ = NULL;
						gboolean _tmp20_ = FALSE;
						_tmp17_ = events;
						_tmp18_ = i;
						_tmp19_ = g_ptr_array_index (_tmp17_, (guint) _tmp18_);
						_tmp20_ = zeitgeist_monitor_manager_monitor_matches (self, (ZeitgeistEvent*) _tmp19_);
						_tmp13_ = _tmp20_;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						GPtrArray* _tmp21_ = NULL;
						gint _tmp22_ = 0;
						gconstpointer _tmp23_ = NULL;
						gint64 _tmp24_ = 0LL;
						gint64 _tmp25_ = 0LL;
						ZeitgeistTimeRange* _tmp26_ = NULL;
						gint64 _tmp27_ = 0LL;
						gint64 _tmp28_ = 0LL;
						_tmp21_ = events;
						_tmp22_ = i;
						_tmp23_ = g_ptr_array_index (_tmp21_, (guint) _tmp22_);
						_tmp24_ = zeitgeist_event_get_timestamp ((ZeitgeistEvent*) _tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = intersect_tr;
						_tmp27_ = zeitgeist_time_range_get_start (_tmp26_);
						_tmp28_ = _tmp27_;
						_tmp12_ = _tmp25_ >= _tmp28_;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						GPtrArray* _tmp29_ = NULL;
						gint _tmp30_ = 0;
						gconstpointer _tmp31_ = NULL;
						gint64 _tmp32_ = 0LL;
						gint64 _tmp33_ = 0LL;
						ZeitgeistTimeRange* _tmp34_ = NULL;
						gint64 _tmp35_ = 0LL;
						gint64 _tmp36_ = 0LL;
						_tmp29_ = events;
						_tmp30_ = i;
						_tmp31_ = g_ptr_array_index (_tmp29_, (guint) _tmp30_);
						_tmp32_ = zeitgeist_event_get_timestamp ((ZeitgeistEvent*) _tmp31_);
						_tmp33_ = _tmp32_;
						_tmp34_ = intersect_tr;
						_tmp35_ = zeitgeist_time_range_get_end (_tmp34_);
						_tmp36_ = _tmp35_;
						_tmp11_ = _tmp33_ <= _tmp36_;
					} else {
						_tmp11_ = FALSE;
					}
					if (_tmp11_) {
						GPtrArray* _tmp37_ = NULL;
						GPtrArray* _tmp38_ = NULL;
						gint _tmp39_ = 0;
						gconstpointer _tmp40_ = NULL;
						ZeitgeistEvent* _tmp41_ = NULL;
						_tmp37_ = matching_events;
						_tmp38_ = events;
						_tmp39_ = i;
						_tmp40_ = g_ptr_array_index (_tmp38_, (guint) _tmp39_);
						_tmp41_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp40_);
						g_ptr_array_add (_tmp37_, _tmp41_);
					}
				}
			}
		}
		_tmp42_ = matching_events;
		_tmp43_ = g_ptr_array_get_length (_tmp42_);
		_tmp44_ = _tmp43_;
		if (_tmp44_ > 0) {
			GVariant* time_v = NULL;
			ZeitgeistTimeRange* _tmp45_ = NULL;
			GVariant* _tmp46_ = NULL;
			GVariant* events_v = NULL;
			GPtrArray* _tmp47_ = NULL;
			GVariant* _tmp48_ = NULL;
			gchar* name_owner = NULL;
			ZeitgeistRemoteMonitor* _tmp49_ = NULL;
			gboolean _tmp56_ = FALSE;
			ZeitgeistRemoteMonitor* _tmp57_ = NULL;
			_tmp45_ = intersect_tr;
			_tmp46_ = zeitgeist_time_range_to_variant (_tmp45_);
			time_v = _tmp46_;
			_tmp47_ = matching_events;
			_tmp48_ = zeitgeist_events_to_variant (_tmp47_);
			events_v = _tmp48_;
			name_owner = NULL;
			_tmp49_ = self->priv->proxy_object;
			if (_tmp49_ != NULL) {
				GDBusProxy* p = NULL;
				ZeitgeistRemoteMonitor* _tmp50_ = NULL;
				GDBusProxy* _tmp51_ = NULL;
				GDBusProxy* _tmp52_ = NULL;
				_tmp50_ = self->priv->proxy_object;
				_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, G_TYPE_DBUS_PROXY) ? ((GDBusProxy*) _tmp50_) : NULL);
				p = _tmp51_;
				_tmp52_ = p;
				if (_tmp52_ != NULL) {
					GDBusProxy* _tmp53_ = NULL;
					gchar* _tmp54_ = NULL;
					gchar* _tmp55_ = NULL;
					_tmp53_ = p;
					g_object_get (_tmp53_, "g-name-owner", &_tmp54_, NULL);
					_tmp55_ = _tmp54_;
					_g_free0 (name_owner);
					name_owner = _tmp55_;
				}
				_g_object_unref0 (p);
			}
			_tmp57_ = self->priv->proxy_object;
			if (_tmp57_ != NULL) {
				const gchar* _tmp58_ = NULL;
				_tmp58_ = name_owner;
				_tmp56_ = _tmp58_ != NULL;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				GDBusProxy* p = NULL;
				ZeitgeistRemoteMonitor* _tmp59_ = NULL;
				GDBusProxy* _tmp60_ = NULL;
				GDBusProxy* _tmp61_ = NULL;
				const gchar* _tmp62_ = NULL;
				GPtrArray* _tmp63_ = NULL;
				gint _tmp64_ = 0;
				gint _tmp65_ = 0;
				ZeitgeistRemoteMonitor* _tmp66_ = NULL;
				GVariant* _tmp67_ = NULL;
				GVariant* _tmp68_ = NULL;
				_tmp59_ = self->priv->proxy_object;
				_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, G_TYPE_DBUS_PROXY, GDBusProxy));
				p = _tmp60_;
				_tmp61_ = p;
				_tmp62_ = g_dbus_proxy_get_name (_tmp61_);
				_tmp63_ = matching_events;
				_tmp64_ = g_ptr_array_get_length (_tmp63_);
				_tmp65_ = _tmp64_;
				g_debug ("notify.vala:234: Notifying %s about %d insertions", _tmp62_, _tmp65_);
				_tmp66_ = self->priv->proxy_object;
				_tmp67_ = time_v;
				_tmp68_ = events_v;
				zeitgeist_remote_monitor_notify_insert (_tmp66_, _tmp67_, _tmp68_, NULL, NULL);
				_g_object_unref0 (p);
			} else {
				GPtrArray* _tmp69_ = NULL;
				gint _tmp70_ = 0;
				gint _tmp71_ = 0;
				GVariant* _tmp72_ = NULL;
				GVariant* _tmp73_ = NULL;
				ZeitgeistMonitorManagerMonitorQueuedNotification* _tmp74_ = NULL;
				_tmp69_ = matching_events;
				_tmp70_ = g_ptr_array_get_length (_tmp69_);
				_tmp71_ = _tmp70_;
				g_debug ("notify.vala:241: Queueing notification about %d insertions", _tmp71_);
				_tmp72_ = time_v;
				_tmp73_ = events_v;
				_tmp74_ = zeitgeist_monitor_manager_monitor_queued_notification_new_insertion (_tmp72_, _tmp73_);
				self->priv->queued_notifications = g_slist_prepend (self->priv->queued_notifications, _tmp74_);
			}
			_g_free0 (name_owner);
			_g_variant_unref0 (events_v);
			_g_variant_unref0 (time_v);
		}
		_g_ptr_array_unref0 (matching_events);
	}
	_g_object_unref0 (intersect_tr);
}


static void zeitgeist_monitor_manager_monitor_notify_delete (ZeitgeistMonitorManagerMonitor* self, ZeitgeistTimeRange* time_range, guint32* event_ids, int event_ids_length1) {
	ZeitgeistTimeRange* intersect_tr = NULL;
	ZeitgeistTimeRange* _tmp0_ = NULL;
	ZeitgeistTimeRange* _tmp1_ = NULL;
	ZeitgeistTimeRange* _tmp2_ = NULL;
	ZeitgeistTimeRange* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	_tmp0_ = time_range;
	_tmp1_ = self->priv->time_range;
	_tmp2_ = zeitgeist_time_range_intersect (_tmp0_, _tmp1_);
	intersect_tr = _tmp2_;
	_tmp3_ = intersect_tr;
	if (_tmp3_ != NULL) {
		GVariant* time_v = NULL;
		ZeitgeistTimeRange* _tmp4_ = NULL;
		GVariant* _tmp5_ = NULL;
		gchar* name_owner = NULL;
		ZeitgeistRemoteMonitor* _tmp6_ = NULL;
		gboolean _tmp13_ = FALSE;
		ZeitgeistRemoteMonitor* _tmp14_ = NULL;
		_tmp4_ = intersect_tr;
		_tmp5_ = zeitgeist_time_range_to_variant (_tmp4_);
		time_v = _tmp5_;
		name_owner = NULL;
		_tmp6_ = self->priv->proxy_object;
		if (_tmp6_ != NULL) {
			GDBusProxy* p = NULL;
			ZeitgeistRemoteMonitor* _tmp7_ = NULL;
			GDBusProxy* _tmp8_ = NULL;
			GDBusProxy* _tmp9_ = NULL;
			_tmp7_ = self->priv->proxy_object;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, G_TYPE_DBUS_PROXY) ? ((GDBusProxy*) _tmp7_) : NULL);
			p = _tmp8_;
			_tmp9_ = p;
			if (_tmp9_ != NULL) {
				GDBusProxy* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				_tmp10_ = p;
				g_object_get (_tmp10_, "g-name-owner", &_tmp11_, NULL);
				_tmp12_ = _tmp11_;
				_g_free0 (name_owner);
				name_owner = _tmp12_;
			}
			_g_object_unref0 (p);
		}
		_tmp14_ = self->priv->proxy_object;
		if (_tmp14_ != NULL) {
			const gchar* _tmp15_ = NULL;
			_tmp15_ = name_owner;
			_tmp13_ = _tmp15_ != NULL;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			ZeitgeistRemoteMonitor* _tmp16_ = NULL;
			GVariant* _tmp17_ = NULL;
			guint32* _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			_tmp16_ = self->priv->proxy_object;
			_tmp17_ = time_v;
			_tmp18_ = event_ids;
			_tmp18__length1 = event_ids_length1;
			zeitgeist_remote_monitor_notify_delete (_tmp16_, _tmp17_, _tmp18_, _tmp18__length1, NULL, NULL);
		} else {
			GVariant* _tmp19_ = NULL;
			guint32* _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			ZeitgeistMonitorManagerMonitorQueuedNotification* _tmp21_ = NULL;
			_tmp19_ = time_v;
			_tmp20_ = event_ids;
			_tmp20__length1 = event_ids_length1;
			_tmp21_ = zeitgeist_monitor_manager_monitor_queued_notification_new_deletion (_tmp19_, _tmp20_, _tmp20__length1);
			self->priv->queued_notifications = g_slist_prepend (self->priv->queued_notifications, _tmp21_);
		}
		_g_free0 (name_owner);
		_g_variant_unref0 (time_v);
	}
	_g_object_unref0 (intersect_tr);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static ZeitgeistMonitorManagerMonitorQueuedNotification* zeitgeist_monitor_manager_monitor_queued_notification_new_insertion (GVariant* time_range, GVariant* events) {
	ZeitgeistMonitorManagerMonitorQueuedNotification* self;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (events != NULL, NULL);
	self = g_slice_new0 (ZeitgeistMonitorManagerMonitorQueuedNotification);
	zeitgeist_monitor_manager_monitor_queued_notification_instance_init (self);
	self->type = ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_INSERTION;
	_tmp0_ = time_range;
	_tmp1_ = _g_variant_ref0 (_tmp0_);
	_g_variant_unref0 (self->time_range);
	self->time_range = _tmp1_;
	_tmp2_ = events;
	_tmp3_ = _g_variant_ref0 (_tmp2_);
	_g_variant_unref0 (self->events);
	self->events = _tmp3_;
	return self;
}


static guint32* _vala_array_dup1 (guint32* self, int length) {
	return g_memdup (self, length * sizeof (guint32));
}


static ZeitgeistMonitorManagerMonitorQueuedNotification* zeitgeist_monitor_manager_monitor_queued_notification_new_deletion (GVariant* time_range, guint32* event_ids, int event_ids_length1) {
	ZeitgeistMonitorManagerMonitorQueuedNotification* self;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	guint32* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guint32* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_val_if_fail (time_range != NULL, NULL);
	self = g_slice_new0 (ZeitgeistMonitorManagerMonitorQueuedNotification);
	zeitgeist_monitor_manager_monitor_queued_notification_instance_init (self);
	self->type = ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_DELETION;
	_tmp0_ = time_range;
	_tmp1_ = _g_variant_ref0 (_tmp0_);
	_g_variant_unref0 (self->time_range);
	self->time_range = _tmp1_;
	_tmp2_ = event_ids;
	_tmp2__length1 = event_ids_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	self->event_ids = (g_free (self->event_ids), NULL);
	self->event_ids = _tmp3_;
	self->event_ids_length1 = _tmp3__length1;
	self->_event_ids_size_ = self->event_ids_length1;
	return self;
}


static void zeitgeist_monitor_manager_monitor_queued_notification_send (ZeitgeistMonitorManagerMonitorQueuedNotification* self, ZeitgeistRemoteMonitor* proxy_object) {
	ZeitgeistMonitorManagerMonitorNotificationType _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy_object != NULL);
	_tmp0_ = self->type;
	if (_tmp0_ == ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_INSERTION) {
		ZeitgeistRemoteMonitor* _tmp1_ = NULL;
		GVariant* _tmp2_ = NULL;
		GVariant* _tmp3_ = NULL;
		_tmp1_ = proxy_object;
		_tmp2_ = self->time_range;
		_tmp3_ = self->events;
		zeitgeist_remote_monitor_notify_insert (_tmp1_, _tmp2_, _tmp3_, NULL, NULL);
	} else {
		ZeitgeistRemoteMonitor* _tmp4_ = NULL;
		GVariant* _tmp5_ = NULL;
		guint32* _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp4_ = proxy_object;
		_tmp5_ = self->time_range;
		_tmp6_ = self->event_ids;
		_tmp6__length1 = self->event_ids_length1;
		zeitgeist_remote_monitor_notify_delete (_tmp4_, _tmp5_, _tmp6_, _tmp6__length1, NULL, NULL);
	}
}


static ZeitgeistMonitorManagerMonitorQueuedNotification* zeitgeist_monitor_manager_monitor_queued_notification_new (void) {
	ZeitgeistMonitorManagerMonitorQueuedNotification* self;
	self = g_slice_new0 (ZeitgeistMonitorManagerMonitorQueuedNotification);
	zeitgeist_monitor_manager_monitor_queued_notification_instance_init (self);
	return self;
}


static void zeitgeist_monitor_manager_monitor_queued_notification_instance_init (ZeitgeistMonitorManagerMonitorQueuedNotification * self) {
}


static void zeitgeist_monitor_manager_monitor_queued_notification_free (ZeitgeistMonitorManagerMonitorQueuedNotification* self) {
	_g_variant_unref0 (self->time_range);
	_g_variant_unref0 (self->events);
	self->event_ids = (g_free (self->event_ids), NULL);
	g_slice_free (ZeitgeistMonitorManagerMonitorQueuedNotification, self);
}


static void zeitgeist_monitor_manager_value_monitor_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void zeitgeist_monitor_manager_value_monitor_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		zeitgeist_monitor_manager_monitor_unref (value->data[0].v_pointer);
	}
}


static void zeitgeist_monitor_manager_value_monitor_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = zeitgeist_monitor_manager_monitor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer zeitgeist_monitor_manager_value_monitor_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* zeitgeist_monitor_manager_value_monitor_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ZeitgeistMonitorManagerMonitor* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = zeitgeist_monitor_manager_monitor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* zeitgeist_monitor_manager_value_monitor_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ZeitgeistMonitorManagerMonitor** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = zeitgeist_monitor_manager_monitor_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* zeitgeist_monitor_manager_param_spec_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ZeitgeistMonitorManagerParamSpecMonitor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer zeitgeist_monitor_manager_value_get_monitor (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR), NULL);
	return value->data[0].v_pointer;
}


static void zeitgeist_monitor_manager_value_set_monitor (GValue* value, gpointer v_object) {
	ZeitgeistMonitorManagerMonitor* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		zeitgeist_monitor_manager_monitor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_monitor_manager_monitor_unref (old);
	}
}


static void zeitgeist_monitor_manager_value_take_monitor (GValue* value, gpointer v_object) {
	ZeitgeistMonitorManagerMonitor* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_monitor_manager_monitor_unref (old);
	}
}


static void zeitgeist_monitor_manager_monitor_class_init (ZeitgeistMonitorManagerMonitorClass * klass) {
	zeitgeist_monitor_manager_monitor_parent_class = g_type_class_peek_parent (klass);
	((ZeitgeistMonitorManagerMonitorClass *) klass)->finalize = zeitgeist_monitor_manager_monitor_finalize;
	g_type_class_add_private (klass, sizeof (ZeitgeistMonitorManagerMonitorPrivate));
}


static void zeitgeist_monitor_manager_monitor_instance_init (ZeitgeistMonitorManagerMonitor * self) {
	self->priv = ZEITGEIST_MONITOR_MANAGER_MONITOR_GET_PRIVATE (self);
	self->priv->proxy_object = NULL;
	self->ref_count = 1;
}


static void zeitgeist_monitor_manager_monitor_finalize (ZeitgeistMonitorManagerMonitor* obj) {
	ZeitgeistMonitorManagerMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, ZeitgeistMonitorManagerMonitor);
	g_signal_handlers_destroy (self);
	_g_ptr_array_unref0 (self->priv->event_templates);
	_g_object_unref0 (self->priv->time_range);
	_g_object_unref0 (self->priv->proxy_object);
	__g_slist_free__zeitgeist_monitor_manager_monitor_queued_notification_free0_0 (self->priv->queued_notifications);
}


static GType zeitgeist_monitor_manager_monitor_get_type (void) {
	static volatile gsize zeitgeist_monitor_manager_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_monitor_manager_monitor_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { zeitgeist_monitor_manager_value_monitor_init, zeitgeist_monitor_manager_value_monitor_free_value, zeitgeist_monitor_manager_value_monitor_copy_value, zeitgeist_monitor_manager_value_monitor_peek_pointer, "p", zeitgeist_monitor_manager_value_monitor_collect_value, "p", zeitgeist_monitor_manager_value_monitor_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistMonitorManagerMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_monitor_manager_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistMonitorManagerMonitor), 0, (GInstanceInitFunc) zeitgeist_monitor_manager_monitor_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType zeitgeist_monitor_manager_monitor_type_id;
		zeitgeist_monitor_manager_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ZeitgeistMonitorManagerMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&zeitgeist_monitor_manager_monitor_type_id__volatile, zeitgeist_monitor_manager_monitor_type_id);
	}
	return zeitgeist_monitor_manager_monitor_type_id__volatile;
}


static gpointer zeitgeist_monitor_manager_monitor_ref (gpointer instance) {
	ZeitgeistMonitorManagerMonitor* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void zeitgeist_monitor_manager_monitor_unref (gpointer instance) {
	ZeitgeistMonitorManagerMonitor* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ZEITGEIST_MONITOR_MANAGER_MONITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void zeitgeist_monitor_manager_class_init (ZeitgeistMonitorManagerClass * klass) {
	zeitgeist_monitor_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistMonitorManagerPrivate));
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_monitor_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_monitor_manager_finalize;
}


static void zeitgeist_monitor_manager_instance_init (ZeitgeistMonitorManager * self) {
	self->priv = ZEITGEIST_MONITOR_MANAGER_GET_PRIVATE (self);
}


static void zeitgeist_monitor_manager_finalize (GObject* obj) {
	ZeitgeistMonitorManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManager);
	zeitgeist_monitor_manager_instance = NULL;
	_g_hash_table_unref0 (self->priv->monitors);
	_g_hash_table_unref0 (self->priv->connections);
	G_OBJECT_CLASS (zeitgeist_monitor_manager_parent_class)->finalize (obj);
}


GType zeitgeist_monitor_manager_get_type (void) {
	static volatile gsize zeitgeist_monitor_manager_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_monitor_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistMonitorManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_monitor_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistMonitorManager), 0, (GInstanceInitFunc) zeitgeist_monitor_manager_instance_init, NULL };
		GType zeitgeist_monitor_manager_type_id;
		zeitgeist_monitor_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistMonitorManager", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_monitor_manager_type_id__volatile, zeitgeist_monitor_manager_type_id);
	}
	return zeitgeist_monitor_manager_type_id__volatile;
}



