/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMNode.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "GObjectEventListener.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDocumentPrivate.h"
#include "WebKitDOMElementPrivate.h"
#include "WebKitDOMEventPrivate.h"
#include "WebKitDOMEventTarget.h"
#include "WebKitDOMNamedNodeMapPrivate.h"
#include "WebKitDOMNodeListPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_NODE_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_NODE, WebKitDOMNodePrivate)

typedef struct _WebKitDOMNodePrivate {
    RefPtr<WebCore::Node> coreObject;
} WebKitDOMNodePrivate;

namespace WebKit {

WebKitDOMNode* kit(WebCore::Node* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_NODE(ret);

    return wrap(obj);
}

WebCore::Node* core(WebKitDOMNode* request)
{
    return request ? static_cast<WebCore::Node*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMNode* wrapNode(WebCore::Node* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_NODE(g_object_new(WEBKIT_TYPE_DOM_NODE, "core-object", coreObject, NULL));
}

} // namespace WebKit

static void webkit_dom_node_dispatch_event(WebKitDOMEventTarget* target, WebKitDOMEvent* event, GError** error)
{
    WebCore::Event* coreEvent = WebKit::core(event);
    WebCore::Node* coreTarget = static_cast<WebCore::Node*>(WEBKIT_DOM_OBJECT(target)->coreObject);

    WebCore::ExceptionCode ec = 0;
    coreTarget->dispatchEvent(coreEvent, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription description(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), description.code, description.name);
    }
}

static gboolean webkit_dom_node_add_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble, gpointer userData)
{
    WebCore::Node* coreTarget = static_cast<WebCore::Node*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::addEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble, userData);
}

static gboolean webkit_dom_node_remove_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble)
{
    WebCore::Node* coreTarget = static_cast<WebCore::Node*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::removeEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble);
}

static void webkit_dom_event_target_init(WebKitDOMEventTargetIface* iface)
{
    iface->dispatch_event = webkit_dom_node_dispatch_event;
    iface->add_event_listener = webkit_dom_node_add_event_listener;
    iface->remove_event_listener = webkit_dom_node_remove_event_listener;
}

G_DEFINE_TYPE_WITH_CODE(WebKitDOMNode, webkit_dom_node, WEBKIT_TYPE_DOM_OBJECT, G_IMPLEMENT_INTERFACE(WEBKIT_TYPE_DOM_EVENT_TARGET, webkit_dom_event_target_init))

enum {
    PROP_0,
    PROP_NODE_NAME,
    PROP_NODE_VALUE,
    PROP_NODE_TYPE,
    PROP_PARENT_NODE,
    PROP_CHILD_NODES,
    PROP_FIRST_CHILD,
    PROP_LAST_CHILD,
    PROP_PREVIOUS_SIBLING,
    PROP_NEXT_SIBLING,
    PROP_ATTRIBUTES,
    PROP_OWNER_DOCUMENT,
    PROP_NAMESPACE_URI,
    PROP_PREFIX,
    PROP_LOCAL_NAME,
    PROP_BASE_URI,
    PROP_TEXT_CONTENT,
    PROP_PARENT_ELEMENT,
};

static void webkit_dom_node_finalize(GObject* object)
{
    WebKitDOMNodePrivate* priv = WEBKIT_DOM_NODE_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMNodePrivate();
    G_OBJECT_CLASS(webkit_dom_node_parent_class)->finalize(object);
}

static void webkit_dom_node_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMNode* self = WEBKIT_DOM_NODE(object);
    WebCore::Node* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_NODE_VALUE: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setNodeValue(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    case PROP_PREFIX: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setPrefix(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    case PROP_TEXT_CONTENT: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setTextContent(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_node_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMNode* self = WEBKIT_DOM_NODE(object);
    WebCore::Node* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_NODE_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->nodeName()));
        break;
    }
    case PROP_NODE_VALUE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->nodeValue()));
        break;
    }
    case PROP_NODE_TYPE: {
        g_value_set_uint(value, coreSelf->nodeType());
        break;
    }
    case PROP_PARENT_NODE: {
        RefPtr<WebCore::Node> ptr = coreSelf->parentNode();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_CHILD_NODES: {
        RefPtr<WebCore::NodeList> ptr = coreSelf->childNodes();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_FIRST_CHILD: {
        RefPtr<WebCore::Node> ptr = coreSelf->firstChild();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_LAST_CHILD: {
        RefPtr<WebCore::Node> ptr = coreSelf->lastChild();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_PREVIOUS_SIBLING: {
        RefPtr<WebCore::Node> ptr = coreSelf->previousSibling();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_NEXT_SIBLING: {
        RefPtr<WebCore::Node> ptr = coreSelf->nextSibling();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_ATTRIBUTES: {
        RefPtr<WebCore::NamedNodeMap> ptr = coreSelf->attributes();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_OWNER_DOCUMENT: {
        RefPtr<WebCore::Document> ptr = coreSelf->ownerDocument();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_NAMESPACE_URI: {
        g_value_take_string(value, convertToUTF8String(coreSelf->namespaceURI()));
        break;
    }
    case PROP_PREFIX: {
        g_value_take_string(value, convertToUTF8String(coreSelf->prefix()));
        break;
    }
    case PROP_LOCAL_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->localName()));
        break;
    }
    case PROP_BASE_URI: {
        g_value_take_string(value, convertToUTF8String(coreSelf->baseURI()));
        break;
    }
    case PROP_TEXT_CONTENT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->textContent()));
        break;
    }
    case PROP_PARENT_ELEMENT: {
        RefPtr<WebCore::Element> ptr = coreSelf->parentElement();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_node_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_node_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMNodePrivate* priv = WEBKIT_DOM_NODE_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::Node*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_node_class_init(WebKitDOMNodeClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMNodePrivate));
    gobjectClass->constructor = webkit_dom_node_constructor;
    gobjectClass->finalize = webkit_dom_node_finalize;
    gobjectClass->set_property = webkit_dom_node_set_property;
    gobjectClass->get_property = webkit_dom_node_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_NODE_NAME,
                                    g_param_spec_string("node-name", /* name */
                                                           "node_node-name", /* short description */
                                                           "read-only  gchar* Node.node-name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NODE_VALUE,
                                    g_param_spec_string("node-value", /* name */
                                                           "node_node-value", /* short description */
                                                           "read-write  gchar* Node.node-value", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NODE_TYPE,
                                    g_param_spec_uint("node-type", /* name */
                                                           "node_node-type", /* short description */
                                                           "read-only  gushort Node.node-type", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PARENT_NODE,
                                    g_param_spec_object("parent-node", /* name */
                                                           "node_parent-node", /* short description */
                                                           "read-only  WebKitDOMNode* Node.parent-node", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CHILD_NODES,
                                    g_param_spec_object("child-nodes", /* name */
                                                           "node_child-nodes", /* short description */
                                                           "read-only  WebKitDOMNodeList* Node.child-nodes", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FIRST_CHILD,
                                    g_param_spec_object("first-child", /* name */
                                                           "node_first-child", /* short description */
                                                           "read-only  WebKitDOMNode* Node.first-child", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LAST_CHILD,
                                    g_param_spec_object("last-child", /* name */
                                                           "node_last-child", /* short description */
                                                           "read-only  WebKitDOMNode* Node.last-child", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PREVIOUS_SIBLING,
                                    g_param_spec_object("previous-sibling", /* name */
                                                           "node_previous-sibling", /* short description */
                                                           "read-only  WebKitDOMNode* Node.previous-sibling", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NEXT_SIBLING,
                                    g_param_spec_object("next-sibling", /* name */
                                                           "node_next-sibling", /* short description */
                                                           "read-only  WebKitDOMNode* Node.next-sibling", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ATTRIBUTES,
                                    g_param_spec_object("attributes", /* name */
                                                           "node_attributes", /* short description */
                                                           "read-only  WebKitDOMNamedNodeMap* Node.attributes", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NAMED_NODE_MAP, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OWNER_DOCUMENT,
                                    g_param_spec_object("owner-document", /* name */
                                                           "node_owner-document", /* short description */
                                                           "read-only  WebKitDOMDocument* Node.owner-document", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOCUMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAMESPACE_URI,
                                    g_param_spec_string("namespace-uri", /* name */
                                                           "node_namespace-uri", /* short description */
                                                           "read-only  gchar* Node.namespace-uri", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PREFIX,
                                    g_param_spec_string("prefix", /* name */
                                                           "node_prefix", /* short description */
                                                           "read-write  gchar* Node.prefix", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LOCAL_NAME,
                                    g_param_spec_string("local-name", /* name */
                                                           "node_local-name", /* short description */
                                                           "read-only  gchar* Node.local-name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BASE_URI,
                                    g_param_spec_string("base-uri", /* name */
                                                           "node_base-uri", /* short description */
                                                           "read-only  gchar* Node.base-uri", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TEXT_CONTENT,
                                    g_param_spec_string("text-content", /* name */
                                                           "node_text-content", /* short description */
                                                           "read-write  gchar* Node.text-content", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PARENT_ELEMENT,
                                    g_param_spec_object("parent-element", /* name */
                                                           "node_parent-element", /* short description */
                                                           "read-only  WebKitDOMElement* Node.parent-element", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_node_init(WebKitDOMNode* request)
{
    WebKitDOMNodePrivate* priv = WEBKIT_DOM_NODE_GET_PRIVATE(request);
    new (priv) WebKitDOMNodePrivate();
}

WebKitDOMNode*
webkit_dom_node_insert_before(WebKitDOMNode* self, WebKitDOMNode* newChild, WebKitDOMNode* refChild, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(newChild), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(refChild), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Node* item = WebKit::core(self);
    WebCore::Node* convertedNewChild = WebKit::core(newChild);
    WebCore::Node* convertedRefChild = WebKit::core(refChild);
    WebCore::ExceptionCode ec = 0;
    bool ok = item->insertBefore(convertedNewChild, convertedRefChild, ec);
    if (ok)
        return WebKit::kit(convertedNewChild);

    WebCore::ExceptionCodeDescription ecdesc(ec);
    g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    return 0;
}

WebKitDOMNode*
webkit_dom_node_replace_child(WebKitDOMNode* self, WebKitDOMNode* newChild, WebKitDOMNode* oldChild, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(newChild), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(oldChild), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Node* item = WebKit::core(self);
    WebCore::Node* convertedNewChild = WebKit::core(newChild);
    WebCore::Node* convertedOldChild = WebKit::core(oldChild);
    WebCore::ExceptionCode ec = 0;
    bool ok = item->replaceChild(convertedNewChild, convertedOldChild, ec);
    if (ok)
        return WebKit::kit(convertedOldChild);

    WebCore::ExceptionCodeDescription ecdesc(ec);
    g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    return 0;
}

WebKitDOMNode*
webkit_dom_node_remove_child(WebKitDOMNode* self, WebKitDOMNode* oldChild, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(oldChild), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Node* item = WebKit::core(self);
    WebCore::Node* convertedOldChild = WebKit::core(oldChild);
    WebCore::ExceptionCode ec = 0;
    bool ok = item->removeChild(convertedOldChild, ec);
    if (ok)
        return WebKit::kit(convertedOldChild);

    WebCore::ExceptionCodeDescription ecdesc(ec);
    g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    return 0;
}

WebKitDOMNode*
webkit_dom_node_append_child(WebKitDOMNode* self, WebKitDOMNode* newChild, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(newChild), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Node* item = WebKit::core(self);
    WebCore::Node* convertedNewChild = WebKit::core(newChild);
    WebCore::ExceptionCode ec = 0;
    bool ok = item->appendChild(convertedNewChild, ec);
    if (ok)
        return WebKit::kit(convertedNewChild);

    WebCore::ExceptionCodeDescription ecdesc(ec);
    g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    return 0;
}

gboolean
webkit_dom_node_has_child_nodes(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), FALSE);
    WebCore::Node* item = WebKit::core(self);
    gboolean result = item->hasChildNodes();
    return result;
}

WebKitDOMNode*
webkit_dom_node_clone_node(WebKitDOMNode* self, gboolean deep)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->cloneNode(deep));
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_node_normalize(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_NODE(self));
    WebCore::Node* item = WebKit::core(self);
    item->normalize();
}

gboolean
webkit_dom_node_is_supported(WebKitDOMNode* self, const gchar* feature, const gchar* version)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), FALSE);
    g_return_val_if_fail(feature, FALSE);
    g_return_val_if_fail(version, FALSE);
    WebCore::Node* item = WebKit::core(self);
    WTF::String convertedFeature = WTF::String::fromUTF8(feature);
    WTF::String convertedVersion = WTF::String::fromUTF8(version);
    gboolean result = item->isSupported(convertedFeature, convertedVersion);
    return result;
}

gboolean
webkit_dom_node_has_attributes(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), FALSE);
    WebCore::Node* item = WebKit::core(self);
    gboolean result = item->hasAttributes();
    return result;
}

gboolean
webkit_dom_node_is_same_node(WebKitDOMNode* self, WebKitDOMNode* other)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), FALSE);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(other), FALSE);
    WebCore::Node* item = WebKit::core(self);
    WebCore::Node* convertedOther = WebKit::core(other);
    gboolean result = item->isSameNode(convertedOther);
    return result;
}

gboolean
webkit_dom_node_is_equal_node(WebKitDOMNode* self, WebKitDOMNode* other)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), FALSE);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(other), FALSE);
    WebCore::Node* item = WebKit::core(self);
    WebCore::Node* convertedOther = WebKit::core(other);
    gboolean result = item->isEqualNode(convertedOther);
    return result;
}

gchar*
webkit_dom_node_lookup_prefix(WebKitDOMNode* self, const gchar* namespaceURI)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    g_return_val_if_fail(namespaceURI, 0);
    WebCore::Node* item = WebKit::core(self);
    WTF::String convertedNamespaceURI = WTF::String::fromUTF8(namespaceURI);
    gchar* result = convertToUTF8String(item->lookupPrefix(convertedNamespaceURI));
    return result;
}

gboolean
webkit_dom_node_is_default_namespace(WebKitDOMNode* self, const gchar* namespaceURI)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), FALSE);
    g_return_val_if_fail(namespaceURI, FALSE);
    WebCore::Node* item = WebKit::core(self);
    WTF::String convertedNamespaceURI = WTF::String::fromUTF8(namespaceURI);
    gboolean result = item->isDefaultNamespace(convertedNamespaceURI);
    return result;
}

gchar*
webkit_dom_node_lookup_namespace_uri(WebKitDOMNode* self, const gchar* prefix)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    g_return_val_if_fail(prefix, 0);
    WebCore::Node* item = WebKit::core(self);
    WTF::String convertedPrefix = WTF::String::fromUTF8(prefix);
    gchar* result = convertToUTF8String(item->lookupNamespaceURI(convertedPrefix));
    return result;
}

gushort
webkit_dom_node_compare_document_position(WebKitDOMNode* self, WebKitDOMNode* other)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(other), 0);
    WebCore::Node* item = WebKit::core(self);
    WebCore::Node* convertedOther = WebKit::core(other);
    gushort result = item->compareDocumentPosition(convertedOther);
    return result;
}

gboolean
webkit_dom_node_contains(WebKitDOMNode* self, WebKitDOMNode* other)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), FALSE);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(other), FALSE);
    WebCore::Node* item = WebKit::core(self);
    WebCore::Node* convertedOther = WebKit::core(other);
    gboolean result = item->contains(convertedOther);
    return result;
}

gboolean
webkit_dom_node_dispatch_event(WebKitDOMNode* self, WebKitDOMEvent* event, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), FALSE);
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(event), FALSE);
    g_return_val_if_fail(!error || !*error, FALSE);
    WebCore::Node* item = WebKit::core(self);
    WebCore::Event* convertedEvent = WebKit::core(event);
    WebCore::ExceptionCode ec = 0;
    gboolean result = item->dispatchEvent(convertedEvent, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

gchar*
webkit_dom_node_get_node_name(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->nodeName());
    return result;
}

gchar*
webkit_dom_node_get_node_value(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->nodeValue());
    return result;
}

void
webkit_dom_node_set_node_value(WebKitDOMNode* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_NODE(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::Node* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setNodeValue(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gushort
webkit_dom_node_get_node_type(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    gushort result = item->nodeType();
    return result;
}

WebKitDOMNode*
webkit_dom_node_get_parent_node(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->parentNode());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNodeList*
webkit_dom_node_get_child_nodes(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->childNodes());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_node_get_first_child(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->firstChild());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_node_get_last_child(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->lastChild());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_node_get_previous_sibling(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->previousSibling());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_node_get_next_sibling(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->nextSibling());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNamedNodeMap*
webkit_dom_node_get_attributes(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    RefPtr<WebCore::NamedNodeMap> gobjectResult = WTF::getPtr(item->attributes());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDocument*
webkit_dom_node_get_owner_document(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    RefPtr<WebCore::Document> gobjectResult = WTF::getPtr(item->ownerDocument());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_node_get_namespace_uri(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->namespaceURI());
    return result;
}

gchar*
webkit_dom_node_get_prefix(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->prefix());
    return result;
}

void
webkit_dom_node_set_prefix(WebKitDOMNode* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_NODE(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::Node* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setPrefix(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gchar*
webkit_dom_node_get_local_name(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->localName());
    return result;
}

gchar*
webkit_dom_node_get_base_uri(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->baseURI());
    return result;
}

gchar*
webkit_dom_node_get_text_content(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->textContent());
    return result;
}

void
webkit_dom_node_set_text_content(WebKitDOMNode* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_NODE(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::Node* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setTextContent(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMElement*
webkit_dom_node_get_parent_element(WebKitDOMNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(self), 0);
    WebCore::Node* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->parentElement());
    return WebKit::kit(gobjectResult.get());
}

