/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLFontElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLFontElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLFontElement* kit(WebCore::HTMLFontElement* obj)
{
    return WEBKIT_DOM_HTML_FONT_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLFontElement* core(WebKitDOMHTMLFontElement* request)
{
    return request ? static_cast<WebCore::HTMLFontElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLFontElement* wrapHTMLFontElement(WebCore::HTMLFontElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_FONT_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_FONT_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLFontElement, webkit_dom_html_font_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_COLOR,
    PROP_FACE,
    PROP_SIZE,
};

static void webkit_dom_html_font_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLFontElement* self = WEBKIT_DOM_HTML_FONT_ELEMENT(object);
    WebCore::HTMLFontElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_COLOR: {
        coreSelf->setAttribute(WebCore::HTMLNames::colorAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_FACE: {
        coreSelf->setAttribute(WebCore::HTMLNames::faceAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SIZE: {
        coreSelf->setAttribute(WebCore::HTMLNames::sizeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_font_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLFontElement* self = WEBKIT_DOM_HTML_FONT_ELEMENT(object);
    WebCore::HTMLFontElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_COLOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::colorAttr)));
        break;
    }
    case PROP_FACE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::faceAttr)));
        break;
    }
    case PROP_SIZE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::sizeAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_font_element_class_init(WebKitDOMHTMLFontElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_font_element_set_property;
    gobjectClass->get_property = webkit_dom_html_font_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_COLOR,
                                    g_param_spec_string("color", /* name */
                                                           "html_font_element_color", /* short description */
                                                           "read-write  gchar* HTMLFontElement.color", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FACE,
                                    g_param_spec_string("face", /* name */
                                                           "html_font_element_face", /* short description */
                                                           "read-write  gchar* HTMLFontElement.face", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SIZE,
                                    g_param_spec_string("size", /* name */
                                                           "html_font_element_size", /* short description */
                                                           "read-write  gchar* HTMLFontElement.size", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_font_element_init(WebKitDOMHTMLFontElement* request)
{
}

gchar*
webkit_dom_html_font_element_get_color(WebKitDOMHTMLFontElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FONT_ELEMENT(self), 0);
    WebCore::HTMLFontElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::colorAttr));
    return result;
}

void
webkit_dom_html_font_element_set_color(WebKitDOMHTMLFontElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FONT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFontElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::colorAttr, convertedValue);
}

gchar*
webkit_dom_html_font_element_get_face(WebKitDOMHTMLFontElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FONT_ELEMENT(self), 0);
    WebCore::HTMLFontElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::faceAttr));
    return result;
}

void
webkit_dom_html_font_element_set_face(WebKitDOMHTMLFontElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FONT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFontElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::faceAttr, convertedValue);
}

gchar*
webkit_dom_html_font_element_get_size(WebKitDOMHTMLFontElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FONT_ELEMENT(self), 0);
    WebCore::HTMLFontElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::sizeAttr));
    return result;
}

void
webkit_dom_html_font_element_set_size(WebKitDOMHTMLFontElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FONT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFontElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::sizeAttr, convertedValue);
}

