/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDOMSettableTokenList.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMSettableTokenListPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMDOMSettableTokenList* kit(WebCore::DOMSettableTokenList* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_DOM_SETTABLE_TOKEN_LIST(ret);

    return wrapDOMSettableTokenList(obj);
}

WebCore::DOMSettableTokenList* core(WebKitDOMDOMSettableTokenList* request)
{
    return request ? static_cast<WebCore::DOMSettableTokenList*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDOMSettableTokenList* wrapDOMSettableTokenList(WebCore::DOMSettableTokenList* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOM_SETTABLE_TOKEN_LIST(g_object_new(WEBKIT_TYPE_DOM_DOM_SETTABLE_TOKEN_LIST, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMDOMSettableTokenList, webkit_dom_dom_settable_token_list, WEBKIT_TYPE_DOM_DOM_TOKEN_LIST)

enum {
    PROP_0,
    PROP_VALUE,
};

static void webkit_dom_dom_settable_token_list_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMDOMSettableTokenList* self = WEBKIT_DOM_DOM_SETTABLE_TOKEN_LIST(object);
    WebCore::DOMSettableTokenList* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_VALUE: {
        coreSelf->setValue(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_dom_settable_token_list_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMDOMSettableTokenList* self = WEBKIT_DOM_DOM_SETTABLE_TOKEN_LIST(object);
    WebCore::DOMSettableTokenList* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_VALUE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->value()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_dom_settable_token_list_class_init(WebKitDOMDOMSettableTokenListClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_dom_settable_token_list_set_property;
    gobjectClass->get_property = webkit_dom_dom_settable_token_list_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_VALUE,
                                    g_param_spec_string("value", /* name */
                                                           "dom_settable_token_list_value", /* short description */
                                                           "read-write  gchar* DOMSettableTokenList.value", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_dom_settable_token_list_init(WebKitDOMDOMSettableTokenList* request)
{
}

gchar*
webkit_dom_dom_settable_token_list_get_value(WebKitDOMDOMSettableTokenList* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SETTABLE_TOKEN_LIST(self), 0);
    WebCore::DOMSettableTokenList* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->value());
    return result;
}

void
webkit_dom_dom_settable_token_list_set_value(WebKitDOMDOMSettableTokenList* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_SETTABLE_TOKEN_LIST(self));
    g_return_if_fail(value);
    WebCore::DOMSettableTokenList* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setValue(convertedValue);
}

