/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SHADOW_DOM)

#include "JSCSSHostRule.h"

#include "CSSHostRule.h"
#include "CSSRuleList.h"
#include "ExceptionCode.h"
#include "JSCSSRuleList.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSHostRuleTableValues[] =
{
    { "cssRules", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSHostRuleCssRules), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSHostRuleConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSHostRuleTable = { 4, 3, JSCSSHostRuleTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCSSHostRuleConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSHostRuleConstructorTable = { 1, 0, JSCSSHostRuleConstructorTableValues, 0 };
const ClassInfo JSCSSHostRuleConstructor::s_info = { "CSSHostRuleConstructor", &Base::s_info, &JSCSSHostRuleConstructorTable, 0, CREATE_METHOD_TABLE(JSCSSHostRuleConstructor) };

JSCSSHostRuleConstructor::JSCSSHostRuleConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCSSHostRuleConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCSSHostRulePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCSSHostRuleConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSHostRuleConstructor, JSDOMWrapper>(exec, &JSCSSHostRuleConstructorTable, jsCast<JSCSSHostRuleConstructor*>(cell), propertyName, slot);
}

bool JSCSSHostRuleConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSHostRuleConstructor, JSDOMWrapper>(exec, &JSCSSHostRuleConstructorTable, jsCast<JSCSSHostRuleConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCSSHostRulePrototypeTableValues[] =
{
    { "insertRule", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSHostRulePrototypeFunctionInsertRule), (intptr_t)2, NoIntrinsic },
    { "deleteRule", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSHostRulePrototypeFunctionDeleteRule), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSHostRulePrototypeTable = { 4, 3, JSCSSHostRulePrototypeTableValues, 0 };
const ClassInfo JSCSSHostRulePrototype::s_info = { "CSSHostRulePrototype", &Base::s_info, &JSCSSHostRulePrototypeTable, 0, CREATE_METHOD_TABLE(JSCSSHostRulePrototype) };

JSObject* JSCSSHostRulePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSHostRule>(exec, globalObject);
}

bool JSCSSHostRulePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSHostRulePrototype* thisObject = jsCast<JSCSSHostRulePrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSHostRulePrototypeTable, thisObject, propertyName, slot);
}

bool JSCSSHostRulePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSHostRulePrototype* thisObject = jsCast<JSCSSHostRulePrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCSSHostRulePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSCSSHostRule::s_info = { "CSSHostRule", &Base::s_info, &JSCSSHostRuleTable, 0 , CREATE_METHOD_TABLE(JSCSSHostRule) };

JSCSSHostRule::JSCSSHostRule(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSHostRule> impl)
    : JSCSSRule(structure, globalObject, impl)
{
}

void JSCSSHostRule::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSCSSHostRule::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCSSHostRulePrototype::create(exec->globalData(), globalObject, JSCSSHostRulePrototype::createStructure(exec->globalData(), globalObject, JSCSSRulePrototype::self(exec, globalObject)));
}

bool JSCSSHostRule::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSHostRule* thisObject = jsCast<JSCSSHostRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCSSHostRule, Base>(exec, &JSCSSHostRuleTable, thisObject, propertyName, slot);
}

bool JSCSSHostRule::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSHostRule* thisObject = jsCast<JSCSSHostRule*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCSSHostRule, Base>(exec, &JSCSSHostRuleTable, thisObject, propertyName, descriptor);
}

JSValue jsCSSHostRuleCssRules(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSHostRule* castedThis = jsCast<JSCSSHostRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSHostRule* impl = static_cast<CSSHostRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->cssRules()));
    return result;
}


JSValue jsCSSHostRuleConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSHostRule* domObject = jsCast<JSCSSHostRule*>(asObject(slotBase));
    return JSCSSHostRule::getConstructor(exec, domObject->globalObject());
}

JSValue JSCSSHostRule::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSHostRuleConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCSSHostRulePrototypeFunctionInsertRule(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSHostRule::s_info))
        return throwVMTypeError(exec);
    JSCSSHostRule* castedThis = jsCast<JSCSSHostRule*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSHostRule::s_info);
    CSSHostRule* impl = static_cast<CSSHostRule*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& rule(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(exec->argument(1).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->insertRule(rule, index, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSHostRulePrototypeFunctionDeleteRule(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSHostRule::s_info))
        return throwVMTypeError(exec);
    JSCSSHostRule* castedThis = jsCast<JSCSSHostRule*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSHostRule::s_info);
    CSSHostRule* impl = static_cast<CSSHostRule*>(castedThis->impl());
    ExceptionCode ec = 0;
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->deleteRule(index, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}


}

#endif // ENABLE(SHADOW_DOM)
