/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWheelEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMWindow.h"
#include "WheelEvent.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWheelEventTableValues[] =
{
    { "wheelDelta", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWheelDelta), (intptr_t)0, NoIntrinsic },
    { "wheelDeltaX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWheelDeltaX), (intptr_t)0, NoIntrinsic },
    { "wheelDeltaY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWheelDeltaY), (intptr_t)0, NoIntrinsic },
    { "webkitDirectionInvertedFromDevice", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWebkitDirectionInvertedFromDevice), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWheelEventTable = { 17, 15, JSWheelEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWheelEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWheelEventConstructorTable = { 1, 0, JSWheelEventConstructorTableValues, 0 };
const ClassInfo JSWheelEventConstructor::s_info = { "WheelEventConstructor", &Base::s_info, &JSWheelEventConstructorTable, 0, CREATE_METHOD_TABLE(JSWheelEventConstructor) };

JSWheelEventConstructor::JSWheelEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWheelEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWheelEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWheelEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWheelEventConstructor, JSDOMWrapper>(exec, &JSWheelEventConstructorTable, jsCast<JSWheelEventConstructor*>(cell), propertyName, slot);
}

bool JSWheelEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWheelEventConstructor, JSDOMWrapper>(exec, &JSWheelEventConstructorTable, jsCast<JSWheelEventConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWheelEventPrototypeTableValues[] =
{
    { "initWebKitWheelEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWheelEventPrototypeFunctionInitWebKitWheelEvent), (intptr_t)11, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWheelEventPrototypeTable = { 2, 1, JSWheelEventPrototypeTableValues, 0 };
const ClassInfo JSWheelEventPrototype::s_info = { "WheelEventPrototype", &Base::s_info, &JSWheelEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSWheelEventPrototype) };

JSObject* JSWheelEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWheelEvent>(exec, globalObject);
}

bool JSWheelEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWheelEventPrototype* thisObject = jsCast<JSWheelEventPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSWheelEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSWheelEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWheelEventPrototype* thisObject = jsCast<JSWheelEventPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSWheelEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSWheelEvent::s_info = { "WheelEvent", &Base::s_info, &JSWheelEventTable, 0 , CREATE_METHOD_TABLE(JSWheelEvent) };

JSWheelEvent::JSWheelEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WheelEvent> impl)
    : JSMouseEvent(structure, globalObject, impl)
{
}

void JSWheelEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWheelEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWheelEventPrototype::create(exec->globalData(), globalObject, JSWheelEventPrototype::createStructure(exec->globalData(), globalObject, JSMouseEventPrototype::self(exec, globalObject)));
}

bool JSWheelEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWheelEvent* thisObject = jsCast<JSWheelEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWheelEvent, Base>(exec, &JSWheelEventTable, thisObject, propertyName, slot);
}

bool JSWheelEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWheelEvent* thisObject = jsCast<JSWheelEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWheelEvent, Base>(exec, &JSWheelEventTable, thisObject, propertyName, descriptor);
}

JSValue jsWheelEventWheelDelta(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWheelEvent* castedThis = jsCast<JSWheelEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WheelEvent* impl = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->wheelDelta());
    return result;
}


JSValue jsWheelEventWheelDeltaX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWheelEvent* castedThis = jsCast<JSWheelEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WheelEvent* impl = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->wheelDeltaX());
    return result;
}


JSValue jsWheelEventWheelDeltaY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWheelEvent* castedThis = jsCast<JSWheelEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WheelEvent* impl = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->wheelDeltaY());
    return result;
}


JSValue jsWheelEventWebkitDirectionInvertedFromDevice(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWheelEvent* castedThis = jsCast<JSWheelEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WheelEvent* impl = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->webkitDirectionInvertedFromDevice());
    return result;
}


JSValue jsWheelEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWheelEvent* domObject = jsCast<JSWheelEvent*>(asObject(slotBase));
    return JSWheelEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSWheelEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWheelEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWheelEventPrototypeFunctionInitWebKitWheelEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWheelEvent::s_info))
        return throwVMTypeError(exec);
    JSWheelEvent* castedThis = jsCast<JSWheelEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWheelEvent::s_info);
    WheelEvent* impl = static_cast<WheelEvent*>(castedThis->impl());
    int wheelDeltaX(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int wheelDeltaY(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    DOMWindow* view(toDOMWindow(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int screenX(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int screenY(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int clientX(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int clientY(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool ctrlKey(MAYBE_MISSING_PARAMETER(exec, 7, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool altKey(MAYBE_MISSING_PARAMETER(exec, 8, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool shiftKey(MAYBE_MISSING_PARAMETER(exec, 9, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool metaKey(MAYBE_MISSING_PARAMETER(exec, 10, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->initWebKitWheelEvent(wheelDeltaX, wheelDeltaY, view, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey);
    return JSValue::encode(jsUndefined());
}


}
