// This file is generated by kconfig_compiler from okular.kcfg.
// All changes you do to this file will be lost.

#include "settings.h"

#include <kstandarddirs.h>
#include <qdom.h>

#include <kglobal.h>
#include <QtCore/QFile>

#include <kdebug.h>

using namespace Okular;

namespace Okular {

class SettingsPrivate
{
  public:

    // Dlg Performance
    bool enableCompositing;

    // Debugging Options
    bool debugDrawBoundaries;
    bool debugDrawAnnotationRect;

    // Contents
    bool contentsSearchCaseSensitive;
    bool contentsSearchRegularExpression;

    // Reviews
    bool reviewsSearchCaseSensitive;
    bool reviewsSearchRegularExpression;
    QStringList annotationTools;

    // Zoom
    uint zoomMode;

    // General
    bool shellOpenFileInTabs;
    bool showOSD;
    bool displayDocumentTitle;
    int displayDocumentNameOrPath;
    bool useKTTSD;
    bool watchFile;

    // Dlg Presentation
    QColor slidesBackgroundColor;
    int slidesTransition;
    int slidesCursor;
    bool slidesShowProgress;
    bool slidesShowSummary;
    QColor slidesPencilColor;
    bool slidesTransitionsEnabled;
    int slidesScreen;

    // Main View
    bool showLeftPanel;
    QList<int> splitterSizes;
    bool showBottomBar;

    // Nav Panel
    bool currentPageOnly;
    bool groupByAuthor;
    bool groupByPage;
    bool filterBookmarks;
    bool syncThumbnailsViewport;
    bool tocPageColumn;
    bool sidebarShowText;
    uint sidebarIconSize;

    // PageView
    int editToolBarPlacement;
    bool showScrollBars;
    uint scrollOverlap;
    uint viewColumns;
    bool trimMargins;
    bool viewContinuous;
    int viewMode;
    int mouseMode;
    bool showSourceLocationsGraphically;

    // Search
    bool searchCaseSensitive;
    bool searchFromCurrentPage;

    // Dlg Accessibility
    bool highlightImages;
    bool highlightLinks;
    QColor recolorForeground;
    QColor recolorBackground;
    uint bWThreshold;
    uint bWContrast;

    // Identity
    QString identityAuthor;

    // items
    SettingsCore::ItemBool *itemEnableCompositing;
    SettingsCore::ItemBool *itemDebugDrawBoundaries;
    SettingsCore::ItemBool *itemDebugDrawAnnotationRect;
    SettingsCore::ItemBool *itemContentsSearchCaseSensitive;
    SettingsCore::ItemBool *itemContentsSearchRegularExpression;
    SettingsCore::ItemBool *itemReviewsSearchCaseSensitive;
    SettingsCore::ItemBool *itemReviewsSearchRegularExpression;
    SettingsCore::ItemStringList *itemAnnotationTools;
    SettingsCore::ItemUInt *itemZoomMode;
    SettingsCore::ItemBool *itemShellOpenFileInTabs;
    SettingsCore::ItemBool *itemShowOSD;
    SettingsCore::ItemBool *itemDisplayDocumentTitle;
    SettingsCore::ItemEnum *itemDisplayDocumentNameOrPath;
    SettingsCore::ItemBool *itemUseKTTSD;
    SettingsCore::ItemBool *itemWatchFile;
    SettingsCore::ItemColor *itemSlidesBackgroundColor;
    SettingsCore::ItemEnum *itemSlidesTransition;
    SettingsCore::ItemEnum *itemSlidesCursor;
    SettingsCore::ItemBool *itemSlidesShowProgress;
    SettingsCore::ItemBool *itemSlidesShowSummary;
    SettingsCore::ItemColor *itemSlidesPencilColor;
    SettingsCore::ItemBool *itemSlidesTransitionsEnabled;
    SettingsCore::ItemInt *itemSlidesScreen;
    SettingsCore::ItemBool *itemShowLeftPanel;
    SettingsCore::ItemIntList *itemSplitterSizes;
    SettingsCore::ItemBool *itemShowBottomBar;
    SettingsCore::ItemBool *itemCurrentPageOnly;
    SettingsCore::ItemBool *itemGroupByAuthor;
    SettingsCore::ItemBool *itemGroupByPage;
    SettingsCore::ItemBool *itemFilterBookmarks;
    SettingsCore::ItemBool *itemSyncThumbnailsViewport;
    SettingsCore::ItemBool *itemTocPageColumn;
    SettingsCore::ItemBool *itemSidebarShowText;
    SettingsCore::ItemUInt *itemSidebarIconSize;
    SettingsCore::ItemInt *itemEditToolBarPlacement;
    SettingsCore::ItemBool *itemShowScrollBars;
    SettingsCore::ItemUInt *itemScrollOverlap;
    SettingsCore::ItemUInt *itemViewColumns;
    SettingsCore::ItemBool *itemTrimMargins;
    SettingsCore::ItemBool *itemViewContinuous;
    SettingsCore::ItemEnum *itemViewMode;
    SettingsCore::ItemEnum *itemMouseMode;
    SettingsCore::ItemBool *itemShowSourceLocationsGraphically;
    SettingsCore::ItemBool *itemSearchCaseSensitive;
    SettingsCore::ItemBool *itemSearchFromCurrentPage;
    SettingsCore::ItemBool *itemHighlightImages;
    SettingsCore::ItemBool *itemHighlightLinks;
    SettingsCore::ItemColor *itemRecolorForeground;
    SettingsCore::ItemColor *itemRecolorBackground;
    SettingsCore::ItemUInt *itemBWThreshold;
    SettingsCore::ItemUInt *itemBWContrast;
    SettingsCore::ItemString *itemIdentityAuthor;
};

}

namespace Okular {

class SettingsHelper
{
  public:
    SettingsHelper() : q(0) {}
    ~SettingsHelper() { delete q; }
    Settings *q;
};
}

K_GLOBAL_STATIC(SettingsHelper, s_globalSettings)
Settings *Settings::self()
{
  if (!s_globalSettings->q)
     kFatal() << "you need to call Settings::instance before using";
  return s_globalSettings->q;
}

void Settings::instance(const QString& cfgfilename)
{
  if (s_globalSettings->q) {
     kDebug() << "Settings::instance called after the first use - ignoring";
     return;
  }
  new Settings(cfgfilename);
  s_globalSettings->q->readConfig();
}

Settings::Settings(  const QString& config  )
  : SettingsCore( config )
{
  d = new SettingsPrivate;
  Q_ASSERT(!s_globalSettings->q);
  s_globalSettings->q = this;
  setCurrentGroup( QLatin1String( "Dlg Performance" ) );

  d->itemEnableCompositing = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "EnableCompositing" ), d->enableCompositing, true );
  addItem( d->itemEnableCompositing, QLatin1String( "EnableCompositing" ) );

  setCurrentGroup( QLatin1String( "Debugging Options" ) );

  d->itemDebugDrawBoundaries = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "DebugDrawBoundaries" ), d->debugDrawBoundaries, false );
  addItem( d->itemDebugDrawBoundaries, QLatin1String( "DebugDrawBoundaries" ) );
  d->itemDebugDrawAnnotationRect = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "DebugDrawAnnotationRect" ), d->debugDrawAnnotationRect, false );
  addItem( d->itemDebugDrawAnnotationRect, QLatin1String( "DebugDrawAnnotationRect" ) );

  setCurrentGroup( QLatin1String( "Contents" ) );

  d->itemContentsSearchCaseSensitive = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "ContentsSearchCaseSensitive" ), d->contentsSearchCaseSensitive, false );
  addItem( d->itemContentsSearchCaseSensitive, QLatin1String( "ContentsSearchCaseSensitive" ) );
  d->itemContentsSearchRegularExpression = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "ContentsSearchRegularExpression" ), d->contentsSearchRegularExpression, false );
  addItem( d->itemContentsSearchRegularExpression, QLatin1String( "ContentsSearchRegularExpression" ) );

  setCurrentGroup( QLatin1String( "Reviews" ) );

  d->itemReviewsSearchCaseSensitive = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "ReviewsSearchCaseSensitive" ), d->reviewsSearchCaseSensitive, false );
  addItem( d->itemReviewsSearchCaseSensitive, QLatin1String( "ReviewsSearchCaseSensitive" ) );
  d->itemReviewsSearchRegularExpression = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "ReviewsSearchRegularExpression" ), d->reviewsSearchRegularExpression, false );
  addItem( d->itemReviewsSearchRegularExpression, QLatin1String( "ReviewsSearchRegularExpression" ) );

      QStringList annotationTools;
      // load the default tool list from the 'xml tools definition' file
      QFile infoFile( KStandardDirs::locate("data", "okular/tools.xml") );
      if ( infoFile.exists() && infoFile.open( QIODevice::ReadOnly ) )
      {
          QDomDocument doc;
          if ( doc.setContent( &infoFile ) )
          {
              QDomElement toolsDefinition = doc.elementsByTagName("annotatingTools").item( 0 ).toElement();
               // create the annotationTools list from the XML dom tree
              QDomNode toolDescription = toolsDefinition.firstChild();
              while ( toolDescription.isElement() )
              {
                  QDomElement toolElement = toolDescription.toElement();
                  if ( toolElement.tagName() == "tool" )
                  {
                      QDomDocument temp;
                      temp.appendChild( temp.importNode( toolElement, true) );
                      // add each <tool>...</tool> as XML string
                      annotationTools << temp.toString(-1);
                  }
                  toolDescription = toolDescription.nextSibling();
              }
          }
          else
          {
              kWarning() << "AnnotatingTools XML file seems to be damaged";
          }
      }
      else
      {
          kWarning() << "Unable to open AnnotatingTools XML definition";
      }
    
  d->itemAnnotationTools = new SettingsCore::ItemStringList( currentGroup(), QLatin1String( "AnnotationTools" ), d->annotationTools, annotationTools );
  addItem( d->itemAnnotationTools, QLatin1String( "AnnotationTools" ) );

  setCurrentGroup( QLatin1String( "Zoom" ) );

  d->itemZoomMode = new SettingsCore::ItemUInt( currentGroup(), QLatin1String( "ZoomMode" ), d->zoomMode, 1 );
  d->itemZoomMode->setMaxValue(3);
  addItem( d->itemZoomMode, QLatin1String( "ZoomMode" ) );

  setCurrentGroup( QLatin1String( "General" ) );

  d->itemShellOpenFileInTabs = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "ShellOpenFileInTabs" ), d->shellOpenFileInTabs, false );
  addItem( d->itemShellOpenFileInTabs, QLatin1String( "ShellOpenFileInTabs" ) );
  d->itemShowOSD = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "ShowOSD" ), d->showOSD, true );
  addItem( d->itemShowOSD, QLatin1String( "ShowOSD" ) );
  d->itemDisplayDocumentTitle = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "DisplayDocumentTitle" ), d->displayDocumentTitle, true );
  addItem( d->itemDisplayDocumentTitle, QLatin1String( "DisplayDocumentTitle" ) );
  QList<SettingsCore::ItemEnum::Choice2> valuesDisplayDocumentNameOrPath;
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("Name");
    valuesDisplayDocumentNameOrPath.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("Path");
    valuesDisplayDocumentNameOrPath.append( choice );
  }
  d->itemDisplayDocumentNameOrPath = new SettingsCore::ItemEnum( currentGroup(), QLatin1String( "DisplayDocumentNameOrPath" ), d->displayDocumentNameOrPath, valuesDisplayDocumentNameOrPath, EnumDisplayDocumentNameOrPath::Name );
  addItem( d->itemDisplayDocumentNameOrPath, QLatin1String( "DisplayDocumentNameOrPath" ) );
  d->itemUseKTTSD = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "UseKTTSD" ), d->useKTTSD );
  addItem( d->itemUseKTTSD, QLatin1String( "UseKTTSD" ) );
  d->itemWatchFile = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "WatchFile" ), d->watchFile, true );
  addItem( d->itemWatchFile, QLatin1String( "WatchFile" ) );

  setCurrentGroup( QLatin1String( "Dlg Presentation" ) );

  d->itemSlidesBackgroundColor = new SettingsCore::ItemColor( currentGroup(), QLatin1String( "SlidesBackgroundColor" ), d->slidesBackgroundColor, Qt::black );
  addItem( d->itemSlidesBackgroundColor, QLatin1String( "SlidesBackgroundColor" ) );
  QList<SettingsCore::ItemEnum::Choice2> valuesSlidesTransition;
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("BlindsHorizontal");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("BlindsVertical");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("BoxIn");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("BoxOut");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("Dissolve");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("GlitterDown");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("GlitterRight");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("GlitterRightDown");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("Random");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("Replace");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("SplitHorizontalIn");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("SplitHorizontalOut");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("SplitVerticalIn");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("SplitVerticalOut");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("WipeDown");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("WipeRight");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("WipeLeft");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("WipeUp");
    valuesSlidesTransition.append( choice );
  }
  d->itemSlidesTransition = new SettingsCore::ItemEnum( currentGroup(), QLatin1String( "SlidesTransition" ), d->slidesTransition, valuesSlidesTransition, EnumSlidesTransition::Replace );
  addItem( d->itemSlidesTransition, QLatin1String( "SlidesTransition" ) );
  QList<SettingsCore::ItemEnum::Choice2> valuesSlidesCursor;
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("HiddenDelay");
    valuesSlidesCursor.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("Visible");
    valuesSlidesCursor.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("Hidden");
    valuesSlidesCursor.append( choice );
  }
  d->itemSlidesCursor = new SettingsCore::ItemEnum( currentGroup(), QLatin1String( "SlidesCursor" ), d->slidesCursor, valuesSlidesCursor, EnumSlidesCursor::HiddenDelay );
  addItem( d->itemSlidesCursor, QLatin1String( "SlidesCursor" ) );
  d->itemSlidesShowProgress = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "SlidesShowProgress" ), d->slidesShowProgress, true );
  addItem( d->itemSlidesShowProgress, QLatin1String( "SlidesShowProgress" ) );
  d->itemSlidesShowSummary = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "SlidesShowSummary" ), d->slidesShowSummary, false );
  addItem( d->itemSlidesShowSummary, QLatin1String( "SlidesShowSummary" ) );
  d->itemSlidesPencilColor = new SettingsCore::ItemColor( currentGroup(), QLatin1String( "SlidesPencilColor" ), d->slidesPencilColor, Qt::red );
  addItem( d->itemSlidesPencilColor, QLatin1String( "SlidesPencilColor" ) );
  d->itemSlidesTransitionsEnabled = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "SlidesTransitionsEnabled" ), d->slidesTransitionsEnabled, true );
  addItem( d->itemSlidesTransitionsEnabled, QLatin1String( "SlidesTransitionsEnabled" ) );
  d->itemSlidesScreen = new SettingsCore::ItemInt( currentGroup(), QLatin1String( "SlidesScreen" ), d->slidesScreen, -2 );
  d->itemSlidesScreen->setMinValue(-2);
  d->itemSlidesScreen->setMaxValue(20);
  addItem( d->itemSlidesScreen, QLatin1String( "SlidesScreen" ) );

  setCurrentGroup( QLatin1String( "Main View" ) );

  d->itemShowLeftPanel = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "ShowLeftPanel" ), d->showLeftPanel, true );
  addItem( d->itemShowLeftPanel, QLatin1String( "ShowLeftPanel" ) );
  QList<int> defaultSplitterSizes;

  d->itemSplitterSizes = new SettingsCore::ItemIntList( currentGroup(), QLatin1String( "SplitterSizes" ), d->splitterSizes, defaultSplitterSizes );
  addItem( d->itemSplitterSizes, QLatin1String( "SplitterSizes" ) );
  d->itemShowBottomBar = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "ShowBottomBar" ), d->showBottomBar, true );
  addItem( d->itemShowBottomBar, QLatin1String( "ShowBottomBar" ) );

  setCurrentGroup( QLatin1String( "Nav Panel" ) );

  d->itemCurrentPageOnly = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "CurrentPageOnly" ), d->currentPageOnly, false );
  addItem( d->itemCurrentPageOnly, QLatin1String( "CurrentPageOnly" ) );
  d->itemGroupByAuthor = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "GroupByAuthor" ), d->groupByAuthor, true );
  addItem( d->itemGroupByAuthor, QLatin1String( "GroupByAuthor" ) );
  d->itemGroupByPage = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "GroupByPage" ), d->groupByPage, true );
  addItem( d->itemGroupByPage, QLatin1String( "GroupByPage" ) );
  d->itemFilterBookmarks = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "FilterBookmarks" ), d->filterBookmarks, false );
  addItem( d->itemFilterBookmarks, QLatin1String( "FilterBookmarks" ) );
  d->itemSyncThumbnailsViewport = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "SyncThumbnailsViewport" ), d->syncThumbnailsViewport, true );
  addItem( d->itemSyncThumbnailsViewport, QLatin1String( "SyncThumbnailsViewport" ) );
  d->itemTocPageColumn = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "TocPageColumn" ), d->tocPageColumn, true );
  addItem( d->itemTocPageColumn, QLatin1String( "TocPageColumn" ) );
  d->itemSidebarShowText = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "SidebarShowText" ), d->sidebarShowText, true );
  addItem( d->itemSidebarShowText, QLatin1String( "SidebarShowText" ) );
  d->itemSidebarIconSize = new SettingsCore::ItemUInt( currentGroup(), QLatin1String( "SidebarIconSize" ), d->sidebarIconSize, 48 );
  addItem( d->itemSidebarIconSize, QLatin1String( "SidebarIconSize" ) );

  setCurrentGroup( QLatin1String( "PageView" ) );

  d->itemEditToolBarPlacement = new SettingsCore::ItemInt( currentGroup(), QLatin1String( "EditToolBarPlacement" ), d->editToolBarPlacement, 0 );
  addItem( d->itemEditToolBarPlacement, QLatin1String( "EditToolBarPlacement" ) );
  d->itemShowScrollBars = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "ShowScrollBars" ), d->showScrollBars, true );
  addItem( d->itemShowScrollBars, QLatin1String( "ShowScrollBars" ) );
  d->itemScrollOverlap = new SettingsCore::ItemUInt( currentGroup(), QLatin1String( "ScrollOverlap" ), d->scrollOverlap, 0 );
  d->itemScrollOverlap->setMinValue(0);
  d->itemScrollOverlap->setMaxValue(50);
  addItem( d->itemScrollOverlap, QLatin1String( "ScrollOverlap" ) );
  d->itemViewColumns = new SettingsCore::ItemUInt( currentGroup(), QLatin1String( "ViewColumns" ), d->viewColumns, 3 );
  d->itemViewColumns->setMinValue(1);
  d->itemViewColumns->setMaxValue(8);
  addItem( d->itemViewColumns, QLatin1String( "ViewColumns" ) );
  d->itemTrimMargins = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "TrimMargins" ), d->trimMargins, false );
  addItem( d->itemTrimMargins, QLatin1String( "TrimMargins" ) );
  d->itemViewContinuous = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "ViewContinuous" ), d->viewContinuous, true );
  addItem( d->itemViewContinuous, QLatin1String( "ViewContinuous" ) );
  QList<SettingsCore::ItemEnum::Choice2> valuesViewMode;
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("Single");
    valuesViewMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("Facing");
    valuesViewMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("FacingFirstCentered");
    valuesViewMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("Summary");
    valuesViewMode.append( choice );
  }
  d->itemViewMode = new SettingsCore::ItemEnum( currentGroup(), QLatin1String( "ViewMode" ), d->viewMode, valuesViewMode, EnumViewMode::Single );
  addItem( d->itemViewMode, QLatin1String( "ViewMode" ) );
  QList<SettingsCore::ItemEnum::Choice2> valuesMouseMode;
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("Browse");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("Zoom");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("RectSelect");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("TextSelect");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("TableSelect");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice2 choice;
    choice.name = QLatin1String("Magnifier");
    valuesMouseMode.append( choice );
  }
  d->itemMouseMode = new SettingsCore::ItemEnum( currentGroup(), QLatin1String( "MouseMode" ), d->mouseMode, valuesMouseMode, EnumMouseMode::Browse );
  addItem( d->itemMouseMode, QLatin1String( "MouseMode" ) );
  d->itemShowSourceLocationsGraphically = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "ShowSourceLocationsGraphically" ), d->showSourceLocationsGraphically, false );
  addItem( d->itemShowSourceLocationsGraphically, QLatin1String( "ShowSourceLocationsGraphically" ) );

  setCurrentGroup( QLatin1String( "Search" ) );

  d->itemSearchCaseSensitive = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "SearchCaseSensitive" ), d->searchCaseSensitive, false );
  addItem( d->itemSearchCaseSensitive, QLatin1String( "SearchCaseSensitive" ) );
  d->itemSearchFromCurrentPage = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "SearchFromCurrentPage" ), d->searchFromCurrentPage, true );
  addItem( d->itemSearchFromCurrentPage, QLatin1String( "SearchFromCurrentPage" ) );

  setCurrentGroup( QLatin1String( "Dlg Accessibility" ) );

  d->itemHighlightImages = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "HighlightImages" ), d->highlightImages, false );
  addItem( d->itemHighlightImages, QLatin1String( "HighlightImages" ) );
  d->itemHighlightLinks = new SettingsCore::ItemBool( currentGroup(), QLatin1String( "HighlightLinks" ), d->highlightLinks, false );
  addItem( d->itemHighlightLinks, QLatin1String( "HighlightLinks" ) );
  d->itemRecolorForeground = new SettingsCore::ItemColor( currentGroup(), QLatin1String( "RecolorForeground" ), d->recolorForeground, 0x600000 );
  addItem( d->itemRecolorForeground, QLatin1String( "RecolorForeground" ) );
  d->itemRecolorBackground = new SettingsCore::ItemColor( currentGroup(), QLatin1String( "RecolorBackground" ), d->recolorBackground, 0xF0F0F0 );
  addItem( d->itemRecolorBackground, QLatin1String( "RecolorBackground" ) );
  d->itemBWThreshold = new SettingsCore::ItemUInt( currentGroup(), QLatin1String( "BWThreshold" ), d->bWThreshold, 127 );
  d->itemBWThreshold->setMinValue(2);
  d->itemBWThreshold->setMaxValue(253);
  addItem( d->itemBWThreshold, QLatin1String( "BWThreshold" ) );
  d->itemBWContrast = new SettingsCore::ItemUInt( currentGroup(), QLatin1String( "BWContrast" ), d->bWContrast, 2 );
  d->itemBWContrast->setMinValue(2);
  d->itemBWContrast->setMaxValue(6);
  addItem( d->itemBWContrast, QLatin1String( "BWContrast" ) );

  setCurrentGroup( QLatin1String( "Identity" ) );


      KUser currentUser;
      QString userString = currentUser.property( KUser::FullName ).toString();
      if ( userString.isEmpty() )
      {
        userString = currentUser.loginName();
      }
    
  d->itemIdentityAuthor = new SettingsCore::ItemString( currentGroup(), QLatin1String( "IdentityAuthor" ), d->identityAuthor, userString );
  addItem( d->itemIdentityAuthor, QLatin1String( "IdentityAuthor" ) );
}

void Settings::setEnableCompositing( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "EnableCompositing" ) ))
        self()->d->enableCompositing = v;
}

bool Settings::enableCompositing()
{
  return self()->d->enableCompositing;
}


void Settings::setDebugDrawBoundaries( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "DebugDrawBoundaries" ) ))
        self()->d->debugDrawBoundaries = v;
}

bool Settings::debugDrawBoundaries()
{
  return self()->d->debugDrawBoundaries;
}


void Settings::setDebugDrawAnnotationRect( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "DebugDrawAnnotationRect" ) ))
        self()->d->debugDrawAnnotationRect = v;
}

bool Settings::debugDrawAnnotationRect()
{
  return self()->d->debugDrawAnnotationRect;
}


void Settings::setContentsSearchCaseSensitive( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "ContentsSearchCaseSensitive" ) ))
        self()->d->contentsSearchCaseSensitive = v;
}

bool Settings::contentsSearchCaseSensitive()
{
  return self()->d->contentsSearchCaseSensitive;
}


void Settings::setContentsSearchRegularExpression( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "ContentsSearchRegularExpression" ) ))
        self()->d->contentsSearchRegularExpression = v;
}

bool Settings::contentsSearchRegularExpression()
{
  return self()->d->contentsSearchRegularExpression;
}


void Settings::setReviewsSearchCaseSensitive( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "ReviewsSearchCaseSensitive" ) ))
        self()->d->reviewsSearchCaseSensitive = v;
}

bool Settings::reviewsSearchCaseSensitive()
{
  return self()->d->reviewsSearchCaseSensitive;
}


void Settings::setReviewsSearchRegularExpression( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "ReviewsSearchRegularExpression" ) ))
        self()->d->reviewsSearchRegularExpression = v;
}

bool Settings::reviewsSearchRegularExpression()
{
  return self()->d->reviewsSearchRegularExpression;
}


void Settings::setAnnotationTools( const QStringList & v )
{
      if (!self()->isImmutable( QString::fromLatin1( "AnnotationTools" ) ))
        self()->d->annotationTools = v;
}

QStringList Settings::annotationTools()
{
  return self()->d->annotationTools;
}


void Settings::setZoomMode( uint v )
{

      if (v > 3)
      {
        kDebug() << "setZoomMode: value " << v << " is greater than the maximum value of 3";
        v = 3;
      }

      if (!self()->isImmutable( QString::fromLatin1( "ZoomMode" ) ))
        self()->d->zoomMode = v;
}

uint Settings::zoomMode()
{
  return self()->d->zoomMode;
}


void Settings::setShellOpenFileInTabs( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "ShellOpenFileInTabs" ) ))
        self()->d->shellOpenFileInTabs = v;
}

bool Settings::shellOpenFileInTabs()
{
  return self()->d->shellOpenFileInTabs;
}


void Settings::setShowOSD( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "ShowOSD" ) ))
        self()->d->showOSD = v;
}

bool Settings::showOSD()
{
  return self()->d->showOSD;
}


void Settings::setDisplayDocumentTitle( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "DisplayDocumentTitle" ) ))
        self()->d->displayDocumentTitle = v;
}

bool Settings::displayDocumentTitle()
{
  return self()->d->displayDocumentTitle;
}


void Settings::setDisplayDocumentNameOrPath( int v )
{
      if (!self()->isImmutable( QString::fromLatin1( "DisplayDocumentNameOrPath" ) ))
        self()->d->displayDocumentNameOrPath = v;
}

int Settings::displayDocumentNameOrPath()
{
  return self()->d->displayDocumentNameOrPath;
}


void Settings::setUseKTTSD( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "UseKTTSD" ) ))
        self()->d->useKTTSD = v;
}

bool Settings::useKTTSD()
{
  return self()->d->useKTTSD;
}


void Settings::setWatchFile( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "WatchFile" ) ))
        self()->d->watchFile = v;
}

bool Settings::watchFile()
{
  return self()->d->watchFile;
}


void Settings::setSlidesBackgroundColor( const QColor & v )
{
      if (!self()->isImmutable( QString::fromLatin1( "SlidesBackgroundColor" ) ))
        self()->d->slidesBackgroundColor = v;
}

QColor Settings::slidesBackgroundColor()
{
  return self()->d->slidesBackgroundColor;
}


void Settings::setSlidesTransition( int v )
{
      if (!self()->isImmutable( QString::fromLatin1( "SlidesTransition" ) ))
        self()->d->slidesTransition = v;
}

int Settings::slidesTransition()
{
  return self()->d->slidesTransition;
}


void Settings::setSlidesCursor( int v )
{
      if (!self()->isImmutable( QString::fromLatin1( "SlidesCursor" ) ))
        self()->d->slidesCursor = v;
}

int Settings::slidesCursor()
{
  return self()->d->slidesCursor;
}


void Settings::setSlidesShowProgress( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "SlidesShowProgress" ) ))
        self()->d->slidesShowProgress = v;
}

bool Settings::slidesShowProgress()
{
  return self()->d->slidesShowProgress;
}


void Settings::setSlidesShowSummary( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "SlidesShowSummary" ) ))
        self()->d->slidesShowSummary = v;
}

bool Settings::slidesShowSummary()
{
  return self()->d->slidesShowSummary;
}


void Settings::setSlidesPencilColor( const QColor & v )
{
      if (!self()->isImmutable( QString::fromLatin1( "SlidesPencilColor" ) ))
        self()->d->slidesPencilColor = v;
}

QColor Settings::slidesPencilColor()
{
  return self()->d->slidesPencilColor;
}


void Settings::setSlidesTransitionsEnabled( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "SlidesTransitionsEnabled" ) ))
        self()->d->slidesTransitionsEnabled = v;
}

bool Settings::slidesTransitionsEnabled()
{
  return self()->d->slidesTransitionsEnabled;
}


void Settings::setSlidesScreen( int v )
{
      if (v < -2)
      {
        kDebug() << "setSlidesScreen: value " << v << " is less than the minimum value of -2";
        v = -2;
      }

      if (v > 20)
      {
        kDebug() << "setSlidesScreen: value " << v << " is greater than the maximum value of 20";
        v = 20;
      }

      if (!self()->isImmutable( QString::fromLatin1( "SlidesScreen" ) ))
        self()->d->slidesScreen = v;
}

int Settings::slidesScreen()
{
  return self()->d->slidesScreen;
}


void Settings::setShowLeftPanel( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "ShowLeftPanel" ) ))
        self()->d->showLeftPanel = v;
}

bool Settings::showLeftPanel()
{
  return self()->d->showLeftPanel;
}


void Settings::setSplitterSizes( const QList<int> & v )
{
      if (!self()->isImmutable( QString::fromLatin1( "SplitterSizes" ) ))
        self()->d->splitterSizes = v;
}

QList<int> Settings::splitterSizes()
{
  return self()->d->splitterSizes;
}


void Settings::setShowBottomBar( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "ShowBottomBar" ) ))
        self()->d->showBottomBar = v;
}

bool Settings::showBottomBar()
{
  return self()->d->showBottomBar;
}


void Settings::setCurrentPageOnly( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "CurrentPageOnly" ) ))
        self()->d->currentPageOnly = v;
}

bool Settings::currentPageOnly()
{
  return self()->d->currentPageOnly;
}


void Settings::setGroupByAuthor( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "GroupByAuthor" ) ))
        self()->d->groupByAuthor = v;
}

bool Settings::groupByAuthor()
{
  return self()->d->groupByAuthor;
}


void Settings::setGroupByPage( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "GroupByPage" ) ))
        self()->d->groupByPage = v;
}

bool Settings::groupByPage()
{
  return self()->d->groupByPage;
}


void Settings::setFilterBookmarks( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "FilterBookmarks" ) ))
        self()->d->filterBookmarks = v;
}

bool Settings::filterBookmarks()
{
  return self()->d->filterBookmarks;
}


void Settings::setSyncThumbnailsViewport( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "SyncThumbnailsViewport" ) ))
        self()->d->syncThumbnailsViewport = v;
}

bool Settings::syncThumbnailsViewport()
{
  return self()->d->syncThumbnailsViewport;
}


void Settings::setTocPageColumn( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "TocPageColumn" ) ))
        self()->d->tocPageColumn = v;
}

bool Settings::tocPageColumn()
{
  return self()->d->tocPageColumn;
}


void Settings::setSidebarShowText( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "SidebarShowText" ) ))
        self()->d->sidebarShowText = v;
}

bool Settings::sidebarShowText()
{
  return self()->d->sidebarShowText;
}


void Settings::setSidebarIconSize( uint v )
{
      if (!self()->isImmutable( QString::fromLatin1( "SidebarIconSize" ) ))
        self()->d->sidebarIconSize = v;
}

uint Settings::sidebarIconSize()
{
  return self()->d->sidebarIconSize;
}


void Settings::setEditToolBarPlacement( int v )
{
      if (!self()->isImmutable( QString::fromLatin1( "EditToolBarPlacement" ) ))
        self()->d->editToolBarPlacement = v;
}

int Settings::editToolBarPlacement()
{
  return self()->d->editToolBarPlacement;
}


void Settings::setShowScrollBars( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "ShowScrollBars" ) ))
        self()->d->showScrollBars = v;
}

bool Settings::showScrollBars()
{
  return self()->d->showScrollBars;
}


void Settings::setScrollOverlap( uint v )
{

      if (v > 50)
      {
        kDebug() << "setScrollOverlap: value " << v << " is greater than the maximum value of 50";
        v = 50;
      }

      if (!self()->isImmutable( QString::fromLatin1( "ScrollOverlap" ) ))
        self()->d->scrollOverlap = v;
}

uint Settings::scrollOverlap()
{
  return self()->d->scrollOverlap;
}


void Settings::setViewColumns( uint v )
{
      if (v < 1)
      {
        kDebug() << "setViewColumns: value " << v << " is less than the minimum value of 1";
        v = 1;
      }

      if (v > 8)
      {
        kDebug() << "setViewColumns: value " << v << " is greater than the maximum value of 8";
        v = 8;
      }

      if (!self()->isImmutable( QString::fromLatin1( "ViewColumns" ) ))
        self()->d->viewColumns = v;
}

uint Settings::viewColumns()
{
  return self()->d->viewColumns;
}


void Settings::setTrimMargins( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "TrimMargins" ) ))
        self()->d->trimMargins = v;
}

bool Settings::trimMargins()
{
  return self()->d->trimMargins;
}


void Settings::setViewContinuous( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "ViewContinuous" ) ))
        self()->d->viewContinuous = v;
}

bool Settings::viewContinuous()
{
  return self()->d->viewContinuous;
}


void Settings::setViewMode( int v )
{
      if (!self()->isImmutable( QString::fromLatin1( "ViewMode" ) ))
        self()->d->viewMode = v;
}

int Settings::viewMode()
{
  return self()->d->viewMode;
}


void Settings::setMouseMode( int v )
{
      if (!self()->isImmutable( QString::fromLatin1( "MouseMode" ) ))
        self()->d->mouseMode = v;
}

int Settings::mouseMode()
{
  return self()->d->mouseMode;
}


void Settings::setShowSourceLocationsGraphically( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "ShowSourceLocationsGraphically" ) ))
        self()->d->showSourceLocationsGraphically = v;
}

bool Settings::showSourceLocationsGraphically()
{
  return self()->d->showSourceLocationsGraphically;
}


void Settings::setSearchCaseSensitive( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "SearchCaseSensitive" ) ))
        self()->d->searchCaseSensitive = v;
}

bool Settings::searchCaseSensitive()
{
  return self()->d->searchCaseSensitive;
}


void Settings::setSearchFromCurrentPage( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "SearchFromCurrentPage" ) ))
        self()->d->searchFromCurrentPage = v;
}

bool Settings::searchFromCurrentPage()
{
  return self()->d->searchFromCurrentPage;
}


void Settings::setHighlightImages( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "HighlightImages" ) ))
        self()->d->highlightImages = v;
}

bool Settings::highlightImages()
{
  return self()->d->highlightImages;
}


void Settings::setHighlightLinks( bool v )
{
      if (!self()->isImmutable( QString::fromLatin1( "HighlightLinks" ) ))
        self()->d->highlightLinks = v;
}

bool Settings::highlightLinks()
{
  return self()->d->highlightLinks;
}


void Settings::setRecolorForeground( const QColor & v )
{
      if (!self()->isImmutable( QString::fromLatin1( "RecolorForeground" ) ))
        self()->d->recolorForeground = v;
}

QColor Settings::recolorForeground()
{
  return self()->d->recolorForeground;
}


void Settings::setRecolorBackground( const QColor & v )
{
      if (!self()->isImmutable( QString::fromLatin1( "RecolorBackground" ) ))
        self()->d->recolorBackground = v;
}

QColor Settings::recolorBackground()
{
  return self()->d->recolorBackground;
}


void Settings::setBWThreshold( uint v )
{
      if (v < 2)
      {
        kDebug() << "setBWThreshold: value " << v << " is less than the minimum value of 2";
        v = 2;
      }

      if (v > 253)
      {
        kDebug() << "setBWThreshold: value " << v << " is greater than the maximum value of 253";
        v = 253;
      }

      if (!self()->isImmutable( QString::fromLatin1( "BWThreshold" ) ))
        self()->d->bWThreshold = v;
}

uint Settings::bWThreshold()
{
  return self()->d->bWThreshold;
}


void Settings::setBWContrast( uint v )
{
      if (v < 2)
      {
        kDebug() << "setBWContrast: value " << v << " is less than the minimum value of 2";
        v = 2;
      }

      if (v > 6)
      {
        kDebug() << "setBWContrast: value " << v << " is greater than the maximum value of 6";
        v = 6;
      }

      if (!self()->isImmutable( QString::fromLatin1( "BWContrast" ) ))
        self()->d->bWContrast = v;
}

uint Settings::bWContrast()
{
  return self()->d->bWContrast;
}


void Settings::setIdentityAuthor( const QString & v )
{
      if (!self()->isImmutable( QString::fromLatin1( "IdentityAuthor" ) ))
        self()->d->identityAuthor = v;
}

QString Settings::identityAuthor()
{
  return self()->d->identityAuthor;
}


Settings::~Settings()
{
  delete d;
  if (!s_globalSettings.isDestroyed()) {
    s_globalSettings->q = 0;
  }
}

