#|  Logiweb, a system for electronic distribution of mathematics
    Copyright (C) 2004-2010 Klaus Grue

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Contact: Klaus Grue, DIKU, Universitetsparken 1, DK2100 Copenhagen,
    Denmark, grue@diku.dk, http://logiweb.eu/, http://www.diku.dk/~grue/

    Logiweb is a system for distribution of mathematical definitions,
    lemmas, and proofs. For more on Logiweb, consult http://logiweb.eu/.
|#

#|
=============================================
Logiweb
=============================================
Auxilliary definitions
=============================================
|#

(in-package "COMMON-LISP-USER")

#|
=============================================
Disable particular CLISP warning
=============================================
|#

(defc *WARN-ON-FLOATING-POINT-CONTAGION* nil)

#|
=============================================
Print debug message
=============================================
|#

(defmacro p (msg &rest parm*)
 `(progn
   (format t "print ~a " ',msg)
   ,@(map 'list 'print-parm parm*)
   (format t "~%")))

(deff print-parm (parm)
 `(format t "~a=~a " ',parm ,parm))

#|
=============================================
Unequal
=============================================
|#

(defmacro unequal (x y) `(not (equalp ,x ,y)))

#|
=============================================
Default
=============================================
|#

(deff default (x y)
 (if y y x))

#|
=============================================
Repetition
=============================================
|#

(deff repeat (n item)
 (repeat1 n item nil))

(deff repeat1 (n item result)
 (:when (= n 0) result)
 (repeat1 (- n 1) item (cons item result)))

(ntst (repeat 0 2))
(etst (repeat 1 2) '(2))
(etst (repeat 5 2) '(2 2 2 2 2))

#|
=============================================
Non-destructive sort
=============================================
|#

(deff safe-sort (predicate list)
 (sort (copy-seq list) predicate))

#|
=============================================
Sort and remove duplicates
=============================================
|#

(deff my-remove-duplicates (list)
 (if (null (cdr list)) list
  (if (equalp (first list) (second list)) (my-remove-duplicates (cdr list))
   (cons (car list) (my-remove-duplicates (cdr list))))))

(deff sort-and-remove-duplicates (predicate list)
 (my-remove-duplicates (safe-sort predicate list)))

(etst (sort-and-remove-duplicates '< '(1 3 2 1)) '(1 2 3))

#|
=============================================
Safe subseq
=============================================
|#

(deff safe-subseq (x y &optional z)
 (let* ((length (length x)))
  (if (null z) (subseq x (min y length))
   (subseq x (min y length) (min z length)))))

#|
=============================================
String prefix
=============================================
|#

(deff string-prefix (x y)
 (equalp x (safe-subseq y 0 (length x))))

(ttst (string-prefix "abc" "abcd"))
(ntst (string-prefix "abcd" "abc"))

#|
=============================================
String suffix
=============================================
|#

(deff string-suffix (x y)
 (:let length-x (length x))
 (:let length-y (length y))
 (:when (<debug length-y length-x) nil)
 (equalp x (subseq y (- length-y length-x))))

(ttst (string-suffix "bcd" "abcd"))
(ttst (string-suffix "abcd" "abcd"))
(ntst (string-suffix "abed" "abcd"))
(ntst (string-suffix "abcd" "bcd"))

#|
=============================================
Get suffix
=============================================
|#

(deff suffix (x y)
 (:let length (length x))
 (:when (equalp x (safe-subseq y 0 length)) (subseq y length))
 nil)

(ntst (suffix "abc" "abdef"))
(ntst (suffix "abc" "ab"))
(etst (suffix "abc" "abcdef") "def")
(etst (suffix "abc" "abc") "")

#|
=============================================
Indentation
=============================================
|#

(deff indent (count)
 (:when (> count 50)
  (format t "~5d indent: " count)
  (+ 5 (length " indent: ")))
 (indent1 count)
 count)

(deff indent1 (count)
 (when (> count 0)
  (format t " ")
  (indent1 (- count 1))))

#|
=============================================
Print progress information
=============================================
|#

(deff progress (message)
 (format t "~a~%" message))

#|
=============================================
Limited printing
=============================================
|#

(defmacro limit-print (print-level print-length &rest forms)
`(let* (
   (print-level1 *print-level*)
   (print-length1 *print-length*))
  (setq *print-level* ,print-level)
  (setq *print-length* ,print-length)
  ,@forms
  (setq *print-level* print-level1)
  (setq *print-length* print-length1)))

#|
=============================================
Gensym control
=============================================
Let gen-sym denote gentemp during debugging. Remember to recompile entire program when the macro is changed so that the change takes effect everywhere.

Recompilation may be done thus:
(testload "source" :test nil :compile t :prompt nil)

(intern-sym) executed in $LOGIWEB/lgc makes gensyms external.
(unintern-sym) executed in $LOGIWEB/lgc restores.
|#

(defc *gensym-suffix* "123")

(defmacro gen-sym (prefix) `(gensym ,prefix))
;(defmacro gen-sym (prefix) `(gentemp ,prefix))
;(defmacro gen-sym (prefix) `(intern (cat ,prefix *gensym-suffix*)))

(deff unintern-sym ()
 (defmacro gen-sym (prefix) `(gensym ,prefix))
 (testload "optimize" :test nil :compile t :prompt nil)
 (testload "codify" :test nil :compile t :prompt nil))
(deff intern-sym ()
 (defmacro gen-sym (prefix) `(gentemp ,prefix))
 (testload "optimize" :test nil :compile t :prompt nil)
 (testload "codify" :test nil :compile t :prompt nil))
(deff name-sym (suffix)
 (setq *gensym-suffix* suffix)
 (defmacro gen-sym (prefix) `(intern (cat ,prefix *gensym-suffix*)))
 (testload "optimize" :test nil :compile t :prompt nil)
 (testload "codify" :test nil :compile t :prompt nil))

