/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Subtarget Enumeration Source Fragment                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_SUBTARGETINFO_ENUM
#undef GET_SUBTARGETINFO_ENUM
namespace llvm {
namespace ARM {
enum : uint64_t {
  FeatureAClass = 0,
  FeatureAvoidMOVsShOp = 1,
  FeatureAvoidPartialCPSR = 2,
  FeatureCRC = 3,
  FeatureCrypto = 4,
  FeatureD16 = 5,
  FeatureDB = 6,
  FeatureDSPThumb2 = 7,
  FeatureFP16 = 8,
  FeatureFPARMv8 = 9,
  FeatureHWDiv = 10,
  FeatureHWDivARM = 11,
  FeatureHasRAS = 12,
  FeatureHasSlowFPVMLx = 13,
  FeatureLongCalls = 14,
  FeatureMClass = 15,
  FeatureMP = 16,
  FeatureNEON = 17,
  FeatureNEONForFP = 18,
  FeatureNaClTrap = 19,
  FeatureNoARM = 20,
  FeaturePerfMon = 21,
  FeaturePref32BitThumb = 22,
  FeatureRClass = 23,
  FeatureSlowFPBrcc = 24,
  FeatureT2XtPk = 25,
  FeatureThumb2 = 26,
  FeatureTrustZone = 27,
  FeatureVFP2 = 28,
  FeatureVFP3 = 29,
  FeatureVFP4 = 30,
  FeatureVFPOnlySP = 31,
  FeatureVMLxForwarding = 32,
  FeatureVirtualization = 33,
  FeatureZCZeroing = 34,
  HasV4TOps = 35,
  HasV5TEOps = 36,
  HasV5TOps = 37,
  HasV6KOps = 38,
  HasV6MOps = 39,
  HasV6Ops = 40,
  HasV6T2Ops = 41,
  HasV7Ops = 42,
  HasV8Ops = 43,
  HasV8_1aOps = 44,
  ModeSoftFloat = 45,
  ModeThumb = 46,
  ProcA5 = 47,
  ProcA7 = 48,
  ProcA8 = 49,
  ProcA9 = 50,
  ProcA12 = 51,
  ProcA15 = 52,
  ProcA17 = 53,
  ProcA53 = 54,
  ProcA57 = 55,
  ProcKrait = 56,
  ProcR4 = 57,
  ProcR5 = 58,
  ProcSwift = 59
};
}
} // End llvm namespace 
#endif // GET_SUBTARGETINFO_ENUM


#ifdef GET_SUBTARGETINFO_MC_DESC
#undef GET_SUBTARGETINFO_MC_DESC
namespace llvm {
// Sorted (by key) array of values for CPU features.
extern const llvm::SubtargetFeatureKV ARMFeatureKV[] = {
  { "32bit", "Prefer 32-bit Thumb instrs", { ARM::FeaturePref32BitThumb }, { } },
  { "a12", "Cortex-A12 ARM processors", { ARM::ProcA12 }, { ARM::FeatureVMLxForwarding, ARM::FeatureT2XtPk, ARM::FeatureVFP4, ARM::FeatureHWDiv, ARM::FeatureHWDivARM, ARM::FeatureAvoidPartialCPSR, ARM::FeatureVirtualization, ARM::FeatureTrustZone } },
  { "a15", "Cortex-A15 ARM processors", { ARM::ProcA15 }, { ARM::FeatureT2XtPk, ARM::FeatureVFP4, ARM::FeatureMP, ARM::FeatureHWDiv, ARM::FeatureHWDivARM, ARM::FeatureAvoidPartialCPSR, ARM::FeatureTrustZone, ARM::FeatureVirtualization } },
  { "a17", "Cortex-A17 ARM processors", { ARM::ProcA17 }, { ARM::FeatureVMLxForwarding, ARM::FeatureT2XtPk, ARM::FeatureVFP4, ARM::FeatureHWDiv, ARM::FeatureHWDivARM, ARM::FeatureAvoidPartialCPSR, ARM::FeatureVirtualization, ARM::FeatureTrustZone } },
  { "a5", "Cortex-A5 ARM processors", { ARM::ProcA5 }, { ARM::FeatureSlowFPBrcc, ARM::FeatureHasSlowFPVMLx, ARM::FeatureVMLxForwarding, ARM::FeatureT2XtPk, ARM::FeatureTrustZone, ARM::FeatureMP } },
  { "a53", "Cortex-A53 ARM processors", { ARM::ProcA53 }, { ARM::FeatureHWDiv, ARM::FeatureHWDivARM, ARM::FeatureTrustZone, ARM::FeatureT2XtPk, ARM::FeatureCrypto, ARM::FeatureCRC } },
  { "a57", "Cortex-A57 ARM processors", { ARM::ProcA57 }, { ARM::FeatureHWDiv, ARM::FeatureHWDivARM, ARM::FeatureTrustZone, ARM::FeatureT2XtPk, ARM::FeatureCrypto, ARM::FeatureCRC } },
  { "a7", "Cortex-A7 ARM processors", { ARM::ProcA7 }, { ARM::FeatureSlowFPBrcc, ARM::FeatureHasSlowFPVMLx, ARM::FeatureVMLxForwarding, ARM::FeatureT2XtPk, ARM::FeatureVFP4, ARM::FeatureMP, ARM::FeatureHWDiv, ARM::FeatureHWDivARM, ARM::FeatureTrustZone, ARM::FeatureVirtualization } },
  { "a8", "Cortex-A8 ARM processors", { ARM::ProcA8 }, { ARM::FeatureSlowFPBrcc, ARM::FeatureHasSlowFPVMLx, ARM::FeatureVMLxForwarding, ARM::FeatureT2XtPk, ARM::FeatureTrustZone } },
  { "a9", "Cortex-A9 ARM processors", { ARM::ProcA9 }, { ARM::FeatureVMLxForwarding, ARM::FeatureT2XtPk, ARM::FeatureFP16, ARM::FeatureAvoidPartialCPSR, ARM::FeatureTrustZone } },
  { "aclass", "Is application profile ('A' series)", { ARM::FeatureAClass }, { } },
  { "avoid-movs-shop", "Avoid movs instructions with shifter operand", { ARM::FeatureAvoidMOVsShOp }, { } },
  { "avoid-partial-cpsr", "Avoid CPSR partial update for OOO execution", { ARM::FeatureAvoidPartialCPSR }, { } },
  { "crc", "Enable support for CRC instructions", { ARM::FeatureCRC }, { } },
  { "crypto", "Enable support for Cryptography extensions", { ARM::FeatureCrypto }, { ARM::FeatureNEON } },
  { "d16", "Restrict VFP3 to 16 double registers", { ARM::FeatureD16 }, { } },
  { "db", "Has data barrier (dmb / dsb) instructions", { ARM::FeatureDB }, { } },
  { "fp-armv8", "Enable ARMv8 FP", { ARM::FeatureFPARMv8 }, { ARM::FeatureVFP4 } },
  { "fp-only-sp", "Floating point unit supports single precision only", { ARM::FeatureVFPOnlySP }, { } },
  { "fp16", "Enable half-precision floating point", { ARM::FeatureFP16 }, { } },
  { "hwdiv", "Enable divide instructions", { ARM::FeatureHWDiv }, { } },
  { "hwdiv-arm", "Enable divide instructions in ARM mode", { ARM::FeatureHWDivARM }, { } },
  { "krait", "Qualcomm ARM processors", { ARM::ProcKrait }, { ARM::FeatureVMLxForwarding, ARM::FeatureT2XtPk, ARM::FeatureFP16, ARM::FeatureAvoidPartialCPSR, ARM::FeatureTrustZone, ARM::FeatureVFP4, ARM::FeatureHWDiv, ARM::FeatureHWDivARM } },
  { "long-calls", "Generate calls via indirect call instructions", { ARM::FeatureLongCalls }, { } },
  { "mclass", "Is microcontroller profile ('M' series)", { ARM::FeatureMClass }, { } },
  { "mp", "Supports Multiprocessing extension", { ARM::FeatureMP }, { } },
  { "nacl-trap", "NaCl trap", { ARM::FeatureNaClTrap }, { } },
  { "neon", "Enable NEON instructions", { ARM::FeatureNEON }, { ARM::FeatureVFP3 } },
  { "neonfp", "Use NEON for single precision FP", { ARM::FeatureNEONForFP }, { } },
  { "noarm", "Does not support ARM mode execution", { ARM::FeatureNoARM }, { ARM::ModeThumb } },
  { "perfmon", "Enable support for Performance Monitor extensions", { ARM::FeaturePerfMon }, { } },
  { "r4", "Cortex-R4 ARM processors", { ARM::ProcR4 }, { ARM::FeatureHWDiv, ARM::FeatureAvoidPartialCPSR, ARM::FeatureDSPThumb2, ARM::FeatureT2XtPk, ARM::HasV7Ops, ARM::FeatureDB, ARM::FeatureHasRAS, ARM::FeatureRClass } },
  { "r5", "Cortex-R5 ARM processors", { ARM::ProcR5 }, { ARM::FeatureSlowFPBrcc, ARM::FeatureHWDiv, ARM::FeatureHWDivARM, ARM::FeatureHasSlowFPVMLx, ARM::FeatureAvoidPartialCPSR, ARM::FeatureT2XtPk } },
  { "ras", "Has return address stack", { ARM::FeatureHasRAS }, { } },
  { "rclass", "Is realtime profile ('R' series)", { ARM::FeatureRClass }, { } },
  { "slow-fp-brcc", "FP compare + branch is slow", { ARM::FeatureSlowFPBrcc }, { } },
  { "slowfpvmlx", "Disable VFP / NEON MAC instructions", { ARM::FeatureHasSlowFPVMLx }, { } },
  { "soft-float", "Use software floating point features.", { ARM::ModeSoftFloat }, { } },
  { "swift", "Swift ARM processors", { ARM::ProcSwift }, { ARM::FeatureNEONForFP, ARM::FeatureT2XtPk, ARM::FeatureVFP4, ARM::FeatureMP, ARM::FeatureHWDiv, ARM::FeatureHWDivARM, ARM::FeatureAvoidPartialCPSR, ARM::FeatureAvoidMOVsShOp, ARM::FeatureHasSlowFPVMLx, ARM::FeatureTrustZone } },
  { "t2dsp", "Supports v7 DSP instructions in Thumb2", { ARM::FeatureDSPThumb2 }, { } },
  { "t2xtpk", "Enable Thumb2 extract and pack instructions", { ARM::FeatureT2XtPk }, { } },
  { "thumb-mode", "Thumb mode", { ARM::ModeThumb }, { } },
  { "thumb2", "Enable Thumb2 instructions", { ARM::FeatureThumb2 }, { } },
  { "trustzone", "Enable support for TrustZone security extensions", { ARM::FeatureTrustZone }, { } },
  { "v4t", "Support ARM v4T instructions", { ARM::HasV4TOps }, { } },
  { "v5t", "Support ARM v5T instructions", { ARM::HasV5TOps }, { ARM::HasV4TOps } },
  { "v5te", "Support ARM v5TE, v5TEj, and v5TExp instructions", { ARM::HasV5TEOps }, { ARM::HasV5TOps } },
  { "v6", "Support ARM v6 instructions", { ARM::HasV6Ops }, { ARM::HasV5TEOps } },
  { "v6k", "Support ARM v6k instructions", { ARM::HasV6KOps }, { ARM::HasV6Ops } },
  { "v6m", "Support ARM v6M instructions", { ARM::HasV6MOps }, { ARM::HasV6Ops } },
  { "v6t2", "Support ARM v6t2 instructions", { ARM::HasV6T2Ops }, { ARM::HasV6MOps, ARM::HasV6KOps, ARM::FeatureThumb2 } },
  { "v7", "Support ARM v7 instructions", { ARM::HasV7Ops }, { ARM::HasV6T2Ops, ARM::FeaturePerfMon } },
  { "v8", "Support ARM v8 instructions", { ARM::HasV8Ops }, { ARM::HasV7Ops, ARM::FeatureVirtualization, ARM::FeatureMP } },
  { "v8.1a", "Support ARM v8.1a instructions", { ARM::HasV8_1aOps }, { ARM::HasV8Ops, ARM::FeatureAClass, ARM::FeatureCRC } },
  { "vfp2", "Enable VFP2 instructions", { ARM::FeatureVFP2 }, { } },
  { "vfp3", "Enable VFP3 instructions", { ARM::FeatureVFP3 }, { ARM::FeatureVFP2 } },
  { "vfp4", "Enable VFP4 instructions", { ARM::FeatureVFP4 }, { ARM::FeatureVFP3, ARM::FeatureFP16 } },
  { "virtualization", "Supports Virtualization extension", { ARM::FeatureVirtualization }, { ARM::FeatureHWDiv, ARM::FeatureHWDivARM } },
  { "vmlx-forwarding", "Has multiplier accumulator forwarding", { ARM::FeatureVMLxForwarding }, { } },
  { "zcz", "Has zero-cycle zeroing instructions", { ARM::FeatureZCZeroing }, { } }
};

// Sorted (by key) array of values for CPU subtype.
extern const llvm::SubtargetFeatureKV ARMSubTypeKV[] = {
  { "arm1020e", "Select the arm1020e processor", { ARM::HasV5TEOps }, { } },
  { "arm1020t", "Select the arm1020t processor", { ARM::HasV5TOps }, { } },
  { "arm1022e", "Select the arm1022e processor", { ARM::HasV5TEOps }, { } },
  { "arm10e", "Select the arm10e processor", { ARM::HasV5TEOps }, { } },
  { "arm10tdmi", "Select the arm10tdmi processor", { ARM::HasV5TOps }, { } },
  { "arm1136j-s", "Select the arm1136j-s processor", { ARM::HasV6Ops }, { } },
  { "arm1136jf-s", "Select the arm1136jf-s processor", { ARM::HasV6Ops, ARM::FeatureVFP2, ARM::FeatureHasSlowFPVMLx }, { } },
  { "arm1156t2-s", "Select the arm1156t2-s processor", { ARM::HasV6T2Ops, ARM::FeatureDSPThumb2 }, { } },
  { "arm1156t2f-s", "Select the arm1156t2f-s processor", { ARM::HasV6T2Ops, ARM::FeatureVFP2, ARM::FeatureHasSlowFPVMLx, ARM::FeatureDSPThumb2 }, { } },
  { "arm1176jz-s", "Select the arm1176jz-s processor", { ARM::HasV6KOps }, { } },
  { "arm1176jzf-s", "Select the arm1176jzf-s processor", { ARM::HasV6KOps, ARM::FeatureVFP2, ARM::FeatureHasSlowFPVMLx }, { } },
  { "arm710t", "Select the arm710t processor", { ARM::HasV4TOps }, { } },
  { "arm720t", "Select the arm720t processor", { ARM::HasV4TOps }, { } },
  { "arm7tdmi", "Select the arm7tdmi processor", { ARM::HasV4TOps }, { } },
  { "arm7tdmi-s", "Select the arm7tdmi-s processor", { ARM::HasV4TOps }, { } },
  { "arm8", "Select the arm8 processor", { }, { } },
  { "arm810", "Select the arm810 processor", { }, { } },
  { "arm9", "Select the arm9 processor", { ARM::HasV4TOps }, { } },
  { "arm920", "Select the arm920 processor", { ARM::HasV4TOps }, { } },
  { "arm920t", "Select the arm920t processor", { ARM::HasV4TOps }, { } },
  { "arm922t", "Select the arm922t processor", { ARM::HasV4TOps }, { } },
  { "arm926ej-s", "Select the arm926ej-s processor", { ARM::HasV5TEOps }, { } },
  { "arm940t", "Select the arm940t processor", { ARM::HasV4TOps }, { } },
  { "arm946e-s", "Select the arm946e-s processor", { ARM::HasV5TEOps }, { } },
  { "arm966e-s", "Select the arm966e-s processor", { ARM::HasV5TEOps }, { } },
  { "arm968e-s", "Select the arm968e-s processor", { ARM::HasV5TEOps }, { } },
  { "arm9e", "Select the arm9e processor", { ARM::HasV5TEOps }, { } },
  { "arm9tdmi", "Select the arm9tdmi processor", { ARM::HasV4TOps }, { } },
  { "cortex-a12", "Select the cortex-a12 processor", { ARM::ProcA12, ARM::HasV7Ops, ARM::FeatureNEON, ARM::FeatureDB, ARM::FeatureDSPThumb2, ARM::FeatureMP, ARM::FeatureHasRAS, ARM::FeatureAClass }, { } },
  { "cortex-a15", "Select the cortex-a15 processor", { ARM::ProcA15, ARM::HasV7Ops, ARM::FeatureNEON, ARM::FeatureDB, ARM::FeatureDSPThumb2, ARM::FeatureHasRAS, ARM::FeatureAClass }, { } },
  { "cortex-a17", "Select the cortex-a17 processor", { ARM::ProcA17, ARM::HasV7Ops, ARM::FeatureNEON, ARM::FeatureDB, ARM::FeatureDSPThumb2, ARM::FeatureMP, ARM::FeatureHasRAS, ARM::FeatureAClass }, { } },
  { "cortex-a5", "Select the cortex-a5 processor", { ARM::ProcA5, ARM::HasV7Ops, ARM::FeatureNEON, ARM::FeatureDB, ARM::FeatureVFP4, ARM::FeatureDSPThumb2, ARM::FeatureHasRAS, ARM::FeatureAClass }, { } },
  { "cortex-a53", "Select the cortex-a53 processor", { ARM::ProcA53, ARM::HasV8Ops, ARM::FeatureAClass, ARM::FeatureDB, ARM::FeatureFPARMv8, ARM::FeatureNEON, ARM::FeatureDSPThumb2 }, { } },
  { "cortex-a57", "Select the cortex-a57 processor", { ARM::ProcA57, ARM::HasV8Ops, ARM::FeatureAClass, ARM::FeatureDB, ARM::FeatureFPARMv8, ARM::FeatureNEON, ARM::FeatureDSPThumb2 }, { } },
  { "cortex-a7", "Select the cortex-a7 processor", { ARM::ProcA7, ARM::HasV7Ops, ARM::FeatureNEON, ARM::FeatureDB, ARM::FeatureDSPThumb2, ARM::FeatureHasRAS, ARM::FeatureAClass }, { } },
  { "cortex-a72", "Select the cortex-a72 processor", { ARM::ProcA57, ARM::HasV8Ops, ARM::FeatureAClass, ARM::FeatureDB, ARM::FeatureFPARMv8, ARM::FeatureNEON, ARM::FeatureDSPThumb2 }, { } },
  { "cortex-a8", "Select the cortex-a8 processor", { ARM::ProcA8, ARM::HasV7Ops, ARM::FeatureNEON, ARM::FeatureDB, ARM::FeatureDSPThumb2, ARM::FeatureHasRAS, ARM::FeatureAClass }, { } },
  { "cortex-a9", "Select the cortex-a9 processor", { ARM::ProcA9, ARM::HasV7Ops, ARM::FeatureNEON, ARM::FeatureDB, ARM::FeatureDSPThumb2, ARM::FeatureHasRAS, ARM::FeatureMP, ARM::FeatureAClass }, { } },
  { "cortex-m0", "Select the cortex-m0 processor", { ARM::HasV6MOps, ARM::FeatureNoARM, ARM::FeatureDB, ARM::FeatureMClass }, { } },
  { "cortex-m0plus", "Select the cortex-m0plus processor", { ARM::HasV6MOps, ARM::FeatureNoARM, ARM::FeatureDB, ARM::FeatureMClass }, { } },
  { "cortex-m1", "Select the cortex-m1 processor", { ARM::HasV6MOps, ARM::FeatureNoARM, ARM::FeatureDB, ARM::FeatureMClass }, { } },
  { "cortex-m3", "Select the cortex-m3 processor", { ARM::HasV7Ops, ARM::FeatureThumb2, ARM::FeatureNoARM, ARM::FeatureDB, ARM::FeatureHWDiv, ARM::FeatureMClass }, { } },
  { "cortex-m4", "Select the cortex-m4 processor", { ARM::HasV7Ops, ARM::FeatureThumb2, ARM::FeatureNoARM, ARM::FeatureDB, ARM::FeatureHWDiv, ARM::FeatureDSPThumb2, ARM::FeatureT2XtPk, ARM::FeatureVFP4, ARM::FeatureVFPOnlySP, ARM::FeatureD16, ARM::FeatureMClass }, { } },
  { "cortex-m7", "Select the cortex-m7 processor", { ARM::HasV7Ops, ARM::FeatureThumb2, ARM::FeatureNoARM, ARM::FeatureDB, ARM::FeatureHWDiv, ARM::FeatureDSPThumb2, ARM::FeatureT2XtPk, ARM::FeatureFPARMv8, ARM::FeatureD16, ARM::FeatureMClass }, { } },
  { "cortex-r4", "Select the cortex-r4 processor", { ARM::ProcR4 }, { } },
  { "cortex-r4f", "Select the cortex-r4f processor", { ARM::ProcR4, ARM::FeatureSlowFPBrcc, ARM::FeatureHasSlowFPVMLx, ARM::FeatureVFP3, ARM::FeatureD16 }, { } },
  { "cortex-r5", "Select the cortex-r5 processor", { ARM::ProcR5, ARM::HasV7Ops, ARM::FeatureDB, ARM::FeatureVFP3, ARM::FeatureDSPThumb2, ARM::FeatureHasRAS, ARM::FeatureD16, ARM::FeatureRClass }, { } },
  { "cortex-r7", "Select the cortex-r7 processor", { ARM::ProcR5, ARM::HasV7Ops, ARM::FeatureDB, ARM::FeatureVFP3, ARM::FeatureDSPThumb2, ARM::FeatureHasRAS, ARM::FeatureVFPOnlySP, ARM::FeatureD16, ARM::FeatureMP, ARM::FeatureRClass }, { } },
  { "cyclone", "Select the cyclone processor", { ARM::ProcSwift, ARM::HasV8Ops, ARM::HasV7Ops, ARM::FeatureCrypto, ARM::FeatureFPARMv8, ARM::FeatureDB, ARM::FeatureDSPThumb2, ARM::FeatureHasRAS, ARM::FeatureZCZeroing }, { } },
  { "ep9312", "Select the ep9312 processor", { ARM::HasV4TOps }, { } },
  { "generic", "Select the generic processor", { }, { } },
  { "iwmmxt", "Select the iwmmxt processor", { ARM::HasV5TEOps }, { } },
  { "krait", "Select the krait processor", { ARM::ProcKrait, ARM::HasV7Ops, ARM::FeatureNEON, ARM::FeatureDB, ARM::FeatureDSPThumb2, ARM::FeatureHasRAS, ARM::FeatureAClass }, { } },
  { "mpcore", "Select the mpcore processor", { ARM::HasV6KOps, ARM::FeatureVFP2, ARM::FeatureHasSlowFPVMLx }, { } },
  { "mpcorenovfp", "Select the mpcorenovfp processor", { ARM::HasV6KOps }, { } },
  { "sc000", "Select the sc000 processor", { ARM::HasV6MOps, ARM::FeatureNoARM, ARM::FeatureDB, ARM::FeatureMClass }, { } },
  { "sc300", "Select the sc300 processor", { ARM::HasV7Ops, ARM::FeatureThumb2, ARM::FeatureNoARM, ARM::FeatureDB, ARM::FeatureHWDiv, ARM::FeatureMClass }, { } },
  { "strongarm", "Select the strongarm processor", { }, { } },
  { "strongarm110", "Select the strongarm110 processor", { }, { } },
  { "strongarm1100", "Select the strongarm1100 processor", { }, { } },
  { "strongarm1110", "Select the strongarm1110 processor", { }, { } },
  { "swift", "Select the swift processor", { ARM::ProcSwift, ARM::HasV7Ops, ARM::FeatureNEON, ARM::FeatureDB, ARM::FeatureDSPThumb2, ARM::FeatureHasRAS, ARM::FeatureAClass }, { } },
  { "xscale", "Select the xscale processor", { ARM::HasV5TEOps }, { } }
};

#ifdef DBGFIELD
#error "<target>GenSubtargetInfo.inc requires a DBGFIELD macro"
#endif
#ifndef NDEBUG
#define DBGFIELD(x) x,
#else
#define DBGFIELD(x)
#endif

// Functional units for "ARMV6Itineraries"
namespace ARMV6ItinerariesFU {
  const unsigned V6_Pipe = 1 << 0;
}

// Functional units for "CortexA9Itineraries"
namespace CortexA9ItinerariesFU {
  const unsigned A9_Issue0 = 1 << 0;
  const unsigned A9_Issue1 = 1 << 1;
  const unsigned A9_Branch = 1 << 2;
  const unsigned A9_ALU0 = 1 << 3;
  const unsigned A9_ALU1 = 1 << 4;
  const unsigned A9_AGU = 1 << 5;
  const unsigned A9_NPipe = 1 << 6;
  const unsigned A9_MUX0 = 1 << 7;
  const unsigned A9_LSUnit = 1 << 8;
  const unsigned A9_DRegsVFP = 1 << 9;
  const unsigned A9_DRegsN = 1 << 10;
}

// Pipeline forwarding pathes for itineraries "CortexA9Itineraries"
namespace CortexA9ItinerariesBypass {
  const unsigned NoBypass = 0;
  const unsigned A9_LdBypass = 1 << 0;
}

// Functional units for "CortexA8Itineraries"
namespace CortexA8ItinerariesFU {
  const unsigned A8_Pipe0 = 1 << 0;
  const unsigned A8_Pipe1 = 1 << 1;
  const unsigned A8_LSPipe = 1 << 2;
  const unsigned A8_NPipe = 1 << 3;
  const unsigned A8_NLSPipe = 1 << 4;
}

// Functional units for "SwiftItineraries"
namespace SwiftItinerariesFU {
  const unsigned SW_DIS0 = 1 << 0;
  const unsigned SW_DIS1 = 1 << 1;
  const unsigned SW_DIS2 = 1 << 2;
  const unsigned SW_ALU0 = 1 << 3;
  const unsigned SW_ALU1 = 1 << 4;
  const unsigned SW_LS = 1 << 5;
  const unsigned SW_IDIV = 1 << 6;
  const unsigned SW_FDIV = 1 << 7;
}

extern const llvm::InstrStage ARMStages[] = {
  { 0, 0, 0, llvm::InstrStage::Required }, // No itinerary
  { 1, ARMV6ItinerariesFU::V6_Pipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 1
  { 2, ARMV6ItinerariesFU::V6_Pipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 2
  { 3, ARMV6ItinerariesFU::V6_Pipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 3
  { 3, ARMV6ItinerariesFU::V6_Pipe, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, ARMV6ItinerariesFU::V6_Pipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 4-5
  { 1, ARMV6ItinerariesFU::V6_Pipe, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, ARMV6ItinerariesFU::V6_Pipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 6-7
  { 1, ARMV6ItinerariesFU::V6_Pipe, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, ARMV6ItinerariesFU::V6_Pipe, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, ARMV6ItinerariesFU::V6_Pipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 8-10
  { 29, ARMV6ItinerariesFU::V6_Pipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 11
  { 15, ARMV6ItinerariesFU::V6_Pipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 12
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_ALU0 | CortexA9ItinerariesFU::A9_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 13-14
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, CortexA9ItinerariesFU::A9_ALU0 | CortexA9ItinerariesFU::A9_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 15-16
  { 1, CortexA9ItinerariesFU::A9_Issue0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_Branch, -1, (llvm::InstrStage::ReservationKinds)0 }, // 17-19
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_ALU0 | CortexA9ItinerariesFU::A9_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 20-21
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)1 },   { 1, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 22-26
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)1 },   { 1, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 27-31
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_AGU, 1, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 32-35
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_AGU, 1, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_Branch, -1, (llvm::InstrStage::ReservationKinds)0 }, // 36-40
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_AGU, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 41-44
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_AGU, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 45-48
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_AGU, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_ALU0 | CortexA9ItinerariesFU::A9_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 49-53
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_AGU, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_LSUnit, 0, (llvm::InstrStage::ReservationKinds)0 }, // 54-57
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_ALU0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 58-59
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_ALU0 | CortexA9ItinerariesFU::A9_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_ALU0 | CortexA9ItinerariesFU::A9_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 60-63
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_ALU0 | CortexA9ItinerariesFU::A9_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_ALU0 | CortexA9ItinerariesFU::A9_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_ALU0 | CortexA9ItinerariesFU::A9_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 64-67
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_ALU0 | CortexA9ItinerariesFU::A9_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_ALU0 | CortexA9ItinerariesFU::A9_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_AGU, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 68-73
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_ALU0 | CortexA9ItinerariesFU::A9_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_ALU0 | CortexA9ItinerariesFU::A9_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 74-76
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_AGU, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 77-80
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 81
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, CortexA9ItinerariesFU::A9_ALU0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 82-83
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_AGU, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 84-87
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 7, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 1, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 88-92
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 7, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 2, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 93-97
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 8, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 2, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 98-102
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)0 },   { 5, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)1 },   { 1, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 103-107
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)0 },   { 26, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)1 },   { 20, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 108-112
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)0 },   { 16, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)1 },   { 10, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 113-117
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 1, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 118-122
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)0 },   { 10, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)1 },   { 2, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 123-127
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)0 },   { 9, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)1 },   { 1, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 128-132
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 10, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 4, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 133-137
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 7, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 1, CortexA9ItinerariesFU::A9_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 138-143
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 8, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 2, CortexA9ItinerariesFU::A9_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 144-149
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 9, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 3, CortexA9ItinerariesFU::A9_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 150-155
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 11, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 5, CortexA9ItinerariesFU::A9_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 5, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 156-161
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 10, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 4, CortexA9ItinerariesFU::A9_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 4, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 162-167
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)1 },   { 1, CortexA9ItinerariesFU::A9_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 168-173
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)1 },   { 1, CortexA9ItinerariesFU::A9_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 174-179
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 }, // 180-181
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)0 },   { 7, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)1 },   { 2, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 182-186
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)0 },   { 6, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)1 },   { 1, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 187-191
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 8, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 1, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 192-196
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 11, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 1, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 197-201
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 12, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 2, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 202-206
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 4, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 2, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 207-211
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)0 },   { 33, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)1 },   { 28, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 212-216
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)0 },   { 18, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)1 },   { 13, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 217-221
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 1, CortexA9ItinerariesFU::A9_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 222-227
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 2, CortexA9ItinerariesFU::A9_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 228-233
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 3, CortexA9ItinerariesFU::A9_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 }, // 234-239
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 8, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 2, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 240-244
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 9, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 3, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 245-249
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 9, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 3, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 250-254
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_DRegsN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 9, CortexA9ItinerariesFU::A9_DRegsVFP, 0, (llvm::InstrStage::ReservationKinds)1 },   { 2, CortexA9ItinerariesFU::A9_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 255-259
  { 1, CortexA9ItinerariesFU::A9_Issue0 | CortexA9ItinerariesFU::A9_Issue1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_MUX0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_AGU, 1, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA9ItinerariesFU::A9_LSUnit, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA9ItinerariesFU::A9_Branch, -1, (llvm::InstrStage::ReservationKinds)0 }, // 260-264
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 265
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 4, CortexA8ItinerariesFU::A8_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 4, CortexA8ItinerariesFU::A8_NLSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 266-268
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 269-270
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_NLSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 271-272
  { 2, CortexA8ItinerariesFU::A8_Pipe0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 273-274
  { 3, CortexA8ItinerariesFU::A8_Pipe0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 275-276
  { 3, CortexA8ItinerariesFU::A8_Pipe0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 277-279
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 280-281
  { 2, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 282-283
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 284-286
  { 2, CortexA8ItinerariesFU::A8_Pipe0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 287
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 288-289
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 290-292
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 293-295
  { 3, CortexA8ItinerariesFU::A8_Pipe0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 296
  { 1, CortexA8ItinerariesFU::A8_Pipe0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 297
  { 2, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 298-299
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA8ItinerariesFU::A8_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 300-301
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 9, CortexA8ItinerariesFU::A8_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 9, CortexA8ItinerariesFU::A8_NLSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 302-304
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 5, CortexA8ItinerariesFU::A8_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 5, CortexA8ItinerariesFU::A8_NLSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 305-307
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 7, CortexA8ItinerariesFU::A8_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 7, CortexA8ItinerariesFU::A8_NLSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 308-310
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 29, CortexA8ItinerariesFU::A8_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 29, CortexA8ItinerariesFU::A8_NLSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 311-313
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 20, CortexA8ItinerariesFU::A8_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 20, CortexA8ItinerariesFU::A8_NLSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 314-316
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA8ItinerariesFU::A8_NLSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 317-318
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 19, CortexA8ItinerariesFU::A8_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 19, CortexA8ItinerariesFU::A8_NLSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 319-321
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA8ItinerariesFU::A8_NLSPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 322-324
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 3, CortexA8ItinerariesFU::A8_NLSPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 325-327
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA8ItinerariesFU::A8_NLSPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 328-330
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, CortexA8ItinerariesFU::A8_NLSPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 331-333
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 5, CortexA8ItinerariesFU::A8_NLSPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 5, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 334-336
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 4, CortexA8ItinerariesFU::A8_NLSPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 4, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 337-339
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_NLSPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_NLSPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 340-344
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_NLSPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_LSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 345-347
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA8ItinerariesFU::A8_NLSPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, CortexA8ItinerariesFU::A8_NPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 348-351
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 11, CortexA8ItinerariesFU::A8_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 11, CortexA8ItinerariesFU::A8_NLSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 352-354
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 8, CortexA8ItinerariesFU::A8_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 8, CortexA8ItinerariesFU::A8_NLSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 355-357
  { 1, CortexA8ItinerariesFU::A8_Pipe0 | CortexA8ItinerariesFU::A8_Pipe1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_NLSPipe, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, CortexA8ItinerariesFU::A8_NPipe, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, CortexA8ItinerariesFU::A8_NLSPipe, -1, (llvm::InstrStage::ReservationKinds)0 }, // 358-361
  { 1, SwiftItinerariesFU::SW_DIS0 | SwiftItinerariesFU::SW_DIS1 | SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 362-363
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 }, // 364
  { 1, SwiftItinerariesFU::SW_DIS0 | SwiftItinerariesFU::SW_DIS1 | SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 365-366
  { 1, SwiftItinerariesFU::SW_DIS0 | SwiftItinerariesFU::SW_DIS1 | SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 367-368
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, -1, (llvm::InstrStage::ReservationKinds)0 }, // 369-373
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, 3, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 374-379
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, -1, (llvm::InstrStage::ReservationKinds)0 }, // 380-383
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, -1, (llvm::InstrStage::ReservationKinds)0 }, // 384-387
  { 1, SwiftItinerariesFU::SW_DIS0 | SwiftItinerariesFU::SW_DIS1 | SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, -1, (llvm::InstrStage::ReservationKinds)0 }, // 388-389
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, 2, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, -1, (llvm::InstrStage::ReservationKinds)0 }, // 390-393
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, 3, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 394-399
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, 3, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 400-406
  { 1, SwiftItinerariesFU::SW_DIS0 | SwiftItinerariesFU::SW_DIS1 | SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, 3, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 407-409
  { 1, SwiftItinerariesFU::SW_DIS0 | SwiftItinerariesFU::SW_DIS1 | SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS0 | SwiftItinerariesFU::SW_DIS1 | SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 410-413
  { 1, SwiftItinerariesFU::SW_DIS0 | SwiftItinerariesFU::SW_DIS1 | SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 414-417
  { 1, SwiftItinerariesFU::SW_DIS0 | SwiftItinerariesFU::SW_DIS1 | SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, -1, (llvm::InstrStage::ReservationKinds)0 }, // 418-421
  { 1, SwiftItinerariesFU::SW_DIS0 | SwiftItinerariesFU::SW_DIS1 | SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 14, SwiftItinerariesFU::SW_IDIV, -1, (llvm::InstrStage::ReservationKinds)0 }, // 422-424
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, 3, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 425-431
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0, 3, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 432-437
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, -1, (llvm::InstrStage::ReservationKinds)0 }, // 438-446
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, -1, (llvm::InstrStage::ReservationKinds)0 }, // 447-452
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU1, 4, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 453-456
  { 1, SwiftItinerariesFU::SW_DIS0 | SwiftItinerariesFU::SW_DIS1 | SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 457-458
  { 1, SwiftItinerariesFU::SW_DIS0 | SwiftItinerariesFU::SW_DIS1 | SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 30, SwiftItinerariesFU::SW_FDIV, -1, (llvm::InstrStage::ReservationKinds)0 }, // 459-461
  { 1, SwiftItinerariesFU::SW_DIS0 | SwiftItinerariesFU::SW_DIS1 | SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 15, SwiftItinerariesFU::SW_FDIV, -1, (llvm::InstrStage::ReservationKinds)0 }, // 462-464
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, 4, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 465-468
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, 4, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU0 | SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 469-472
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, 3, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, -1, (llvm::InstrStage::ReservationKinds)0 }, // 473-476
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU1, 2, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 477-480
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU1, 2, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU1, 2, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 481-486
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU1, 2, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU1, 2, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU1, 2, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_ALU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 487-493
  { 1, SwiftItinerariesFU::SW_DIS0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, SwiftItinerariesFU::SW_LS, -1, (llvm::InstrStage::ReservationKinds)0 }, // 494-497
  { 0, 0, 0, llvm::InstrStage::Required } // End stages
};
extern const unsigned ARMOperandCycles[] = {
  0, // No itinerary
  2,   2, // 1-2
  2,   2,   2, // 3-5
  3,   3,   2,   1, // 6-9
  3,   3,   2,   1, // 10-13
  3,   3,   2,   1, // 14-17
  2,   2, // 18-19
  2,   2,   2, // 20-22
  3,   3,   2,   1, // 23-26
  3,   3,   2,   1, // 27-30
  2,   1, // 31-32
  2,   2, // 33-34
  2, // 35
  2,   2, // 36-37
  3,   2,   1, // 38-40
  3,   2,   1, // 41-43
  5,   2, // 44-45
  5,   2, // 46-47
  3, // 48
  1,   1,   1,   1,   4, // 49-53
  2,   1,   1,   1,   4, // 54-58
  1,   2,   1,   1,   4, // 59-63
  4,   2,   1,   1, // 64-67
  4,   2,   1, // 68-70
  4,   1,   1, // 71-73
  5,   2,   1, // 74-76
  4,   1,   1, // 77-79
  4,   2,   1,   1, // 80-83
  4,   1, // 84-85
  3,   1, // 86-87
  4,   2,   1,   1, // 88-91
  4,   2,   1, // 92-94
  4,   1,   1, // 95-97
  5,   2,   1, // 98-100
  5,   1,   1,   2, // 101-104
  3, // 105
  2, // 106
  4, // 107
  3,   2, // 108-109
  4,   2,   1, // 110-112
  3, // 113
  5, // 114
  2, // 115
  2,   2, // 116-117
  3,   2,   1, // 118-120
  2,   1, // 121-122
  5,   1,   1, // 123-125
  2, // 126
  2,   2, // 127-128
  3,   2,   1, // 129-131
  2,   2,   2, // 132-134
  2,   1,   1, // 135-137
  2,   1,   1, // 138-140
  2,   2,   1, // 141-143
  2,   2,   1, // 144-146
  4,   1,   1,   2, // 147-150
  6,   1,   1,   2, // 151-154
  4,   1,   1, // 155-157
  6,   1,   1, // 158-160
  2, // 161
  2,   2,   1,   1, // 162-165
  2,   2,   1, // 166-168
  2,   2,   1,   1, // 169-172
  2,   2,   1, // 173-175
  2,   1,   1, // 176-178
  2,   2,   1,   1, // 179-182
  2,   2,   1, // 183-185
  2,   2,   1, // 186-188
  2,   2,   1, // 189-191
  1,   1, // 192-193
  2, // 194
  2,   2, // 195-196
  3,   2,   1, // 197-199
  3,   2,   1, // 200-202
  9,   2,   2, // 203-205
  9,   2,   2, // 206-208
  2,   2, // 209-210
  2,   2, // 211-212
  5,   2, // 213-214
  5,   2, // 215-216
  34,   2,   2, // 217-219
  20,   2,   2, // 220-222
  9,   2,   2,   2, // 223-226
  9,   2,   2,   2, // 227-230
  3,   2,   1,   1,   5, // 231-235
  2,   1,   1,   5, // 236-239
  5,   2,   2, // 240-242
  5,   2,   2, // 243-245
  9,   2,   2,   2, // 246-249
  9,   2,   2,   2, // 250-253
  10,   1,   1, // 254-256
  10,   10,   1, // 257-259
  10,   1, // 260-261
  10,   1, // 262-263
  9,   2,   2, // 264-266
  9,   2,   2, // 267-269
  9,   2, // 270-271
  9,   2, // 272-273
  9,   2, // 274-275
  9,   2, // 276-277
  34,   2,   2, // 278-280
  20,   2,   2, // 281-283
  3,   2,   2,   2,   2, // 284-288
  2,   2,   2,   2, // 289-292
  2,   2,   2, // 293-295
  2,   2,   2, // 296-298
  9,   2, // 299-300
  9,   2, // 301-302
  9,   2, // 303-304
  9,   2, // 305-306
  2,   2,   1, // 307-309
  2,   2, // 310-311
  2,   1, // 312-313
  2, // 314
  2,   2, // 315-316
  2,   1, // 317-318
  4,   1, // 319-320
  4,   1, // 321-322
  3,   1, // 323-324
  2, // 325
  2,   1, // 326-327
  2,   1, // 328-329
  2,   1, // 330-331
  3,   3,   2,   1, // 332-335
  1,   1, // 336-337
  2, // 338
  2,   2, // 339-340
  2,   1, // 341-342
  2,   2,   2, // 343-345
  2,   2, // 346-347
  2,   2,   2, // 348-350
  1,   1,   4, // 351-353
  1,   2,   4, // 354-356
  2,   2, // 357-358
  2,   2, // 359-360
  2,   2,   2, // 361-363
  3,   3,   2,   1, // 364-367
  3,   3,   2,   1, // 368-371
  4,   2,   1, // 372-374
  3,   2,   1, // 375-377
  2,   1, // 378-379
  3,   2,   1, // 380-382
  2,   2, // 383-384
  4, // 385
  2, // 386
  3, // 387
  5, // 388
  2,   1, // 389-390
  5,   1,   1,   2, // 391-394
  5,   1,   1, // 395-397
  6,   1,   1,   2, // 398-401
  6,   1,   1, // 402-404
  4,   1,   1, // 405-407
  4,   1,   1,   2, // 408-411
  4,   1,   1, // 412-414
  5,   2,   1, // 415-417
  4,   1,   1, // 418-420
  4,   2,   1,   1, // 421-424
  1,   1, // 425-426
  1,   1, // 427-428
  4, // 429
  2, // 430
  3, // 431
  2, // 432
  2,   1, // 433-434
  2,   2, // 435-436
  2,   2,   2, // 437-439
  2,   2,   2, // 440-442
  2,   2,   2, // 443-445
  2,   2,   1, // 446-448
  3,   3,   2,   1, // 449-452
  5,   1,   1, // 453-455
  4,   1,   1, // 456-458
  5,   1,   1,   2, // 459-462
  5,   1,   1,   2, // 463-466
  5,   1,   1,   2, // 467-470
  4,   1,   1,   2, // 471-474
  5,   1,   1,   2, // 475-478
  5,   1,   1,   2, // 479-482
  6,   1,   1, // 483-485
  6,   1,   1, // 486-488
  6,   1,   1,   2, // 489-492
  4,   1,   1, // 493-495
  5,   2,   1, // 496-498
  4,   1,   1, // 499-501
  4,   1, // 502-503
  4,   1, // 504-505
  3,   1, // 506-507
  5,   2,   1, // 508-510
  4,   1,   1, // 511-513
  4,   1,   1, // 514-516
  4,   1,   1, // 517-519
  4,   1,   1, // 520-522
  4,   1, // 523-524
  5,   2,   1, // 525-527
  4,   1,   1, // 528-530
  4,   2,   1,   1, // 531-534
  4,   2,   1, // 535-537
  4,   2,   1,   1, // 538-541
  4,   2,   1,   1, // 542-545
  4,   2,   1, // 546-548
  4,   1, // 549-550
  4,   1, // 551-552
  4,   1, // 553-554
  4,   2,   1, // 555-557
  4,   1,   1, // 558-560
  4,   1, // 561-562
  4,   2,   1,   1, // 563-566
  1,   1,   1,   1,   4, // 567-571
  2,   1,   1,   1,   4, // 572-576
  1,   2,   1,   1,   4, // 577-581
  1,   1,   4, // 582-584
  1,   2,   4, // 585-587
  2,   1,   1, // 588-590
  2,   1,   1, // 591-593
  2,   2,   1, // 594-596
  2,   2,   1, // 597-599
  2,   1, // 600-601
  2,   1, // 602-603
  2,   2,   1,   1, // 604-607
  2,   2,   1, // 608-610
  2,   2,   1,   1, // 611-614
  2,   2,   1, // 615-617
  2,   1, // 618-619
  2,   1, // 620-621
  2,   1,   1, // 622-624
  2,   2,   1,   1, // 625-628
  2, // 629
  5,   2, // 630-631
  5,   2, // 632-633
  2,   2, // 634-635
  2,   2, // 636-637
  9,   2,   2, // 638-640
  9,   2,   2, // 641-643
  9,   2,   2, // 644-646
  9,   2,   2, // 647-649
  9,   2,   2,   2, // 650-653
  9,   2,   2,   2, // 654-657
  9,   2,   2,   2, // 658-661
  9,   2,   2,   2, // 662-665
  5,   2, // 666-667
  5,   2, // 668-669
  9,   2, // 670-671
  9,   2, // 672-673
  9,   2, // 674-675
  9,   2, // 676-677
  9,   2, // 678-679
  9,   2, // 680-681
  5,   2, // 682-683
  5,   2, // 684-685
  10,   1, // 686-687
  10,   1, // 688-689
  10,   10,   1, // 690-692
  10,   1,   1, // 693-695
  10,   1,   1, // 696-698
  3, // 699
  3, // 700
  3, // 701
  5,   2,   2, // 702-704
  5,   2,   2, // 705-707
  2,   2,   2, // 708-710
  2,   2,   2, // 711-713
  2,   1,   1,   5, // 714-717
  2,   2,   2,   2, // 718-721
  2,   1,   1,   5, // 722-725
  3,   2,   1,   1,   5, // 726-730
  2,   2,   2,   2, // 731-734
  3,   2,   2,   2,   2, // 735-739
  20,   2,   2, // 740-742
  20,   2,   2, // 743-745
  34,   2,   2, // 746-748
  34,   2,   2, // 749-751
  1,   1, // 752-753
  1,   1,   1, // 754-756
  3,   1,   1,   1, // 757-760
  3,   1,   1,   1, // 761-764
  3,   1,   1,   1, // 765-768
  1,   1, // 769-770
  1,   1,   1, // 771-773
  3,   1,   1,   1, // 774-777
  3,   1,   1,   1, // 778-781
  2,   1, // 782-783
  1,   1, // 784-785
  1, // 786
  1,   1, // 787-788
  1,   1,   1, // 789-791
  1,   1,   1, // 792-794
  1,   1, // 795-796
  1,   1, // 797-798
  1, // 799
  1,   1,   1,   1,   3, // 800-804
  2,   1,   1,   1,   3, // 805-809
  1,   2,   1,   1,   3, // 810-814
  4,   3,   1,   1, // 815-818
  4,   3,   1, // 819-821
  4,   1,   1, // 822-824
  5,   1,   1, // 825-827
  3,   3,   1,   1, // 828-831
  3,   3,   1,   1, // 832-835
  3,   1, // 836-837
  2,   1, // 838-839
  3,   2,   1,   1, // 840-843
  3,   2,   1, // 844-846
  3,   1,   1, // 847-849
  4,   1,   1, // 850-852
  4,   1,   1,   1, // 853-856
  1, // 857
  1, // 858
  2, // 859
  1,   1, // 860-861
  2,   1,   1, // 862-864
  3, // 865
  5, // 866
  2, // 867
  1,   1, // 868-869
  2,   1,   1, // 870-872
  1,   1, // 873-874
  4,   1,   1, // 875-877
  1, // 878
  1,   1, // 879-880
  3,   1,   1, // 881-883
  1,   1,   1, // 884-886
  1,   1,   1, // 887-889
  1,   1,   1, // 890-892
  2,   1,   1, // 893-895
  2,   1,   1, // 896-898
  1,   1, // 899-900
  3,   1,   1,   1, // 901-904
  4,   5,   1,   1, // 905-908
  3,   1,   1, // 909-911
  4,   5,   1,   1, // 912-915
  2, // 916
  3,   1,   1,   1, // 917-920
  3,   1,   1, // 921-923
  2,   1,   1,   1, // 924-927
  1,   1,   1, // 928-930
  1,   1,   1, // 931-933
  3,   1,   1,   1, // 934-937
  2,   1,   1, // 938-940
  1,   1,   1, // 941-943
  3,   1,   1, // 944-946
  2,   1, // 947-948
  1, // 949
  1,   1, // 950-951
  1,   1,   1, // 952-954
  1,   1,   1, // 955-957
  6,   3,   2,   1, // 958-961
  6,   3,   2,   1, // 962-965
  4,   2,   1, // 966-968
  5,   2,   2, // 969-971
  6,   2,   2, // 972-974
  4,   2,   1, // 975-977
  5,   2, // 978-979
  6,   2, // 980-981
  4,   2, // 982-983
  4,   2, // 984-985
  4,   1,   1, // 986-988
  4,   2,   2, // 989-991
  3,   1,   1, // 992-994
  4,   1,   1, // 995-997
  3,   2,   1, // 998-1000
  3,   2,   2, // 1001-1003
  3,   2,   2, // 1004-1006
  3, // 1007
  3,   2,   2, // 1008-1010
  4,   2,   2, // 1011-1013
  1,   1, // 1014-1015
  1,   1, // 1016-1017
  4,   1, // 1018-1019
  2,   1, // 1020-1021
  4,   1, // 1022-1023
  4,   1, // 1024-1025
  25,   1,   1, // 1026-1028
  15,   1,   1, // 1029-1031
  1,   1, // 1032-1033
  2,   1, // 1034-1035
  2,   1, // 1036-1037
  2,   1,   1, // 1038-1040
  3,   1,   2, // 1041-1043
  9,   1,   1,   1, // 1044-1047
  8,   1,   1,   1, // 1048-1051
  6,   3,   2,   1, // 1052-1055
  8,   4,   2,   1, // 1056-1059
  2,   1, // 1060-1061
  4,   2,   2, // 1062-1064
  2,   1, // 1065-1066
  2,   2,   1,   1, // 1067-1070
  3,   1,   1,   1, // 1071-1074
  3,   2,   1,   1,   1,   1, // 1075-1080
  1,   1, // 1081-1082
  1,   1,   2,   2,   1, // 1083-1087
  1,   1,   2,   1, // 1088-1091
  1,   1,   2,   1, // 1092-1095
  1,   2,   1, // 1096-1098
  1,   1,   1, // 1099-1101
  2,   2,   1, // 1102-1104
  2,   2,   2,   1,   1, // 1105-1109
  3,   3,   1,   1,   1,   1, // 1110-1115
  3,   3,   2,   1,   1,   1,   1,   1, // 1116-1123
  2,   2,   1, // 1124-1126
  2,   2,   2,   1,   1,   1, // 1127-1132
  2,   3,   2,   3,   1, // 1133-1137
  2,   3,   2,   3,   2,   1, // 1138-1143
  3,   3,   4,   1, // 1144-1147
  3,   3,   4,   2,   1,   1, // 1148-1153
  5,   5,   6,   1,   1,   1,   1,   2, // 1154-1161
  5,   5,   6,   2,   1,   1,   1,   1,   1,   2, // 1162-1171
  3,   3,   4,   1, // 1172-1175
  3,   3,   4,   2,   1, // 1176-1180
  2,   2,   3,   3,   1, // 1181-1185
  2,   2,   3,   3,   2,   1,   1, // 1186-1192
  4,   4,   5,   5,   1,   1,   1,   1,   2,   2, // 1193-1202
  4,   4,   5,   5,   2,   1,   1,   1,   1,   1,   2,   2, // 1203-1214
  3,   3,   4,   4,   1, // 1215-1219
  3,   3,   4,   4,   2,   1, // 1220-1225
  2,   1,   1,   1, // 1226-1229
  1,   1,   1,   1, // 1230-1233
  2,   1, // 1234-1235
  1,   1, // 1236-1237
  9,   1,   1,   1, // 1238-1241
  7,   3,   2,   1, // 1242-1245
  6,   3,   2,   2, // 1246-1249
  8,   1,   1,   1, // 1250-1253
  6,   3,   2,   1, // 1254-1257
  8,   4,   2,   1, // 1258-1261
  9,   3,   2,   1, // 1262-1265
  7,   3,   2,   2, // 1266-1269
  1,   1,   1, // 1270-1272
  4,   1, // 1273-1274
  3,   1, // 1275-1276
  2,   1,   1, // 1277-1279
  2,   1, // 1280-1281
  1,   1, // 1282-1283
  6,   1,   1, // 1284-1286
  6,   2,   2, // 1287-1289
  7,   2,   1, // 1290-1292
  5,   1,   1, // 1293-1295
  5,   2,   1, // 1296-1298
  6,   2,   1, // 1299-1301
  7,   2,   2, // 1302-1304
  9,   2,   1, // 1305-1307
  3,   1,   1, // 1308-1310
  6,   3,   1, // 1311-1313
  6,   3,   1, // 1314-1316
  5,   1,   1, // 1317-1319
  4,   1, // 1320-1321
  4,   1,   1, // 1322-1324
  4,   1,   1, // 1325-1327
  9,   2,   2, // 1328-1330
  10,   2,   2, // 1331-1333
  3,   1,   1, // 1334-1336
  4,   1, // 1337-1338
  4,   1, // 1339-1340
  4,   1, // 1341-1342
  4,   1, // 1343-1344
  32,   1, // 1345-1346
  17,   1, // 1347-1348
  1,   1,   1, // 1349-1351
  2,   1,   1,   1,   1, // 1352-1356
  1,   1,   1, // 1357-1359
  1,   1,   1,   1,   2,   2, // 1360-1365
  1,   1,   2,   2,   2,   1, // 1366-1371
  1,   1,   1,   1,   2, // 1372-1376
  1,   1,   2,   2,   1, // 1377-1381
  2,   1,   1,   1,   1,   1,   2,   2, // 1382-1389
  2,   1,   1,   1,   1,   1,   2, // 1390-1396
  1,   1,   1,   1, // 1397-1400
  1,   1,   1,   1, // 1401-1404
  2,   1,   1,   1,   1,   1, // 1405-1410
  1,   1,   1,   1, // 1411-1414
  1,   1,   1,   1,   2,   2, // 1415-1420
  2,   1,   1,   1,   1,   1,   2,   2, // 1421-1428
  1,   1,   1,   1,   2, // 1429-1433
  2,   1,   1,   1,   1,   1,   2, // 1434-1440
  1,   1,   1,   1,   2, // 1441-1445
  2,   1,   1,   1,   1,   1,   2, // 1446-1452
  1,   1,   1,   1,   2,   2, // 1453-1458
  2,   1,   1,   1,   1,   1,   2,   2, // 1459-1466
  1,   1,   1,   1,   2,   2, // 1467-1472
  2,   1,   1,   1,   1,   1,   2,   2, // 1473-1480
  2,   1,   1,   1, // 1481-1484
  1,   1,   1,   1, // 1485-1488
  1,   1, // 1489-1490
  1,   1, // 1491-1492
  3,   2,   1, // 1493-1495
  3,   2,   1, // 1496-1498
  3,   2,   2,   1, // 1499-1502
  4,   2,   2,   3,   1, // 1503-1507
  4,   2,   2,   3,   3,   1, // 1508-1513
  3,   1,   2,   1, // 1514-1517
  3,   1,   2,   2,   1, // 1518-1522
  4,   1,   2,   2,   3,   1, // 1523-1528
  4,   1,   2,   2,   3,   3,   1, // 1529-1535
  4,   1, // 1536-1537
  4,   1, // 1538-1539
  4,   1, // 1540-1541
  4,   1, // 1542-1543
  2,   2,   1,   1, // 1544-1547
  3,   3,   1,   1, // 1548-1551
  4,   4,   1,   1, // 1552-1555
  2,   1,   1, // 1556-1558
  1,   1, // 1559-1560
  1,   1, // 1561-1562
  1, // 1563
  1,   1, // 1564-1565
  1,   1, // 1566-1567
  4,   1, // 1568-1569
  3,   3,   1, // 1570-1572
  1,   1, // 1573-1574
  1, // 1575
  2,   1, // 1576-1577
  2,   1,   1, // 1578-1580
  1,   1, // 1581-1582
  1,   1, // 1583-1584
  3,   1,   1,   1, // 1585-1588
  2,   1, // 1589-1590
  1, // 1591
  1,   1, // 1592-1593
  1,   1, // 1594-1595
  1,   1,   1, // 1596-1598
  1,   1, // 1599-1600
  1,   1,   1, // 1601-1603
  1,   1,   3, // 1604-1606
  1,   1,   3, // 1607-1609
  1,   1, // 1610-1611
  1,   1, // 1612-1613
  1,   1,   1, // 1614-1616
  3,   1,   1,   1, // 1617-1620
  3,   1,   1,   1, // 1621-1624
  2,   1,   1, // 1625-1627
  2,   1,   1, // 1628-1630
  1,   1, // 1631-1632
  3,   1,   1, // 1633-1635
  1,   1, // 1636-1637
  2, // 1638
  2, // 1639
  3, // 1640
  5, // 1641
  2,   1, // 1642-1643
  4,   1,   1,   1, // 1644-1647
  4,   1,   1, // 1648-1650
  4,   5,   1,   1, // 1651-1654
  4,   5,   1,   1, // 1655-1658
  3,   1,   1, // 1659-1661
  3,   1,   1,   1, // 1662-1665
  3,   1,   1, // 1666-1668
  4,   1,   1, // 1669-1671
  4,   1,   1, // 1672-1674
  4,   3,   1,   1, // 1675-1678
  2,   1, // 1679-1680
  2,   1, // 1681-1682
  2, // 1683
  2, // 1684
  3, // 1685
  1, // 1686
  2,   1, // 1687-1688
  1,   1, // 1689-1690
  1,   1,   1, // 1691-1693
  1,   1,   1, // 1694-1696
  1,   1,   1, // 1697-1699
  3,   1,   1, // 1700-1702
  3,   1,   1,   1, // 1703-1706
  4,   1,   1, // 1707-1709
  3,   1,   1, // 1710-1712
  4,   1,   1,   1, // 1713-1716
  4,   1,   1,   1, // 1717-1720
  4,   1,   1,   1, // 1721-1724
  3,   1,   1,   1, // 1725-1728
  4,   1,   1,   1, // 1729-1732
  4,   1,   1,   1, // 1733-1736
  4,   5,   1,   1, // 1737-1740
  4,   5,   1,   1, // 1741-1744
  4,   5,   1,   1, // 1745-1748
  4,   1,   1, // 1749-1751
  5,   1,   1, // 1752-1754
  3,   1,   1, // 1755-1757
  4,   1, // 1758-1759
  3,   1, // 1760-1761
  2,   1, // 1762-1763
  4,   1,   1, // 1764-1766
  4,   1,   1, // 1767-1769
  3,   1,   1, // 1770-1772
  4,   1,   1, // 1773-1775
  3,   1,   1, // 1776-1778
  4,   1, // 1779-1780
  5,   1,   1, // 1781-1783
  4,   1,   1, // 1784-1786
  4,   3,   1,   1, // 1787-1790
  4,   3,   1, // 1791-1793
  4,   3,   1,   1, // 1794-1797
  3,   2,   1,   1, // 1798-1801
  3,   2,   1, // 1802-1804
  4,   1, // 1805-1806
  3,   1, // 1807-1808
  4,   1, // 1809-1810
  4,   3,   1, // 1811-1813
  3,   3,   1,   1, // 1814-1817
  3,   3,   1, // 1818-1820
  3,   3,   1,   1, // 1821-1824
  1,   1,   1,   1,   3, // 1825-1829
  2,   1,   1,   1,   3, // 1830-1834
  1,   2,   1,   1,   3, // 1835-1839
  1,   1,   3, // 1840-1842
  1,   1,   3, // 1843-1845
  1,   1,   1, // 1846-1848
  1,   1,   1, // 1849-1851
  1,   1,   1, // 1852-1854
  1,   1,   1, // 1855-1857
  1,   1, // 1858-1859
  1,   1, // 1860-1861
  3,   1,   1,   1, // 1862-1865
  3,   1,   1, // 1866-1868
  2,   1,   1,   1, // 1869-1872
  2,   1,   1, // 1873-1875
  1,   1, // 1876-1877
  1,   1, // 1878-1879
  1,   1,   1, // 1880-1882
  3,   1,   1,   1, // 1883-1886
  2, // 1887
  3,   1,   1, // 1888-1890
  3,   2,   1, // 1891-1893
  3,   2,   2, // 1894-1896
  3,   2,   2, // 1897-1899
  3, // 1900
  3,   2,   2, // 1901-1903
  4,   2,   2, // 1904-1906
  4,   2,   2, // 1907-1909
  4,   2,   2, // 1910-1912
  4,   2,   1, // 1913-1915
  4,   2,   1, // 1916-1918
  6,   2, // 1919-1920
  5,   2, // 1921-1922
  3,   1,   1, // 1923-1925
  4,   1,   1, // 1926-1928
  4,   1,   1, // 1929-1931
  3,   2,   1, // 1932-1934
  2,   1,   1, // 1935-1937
  3,   1,   2, // 1938-1940
  2,   1, // 1941-1942
  2,   1, // 1943-1944
  6,   3,   2,   1, // 1945-1948
  6,   3,   2,   1, // 1949-1952
  5,   2, // 1953-1954
  6,   2, // 1955-1956
  4,   2, // 1957-1958
  4,   2, // 1959-1960
  5,   2,   2, // 1961-1963
  6,   2,   2, // 1964-1966
  4,   2,   1, // 1967-1969
  4,   2,   1, // 1970-1972
  6,   3,   1, // 1973-1975
  6,   3,   1, // 1976-1978
  4,   1, // 1979-1980
  4,   1, // 1981-1982
  4,   2,   2, // 1983-1985
  4,   2,   2, // 1986-1988
  4,   1,   1, // 1989-1991
  4,   1,   1, // 1992-1994
  5,   2, // 1995-1996
  6,   2, // 1997-1998
  4,   2,   2, // 1999-2001
  3,   1,   1, // 2002-2004
  4,   1,   1, // 2005-2007
  4,   2,   2, // 2008-2010
  3,   2,   1, // 2011-2013
  3,   1,   2,   1, // 2014-2017
  3,   2,   2,   1, // 2018-2021
  3,   1,   2,   2,   1, // 2022-2026
  4,   2,   2,   3,   1, // 2027-2031
  4,   1,   2,   2,   3,   1, // 2032-2037
  4,   2,   2,   3,   3,   1, // 2038-2043
  4,   1,   2,   2,   3,   3,   1, // 2044-2050
  2,   2,   1,   1, // 2051-2054
  3,   3,   1,   1, // 2055-2058
  4,   4,   1,   1, // 2059-2062
  1,   1, // 2063-2064
  1,   1, // 2065-2066
  1,   1, // 2067-2068
  1,   1, // 2069-2070
  4,   2,   1, // 2071-2073
  5,   2,   2, // 2074-2076
  6,   2,   2, // 2077-2079
  4,   2,   1, // 2080-2082
  4,   1,   1, // 2083-2085
  5,   1,   1, // 2086-2088
  4,   1,   1, // 2089-2091
  9,   2,   2, // 2092-2094
  10,   2,   2, // 2095-2097
  6,   2,   2, // 2098-2100
  7,   2,   1, // 2101-2103
  5,   1,   1, // 2104-2106
  5,   2,   1, // 2107-2109
  6,   2,   1, // 2110-2112
  7,   2,   2, // 2113-2115
  5,   2,   2, // 2116-2118
  6,   2,   2, // 2119-2121
  9,   2,   1, // 2122-2124
  6,   1,   1, // 2125-2127
  9,   1,   1,   1, // 2128-2131
  8,   1,   1,   1, // 2132-2135
  9,   1,   1,   1, // 2136-2139
  7,   3,   2,   1, // 2140-2143
  6,   3,   2,   2, // 2144-2147
  8,   1,   1,   1, // 2148-2151
  6,   3,   2,   1, // 2152-2155
  8,   4,   2,   1, // 2156-2159
  9,   3,   2,   1, // 2160-2163
  7,   3,   2,   2, // 2164-2167
  6,   3,   2,   1, // 2168-2171
  8,   4,   2,   1, // 2172-2175
  4,   1, // 2176-2177
  2,   1, // 2178-2179
  4,   1, // 2180-2181
  4,   1, // 2182-2183
  6,   2, // 2184-2185
  5,   2, // 2186-2187
  4,   1, // 2188-2189
  4,   1, // 2190-2191
  4,   1, // 2192-2193
  4,   1, // 2194-2195
  4,   1, // 2196-2197
  4,   1, // 2198-2199
  1,   1, // 2200-2201
  1,   1, // 2202-2203
  3, // 2204
  3,   2,   1, // 2205-2207
  4,   1, // 2208-2209
  3,   1, // 2210-2211
  4,   1, // 2212-2213
  2,   1, // 2214-2215
  2,   1, // 2216-2217
  1,   1, // 2218-2219
  2,   1, // 2220-2221
  1,   1, // 2222-2223
  3,   1,   1, // 2224-2226
  2,   1,   1, // 2227-2229
  1,   1,   1, // 2230-2232
  1,   1,   1, // 2233-2235
  2,   1, // 2236-2237
  2,   1, // 2238-2239
  1, // 2240
  1, // 2241
  1, // 2242
  2,   1, // 2243-2244
  1,   1, // 2245-2246
  1,   1, // 2247-2248
  1,   1, // 2249-2250
  1,   1,   1,   1, // 2251-2254
  1,   1,   1,   1, // 2255-2258
  1,   1,   1,   1, // 2259-2262
  2,   1,   1,   1, // 2263-2266
  1,   1,   1,   1, // 2267-2270
  2,   1,   1,   1, // 2271-2274
  1,   1, // 2275-2276
  1,   1,   1, // 2277-2279
  1,   2,   1, // 2280-2282
  1,   1,   2,   1, // 2283-2286
  1,   1,   2,   1, // 2287-2290
  1,   1,   2,   1, // 2291-2294
  1,   1,   2,   2,   1, // 2295-2299
  1,   1,   2,   1, // 2300-2303
  2,   2,   1, // 2304-2306
  2,   3,   2,   3,   1, // 2307-2311
  2,   2,   2,   1,   1,   1, // 2312-2317
  2,   3,   2,   3,   2,   1, // 2318-2323
  3,   3,   4,   1, // 2324-2327
  3,   3,   4,   1, // 2328-2331
  3,   3,   4,   2,   1, // 2332-2336
  3,   3,   4,   2,   1, // 2337-2341
  3,   3,   4,   4,   1, // 2342-2346
  3,   3,   4,   4,   1, // 2347-2351
  3,   3,   4,   4,   2,   1, // 2352-2357
  3,   3,   4,   4,   2,   1, // 2358-2363
  2,   1, // 2364-2365
  3,   1,   1,   1, // 2366-2369
  2,   2,   1,   1, // 2370-2373
  3,   2,   1,   1,   1,   1, // 2374-2379
  2,   2,   1, // 2380-2382
  3,   3,   1,   1,   1,   1, // 2383-2388
  3,   3,   2,   1,   1,   1,   1,   1, // 2389-2396
  2,   2,   2,   1,   1, // 2397-2401
  3,   3,   2,   1,   1,   1,   1,   1, // 2402-2409
  3,   3,   4,   1, // 2410-2413
  5,   5,   6,   1,   1,   1,   1,   2, // 2414-2421
  3,   3,   4,   2,   1,   1, // 2422-2427
  5,   5,   6,   2,   1,   1,   1,   1,   1,   2, // 2428-2437
  3,   3,   4,   2,   1,   1, // 2438-2443
  5,   5,   6,   2,   1,   1,   1,   1,   1,   2, // 2444-2453
  2,   2,   3,   3,   1, // 2454-2458
  4,   4,   5,   5,   1,   1,   1,   1,   2,   2, // 2459-2468
  2,   2,   3,   3,   2,   1,   1, // 2469-2475
  4,   4,   5,   5,   2,   1,   1,   1,   1,   1,   2,   2, // 2476-2487
  2,   2,   3,   3,   2,   1,   1, // 2488-2494
  4,   4,   5,   5,   2,   1,   1,   1,   1,   1,   2,   2, // 2495-2506
  1,   1,   1, // 2507-2509
  1,   1,   1,   1, // 2510-2513
  1,   2,   1, // 2514-2516
  1,   1,   2,   1, // 2517-2520
  1,   1,   1,   1,   2, // 2521-2525
  1,   1,   2,   2,   1, // 2526-2530
  2,   1,   1,   1,   1,   1,   2, // 2531-2537
  1,   1,   1,   1,   2,   2, // 2538-2543
  1,   1,   2,   2,   2,   1, // 2544-2549
  2,   1,   1,   1,   1,   1,   2,   2, // 2550-2557
  1,   1,   1,   1, // 2558-2561
  1,   2,   1, // 2562-2564
  1,   1,   1,   1,   2,   2, // 2565-2570
  2,   1,   1,   1,   1,   1,   2,   2, // 2571-2578
  1,   2,   1, // 2579-2581
  1,   1,   1,   1,   2, // 2582-2586
  2,   1,   1,   1,   1,   1,   2, // 2587-2593
  1,   1,   1,   1,   2,   2, // 2594-2599
  2,   1,   1,   1,   1,   1,   2,   2, // 2600-2607
  1,   1,   1, // 2608-2610
  2,   1,   1,   1,   1, // 2611-2615
  1,   1,   1,   1, // 2616-2619
  2,   1,   1,   1,   1,   1, // 2620-2625
  1,   1,   1,   1,   2, // 2626-2630
  2,   1,   1,   1,   1,   1,   2, // 2631-2637
  1,   1,   1,   1,   2,   2, // 2638-2643
  2,   1,   1,   1,   1,   1,   2,   2, // 2644-2651
  15,   1,   1, // 2652-2654
  17,   1, // 2655-2656
  25,   1,   1, // 2657-2659
  32,   1, // 2660-2661
  2,   2, // 2662-2663
  2,   2,   2, // 2664-2666
  2,   2,   1,   1, // 2667-2670
  2,   2,   1,   1, // 2671-2674
  2,   2,   1,   1, // 2675-2678
  2,   2, // 2679-2680
  2,   2,   2, // 2681-2683
  2,   2,   1,   1, // 2684-2687
  2,   2,   1,   1, // 2688-2691
  2,   1, // 2692-2693
  2,   2, // 2694-2695
  2, // 2696
  2,   2, // 2697-2698
  2,   1,   1, // 2699-2701
  2,   1,   1, // 2702-2704
  4,   1, // 2705-2706
  7,   1, // 2707-2708
  20, // 2709
  1,   1,   1,   1,   3, // 2710-2714
  2,   1,   1,   1,   3, // 2715-2719
  1,   2,   1,   1,   3, // 2720-2724
  3,   2,   1,   1, // 2725-2728
  3,   2,   1, // 2729-2731
  3,   1,   1, // 2732-2734
  4,   1,   1, // 2735-2737
  3,   1,   1, // 2738-2740
  3,   2,   1,   1, // 2741-2744
  3,   1, // 2745-2746
  4,   1, // 2747-2748
  3,   2,   1,   1, // 2749-2752
  3,   2,   1, // 2753-2755
  3,   1,   1, // 2756-2758
  4,   1,   1, // 2759-2761
  6,   1,   1,   4, // 2762-2765
  2, // 2766
  1, // 2767
  3,   1, // 2768-2769
  2,   1, // 2770-2771
  2,   1,   1, // 2772-2774
  3, // 2775
  5, // 2776
  2, // 2777
  1,   1, // 2778-2779
  1,   1,   1, // 2780-2782
  1,   1, // 2783-2784
  6,   1,   1, // 2785-2787
  1, // 2788
  1,   1, // 2789-2790
  1,   1,   1, // 2791-2793
  2,   2,   2, // 2794-2796
  3,   1,   1, // 2797-2799
  3,   1,   1, // 2800-2802
  2,   2,   1, // 2803-2805
  2,   2,   1, // 2806-2808
  2,   2, // 2809-2810
  6,   1,   1,   4, // 2811-2814
  6,   6,   1,   1, // 2815-2818
  5,   1,   1, // 2819-2821
  6,   6,   1,   1, // 2822-2825
  2, // 2826
  2,   3,   1,   1, // 2827-2830
  2,   3,   1, // 2831-2833
  2,   3,   1,   1, // 2834-2837
  3,   1,   1, // 2838-2840
  3,   1,   1, // 2841-2843
  2,   3,   1,   1, // 2844-2847
  2,   3,   1, // 2848-2850
  3,   1,   1, // 2851-2853
  2,   2,   1, // 2854-2856
  1,   1, // 2857-2858
  2, // 2859
  2,   2, // 2860-2861
  2,   1,   1, // 2862-2864
  2,   1,   1, // 2865-2867
  6,   3,   2,   1, // 2868-2871
  6,   3,   2,   1, // 2872-2875
  4,   2,   1, // 2876-2878
  5,   2,   2, // 2879-2881
  6,   2,   2, // 2882-2884
  4,   2,   1, // 2885-2887
  5,   2, // 2888-2889
  6,   2, // 2890-2891
  4,   2, // 2892-2893
  4,   2, // 2894-2895
  9,   1,   1, // 2896-2898
  4,   2,   1, // 2899-2901
  3,   1,   1, // 2902-2904
  7,   1,   1, // 2905-2907
  3,   2,   1, // 2908-2910
  3,   2,   2, // 2911-2913
  3,   2,   2, // 2914-2916
  3, // 2917
  3,   2,   2, // 2918-2920
  4,   2,   2, // 2921-2923
  4,   1, // 2924-2925
  1,   1, // 2926-2927
  5,   1, // 2928-2929
  7,   1, // 2930-2931
  29,   1,   1, // 2932-2934
  20,   1,   1, // 2935-2937
  2,   1, // 2938-2939
  2,   1, // 2940-2941
  3,   1, // 2942-2943
  2,   1,   1, // 2944-2946
  3,   1,   1, // 2947-2949
  19,   2,   1,   1, // 2950-2953
  7,   2,   1,   1, // 2954-2957
  9,   3,   2,   2, // 2958-2961
  10,   3,   2,   2, // 2962-2965
  20,   1, // 2966-2967
  4,   2,   1, // 2968-2970
  2,   1, // 2971-2972
  2,   2,   1,   1, // 2973-2976
  3,   1,   1,   1, // 2977-2980
  3,   2,   1,   1,   1,   1, // 2981-2986
  2,   1, // 2987-2988
  2,   2,   3,   3,   1, // 2989-2993
  2,   2,   2,   1, // 2994-2997
  2,   2,   3,   1, // 2998-3001
  2,   2,   1, // 3002-3004
  2,   2,   1, // 3005-3007
  2,   2,   1, // 3008-3010
  2,   2,   2,   1,   1, // 3011-3015
  3,   3,   1,   1,   1,   1, // 3016-3021
  3,   3,   2,   1,   1,   1,   1,   1, // 3022-3029
  2,   2,   1, // 3030-3032
  2,   2,   2,   1,   1,   1, // 3033-3038
  2,   2,   3,   3,   1, // 3039-3043
  2,   2,   3,   3,   2,   1, // 3044-3049
  2,   2,   3,   1, // 3050-3053
  2,   2,   3,   2,   1,   1, // 3054-3059
  4,   4,   5,   1,   1,   1,   1,   2, // 3060-3067
  4,   4,   5,   2,   1,   1,   1,   1,   1,   2, // 3068-3077
  3,   3,   4,   1, // 3078-3081
  3,   3,   4,   2,   1, // 3082-3086
  2,   2,   3,   3,   1, // 3087-3091
  2,   2,   3,   3,   2,   1,   1, // 3092-3098
  4,   4,   5,   5,   1,   1,   1,   1,   2,   2, // 3099-3108
  4,   4,   5,   5,   2,   1,   1,   1,   1,   1,   2,   2, // 3109-3120
  3,   3,   4,   4,   1, // 3121-3125
  3,   3,   4,   4,   2,   1, // 3126-3131
  2,   1,   1,   1,   2, // 3132-3136
  1,   1,   1,   2, // 3137-3140
  2,   1, // 3141-3142
  2,   1, // 3143-3144
  19,   2,   1,   1, // 3145-3148
  7,   3,   2,   1, // 3149-3152
  6,   3,   2,   2, // 3153-3156
  7,   2,   1,   1, // 3157-3160
  9,   3,   2,   2, // 3161-3164
  10,   3,   2,   2, // 3165-3168
  9,   3,   2,   1, // 3169-3172
  7,   3,   2,   2, // 3173-3176
  2,   1,   1, // 3177-3179
  4,   1, // 3180-3181
  2,   1, // 3182-3183
  20,   20,   1, // 3184-3186
  20,   1, // 3187-3188
  2,   1, // 3189-3190
  11,   1,   1, // 3191-3193
  6,   2,   2, // 3194-3196
  7,   2,   1, // 3197-3199
  7,   1,   1, // 3200-3202
  5,   2,   1, // 3203-3205
  6,   2,   1, // 3206-3208
  7,   2,   2, // 3209-3211
  9,   2,   1, // 3212-3214
  4,   1,   1, // 3215-3217
  7,   3,   1, // 3218-3220
  6,   3,   1, // 3221-3223
  5,   2,   2, // 3224-3226
  4,   1, // 3227-3228
  5,   1,   1, // 3229-3231
  4,   1,   1, // 3232-3234
  9,   2,   2, // 3235-3237
  10,   2,   2, // 3238-3240
  3,   1,   1, // 3241-3243
  8,   1, // 3244-3245
  7,   1, // 3246-3247
  8,   1, // 3248-3249
  7,   1, // 3250-3251
  29,   1, // 3252-3253
  19,   1, // 3254-3255
  1,   1,   1, // 3256-3258
  2,   1,   1,   1,   1, // 3259-3263
  1,   1,   1, // 3264-3266
  1,   1,   1,   1,   2,   2, // 3267-3272
  2,   2,   3,   3,   2,   1, // 3273-3278
  1,   1,   1,   1,   2, // 3279-3283
  2,   2,   3,   2,   1, // 3284-3288
  2,   1,   1,   1,   1,   1,   2,   2, // 3289-3296
  2,   1,   1,   1,   1,   1,   2, // 3297-3303
  1,   1,   1,   1, // 3304-3307
  1,   1,   1,   1, // 3308-3311
  2,   1,   1,   1,   1,   1, // 3312-3317
  1,   1,   1,   1, // 3318-3321
  1,   1,   1,   1,   2,   2, // 3322-3327
  2,   1,   1,   1,   1,   1,   2,   2, // 3328-3335
  1,   1,   1,   1,   2, // 3336-3340
  2,   1,   1,   1,   1,   1,   2, // 3341-3347
  1,   1,   1,   1,   2, // 3348-3352
  2,   1,   1,   1,   1,   1,   2, // 3353-3359
  1,   1,   1,   1,   2,   2, // 3360-3365
  2,   1,   1,   1,   1,   1,   2,   2, // 3366-3373
  1,   1,   1,   1,   2,   2, // 3374-3379
  2,   1,   1,   1,   1,   1,   2,   2, // 3380-3387
  2,   1,   1,   1,   1, // 3388-3392
  1,   1,   1,   1, // 3393-3396
  1,   1, // 3397-3398
  1,   1, // 3399-3400
  3,   2,   1, // 3401-3403
  3,   2,   1, // 3404-3406
  3,   2,   2,   1, // 3407-3410
  4,   2,   2,   3,   1, // 3411-3415
  4,   2,   2,   3,   3,   1, // 3416-3421
  3,   1,   2,   1, // 3422-3425
  3,   1,   2,   2,   1, // 3426-3430
  4,   1,   2,   2,   3,   1, // 3431-3436
  4,   1,   2,   2,   3,   3,   1, // 3437-3443
  8,   1, // 3444-3445
  7,   1, // 3446-3447
  8,   1, // 3448-3449
  7,   1, // 3450-3451
  2,   2,   1,   1, // 3452-3455
  3,   3,   1,   1, // 3456-3459
  4,   4,   1,   1, // 3460-3463
  2,   2,   1, // 3464-3466
  2,   2, // 3467-3468
  2,   1, // 3469-3470
  2, // 3471
  2,   2, // 3472-3473
  2,   1, // 3474-3475
  3,   1, // 3476-3477
  3,   1, // 3478-3479
  2,   1, // 3480-3481
  1, // 3482
  1,   1, // 3483-3484
  2,   1,   2, // 3485-3487
  3,   1, // 3488-3489
  3,   1, // 3490-3491
  2,   2,   1,   1, // 3492-3495
  1,   1, // 3496-3497
  2, // 3498
  2,   2, // 3499-3500
  2,   1, // 3501-3502
  2,   2,   2, // 3503-3505
  2,   2, // 3506-3507
  2,   2,   2, // 3508-3510
  1,   1,   3, // 3511-3513
  1,   1,   3, // 3514-3516
  2,   2, // 3517-3518
  2,   2, // 3519-3520
  2,   2,   2, // 3521-3523
  2,   2,   1,   1, // 3524-3527
  2,   2,   1,   1, // 3528-3531
  2,   1,   1, // 3532-3534
  1,   1,   1, // 3535-3537
  1,   1, // 3538-3539
  1,   1,   1, // 3540-3542
  1,   1, // 3543-3544
  3,   1, // 3545-3546
  2, // 3547
  3, // 3548
  5, // 3549
  2,   1, // 3550-3551
  6,   1,   1,   4, // 3552-3555
  6,   1,   1, // 3556-3558
  6,   6,   1,   1, // 3559-3562
  6,   6,   1,   1, // 3563-3566
  5,   1,   1, // 3567-3569
  6,   1,   1,   4, // 3570-3573
  3,   1,   1, // 3574-3576
  4,   1,   1, // 3577-3579
  3,   1,   1, // 3580-3582
  3,   2,   1,   1, // 3583-3586
  1,   1, // 3587-3588
  1,   1, // 3589-3590
  3,   1, // 3591-3592
  2, // 3593
  3, // 3594
  1, // 3595
  2,   1, // 3596-3597
  2,   2, // 3598-3599
  2,   2,   2, // 3600-3602
  2,   2,   2, // 3603-3605
  2,   2,   2, // 3606-3608
  2,   2,   1, // 3609-3611
  2,   2,   1,   1, // 3612-3615
  6,   1,   1, // 3616-3618
  5,   1,   1, // 3619-3621
  6,   1,   1,   4, // 3622-3625
  6,   1,   1,   4, // 3626-3629
  6,   1,   1,   4, // 3630-3633
  6,   1,   1,   4, // 3634-3637
  6,   1,   1,   4, // 3638-3641
  6,   1,   1,   4, // 3642-3645
  6,   6,   1,   1, // 3646-3649
  6,   6,   1,   1, // 3650-3653
  6,   6,   1,   1, // 3654-3657
  3,   1,   1, // 3658-3660
  4,   1,   1, // 3661-3663
  3,   1,   1, // 3664-3666
  3,   1, // 3667-3668
  3,   1, // 3669-3670
  4,   1, // 3671-3672
  4,   1,   1, // 3673-3675
  3,   1,   1, // 3676-3678
  3,   1,   1, // 3679-3681
  3,   1,   1, // 3682-3684
  3,   1,   1, // 3685-3687
  3,   1, // 3688-3689
  4,   1,   1, // 3690-3692
  3,   1,   1, // 3693-3695
  3,   2,   1,   1, // 3696-3699
  3,   2,   1, // 3700-3702
  3,   2,   1,   1, // 3703-3706
  3,   2,   1,   1, // 3707-3710
  3,   2,   1, // 3711-3713
  3,   1, // 3714-3715
  3,   1, // 3716-3717
  3,   1, // 3718-3719
  3,   2,   1, // 3720-3722
  3,   1,   1, // 3723-3725
  3,   1, // 3726-3727
  3,   2,   1,   1, // 3728-3731
  1,   1,   1,   1,   3, // 3732-3736
  2,   1,   1,   1,   3, // 3737-3741
  1,   2,   1,   1,   3, // 3742-3746
  1,   1,   3, // 3747-3749
  1,   1,   3, // 3750-3752
  3,   1,   1, // 3753-3755
  3,   1,   1, // 3756-3758
  3,   1,   1, // 3759-3761
  3,   1,   1, // 3762-3764
  3,   1, // 3765-3766
  3,   1, // 3767-3768
  2,   3,   1,   1, // 3769-3772
  2,   3,   1, // 3773-3775
  2,   3,   1,   1, // 3776-3779
  2,   3,   1, // 3780-3782
  3,   1, // 3783-3784
  3,   1, // 3785-3786
  3,   1,   1, // 3787-3789
  2,   3,   1,   1, // 3790-3793
  2, // 3794
  3,   1,   1, // 3795-3797
  3,   2,   1, // 3798-3800
  3,   2,   2, // 3801-3803
  3,   2,   2, // 3804-3806
  3, // 3807
  3,   2,   2, // 3808-3810
  4,   2,   2, // 3811-3813
  4,   2,   1, // 3814-3816
  4,   2,   1, // 3817-3819
  4,   2,   1, // 3820-3822
  4,   2,   1, // 3823-3825
  6,   2, // 3826-3827
  5,   2, // 3828-3829
  4,   1,   1, // 3830-3832
  4,   1,   1, // 3833-3835
  5,   1,   1, // 3836-3838
  3,   2,   1, // 3839-3841
  2,   1,   1, // 3842-3844
  3,   1,   1, // 3845-3847
  2,   1, // 3848-3849
  3,   1, // 3850-3851
  6,   3,   2,   1, // 3852-3855
  6,   3,   2,   1, // 3856-3859
  5,   2, // 3860-3861
  6,   2, // 3862-3863
  4,   2, // 3864-3865
  4,   2, // 3866-3867
  5,   2,   2, // 3868-3870
  6,   2,   2, // 3871-3873
  4,   2,   1, // 3874-3876
  4,   2,   1, // 3877-3879
  7,   3,   1, // 3880-3882
  6,   3,   1, // 3883-3885
  4,   1, // 3886-3887
  4,   1, // 3888-3889
  4,   2,   1, // 3890-3892
  4,   2,   1, // 3893-3895
  5,   1,   1, // 3896-3898
  4,   1,   1, // 3899-3901
  5,   2, // 3902-3903
  6,   2, // 3904-3905
  4,   2,   1, // 3906-3908
  3,   1,   1, // 3909-3911
  4,   1,   1, // 3912-3914
  4,   2,   1, // 3915-3917
  3,   2,   1, // 3918-3920
  3,   1,   2,   1, // 3921-3924
  3,   2,   2,   1, // 3925-3928
  3,   1,   2,   2,   1, // 3929-3933
  4,   2,   2,   3,   1, // 3934-3938
  4,   1,   2,   2,   3,   1, // 3939-3944
  4,   2,   2,   3,   3,   1, // 3945-3950
  4,   1,   2,   2,   3,   3,   1, // 3951-3957
  2,   2,   1,   1, // 3958-3961
  3,   3,   1,   1, // 3962-3965
  4,   4,   1,   1, // 3966-3969
  4,   1, // 3970-3971
  7,   1, // 3972-3973
  4,   1, // 3974-3975
  1,   1, // 3976-3977
  4,   2,   1, // 3978-3980
  5,   2,   2, // 3981-3983
  6,   2,   2, // 3984-3986
  4,   2,   1, // 3987-3989
  7,   1,   1, // 3990-3992
  5,   2,   2, // 3993-3995
  9,   1,   1, // 3996-3998
  9,   2,   2, // 3999-4001
  10,   2,   2, // 4002-4004
  6,   2,   2, // 4005-4007
  7,   2,   1, // 4008-4010
  7,   1,   1, // 4011-4013
  5,   2,   1, // 4014-4016
  6,   2,   1, // 4017-4019
  7,   2,   2, // 4020-4022
  5,   2,   2, // 4023-4025
  6,   2,   2, // 4026-4028
  9,   2,   1, // 4029-4031
  11,   1,   1, // 4032-4034
  19,   2,   1,   1, // 4035-4038
  7,   2,   1,   1, // 4039-4042
  19,   2,   1,   1, // 4043-4046
  7,   3,   2,   1, // 4047-4050
  6,   3,   2,   2, // 4051-4054
  7,   2,   1,   1, // 4055-4058
  9,   3,   2,   2, // 4059-4062
  10,   3,   2,   2, // 4063-4066
  9,   3,   2,   1, // 4067-4070
  7,   3,   2,   2, // 4071-4074
  9,   3,   2,   2, // 4075-4078
  10,   3,   2,   2, // 4079-4082
  5,   1, // 4083-4084
  7,   1, // 4085-4086
  6,   2, // 4087-4088
  5,   2, // 4089-4090
  8,   1, // 4091-4092
  7,   1, // 4093-4094
  8,   1, // 4095-4096
  7,   1, // 4097-4098
  8,   1, // 4099-4100
  7,   1, // 4101-4102
  4,   1, // 4103-4104
  7,   1, // 4105-4106
  3, // 4107
  3,   2,   1, // 4108-4110
  4,   1, // 4111-4112
  2,   1, // 4113-4114
  4,   1, // 4115-4116
  2,   1, // 4117-4118
  3,   1, // 4119-4120
  2,   1, // 4121-4122
  20,   1, // 4123-4124
  2,   1, // 4125-4126
  3,   1,   1, // 4127-4129
  20,   20,   1, // 4130-4132
  2,   1,   1, // 4133-4135
  2,   1,   1, // 4136-4138
  20,   1, // 4139-4140
  20,   1, // 4141-4142
  20, // 4143
  20, // 4144
  20, // 4145
  2,   1, // 4146-4147
  2,   1, // 4148-4149
  1,   1, // 4150-4151
  1,   1, // 4152-4153
  1,   1,   1,   2, // 4154-4157
  1,   1,   1,   1, // 4158-4161
  1,   1,   1,   2, // 4162-4165
  2,   1,   1,   1,   2, // 4166-4170
  1,   1,   1,   1, // 4171-4174
  2,   1,   1,   1,   1, // 4175-4179
  2,   1, // 4180-4181
  2,   2,   1, // 4182-4184
  2,   2,   1, // 4185-4187
  2,   2,   2,   1, // 4188-4191
  2,   2,   3,   1, // 4192-4195
  2,   2,   2,   1, // 4196-4199
  2,   2,   3,   3,   1, // 4200-4204
  2,   2,   2,   1, // 4205-4208
  2,   2,   1, // 4209-4211
  2,   2,   3,   3,   1, // 4212-4216
  2,   2,   2,   1,   1,   1, // 4217-4222
  2,   2,   3,   3,   2,   1, // 4223-4228
  3,   3,   4,   1, // 4229-4232
  3,   3,   4,   1, // 4233-4236
  3,   3,   4,   2,   1, // 4237-4241
  3,   3,   4,   2,   1, // 4242-4246
  3,   3,   4,   4,   1, // 4247-4251
  3,   3,   4,   4,   1, // 4252-4256
  3,   3,   4,   4,   2,   1, // 4257-4262
  3,   3,   4,   4,   2,   1, // 4263-4268
  2,   1, // 4269-4270
  3,   1,   1,   1, // 4271-4274
  2,   2,   1,   1, // 4275-4278
  3,   2,   1,   1,   1,   1, // 4279-4284
  2,   2,   1, // 4285-4287
  3,   3,   1,   1,   1,   1, // 4288-4293
  3,   3,   2,   1,   1,   1,   1,   1, // 4294-4301
  2,   2,   2,   1,   1, // 4302-4306
  3,   3,   2,   1,   1,   1,   1,   1, // 4307-4314
  2,   2,   3,   1, // 4315-4318
  4,   4,   5,   1,   1,   1,   1,   2, // 4319-4326
  2,   2,   3,   2,   1,   1, // 4327-4332
  4,   4,   5,   2,   1,   1,   1,   1,   1,   2, // 4333-4342
  2,   2,   3,   2,   1,   1, // 4343-4348
  4,   4,   5,   2,   1,   1,   1,   1,   1,   2, // 4349-4358
  2,   2,   3,   3,   1, // 4359-4363
  4,   4,   5,   5,   1,   1,   1,   1,   2,   2, // 4364-4373
  2,   2,   3,   3,   2,   1,   1, // 4374-4380
  4,   4,   5,   5,   2,   1,   1,   1,   1,   1,   2,   2, // 4381-4392
  2,   2,   3,   3,   2,   1,   1, // 4393-4399
  4,   4,   5,   5,   2,   1,   1,   1,   1,   1,   2,   2, // 4400-4411
  1,   1,   1, // 4412-4414
  1,   1,   1,   1, // 4415-4418
  2,   2,   1, // 4419-4421
  2,   2,   2,   1, // 4422-4425
  1,   1,   1,   1,   2, // 4426-4430
  2,   2,   3,   2,   1, // 4431-4435
  2,   1,   1,   1,   1,   1,   2, // 4436-4442
  1,   1,   1,   1,   2,   2, // 4443-4448
  2,   2,   3,   3,   2,   1, // 4449-4454
  2,   1,   1,   1,   1,   1,   2,   2, // 4455-4462
  1,   1,   1,   1, // 4463-4466
  2,   2,   1, // 4467-4469
  1,   1,   1,   1,   2,   2, // 4470-4475
  2,   1,   1,   1,   1,   1,   2,   2, // 4476-4483
  2,   2,   1, // 4484-4486
  1,   1,   1,   1,   2, // 4487-4491
  2,   1,   1,   1,   1,   1,   2, // 4492-4498
  1,   1,   1,   1,   2,   2, // 4499-4504
  2,   1,   1,   1,   1,   1,   2,   2, // 4505-4512
  1,   1,   1, // 4513-4515
  2,   1,   1,   1,   1, // 4516-4520
  1,   1,   1,   1, // 4521-4524
  2,   1,   1,   1,   1,   1, // 4525-4530
  1,   1,   1,   1,   2, // 4531-4535
  2,   1,   1,   1,   1,   1,   2, // 4536-4542
  1,   1,   1,   1,   2,   2, // 4543-4548
  2,   1,   1,   1,   1,   1,   2,   2, // 4549-4556
  20,   1,   1, // 4557-4559
  19,   1, // 4560-4561
  29,   1,   1, // 4562-4564
  29,   1, // 4565-4566
  1,   1, // 4567-4568
  1,   1,   1, // 4569-4571
  2,   1,   1,   1, // 4572-4575
  2,   1,   1,   1, // 4576-4579
  2,   1,   1,   1, // 4580-4583
  1,   1, // 4584-4585
  1,   1,   1, // 4586-4588
  2,   1,   1,   1, // 4589-4592
  2,   1,   1,   1, // 4593-4596
  2,   1, // 4597-4598
  1,   1, // 4599-4600
  1, // 4601
  1,   1, // 4602-4603
  1,   1,   1, // 4604-4606
  1,   1,   1, // 4607-4609
  2,   1, // 4610-4611
  2,   1, // 4612-4613
  1, // 4614
  1,   1,   1,   1,   3, // 4615-4619
  2,   1,   1,   1,   3, // 4620-4624
  1,   1,   1,   1,   3, // 4625-4629
  3,   1,   1,   1, // 4630-4633
  3,   1,   1, // 4634-4636
  3,   1,   1, // 4637-4639
  5,   1,   1, // 4640-4642
  3,   4,   1,   1, // 4643-4646
  3,   4,   1,   1, // 4647-4650
  3,   1, // 4651-4652
  4,   1, // 4653-4654
  3,   1,   1,   1, // 4655-4658
  3,   1,   1, // 4659-4661
  3,   1,   1, // 4662-4664
  5,   1,   1, // 4665-4667
  4,   1,   1,   1, // 4668-4671
  1, // 4672
  1, // 4673
  2, // 4674
  1,   1, // 4675-4676
  2,   1,   1, // 4677-4679
  3, // 4680
  5, // 4681
  2, // 4682
  1, // 4683
  1, // 4684
  1, // 4685
  4,   1,   1, // 4686-4688
  1, // 4689
  1, // 4690
  1, // 4691
  1,   1,   1, // 4692-4694
  1,   1,   1, // 4695-4697
  1,   1,   1, // 4698-4700
  2,   1,   1, // 4701-4703
  2,   1,   1, // 4704-4706
  1,   1, // 4707-4708
  14,   1,   1, // 4709-4711
  3,   1,   1,   1, // 4712-4715
  5,   6,   1,   1, // 4716-4719
  3,   1,   1, // 4720-4722
  5,   5,   1,   1, // 4723-4726
  2, // 4727
  1,   1,   1,   1, // 4728-4731
  1,   1,   1, // 4732-4734
  1,   1,   1,   1, // 4735-4738
  1,   1,   1, // 4739-4741
  1,   1,   1, // 4742-4744
  1,   1,   1,   1, // 4745-4748
  1,   1,   1, // 4749-4751
  1,   1,   1, // 4752-4754
  1,   1,   1, // 4755-4757
  1,   1, // 4758-4759
  1, // 4760
  1,   1, // 4761-4762
  1,   1,   1, // 4763-4765
  1,   1,   1, // 4766-4768
  4,   1,   1,   1, // 4769-4772
  4,   1,   1,   1, // 4773-4776
  4,   1,   1, // 4777-4779
  4,   1,   1, // 4780-4782
  4,   1,   1, // 4783-4785
  4,   1,   1, // 4786-4788
  2,   1, // 4789-4790
  2,   1, // 4791-4792
  4,   1, // 4793-4794
  4,   1, // 4795-4796
  2,   1,   1, // 4797-4799
  4,   1,   1, // 4800-4802
  2,   1,   1, // 4803-4805
  2,   1,   1, // 4806-4808
  2,   1,   1, // 4809-4811
  2,   1,   1, // 4812-4814
  2,   1,   1, // 4815-4817
  2, // 4818
  2,   1,   1, // 4819-4821
  2,   1,   1, // 4822-4824
  1,   1, // 4825-4826
  1,   1, // 4827-4828
  6,   1, // 4829-4830
  4,   1, // 4831-4832
  4,   1, // 4833-4834
  4,   1, // 4835-4836
  32,   1,   1, // 4837-4839
  17,   1,   1, // 4840-4842
  6,   1, // 4843-4844
  2,   1, // 4845-4846
  2,   1, // 4847-4848
  2,   1,   1, // 4849-4851
  2,   1,   1, // 4852-4854
  12,   1,   1, // 4855-4857
  8,   1,   1, // 4858-4860
  8,   1,   1, // 4861-4863
  8,   1,   1, // 4864-4866
  3,   1, // 4867-4868
  4,   1,   1, // 4869-4871
  2,   1,   1,   1,   4, // 4872-4876
  1,   1,   1,   4, // 4877-4880
  4,   1, // 4881-4882
  4,   1, // 4883-4884
  12,   1,   1, // 4885-4887
  4,   1,   1,   1, // 4888-4891
  4,   1,   1,   1, // 4892-4895
  8,   1,   1, // 4896-4898
  8,   1,   1, // 4899-4901
  8,   1,   1, // 4902-4904
  4,   1,   1,   1, // 4905-4908
  4,   1,   1,   1, // 4909-4912
  4,   1, // 4913-4914
  4,   1, // 4915-4916
  2,   1, // 4917-4918
  3,   4,   1, // 4919-4921
  3,   1, // 4922-4923
  6,   1, // 4924-4925
  6,   1,   1, // 4926-4928
  4,   1,   1, // 4929-4931
  4,   1,   1, // 4932-4934
  4,   1,   1, // 4935-4937
  4,   1,   1, // 4938-4940
  4,   1,   1, // 4941-4943
  4,   1,   1, // 4944-4946
  4,   1,   1, // 4947-4949
  2,   1,   1, // 4950-4952
  4,   1,   1, // 4953-4955
  4,   1,   1, // 4956-4958
  4,   1,   1, // 4959-4961
  4,   1, // 4962-4963
  4,   1,   1, // 4964-4966
  4,   1,   1, // 4967-4969
  8,   1,   1, // 4970-4972
  8,   1,   1, // 4973-4975
  6,   1, // 4976-4977
  4,   1, // 4978-4979
  4,   1, // 4980-4981
  4,   1, // 4982-4983
  4,   1, // 4984-4985
  32,   1,   1, // 4986-4988
  17,   1, // 4989-4990
  2,   1,   1,   1, // 4991-4994
  1,   1,   1, // 4995-4997
  1,   1, // 4998-4999
  1,   1, // 5000-5001
  2,   1,   1, // 5002-5004
  2,   1,   1, // 5005-5007
  4,   1,   3,   3, // 5008-5011
  6,   1,   3,   5,   5, // 5012-5016
  8,   1,   3,   5,   7,   7, // 5017-5022
  2,   1,   1, // 5023-5025
  4,   1,   3,   3, // 5026-5029
  6,   1,   3,   5,   5, // 5030-5034
  8,   1,   3,   5,   7,   7, // 5035-5040
  4,   1, // 5041-5042
  4,   1, // 5043-5044
  4,   1, // 5045-5046
  4,   1, // 5047-5048
  3,   4,   3,   4, // 5049-5052
  3,   4,   3,   4, // 5053-5056
  3,   4,   3,   4, // 5057-5060
  2,   1,   1, // 5061-5063
  1,   1, // 5064-5065
  1,   1, // 5066-5067
  1, // 5068
  1,   1, // 5069-5070
  1,   1, // 5071-5072
  3,   1, // 5073-5074
  3,   4,   1, // 5075-5077
  1,   1, // 5078-5079
  1, // 5080
  1, // 5081
  2,   1,   1, // 5082-5084
  1,   1, // 5085-5086
  1,   1, // 5087-5088
  1,   1,   1,   1, // 5089-5092
  1,   1, // 5093-5094
  1, // 5095
  1,   1, // 5096-5097
  1,   1, // 5098-5099
  1,   1,   1, // 5100-5102
  1,   1, // 5103-5104
  1,   1,   1, // 5105-5107
  1,   1,   3, // 5108-5110
  1,   1,   3, // 5111-5113
  1,   1, // 5114-5115
  1,   1, // 5116-5117
  1,   1,   1, // 5118-5120
  2,   1,   1,   1, // 5121-5124
  2,   1,   1,   1, // 5125-5128
  2,   1,   1, // 5129-5131
  1, // 5132
  1, // 5133
  1, // 5134
  1, // 5135
  2, // 5136
  2, // 5137
  3, // 5138
  5, // 5139
  2,   1, // 5140-5141
  4,   1,   1,   1, // 5142-5145
  4,   1,   1, // 5146-5148
  5,   6,   1,   1, // 5149-5152
  5,   5,   1,   1, // 5153-5156
  3,   1,   1, // 5157-5159
  3,   1,   1,   1, // 5160-5163
  3,   1,   1, // 5164-5166
  5,   1,   1, // 5167-5169
  3,   1,   1, // 5170-5172
  3,   1,   1,   1, // 5173-5176
  1,   1, // 5177-5178
  1,   1, // 5179-5180
  2, // 5181
  2, // 5182
  3, // 5183
  1, // 5184
  2,   1, // 5185-5186
  1,   1, // 5187-5188
  1,   1,   1, // 5189-5191
  1,   1,   1, // 5192-5194
  1,   1,   1, // 5195-5197
  1,   1,   1, // 5198-5200
  1,   1,   1,   1, // 5201-5204
  4,   1,   1, // 5205-5207
  3,   1,   1, // 5208-5210
  4,   1,   1,   1, // 5211-5214
  4,   1,   1,   1, // 5215-5218
  4,   1,   1,   1, // 5219-5222
  3,   1,   1,   1, // 5223-5226
  4,   1,   1,   1, // 5227-5230
  4,   1,   1,   1, // 5231-5234
  5,   5,   1,   1, // 5235-5238
  5,   5,   1,   1, // 5239-5242
  5,   6,   1,   1, // 5243-5246
  14,   1,   1, // 5247-5249
  3,   1,   1, // 5250-5252
  5,   1,   1, // 5253-5255
  3,   1,   1, // 5256-5258
  3,   1, // 5259-5260
  3,   1, // 5261-5262
  4,   1, // 5263-5264
  5,   1,   1, // 5265-5267
  3,   1,   1, // 5268-5270
  3,   1,   1, // 5271-5273
  3,   1,   1, // 5274-5276
  3,   1,   1, // 5277-5279
  3,   1, // 5280-5281
  5,   1,   1, // 5282-5284
  3,   1,   1, // 5285-5287
  3,   1,   1,   1, // 5288-5291
  3,   1,   1, // 5292-5294
  3,   1,   1,   1, // 5295-5298
  3,   1,   1,   1, // 5299-5302
  3,   1,   1, // 5303-5305
  3,   1, // 5306-5307
  3,   1, // 5308-5309
  3,   1, // 5310-5311
  3,   1,   1, // 5312-5314
  3,   4,   1,   1, // 5315-5318
  3,   4,   1, // 5319-5321
  3,   4,   1,   1, // 5322-5325
  1,   1,   1,   1,   3, // 5326-5330
  2,   1,   1,   1,   3, // 5331-5335
  1,   1,   1,   1,   3, // 5336-5340
  1,   1,   3, // 5341-5343
  1,   1,   3, // 5344-5346
  1,   1,   1, // 5347-5349
  1,   1,   1, // 5350-5352
  1,   1,   1, // 5353-5355
  1,   1,   1, // 5356-5358
  1,   1, // 5359-5360
  1,   1, // 5361-5362
  1,   1,   1,   1, // 5363-5366
  1,   1,   1, // 5367-5369
  1,   1,   1,   1, // 5370-5373
  1,   1,   1, // 5374-5376
  1,   1, // 5377-5378
  1,   1, // 5379-5380
  1,   1,   1, // 5381-5383
  1,   1,   1,   1, // 5384-5387
  2, // 5388
  2,   1,   1, // 5389-5391
  2,   1,   1, // 5392-5394
  2,   1,   1, // 5395-5397
  2,   1,   1, // 5398-5400
  2, // 5401
  2,   1,   1, // 5402-5404
  2,   1,   1, // 5405-5407
  4,   1,   1, // 5408-5410
  4,   1,   1, // 5411-5413
  4,   1,   1, // 5414-5416
  4,   1,   1, // 5417-5419
  2,   1, // 5420-5421
  2,   1, // 5422-5423
  2,   1,   1, // 5424-5426
  4,   1,   1, // 5427-5429
  4,   1,   1, // 5430-5432
  2,   1,   1, // 5433-5435
  2,   1,   1, // 5436-5438
  2,   1,   1, // 5439-5441
  2,   1, // 5442-5443
  2,   1, // 5444-5445
  4,   1,   1,   1, // 5446-5449
  4,   1,   1,   1, // 5450-5453
  2,   1, // 5454-5455
  2,   1, // 5456-5457
  4,   1, // 5458-5459
  4,   1, // 5460-5461
  4,   1,   1, // 5462-5464
  4,   1,   1, // 5465-5467
  4,   1,   1, // 5468-5470
  4,   1,   1, // 5471-5473
  4,   1,   1, // 5474-5476
  4,   1,   1, // 5477-5479
  4,   1, // 5480-5481
  4,   1, // 5482-5483
  4,   1,   1, // 5484-5486
  4,   1,   1, // 5487-5489
  4,   1,   1, // 5490-5492
  4,   1,   1, // 5493-5495
  2,   1, // 5496-5497
  2,   1, // 5498-5499
  4,   1,   1, // 5500-5502
  2,   1,   1, // 5503-5505
  4,   1,   1, // 5506-5508
  4,   1,   1, // 5509-5511
  2,   1,   1, // 5512-5514
  2,   1,   1, // 5515-5517
  4,   1,   3,   3, // 5518-5521
  4,   1,   3,   3, // 5522-5525
  6,   1,   3,   5,   5, // 5526-5530
  6,   1,   3,   5,   5, // 5531-5535
  8,   1,   3,   5,   7,   7, // 5536-5541
  8,   1,   3,   5,   7,   7, // 5542-5547
  3,   4,   3,   4, // 5548-5551
  3,   4,   3,   4, // 5552-5555
  3,   4,   3,   4, // 5556-5559
  2,   1, // 5560-5561
  2,   1, // 5562-5563
  1,   1, // 5564-5565
  1,   1, // 5566-5567
  4,   1,   1, // 5568-5570
  4,   1,   1, // 5571-5573
  4,   1,   1, // 5574-5576
  4,   1,   1, // 5577-5579
  2,   1,   1, // 5580-5582
  4,   1,   1, // 5583-5585
  2,   1,   1, // 5586-5588
  8,   1,   1, // 5589-5591
  8,   1,   1, // 5592-5594
  4,   1,   1, // 5595-5597
  4,   1,   1, // 5598-5600
  4,   1,   1, // 5601-5603
  4,   1,   1, // 5604-5606
  4,   1,   1, // 5607-5609
  4,   1,   1, // 5610-5612
  4,   1,   1, // 5613-5615
  4,   1,   1, // 5616-5618
  4,   1,   1, // 5619-5621
  6,   1,   1, // 5622-5624
  12,   1,   1, // 5625-5627
  8,   1,   1, // 5628-5630
  12,   1,   1, // 5631-5633
  4,   1,   1,   1, // 5634-5637
  4,   1,   1,   1, // 5638-5641
  8,   1,   1, // 5642-5644
  8,   1,   1, // 5645-5647
  8,   1,   1, // 5648-5650
  4,   1,   1,   1, // 5651-5654
  4,   1,   1,   1, // 5655-5658
  8,   1,   1, // 5659-5661
  8,   1,   1, // 5662-5664
  6,   1, // 5665-5666
  4,   1, // 5667-5668
  4,   1, // 5669-5670
  4,   1, // 5671-5672
  2,   1, // 5673-5674
  2,   1, // 5675-5676
  4,   1, // 5677-5678
  4,   1, // 5679-5680
  4,   1, // 5681-5682
  4,   1, // 5683-5684
  4,   1, // 5685-5686
  4,   1, // 5687-5688
  2,   1, // 5689-5690
  2,   1, // 5691-5692
  2, // 5693
  2,   1,   1, // 5694-5696
  4,   1, // 5697-5698
  2,   1, // 5699-5700
  4,   1, // 5701-5702
  2,   1, // 5703-5704
  2,   1, // 5705-5706
  6,   1, // 5707-5708
  3,   1, // 5709-5710
  6,   1, // 5711-5712
  6,   1, // 5713-5714
  3,   4,   1, // 5715-5717
  4,   1, // 5718-5719
  4,   1, // 5720-5721
  3,   1, // 5722-5723
  3,   1, // 5724-5725
  1, // 5726
  1, // 5727
  1, // 5728
  4,   1, // 5729-5730
  4,   1, // 5731-5732
  1,   1, // 5733-5734
  1,   1, // 5735-5736
  1,   1,   1,   4, // 5737-5740
  1,   1,   1, // 5741-5743
  1,   1,   1,   4, // 5744-5747
  2,   1,   1,   1,   4, // 5748-5752
  1,   1,   1, // 5753-5755
  2,   1,   1,   1, // 5756-5759
  17,   1,   1, // 5760-5762
  17,   1, // 5763-5764
  32,   1,   1, // 5765-5767
  32,   1,   1, // 5768-5770
  0 // End operand cycles
};
extern const unsigned ARMForwardingPaths[] = {
 0, // No itinerary
 0,  0, // 1-2
 0,  0,  0, // 3-5
 0,  0,  0,  0, // 6-9
 0,  0,  0,  0, // 10-13
 0,  0,  0,  0, // 14-17
 0,  0, // 18-19
 0,  0,  0, // 20-22
 0,  0,  0,  0, // 23-26
 0,  0,  0,  0, // 27-30
 0,  0, // 31-32
 0,  0, // 33-34
 0, // 35
 0,  0, // 36-37
 0,  0,  0, // 38-40
 0,  0,  0, // 41-43
 0,  0, // 44-45
 0,  0, // 46-47
 0, // 48
 0,  0,  0,  0,  0, // 49-53
 0,  0,  0,  0,  0, // 54-58
 0,  0,  0,  0,  0, // 59-63
 0,  0,  0,  0, // 64-67
 0,  0,  0, // 68-70
 0,  0,  0, // 71-73
 0,  0,  0, // 74-76
 0,  0,  0, // 77-79
 0,  0,  0,  0, // 80-83
 0,  0, // 84-85
 0,  0, // 86-87
 0,  0,  0,  0, // 88-91
 0,  0,  0, // 92-94
 0,  0,  0, // 95-97
 0,  0,  0, // 98-100
 0,  0,  0,  0, // 101-104
 0, // 105
 0, // 106
 0, // 107
 0,  0, // 108-109
 0,  0,  0, // 110-112
 0, // 113
 0, // 114
 0, // 115
 0,  0, // 116-117
 0,  0,  0, // 118-120
 0,  0, // 121-122
 0,  0,  0, // 123-125
 0, // 126
 0,  0, // 127-128
 0,  0,  0, // 129-131
 0,  0,  0, // 132-134
 0,  0,  0, // 135-137
 0,  0,  0, // 138-140
 0,  0,  0, // 141-143
 0,  0,  0, // 144-146
 0,  0,  0,  0, // 147-150
 0,  0,  0,  0, // 151-154
 0,  0,  0, // 155-157
 0,  0,  0, // 158-160
 0, // 161
 0,  0,  0,  0, // 162-165
 0,  0,  0, // 166-168
 0,  0,  0,  0, // 169-172
 0,  0,  0, // 173-175
 0,  0,  0, // 176-178
 0,  0,  0,  0, // 179-182
 0,  0,  0, // 183-185
 0,  0,  0, // 186-188
 0,  0,  0, // 189-191
 0,  0, // 192-193
 0, // 194
 0,  0, // 195-196
 0,  0,  0, // 197-199
 0,  0,  0, // 200-202
 0,  0,  0, // 203-205
 0,  0,  0, // 206-208
 0,  0, // 209-210
 0,  0, // 211-212
 0,  0, // 213-214
 0,  0, // 215-216
 0,  0,  0, // 217-219
 0,  0,  0, // 220-222
 0,  0,  0,  0, // 223-226
 0,  0,  0,  0, // 227-230
 0,  0,  0,  0,  0, // 231-235
 0,  0,  0,  0, // 236-239
 0,  0,  0, // 240-242
 0,  0,  0, // 243-245
 0,  0,  0,  0, // 246-249
 0,  0,  0,  0, // 250-253
 0,  0,  0, // 254-256
 0,  0,  0, // 257-259
 0,  0, // 260-261
 0,  0, // 262-263
 0,  0,  0, // 264-266
 0,  0,  0, // 267-269
 0,  0, // 270-271
 0,  0, // 272-273
 0,  0, // 274-275
 0,  0, // 276-277
 0,  0,  0, // 278-280
 0,  0,  0, // 281-283
 0,  0,  0,  0,  0, // 284-288
 0,  0,  0,  0, // 289-292
 0,  0,  0, // 293-295
 0,  0,  0, // 296-298
 0,  0, // 299-300
 0,  0, // 301-302
 0,  0, // 303-304
 0,  0, // 305-306
 0,  0,  0, // 307-309
 0,  0, // 310-311
 0,  0, // 312-313
 0, // 314
 0,  0, // 315-316
 0,  0, // 317-318
 0,  0, // 319-320
 0,  0, // 321-322
 0,  0, // 323-324
 0, // 325
 0,  0, // 326-327
 0,  0, // 328-329
 0,  0, // 330-331
 0,  0,  0,  0, // 332-335
 0,  0, // 336-337
 0, // 338
 0,  0, // 339-340
 0,  0, // 341-342
 0,  0,  0, // 343-345
 0,  0, // 346-347
 0,  0,  0, // 348-350
 0,  0,  0, // 351-353
 0,  0,  0, // 354-356
 0,  0, // 357-358
 0,  0, // 359-360
 0,  0,  0, // 361-363
 0,  0,  0,  0, // 364-367
 0,  0,  0,  0, // 368-371
 0,  0,  0, // 372-374
 0,  0,  0, // 375-377
 0,  0, // 378-379
 0,  0,  0, // 380-382
 0,  0, // 383-384
 0, // 385
 0, // 386
 0, // 387
 0, // 388
 0,  0, // 389-390
 0,  0,  0,  0, // 391-394
 0,  0,  0, // 395-397
 0,  0,  0,  0, // 398-401
 0,  0,  0, // 402-404
 0,  0,  0, // 405-407
 0,  0,  0,  0, // 408-411
 0,  0,  0, // 412-414
 0,  0,  0, // 415-417
 0,  0,  0, // 418-420
 0,  0,  0,  0, // 421-424
 0,  0, // 425-426
 0,  0, // 427-428
 0, // 429
 0, // 430
 0, // 431
 0, // 432
 0,  0, // 433-434
 0,  0, // 435-436
 0,  0,  0, // 437-439
 0,  0,  0, // 440-442
 0,  0,  0, // 443-445
 0,  0,  0, // 446-448
 0,  0,  0,  0, // 449-452
 0,  0,  0, // 453-455
 0,  0,  0, // 456-458
 0,  0,  0,  0, // 459-462
 0,  0,  0,  0, // 463-466
 0,  0,  0,  0, // 467-470
 0,  0,  0,  0, // 471-474
 0,  0,  0,  0, // 475-478
 0,  0,  0,  0, // 479-482
 0,  0,  0, // 483-485
 0,  0,  0, // 486-488
 0,  0,  0,  0, // 489-492
 0,  0,  0, // 493-495
 0,  0,  0, // 496-498
 0,  0,  0, // 499-501
 0,  0, // 502-503
 0,  0, // 504-505
 0,  0, // 506-507
 0,  0,  0, // 508-510
 0,  0,  0, // 511-513
 0,  0,  0, // 514-516
 0,  0,  0, // 517-519
 0,  0,  0, // 520-522
 0,  0, // 523-524
 0,  0,  0, // 525-527
 0,  0,  0, // 528-530
 0,  0,  0,  0, // 531-534
 0,  0,  0, // 535-537
 0,  0,  0,  0, // 538-541
 0,  0,  0,  0, // 542-545
 0,  0,  0, // 546-548
 0,  0, // 549-550
 0,  0, // 551-552
 0,  0, // 553-554
 0,  0,  0, // 555-557
 0,  0,  0, // 558-560
 0,  0, // 561-562
 0,  0,  0,  0, // 563-566
 0,  0,  0,  0,  0, // 567-571
 0,  0,  0,  0,  0, // 572-576
 0,  0,  0,  0,  0, // 577-581
 0,  0,  0, // 582-584
 0,  0,  0, // 585-587
 0,  0,  0, // 588-590
 0,  0,  0, // 591-593
 0,  0,  0, // 594-596
 0,  0,  0, // 597-599
 0,  0, // 600-601
 0,  0, // 602-603
 0,  0,  0,  0, // 604-607
 0,  0,  0, // 608-610
 0,  0,  0,  0, // 611-614
 0,  0,  0, // 615-617
 0,  0, // 618-619
 0,  0, // 620-621
 0,  0,  0, // 622-624
 0,  0,  0,  0, // 625-628
 0, // 629
 0,  0, // 630-631
 0,  0, // 632-633
 0,  0, // 634-635
 0,  0, // 636-637
 0,  0,  0, // 638-640
 0,  0,  0, // 641-643
 0,  0,  0, // 644-646
 0,  0,  0, // 647-649
 0,  0,  0,  0, // 650-653
 0,  0,  0,  0, // 654-657
 0,  0,  0,  0, // 658-661
 0,  0,  0,  0, // 662-665
 0,  0, // 666-667
 0,  0, // 668-669
 0,  0, // 670-671
 0,  0, // 672-673
 0,  0, // 674-675
 0,  0, // 676-677
 0,  0, // 678-679
 0,  0, // 680-681
 0,  0, // 682-683
 0,  0, // 684-685
 0,  0, // 686-687
 0,  0, // 688-689
 0,  0,  0, // 690-692
 0,  0,  0, // 693-695
 0,  0,  0, // 696-698
 0, // 699
 0, // 700
 0, // 701
 0,  0,  0, // 702-704
 0,  0,  0, // 705-707
 0,  0,  0, // 708-710
 0,  0,  0, // 711-713
 0,  0,  0,  0, // 714-717
 0,  0,  0,  0, // 718-721
 0,  0,  0,  0, // 722-725
 0,  0,  0,  0,  0, // 726-730
 0,  0,  0,  0, // 731-734
 0,  0,  0,  0,  0, // 735-739
 0,  0,  0, // 740-742
 0,  0,  0, // 743-745
 0,  0,  0, // 746-748
 0,  0,  0, // 749-751
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 752-753
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 754-756
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, // 757-760
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, // 761-764
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, // 765-768
 0,  0, // 769-770
 0,  0,  0, // 771-773
 0,  0,  0,  0, // 774-777
 0,  0,  0,  0, // 778-781
 0,  0, // 782-783
 0,  0, // 784-785
CortexA9ItinerariesBypass::A9_LdBypass, // 786
CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 787-788
CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, // 789-791
CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, // 792-794
 0,  0, // 795-796
 0,  0, // 797-798
 0, // 799
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 800-804
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 805-809
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 810-814
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0,  0, // 815-818
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 819-821
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 822-824
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 825-827
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0,  0, // 828-831
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0,  0, // 832-835
CortexA9ItinerariesBypass::A9_LdBypass,  0, // 836-837
 0,  0, // 838-839
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0,  0, // 840-843
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 844-846
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 847-849
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 850-852
 0,  0,  0,  0, // 853-856
 0, // 857
 0, // 858
 0, // 859
 0,  0, // 860-861
 0,  0,  0, // 862-864
 0, // 865
 0, // 866
 0, // 867
 0,  0, // 868-869
 0,  0,  0, // 870-872
 0,  0, // 873-874
 0,  0,  0, // 875-877
 0, // 878
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 879-880
 0,  0,  0, // 881-883
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 884-886
 0,  0,  0, // 887-889
 0,  0,  0, // 890-892
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::NoBypass, // 893-895
 0,  0,  0, // 896-898
 0,  0, // 899-900
 0,  0,  0,  0, // 901-904
 0,  0,  0,  0, // 905-908
 0,  0,  0, // 909-911
 0,  0,  0,  0, // 912-915
 0, // 916
 0,  0,  0,  0, // 917-920
 0,  0,  0, // 921-923
 0,  0,  0,  0, // 924-927
 0,  0,  0, // 928-930
 0,  0,  0, // 931-933
 0,  0,  0,  0, // 934-937
 0,  0,  0, // 938-940
 0,  0,  0, // 941-943
 0,  0,  0, // 944-946
 0,  0, // 947-948
 0, // 949
 0,  0, // 950-951
 0,  0,  0, // 952-954
 0,  0,  0, // 955-957
 0,  0,  0,  0, // 958-961
 0,  0,  0,  0, // 962-965
 0,  0,  0, // 966-968
 0,  0,  0, // 969-971
 0,  0,  0, // 972-974
 0,  0,  0, // 975-977
 0,  0, // 978-979
 0,  0, // 980-981
 0,  0, // 982-983
 0,  0, // 984-985
 0,  0,  0, // 986-988
 0,  0,  0, // 989-991
 0,  0,  0, // 992-994
 0,  0,  0, // 995-997
 0,  0,  0, // 998-1000
 0,  0,  0, // 1001-1003
 0,  0,  0, // 1004-1006
 0, // 1007
 0,  0,  0, // 1008-1010
 0,  0,  0, // 1011-1013
 0,  0, // 1014-1015
 0,  0, // 1016-1017
 0,  0, // 1018-1019
 0,  0, // 1020-1021
 0,  0, // 1022-1023
 0,  0, // 1024-1025
 0,  0,  0, // 1026-1028
 0,  0,  0, // 1029-1031
 0,  0, // 1032-1033
 0,  0, // 1034-1035
 0,  0, // 1036-1037
 0,  0,  0, // 1038-1040
 0,  0,  0, // 1041-1043
 0,  0,  0,  0, // 1044-1047
 0,  0,  0,  0, // 1048-1051
 0,  0,  0,  0, // 1052-1055
 0,  0,  0,  0, // 1056-1059
 0,  0, // 1060-1061
 0,  0,  0, // 1062-1064
 0,  0, // 1065-1066
 0,  0,  0,  0, // 1067-1070
 0,  0,  0,  0, // 1071-1074
 0,  0,  0,  0,  0,  0, // 1075-1080
 0,  0, // 1081-1082
 0,  0,  0,  0,  0, // 1083-1087
 0,  0,  0,  0, // 1088-1091
 0,  0,  0,  0, // 1092-1095
 0,  0,  0, // 1096-1098
 0,  0,  0, // 1099-1101
 0,  0,  0, // 1102-1104
 0,  0,  0,  0,  0, // 1105-1109
 0,  0,  0,  0,  0,  0, // 1110-1115
 0,  0,  0,  0,  0,  0,  0,  0, // 1116-1123
 0,  0,  0, // 1124-1126
 0,  0,  0,  0,  0,  0, // 1127-1132
 0,  0,  0,  0,  0, // 1133-1137
 0,  0,  0,  0,  0,  0, // 1138-1143
 0,  0,  0,  0, // 1144-1147
 0,  0,  0,  0,  0,  0, // 1148-1153
 0,  0,  0,  0,  0,  0,  0,  0, // 1154-1161
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 1162-1171
 0,  0,  0,  0, // 1172-1175
 0,  0,  0,  0,  0, // 1176-1180
 0,  0,  0,  0,  0, // 1181-1185
 0,  0,  0,  0,  0,  0,  0, // 1186-1192
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 1193-1202
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 1203-1214
 0,  0,  0,  0,  0, // 1215-1219
 0,  0,  0,  0,  0,  0, // 1220-1225
 0,  0,  0,  0, // 1226-1229
 0,  0,  0,  0, // 1230-1233
 0,  0, // 1234-1235
 0,  0, // 1236-1237
 0,  0,  0,  0, // 1238-1241
 0,  0,  0,  0, // 1242-1245
 0,  0,  0,  0, // 1246-1249
 0,  0,  0,  0, // 1250-1253
 0,  0,  0,  0, // 1254-1257
 0,  0,  0,  0, // 1258-1261
 0,  0,  0,  0, // 1262-1265
 0,  0,  0,  0, // 1266-1269
 0,  0,  0, // 1270-1272
 0,  0, // 1273-1274
 0,  0, // 1275-1276
 0,  0,  0, // 1277-1279
 0,  0, // 1280-1281
 0,  0, // 1282-1283
 0,  0,  0, // 1284-1286
 0,  0,  0, // 1287-1289
 0,  0,  0, // 1290-1292
 0,  0,  0, // 1293-1295
 0,  0,  0, // 1296-1298
 0,  0,  0, // 1299-1301
 0,  0,  0, // 1302-1304
 0,  0,  0, // 1305-1307
 0,  0,  0, // 1308-1310
 0,  0,  0, // 1311-1313
 0,  0,  0, // 1314-1316
 0,  0,  0, // 1317-1319
 0,  0, // 1320-1321
 0,  0,  0, // 1322-1324
 0,  0,  0, // 1325-1327
 0,  0,  0, // 1328-1330
 0,  0,  0, // 1331-1333
 0,  0,  0, // 1334-1336
 0,  0, // 1337-1338
 0,  0, // 1339-1340
 0,  0, // 1341-1342
 0,  0, // 1343-1344
 0,  0, // 1345-1346
 0,  0, // 1347-1348
 0,  0,  0, // 1349-1351
 0,  0,  0,  0,  0, // 1352-1356
 0,  0,  0, // 1357-1359
 0,  0,  0,  0,  0,  0, // 1360-1365
 0,  0,  0,  0,  0,  0, // 1366-1371
 0,  0,  0,  0,  0, // 1372-1376
 0,  0,  0,  0,  0, // 1377-1381
 0,  0,  0,  0,  0,  0,  0,  0, // 1382-1389
 0,  0,  0,  0,  0,  0,  0, // 1390-1396
 0,  0,  0,  0, // 1397-1400
 0,  0,  0,  0, // 1401-1404
 0,  0,  0,  0,  0,  0, // 1405-1410
 0,  0,  0,  0, // 1411-1414
 0,  0,  0,  0,  0,  0, // 1415-1420
 0,  0,  0,  0,  0,  0,  0,  0, // 1421-1428
 0,  0,  0,  0,  0, // 1429-1433
 0,  0,  0,  0,  0,  0,  0, // 1434-1440
 0,  0,  0,  0,  0, // 1441-1445
 0,  0,  0,  0,  0,  0,  0, // 1446-1452
 0,  0,  0,  0,  0,  0, // 1453-1458
 0,  0,  0,  0,  0,  0,  0,  0, // 1459-1466
 0,  0,  0,  0,  0,  0, // 1467-1472
 0,  0,  0,  0,  0,  0,  0,  0, // 1473-1480
 0,  0,  0,  0, // 1481-1484
 0,  0,  0,  0, // 1485-1488
 0,  0, // 1489-1490
 0,  0, // 1491-1492
 0,  0,  0, // 1493-1495
 0,  0,  0, // 1496-1498
 0,  0,  0,  0, // 1499-1502
 0,  0,  0,  0,  0, // 1503-1507
 0,  0,  0,  0,  0,  0, // 1508-1513
 0,  0,  0,  0, // 1514-1517
 0,  0,  0,  0,  0, // 1518-1522
 0,  0,  0,  0,  0,  0, // 1523-1528
 0,  0,  0,  0,  0,  0,  0, // 1529-1535
 0,  0, // 1536-1537
 0,  0, // 1538-1539
 0,  0, // 1540-1541
 0,  0, // 1542-1543
 0,  0,  0,  0, // 1544-1547
 0,  0,  0,  0, // 1548-1551
 0,  0,  0,  0, // 1552-1555
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::NoBypass, // 1556-1558
 0,  0, // 1559-1560
CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::NoBypass, // 1561-1562
CortexA9ItinerariesBypass::A9_LdBypass, // 1563
CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1564-1565
CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::NoBypass, // 1566-1567
CortexA9ItinerariesBypass::A9_LdBypass,  0, // 1568-1569
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1570-1572
 0,  0, // 1573-1574
 0, // 1575
 0,  0, // 1576-1577
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1578-1580
 0,  0, // 1581-1582
 0,  0, // 1583-1584
 0,  0,  0,  0, // 1585-1588
 0,  0, // 1589-1590
 0, // 1591
 0,  0, // 1592-1593
 0,  0, // 1594-1595
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1596-1598
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1599-1600
 0,  0,  0, // 1601-1603
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1604-1606
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1607-1609
 0,  0, // 1610-1611
 0,  0, // 1612-1613
 0,  0,  0, // 1614-1616
 0,  0,  0,  0, // 1617-1620
 0,  0,  0,  0, // 1621-1624
 0,  0,  0, // 1625-1627
 0,  0,  0, // 1628-1630
 0,  0, // 1631-1632
 0,  0,  0, // 1633-1635
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1636-1637
 0, // 1638
 0, // 1639
 0, // 1640
 0, // 1641
 0,  0, // 1642-1643
 0,  0,  0,  0, // 1644-1647
 0,  0,  0, // 1648-1650
 0,  0,  0,  0, // 1651-1654
 0,  0,  0,  0, // 1655-1658
 0,  0,  0, // 1659-1661
 0,  0,  0,  0, // 1662-1665
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1666-1668
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1669-1671
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1672-1674
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0,  0, // 1675-1678
 0,  0, // 1679-1680
 0,  0, // 1681-1682
 0, // 1683
 0, // 1684
 0, // 1685
 0, // 1686
 0,  0, // 1687-1688
 0,  0, // 1689-1690
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1691-1693
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1694-1696
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1697-1699
 0,  0,  0, // 1700-1702
 0,  0,  0,  0, // 1703-1706
 0,  0,  0, // 1707-1709
 0,  0,  0, // 1710-1712
 0,  0,  0,  0, // 1713-1716
 0,  0,  0,  0, // 1717-1720
 0,  0,  0,  0, // 1721-1724
 0,  0,  0,  0, // 1725-1728
 0,  0,  0,  0, // 1729-1732
 0,  0,  0,  0, // 1733-1736
 0,  0,  0,  0, // 1737-1740
 0,  0,  0,  0, // 1741-1744
 0,  0,  0,  0, // 1745-1748
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1749-1751
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1752-1754
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1755-1757
CortexA9ItinerariesBypass::A9_LdBypass,  0, // 1758-1759
CortexA9ItinerariesBypass::A9_LdBypass,  0, // 1760-1761
 0,  0, // 1762-1763
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1764-1766
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1767-1769
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1770-1772
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1773-1775
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1776-1778
CortexA9ItinerariesBypass::A9_LdBypass,  0, // 1779-1780
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1781-1783
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1784-1786
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0,  0, // 1787-1790
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1791-1793
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0,  0, // 1794-1797
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0,  0, // 1798-1801
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1802-1804
CortexA9ItinerariesBypass::A9_LdBypass,  0, // 1805-1806
CortexA9ItinerariesBypass::A9_LdBypass,  0, // 1807-1808
CortexA9ItinerariesBypass::A9_LdBypass,  0, // 1809-1810
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1811-1813
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0,  0, // 1814-1817
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0, // 1818-1820
CortexA9ItinerariesBypass::A9_LdBypass,  0,  0,  0, // 1821-1824
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1825-1829
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1830-1834
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1835-1839
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1840-1842
CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::NoBypass, CortexA9ItinerariesBypass::A9_LdBypass, // 1843-1845
 0,  0,  0, // 1846-1848
 0,  0,  0, // 1849-1851
 0,  0,  0, // 1852-1854
 0,  0,  0, // 1855-1857
 0,  0, // 1858-1859
 0,  0, // 1860-1861
 0,  0,  0,  0, // 1862-1865
 0,  0,  0, // 1866-1868
 0,  0,  0,  0, // 1869-1872
 0,  0,  0, // 1873-1875
 0,  0, // 1876-1877
 0,  0, // 1878-1879
 0,  0,  0, // 1880-1882
 0,  0,  0,  0, // 1883-1886
 0, // 1887
 0,  0,  0, // 1888-1890
 0,  0,  0, // 1891-1893
 0,  0,  0, // 1894-1896
 0,  0,  0, // 1897-1899
 0, // 1900
 0,  0,  0, // 1901-1903
 0,  0,  0, // 1904-1906
 0,  0,  0, // 1907-1909
 0,  0,  0, // 1910-1912
 0,  0,  0, // 1913-1915
 0,  0,  0, // 1916-1918
 0,  0, // 1919-1920
 0,  0, // 1921-1922
 0,  0,  0, // 1923-1925
 0,  0,  0, // 1926-1928
 0,  0,  0, // 1929-1931
 0,  0,  0, // 1932-1934
 0,  0,  0, // 1935-1937
 0,  0,  0, // 1938-1940
 0,  0, // 1941-1942
 0,  0, // 1943-1944
 0,  0,  0,  0, // 1945-1948
 0,  0,  0,  0, // 1949-1952
 0,  0, // 1953-1954
 0,  0, // 1955-1956
 0,  0, // 1957-1958
 0,  0, // 1959-1960
 0,  0,  0, // 1961-1963
 0,  0,  0, // 1964-1966
 0,  0,  0, // 1967-1969
 0,  0,  0, // 1970-1972
 0,  0,  0, // 1973-1975
 0,  0,  0, // 1976-1978
 0,  0, // 1979-1980
 0,  0, // 1981-1982
 0,  0,  0, // 1983-1985
 0,  0,  0, // 1986-1988
 0,  0,  0, // 1989-1991
 0,  0,  0, // 1992-1994
 0,  0, // 1995-1996
 0,  0, // 1997-1998
 0,  0,  0, // 1999-2001
 0,  0,  0, // 2002-2004
 0,  0,  0, // 2005-2007
 0,  0,  0, // 2008-2010
 0,  0,  0, // 2011-2013
 0,  0,  0,  0, // 2014-2017
 0,  0,  0,  0, // 2018-2021
 0,  0,  0,  0,  0, // 2022-2026
 0,  0,  0,  0,  0, // 2027-2031
 0,  0,  0,  0,  0,  0, // 2032-2037
 0,  0,  0,  0,  0,  0, // 2038-2043
 0,  0,  0,  0,  0,  0,  0, // 2044-2050
 0,  0,  0,  0, // 2051-2054
 0,  0,  0,  0, // 2055-2058
 0,  0,  0,  0, // 2059-2062
 0,  0, // 2063-2064
 0,  0, // 2065-2066
 0,  0, // 2067-2068
 0,  0, // 2069-2070
 0,  0,  0, // 2071-2073
 0,  0,  0, // 2074-2076
 0,  0,  0, // 2077-2079
 0,  0,  0, // 2080-2082
 0,  0,  0, // 2083-2085
 0,  0,  0, // 2086-2088
 0,  0,  0, // 2089-2091
 0,  0,  0, // 2092-2094
 0,  0,  0, // 2095-2097
 0,  0,  0, // 2098-2100
 0,  0,  0, // 2101-2103
 0,  0,  0, // 2104-2106
 0,  0,  0, // 2107-2109
 0,  0,  0, // 2110-2112
 0,  0,  0, // 2113-2115
 0,  0,  0, // 2116-2118
 0,  0,  0, // 2119-2121
 0,  0,  0, // 2122-2124
 0,  0,  0, // 2125-2127
 0,  0,  0,  0, // 2128-2131
 0,  0,  0,  0, // 2132-2135
 0,  0,  0,  0, // 2136-2139
 0,  0,  0,  0, // 2140-2143
 0,  0,  0,  0, // 2144-2147
 0,  0,  0,  0, // 2148-2151
 0,  0,  0,  0, // 2152-2155
 0,  0,  0,  0, // 2156-2159
 0,  0,  0,  0, // 2160-2163
 0,  0,  0,  0, // 2164-2167
 0,  0,  0,  0, // 2168-2171
 0,  0,  0,  0, // 2172-2175
 0,  0, // 2176-2177
 0,  0, // 2178-2179
 0,  0, // 2180-2181
 0,  0, // 2182-2183
 0,  0, // 2184-2185
 0,  0, // 2186-2187
 0,  0, // 2188-2189
 0,  0, // 2190-2191
 0,  0, // 2192-2193
 0,  0, // 2194-2195
 0,  0, // 2196-2197
 0,  0, // 2198-2199
 0,  0, // 2200-2201
 0,  0, // 2202-2203
 0, // 2204
 0,  0,  0, // 2205-2207
 0,  0, // 2208-2209
 0,  0, // 2210-2211
 0,  0, // 2212-2213
 0,  0, // 2214-2215
 0,  0, // 2216-2217
 0,  0, // 2218-2219
 0,  0, // 2220-2221
 0,  0, // 2222-2223
 0,  0,  0, // 2224-2226
 0,  0,  0, // 2227-2229
 0,  0,  0, // 2230-2232
 0,  0,  0, // 2233-2235
 0,  0, // 2236-2237
 0,  0, // 2238-2239
 0, // 2240
 0, // 2241
 0, // 2242
 0,  0, // 2243-2244
 0,  0, // 2245-2246
 0,  0, // 2247-2248
 0,  0, // 2249-2250
 0,  0,  0,  0, // 2251-2254
 0,  0,  0,  0, // 2255-2258
 0,  0,  0,  0, // 2259-2262
 0,  0,  0,  0, // 2263-2266
 0,  0,  0,  0, // 2267-2270
 0,  0,  0,  0, // 2271-2274
 0,  0, // 2275-2276
 0,  0,  0, // 2277-2279
 0,  0,  0, // 2280-2282
 0,  0,  0,  0, // 2283-2286
 0,  0,  0,  0, // 2287-2290
 0,  0,  0,  0, // 2291-2294
 0,  0,  0,  0,  0, // 2295-2299
 0,  0,  0,  0, // 2300-2303
 0,  0,  0, // 2304-2306
 0,  0,  0,  0,  0, // 2307-2311
 0,  0,  0,  0,  0,  0, // 2312-2317
 0,  0,  0,  0,  0,  0, // 2318-2323
 0,  0,  0,  0, // 2324-2327
 0,  0,  0,  0, // 2328-2331
 0,  0,  0,  0,  0, // 2332-2336
 0,  0,  0,  0,  0, // 2337-2341
 0,  0,  0,  0,  0, // 2342-2346
 0,  0,  0,  0,  0, // 2347-2351
 0,  0,  0,  0,  0,  0, // 2352-2357
 0,  0,  0,  0,  0,  0, // 2358-2363
 0,  0, // 2364-2365
 0,  0,  0,  0, // 2366-2369
 0,  0,  0,  0, // 2370-2373
 0,  0,  0,  0,  0,  0, // 2374-2379
 0,  0,  0, // 2380-2382
 0,  0,  0,  0,  0,  0, // 2383-2388
 0,  0,  0,  0,  0,  0,  0,  0, // 2389-2396
 0,  0,  0,  0,  0, // 2397-2401
 0,  0,  0,  0,  0,  0,  0,  0, // 2402-2409
 0,  0,  0,  0, // 2410-2413
 0,  0,  0,  0,  0,  0,  0,  0, // 2414-2421
 0,  0,  0,  0,  0,  0, // 2422-2427
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 2428-2437
 0,  0,  0,  0,  0,  0, // 2438-2443
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 2444-2453
 0,  0,  0,  0,  0, // 2454-2458
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 2459-2468
 0,  0,  0,  0,  0,  0,  0, // 2469-2475
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 2476-2487
 0,  0,  0,  0,  0,  0,  0, // 2488-2494
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 2495-2506
 0,  0,  0, // 2507-2509
 0,  0,  0,  0, // 2510-2513
 0,  0,  0, // 2514-2516
 0,  0,  0,  0, // 2517-2520
 0,  0,  0,  0,  0, // 2521-2525
 0,  0,  0,  0,  0, // 2526-2530
 0,  0,  0,  0,  0,  0,  0, // 2531-2537
 0,  0,  0,  0,  0,  0, // 2538-2543
 0,  0,  0,  0,  0,  0, // 2544-2549
 0,  0,  0,  0,  0,  0,  0,  0, // 2550-2557
 0,  0,  0,  0, // 2558-2561
 0,  0,  0, // 2562-2564
 0,  0,  0,  0,  0,  0, // 2565-2570
 0,  0,  0,  0,  0,  0,  0,  0, // 2571-2578
 0,  0,  0, // 2579-2581
 0,  0,  0,  0,  0, // 2582-2586
 0,  0,  0,  0,  0,  0,  0, // 2587-2593
 0,  0,  0,  0,  0,  0, // 2594-2599
 0,  0,  0,  0,  0,  0,  0,  0, // 2600-2607
 0,  0,  0, // 2608-2610
 0,  0,  0,  0,  0, // 2611-2615
 0,  0,  0,  0, // 2616-2619
 0,  0,  0,  0,  0,  0, // 2620-2625
 0,  0,  0,  0,  0, // 2626-2630
 0,  0,  0,  0,  0,  0,  0, // 2631-2637
 0,  0,  0,  0,  0,  0, // 2638-2643
 0,  0,  0,  0,  0,  0,  0,  0, // 2644-2651
 0,  0,  0, // 2652-2654
 0,  0, // 2655-2656
 0,  0,  0, // 2657-2659
 0,  0, // 2660-2661
 0,  0, // 2662-2663
 0,  0,  0, // 2664-2666
 0,  0,  0,  0, // 2667-2670
 0,  0,  0,  0, // 2671-2674
 0,  0,  0,  0, // 2675-2678
 0,  0, // 2679-2680
 0,  0,  0, // 2681-2683
 0,  0,  0,  0, // 2684-2687
 0,  0,  0,  0, // 2688-2691
 0,  0, // 2692-2693
 0,  0, // 2694-2695
 0, // 2696
 0,  0, // 2697-2698
 0,  0,  0, // 2699-2701
 0,  0,  0, // 2702-2704
 0,  0, // 2705-2706
 0,  0, // 2707-2708
 0, // 2709
 0,  0,  0,  0,  0, // 2710-2714
 0,  0,  0,  0,  0, // 2715-2719
 0,  0,  0,  0,  0, // 2720-2724
 0,  0,  0,  0, // 2725-2728
 0,  0,  0, // 2729-2731
 0,  0,  0, // 2732-2734
 0,  0,  0, // 2735-2737
 0,  0,  0, // 2738-2740
 0,  0,  0,  0, // 2741-2744
 0,  0, // 2745-2746
 0,  0, // 2747-2748
 0,  0,  0,  0, // 2749-2752
 0,  0,  0, // 2753-2755
 0,  0,  0, // 2756-2758
 0,  0,  0, // 2759-2761
 0,  0,  0,  0, // 2762-2765
 0, // 2766
 0, // 2767
 0,  0, // 2768-2769
 0,  0, // 2770-2771
 0,  0,  0, // 2772-2774
 0, // 2775
 0, // 2776
 0, // 2777
 0,  0, // 2778-2779
 0,  0,  0, // 2780-2782
 0,  0, // 2783-2784
 0,  0,  0, // 2785-2787
 0, // 2788
 0,  0, // 2789-2790
 0,  0,  0, // 2791-2793
 0,  0,  0, // 2794-2796
 0,  0,  0, // 2797-2799
 0,  0,  0, // 2800-2802
 0,  0,  0, // 2803-2805
 0,  0,  0, // 2806-2808
 0,  0, // 2809-2810
 0,  0,  0,  0, // 2811-2814
 0,  0,  0,  0, // 2815-2818
 0,  0,  0, // 2819-2821
 0,  0,  0,  0, // 2822-2825
 0, // 2826
 0,  0,  0,  0, // 2827-2830
 0,  0,  0, // 2831-2833
 0,  0,  0,  0, // 2834-2837
 0,  0,  0, // 2838-2840
 0,  0,  0, // 2841-2843
 0,  0,  0,  0, // 2844-2847
 0,  0,  0, // 2848-2850
 0,  0,  0, // 2851-2853
 0,  0,  0, // 2854-2856
 0,  0, // 2857-2858
 0, // 2859
 0,  0, // 2860-2861
 0,  0,  0, // 2862-2864
 0,  0,  0, // 2865-2867
 0,  0,  0,  0, // 2868-2871
 0,  0,  0,  0, // 2872-2875
 0,  0,  0, // 2876-2878
 0,  0,  0, // 2879-2881
 0,  0,  0, // 2882-2884
 0,  0,  0, // 2885-2887
 0,  0, // 2888-2889
 0,  0, // 2890-2891
 0,  0, // 2892-2893
 0,  0, // 2894-2895
 0,  0,  0, // 2896-2898
 0,  0,  0, // 2899-2901
 0,  0,  0, // 2902-2904
 0,  0,  0, // 2905-2907
 0,  0,  0, // 2908-2910
 0,  0,  0, // 2911-2913
 0,  0,  0, // 2914-2916
 0, // 2917
 0,  0,  0, // 2918-2920
 0,  0,  0, // 2921-2923
 0,  0, // 2924-2925
 0,  0, // 2926-2927
 0,  0, // 2928-2929
 0,  0, // 2930-2931
 0,  0,  0, // 2932-2934
 0,  0,  0, // 2935-2937
 0,  0, // 2938-2939
 0,  0, // 2940-2941
 0,  0, // 2942-2943
 0,  0,  0, // 2944-2946
 0,  0,  0, // 2947-2949
 0,  0,  0,  0, // 2950-2953
 0,  0,  0,  0, // 2954-2957
 0,  0,  0,  0, // 2958-2961
 0,  0,  0,  0, // 2962-2965
 0,  0, // 2966-2967
 0,  0,  0, // 2968-2970
 0,  0, // 2971-2972
 0,  0,  0,  0, // 2973-2976
 0,  0,  0,  0, // 2977-2980
 0,  0,  0,  0,  0,  0, // 2981-2986
 0,  0, // 2987-2988
 0,  0,  0,  0,  0, // 2989-2993
 0,  0,  0,  0, // 2994-2997
 0,  0,  0,  0, // 2998-3001
 0,  0,  0, // 3002-3004
 0,  0,  0, // 3005-3007
 0,  0,  0, // 3008-3010
 0,  0,  0,  0,  0, // 3011-3015
 0,  0,  0,  0,  0,  0, // 3016-3021
 0,  0,  0,  0,  0,  0,  0,  0, // 3022-3029
 0,  0,  0, // 3030-3032
 0,  0,  0,  0,  0,  0, // 3033-3038
 0,  0,  0,  0,  0, // 3039-3043
 0,  0,  0,  0,  0,  0, // 3044-3049
 0,  0,  0,  0, // 3050-3053
 0,  0,  0,  0,  0,  0, // 3054-3059
 0,  0,  0,  0,  0,  0,  0,  0, // 3060-3067
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 3068-3077
 0,  0,  0,  0, // 3078-3081
 0,  0,  0,  0,  0, // 3082-3086
 0,  0,  0,  0,  0, // 3087-3091
 0,  0,  0,  0,  0,  0,  0, // 3092-3098
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 3099-3108
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 3109-3120
 0,  0,  0,  0,  0, // 3121-3125
 0,  0,  0,  0,  0,  0, // 3126-3131
 0,  0,  0,  0,  0, // 3132-3136
 0,  0,  0,  0, // 3137-3140
 0,  0, // 3141-3142
 0,  0, // 3143-3144
 0,  0,  0,  0, // 3145-3148
 0,  0,  0,  0, // 3149-3152
 0,  0,  0,  0, // 3153-3156
 0,  0,  0,  0, // 3157-3160
 0,  0,  0,  0, // 3161-3164
 0,  0,  0,  0, // 3165-3168
 0,  0,  0,  0, // 3169-3172
 0,  0,  0,  0, // 3173-3176
 0,  0,  0, // 3177-3179
 0,  0, // 3180-3181
 0,  0, // 3182-3183
 0,  0,  0, // 3184-3186
 0,  0, // 3187-3188
 0,  0, // 3189-3190
 0,  0,  0, // 3191-3193
 0,  0,  0, // 3194-3196
 0,  0,  0, // 3197-3199
 0,  0,  0, // 3200-3202
 0,  0,  0, // 3203-3205
 0,  0,  0, // 3206-3208
 0,  0,  0, // 3209-3211
 0,  0,  0, // 3212-3214
 0,  0,  0, // 3215-3217
 0,  0,  0, // 3218-3220
 0,  0,  0, // 3221-3223
 0,  0,  0, // 3224-3226
 0,  0, // 3227-3228
 0,  0,  0, // 3229-3231
 0,  0,  0, // 3232-3234
 0,  0,  0, // 3235-3237
 0,  0,  0, // 3238-3240
 0,  0,  0, // 3241-3243
 0,  0, // 3244-3245
 0,  0, // 3246-3247
 0,  0, // 3248-3249
 0,  0, // 3250-3251
 0,  0, // 3252-3253
 0,  0, // 3254-3255
 0,  0,  0, // 3256-3258
 0,  0,  0,  0,  0, // 3259-3263
 0,  0,  0, // 3264-3266
 0,  0,  0,  0,  0,  0, // 3267-3272
 0,  0,  0,  0,  0,  0, // 3273-3278
 0,  0,  0,  0,  0, // 3279-3283
 0,  0,  0,  0,  0, // 3284-3288
 0,  0,  0,  0,  0,  0,  0,  0, // 3289-3296
 0,  0,  0,  0,  0,  0,  0, // 3297-3303
 0,  0,  0,  0, // 3304-3307
 0,  0,  0,  0, // 3308-3311
 0,  0,  0,  0,  0,  0, // 3312-3317
 0,  0,  0,  0, // 3318-3321
 0,  0,  0,  0,  0,  0, // 3322-3327
 0,  0,  0,  0,  0,  0,  0,  0, // 3328-3335
 0,  0,  0,  0,  0, // 3336-3340
 0,  0,  0,  0,  0,  0,  0, // 3341-3347
 0,  0,  0,  0,  0, // 3348-3352
 0,  0,  0,  0,  0,  0,  0, // 3353-3359
 0,  0,  0,  0,  0,  0, // 3360-3365
 0,  0,  0,  0,  0,  0,  0,  0, // 3366-3373
 0,  0,  0,  0,  0,  0, // 3374-3379
 0,  0,  0,  0,  0,  0,  0,  0, // 3380-3387
 0,  0,  0,  0,  0, // 3388-3392
 0,  0,  0,  0, // 3393-3396
 0,  0, // 3397-3398
 0,  0, // 3399-3400
 0,  0,  0, // 3401-3403
 0,  0,  0, // 3404-3406
 0,  0,  0,  0, // 3407-3410
 0,  0,  0,  0,  0, // 3411-3415
 0,  0,  0,  0,  0,  0, // 3416-3421
 0,  0,  0,  0, // 3422-3425
 0,  0,  0,  0,  0, // 3426-3430
 0,  0,  0,  0,  0,  0, // 3431-3436
 0,  0,  0,  0,  0,  0,  0, // 3437-3443
 0,  0, // 3444-3445
 0,  0, // 3446-3447
 0,  0, // 3448-3449
 0,  0, // 3450-3451
 0,  0,  0,  0, // 3452-3455
 0,  0,  0,  0, // 3456-3459
 0,  0,  0,  0, // 3460-3463
 0,  0,  0, // 3464-3466
 0,  0, // 3467-3468
 0,  0, // 3469-3470
 0, // 3471
 0,  0, // 3472-3473
 0,  0, // 3474-3475
 0,  0, // 3476-3477
 0,  0, // 3478-3479
 0,  0, // 3480-3481
 0, // 3482
 0,  0, // 3483-3484
 0,  0,  0, // 3485-3487
 0,  0, // 3488-3489
 0,  0, // 3490-3491
 0,  0,  0,  0, // 3492-3495
 0,  0, // 3496-3497
 0, // 3498
 0,  0, // 3499-3500
 0,  0, // 3501-3502
 0,  0,  0, // 3503-3505
 0,  0, // 3506-3507
 0,  0,  0, // 3508-3510
 0,  0,  0, // 3511-3513
 0,  0,  0, // 3514-3516
 0,  0, // 3517-3518
 0,  0, // 3519-3520
 0,  0,  0, // 3521-3523
 0,  0,  0,  0, // 3524-3527
 0,  0,  0,  0, // 3528-3531
 0,  0,  0, // 3532-3534
 0,  0,  0, // 3535-3537
 0,  0, // 3538-3539
 0,  0,  0, // 3540-3542
 0,  0, // 3543-3544
 0,  0, // 3545-3546
 0, // 3547
 0, // 3548
 0, // 3549
 0,  0, // 3550-3551
 0,  0,  0,  0, // 3552-3555
 0,  0,  0, // 3556-3558
 0,  0,  0,  0, // 3559-3562
 0,  0,  0,  0, // 3563-3566
 0,  0,  0, // 3567-3569
 0,  0,  0,  0, // 3570-3573
 0,  0,  0, // 3574-3576
 0,  0,  0, // 3577-3579
 0,  0,  0, // 3580-3582
 0,  0,  0,  0, // 3583-3586
 0,  0, // 3587-3588
 0,  0, // 3589-3590
 0,  0, // 3591-3592
 0, // 3593
 0, // 3594
 0, // 3595
 0,  0, // 3596-3597
 0,  0, // 3598-3599
 0,  0,  0, // 3600-3602
 0,  0,  0, // 3603-3605
 0,  0,  0, // 3606-3608
 0,  0,  0, // 3609-3611
 0,  0,  0,  0, // 3612-3615
 0,  0,  0, // 3616-3618
 0,  0,  0, // 3619-3621
 0,  0,  0,  0, // 3622-3625
 0,  0,  0,  0, // 3626-3629
 0,  0,  0,  0, // 3630-3633
 0,  0,  0,  0, // 3634-3637
 0,  0,  0,  0, // 3638-3641
 0,  0,  0,  0, // 3642-3645
 0,  0,  0,  0, // 3646-3649
 0,  0,  0,  0, // 3650-3653
 0,  0,  0,  0, // 3654-3657
 0,  0,  0, // 3658-3660
 0,  0,  0, // 3661-3663
 0,  0,  0, // 3664-3666
 0,  0, // 3667-3668
 0,  0, // 3669-3670
 0,  0, // 3671-3672
 0,  0,  0, // 3673-3675
 0,  0,  0, // 3676-3678
 0,  0,  0, // 3679-3681
 0,  0,  0, // 3682-3684
 0,  0,  0, // 3685-3687
 0,  0, // 3688-3689
 0,  0,  0, // 3690-3692
 0,  0,  0, // 3693-3695
 0,  0,  0,  0, // 3696-3699
 0,  0,  0, // 3700-3702
 0,  0,  0,  0, // 3703-3706
 0,  0,  0,  0, // 3707-3710
 0,  0,  0, // 3711-3713
 0,  0, // 3714-3715
 0,  0, // 3716-3717
 0,  0, // 3718-3719
 0,  0,  0, // 3720-3722
 0,  0,  0, // 3723-3725
 0,  0, // 3726-3727
 0,  0,  0,  0, // 3728-3731
 0,  0,  0,  0,  0, // 3732-3736
 0,  0,  0,  0,  0, // 3737-3741
 0,  0,  0,  0,  0, // 3742-3746
 0,  0,  0, // 3747-3749
 0,  0,  0, // 3750-3752
 0,  0,  0, // 3753-3755
 0,  0,  0, // 3756-3758
 0,  0,  0, // 3759-3761
 0,  0,  0, // 3762-3764
 0,  0, // 3765-3766
 0,  0, // 3767-3768
 0,  0,  0,  0, // 3769-3772
 0,  0,  0, // 3773-3775
 0,  0,  0,  0, // 3776-3779
 0,  0,  0, // 3780-3782
 0,  0, // 3783-3784
 0,  0, // 3785-3786
 0,  0,  0, // 3787-3789
 0,  0,  0,  0, // 3790-3793
 0, // 3794
 0,  0,  0, // 3795-3797
 0,  0,  0, // 3798-3800
 0,  0,  0, // 3801-3803
 0,  0,  0, // 3804-3806
 0, // 3807
 0,  0,  0, // 3808-3810
 0,  0,  0, // 3811-3813
 0,  0,  0, // 3814-3816
 0,  0,  0, // 3817-3819
 0,  0,  0, // 3820-3822
 0,  0,  0, // 3823-3825
 0,  0, // 3826-3827
 0,  0, // 3828-3829
 0,  0,  0, // 3830-3832
 0,  0,  0, // 3833-3835
 0,  0,  0, // 3836-3838
 0,  0,  0, // 3839-3841
 0,  0,  0, // 3842-3844
 0,  0,  0, // 3845-3847
 0,  0, // 3848-3849
 0,  0, // 3850-3851
 0,  0,  0,  0, // 3852-3855
 0,  0,  0,  0, // 3856-3859
 0,  0, // 3860-3861
 0,  0, // 3862-3863
 0,  0, // 3864-3865
 0,  0, // 3866-3867
 0,  0,  0, // 3868-3870
 0,  0,  0, // 3871-3873
 0,  0,  0, // 3874-3876
 0,  0,  0, // 3877-3879
 0,  0,  0, // 3880-3882
 0,  0,  0, // 3883-3885
 0,  0, // 3886-3887
 0,  0, // 3888-3889
 0,  0,  0, // 3890-3892
 0,  0,  0, // 3893-3895
 0,  0,  0, // 3896-3898
 0,  0,  0, // 3899-3901
 0,  0, // 3902-3903
 0,  0, // 3904-3905
 0,  0,  0, // 3906-3908
 0,  0,  0, // 3909-3911
 0,  0,  0, // 3912-3914
 0,  0,  0, // 3915-3917
 0,  0,  0, // 3918-3920
 0,  0,  0,  0, // 3921-3924
 0,  0,  0,  0, // 3925-3928
 0,  0,  0,  0,  0, // 3929-3933
 0,  0,  0,  0,  0, // 3934-3938
 0,  0,  0,  0,  0,  0, // 3939-3944
 0,  0,  0,  0,  0,  0, // 3945-3950
 0,  0,  0,  0,  0,  0,  0, // 3951-3957
 0,  0,  0,  0, // 3958-3961
 0,  0,  0,  0, // 3962-3965
 0,  0,  0,  0, // 3966-3969
 0,  0, // 3970-3971
 0,  0, // 3972-3973
 0,  0, // 3974-3975
 0,  0, // 3976-3977
 0,  0,  0, // 3978-3980
 0,  0,  0, // 3981-3983
 0,  0,  0, // 3984-3986
 0,  0,  0, // 3987-3989
 0,  0,  0, // 3990-3992
 0,  0,  0, // 3993-3995
 0,  0,  0, // 3996-3998
 0,  0,  0, // 3999-4001
 0,  0,  0, // 4002-4004
 0,  0,  0, // 4005-4007
 0,  0,  0, // 4008-4010
 0,  0,  0, // 4011-4013
 0,  0,  0, // 4014-4016
 0,  0,  0, // 4017-4019
 0,  0,  0, // 4020-4022
 0,  0,  0, // 4023-4025
 0,  0,  0, // 4026-4028
 0,  0,  0, // 4029-4031
 0,  0,  0, // 4032-4034
 0,  0,  0,  0, // 4035-4038
 0,  0,  0,  0, // 4039-4042
 0,  0,  0,  0, // 4043-4046
 0,  0,  0,  0, // 4047-4050
 0,  0,  0,  0, // 4051-4054
 0,  0,  0,  0, // 4055-4058
 0,  0,  0,  0, // 4059-4062
 0,  0,  0,  0, // 4063-4066
 0,  0,  0,  0, // 4067-4070
 0,  0,  0,  0, // 4071-4074
 0,  0,  0,  0, // 4075-4078
 0,  0,  0,  0, // 4079-4082
 0,  0, // 4083-4084
 0,  0, // 4085-4086
 0,  0, // 4087-4088
 0,  0, // 4089-4090
 0,  0, // 4091-4092
 0,  0, // 4093-4094
 0,  0, // 4095-4096
 0,  0, // 4097-4098
 0,  0, // 4099-4100
 0,  0, // 4101-4102
 0,  0, // 4103-4104
 0,  0, // 4105-4106
 0, // 4107
 0,  0,  0, // 4108-4110
 0,  0, // 4111-4112
 0,  0, // 4113-4114
 0,  0, // 4115-4116
 0,  0, // 4117-4118
 0,  0, // 4119-4120
 0,  0, // 4121-4122
 0,  0, // 4123-4124
 0,  0, // 4125-4126
 0,  0,  0, // 4127-4129
 0,  0,  0, // 4130-4132
 0,  0,  0, // 4133-4135
 0,  0,  0, // 4136-4138
 0,  0, // 4139-4140
 0,  0, // 4141-4142
 0, // 4143
 0, // 4144
 0, // 4145
 0,  0, // 4146-4147
 0,  0, // 4148-4149
 0,  0, // 4150-4151
 0,  0, // 4152-4153
 0,  0,  0,  0, // 4154-4157
 0,  0,  0,  0, // 4158-4161
 0,  0,  0,  0, // 4162-4165
 0,  0,  0,  0,  0, // 4166-4170
 0,  0,  0,  0, // 4171-4174
 0,  0,  0,  0,  0, // 4175-4179
 0,  0, // 4180-4181
 0,  0,  0, // 4182-4184
 0,  0,  0, // 4185-4187
 0,  0,  0,  0, // 4188-4191
 0,  0,  0,  0, // 4192-4195
 0,  0,  0,  0, // 4196-4199
 0,  0,  0,  0,  0, // 4200-4204
 0,  0,  0,  0, // 4205-4208
 0,  0,  0, // 4209-4211
 0,  0,  0,  0,  0, // 4212-4216
 0,  0,  0,  0,  0,  0, // 4217-4222
 0,  0,  0,  0,  0,  0, // 4223-4228
 0,  0,  0,  0, // 4229-4232
 0,  0,  0,  0, // 4233-4236
 0,  0,  0,  0,  0, // 4237-4241
 0,  0,  0,  0,  0, // 4242-4246
 0,  0,  0,  0,  0, // 4247-4251
 0,  0,  0,  0,  0, // 4252-4256
 0,  0,  0,  0,  0,  0, // 4257-4262
 0,  0,  0,  0,  0,  0, // 4263-4268
 0,  0, // 4269-4270
 0,  0,  0,  0, // 4271-4274
 0,  0,  0,  0, // 4275-4278
 0,  0,  0,  0,  0,  0, // 4279-4284
 0,  0,  0, // 4285-4287
 0,  0,  0,  0,  0,  0, // 4288-4293
 0,  0,  0,  0,  0,  0,  0,  0, // 4294-4301
 0,  0,  0,  0,  0, // 4302-4306
 0,  0,  0,  0,  0,  0,  0,  0, // 4307-4314
 0,  0,  0,  0, // 4315-4318
 0,  0,  0,  0,  0,  0,  0,  0, // 4319-4326
 0,  0,  0,  0,  0,  0, // 4327-4332
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 4333-4342
 0,  0,  0,  0,  0,  0, // 4343-4348
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 4349-4358
 0,  0,  0,  0,  0, // 4359-4363
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 4364-4373
 0,  0,  0,  0,  0,  0,  0, // 4374-4380
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 4381-4392
 0,  0,  0,  0,  0,  0,  0, // 4393-4399
 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, // 4400-4411
 0,  0,  0, // 4412-4414
 0,  0,  0,  0, // 4415-4418
 0,  0,  0, // 4419-4421
 0,  0,  0,  0, // 4422-4425
 0,  0,  0,  0,  0, // 4426-4430
 0,  0,  0,  0,  0, // 4431-4435
 0,  0,  0,  0,  0,  0,  0, // 4436-4442
 0,  0,  0,  0,  0,  0, // 4443-4448
 0,  0,  0,  0,  0,  0, // 4449-4454
 0,  0,  0,  0,  0,  0,  0,  0, // 4455-4462
 0,  0,  0,  0, // 4463-4466
 0,  0,  0, // 4467-4469
 0,  0,  0,  0,  0,  0, // 4470-4475
 0,  0,  0,  0,  0,  0,  0,  0, // 4476-4483
 0,  0,  0, // 4484-4486
 0,  0,  0,  0,  0, // 4487-4491
 0,  0,  0,  0,  0,  0,  0, // 4492-4498
 0,  0,  0,  0,  0,  0, // 4499-4504
 0,  0,  0,  0,  0,  0,  0,  0, // 4505-4512
 0,  0,  0, // 4513-4515
 0,  0,  0,  0,  0, // 4516-4520
 0,  0,  0,  0, // 4521-4524
 0,  0,  0,  0,  0,  0, // 4525-4530
 0,  0,  0,  0,  0, // 4531-4535
 0,  0,  0,  0,  0,  0,  0, // 4536-4542
 0,  0,  0,  0,  0,  0, // 4543-4548
 0,  0,  0,  0,  0,  0,  0,  0, // 4549-4556
 0,  0,  0, // 4557-4559
 0,  0, // 4560-4561
 0,  0,  0, // 4562-4564
 0,  0, // 4565-4566
 0,  0, // 4567-4568
 0,  0,  0, // 4569-4571
 0,  0,  0,  0, // 4572-4575
 0,  0,  0,  0, // 4576-4579
 0,  0,  0,  0, // 4580-4583
 0,  0, // 4584-4585
 0,  0,  0, // 4586-4588
 0,  0,  0,  0, // 4589-4592
 0,  0,  0,  0, // 4593-4596
 0,  0, // 4597-4598
 0,  0, // 4599-4600
 0, // 4601
 0,  0, // 4602-4603
 0,  0,  0, // 4604-4606
 0,  0,  0, // 4607-4609
 0,  0, // 4610-4611
 0,  0, // 4612-4613
 0, // 4614
 0,  0,  0,  0,  0, // 4615-4619
 0,  0,  0,  0,  0, // 4620-4624
 0,  0,  0,  0,  0, // 4625-4629
 0,  0,  0,  0, // 4630-4633
 0,  0,  0, // 4634-4636
 0,  0,  0, // 4637-4639
 0,  0,  0, // 4640-4642
 0,  0,  0,  0, // 4643-4646
 0,  0,  0,  0, // 4647-4650
 0,  0, // 4651-4652
 0,  0, // 4653-4654
 0,  0,  0,  0, // 4655-4658
 0,  0,  0, // 4659-4661
 0,  0,  0, // 4662-4664
 0,  0,  0, // 4665-4667
 0,  0,  0,  0, // 4668-4671
 0, // 4672
 0, // 4673
 0, // 4674
 0,  0, // 4675-4676
 0,  0,  0, // 4677-4679
 0, // 4680
 0, // 4681
 0, // 4682
 0, // 4683
 0, // 4684
 0, // 4685
 0,  0,  0, // 4686-4688
 0, // 4689
 0, // 4690
 0, // 4691
 0,  0,  0, // 4692-4694
 0,  0,  0, // 4695-4697
 0,  0,  0, // 4698-4700
 0,  0,  0, // 4701-4703
 0,  0,  0, // 4704-4706
 0,  0, // 4707-4708
 0,  0,  0, // 4709-4711
 0,  0,  0,  0, // 4712-4715
 0,  0,  0,  0, // 4716-4719
 0,  0,  0, // 4720-4722
 0,  0,  0,  0, // 4723-4726
 0, // 4727
 0,  0,  0,  0, // 4728-4731
 0,  0,  0, // 4732-4734
 0,  0,  0,  0, // 4735-4738
 0,  0,  0, // 4739-4741
 0,  0,  0, // 4742-4744
 0,  0,  0,  0, // 4745-4748
 0,  0,  0, // 4749-4751
 0,  0,  0, // 4752-4754
 0,  0,  0, // 4755-4757
 0,  0, // 4758-4759
 0, // 4760
 0,  0, // 4761-4762
 0,  0,  0, // 4763-4765
 0,  0,  0, // 4766-4768
 0,  0,  0,  0, // 4769-4772
 0,  0,  0,  0, // 4773-4776
 0,  0,  0, // 4777-4779
 0,  0,  0, // 4780-4782
 0,  0,  0, // 4783-4785
 0,  0,  0, // 4786-4788
 0,  0, // 4789-4790
 0,  0, // 4791-4792
 0,  0, // 4793-4794
 0,  0, // 4795-4796
 0,  0,  0, // 4797-4799
 0,  0,  0, // 4800-4802
 0,  0,  0, // 4803-4805
 0,  0,  0, // 4806-4808
 0,  0,  0, // 4809-4811
 0,  0,  0, // 4812-4814
 0,  0,  0, // 4815-4817
 0, // 4818
 0,  0,  0, // 4819-4821
 0,  0,  0, // 4822-4824
 0,  0, // 4825-4826
 0,  0, // 4827-4828
 0,  0, // 4829-4830
 0,  0, // 4831-4832
 0,  0, // 4833-4834
 0,  0, // 4835-4836
 0,  0,  0, // 4837-4839
 0,  0,  0, // 4840-4842
 0,  0, // 4843-4844
 0,  0, // 4845-4846
 0,  0, // 4847-4848
 0,  0,  0, // 4849-4851
 0,  0,  0, // 4852-4854
 0,  0,  0, // 4855-4857
 0,  0,  0, // 4858-4860
 0,  0,  0, // 4861-4863
 0,  0,  0, // 4864-4866
 0,  0, // 4867-4868
 0,  0,  0, // 4869-4871
 0,  0,  0,  0,  0, // 4872-4876
 0,  0,  0,  0, // 4877-4880
 0,  0, // 4881-4882
 0,  0, // 4883-4884
 0,  0,  0, // 4885-4887
 0,  0,  0,  0, // 4888-4891
 0,  0,  0,  0, // 4892-4895
 0,  0,  0, // 4896-4898
 0,  0,  0, // 4899-4901
 0,  0,  0, // 4902-4904
 0,  0,  0,  0, // 4905-4908
 0,  0,  0,  0, // 4909-4912
 0,  0, // 4913-4914
 0,  0, // 4915-4916
 0,  0, // 4917-4918
 0,  0,  0, // 4919-4921
 0,  0, // 4922-4923
 0,  0, // 4924-4925
 0,  0,  0, // 4926-4928
 0,  0,  0, // 4929-4931
 0,  0,  0, // 4932-4934
 0,  0,  0, // 4935-4937
 0,  0,  0, // 4938-4940
 0,  0,  0, // 4941-4943
 0,  0,  0, // 4944-4946
 0,  0,  0, // 4947-4949
 0,  0,  0, // 4950-4952
 0,  0,  0, // 4953-4955
 0,  0,  0, // 4956-4958
 0,  0,  0, // 4959-4961
 0,  0, // 4962-4963
 0,  0,  0, // 4964-4966
 0,  0,  0, // 4967-4969
 0,  0,  0, // 4970-4972
 0,  0,  0, // 4973-4975
 0,  0, // 4976-4977
 0,  0, // 4978-4979
 0,  0, // 4980-4981
 0,  0, // 4982-4983
 0,  0, // 4984-4985
 0,  0,  0, // 4986-4988
 0,  0, // 4989-4990
 0,  0,  0,  0, // 4991-4994
 0,  0,  0, // 4995-4997
 0,  0, // 4998-4999
 0,  0, // 5000-5001
 0,  0,  0, // 5002-5004
 0,  0,  0, // 5005-5007
 0,  0,  0,  0, // 5008-5011
 0,  0,  0,  0,  0, // 5012-5016
 0,  0,  0,  0,  0,  0, // 5017-5022
 0,  0,  0, // 5023-5025
 0,  0,  0,  0, // 5026-5029
 0,  0,  0,  0,  0, // 5030-5034
 0,  0,  0,  0,  0,  0, // 5035-5040
 0,  0, // 5041-5042
 0,  0, // 5043-5044
 0,  0, // 5045-5046
 0,  0, // 5047-5048
 0,  0,  0,  0, // 5049-5052
 0,  0,  0,  0, // 5053-5056
 0,  0,  0,  0, // 5057-5060
 0,  0,  0, // 5061-5063
 0,  0, // 5064-5065
 0,  0, // 5066-5067
 0, // 5068
 0,  0, // 5069-5070
 0,  0, // 5071-5072
 0,  0, // 5073-5074
 0,  0,  0, // 5075-5077
 0,  0, // 5078-5079
 0, // 5080
 0, // 5081
 0,  0,  0, // 5082-5084
 0,  0, // 5085-5086
 0,  0, // 5087-5088
 0,  0,  0,  0, // 5089-5092
 0,  0, // 5093-5094
 0, // 5095
 0,  0, // 5096-5097
 0,  0, // 5098-5099
 0,  0,  0, // 5100-5102
 0,  0, // 5103-5104
 0,  0,  0, // 5105-5107
 0,  0,  0, // 5108-5110
 0,  0,  0, // 5111-5113
 0,  0, // 5114-5115
 0,  0, // 5116-5117
 0,  0,  0, // 5118-5120
 0,  0,  0,  0, // 5121-5124
 0,  0,  0,  0, // 5125-5128
 0,  0,  0, // 5129-5131
 0, // 5132
 0, // 5133
 0, // 5134
 0, // 5135
 0, // 5136
 0, // 5137
 0, // 5138
 0, // 5139
 0,  0, // 5140-5141
 0,  0,  0,  0, // 5142-5145
 0,  0,  0, // 5146-5148
 0,  0,  0,  0, // 5149-5152
 0,  0,  0,  0, // 5153-5156
 0,  0,  0, // 5157-5159
 0,  0,  0,  0, // 5160-5163
 0,  0,  0, // 5164-5166
 0,  0,  0, // 5167-5169
 0,  0,  0, // 5170-5172
 0,  0,  0,  0, // 5173-5176
 0,  0, // 5177-5178
 0,  0, // 5179-5180
 0, // 5181
 0, // 5182
 0, // 5183
 0, // 5184
 0,  0, // 5185-5186
 0,  0, // 5187-5188
 0,  0,  0, // 5189-5191
 0,  0,  0, // 5192-5194
 0,  0,  0, // 5195-5197
 0,  0,  0, // 5198-5200
 0,  0,  0,  0, // 5201-5204
 0,  0,  0, // 5205-5207
 0,  0,  0, // 5208-5210
 0,  0,  0,  0, // 5211-5214
 0,  0,  0,  0, // 5215-5218
 0,  0,  0,  0, // 5219-5222
 0,  0,  0,  0, // 5223-5226
 0,  0,  0,  0, // 5227-5230
 0,  0,  0,  0, // 5231-5234
 0,  0,  0,  0, // 5235-5238
 0,  0,  0,  0, // 5239-5242
 0,  0,  0,  0, // 5243-5246
 0,  0,  0, // 5247-5249
 0,  0,  0, // 5250-5252
 0,  0,  0, // 5253-5255
 0,  0,  0, // 5256-5258
 0,  0, // 5259-5260
 0,  0, // 5261-5262
 0,  0, // 5263-5264
 0,  0,  0, // 5265-5267
 0,  0,  0, // 5268-5270
 0,  0,  0, // 5271-5273
 0,  0,  0, // 5274-5276
 0,  0,  0, // 5277-5279
 0,  0, // 5280-5281
 0,  0,  0, // 5282-5284
 0,  0,  0, // 5285-5287
 0,  0,  0,  0, // 5288-5291
 0,  0,  0, // 5292-5294
 0,  0,  0,  0, // 5295-5298
 0,  0,  0,  0, // 5299-5302
 0,  0,  0, // 5303-5305
 0,  0, // 5306-5307
 0,  0, // 5308-5309
 0,  0, // 5310-5311
 0,  0,  0, // 5312-5314
 0,  0,  0,  0, // 5315-5318
 0,  0,  0, // 5319-5321
 0,  0,  0,  0, // 5322-5325
 0,  0,  0,  0,  0, // 5326-5330
 0,  0,  0,  0,  0, // 5331-5335
 0,  0,  0,  0,  0, // 5336-5340
 0,  0,  0, // 5341-5343
 0,  0,  0, // 5344-5346
 0,  0,  0, // 5347-5349
 0,  0,  0, // 5350-5352
 0,  0,  0, // 5353-5355
 0,  0,  0, // 5356-5358
 0,  0, // 5359-5360
 0,  0, // 5361-5362
 0,  0,  0,  0, // 5363-5366
 0,  0,  0, // 5367-5369
 0,  0,  0,  0, // 5370-5373
 0,  0,  0, // 5374-5376
 0,  0, // 5377-5378
 0,  0, // 5379-5380
 0,  0,  0, // 5381-5383
 0,  0,  0,  0, // 5384-5387
 0, // 5388
 0,  0,  0, // 5389-5391
 0,  0,  0, // 5392-5394
 0,  0,  0, // 5395-5397
 0,  0,  0, // 5398-5400
 0, // 5401
 0,  0,  0, // 5402-5404
 0,  0,  0, // 5405-5407
 0,  0,  0, // 5408-5410
 0,  0,  0, // 5411-5413
 0,  0,  0, // 5414-5416
 0,  0,  0, // 5417-5419
 0,  0, // 5420-5421
 0,  0, // 5422-5423
 0,  0,  0, // 5424-5426
 0,  0,  0, // 5427-5429
 0,  0,  0, // 5430-5432
 0,  0,  0, // 5433-5435
 0,  0,  0, // 5436-5438
 0,  0,  0, // 5439-5441
 0,  0, // 5442-5443
 0,  0, // 5444-5445
 0,  0,  0,  0, // 5446-5449
 0,  0,  0,  0, // 5450-5453
 0,  0, // 5454-5455
 0,  0, // 5456-5457
 0,  0, // 5458-5459
 0,  0, // 5460-5461
 0,  0,  0, // 5462-5464
 0,  0,  0, // 5465-5467
 0,  0,  0, // 5468-5470
 0,  0,  0, // 5471-5473
 0,  0,  0, // 5474-5476
 0,  0,  0, // 5477-5479
 0,  0, // 5480-5481
 0,  0, // 5482-5483
 0,  0,  0, // 5484-5486
 0,  0,  0, // 5487-5489
 0,  0,  0, // 5490-5492
 0,  0,  0, // 5493-5495
 0,  0, // 5496-5497
 0,  0, // 5498-5499
 0,  0,  0, // 5500-5502
 0,  0,  0, // 5503-5505
 0,  0,  0, // 5506-5508
 0,  0,  0, // 5509-5511
 0,  0,  0, // 5512-5514
 0,  0,  0, // 5515-5517
 0,  0,  0,  0, // 5518-5521
 0,  0,  0,  0, // 5522-5525
 0,  0,  0,  0,  0, // 5526-5530
 0,  0,  0,  0,  0, // 5531-5535
 0,  0,  0,  0,  0,  0, // 5536-5541
 0,  0,  0,  0,  0,  0, // 5542-5547
 0,  0,  0,  0, // 5548-5551
 0,  0,  0,  0, // 5552-5555
 0,  0,  0,  0, // 5556-5559
 0,  0, // 5560-5561
 0,  0, // 5562-5563
 0,  0, // 5564-5565
 0,  0, // 5566-5567
 0,  0,  0, // 5568-5570
 0,  0,  0, // 5571-5573
 0,  0,  0, // 5574-5576
 0,  0,  0, // 5577-5579
 0,  0,  0, // 5580-5582
 0,  0,  0, // 5583-5585
 0,  0,  0, // 5586-5588
 0,  0,  0, // 5589-5591
 0,  0,  0, // 5592-5594
 0,  0,  0, // 5595-5597
 0,  0,  0, // 5598-5600
 0,  0,  0, // 5601-5603
 0,  0,  0, // 5604-5606
 0,  0,  0, // 5607-5609
 0,  0,  0, // 5610-5612
 0,  0,  0, // 5613-5615
 0,  0,  0, // 5616-5618
 0,  0,  0, // 5619-5621
 0,  0,  0, // 5622-5624
 0,  0,  0, // 5625-5627
 0,  0,  0, // 5628-5630
 0,  0,  0, // 5631-5633
 0,  0,  0,  0, // 5634-5637
 0,  0,  0,  0, // 5638-5641
 0,  0,  0, // 5642-5644
 0,  0,  0, // 5645-5647
 0,  0,  0, // 5648-5650
 0,  0,  0,  0, // 5651-5654
 0,  0,  0,  0, // 5655-5658
 0,  0,  0, // 5659-5661
 0,  0,  0, // 5662-5664
 0,  0, // 5665-5666
 0,  0, // 5667-5668
 0,  0, // 5669-5670
 0,  0, // 5671-5672
 0,  0, // 5673-5674
 0,  0, // 5675-5676
 0,  0, // 5677-5678
 0,  0, // 5679-5680
 0,  0, // 5681-5682
 0,  0, // 5683-5684
 0,  0, // 5685-5686
 0,  0, // 5687-5688
 0,  0, // 5689-5690
 0,  0, // 5691-5692
 0, // 5693
 0,  0,  0, // 5694-5696
 0,  0, // 5697-5698
 0,  0, // 5699-5700
 0,  0, // 5701-5702
 0,  0, // 5703-5704
 0,  0, // 5705-5706
 0,  0, // 5707-5708
 0,  0, // 5709-5710
 0,  0, // 5711-5712
 0,  0, // 5713-5714
 0,  0,  0, // 5715-5717
 0,  0, // 5718-5719
 0,  0, // 5720-5721
 0,  0, // 5722-5723
 0,  0, // 5724-5725
 0, // 5726
 0, // 5727
 0, // 5728
 0,  0, // 5729-5730
 0,  0, // 5731-5732
 0,  0, // 5733-5734
 0,  0, // 5735-5736
 0,  0,  0,  0, // 5737-5740
 0,  0,  0, // 5741-5743
 0,  0,  0,  0, // 5744-5747
 0,  0,  0,  0,  0, // 5748-5752
 0,  0,  0, // 5753-5755
 0,  0,  0,  0, // 5756-5759
 0,  0,  0, // 5760-5762
 0,  0, // 5763-5764
 0,  0,  0, // 5765-5767
 0,  0,  0, // 5768-5770
 0 // End bypass tables
};

static const llvm::InstrItinerary ARMV6Itineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 1, 1, 2, 1, 3 }, // 1 IIC_iALUi_WriteALU_ReadALU
  { 1, 1, 2, 3, 6 }, // 2 IIC_iALUr_WriteALU_ReadALU_ReadALU
  { 1, 2, 3, 6, 10 }, // 3 IIC_iALUsr_WriteALUsi_ReadALU
  { 1, 2, 3, 10, 14 }, // 4 IIC_iALUsr_WriteALUsr_ReadALUsr
  { 1, 2, 3, 14, 18 }, // 5 IIC_iALUsr_WriteALUSsr_ReadALUsr
  { 1, 1, 2, 18, 20 }, // 6 IIC_iBITi_WriteALU_ReadALU
  { 1, 1, 2, 20, 23 }, // 7 IIC_iBITr_WriteALU_ReadALU_ReadALU
  { 1, 2, 3, 23, 27 }, // 8 IIC_iBITsr_WriteALUsi_ReadALU
  { 1, 2, 3, 27, 31 }, // 9 IIC_iBITsr_WriteALUsr_ReadALUsr
  { 1, 1, 2, 0, 0 }, // 10 IIC_Br_WriteBr
  { 1, 1, 2, 31, 33 }, // 11 IIC_iUNAsi
  { 1, 1, 2, 0, 0 }, // 12 IIC_Br_WriteBrL
  { 0, 0, 0, 0, 0 }, // 13 WriteBrL
  { 1, 1, 2, 0, 0 }, // 14 IIC_Br_WriteBrTbl
  { 0, 0, 0, 0, 0 }, // 15 WriteBr
  { 1, 1, 2, 33, 35 }, // 16 IIC_iUNAr_WriteALU
  { 1, 1, 2, 35, 36 }, // 17 IIC_iCMPi_WriteCMP_ReadALU
  { 1, 1, 2, 36, 38 }, // 18 IIC_iCMPr_WriteCMP_ReadALU_ReadALU
  { 1, 2, 3, 38, 41 }, // 19 IIC_iCMPsr_WriteCMPsi_ReadALU
  { 1, 2, 3, 41, 44 }, // 20 IIC_iCMPsr_WriteCMPsr_ReadALU
  { 1, 1, 2, 44, 46 }, // 21 IIC_fpUNA64
  { 1, 1, 2, 46, 48 }, // 22 IIC_fpUNA32
  { 1, 1, 2, 48, 49 }, // 23 IIC_fpSTAT
  { 1, 3, 4, 49, 54 }, // 24 IIC_iLoad_m
  { 1, 3, 4, 54, 59 }, // 25 IIC_iLoad_mu
  { 1, 4, 6, 59, 64 }, // 26 IIC_iLoad_mBr
  { 1, 1, 2, 64, 68 }, // 27 IIC_iLoad_bh_ru
  { 1, 1, 2, 68, 71 }, // 28 IIC_iLoad_bh_iu
  { 1, 1, 2, 71, 74 }, // 29 IIC_iLoad_bh_r
  { 1, 2, 3, 74, 77 }, // 30 IIC_iLoad_bh_si
  { 1, 1, 2, 77, 80 }, // 31 IIC_iLoad_d_r
  { 1, 1, 2, 80, 84 }, // 32 IIC_iLoad_d_ru
  { 1, 1, 2, 84, 86 }, // 33 IIC_iLoad_i
  { 1, 6, 8, 86, 88 }, // 34 IIC_iLoadiALU
  { 1, 1, 2, 88, 92 }, // 35 IIC_iLoad_ru
  { 1, 1, 2, 92, 95 }, // 36 IIC_iLoad_iu
  { 1, 1, 2, 95, 98 }, // 37 IIC_iLoad_r
  { 1, 2, 3, 98, 101 }, // 38 IIC_iLoad_si
  { 1, 2, 3, 101, 105 }, // 39 IIC_iMAC32
  { 1, 1, 2, 105, 106 }, // 40 IIC_iCMOVi_WriteALU
  { 1, 1, 2, 106, 107 }, // 41 IIC_iMOVi_WriteALU
  { 1, 6, 8, 107, 108 }, // 42 IIC_iCMOVix2
  { 1, 1, 2, 108, 110 }, // 43 IIC_iCMOVr_WriteALU
  { 1, 1, 2, 110, 113 }, // 44 IIC_iCMOVsr_WriteALU
  { 1, 8, 11, 113, 114 }, // 45 IIC_iMOVix2addpc
  { 1, 8, 11, 114, 115 }, // 46 IIC_iMOVix2ld
  { 1, 6, 8, 115, 116 }, // 47 IIC_iMOVix2
  { 1, 1, 2, 116, 118 }, // 48 IIC_iMOVr_WriteALU
  { 1, 2, 3, 118, 121 }, // 49 IIC_iMOVsr_WriteALU
  { 1, 1, 2, 121, 123 }, // 50 IIC_iMOVsi_WriteALU
  { 1, 2, 3, 123, 126 }, // 51 IIC_iMUL32
  { 1, 1, 2, 126, 127 }, // 52 IIC_iMVNi_WriteALU
  { 1, 1, 2, 127, 129 }, // 53 IIC_iMVNr_WriteALU
  { 1, 2, 3, 129, 132 }, // 54 IIC_iMVNsr_WriteALU
  { 1, 1, 2, 132, 135 }, // 55 IIC_iALUr_WriteALU_ReadALU
  { 1, 1, 2, 135, 138 }, // 56 IIC_iStore_r
  { 1, 1, 2, 138, 141 }, // 57 IIC_iStore_bh_r
  { 1, 1, 2, 141, 144 }, // 58 IIC_iALUsi_WriteALUsi_ReadALU
  { 1, 1, 2, 144, 147 }, // 59 IIC_iBITsi_WriteALUsi_ReadALU
  { 0, 0, 0, 0, 0 }, // 60 IIC_Preload_WritePreLd
  { 0, 0, 0, 0, 0 }, // 61 IIC_iDIV
  { 1, 1, 2, 147, 151 }, // 62 IIC_iMAC16
  { 1, 3, 4, 151, 155 }, // 63 IIC_iMAC64
  { 1, 1, 2, 155, 158 }, // 64 IIC_iMUL16
  { 1, 3, 4, 158, 161 }, // 65 IIC_iMUL64
  { 1, 3, 4, 0, 0 }, // 66 IIC_iStore_m
  { 1, 3, 4, 161, 162 }, // 67 IIC_iStore_mu
  { 1, 1, 2, 162, 166 }, // 68 IIC_iStore_bh_ru
  { 1, 1, 2, 166, 169 }, // 69 IIC_iStore_bh_iu
  { 1, 1, 2, 169, 173 }, // 70 IIC_iStore_ru
  { 1, 2, 3, 173, 176 }, // 71 IIC_iStore_bh_si
  { 1, 1, 2, 176, 179 }, // 72 IIC_iStore_d_r
  { 1, 1, 2, 179, 183 }, // 73 IIC_iStore_d_ru
  { 1, 1, 2, 183, 186 }, // 74 IIC_iStore_iu
  { 1, 2, 3, 186, 189 }, // 75 IIC_iStore_si
  { 1, 1, 2, 0, 0 }, // 76 IIC_Br
  { 1, 1, 2, 189, 192 }, // 77 IIC_iEXTAr_WriteALUsr
  { 1, 1, 2, 192, 194 }, // 78 IIC_iEXTr_WriteALUsi
  { 1, 1, 2, 194, 195 }, // 79 IIC_iTSTi_WriteCMP_ReadALU
  { 1, 1, 2, 195, 197 }, // 80 IIC_iTSTr_WriteCMP_ReadALU_ReadALU
  { 1, 2, 3, 197, 200 }, // 81 IIC_iTSTsr_WriteCMPsi_ReadALU
  { 1, 2, 3, 200, 203 }, // 82 IIC_iTSTsr_WriteCMPsr_ReadALU
  { 0, 0, 0, 0, 0 }, // 83 WriteALU_ReadALU_ReadALU
  { 0, 0, 0, 0, 0 }, // 84 IIC_VABAD
  { 0, 0, 0, 0, 0 }, // 85 IIC_VABAQ
  { 0, 0, 0, 0, 0 }, // 86 IIC_VSUBi4Q
  { 0, 0, 0, 0, 0 }, // 87 IIC_VBIND
  { 0, 0, 0, 0, 0 }, // 88 IIC_VBINQ
  { 0, 0, 0, 0, 0 }, // 89 IIC_VSUBi4D
  { 0, 0, 0, 0, 0 }, // 90 IIC_VUNAD
  { 0, 0, 0, 0, 0 }, // 91 IIC_VUNAQ
  { 0, 0, 0, 0, 0 }, // 92 IIC_VUNAiQ
  { 0, 0, 0, 0, 0 }, // 93 IIC_VUNAiD
  { 1, 1, 2, 203, 206 }, // 94 IIC_fpALU64
  { 0, 0, 0, 0, 0 }, // 95 IIC_VBINi4D
  { 0, 0, 0, 0, 0 }, // 96 IIC_VSHLiD
  { 1, 1, 2, 206, 209 }, // 97 IIC_fpALU32
  { 0, 0, 0, 0, 0 }, // 98 IIC_VSUBiD
  { 0, 0, 0, 0, 0 }, // 99 IIC_VBINiQ
  { 0, 0, 0, 0, 0 }, // 100 IIC_VBINiD
  { 0, 0, 0, 0, 0 }, // 101 IIC_VMOVImm
  { 0, 0, 0, 0, 0 }, // 102 IIC_VCNTiD
  { 0, 0, 0, 0, 0 }, // 103 IIC_VCNTiQ
  { 1, 1, 2, 209, 211 }, // 104 IIC_fpCMP64
  { 1, 1, 2, 211, 213 }, // 105 IIC_fpCMP32
  { 0, 0, 0, 0, 0 }, // 106 IIC_fpCVTSH
  { 0, 0, 0, 0, 0 }, // 107 IIC_fpCVTHS
  { 1, 1, 2, 213, 215 }, // 108 IIC_fpCVTDS
  { 1, 1, 2, 215, 217 }, // 109 IIC_fpCVTSD
  { 1, 11, 12, 217, 220 }, // 110 IIC_fpDIV64
  { 1, 12, 13, 220, 223 }, // 111 IIC_fpDIV32
  { 0, 0, 0, 0, 0 }, // 112 IIC_VMOVIS
  { 0, 0, 0, 0, 0 }, // 113 IIC_VMOVD
  { 0, 0, 0, 0, 0 }, // 114 IIC_VMOVQ
  { 0, 0, 0, 0, 0 }, // 115 IIC_VEXTD
  { 0, 0, 0, 0, 0 }, // 116 IIC_VEXTQ
  { 1, 2, 3, 223, 227 }, // 117 IIC_fpFMAC64
  { 1, 1, 2, 227, 231 }, // 118 IIC_fpFMAC32
  { 0, 0, 0, 0, 0 }, // 119 IIC_VFMACD
  { 0, 0, 0, 0, 0 }, // 120 IIC_VFMACQ
  { 0, 0, 0, 0, 0 }, // 121 IIC_VMOVSI
  { 0, 0, 0, 0, 0 }, // 122 IIC_VBINi4Q
  { 0, 0, 0, 0, 0 }, // 123 IIC_VLD1dup
  { 0, 0, 0, 0, 0 }, // 124 IIC_VLD1dupu
  { 0, 0, 0, 0, 0 }, // 125 IIC_VLD1ln
  { 0, 0, 0, 0, 0 }, // 126 IIC_VLD1lnu
  { 0, 0, 0, 0, 0 }, // 127 IIC_VLD1
  { 0, 0, 0, 0, 0 }, // 128 IIC_VLD1x4
  { 0, 0, 0, 0, 0 }, // 129 IIC_VLD1x2u
  { 0, 0, 0, 0, 0 }, // 130 IIC_VLD1x3
  { 0, 0, 0, 0, 0 }, // 131 IIC_VLD1u
  { 0, 0, 0, 0, 0 }, // 132 IIC_VLD1x2
  { 0, 0, 0, 0, 0 }, // 133 IIC_VLD2dup
  { 0, 0, 0, 0, 0 }, // 134 IIC_VLD2dupu
  { 0, 0, 0, 0, 0 }, // 135 IIC_VLD2ln
  { 0, 0, 0, 0, 0 }, // 136 IIC_VLD2lnu
  { 0, 0, 0, 0, 0 }, // 137 IIC_VLD2
  { 0, 0, 0, 0, 0 }, // 138 IIC_VLD2u
  { 0, 0, 0, 0, 0 }, // 139 IIC_VLD2x2
  { 0, 0, 0, 0, 0 }, // 140 IIC_VLD2x2u
  { 0, 0, 0, 0, 0 }, // 141 IIC_VLD3dup
  { 0, 0, 0, 0, 0 }, // 142 IIC_VLD3dupu
  { 0, 0, 0, 0, 0 }, // 143 IIC_VLD3ln
  { 0, 0, 0, 0, 0 }, // 144 IIC_VLD3lnu
  { 0, 0, 0, 0, 0 }, // 145 IIC_VLD3
  { 0, 0, 0, 0, 0 }, // 146 IIC_VLD3u
  { 0, 0, 0, 0, 0 }, // 147 IIC_VLD4dup
  { 0, 0, 0, 0, 0 }, // 148 IIC_VLD4dupu
  { 0, 0, 0, 0, 0 }, // 149 IIC_VLD4ln
  { 0, 0, 0, 0, 0 }, // 150 IIC_VLD4lnu
  { 0, 0, 0, 0, 0 }, // 151 IIC_VLD4
  { 0, 0, 0, 0, 0 }, // 152 IIC_VLD4u
  { 1, 3, 4, 231, 236 }, // 153 IIC_fpLoad_mu
  { 1, 3, 4, 236, 240 }, // 154 IIC_fpLoad_m
  { 1, 1, 2, 240, 243 }, // 155 IIC_fpLoad64
  { 1, 1, 2, 243, 246 }, // 156 IIC_fpLoad32
  { 1, 2, 3, 246, 250 }, // 157 IIC_fpMAC64
  { 0, 0, 0, 0, 0 }, // 158 IIC_VMACi32D
  { 0, 0, 0, 0, 0 }, // 159 IIC_VMACi16D
  { 1, 1, 2, 250, 254 }, // 160 IIC_fpMAC32
  { 0, 0, 0, 0, 0 }, // 161 IIC_VMACD
  { 0, 0, 0, 0, 0 }, // 162 IIC_VMACQ
  { 0, 0, 0, 0, 0 }, // 163 IIC_VMACi32Q
  { 0, 0, 0, 0, 0 }, // 164 IIC_VMACi16Q
  { 1, 1, 2, 254, 257 }, // 165 IIC_fpMOVID
  { 0, 0, 0, 0, 0 }, // 166 IIC_VQUNAiD
  { 0, 0, 0, 0, 0 }, // 167 IIC_VMOVN
  { 1, 1, 2, 257, 260 }, // 168 IIC_fpMOVDI
  { 1, 1, 2, 260, 262 }, // 169 IIC_fpMOVSI
  { 1, 1, 2, 262, 264 }, // 170 IIC_fpMOVIS
  { 1, 2, 3, 264, 267 }, // 171 IIC_fpMUL64
  { 0, 0, 0, 0, 0 }, // 172 IIC_VMULi16D
  { 0, 0, 0, 0, 0 }, // 173 IIC_VMULi32D
  { 1, 1, 2, 267, 270 }, // 174 IIC_fpMUL32
  { 0, 0, 0, 0, 0 }, // 175 IIC_VFMULD
  { 0, 0, 0, 0, 0 }, // 176 IIC_VFMULQ
  { 0, 0, 0, 0, 0 }, // 177 IIC_VMULi16Q
  { 0, 0, 0, 0, 0 }, // 178 IIC_VMULi32Q
  { 0, 0, 0, 0, 0 }, // 179 IIC_VSHLiQ
  { 0, 0, 0, 0, 0 }, // 180 IIC_VPALiQ
  { 0, 0, 0, 0, 0 }, // 181 IIC_VPALiD
  { 0, 0, 0, 0, 0 }, // 182 IIC_VPBIND
  { 0, 0, 0, 0, 0 }, // 183 IIC_VQUNAiQ
  { 0, 0, 0, 0, 0 }, // 184 IIC_VSHLi4Q
  { 0, 0, 0, 0, 0 }, // 185 IIC_VSHLi4D
  { 0, 0, 0, 0, 0 }, // 186 IIC_VRECSD
  { 0, 0, 0, 0, 0 }, // 187 IIC_VRECSQ
  { 0, 0, 0, 0, 0 }, // 188 IIC_VMOVISL
  { 1, 1, 2, 270, 272 }, // 189 IIC_fpCVTID_WriteCvtFP
  { 1, 1, 2, 272, 274 }, // 190 IIC_fpCVTIS_WriteCvtFP
  { 1, 1, 2, 274, 276 }, // 191 IIC_fpCVTID
  { 1, 1, 2, 276, 278 }, // 192 IIC_fpCVTIS
  { 1, 11, 12, 278, 281 }, // 193 IIC_fpSQRT64
  { 1, 12, 13, 281, 284 }, // 194 IIC_fpSQRT32
  { 0, 0, 0, 0, 0 }, // 195 IIC_VST1ln
  { 0, 0, 0, 0, 0 }, // 196 IIC_VST1lnu
  { 0, 0, 0, 0, 0 }, // 197 IIC_VST1
  { 0, 0, 0, 0, 0 }, // 198 IIC_VST1x4
  { 0, 0, 0, 0, 0 }, // 199 IIC_VLD1x4u
  { 0, 0, 0, 0, 0 }, // 200 IIC_VST1x3
  { 0, 0, 0, 0, 0 }, // 201 IIC_VLD1x3u
  { 0, 0, 0, 0, 0 }, // 202 IIC_VST1x4u
  { 0, 0, 0, 0, 0 }, // 203 IIC_VST1x3u
  { 0, 0, 0, 0, 0 }, // 204 IIC_VST1x2
  { 0, 0, 0, 0, 0 }, // 205 IIC_VST2ln
  { 0, 0, 0, 0, 0 }, // 206 IIC_VST2lnu
  { 0, 0, 0, 0, 0 }, // 207 IIC_VST2
  { 0, 0, 0, 0, 0 }, // 208 IIC_VST2x2
  { 0, 0, 0, 0, 0 }, // 209 IIC_VST2x2u
  { 0, 0, 0, 0, 0 }, // 210 IIC_VST3ln
  { 0, 0, 0, 0, 0 }, // 211 IIC_VST3lnu
  { 0, 0, 0, 0, 0 }, // 212 IIC_VST3
  { 0, 0, 0, 0, 0 }, // 213 IIC_VST3u
  { 0, 0, 0, 0, 0 }, // 214 IIC_VST4ln
  { 0, 0, 0, 0, 0 }, // 215 IIC_VST4lnu
  { 0, 0, 0, 0, 0 }, // 216 IIC_VST4
  { 0, 0, 0, 0, 0 }, // 217 IIC_VST4u
  { 1, 3, 4, 284, 289 }, // 218 IIC_fpStore_mu
  { 1, 3, 4, 289, 293 }, // 219 IIC_fpStore_m
  { 1, 1, 2, 293, 296 }, // 220 IIC_fpStore64
  { 1, 1, 2, 296, 299 }, // 221 IIC_fpStore32
  { 0, 0, 0, 0, 0 }, // 222 IIC_VSUBiQ
  { 0, 0, 0, 0, 0 }, // 223 IIC_VTB1
  { 0, 0, 0, 0, 0 }, // 224 IIC_VTB2
  { 0, 0, 0, 0, 0 }, // 225 IIC_VTB3
  { 0, 0, 0, 0, 0 }, // 226 IIC_VTB4
  { 0, 0, 0, 0, 0 }, // 227 IIC_VTBX1
  { 0, 0, 0, 0, 0 }, // 228 IIC_VTBX2
  { 0, 0, 0, 0, 0 }, // 229 IIC_VTBX3
  { 0, 0, 0, 0, 0 }, // 230 IIC_VTBX4
  { 1, 1, 2, 299, 301 }, // 231 IIC_fpCVTDI_WriteCvtFP
  { 1, 1, 2, 301, 303 }, // 232 IIC_fpCVTSI_WriteCvtFP
  { 1, 1, 2, 303, 305 }, // 233 IIC_fpCVTDI
  { 1, 1, 2, 305, 307 }, // 234 IIC_fpCVTSI
  { 0, 0, 0, 0, 0 }, // 235 IIC_VPERMD
  { 0, 0, 0, 0, 0 }, // 236 IIC_VPERMQ
  { 0, 0, 0, 0, 0 }, // 237 IIC_VPERMQ3
  { 1, 1, 2, 307, 310 }, // 238 IIC_iALUsi_WriteALUsi_ReadALUsr
  { 1, 1, 2, 310, 312 }, // 239 IIC_iBITi
  { 1, 1, 2, 312, 314 }, // 240 IIC_iCMPsi_WriteCMPsi_ReadALU_ReadALU
  { 1, 1, 2, 314, 315 }, // 241 IIC_iCMPi_WriteCMP
  { 1, 1, 2, 315, 317 }, // 242 IIC_iCMPr_WriteCMP
  { 1, 1, 2, 317, 319 }, // 243 IIC_iCMPsi_WriteCMPsi
  { 1, 1, 2, 0, 0 }, // 244 IIC_iALUx
  { 1, 1, 2, 319, 321 }, // 245 IIC_iLoad_bh_i
  { 1, 1, 2, 321, 323 }, // 246 IIC_iLoad_d_i
  { 1, 1, 2, 323, 325 }, // 247 IIC_iCMOVsi_WriteALU
  { 1, 1, 2, 325, 326 }, // 248 IIC_iMOVi
  { 1, 1, 2, 326, 328 }, // 249 IIC_iMVNsi_WriteALU
  { 0, 0, 0, 0, 0 }, // 250 IIC_iALUsir_WriteALUsi_ReadALU
  { 1, 1, 2, 328, 330 }, // 251 IIC_iStore_bh_i
  { 1, 1, 2, 330, 332 }, // 252 IIC_iStore_i
  { 1, 2, 3, 332, 336 }, // 253 IIC_iEXTAsr
  { 1, 1, 2, 336, 338 }, // 254 IIC_iEXTr
  { 1, 1, 2, 338, 339 }, // 255 IIC_iTSTi_WriteCMP
  { 1, 1, 2, 339, 341 }, // 256 IIC_iTSTr_WriteCMP
  { 1, 1, 2, 341, 343 }, // 257 IIC_iTSTsi_WriteCMPsi
  { 1, 1, 2, 343, 346 }, // 258 IIC_iALUr_WriteALU
  { 1, 1, 2, 346, 348 }, // 259 IIC_iALUi_WriteALU
  { 1, 1, 2, 348, 351 }, // 260 IIC_iBITr_WriteALU
  { 1, 3, 4, 351, 354 }, // 261 IIC_iPop
  { 1, 4, 6, 354, 357 }, // 262 IIC_iPop_Br_WriteBrL
  { 1, 1, 2, 357, 359 }, // 263 IIC_iTSTr_WriteALU
  { 1, 1, 2, 359, 361 }, // 264 ANDri_BICri_EORri_ORRri
  { 1, 1, 2, 361, 364 }, // 265 ANDrr_BICrr_EORrr_ORRrr
  { 1, 2, 3, 364, 368 }, // 266 ANDrsi_BICrsi_EORrsi_ORRrsi
  { 1, 2, 3, 368, 372 }, // 267 ANDrsr_BICrsr_EORrsr_ORRrsr
  { 1, 1, 2, 372, 375 }, // 268 MOVCCsi_MOVCCsr
  { 1, 2, 3, 375, 378 }, // 269 MOVsi_MOVsr
  { 1, 1, 2, 378, 380 }, // 270 MOVsra_flag_MOVsrl_flag
  { 1, 2, 3, 380, 383 }, // 271 MVNsr
  { 1, 1, 2, 383, 385 }, // 272 MVNr
  { 1, 6, 8, 385, 386 }, // 273 MOVCCi32imm
  { 1, 6, 8, 386, 387 }, // 274 MOVi32imm
  { 1, 8, 11, 387, 388 }, // 275 MOV_ga_pcrel
  { 1, 8, 11, 388, 389 }, // 276 MOV_ga_pcrel_ldr
  { 0, 0, 0, 0, 0 }, // 277 SEL
  { 1, 1, 2, 389, 391 }, // 278 BFC_BFI_SBFX_UBFX
  { 1, 2, 3, 391, 395 }, // 279 MLA_MLAv5_MLS_SMMLA_SMMLAR_SMMLS_SMMLSR
  { 1, 2, 3, 395, 398 }, // 280 MUL_MULv5_SMMUL_SMMULR
  { 1, 3, 4, 398, 402 }, // 281 SMLAL_SMLALBB_SMLALBT_SMLALTB_SMLALTT_SMLALv5_UMAAL_UMLAL_UMLALv5
  { 1, 3, 4, 402, 405 }, // 282 SMULL_SMULLv5_UMULL_UMULLv5
  { 0, 0, 0, 0, 0 }, // 283 SMLAD_SMLADX_SMLALD_SMLALDX_SMLSD_SMLSDX_SMLSLD_SMLSLDX_SMUAD_SMUADX_SMUSD_SMUSDX
  { 1, 1, 2, 405, 408 }, // 284 SMULBB_SMULBT_SMULTB_SMULTT_SMULWB_SMULWT
  { 1, 1, 2, 408, 412 }, // 285 SMLABB_SMLABT_SMLATB_SMLATT_SMLAWB_SMLAWT
  { 1, 1, 2, 412, 415 }, // 286 LDRi12_PICLDR
  { 1, 2, 3, 415, 418 }, // 287 LDRrs
  { 1, 1, 2, 418, 421 }, // 288 LDRBi12_LDRH_LDRSB_LDRSH_PICLDRB_PICLDRH_PICLDRSB_PICLDRSH
  { 1, 1, 2, 421, 425 }, // 289 LDRHTi_LDRHTr_LDRH_POST_LDRH_PRE_LDRSBTi_LDRSBTr_LDRSB_POST_LDRSB_PRE_LDRSHTi_LDRSHTr_LDRSH_POST_LDRSH_PRE
  { 1, 1, 2, 425, 427 }, // 290 SXTB_SXTB16_SXTH_UXTB_UXTB16_UXTH
  { 1, 1, 2, 427, 429 }, // 291 t2SXTB_t2SXTB16_t2SXTH_t2UXTB_t2UXTB16_t2UXTH
  { 1, 6, 8, 429, 430 }, // 292 t2MOVCCi32imm
  { 1, 6, 8, 430, 431 }, // 293 t2MOVi32imm
  { 1, 8, 11, 431, 432 }, // 294 t2MOV_ga_pcrel
  { 1, 1, 2, 432, 433 }, // 295 t2MOVi16_ga_pcrel
  { 0, 0, 0, 0, 0 }, // 296 t2SEL
  { 1, 1, 2, 433, 435 }, // 297 t2BFC_t2SBFX_t2UBFX
  { 1, 1, 2, 435, 437 }, // 298 t2BFI
  { 1, 1, 2, 437, 440 }, // 299 QADD_QADD16_QADD8_QASX_QDADD_QDSUB_QSAX_QSUB_QSUB16_QSUB8_UQADD16_UQADD8_UQASX_UQSAX_UQSUB16_UQSUB8
  { 0, 0, 0, 0, 0 }, // 300 SSAT_SSAT16_USAT_USAT16_t2QADD_t2QADD16_t2QADD8_t2QASX_t2QDADD_t2QDSUB_t2QSAX_t2QSUB_t2QSUB16_t2QSUB8_t2SSAT_t2SSAT16_t2UQADD16_t2UQADD8_t2UQASX_t2UQSAX_t2UQSUB16_t2UQSUB8_t2USAT_t2USAT16
  { 1, 1, 2, 440, 443 }, // 301 SADD16_SADD8_SASX_SSAX_SSUB16_SSUB8_UADD16_UADD8_UASX_USAX_USUB16_USUB8
  { 0, 0, 0, 0, 0 }, // 302 t2SADD16_t2SADD8_t2SASX_t2SSAX_t2SSUB16_t2SSUB8_t2UADD16_t2UADD8_t2UASX_t2USAX_t2USUB16_t2USUB8
  { 1, 1, 2, 443, 446 }, // 303 SHADD16_SHADD8_SHASX_SHSAX_SHSUB16_SHSUB8_UHADD16_UHADD8_UHASX_UHSAX_UHSUB16_UHSUB8
  { 1, 1, 2, 446, 449 }, // 304 SXTAB_SXTAB16_SXTAH_UXTAB_UXTAB16_UXTAH
  { 0, 0, 0, 0, 0 }, // 305 t2SHADD16_t2SHADD8_t2SHASX_t2SHSAX_t2SHSUB16_t2SHSUB8_t2UHADD16_t2UHADD8_t2UHASX_t2UHSAX_t2UHSUB16_t2UHSUB8
  { 1, 2, 3, 449, 453 }, // 306 t2SXTAB_t2SXTAB16_t2SXTAH_t2UXTAB_t2UXTAB16_t2UXTAH
  { 0, 0, 0, 0, 0 }, // 307 USAD8
  { 0, 0, 0, 0, 0 }, // 308 USADA8
  { 0, 0, 0, 0, 0 }, // 309 SMUSD_SMUSDX
  { 1, 2, 3, 453, 456 }, // 310 t2MUL_t2SMMUL_t2SMMULR
  { 1, 1, 2, 456, 459 }, // 311 t2SMULBB_t2SMULBT_t2SMULTB_t2SMULTT_t2SMULWB_t2SMULWT
  { 1, 2, 3, 459, 463 }, // 312 t2SMUSD_t2SMUSDX
  { 1, 2, 3, 463, 467 }, // 313 t2MLA_t2MLS_t2SMMLA_t2SMMLAR_t2SMMLS_t2SMMLSR
  { 0, 0, 0, 0, 0 }, // 314 SMUAD_SMUADX
  { 1, 2, 3, 467, 471 }, // 315 t2SMUAD_t2SMUADX
  { 0, 0, 0, 0, 0 }, // 316 SMLSD_SMLSDX
  { 1, 1, 2, 471, 475 }, // 317 t2SMLABB_t2SMLABT_t2SMLATB_t2SMLATT_t2SMLAWB_t2SMLAWT
  { 1, 2, 3, 475, 479 }, // 318 t2SMLSD_t2SMLSDX
  { 0, 0, 0, 0, 0 }, // 319 SMLAD_SMLADX
  { 1, 2, 3, 479, 483 }, // 320 t2SMLAD_t2SMLADX
  { 1, 3, 4, 483, 486 }, // 321 SMULL_UMULL
  { 1, 3, 4, 486, 489 }, // 322 t2SMULL_t2UMULL
  { 1, 3, 4, 489, 493 }, // 323 t2SMLAL_t2SMLALBB_t2SMLALBT_t2SMLALD_t2SMLALDX_t2SMLALTB_t2SMLALTT_t2SMLSLD_t2SMLSLDX_t2UMAAL_t2UMLAL
  { 0, 0, 0, 0, 0 }, // 324 SDIV_UDIV_t2SDIV_t2UDIV
  { 1, 1, 2, 493, 496 }, // 325 LDRBi12
  { 1, 2, 3, 496, 499 }, // 326 LDRBrs_t2LDRBs_t2LDRHs
  { 0, 0, 0, 0, 0 }, // 327 LDREX_LDREXB_LDREXD_LDREXH_tLDRpci_pic
  { 1, 1, 2, 499, 502 }, // 328 LDRi12
  { 1, 1, 2, 502, 504 }, // 329 t2LDRBi12_t2LDRBi8_t2LDRBpci_t2LDRHi12_t2LDRHi8_t2LDRHpci_tLDRBi_tLDRHi
  { 1, 1, 2, 504, 506 }, // 330 t2LDRi12_t2LDRi8_t2LDRpci_tLDRi_tLDRpci_tLDRspi
  { 1, 6, 8, 506, 508 }, // 331 t2LDRpci_pic
  { 1, 2, 3, 508, 511 }, // 332 t2LDRs
  { 1, 1, 2, 511, 514 }, // 333 tLDRBr_tLDRHr
  { 1, 1, 2, 514, 517 }, // 334 tLDRr
  { 1, 1, 2, 517, 520 }, // 335 LDRH_PICLDRB_PICLDRH
  { 1, 1, 2, 520, 523 }, // 336 LDRcp
  { 1, 1, 2, 523, 525 }, // 337 t2LDRSBi12_t2LDRSBi8_t2LDRSBpci_t2LDRSHi12_t2LDRSHi8_t2LDRSHpci
  { 0, 0, 0, 0, 0 }, // 338 t2LDRSBpcrel_t2LDRSHpcrel
  { 1, 2, 3, 525, 528 }, // 339 t2LDRSBs_t2LDRSHs
  { 1, 1, 2, 528, 531 }, // 340 tLDRSB_tLDRSH
  { 1, 1, 2, 531, 535 }, // 341 LDRBT_POST_IMM_LDRBT_POST_REG_LDRB_POST_REG_LDRB_PRE_REG
  { 1, 1, 2, 535, 538 }, // 342 LDRB_POST_IMM_LDRB_PRE_IMM_t2LDRB_POST_t2LDRB_PRE_t2LDRH_POST_t2LDRH_PRE
  { 1, 1, 2, 538, 542 }, // 343 LDRHTi_LDRHTr_LDRH_POST_LDRH_PRE
  { 1, 1, 2, 542, 546 }, // 344 LDRT_POST_IMM_LDRT_POST_REG_LDR_POST_REG_LDR_PRE_REG
  { 1, 1, 2, 546, 549 }, // 345 LDR_POST_IMM_LDR_PRE_IMM_t2LDR_POST_t2LDR_PRE
  { 1, 1, 2, 549, 551 }, // 346 t2LDRBT_t2LDRHT
  { 1, 1, 2, 551, 553 }, // 347 t2LDRT
  { 1, 1, 2, 553, 555 }, // 348 t2LDRSBT_t2LDRSHT
  { 1, 1, 2, 555, 558 }, // 349 t2LDRSB_POST_t2LDRSB_PRE_t2LDRSH_POST_t2LDRSH_PRE
  { 1, 1, 2, 558, 561 }, // 350 LDRD
  { 1, 1, 2, 561, 563 }, // 351 t2LDRDi8
  { 1, 1, 2, 563, 567 }, // 352 LDRD_POST_LDRD_PRE_t2LDRD_POST_t2LDRD_PRE
  { 1, 3, 4, 567, 572 }, // 353 LDMDA_LDMDB_LDMIA_LDMIB_sysLDMDA_sysLDMDB_sysLDMIA_sysLDMIB_t2LDMDB_t2LDMIA_tLDMIA
  { 1, 3, 4, 572, 577 }, // 354 LDMDA_UPD_LDMDB_UPD_LDMIA_UPD_LDMIB_UPD_sysLDMDA_UPD_sysLDMDB_UPD_sysLDMIA_UPD_sysLDMIB_UPD_t2LDMDB_UPD_t2LDMIA_UPD_tLDMIA_UPD
  { 1, 4, 6, 577, 582 }, // 355 LDMIA_RET_t2LDMIA_RET
  { 1, 3, 4, 582, 585 }, // 356 tPOP
  { 1, 4, 6, 585, 588 }, // 357 tPOP_RET
  { 1, 1, 2, 588, 591 }, // 358 PICSTR_STRi12_tSTRr
  { 1, 1, 2, 591, 594 }, // 359 PICSTRB_PICSTRH_STRBi12_STRH_tSTRBr_tSTRHr
  { 1, 2, 3, 594, 597 }, // 360 STRBrs_t2STRBs_t2STRHs
  { 0, 0, 0, 0, 0 }, // 361 STREX_STREXB_STREXD_STREXH
  { 1, 2, 3, 597, 600 }, // 362 STRrs_t2STRs
  { 1, 1, 2, 600, 602 }, // 363 t2STRBi12_t2STRBi8_t2STRHi12_t2STRHi8_tSTRBi_tSTRHi
  { 1, 1, 2, 602, 604 }, // 364 t2STRi12_t2STRi8_tSTRi_tSTRspi
  { 0, 0, 0, 0, 0 }, // 365 STRBT_POST_STRT_POST
  { 1, 1, 2, 604, 608 }, // 366 STRBT_POST_IMM_STRBT_POST_REG_STRB_POST_REG_STRB_PRE_REG_STRHTi_STRHTr_STRH_POST_STRH_PRE
  { 1, 1, 2, 608, 611 }, // 367 STRB_POST_IMM_STRB_PRE_IMM_t2STRB_POST_t2STRB_PRE_t2STRH_POST
  { 1, 1, 2, 611, 615 }, // 368 STRBi_preidx_STRBr_preidx_STRH_preidx_STRT_POST_IMM_STRT_POST_REG_STR_POST_REG_STR_PRE_REG_STRi_preidx_STRr_preidx_t2STRB_preidx_t2STRH_preidx_t2STR_preidx
  { 1, 1, 2, 615, 618 }, // 369 STR_POST_IMM_STR_PRE_IMM_t2STRH_PRE_t2STR_POST_t2STR_PRE
  { 1, 1, 2, 618, 620 }, // 370 t2STRBT_t2STRHT
  { 1, 1, 2, 620, 622 }, // 371 t2STRT
  { 1, 1, 2, 622, 625 }, // 372 STRD_t2STRDi8
  { 1, 1, 2, 625, 629 }, // 373 STRD_POST_STRD_PRE_t2STRD_POST_t2STRD_PRE
  { 1, 3, 4, 0, 0 }, // 374 STMDA_STMDB_STMIA_STMIB_sysSTMDA_sysSTMDB_sysSTMIA_sysSTMIB_t2STMDB_t2STMIA
  { 1, 3, 4, 629, 630 }, // 375 STMDA_UPD_STMDB_UPD_STMIA_UPD_STMIB_UPD_sysSTMDA_UPD_sysSTMDB_UPD_sysSTMIA_UPD_sysSTMIB_UPD_t2STMDB_UPD_t2STMIA_UPD_tSTMIA_UPD
  { 1, 3, 4, 0, 0 }, // 376 tPUSH
  { 0, 0, 0, 0, 0 }, // 377 ITasm
  { 1, 1, 2, 0, 0 }, // 378 t2IT
  { 0, 0, 0, 0, 0 }, // 379 VADDLsv2i64_VADDLsv4i32_VADDLsv8i16_VADDLuv2i64_VADDLuv4i32_VADDLuv8i16_VNEGs16d_VNEGs32d_VNEGs8d_VPADDLsv16i8_VPADDLsv2i32_VPADDLsv4i16_VPADDLsv4i32_VPADDLsv8i16_VPADDLsv8i8_VPADDLuv16i8_VPADDLuv2i32_VPADDLuv4i16_VPADDLuv4i32_VPADDLuv8i16_VPADDLuv8i8_VPADDi16_VPADDi32_VPADDi8_VSHLLi16_VSHLLi32_VSHLLi8_VSHLLsv2i64_VSHLLsv4i32_VSHLLsv8i16_VSHLLuv2i64_VSHLLuv4i32_VSHLLuv8i16_VSHLiv16i8_VSHLiv1i64_VSHLiv2i32_VSHLiv2i64_VSHLiv4i16_VSHLiv4i32_VSHLiv8i16_VSHLiv8i8_VSHLsv1i64_VSHLsv2i32_VSHLsv4i16_VSHLsv8i8_VSHLuv1i64_VSHLuv2i32_VSHLuv4i16_VSHLuv8i8_VSHRsv16i8_VSHRsv1i64_VSHRsv2i32_VSHRsv2i64_VSHRsv4i16_VSHRsv4i32_VSHRsv8i16_VSHRsv8i8_VSHRuv16i8_VSHRuv1i64_VSHRuv2i32_VSHRuv2i64_VSHRuv4i16_VSHRuv4i32_VSHRuv8i16_VSHRuv8i8_VSLIv1i64_VSLIv2i32_VSLIv4i16_VSLIv8i8_VSRIv1i64_VSRIv2i32_VSRIv4i16_VSRIv8i8_VSUBLsv2i64_VSUBLsv4i32_VSUBLsv8i16_VSUBLuv2i64_VSUBLuv4i32_VSUBLuv8i16
  { 0, 0, 0, 0, 0 }, // 380 VADDWsv2i64_VADDWsv4i32_VADDWsv8i16_VADDWuv2i64_VADDWuv4i32_VADDWuv8i16_VSUBWsv2i64_VSUBWsv4i32_VSUBWsv8i16_VSUBWuv2i64_VSUBWuv4i32_VSUBWuv8i16_VSUBv1i64_VSUBv2i32_VSUBv4i16_VSUBv8i8
  { 0, 0, 0, 0, 0 }, // 381 VADDv16i8_VADDv2i64_VADDv4i32_VADDv8i16_VANDq_VBICq_VBIFq_VBITq_VEORq_VORNq_VORRq
  { 0, 0, 0, 0, 0 }, // 382 VADDv1i64_VADDv2i32_VADDv4i16_VADDv8i8_VANDd_VBICd_VBIFd_VBITd_VEORd_VORNd_VORRd
  { 0, 0, 0, 0, 0 }, // 383 VBICiv2i32_VBICiv4i16_VBICiv4i32_VBICiv8i16_VORRiv2i32_VORRiv4i16_VORRiv4i32_VORRiv8i16
  { 0, 0, 0, 0, 0 }, // 384 VBSLd_VCLSv2i32_VCLSv4i16_VCLSv8i8_VCLZv2i32_VCLZv4i16_VCLZv8i8_VCNTd
  { 0, 0, 0, 0, 0 }, // 385 VBSLq_VCLSv16i8_VCLSv4i32_VCLSv8i16_VCLZv16i8_VCLZv4i32_VCLZv8i16_VCNTq
  { 0, 0, 0, 0, 0 }, // 386 VHADDsv16i8_VHADDsv4i32_VHADDsv8i16_VHADDuv16i8_VHADDuv4i32_VHADDuv8i16_VRHADDsv16i8_VRHADDsv4i32_VRHADDsv8i16_VRHADDuv16i8_VRHADDuv4i32_VRHADDuv8i16_VTSTv16i8_VTSTv4i32_VTSTv8i16
  { 0, 0, 0, 0, 0 }, // 387 VHADDsv2i32_VHADDsv4i16_VHADDsv8i8_VHADDuv2i32_VHADDuv4i16_VHADDuv8i8_VRHADDsv2i32_VRHADDsv4i16_VRHADDsv8i8_VRHADDuv2i32_VRHADDuv4i16_VRHADDuv8i8_VTSTv2i32_VTSTv4i16_VTSTv8i8
  { 0, 0, 0, 0, 0 }, // 388 VHSUBsv16i8_VHSUBsv4i32_VHSUBsv8i16_VHSUBuv16i8_VHSUBuv4i32_VHSUBuv8i16
  { 0, 0, 0, 0, 0 }, // 389 VHSUBsv2i32_VHSUBsv4i16_VHSUBsv8i8_VHSUBuv2i32_VHSUBuv4i16_VHSUBuv8i8
  { 0, 0, 0, 0, 0 }, // 390 VNEGf32q
  { 0, 0, 0, 0, 0 }, // 391 VNEGfd
  { 0, 0, 0, 0, 0 }, // 392 VNEGs16q_VNEGs32q_VNEGs8q_VSHLsv16i8_VSHLsv2i64_VSHLsv4i32_VSHLsv8i16_VSHLuv16i8_VSHLuv2i64_VSHLuv4i32_VSHLuv8i16_VSLIv16i8_VSLIv2i64_VSLIv4i32_VSLIv8i16_VSRIv16i8_VSRIv2i64_VSRIv4i32_VSRIv8i16
  { 0, 0, 0, 0, 0 }, // 393 VQSHLsiv16i8_VQSHLsiv1i64_VQSHLsiv2i32_VQSHLsiv2i64_VQSHLsiv4i16_VQSHLsiv4i32_VQSHLsiv8i16_VQSHLsiv8i8_VQSHLsuv16i8_VQSHLsuv1i64_VQSHLsuv2i32_VQSHLsuv2i64_VQSHLsuv4i16_VQSHLsuv4i32_VQSHLsuv8i16_VQSHLsuv8i8_VQSHLsv1i64_VQSHLsv2i32_VQSHLsv4i16_VQSHLsv8i8_VQSHLuiv16i8_VQSHLuiv1i64_VQSHLuiv2i32_VQSHLuiv2i64_VQSHLuiv4i16_VQSHLuiv4i32_VQSHLuiv8i16_VQSHLuiv8i8_VQSHLuv1i64_VQSHLuv2i32_VQSHLuv4i16_VQSHLuv8i8
  { 0, 0, 0, 0, 0 }, // 394 VQSHLsv16i8_VQSHLsv2i64_VQSHLsv4i32_VQSHLsv8i16_VQSHLuv16i8_VQSHLuv2i64_VQSHLuv4i32_VQSHLuv8i16
  { 0, 0, 0, 0, 0 }, // 395 VSUBv16i8_VSUBv2i64_VSUBv4i32_VSUBv8i16
  { 0, 0, 0, 0, 0 }, // 396 VEXTd16_VEXTd32_VEXTd8
  { 0, 0, 0, 0, 0 }, // 397 VEXTq16_VEXTq32_VEXTq64_VEXTq8
  { 0, 0, 0, 0, 0 }, // 398 VREV16d8_VREV32d16_VREV32d8_VREV64d16_VREV64d32_VREV64d8
  { 0, 0, 0, 0, 0 }, // 399 VREV16q8_VREV32q16_VREV32q8_VREV64q16_VREV64q32_VREV64q8
  { 0, 0, 0, 0, 0 }, // 400 VABALsv2i64_VABALsv4i32_VABALsv8i16_VABALuv2i64_VABALuv4i32_VABALuv8i16_VABAsv2i32_VABAsv4i16_VABAsv8i8_VABAuv2i32_VABAuv4i16_VABAuv8i8
  { 0, 0, 0, 0, 0 }, // 401 VABAsv16i8_VABAsv4i32_VABAsv8i16_VABAuv16i8_VABAuv4i32_VABAuv8i16
  { 0, 0, 0, 0, 0 }, // 402 VABSfd
  { 0, 0, 0, 0, 0 }, // 403 VABSfq
  { 0, 0, 0, 0, 0 }, // 404 VABSv16i8_VABSv4i32_VABSv8i16
  { 0, 0, 0, 0, 0 }, // 405 VABSv2i32_VABSv4i16_VABSv8i8
  { 0, 0, 0, 0, 0 }, // 406 VACGEd_VACGTd_VCEQfd_VCGEfd_VCGTfd
  { 0, 0, 0, 0, 0 }, // 407 VACGEq_VACGTq_VCEQfq_VCGEfq_VCGTfq
  { 0, 0, 0, 0, 0 }, // 408 VCEQv16i8_VCEQv4i32_VCEQv8i16_VCGEsv16i8_VCGEsv4i32_VCGEsv8i16_VCGEuv16i8_VCGEuv4i32_VCGEuv8i16_VCGTsv16i8_VCGTsv4i32_VCGTsv8i16_VCGTuv16i8_VCGTuv4i32_VCGTuv8i16_VQSUBsv16i8_VQSUBsv2i64_VQSUBsv4i32_VQSUBsv8i16_VQSUBuv16i8_VQSUBuv2i64_VQSUBuv4i32_VQSUBuv8i16
  { 0, 0, 0, 0, 0 }, // 409 VCEQv2i32_VCEQv4i16_VCEQv8i8_VCGEsv2i32_VCGEsv4i16_VCGEsv8i8_VCGEuv2i32_VCGEuv4i16_VCGEuv8i8_VCGTsv2i32_VCGTsv4i16_VCGTsv8i8_VCGTuv2i32_VCGTuv4i16_VCGTuv8i8_VQSUBsv1i64_VQSUBsv2i32_VQSUBsv4i16_VQSUBsv8i8_VQSUBuv1i64_VQSUBuv2i32_VQSUBuv4i16_VQSUBuv8i8
  { 0, 0, 0, 0, 0 }, // 410 VCEQzv16i8_VCEQzv2f32_VCEQzv2i32_VCEQzv4f32_VCEQzv4i16_VCEQzv4i32_VCEQzv8i16_VCEQzv8i8_VCGEzv16i8_VCGEzv2f32_VCGEzv2i32_VCGEzv4f32_VCGEzv4i16_VCGEzv4i32_VCGEzv8i16_VCGEzv8i8_VCGTzv16i8_VCGTzv2f32_VCGTzv2i32_VCGTzv4f32_VCGTzv4i16_VCGTzv4i32_VCGTzv8i16_VCGTzv8i8_VCLEzv16i8_VCLEzv2f32_VCLEzv2i32_VCLEzv4f32_VCLEzv4i16_VCLEzv4i32_VCLEzv8i16_VCLEzv8i8_VCLTzv16i8_VCLTzv2f32_VCLTzv2i32_VCLTzv4f32_VCLTzv4i16_VCLTzv4i32_VCLTzv8i16_VCLTzv8i8
  { 0, 0, 0, 0, 0 }, // 411 VPADALsv16i8_VPADALsv4i32_VPADALsv8i16_VPADALuv16i8_VPADALuv4i32_VPADALuv8i16
  { 0, 0, 0, 0, 0 }, // 412 VPADALsv2i32_VPADALsv4i16_VPADALsv8i8_VPADALuv2i32_VPADALuv4i16_VPADALuv8i8_VRSRAsv16i8_VRSRAsv1i64_VRSRAsv2i32_VRSRAsv2i64_VRSRAsv4i16_VRSRAsv4i32_VRSRAsv8i16_VRSRAsv8i8_VRSRAuv16i8_VRSRAuv1i64_VRSRAuv2i32_VRSRAuv2i64_VRSRAuv4i16_VRSRAuv4i32_VRSRAuv8i16_VRSRAuv8i8_VSRAsv16i8_VSRAsv1i64_VSRAsv2i32_VSRAsv2i64_VSRAsv4i16_VSRAsv4i32_VSRAsv8i16_VSRAsv8i8_VSRAuv16i8_VSRAuv1i64_VSRAuv2i32_VSRAuv2i64_VSRAuv4i16_VSRAuv4i32_VSRAuv8i16_VSRAuv8i8
  { 0, 0, 0, 0, 0 }, // 413 VQABSv16i8_VQABSv4i32_VQABSv8i16_VQNEGv16i8_VQNEGv4i32_VQNEGv8i16
  { 0, 0, 0, 0, 0 }, // 414 VQABSv2i32_VQABSv4i16_VQABSv8i8_VQNEGv2i32_VQNEGv4i16_VQNEGv8i8
  { 0, 0, 0, 0, 0 }, // 415 VQADDsv16i8_VQADDsv2i64_VQADDsv4i32_VQADDsv8i16_VQADDuv16i8_VQADDuv2i64_VQADDuv4i32_VQADDuv8i16
  { 0, 0, 0, 0, 0 }, // 416 VQADDsv1i64_VQADDsv2i32_VQADDsv4i16_VQADDsv8i8_VQADDuv1i64_VQADDuv2i32_VQADDuv4i16_VQADDuv8i8
  { 0, 0, 0, 0, 0 }, // 417 VQRSHLsv16i8_VQRSHLsv2i64_VQRSHLsv4i32_VQRSHLsv8i16_VQRSHLuv16i8_VQRSHLuv2i64_VQRSHLuv4i32_VQRSHLuv8i16_VRSHLsv16i8_VRSHLsv2i64_VRSHLsv4i32_VRSHLsv8i16_VRSHLuv16i8_VRSHLuv2i64_VRSHLuv4i32_VRSHLuv8i16
  { 0, 0, 0, 0, 0 }, // 418 VQRSHLsv1i64_VQRSHLsv2i32_VQRSHLsv4i16_VQRSHLsv8i8_VQRSHLuv1i64_VQRSHLuv2i32_VQRSHLuv4i16_VQRSHLuv8i8_VRSHLsv1i64_VRSHLsv2i32_VRSHLsv4i16_VRSHLsv8i8_VRSHLuv1i64_VRSHLuv2i32_VRSHLuv4i16_VRSHLuv8i8_VRSHRsv16i8_VRSHRsv1i64_VRSHRsv2i32_VRSHRsv2i64_VRSHRsv4i16_VRSHRsv4i32_VRSHRsv8i16_VRSHRsv8i8_VRSHRuv16i8_VRSHRuv1i64_VRSHRuv2i32_VRSHRuv2i64_VRSHRuv4i16_VRSHRuv4i32_VRSHRuv8i16_VRSHRuv8i8
  { 0, 0, 0, 0, 0 }, // 419 VRECPEd_VRECPEfd_VRSQRTEd_VRSQRTEfd
  { 0, 0, 0, 0, 0 }, // 420 VRECPEfq_VRECPEq_VRSQRTEfq_VRSQRTEq
  { 0, 0, 0, 0, 0 }, // 421 VADDHNv2i32_VADDHNv4i16_VADDHNv8i8_VSUBHNv2i32_VSUBHNv4i16_VSUBHNv8i8
  { 0, 0, 0, 0, 0 }, // 422 VSHRNv2i32_VSHRNv4i16_VSHRNv8i8
  { 0, 0, 0, 0, 0 }, // 423 VQRSHRNsv2i32_VQRSHRNsv4i16_VQRSHRNsv8i8_VQRSHRNuv2i32_VQRSHRNuv4i16_VQRSHRNuv8i8_VQRSHRUNv2i32_VQRSHRUNv4i16_VQRSHRUNv8i8_VQSHRNsv2i32_VQSHRNsv4i16_VQSHRNsv8i8_VQSHRNuv2i32_VQSHRNuv4i16_VQSHRNuv8i8_VQSHRUNv2i32_VQSHRUNv4i16_VQSHRUNv8i8_VRSHRNv2i32_VRSHRNv4i16_VRSHRNv8i8
  { 0, 0, 0, 0, 0 }, // 424 VRADDHNv2i32_VRADDHNv4i16_VRADDHNv8i8_VRSUBHNv2i32_VRSUBHNv4i16_VRSUBHNv8i8
  { 0, 0, 0, 0, 0 }, // 425 VTBL1
  { 0, 0, 0, 0, 0 }, // 426 VTBX1
  { 0, 0, 0, 0, 0 }, // 427 VTBL2
  { 0, 0, 0, 0, 0 }, // 428 VTBX2
  { 0, 0, 0, 0, 0 }, // 429 VTBL3_VTBL3Pseudo
  { 0, 0, 0, 0, 0 }, // 430 VTBX3_VTBX3Pseudo
  { 0, 0, 0, 0, 0 }, // 431 VTBL4_VTBL4Pseudo
  { 0, 0, 0, 0, 0 }, // 432 VTBX4_VTBX4Pseudo
  { 0, 0, 0, 0, 0 }, // 433 VSWPd_VSWPq
  { 0, 0, 0, 0, 0 }, // 434 VTRNd16_VTRNd32_VTRNd8_VUZPd16_VUZPd8_VZIPd16_VZIPd8
  { 0, 0, 0, 0, 0 }, // 435 VTRNq16_VTRNq32_VTRNq8
  { 0, 0, 0, 0, 0 }, // 436 VUZPq16_VUZPq32_VUZPq8_VZIPq16_VZIPq32_VZIPq8
  { 1, 1, 2, 630, 632 }, // 437 VABSD_VNEGD
  { 1, 1, 2, 632, 634 }, // 438 VABSS_VNEGS
  { 1, 1, 2, 634, 636 }, // 439 VCMPD_VCMPED_VCMPEZD_VCMPZD
  { 1, 1, 2, 636, 638 }, // 440 VCMPES_VCMPEZS_VCMPS_VCMPZS
  { 0, 0, 0, 0, 0 }, // 441 VABDLsv2i64_VABDLsv4i32_VABDLsv8i16_VABDLuv2i64_VABDLuv4i32_VABDLuv8i16_VABDsv16i8_VABDsv4i32_VABDsv8i16_VABDuv16i8_VABDuv4i32_VABDuv8i16_VMAXsv16i8_VMAXsv4i32_VMAXsv8i16_VMAXuv16i8_VMAXuv4i32_VMAXuv8i16_VMINsv16i8_VMINsv4i32_VMINsv8i16_VMINuv16i8_VMINuv4i32_VMINuv8i16
  { 0, 0, 0, 0, 0 }, // 442 VABDfd_VADDfd_VMAXfd_VMINfd_VSUBfd
  { 0, 0, 0, 0, 0 }, // 443 VABDfq_VADDfq_VMAXfq_VMINfq_VSUBfq
  { 0, 0, 0, 0, 0 }, // 444 VABDsv2i32_VABDsv4i16_VABDsv8i8_VABDuv2i32_VABDuv4i16_VABDuv8i8_VMAXsv2i32_VMAXsv4i16_VMAXsv8i8_VMAXuv2i32_VMAXuv4i16_VMAXuv8i8_VMINsv2i32_VMINsv4i16_VMINsv8i8_VMINuv2i32_VMINuv4i16_VMINuv8i8_VPMAXs16_VPMAXs32_VPMAXs8_VPMAXu16_VPMAXu32_VPMAXu8_VPMINs16_VPMINs32_VPMINs8_VPMINu16_VPMINu32_VPMINu8
  { 1, 1, 2, 638, 641 }, // 445 VADDS_VSUBS
  { 0, 0, 0, 0, 0 }, // 446 VMAXNMD_VMAXNMND_VMAXNMNQ_VMAXNMS_VMINNMD_VMINNMND_VMINNMNQ_VMINNMS
  { 0, 0, 0, 0, 0 }, // 447 VPADDf_VPMAXf_VPMINf
  { 1, 1, 2, 641, 644 }, // 448 VADDD_VSUBD
  { 0, 0, 0, 0, 0 }, // 449 VRECPSfd_VRSQRTSfd
  { 0, 0, 0, 0, 0 }, // 450 VRECPSfq_VRSQRTSfq
  { 0, 0, 0, 0, 0 }, // 451 VMULLp64
  { 0, 0, 0, 0, 0 }, // 452 VMULLp8_VMULLslsv2i32_VMULLslsv4i16_VMULLsluv2i32_VMULLsluv4i16_VMULLsv4i32_VMULLsv8i16_VMULLuv4i32_VMULLuv8i16_VMULpd_VMULslv4i16_VMULv4i16_VMULv8i8_VQDMULHslv4i16_VQDMULHv4i16_VQDMULLslv2i32_VQDMULLslv4i16_VQDMULLv4i32_VQRDMULHslv4i16_VQRDMULHv4i16
  { 0, 0, 0, 0, 0 }, // 453 VMULLsv2i64_VMULLuv2i64_VMULslv2i32_VMULv2i32_VQDMULHslv2i32_VQDMULHv2i32_VQDMULLv2i64_VQRDMULHslv2i32_VQRDMULHv2i32
  { 1, 1, 2, 644, 647 }, // 454 VMULS_VNMULS
  { 0, 0, 0, 0, 0 }, // 455 VMULfd
  { 0, 0, 0, 0, 0 }, // 456 VMULfq
  { 0, 0, 0, 0, 0 }, // 457 VMULpq_VMULslv8i16_VMULv16i8_VMULv8i16_VQDMULHslv8i16_VQDMULHv8i16_VQRDMULHslv8i16_VQRDMULHv8i16
  { 0, 0, 0, 0, 0 }, // 458 VMULslfd
  { 0, 0, 0, 0, 0 }, // 459 VMULslfq
  { 0, 0, 0, 0, 0 }, // 460 VMULslv4i32_VMULv4i32_VQDMULHslv4i32_VQDMULHv4i32_VQRDMULHslv4i32_VQRDMULHv4i32
  { 1, 2, 3, 647, 650 }, // 461 VMULD_VNMULD
  { 1, 2, 3, 650, 654 }, // 462 VFMAD_VFMSD_VFNMAD_VFNMSD
  { 1, 1, 2, 654, 658 }, // 463 VFMAS_VFMSS_VFNMAS_VFNMSS
  { 1, 2, 3, 658, 662 }, // 464 VMLAD_VMLSD_VNMLAD_VNMLSD
  { 0, 0, 0, 0, 0 }, // 465 VMLALslsv2i32_VMLALsluv2i32_VMLALsv2i64_VMLALuv2i64_VMLAslv2i32_VMLAv2i32_VMLSLslsv2i32_VMLSLsluv2i32_VMLSLsv2i64_VMLSLuv2i64_VMLSslv2i32_VMLSv2i32_VQDMLALslv2i32_VQDMLALv2i64_VQDMLSLslv2i32_VQDMLSLv2i64
  { 0, 0, 0, 0, 0 }, // 466 VMLALslsv4i16_VMLALsluv4i16_VMLALsv4i32_VMLALsv8i16_VMLALuv4i32_VMLALuv8i16_VMLAslv4i16_VMLAv4i16_VMLAv8i8_VMLSLslsv4i16_VMLSLsluv4i16_VMLSLsv4i32_VMLSLsv8i16_VMLSLuv4i32_VMLSLuv8i16_VMLSslv4i16_VMLSv4i16_VMLSv8i8_VQDMLALslv4i16_VQDMLALv4i32_VQDMLSLslv4i16_VQDMLSLv4i32
  { 1, 1, 2, 662, 666 }, // 467 VMLAS_VMLSS_VNMLAS_VNMLSS
  { 0, 0, 0, 0, 0 }, // 468 VMLAfd_VMLAslfd_VMLSfd_VMLSslfd
  { 0, 0, 0, 0, 0 }, // 469 VMLAfq_VMLAslfq_VMLSfq_VMLSslfq
  { 0, 0, 0, 0, 0 }, // 470 VMLAslv4i32_VMLAv4i32_VMLSslv4i32_VMLSv4i32
  { 0, 0, 0, 0, 0 }, // 471 VMLAslv8i16_VMLAv16i8_VMLAv8i16_VMLSslv8i16_VMLSv16i8_VMLSv8i16
  { 0, 0, 0, 0, 0 }, // 472 VFMAfd_VFMSfd
  { 0, 0, 0, 0, 0 }, // 473 VFMAfq_VFMSfq
  { 0, 0, 0, 0, 0 }, // 474 VCVTANSD_VCVTANSQ_VCVTANUD_VCVTANUQ_VCVTASD_VCVTASS_VCVTAUD_VCVTAUS_VCVTBDH_VCVTBHD_VCVTMNSD_VCVTMNSQ_VCVTMNUD_VCVTMNUQ_VCVTMSD_VCVTMSS_VCVTMUD_VCVTMUS_VCVTNNSD_VCVTNNSQ_VCVTNNUD_VCVTNNUQ_VCVTNSD_VCVTNSS_VCVTNUD_VCVTNUS_VCVTPNSD_VCVTPNSQ_VCVTPNUD_VCVTPNUQ_VCVTPSD_VCVTPSS_VCVTPUD_VCVTPUS_VCVTTDH_VCVTTHD
  { 0, 0, 0, 0, 0 }, // 475 VCVTBHS_VCVTTHS
  { 0, 0, 0, 0, 0 }, // 476 VCVTBSH_VCVTTSH
  { 1, 1, 2, 666, 668 }, // 477 VCVTDS
  { 1, 1, 2, 668, 670 }, // 478 VCVTSD
  { 0, 0, 0, 0, 0 }, // 479 VCVTf2h_VCVTf2sq_VCVTf2uq_VCVTf2xsq_VCVTf2xuq_VCVTh2f_VCVTs2fq_VCVTu2fq_VCVTxs2fq_VCVTxu2fq
  { 0, 0, 0, 0, 0 }, // 480 VCVTf2sd_VCVTf2ud_VCVTf2xsd_VCVTf2xud_VCVTs2fd_VCVTu2fd_VCVTxs2fd_VCVTxu2fd
  { 1, 1, 2, 670, 672 }, // 481 VSITOD_VUITOD
  { 1, 1, 2, 672, 674 }, // 482 VSITOS_VUITOS
  { 1, 1, 2, 674, 676 }, // 483 VTOSHD_VTOSLD_VTOUHD_VTOULD
  { 1, 1, 2, 676, 678 }, // 484 VTOSHS_VTOSLS_VTOUHS_VTOULS
  { 1, 1, 2, 678, 680 }, // 485 VTOSIRD_VTOSIZD_VTOUIRD_VTOUIZD
  { 1, 1, 2, 680, 682 }, // 486 VTOSIRS_VTOSIZS_VTOUIRS_VTOUIZS
  { 1, 1, 2, 682, 684 }, // 487 FCONSTD_VMOVD_VMOVDcc
  { 1, 1, 2, 684, 686 }, // 488 FCONSTS_VMOVS_VMOVScc
  { 0, 0, 0, 0, 0 }, // 489 VMOVv16i8_VMOVv1i64_VMOVv2f32_VMOVv2i32_VMOVv2i64_VMOVv4f32_VMOVv4i16_VMOVv4i32_VMOVv8i16_VMOVv8i8_VMVNv2i32_VMVNv4i16_VMVNv4i32_VMVNv8i16
  { 0, 0, 0, 0, 0 }, // 490 VMVNd_VMVNq
  { 0, 0, 0, 0, 0 }, // 491 VMOVLsv2i64_VMOVLsv4i32_VMOVLsv8i16_VMOVLuv2i64_VMOVLuv4i32_VMOVLuv8i16
  { 0, 0, 0, 0, 0 }, // 492 VMOVNv2i32_VMOVNv4i16_VMOVNv8i8
  { 0, 0, 0, 0, 0 }, // 493 VQMOVNsuv2i32_VQMOVNsuv4i16_VQMOVNsuv8i8_VQMOVNsv2i32_VQMOVNsv4i16_VQMOVNsv8i8_VQMOVNuv2i32_VQMOVNuv4i16_VQMOVNuv8i8
  { 0, 0, 0, 0, 0 }, // 494 VDUPLN16d_VDUPLN32d_VDUPLN8d
  { 0, 0, 0, 0, 0 }, // 495 VDUPLN16q_VDUPLN32q_VDUPLN8q
  { 0, 0, 0, 0, 0 }, // 496 VDUP16d_VDUP16q_VDUP32d_VDUP32q_VDUP8d_VDUP8q
  { 1, 1, 2, 686, 688 }, // 497 VMOVRS
  { 1, 1, 2, 688, 690 }, // 498 VMOVSR
  { 0, 0, 0, 0, 0 }, // 499 VSETLNi16_VSETLNi32_VSETLNi8
  { 1, 1, 2, 690, 693 }, // 500 VMOVRRD_VMOVRRS
  { 1, 1, 2, 693, 696 }, // 501 VMOVDRR
  { 1, 1, 2, 696, 699 }, // 502 VMOVSRR
  { 0, 0, 0, 0, 0 }, // 503 VGETLNi32_VGETLNu16_VGETLNu8
  { 0, 0, 0, 0, 0 }, // 504 VGETLNs16_VGETLNs8
  { 1, 1, 2, 699, 700 }, // 505 VMRS_VMRS_FPEXC_VMRS_FPINST_VMRS_FPINST2_VMRS_FPSID_VMRS_MVFR0_VMRS_MVFR1_VMRS_MVFR2
  { 1, 1, 2, 700, 701 }, // 506 VMSR_VMSR_FPEXC_VMSR_FPINST_VMSR_FPINST2_VMSR_FPSID
  { 1, 1, 2, 701, 702 }, // 507 FMSTAT
  { 1, 1, 2, 702, 705 }, // 508 VLDRD
  { 1, 1, 2, 705, 708 }, // 509 VLDRS
  { 1, 1, 2, 708, 711 }, // 510 VSTRD
  { 1, 1, 2, 711, 714 }, // 511 VSTRS
  { 1, 3, 4, 714, 718 }, // 512 VLDMQIA
  { 1, 3, 4, 718, 722 }, // 513 VSTMQIA
  { 1, 3, 4, 722, 726 }, // 514 VLDMDIA_VLDMSIA
  { 1, 3, 4, 726, 731 }, // 515 VLDMDDB_UPD_VLDMDIA_UPD_VLDMSDB_UPD_VLDMSIA_UPD
  { 1, 3, 4, 731, 735 }, // 516 VSTMDIA_VSTMSIA
  { 1, 3, 4, 735, 740 }, // 517 VSTMDDB_UPD_VSTMDIA_UPD_VSTMSDB_UPD_VSTMSIA_UPD
  { 0, 0, 0, 0, 0 }, // 518 VLD1d16_VLD1d32_VLD1d64_VLD1d8
  { 0, 0, 0, 0, 0 }, // 519 VLD1q16_VLD1q32_VLD1q64_VLD1q8
  { 0, 0, 0, 0, 0 }, // 520 VLD1d16wb_fixed_VLD1d16wb_register_VLD1d32wb_fixed_VLD1d32wb_register_VLD1d64wb_fixed_VLD1d64wb_register_VLD1d8wb_fixed_VLD1d8wb_register
  { 0, 0, 0, 0, 0 }, // 521 VLD1q16wb_fixed_VLD1q16wb_register_VLD1q32wb_fixed_VLD1q32wb_register_VLD1q64wb_fixed_VLD1q64wb_register_VLD1q8wb_fixed_VLD1q8wb_register
  { 0, 0, 0, 0, 0 }, // 522 VLD1d16T_VLD1d32T_VLD1d64T_VLD1d64TPseudo_VLD1d64TPseudoWB_fixed_VLD1d64TPseudoWB_register_VLD1d8T
  { 0, 0, 0, 0, 0 }, // 523 VLD1d16Twb_fixed_VLD1d16Twb_register_VLD1d32Twb_fixed_VLD1d32Twb_register_VLD1d64Twb_fixed_VLD1d64Twb_register_VLD1d8Twb_fixed_VLD1d8Twb_register
  { 0, 0, 0, 0, 0 }, // 524 VLD1d16Q_VLD1d32Q_VLD1d64Q_VLD1d64QPseudo_VLD1d64QPseudoWB_fixed_VLD1d64QPseudoWB_register_VLD1d8Q
  { 0, 0, 0, 0, 0 }, // 525 VLD1d16Qwb_fixed_VLD1d16Qwb_register_VLD1d32Qwb_fixed_VLD1d32Qwb_register_VLD1d64Qwb_fixed_VLD1d64Qwb_register_VLD1d8Qwb_fixed_VLD1d8Qwb_register
  { 0, 0, 0, 0, 0 }, // 526 VLD2b16_VLD2b32_VLD2b8_VLD2d16_VLD2d32_VLD2d8
  { 0, 0, 0, 0, 0 }, // 527 VLD2q16_VLD2q16Pseudo_VLD2q32_VLD2q32Pseudo_VLD2q8_VLD2q8Pseudo
  { 0, 0, 0, 0, 0 }, // 528 VLD2b16wb_fixed_VLD2b16wb_register_VLD2b32wb_fixed_VLD2b32wb_register_VLD2b8wb_fixed_VLD2b8wb_register_VLD2d16wb_fixed_VLD2d16wb_register_VLD2d32wb_fixed_VLD2d32wb_register_VLD2d8wb_fixed_VLD2d8wb_register
  { 0, 0, 0, 0, 0 }, // 529 VLD2q16PseudoWB_fixed_VLD2q16PseudoWB_register_VLD2q16wb_fixed_VLD2q16wb_register_VLD2q32PseudoWB_fixed_VLD2q32PseudoWB_register_VLD2q32wb_fixed_VLD2q32wb_register_VLD2q8PseudoWB_fixed_VLD2q8PseudoWB_register_VLD2q8wb_fixed_VLD2q8wb_register
  { 0, 0, 0, 0, 0 }, // 530 VLD3d16_VLD3d32_VLD3d8_VLD3q16_VLD3q32_VLD3q8
  { 0, 0, 0, 0, 0 }, // 531 VLD3d16Pseudo_VLD3d32Pseudo_VLD3d8Pseudo_VLD3q16oddPseudo_VLD3q32oddPseudo_VLD3q8oddPseudo
  { 0, 0, 0, 0, 0 }, // 532 VLD3d16_UPD_VLD3d32_UPD_VLD3d8_UPD_VLD3q16_UPD_VLD3q32_UPD_VLD3q8_UPD
  { 0, 0, 0, 0, 0 }, // 533 VLD3d16Pseudo_UPD_VLD3d32Pseudo_UPD_VLD3d8Pseudo_UPD_VLD3q16Pseudo_UPD_VLD3q16oddPseudo_UPD_VLD3q32Pseudo_UPD_VLD3q32oddPseudo_UPD_VLD3q8Pseudo_UPD_VLD3q8oddPseudo_UPD
  { 0, 0, 0, 0, 0 }, // 534 VLD4d16_VLD4d32_VLD4d8_VLD4q16_VLD4q32_VLD4q8
  { 0, 0, 0, 0, 0 }, // 535 VLD4d16Pseudo_VLD4d32Pseudo_VLD4d8Pseudo_VLD4q16oddPseudo_VLD4q32oddPseudo_VLD4q8oddPseudo
  { 0, 0, 0, 0, 0 }, // 536 VLD4d16_UPD_VLD4d32_UPD_VLD4d8_UPD_VLD4q16_UPD_VLD4q32_UPD_VLD4q8_UPD
  { 0, 0, 0, 0, 0 }, // 537 VLD4d16Pseudo_UPD_VLD4d32Pseudo_UPD_VLD4d8Pseudo_UPD_VLD4q16Pseudo_UPD_VLD4q16oddPseudo_UPD_VLD4q32Pseudo_UPD_VLD4q32oddPseudo_UPD_VLD4q8Pseudo_UPD_VLD4q8oddPseudo_UPD
  { 0, 0, 0, 0, 0 }, // 538 VLD1DUPd16_VLD1DUPd32_VLD1DUPd8_VLD1DUPq16_VLD1DUPq32_VLD1DUPq8
  { 0, 0, 0, 0, 0 }, // 539 VLD1LNd16_VLD1LNd32_VLD1LNd8_VLD1LNq16Pseudo_VLD1LNq32Pseudo_VLD1LNq8Pseudo
  { 0, 0, 0, 0, 0 }, // 540 VLD1DUPd16wb_fixed_VLD1DUPd16wb_register_VLD1DUPd32wb_fixed_VLD1DUPd32wb_register_VLD1DUPd8wb_fixed_VLD1DUPd8wb_register_VLD1DUPq16wb_fixed_VLD1DUPq16wb_register_VLD1DUPq32wb_fixed_VLD1DUPq32wb_register_VLD1DUPq8wb_fixed_VLD1DUPq8wb_register
  { 0, 0, 0, 0, 0 }, // 541 VLD1LNd16_UPD_VLD1LNd32_UPD_VLD1LNd8_UPD_VLD1LNq16Pseudo_UPD_VLD1LNq32Pseudo_UPD_VLD1LNq8Pseudo_UPD
  { 0, 0, 0, 0, 0 }, // 542 VLD2DUPd16_VLD2DUPd16x2_VLD2DUPd32_VLD2DUPd32x2_VLD2DUPd8_VLD2DUPd8x2
  { 0, 0, 0, 0, 0 }, // 543 VLD2LNd16_VLD2LNd16Pseudo_VLD2LNd32_VLD2LNd32Pseudo_VLD2LNd8_VLD2LNd8Pseudo_VLD2LNq16_VLD2LNq16Pseudo_VLD2LNq32_VLD2LNq32Pseudo
  { 0, 0, 0, 0, 0 }, // 544 VLD2LNd16_UPD_VLD2LNd32_UPD_VLD2LNd8_UPD_VLD2LNq16_UPD_VLD2LNq32_UPD
  { 0, 0, 0, 0, 0 }, // 545 VLD2DUPd16wb_fixed_VLD2DUPd16wb_register_VLD2DUPd16x2wb_fixed_VLD2DUPd16x2wb_register_VLD2DUPd32wb_fixed_VLD2DUPd32wb_register_VLD2DUPd32x2wb_fixed_VLD2DUPd32x2wb_register_VLD2DUPd8wb_fixed_VLD2DUPd8wb_register_VLD2DUPd8x2wb_fixed_VLD2DUPd8x2wb_register
  { 0, 0, 0, 0, 0 }, // 546 VLD2LNd16Pseudo_UPD_VLD2LNd32Pseudo_UPD_VLD2LNd8Pseudo_UPD_VLD2LNq16Pseudo_UPD_VLD2LNq32Pseudo_UPD
  { 0, 0, 0, 0, 0 }, // 547 VLD3DUPd16_VLD3DUPd16Pseudo_VLD3DUPd32_VLD3DUPd32Pseudo_VLD3DUPd8_VLD3DUPd8Pseudo_VLD3DUPq16_VLD3DUPq32_VLD3DUPq8
  { 0, 0, 0, 0, 0 }, // 548 VLD3LNd16_VLD3LNd16Pseudo_VLD3LNd32_VLD3LNd32Pseudo_VLD3LNd8_VLD3LNd8Pseudo_VLD3LNq16_VLD3LNq16Pseudo_VLD3LNq32_VLD3LNq32Pseudo
  { 0, 0, 0, 0, 0 }, // 549 VLD3DUPd16_UPD_VLD3DUPd32_UPD_VLD3DUPd8_UPD_VLD3DUPq16_UPD_VLD3DUPq32_UPD_VLD3DUPq8_UPD
  { 0, 0, 0, 0, 0 }, // 550 VLD3LNd16_UPD_VLD3LNd32_UPD_VLD3LNd8_UPD_VLD3LNq16_UPD_VLD3LNq32_UPD
  { 0, 0, 0, 0, 0 }, // 551 VLD3DUPd16Pseudo_UPD_VLD3DUPd32Pseudo_UPD_VLD3DUPd8Pseudo_UPD
  { 0, 0, 0, 0, 0 }, // 552 VLD3LNd16Pseudo_UPD_VLD3LNd32Pseudo_UPD_VLD3LNd8Pseudo_UPD_VLD3LNq16Pseudo_UPD_VLD3LNq32Pseudo_UPD
  { 0, 0, 0, 0, 0 }, // 553 VLD4DUPd16_VLD4DUPd16Pseudo_VLD4DUPd32_VLD4DUPd32Pseudo_VLD4DUPd8_VLD4DUPd8Pseudo_VLD4DUPq16_VLD4DUPq32_VLD4DUPq8
  { 0, 0, 0, 0, 0 }, // 554 VLD4LNd16_VLD4LNd16Pseudo_VLD4LNd32_VLD4LNd32Pseudo_VLD4LNd8_VLD4LNd8Pseudo_VLD4LNq16_VLD4LNq16Pseudo_VLD4LNq32_VLD4LNq32Pseudo
  { 0, 0, 0, 0, 0 }, // 555 VLD4DUPd16_UPD_VLD4DUPd32_UPD_VLD4DUPd8_UPD_VLD4DUPq16_UPD_VLD4DUPq32_UPD_VLD4DUPq8_UPD
  { 0, 0, 0, 0, 0 }, // 556 VLD4LNd16_UPD_VLD4LNd32_UPD_VLD4LNd8_UPD_VLD4LNq16_UPD_VLD4LNq32_UPD
  { 0, 0, 0, 0, 0 }, // 557 VLD4DUPd16Pseudo_UPD_VLD4DUPd32Pseudo_UPD_VLD4DUPd8Pseudo_UPD
  { 0, 0, 0, 0, 0 }, // 558 VLD4LNd16Pseudo_UPD_VLD4LNd32Pseudo_UPD_VLD4LNd8Pseudo_UPD_VLD4LNq16Pseudo_UPD_VLD4LNq32Pseudo_UPD
  { 0, 0, 0, 0, 0 }, // 559 VST1d16_VST1d32_VST1d64_VST1d8
  { 0, 0, 0, 0, 0 }, // 560 VST1q16_VST1q32_VST1q64_VST1q8
  { 0, 0, 0, 0, 0 }, // 561 VST1d16wb_fixed_VST1d16wb_register_VST1d32wb_fixed_VST1d32wb_register_VST1d64wb_fixed_VST1d64wb_register_VST1d8wb_fixed_VST1d8wb_register
  { 0, 0, 0, 0, 0 }, // 562 VST1q16wb_fixed_VST1q16wb_register_VST1q32wb_fixed_VST1q32wb_register_VST1q64wb_fixed_VST1q64wb_register_VST1q8wb_fixed_VST1q8wb_register
  { 0, 0, 0, 0, 0 }, // 563 VST1d16T_VST1d32T_VST1d64T_VST1d64TPseudo_VST1d8T
  { 0, 0, 0, 0, 0 }, // 564 VST1d16Twb_fixed_VST1d16Twb_register_VST1d32Twb_fixed_VST1d32Twb_register_VST1d64Twb_fixed_VST1d64Twb_register_VST1d8Twb_fixed_VST1d8Twb_register
  { 0, 0, 0, 0, 0 }, // 565 VST1d64TPseudoWB_fixed_VST1d64TPseudoWB_register
  { 0, 0, 0, 0, 0 }, // 566 VST1d16Q_VST1d32Q_VST1d64Q_VST1d64QPseudo_VST1d8Q
  { 0, 0, 0, 0, 0 }, // 567 VST1d16Qwb_fixed_VST1d16Qwb_register_VST1d32Qwb_fixed_VST1d32Qwb_register_VST1d64Qwb_fixed_VST1d64Qwb_register_VST1d8Qwb_fixed_VST1d8Qwb_register
  { 0, 0, 0, 0, 0 }, // 568 VST1d64QPseudoWB_fixed_VST1d64QPseudoWB_register
  { 0, 0, 0, 0, 0 }, // 569 VST2b16_VST2b32_VST2b8_VST2d16_VST2d32_VST2d8
  { 0, 0, 0, 0, 0 }, // 570 VST2b16wb_fixed_VST2b16wb_register_VST2b32wb_fixed_VST2b32wb_register_VST2b8wb_fixed_VST2b8wb_register_VST2d16wb_fixed_VST2d16wb_register_VST2d32wb_fixed_VST2d32wb_register_VST2d8wb_fixed_VST2d8wb_register
  { 0, 0, 0, 0, 0 }, // 571 VST2q16_VST2q16Pseudo_VST2q32_VST2q32Pseudo_VST2q8_VST2q8Pseudo
  { 0, 0, 0, 0, 0 }, // 572 VST2q16PseudoWB_fixed_VST2q16PseudoWB_register_VST2q32PseudoWB_fixed_VST2q32PseudoWB_register_VST2q8PseudoWB_fixed_VST2q8PseudoWB_register
  { 0, 0, 0, 0, 0 }, // 573 VST2q16wb_fixed_VST2q16wb_register_VST2q32wb_fixed_VST2q32wb_register_VST2q8wb_fixed_VST2q8wb_register
  { 0, 0, 0, 0, 0 }, // 574 VST3d16_VST3d16Pseudo_VST3d32_VST3d32Pseudo_VST3d8_VST3d8Pseudo_VST3q16_VST3q16oddPseudo_VST3q32_VST3q32oddPseudo_VST3q8_VST3q8oddPseudo
  { 0, 0, 0, 0, 0 }, // 575 VST3d16Pseudo_UPD_VST3d16_UPD_VST3d32Pseudo_UPD_VST3d32_UPD_VST3d8Pseudo_UPD_VST3d8_UPD_VST3q16Pseudo_UPD_VST3q16_UPD_VST3q16oddPseudo_UPD_VST3q32Pseudo_UPD_VST3q32_UPD_VST3q32oddPseudo_UPD_VST3q8Pseudo_UPD_VST3q8_UPD_VST3q8oddPseudo_UPD
  { 0, 0, 0, 0, 0 }, // 576 VST4d16_VST4d16Pseudo_VST4d32_VST4d32Pseudo_VST4d8_VST4d8Pseudo_VST4q16_VST4q16oddPseudo_VST4q32_VST4q32oddPseudo_VST4q8_VST4q8oddPseudo
  { 0, 0, 0, 0, 0 }, // 577 VST4d16Pseudo_UPD_VST4d16_UPD_VST4d32Pseudo_UPD_VST4d32_UPD_VST4d8Pseudo_UPD_VST4d8_UPD_VST4q16Pseudo_UPD_VST4q16_UPD_VST4q16oddPseudo_UPD_VST4q32Pseudo_UPD_VST4q32_UPD_VST4q32oddPseudo_UPD_VST4q8Pseudo_UPD_VST4q8_UPD_VST4q8oddPseudo_UPD
  { 0, 0, 0, 0, 0 }, // 578 VST1LNd16_VST1LNd32_VST1LNd8_VST1LNq16Pseudo_VST1LNq32Pseudo_VST1LNq8Pseudo
  { 0, 0, 0, 0, 0 }, // 579 VST1LNd16_UPD_VST1LNd32_UPD_VST1LNd8_UPD_VST1LNq16Pseudo_UPD_VST1LNq32Pseudo_UPD_VST1LNq8Pseudo_UPD
  { 0, 0, 0, 0, 0 }, // 580 VST2LNd16_VST2LNd16Pseudo_VST2LNd32_VST2LNd32Pseudo_VST2LNd8_VST2LNd8Pseudo_VST2LNq16_VST2LNq16Pseudo_VST2LNq32_VST2LNq32Pseudo
  { 0, 0, 0, 0, 0 }, // 581 VST2LNd16Pseudo_UPD_VST2LNd16_UPD_VST2LNd32Pseudo_UPD_VST2LNd32_UPD_VST2LNd8Pseudo_UPD_VST2LNd8_UPD_VST2LNq16Pseudo_UPD_VST2LNq16_UPD_VST2LNq32Pseudo_UPD_VST2LNq32_UPD
  { 0, 0, 0, 0, 0 }, // 582 VST3LNd16_VST3LNd16Pseudo_VST3LNd32_VST3LNd32Pseudo_VST3LNd8_VST3LNd8Pseudo_VST3LNq16_VST3LNq16Pseudo_VST3LNq32_VST3LNq32Pseudo
  { 0, 0, 0, 0, 0 }, // 583 VST3LNd16Pseudo_UPD_VST3LNd16_UPD_VST3LNd32Pseudo_UPD_VST3LNd32_UPD_VST3LNd8Pseudo_UPD_VST3LNd8_UPD_VST3LNq16Pseudo_UPD_VST3LNq16_UPD_VST3LNq32Pseudo_UPD_VST3LNq32_UPD
  { 0, 0, 0, 0, 0 }, // 584 VST4LNd16_VST4LNd16Pseudo_VST4LNd32_VST4LNd32Pseudo_VST4LNd8_VST4LNd8Pseudo_VST4LNq16_VST4LNq16Pseudo_VST4LNq32_VST4LNq32Pseudo
  { 0, 0, 0, 0, 0 }, // 585 VST4LNd16Pseudo_UPD_VST4LNd16_UPD_VST4LNd32Pseudo_UPD_VST4LNd32_UPD_VST4LNd8Pseudo_UPD_VST4LNd8_UPD_VST4LNq16Pseudo_UPD_VST4LNq16_UPD_VST4LNq32Pseudo_UPD_VST4LNq32_UPD
  { 1, 12, 13, 740, 743 }, // 586 VDIVS
  { 1, 12, 13, 743, 746 }, // 587 VSQRTS
  { 1, 11, 12, 746, 749 }, // 588 VDIVD
  { 1, 11, 12, 749, 752 }, // 589 VSQRTD
  { 0, 0, 0, 0, 0 }, // 590 ABS
  { 0, ~0U, ~0U, ~0U, ~0U } // end marker
};

static const llvm::InstrItinerary CortexA9Itineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 1, 13, 15, 752, 754 }, // 1 IIC_iALUi_WriteALU_ReadALU
  { 1, 13, 15, 754, 757 }, // 2 IIC_iALUr_WriteALU_ReadALU_ReadALU
  { 1, 15, 17, 757, 761 }, // 3 IIC_iALUsr_WriteALUsi_ReadALU
  { 1, 15, 17, 761, 765 }, // 4 IIC_iALUsr_WriteALUsr_ReadALUsr
  { 1, 15, 17, 765, 769 }, // 5 IIC_iALUsr_WriteALUSsr_ReadALUsr
  { 1, 13, 15, 769, 771 }, // 6 IIC_iBITi_WriteALU_ReadALU
  { 1, 13, 15, 771, 774 }, // 7 IIC_iBITr_WriteALU_ReadALU_ReadALU
  { 1, 15, 17, 774, 778 }, // 8 IIC_iBITsr_WriteALUsi_ReadALU
  { 1, 15, 17, 778, 782 }, // 9 IIC_iBITsr_WriteALUsr_ReadALUsr
  { 1, 17, 20, 0, 0 }, // 10 IIC_Br_WriteBr
  { 1, 20, 22, 782, 784 }, // 11 IIC_iUNAsi
  { 1, 17, 20, 0, 0 }, // 12 IIC_Br_WriteBrL
  { 0, 0, 0, 0, 0 }, // 13 WriteBrL
  { 1, 17, 20, 0, 0 }, // 14 IIC_Br_WriteBrTbl
  { 0, 0, 0, 0, 0 }, // 15 WriteBr
  { 1, 13, 15, 784, 786 }, // 16 IIC_iUNAr_WriteALU
  { 1, 13, 15, 786, 787 }, // 17 IIC_iCMPi_WriteCMP_ReadALU
  { 1, 13, 15, 787, 789 }, // 18 IIC_iCMPr_WriteCMP_ReadALU_ReadALU
  { 1, 15, 17, 789, 792 }, // 19 IIC_iCMPsr_WriteCMPsi_ReadALU
  { 1, 15, 17, 792, 795 }, // 20 IIC_iCMPsr_WriteCMPsr_ReadALU
  { 1, 22, 27, 795, 797 }, // 21 IIC_fpUNA64
  { 1, 22, 27, 797, 799 }, // 22 IIC_fpUNA32
  { 1, 27, 32, 799, 800 }, // 23 IIC_fpSTAT
  { -1, 32, 36, 800, 805 }, // 24 IIC_iLoad_m
  { -1, 32, 36, 805, 810 }, // 25 IIC_iLoad_mu
  { -1, 36, 41, 810, 815 }, // 26 IIC_iLoad_mBr
  { 1, 41, 45, 815, 819 }, // 27 IIC_iLoad_bh_ru
  { 1, 41, 45, 819, 822 }, // 28 IIC_iLoad_bh_iu
  { 1, 41, 45, 822, 825 }, // 29 IIC_iLoad_bh_r
  { 1, 41, 45, 825, 828 }, // 30 IIC_iLoad_bh_si
  { 1, 41, 45, 828, 832 }, // 31 IIC_iLoad_d_r
  { 1, 41, 45, 832, 836 }, // 32 IIC_iLoad_d_ru
  { 1, 45, 49, 836, 838 }, // 33 IIC_iLoad_i
  { 1, 49, 54, 838, 840 }, // 34 IIC_iLoadiALU
  { 1, 45, 49, 840, 844 }, // 35 IIC_iLoad_ru
  { 1, 45, 49, 844, 847 }, // 36 IIC_iLoad_iu
  { 1, 45, 49, 847, 850 }, // 37 IIC_iLoad_r
  { 1, 54, 58, 850, 853 }, // 38 IIC_iLoad_si
  { 1, 58, 60, 853, 857 }, // 39 IIC_iMAC32
  { 1, 13, 15, 857, 858 }, // 40 IIC_iCMOVi_WriteALU
  { 1, 13, 15, 858, 859 }, // 41 IIC_iMOVi_WriteALU
  { 1, 60, 64, 859, 860 }, // 42 IIC_iCMOVix2
  { 1, 13, 15, 860, 862 }, // 43 IIC_iCMOVr_WriteALU
  { 1, 20, 22, 862, 865 }, // 44 IIC_iCMOVsr_WriteALU
  { 1, 64, 68, 865, 866 }, // 45 IIC_iMOVix2addpc
  { 1, 68, 74, 866, 867 }, // 46 IIC_iMOVix2ld
  { 1, 74, 77, 867, 868 }, // 47 IIC_iMOVix2
  { 1, 13, 15, 868, 870 }, // 48 IIC_iMOVr_WriteALU
  { 1, 20, 22, 870, 873 }, // 49 IIC_iMOVsr_WriteALU
  { 1, 13, 15, 873, 875 }, // 50 IIC_iMOVsi_WriteALU
  { 1, 58, 60, 875, 878 }, // 51 IIC_iMUL32
  { 1, 13, 15, 878, 879 }, // 52 IIC_iMVNi_WriteALU
  { 1, 13, 15, 879, 881 }, // 53 IIC_iMVNr_WriteALU
  { 1, 15, 17, 881, 884 }, // 54 IIC_iMVNsr_WriteALU
  { 1, 13, 15, 884, 887 }, // 55 IIC_iALUr_WriteALU_ReadALU
  { 1, 45, 49, 887, 890 }, // 56 IIC_iStore_r
  { 1, 77, 81, 890, 893 }, // 57 IIC_iStore_bh_r
  { 1, 20, 22, 893, 896 }, // 58 IIC_iALUsi_WriteALUsi_ReadALU
  { 1, 20, 22, 896, 899 }, // 59 IIC_iBITsi_WriteALUsi_ReadALU
  { 1, 81, 82, 899, 901 }, // 60 IIC_Preload_WritePreLd
  { 0, 0, 0, 0, 0 }, // 61 IIC_iDIV
  { 1, 58, 60, 901, 905 }, // 62 IIC_iMAC16
  { 1, 82, 84, 905, 909 }, // 63 IIC_iMAC64
  { 1, 58, 60, 909, 912 }, // 64 IIC_iMUL16
  { 1, 82, 84, 912, 916 }, // 65 IIC_iMUL64
  { -1, 84, 88, 0, 0 }, // 66 IIC_iStore_m
  { -1, 84, 88, 916, 917 }, // 67 IIC_iStore_mu
  { 1, 77, 81, 917, 921 }, // 68 IIC_iStore_bh_ru
  { 1, 77, 81, 921, 924 }, // 69 IIC_iStore_bh_iu
  { 1, 45, 49, 924, 928 }, // 70 IIC_iStore_ru
  { 1, 77, 81, 928, 931 }, // 71 IIC_iStore_bh_si
  { 1, 77, 81, 931, 934 }, // 72 IIC_iStore_d_r
  { 1, 77, 81, 934, 938 }, // 73 IIC_iStore_d_ru
  { 1, 45, 49, 938, 941 }, // 74 IIC_iStore_iu
  { 1, 45, 49, 941, 944 }, // 75 IIC_iStore_si
  { 1, 17, 20, 0, 0 }, // 76 IIC_Br
  { 1, 20, 22, 944, 947 }, // 77 IIC_iEXTAr_WriteALUsr
  { 1, 13, 15, 947, 949 }, // 78 IIC_iEXTr_WriteALUsi
  { 1, 13, 15, 949, 950 }, // 79 IIC_iTSTi_WriteCMP_ReadALU
  { 1, 13, 15, 950, 952 }, // 80 IIC_iTSTr_WriteCMP_ReadALU_ReadALU
  { 1, 15, 17, 952, 955 }, // 81 IIC_iTSTsr_WriteCMPsi_ReadALU
  { 1, 15, 17, 955, 958 }, // 82 IIC_iTSTsr_WriteCMPsr_ReadALU
  { 0, 0, 0, 0, 0 }, // 83 WriteALU_ReadALU_ReadALU
  { 1, 88, 93, 958, 962 }, // 84 IIC_VABAD
  { 1, 93, 98, 962, 966 }, // 85 IIC_VABAQ
  { 1, 88, 93, 966, 969 }, // 86 IIC_VSUBi4Q
  { 1, 88, 93, 969, 972 }, // 87 IIC_VBIND
  { 1, 98, 103, 972, 975 }, // 88 IIC_VBINQ
  { 1, 88, 93, 975, 978 }, // 89 IIC_VSUBi4D
  { 1, 88, 93, 978, 980 }, // 90 IIC_VUNAD
  { 1, 98, 103, 980, 982 }, // 91 IIC_VUNAQ
  { 1, 88, 93, 982, 984 }, // 92 IIC_VUNAiQ
  { 1, 88, 93, 984, 986 }, // 93 IIC_VUNAiD
  { 1, 103, 108, 986, 989 }, // 94 IIC_fpALU64
  { 1, 88, 93, 989, 992 }, // 95 IIC_VBINi4D
  { 1, 88, 93, 992, 995 }, // 96 IIC_VSHLiD
  { 1, 103, 108, 995, 998 }, // 97 IIC_fpALU32
  { 1, 88, 93, 998, 1001 }, // 98 IIC_VSUBiD
  { 1, 88, 93, 1001, 1004 }, // 99 IIC_VBINiQ
  { 1, 88, 93, 1004, 1007 }, // 100 IIC_VBINiD
  { 1, 88, 93, 1007, 1008 }, // 101 IIC_VMOVImm
  { 1, 88, 93, 1008, 1011 }, // 102 IIC_VCNTiD
  { 1, 98, 103, 1011, 1014 }, // 103 IIC_VCNTiQ
  { 1, 103, 108, 1014, 1016 }, // 104 IIC_fpCMP64
  { 1, 103, 108, 1016, 1018 }, // 105 IIC_fpCMP32
  { 1, 103, 108, 1018, 1020 }, // 106 IIC_fpCVTSH
  { 1, 22, 27, 1020, 1022 }, // 107 IIC_fpCVTHS
  { 1, 103, 108, 1022, 1024 }, // 108 IIC_fpCVTDS
  { 1, 103, 108, 1024, 1026 }, // 109 IIC_fpCVTSD
  { 1, 108, 113, 1026, 1029 }, // 110 IIC_fpDIV64
  { 1, 113, 118, 1029, 1032 }, // 111 IIC_fpDIV32
  { 1, 118, 123, 1032, 1034 }, // 112 IIC_VMOVIS
  { 1, 88, 93, 1034, 1036 }, // 113 IIC_VMOVD
  { 1, 88, 93, 1036, 1038 }, // 114 IIC_VMOVQ
  { 1, 88, 93, 1038, 1041 }, // 115 IIC_VEXTD
  { 1, 98, 103, 1041, 1044 }, // 116 IIC_VEXTQ
  { 1, 123, 128, 1044, 1048 }, // 117 IIC_fpFMAC64
  { 1, 128, 133, 1048, 1052 }, // 118 IIC_fpFMAC32
  { 1, 98, 103, 1052, 1056 }, // 119 IIC_VFMACD
  { 1, 133, 138, 1056, 1060 }, // 120 IIC_VFMACQ
  { 1, 118, 123, 1060, 1062 }, // 121 IIC_VMOVSI
  { 1, 88, 93, 1062, 1065 }, // 122 IIC_VBINi4Q
  { 1, 138, 144, 1065, 1067 }, // 123 IIC_VLD1dup
  { 1, 138, 144, 1067, 1071 }, // 124 IIC_VLD1dupu
  { 1, 144, 150, 1071, 1075 }, // 125 IIC_VLD1ln
  { 1, 144, 150, 1075, 1081 }, // 126 IIC_VLD1lnu
  { 1, 138, 144, 1081, 1083 }, // 127 IIC_VLD1
  { 1, 144, 150, 1083, 1088 }, // 128 IIC_VLD1x4
  { 1, 138, 144, 1088, 1092 }, // 129 IIC_VLD1x2u
  { 1, 144, 150, 1092, 1096 }, // 130 IIC_VLD1x3
  { 1, 138, 144, 1096, 1099 }, // 131 IIC_VLD1u
  { 1, 138, 144, 1099, 1102 }, // 132 IIC_VLD1x2
  { 1, 138, 144, 1102, 1105 }, // 133 IIC_VLD2dup
  { 1, 138, 144, 1105, 1110 }, // 134 IIC_VLD2dupu
  { 1, 144, 150, 1110, 1116 }, // 135 IIC_VLD2ln
  { 1, 144, 150, 1116, 1124 }, // 136 IIC_VLD2lnu
  { 1, 138, 144, 1124, 1127 }, // 137 IIC_VLD2
  { 1, 138, 144, 1127, 1133 }, // 138 IIC_VLD2u
  { 1, 144, 150, 1133, 1138 }, // 139 IIC_VLD2x2
  { 1, 144, 150, 1138, 1144 }, // 140 IIC_VLD2x2u
  { 1, 150, 156, 1144, 1148 }, // 141 IIC_VLD3dup
  { 1, 150, 156, 1148, 1154 }, // 142 IIC_VLD3dupu
  { 1, 156, 162, 1154, 1162 }, // 143 IIC_VLD3ln
  { 1, 156, 162, 1162, 1172 }, // 144 IIC_VLD3lnu
  { 1, 150, 156, 1172, 1176 }, // 145 IIC_VLD3
  { 1, 150, 156, 1176, 1181 }, // 146 IIC_VLD3u
  { 1, 144, 150, 1181, 1186 }, // 147 IIC_VLD4dup
  { 1, 144, 150, 1186, 1193 }, // 148 IIC_VLD4dupu
  { 1, 162, 168, 1193, 1203 }, // 149 IIC_VLD4ln
  { 1, 162, 168, 1203, 1215 }, // 150 IIC_VLD4lnu
  { 1, 150, 156, 1215, 1220 }, // 151 IIC_VLD4
  { 1, 150, 156, 1220, 1226 }, // 152 IIC_VLD4u
  { -1, 168, 174, 1226, 1230 }, // 153 IIC_fpLoad_mu
  { -1, 168, 174, 1230, 1234 }, // 154 IIC_fpLoad_m
  { 1, 174, 180, 1234, 1236 }, // 155 IIC_fpLoad64
  { 1, 174, 180, 1236, 1238 }, // 156 IIC_fpLoad32
  { 1, 123, 128, 1238, 1242 }, // 157 IIC_fpMAC64
  { 1, 98, 103, 1242, 1246 }, // 158 IIC_VMACi32D
  { 1, 88, 93, 1246, 1250 }, // 159 IIC_VMACi16D
  { 1, 128, 133, 1250, 1254 }, // 160 IIC_fpMAC32
  { 1, 98, 103, 1254, 1258 }, // 161 IIC_VMACD
  { 1, 133, 138, 1258, 1262 }, // 162 IIC_VMACQ
  { 1, 133, 138, 1262, 1266 }, // 163 IIC_VMACi32Q
  { 1, 98, 103, 1266, 1270 }, // 164 IIC_VMACi16Q
  { 1, 22, 27, 1270, 1273 }, // 165 IIC_fpMOVID
  { 1, 88, 93, 1273, 1275 }, // 166 IIC_VQUNAiD
  { 1, 88, 93, 1275, 1277 }, // 167 IIC_VMOVN
  { 1, 180, 182, 1277, 1280 }, // 168 IIC_fpMOVDI
  { 1, 180, 182, 1280, 1282 }, // 169 IIC_fpMOVSI
  { 1, 22, 27, 1282, 1284 }, // 170 IIC_fpMOVIS
  { 1, 182, 187, 1284, 1287 }, // 171 IIC_fpMUL64
  { 1, 88, 93, 1287, 1290 }, // 172 IIC_VMULi16D
  { 1, 98, 103, 1290, 1293 }, // 173 IIC_VMULi32D
  { 1, 187, 192, 1293, 1296 }, // 174 IIC_fpMUL32
  { 1, 88, 93, 1296, 1299 }, // 175 IIC_VFMULD
  { 1, 192, 197, 1299, 1302 }, // 176 IIC_VFMULQ
  { 1, 98, 103, 1302, 1305 }, // 177 IIC_VMULi16Q
  { 1, 133, 138, 1305, 1308 }, // 178 IIC_VMULi32Q
  { 1, 88, 93, 1308, 1311 }, // 179 IIC_VSHLiQ
  { 1, 93, 98, 1311, 1314 }, // 180 IIC_VPALiQ
  { 1, 88, 93, 1314, 1317 }, // 181 IIC_VPALiD
  { 1, 88, 93, 1317, 1320 }, // 182 IIC_VPBIND
  { 1, 88, 93, 1320, 1322 }, // 183 IIC_VQUNAiQ
  { 1, 88, 93, 1322, 1325 }, // 184 IIC_VSHLi4Q
  { 1, 88, 93, 1325, 1328 }, // 185 IIC_VSHLi4D
  { 1, 197, 202, 1328, 1331 }, // 186 IIC_VRECSD
  { 1, 202, 207, 1331, 1334 }, // 187 IIC_VRECSQ
  { 1, 207, 212, 1334, 1337 }, // 188 IIC_VMOVISL
  { 1, 103, 108, 1337, 1339 }, // 189 IIC_fpCVTID_WriteCvtFP
  { 1, 103, 108, 1339, 1341 }, // 190 IIC_fpCVTIS_WriteCvtFP
  { 1, 103, 108, 1341, 1343 }, // 191 IIC_fpCVTID
  { 1, 103, 108, 1343, 1345 }, // 192 IIC_fpCVTIS
  { 1, 212, 217, 1345, 1347 }, // 193 IIC_fpSQRT64
  { 1, 217, 222, 1347, 1349 }, // 194 IIC_fpSQRT32
  { 1, 222, 228, 1349, 1352 }, // 195 IIC_VST1ln
  { 1, 222, 228, 1352, 1357 }, // 196 IIC_VST1lnu
  { 1, 222, 228, 1357, 1360 }, // 197 IIC_VST1
  { 1, 228, 234, 1360, 1366 }, // 198 IIC_VST1x4
  { 1, 144, 150, 1366, 1372 }, // 199 IIC_VLD1x4u
  { 1, 228, 234, 1372, 1377 }, // 200 IIC_VST1x3
  { 1, 144, 150, 1377, 1382 }, // 201 IIC_VLD1x3u
  { 1, 228, 234, 1382, 1390 }, // 202 IIC_VST1x4u
  { 1, 228, 234, 1390, 1397 }, // 203 IIC_VST1x3u
  { 1, 222, 228, 1397, 1401 }, // 204 IIC_VST1x2
  { 1, 222, 228, 1401, 1405 }, // 205 IIC_VST2ln
  { 1, 222, 228, 1405, 1411 }, // 206 IIC_VST2lnu
  { 1, 222, 228, 1411, 1415 }, // 207 IIC_VST2
  { 1, 234, 240, 1415, 1421 }, // 208 IIC_VST2x2
  { 1, 234, 240, 1421, 1429 }, // 209 IIC_VST2x2u
  { 1, 234, 240, 1429, 1434 }, // 210 IIC_VST3ln
  { 1, 234, 240, 1434, 1441 }, // 211 IIC_VST3lnu
  { 1, 228, 234, 1441, 1446 }, // 212 IIC_VST3
  { 1, 228, 234, 1446, 1453 }, // 213 IIC_VST3u
  { 1, 228, 234, 1453, 1459 }, // 214 IIC_VST4ln
  { 1, 228, 234, 1459, 1467 }, // 215 IIC_VST4lnu
  { 1, 228, 234, 1467, 1473 }, // 216 IIC_VST4
  { 1, 228, 234, 1473, 1481 }, // 217 IIC_VST4u
  { -1, 168, 174, 1481, 1485 }, // 218 IIC_fpStore_mu
  { -1, 168, 174, 1485, 1489 }, // 219 IIC_fpStore_m
  { 1, 174, 180, 1489, 1491 }, // 220 IIC_fpStore64
  { 1, 174, 180, 1491, 1493 }, // 221 IIC_fpStore32
  { 1, 88, 93, 1493, 1496 }, // 222 IIC_VSUBiQ
  { 1, 98, 103, 1496, 1499 }, // 223 IIC_VTB1
  { 1, 240, 245, 1499, 1503 }, // 224 IIC_VTB2
  { 1, 245, 250, 1503, 1508 }, // 225 IIC_VTB3
  { 1, 250, 255, 1508, 1514 }, // 226 IIC_VTB4
  { 1, 98, 103, 1514, 1518 }, // 227 IIC_VTBX1
  { 1, 98, 103, 1518, 1523 }, // 228 IIC_VTBX2
  { 1, 250, 255, 1523, 1529 }, // 229 IIC_VTBX3
  { 1, 255, 260, 1529, 1536 }, // 230 IIC_VTBX4
  { 1, 103, 108, 1536, 1538 }, // 231 IIC_fpCVTDI_WriteCvtFP
  { 1, 103, 108, 1538, 1540 }, // 232 IIC_fpCVTSI_WriteCvtFP
  { 1, 103, 108, 1540, 1542 }, // 233 IIC_fpCVTDI
  { 1, 103, 108, 1542, 1544 }, // 234 IIC_fpCVTSI
  { 1, 88, 93, 1544, 1548 }, // 235 IIC_VPERMD
  { 1, 98, 103, 1548, 1552 }, // 236 IIC_VPERMQ
  { 1, 250, 255, 1552, 1556 }, // 237 IIC_VPERMQ3
  { 1, 20, 22, 1556, 1559 }, // 238 IIC_iALUsi_WriteALUsi_ReadALUsr
  { 1, 13, 15, 1559, 1561 }, // 239 IIC_iBITi
  { 1, 20, 22, 1561, 1563 }, // 240 IIC_iCMPsi_WriteCMPsi_ReadALU_ReadALU
  { 1, 13, 15, 1563, 1564 }, // 241 IIC_iCMPi_WriteCMP
  { 1, 13, 15, 1564, 1566 }, // 242 IIC_iCMPr_WriteCMP
  { 1, 20, 22, 1566, 1568 }, // 243 IIC_iCMPsi_WriteCMPsi
  { 1, 13, 15, 0, 0 }, // 244 IIC_iALUx
  { 1, 41, 45, 1568, 1570 }, // 245 IIC_iLoad_bh_i
  { 1, 41, 45, 1570, 1573 }, // 246 IIC_iLoad_d_i
  { 1, 13, 15, 1573, 1575 }, // 247 IIC_iCMOVsi_WriteALU
  { 1, 13, 15, 1575, 1576 }, // 248 IIC_iMOVi
  { 1, 20, 22, 1576, 1578 }, // 249 IIC_iMVNsi_WriteALU
  { 1, 20, 22, 1578, 1581 }, // 250 IIC_iALUsir_WriteALUsi_ReadALU
  { 1, 77, 81, 1581, 1583 }, // 251 IIC_iStore_bh_i
  { 1, 45, 49, 1583, 1585 }, // 252 IIC_iStore_i
  { 1, 15, 17, 1585, 1589 }, // 253 IIC_iEXTAsr
  { 1, 13, 15, 1589, 1591 }, // 254 IIC_iEXTr
  { 1, 13, 15, 1591, 1592 }, // 255 IIC_iTSTi_WriteCMP
  { 1, 13, 15, 1592, 1594 }, // 256 IIC_iTSTr_WriteCMP
  { 1, 20, 22, 1594, 1596 }, // 257 IIC_iTSTsi_WriteCMPsi
  { 1, 13, 15, 1596, 1599 }, // 258 IIC_iALUr_WriteALU
  { 1, 13, 15, 1599, 1601 }, // 259 IIC_iALUi_WriteALU
  { 1, 13, 15, 1601, 1604 }, // 260 IIC_iBITr_WriteALU
  { -1, 32, 36, 1604, 1607 }, // 261 IIC_iPop
  { -1, 260, 265, 1607, 1610 }, // 262 IIC_iPop_Br_WriteBrL
  { 1, 13, 15, 1610, 1612 }, // 263 IIC_iTSTr_WriteALU
  { 1, 13, 15, 1612, 1614 }, // 264 ANDri_BICri_EORri_ORRri
  { 1, 13, 15, 1614, 1617 }, // 265 ANDrr_BICrr_EORrr_ORRrr
  { 1, 15, 17, 1617, 1621 }, // 266 ANDrsi_BICrsi_EORrsi_ORRrsi
  { 1, 15, 17, 1621, 1625 }, // 267 ANDrsr_BICrsr_EORrsr_ORRrsr
  { 1, 20, 22, 1625, 1628 }, // 268 MOVCCsi_MOVCCsr
  { 1, 20, 22, 1628, 1631 }, // 269 MOVsi_MOVsr
  { 1, 13, 15, 1631, 1633 }, // 270 MOVsra_flag_MOVsrl_flag
  { 1, 15, 17, 1633, 1636 }, // 271 MVNsr
  { 1, 13, 15, 1636, 1638 }, // 272 MVNr
  { 1, 60, 64, 1638, 1639 }, // 273 MOVCCi32imm
  { 1, 74, 77, 1639, 1640 }, // 274 MOVi32imm
  { 1, 64, 68, 1640, 1641 }, // 275 MOV_ga_pcrel
  { 1, 68, 74, 1641, 1642 }, // 276 MOV_ga_pcrel_ldr
  { 0, 0, 0, 0, 0 }, // 277 SEL
  { 1, 20, 22, 1642, 1644 }, // 278 BFC_BFI_SBFX_UBFX
  { 1, 58, 60, 1644, 1648 }, // 279 MLA_MLAv5_MLS_SMMLA_SMMLAR_SMMLS_SMMLSR
  { 1, 58, 60, 1648, 1651 }, // 280 MUL_MULv5_SMMUL_SMMULR
  { 1, 82, 84, 1651, 1655 }, // 281 SMLAL_SMLALBB_SMLALBT_SMLALTB_SMLALTT_SMLALv5_UMAAL_UMLAL_UMLALv5
  { 1, 82, 84, 1655, 1659 }, // 282 SMULL_SMULLv5_UMULL_UMULLv5
  { 0, 0, 0, 0, 0 }, // 283 SMLAD_SMLADX_SMLALD_SMLALDX_SMLSD_SMLSDX_SMLSLD_SMLSLDX_SMUAD_SMUADX_SMUSD_SMUSDX
  { 1, 58, 60, 1659, 1662 }, // 284 SMULBB_SMULBT_SMULTB_SMULTT_SMULWB_SMULWT
  { 1, 58, 60, 1662, 1666 }, // 285 SMLABB_SMLABT_SMLATB_SMLATT_SMLAWB_SMLAWT
  { 1, 45, 49, 1666, 1669 }, // 286 LDRi12_PICLDR
  { 1, 54, 58, 1669, 1672 }, // 287 LDRrs
  { 1, 41, 45, 1672, 1675 }, // 288 LDRBi12_LDRH_LDRSB_LDRSH_PICLDRB_PICLDRH_PICLDRSB_PICLDRSH
  { 1, 41, 45, 1675, 1679 }, // 289 LDRHTi_LDRHTr_LDRH_POST_LDRH_PRE_LDRSBTi_LDRSBTr_LDRSB_POST_LDRSB_PRE_LDRSHTi_LDRSHTr_LDRSH_POST_LDRSH_PRE
  { 1, 13, 15, 1679, 1681 }, // 290 SXTB_SXTB16_SXTH_UXTB_UXTB16_UXTH
  { 1, 13, 15, 1681, 1683 }, // 291 t2SXTB_t2SXTB16_t2SXTH_t2UXTB_t2UXTB16_t2UXTH
  { 1, 60, 64, 1683, 1684 }, // 292 t2MOVCCi32imm
  { 1, 74, 77, 1684, 1685 }, // 293 t2MOVi32imm
  { 1, 64, 68, 1685, 1686 }, // 294 t2MOV_ga_pcrel
  { 1, 13, 15, 1686, 1687 }, // 295 t2MOVi16_ga_pcrel
  { 0, 0, 0, 0, 0 }, // 296 t2SEL
  { 1, 20, 22, 1687, 1689 }, // 297 t2BFC_t2SBFX_t2UBFX
  { 1, 13, 15, 1689, 1691 }, // 298 t2BFI
  { 1, 13, 15, 1691, 1694 }, // 299 QADD_QADD16_QADD8_QASX_QDADD_QDSUB_QSAX_QSUB_QSUB16_QSUB8_UQADD16_UQADD8_UQASX_UQSAX_UQSUB16_UQSUB8
  { 0, 0, 0, 0, 0 }, // 300 SSAT_SSAT16_USAT_USAT16_t2QADD_t2QADD16_t2QADD8_t2QASX_t2QDADD_t2QDSUB_t2QSAX_t2QSUB_t2QSUB16_t2QSUB8_t2SSAT_t2SSAT16_t2UQADD16_t2UQADD8_t2UQASX_t2UQSAX_t2UQSUB16_t2UQSUB8_t2USAT_t2USAT16
  { 1, 13, 15, 1694, 1697 }, // 301 SADD16_SADD8_SASX_SSAX_SSUB16_SSUB8_UADD16_UADD8_UASX_USAX_USUB16_USUB8
  { 0, 0, 0, 0, 0 }, // 302 t2SADD16_t2SADD8_t2SASX_t2SSAX_t2SSUB16_t2SSUB8_t2UADD16_t2UADD8_t2UASX_t2USAX_t2USUB16_t2USUB8
  { 1, 13, 15, 1697, 1700 }, // 303 SHADD16_SHADD8_SHASX_SHSAX_SHSUB16_SHSUB8_UHADD16_UHADD8_UHASX_UHSAX_UHSUB16_UHSUB8
  { 1, 20, 22, 1700, 1703 }, // 304 SXTAB_SXTAB16_SXTAH_UXTAB_UXTAB16_UXTAH
  { 0, 0, 0, 0, 0 }, // 305 t2SHADD16_t2SHADD8_t2SHASX_t2SHSAX_t2SHSUB16_t2SHSUB8_t2UHADD16_t2UHADD8_t2UHASX_t2UHSAX_t2UHSUB16_t2UHSUB8
  { 1, 15, 17, 1703, 1707 }, // 306 t2SXTAB_t2SXTAB16_t2SXTAH_t2UXTAB_t2UXTAB16_t2UXTAH
  { 0, 0, 0, 0, 0 }, // 307 USAD8
  { 0, 0, 0, 0, 0 }, // 308 USADA8
  { 0, 0, 0, 0, 0 }, // 309 SMUSD_SMUSDX
  { 1, 58, 60, 1707, 1710 }, // 310 t2MUL_t2SMMUL_t2SMMULR
  { 1, 58, 60, 1710, 1713 }, // 311 t2SMULBB_t2SMULBT_t2SMULTB_t2SMULTT_t2SMULWB_t2SMULWT
  { 1, 58, 60, 1713, 1717 }, // 312 t2SMUSD_t2SMUSDX
  { 1, 58, 60, 1717, 1721 }, // 313 t2MLA_t2MLS_t2SMMLA_t2SMMLAR_t2SMMLS_t2SMMLSR
  { 0, 0, 0, 0, 0 }, // 314 SMUAD_SMUADX
  { 1, 58, 60, 1721, 1725 }, // 315 t2SMUAD_t2SMUADX
  { 0, 0, 0, 0, 0 }, // 316 SMLSD_SMLSDX
  { 1, 58, 60, 1725, 1729 }, // 317 t2SMLABB_t2SMLABT_t2SMLATB_t2SMLATT_t2SMLAWB_t2SMLAWT
  { 1, 58, 60, 1729, 1733 }, // 318 t2SMLSD_t2SMLSDX
  { 0, 0, 0, 0, 0 }, // 319 SMLAD_SMLADX
  { 1, 58, 60, 1733, 1737 }, // 320 t2SMLAD_t2SMLADX
  { 1, 82, 84, 1737, 1741 }, // 321 SMULL_UMULL
  { 1, 82, 84, 1741, 1745 }, // 322 t2SMULL_t2UMULL
  { 1, 82, 84, 1745, 1749 }, // 323 t2SMLAL_t2SMLALBB_t2SMLALBT_t2SMLALD_t2SMLALDX_t2SMLALTB_t2SMLALTT_t2SMLSLD_t2SMLSLDX_t2UMAAL_t2UMLAL
  { 0, 0, 0, 0, 0 }, // 324 SDIV_UDIV_t2SDIV_t2UDIV
  { 1, 41, 45, 1749, 1752 }, // 325 LDRBi12
  { 1, 41, 45, 1752, 1755 }, // 326 LDRBrs_t2LDRBs_t2LDRHs
  { 0, 0, 0, 0, 0 }, // 327 LDREX_LDREXB_LDREXD_LDREXH_tLDRpci_pic
  { 1, 45, 49, 1755, 1758 }, // 328 LDRi12
  { 1, 41, 45, 1758, 1760 }, // 329 t2LDRBi12_t2LDRBi8_t2LDRBpci_t2LDRHi12_t2LDRHi8_t2LDRHpci_tLDRBi_tLDRHi
  { 1, 45, 49, 1760, 1762 }, // 330 t2LDRi12_t2LDRi8_t2LDRpci_tLDRi_tLDRpci_tLDRspi
  { 1, 49, 54, 1762, 1764 }, // 331 t2LDRpci_pic
  { 1, 54, 58, 1764, 1767 }, // 332 t2LDRs
  { 1, 41, 45, 1767, 1770 }, // 333 tLDRBr_tLDRHr
  { 1, 45, 49, 1770, 1773 }, // 334 tLDRr
  { 1, 41, 45, 1773, 1776 }, // 335 LDRH_PICLDRB_PICLDRH
  { 1, 45, 49, 1776, 1779 }, // 336 LDRcp
  { 1, 41, 45, 1779, 1781 }, // 337 t2LDRSBi12_t2LDRSBi8_t2LDRSBpci_t2LDRSHi12_t2LDRSHi8_t2LDRSHpci
  { 0, 0, 0, 0, 0 }, // 338 t2LDRSBpcrel_t2LDRSHpcrel
  { 1, 41, 45, 1781, 1784 }, // 339 t2LDRSBs_t2LDRSHs
  { 1, 41, 45, 1784, 1787 }, // 340 tLDRSB_tLDRSH
  { 1, 41, 45, 1787, 1791 }, // 341 LDRBT_POST_IMM_LDRBT_POST_REG_LDRB_POST_REG_LDRB_PRE_REG
  { 1, 41, 45, 1791, 1794 }, // 342 LDRB_POST_IMM_LDRB_PRE_IMM_t2LDRB_POST_t2LDRB_PRE_t2LDRH_POST_t2LDRH_PRE
  { 1, 41, 45, 1794, 1798 }, // 343 LDRHTi_LDRHTr_LDRH_POST_LDRH_PRE
  { 1, 45, 49, 1798, 1802 }, // 344 LDRT_POST_IMM_LDRT_POST_REG_LDR_POST_REG_LDR_PRE_REG
  { 1, 45, 49, 1802, 1805 }, // 345 LDR_POST_IMM_LDR_PRE_IMM_t2LDR_POST_t2LDR_PRE
  { 1, 41, 45, 1805, 1807 }, // 346 t2LDRBT_t2LDRHT
  { 1, 45, 49, 1807, 1809 }, // 347 t2LDRT
  { 1, 41, 45, 1809, 1811 }, // 348 t2LDRSBT_t2LDRSHT
  { 1, 41, 45, 1811, 1814 }, // 349 t2LDRSB_POST_t2LDRSB_PRE_t2LDRSH_POST_t2LDRSH_PRE
  { 1, 41, 45, 1814, 1818 }, // 350 LDRD
  { 1, 41, 45, 1818, 1821 }, // 351 t2LDRDi8
  { 1, 41, 45, 1821, 1825 }, // 352 LDRD_POST_LDRD_PRE_t2LDRD_POST_t2LDRD_PRE
  { -1, 32, 36, 1825, 1830 }, // 353 LDMDA_LDMDB_LDMIA_LDMIB_sysLDMDA_sysLDMDB_sysLDMIA_sysLDMIB_t2LDMDB_t2LDMIA_tLDMIA
  { -1, 32, 36, 1830, 1835 }, // 354 LDMDA_UPD_LDMDB_UPD_LDMIA_UPD_LDMIB_UPD_sysLDMDA_UPD_sysLDMDB_UPD_sysLDMIA_UPD_sysLDMIB_UPD_t2LDMDB_UPD_t2LDMIA_UPD_tLDMIA_UPD
  { -1, 36, 41, 1835, 1840 }, // 355 LDMIA_RET_t2LDMIA_RET
  { -1, 32, 36, 1840, 1843 }, // 356 tPOP
  { -1, 260, 265, 1843, 1846 }, // 357 tPOP_RET
  { 1, 45, 49, 1846, 1849 }, // 358 PICSTR_STRi12_tSTRr
  { 1, 77, 81, 1849, 1852 }, // 359 PICSTRB_PICSTRH_STRBi12_STRH_tSTRBr_tSTRHr
  { 1, 77, 81, 1852, 1855 }, // 360 STRBrs_t2STRBs_t2STRHs
  { 0, 0, 0, 0, 0 }, // 361 STREX_STREXB_STREXD_STREXH
  { 1, 45, 49, 1855, 1858 }, // 362 STRrs_t2STRs
  { 1, 77, 81, 1858, 1860 }, // 363 t2STRBi12_t2STRBi8_t2STRHi12_t2STRHi8_tSTRBi_tSTRHi
  { 1, 45, 49, 1860, 1862 }, // 364 t2STRi12_t2STRi8_tSTRi_tSTRspi
  { 0, 0, 0, 0, 0 }, // 365 STRBT_POST_STRT_POST
  { 1, 77, 81, 1862, 1866 }, // 366 STRBT_POST_IMM_STRBT_POST_REG_STRB_POST_REG_STRB_PRE_REG_STRHTi_STRHTr_STRH_POST_STRH_PRE
  { 1, 77, 81, 1866, 1869 }, // 367 STRB_POST_IMM_STRB_PRE_IMM_t2STRB_POST_t2STRB_PRE_t2STRH_POST
  { 1, 45, 49, 1869, 1873 }, // 368 STRBi_preidx_STRBr_preidx_STRH_preidx_STRT_POST_IMM_STRT_POST_REG_STR_POST_REG_STR_PRE_REG_STRi_preidx_STRr_preidx_t2STRB_preidx_t2STRH_preidx_t2STR_preidx
  { 1, 45, 49, 1873, 1876 }, // 369 STR_POST_IMM_STR_PRE_IMM_t2STRH_PRE_t2STR_POST_t2STR_PRE
  { 1, 77, 81, 1876, 1878 }, // 370 t2STRBT_t2STRHT
  { 1, 45, 49, 1878, 1880 }, // 371 t2STRT
  { 1, 77, 81, 1880, 1883 }, // 372 STRD_t2STRDi8
  { 1, 77, 81, 1883, 1887 }, // 373 STRD_POST_STRD_PRE_t2STRD_POST_t2STRD_PRE
  { -1, 84, 88, 0, 0 }, // 374 STMDA_STMDB_STMIA_STMIB_sysSTMDA_sysSTMDB_sysSTMIA_sysSTMIB_t2STMDB_t2STMIA
  { -1, 84, 88, 1887, 1888 }, // 375 STMDA_UPD_STMDB_UPD_STMIA_UPD_STMIB_UPD_sysSTMDA_UPD_sysSTMDB_UPD_sysSTMIA_UPD_sysSTMIB_UPD_t2STMDB_UPD_t2STMIA_UPD_tSTMIA_UPD
  { -1, 84, 88, 0, 0 }, // 376 tPUSH
  { 0, 0, 0, 0, 0 }, // 377 ITasm
  { 1, 13, 15, 0, 0 }, // 378 t2IT
  { 1, 88, 93, 1888, 1891 }, // 379 VADDLsv2i64_VADDLsv4i32_VADDLsv8i16_VADDLuv2i64_VADDLuv4i32_VADDLuv8i16_VNEGs16d_VNEGs32d_VNEGs8d_VPADDLsv16i8_VPADDLsv2i32_VPADDLsv4i16_VPADDLsv4i32_VPADDLsv8i16_VPADDLsv8i8_VPADDLuv16i8_VPADDLuv2i32_VPADDLuv4i16_VPADDLuv4i32_VPADDLuv8i16_VPADDLuv8i8_VPADDi16_VPADDi32_VPADDi8_VSHLLi16_VSHLLi32_VSHLLi8_VSHLLsv2i64_VSHLLsv4i32_VSHLLsv8i16_VSHLLuv2i64_VSHLLuv4i32_VSHLLuv8i16_VSHLiv16i8_VSHLiv1i64_VSHLiv2i32_VSHLiv2i64_VSHLiv4i16_VSHLiv4i32_VSHLiv8i16_VSHLiv8i8_VSHLsv1i64_VSHLsv2i32_VSHLsv4i16_VSHLsv8i8_VSHLuv1i64_VSHLuv2i32_VSHLuv4i16_VSHLuv8i8_VSHRsv16i8_VSHRsv1i64_VSHRsv2i32_VSHRsv2i64_VSHRsv4i16_VSHRsv4i32_VSHRsv8i16_VSHRsv8i8_VSHRuv16i8_VSHRuv1i64_VSHRuv2i32_VSHRuv2i64_VSHRuv4i16_VSHRuv4i32_VSHRuv8i16_VSHRuv8i8_VSLIv1i64_VSLIv2i32_VSLIv4i16_VSLIv8i8_VSRIv1i64_VSRIv2i32_VSRIv4i16_VSRIv8i8_VSUBLsv2i64_VSUBLsv4i32_VSUBLsv8i16_VSUBLuv2i64_VSUBLuv4i32_VSUBLuv8i16
  { 1, 88, 93, 1891, 1894 }, // 380 VADDWsv2i64_VADDWsv4i32_VADDWsv8i16_VADDWuv2i64_VADDWuv4i32_VADDWuv8i16_VSUBWsv2i64_VSUBWsv4i32_VSUBWsv8i16_VSUBWuv2i64_VSUBWuv4i32_VSUBWuv8i16_VSUBv1i64_VSUBv2i32_VSUBv4i16_VSUBv8i8
  { 1, 88, 93, 1894, 1897 }, // 381 VADDv16i8_VADDv2i64_VADDv4i32_VADDv8i16_VANDq_VBICq_VBIFq_VBITq_VEORq_VORNq_VORRq
  { 1, 88, 93, 1897, 1900 }, // 382 VADDv1i64_VADDv2i32_VADDv4i16_VADDv8i8_VANDd_VBICd_VBIFd_VBITd_VEORd_VORNd_VORRd
  { 1, 88, 93, 1900, 1901 }, // 383 VBICiv2i32_VBICiv4i16_VBICiv4i32_VBICiv8i16_VORRiv2i32_VORRiv4i16_VORRiv4i32_VORRiv8i16
  { 1, 88, 93, 1901, 1904 }, // 384 VBSLd_VCLSv2i32_VCLSv4i16_VCLSv8i8_VCLZv2i32_VCLZv4i16_VCLZv8i8_VCNTd
  { 1, 98, 103, 1904, 1907 }, // 385 VBSLq_VCLSv16i8_VCLSv4i32_VCLSv8i16_VCLZv16i8_VCLZv4i32_VCLZv8i16_VCNTq
  { 1, 88, 93, 1907, 1910 }, // 386 VHADDsv16i8_VHADDsv4i32_VHADDsv8i16_VHADDuv16i8_VHADDuv4i32_VHADDuv8i16_VRHADDsv16i8_VRHADDsv4i32_VRHADDsv8i16_VRHADDuv16i8_VRHADDuv4i32_VRHADDuv8i16_VTSTv16i8_VTSTv4i32_VTSTv8i16
  { 1, 88, 93, 1910, 1913 }, // 387 VHADDsv2i32_VHADDsv4i16_VHADDsv8i8_VHADDuv2i32_VHADDuv4i16_VHADDuv8i8_VRHADDsv2i32_VRHADDsv4i16_VRHADDsv8i8_VRHADDuv2i32_VRHADDuv4i16_VRHADDuv8i8_VTSTv2i32_VTSTv4i16_VTSTv8i8
  { 1, 88, 93, 1913, 1916 }, // 388 VHSUBsv16i8_VHSUBsv4i32_VHSUBsv8i16_VHSUBuv16i8_VHSUBuv4i32_VHSUBuv8i16
  { 1, 88, 93, 1916, 1919 }, // 389 VHSUBsv2i32_VHSUBsv4i16_VHSUBsv8i8_VHSUBuv2i32_VHSUBuv4i16_VHSUBuv8i8
  { 1, 98, 103, 1919, 1921 }, // 390 VNEGf32q
  { 1, 88, 93, 1921, 1923 }, // 391 VNEGfd
  { 1, 88, 93, 1923, 1926 }, // 392 VNEGs16q_VNEGs32q_VNEGs8q_VSHLsv16i8_VSHLsv2i64_VSHLsv4i32_VSHLsv8i16_VSHLuv16i8_VSHLuv2i64_VSHLuv4i32_VSHLuv8i16_VSLIv16i8_VSLIv2i64_VSLIv4i32_VSLIv8i16_VSRIv16i8_VSRIv2i64_VSRIv4i32_VSRIv8i16
  { 1, 88, 93, 1926, 1929 }, // 393 VQSHLsiv16i8_VQSHLsiv1i64_VQSHLsiv2i32_VQSHLsiv2i64_VQSHLsiv4i16_VQSHLsiv4i32_VQSHLsiv8i16_VQSHLsiv8i8_VQSHLsuv16i8_VQSHLsuv1i64_VQSHLsuv2i32_VQSHLsuv2i64_VQSHLsuv4i16_VQSHLsuv4i32_VQSHLsuv8i16_VQSHLsuv8i8_VQSHLsv1i64_VQSHLsv2i32_VQSHLsv4i16_VQSHLsv8i8_VQSHLuiv16i8_VQSHLuiv1i64_VQSHLuiv2i32_VQSHLuiv2i64_VQSHLuiv4i16_VQSHLuiv4i32_VQSHLuiv8i16_VQSHLuiv8i8_VQSHLuv1i64_VQSHLuv2i32_VQSHLuv4i16_VQSHLuv8i8
  { 1, 88, 93, 1929, 1932 }, // 394 VQSHLsv16i8_VQSHLsv2i64_VQSHLsv4i32_VQSHLsv8i16_VQSHLuv16i8_VQSHLuv2i64_VQSHLuv4i32_VQSHLuv8i16
  { 1, 88, 93, 1932, 1935 }, // 395 VSUBv16i8_VSUBv2i64_VSUBv4i32_VSUBv8i16
  { 1, 88, 93, 1935, 1938 }, // 396 VEXTd16_VEXTd32_VEXTd8
  { 1, 98, 103, 1938, 1941 }, // 397 VEXTq16_VEXTq32_VEXTq64_VEXTq8
  { 1, 88, 93, 1941, 1943 }, // 398 VREV16d8_VREV32d16_VREV32d8_VREV64d16_VREV64d32_VREV64d8
  { 1, 88, 93, 1943, 1945 }, // 399 VREV16q8_VREV32q16_VREV32q8_VREV64q16_VREV64q32_VREV64q8
  { 1, 88, 93, 1945, 1949 }, // 400 VABALsv2i64_VABALsv4i32_VABALsv8i16_VABALuv2i64_VABALuv4i32_VABALuv8i16_VABAsv2i32_VABAsv4i16_VABAsv8i8_VABAuv2i32_VABAuv4i16_VABAuv8i8
  { 1, 93, 98, 1949, 1953 }, // 401 VABAsv16i8_VABAsv4i32_VABAsv8i16_VABAuv16i8_VABAuv4i32_VABAuv8i16
  { 1, 88, 93, 1953, 1955 }, // 402 VABSfd
  { 1, 98, 103, 1955, 1957 }, // 403 VABSfq
  { 1, 88, 93, 1957, 1959 }, // 404 VABSv16i8_VABSv4i32_VABSv8i16
  { 1, 88, 93, 1959, 1961 }, // 405 VABSv2i32_VABSv4i16_VABSv8i8
  { 1, 88, 93, 1961, 1964 }, // 406 VACGEd_VACGTd_VCEQfd_VCGEfd_VCGTfd
  { 1, 98, 103, 1964, 1967 }, // 407 VACGEq_VACGTq_VCEQfq_VCGEfq_VCGTfq
  { 1, 88, 93, 1967, 1970 }, // 408 VCEQv16i8_VCEQv4i32_VCEQv8i16_VCGEsv16i8_VCGEsv4i32_VCGEsv8i16_VCGEuv16i8_VCGEuv4i32_VCGEuv8i16_VCGTsv16i8_VCGTsv4i32_VCGTsv8i16_VCGTuv16i8_VCGTuv4i32_VCGTuv8i16_VQSUBsv16i8_VQSUBsv2i64_VQSUBsv4i32_VQSUBsv8i16_VQSUBuv16i8_VQSUBuv2i64_VQSUBuv4i32_VQSUBuv8i16
  { 1, 88, 93, 1970, 1973 }, // 409 VCEQv2i32_VCEQv4i16_VCEQv8i8_VCGEsv2i32_VCGEsv4i16_VCGEsv8i8_VCGEuv2i32_VCGEuv4i16_VCGEuv8i8_VCGTsv2i32_VCGTsv4i16_VCGTsv8i8_VCGTuv2i32_VCGTuv4i16_VCGTuv8i8_VQSUBsv1i64_VQSUBsv2i32_VQSUBsv4i16_VQSUBsv8i8_VQSUBuv1i64_VQSUBuv2i32_VQSUBuv4i16_VQSUBuv8i8
  { 0, 0, 0, 0, 0 }, // 410 VCEQzv16i8_VCEQzv2f32_VCEQzv2i32_VCEQzv4f32_VCEQzv4i16_VCEQzv4i32_VCEQzv8i16_VCEQzv8i8_VCGEzv16i8_VCGEzv2f32_VCGEzv2i32_VCGEzv4f32_VCGEzv4i16_VCGEzv4i32_VCGEzv8i16_VCGEzv8i8_VCGTzv16i8_VCGTzv2f32_VCGTzv2i32_VCGTzv4f32_VCGTzv4i16_VCGTzv4i32_VCGTzv8i16_VCGTzv8i8_VCLEzv16i8_VCLEzv2f32_VCLEzv2i32_VCLEzv4f32_VCLEzv4i16_VCLEzv4i32_VCLEzv8i16_VCLEzv8i8_VCLTzv16i8_VCLTzv2f32_VCLTzv2i32_VCLTzv4f32_VCLTzv4i16_VCLTzv4i32_VCLTzv8i16_VCLTzv8i8
  { 1, 93, 98, 1973, 1976 }, // 411 VPADALsv16i8_VPADALsv4i32_VPADALsv8i16_VPADALuv16i8_VPADALuv4i32_VPADALuv8i16
  { 1, 88, 93, 1976, 1979 }, // 412 VPADALsv2i32_VPADALsv4i16_VPADALsv8i8_VPADALuv2i32_VPADALuv4i16_VPADALuv8i8_VRSRAsv16i8_VRSRAsv1i64_VRSRAsv2i32_VRSRAsv2i64_VRSRAsv4i16_VRSRAsv4i32_VRSRAsv8i16_VRSRAsv8i8_VRSRAuv16i8_VRSRAuv1i64_VRSRAuv2i32_VRSRAuv2i64_VRSRAuv4i16_VRSRAuv4i32_VRSRAuv8i16_VRSRAuv8i8_VSRAsv16i8_VSRAsv1i64_VSRAsv2i32_VSRAsv2i64_VSRAsv4i16_VSRAsv4i32_VSRAsv8i16_VSRAsv8i8_VSRAuv16i8_VSRAuv1i64_VSRAuv2i32_VSRAuv2i64_VSRAuv4i16_VSRAuv4i32_VSRAuv8i16_VSRAuv8i8
  { 1, 88, 93, 1979, 1981 }, // 413 VQABSv16i8_VQABSv4i32_VQABSv8i16_VQNEGv16i8_VQNEGv4i32_VQNEGv8i16
  { 1, 88, 93, 1981, 1983 }, // 414 VQABSv2i32_VQABSv4i16_VQABSv8i8_VQNEGv2i32_VQNEGv4i16_VQNEGv8i8
  { 1, 88, 93, 1983, 1986 }, // 415 VQADDsv16i8_VQADDsv2i64_VQADDsv4i32_VQADDsv8i16_VQADDuv16i8_VQADDuv2i64_VQADDuv4i32_VQADDuv8i16
  { 1, 88, 93, 1986, 1989 }, // 416 VQADDsv1i64_VQADDsv2i32_VQADDsv4i16_VQADDsv8i8_VQADDuv1i64_VQADDuv2i32_VQADDuv4i16_VQADDuv8i8
  { 1, 88, 93, 1989, 1992 }, // 417 VQRSHLsv16i8_VQRSHLsv2i64_VQRSHLsv4i32_VQRSHLsv8i16_VQRSHLuv16i8_VQRSHLuv2i64_VQRSHLuv4i32_VQRSHLuv8i16_VRSHLsv16i8_VRSHLsv2i64_VRSHLsv4i32_VRSHLsv8i16_VRSHLuv16i8_VRSHLuv2i64_VRSHLuv4i32_VRSHLuv8i16
  { 1, 88, 93, 1992, 1995 }, // 418 VQRSHLsv1i64_VQRSHLsv2i32_VQRSHLsv4i16_VQRSHLsv8i8_VQRSHLuv1i64_VQRSHLuv2i32_VQRSHLuv4i16_VQRSHLuv8i8_VRSHLsv1i64_VRSHLsv2i32_VRSHLsv4i16_VRSHLsv8i8_VRSHLuv1i64_VRSHLuv2i32_VRSHLuv4i16_VRSHLuv8i8_VRSHRsv16i8_VRSHRsv1i64_VRSHRsv2i32_VRSHRsv2i64_VRSHRsv4i16_VRSHRsv4i32_VRSHRsv8i16_VRSHRsv8i8_VRSHRuv16i8_VRSHRuv1i64_VRSHRuv2i32_VRSHRuv2i64_VRSHRuv4i16_VRSHRuv4i32_VRSHRuv8i16_VRSHRuv8i8
  { 1, 88, 93, 1995, 1997 }, // 419 VRECPEd_VRECPEfd_VRSQRTEd_VRSQRTEfd
  { 1, 98, 103, 1997, 1999 }, // 420 VRECPEfq_VRECPEq_VRSQRTEfq_VRSQRTEq
  { 1, 88, 93, 1999, 2002 }, // 421 VADDHNv2i32_VADDHNv4i16_VADDHNv8i8_VSUBHNv2i32_VSUBHNv4i16_VSUBHNv8i8
  { 1, 88, 93, 2002, 2005 }, // 422 VSHRNv2i32_VSHRNv4i16_VSHRNv8i8
  { 1, 88, 93, 2005, 2008 }, // 423 VQRSHRNsv2i32_VQRSHRNsv4i16_VQRSHRNsv8i8_VQRSHRNuv2i32_VQRSHRNuv4i16_VQRSHRNuv8i8_VQRSHRUNv2i32_VQRSHRUNv4i16_VQRSHRUNv8i8_VQSHRNsv2i32_VQSHRNsv4i16_VQSHRNsv8i8_VQSHRNuv2i32_VQSHRNuv4i16_VQSHRNuv8i8_VQSHRUNv2i32_VQSHRUNv4i16_VQSHRUNv8i8_VRSHRNv2i32_VRSHRNv4i16_VRSHRNv8i8
  { 1, 88, 93, 2008, 2011 }, // 424 VRADDHNv2i32_VRADDHNv4i16_VRADDHNv8i8_VRSUBHNv2i32_VRSUBHNv4i16_VRSUBHNv8i8
  { 1, 98, 103, 2011, 2014 }, // 425 VTBL1
  { 1, 98, 103, 2014, 2018 }, // 426 VTBX1
  { 1, 240, 245, 2018, 2022 }, // 427 VTBL2
  { 1, 98, 103, 2022, 2027 }, // 428 VTBX2
  { 1, 245, 250, 2027, 2032 }, // 429 VTBL3_VTBL3Pseudo
  { 1, 250, 255, 2032, 2038 }, // 430 VTBX3_VTBX3Pseudo
  { 1, 250, 255, 2038, 2044 }, // 431 VTBL4_VTBL4Pseudo
  { 1, 255, 260, 2044, 2051 }, // 432 VTBX4_VTBX4Pseudo
  { 0, 0, 0, 0, 0 }, // 433 VSWPd_VSWPq
  { 1, 88, 93, 2051, 2055 }, // 434 VTRNd16_VTRNd32_VTRNd8_VUZPd16_VUZPd8_VZIPd16_VZIPd8
  { 1, 98, 103, 2055, 2059 }, // 435 VTRNq16_VTRNq32_VTRNq8
  { 1, 250, 255, 2059, 2063 }, // 436 VUZPq16_VUZPq32_VUZPq8_VZIPq16_VZIPq32_VZIPq8
  { 1, 22, 27, 2063, 2065 }, // 437 VABSD_VNEGD
  { 1, 22, 27, 2065, 2067 }, // 438 VABSS_VNEGS
  { 1, 103, 108, 2067, 2069 }, // 439 VCMPD_VCMPED_VCMPEZD_VCMPZD
  { 1, 103, 108, 2069, 2071 }, // 440 VCMPES_VCMPEZS_VCMPS_VCMPZS
  { 1, 88, 93, 2071, 2074 }, // 441 VABDLsv2i64_VABDLsv4i32_VABDLsv8i16_VABDLuv2i64_VABDLuv4i32_VABDLuv8i16_VABDsv16i8_VABDsv4i32_VABDsv8i16_VABDuv16i8_VABDuv4i32_VABDuv8i16_VMAXsv16i8_VMAXsv4i32_VMAXsv8i16_VMAXuv16i8_VMAXuv4i32_VMAXuv8i16_VMINsv16i8_VMINsv4i32_VMINsv8i16_VMINuv16i8_VMINuv4i32_VMINuv8i16
  { 1, 88, 93, 2074, 2077 }, // 442 VABDfd_VADDfd_VMAXfd_VMINfd_VSUBfd
  { 1, 98, 103, 2077, 2080 }, // 443 VABDfq_VADDfq_VMAXfq_VMINfq_VSUBfq
  { 1, 88, 93, 2080, 2083 }, // 444 VABDsv2i32_VABDsv4i16_VABDsv8i8_VABDuv2i32_VABDuv4i16_VABDuv8i8_VMAXsv2i32_VMAXsv4i16_VMAXsv8i8_VMAXuv2i32_VMAXuv4i16_VMAXuv8i8_VMINsv2i32_VMINsv4i16_VMINsv8i8_VMINuv2i32_VMINuv4i16_VMINuv8i8_VPMAXs16_VPMAXs32_VPMAXs8_VPMAXu16_VPMAXu32_VPMAXu8_VPMINs16_VPMINs32_VPMINs8_VPMINu16_VPMINu32_VPMINu8
  { 1, 103, 108, 2083, 2086 }, // 445 VADDS_VSUBS
  { 0, 0, 0, 0, 0 }, // 446 VMAXNMD_VMAXNMND_VMAXNMNQ_VMAXNMS_VMINNMD_VMINNMND_VMINNMNQ_VMINNMS
  { 1, 88, 93, 2086, 2089 }, // 447 VPADDf_VPMAXf_VPMINf
  { 1, 103, 108, 2089, 2092 }, // 448 VADDD_VSUBD
  { 1, 197, 202, 2092, 2095 }, // 449 VRECPSfd_VRSQRTSfd
  { 1, 202, 207, 2095, 2098 }, // 450 VRECPSfq_VRSQRTSfq
  { 0, 0, 0, 0, 0 }, // 451 VMULLp64
  { 1, 88, 93, 2098, 2101 }, // 452 VMULLp8_VMULLslsv2i32_VMULLslsv4i16_VMULLsluv2i32_VMULLsluv4i16_VMULLsv4i32_VMULLsv8i16_VMULLuv4i32_VMULLuv8i16_VMULpd_VMULslv4i16_VMULv4i16_VMULv8i8_VQDMULHslv4i16_VQDMULHv4i16_VQDMULLslv2i32_VQDMULLslv4i16_VQDMULLv4i32_VQRDMULHslv4i16_VQRDMULHv4i16
  { 1, 98, 103, 2101, 2104 }, // 453 VMULLsv2i64_VMULLuv2i64_VMULslv2i32_VMULv2i32_VQDMULHslv2i32_VQDMULHv2i32_VQDMULLv2i64_VQRDMULHslv2i32_VQRDMULHv2i32
  { 1, 187, 192, 2104, 2107 }, // 454 VMULS_VNMULS
  { 1, 88, 93, 2107, 2110 }, // 455 VMULfd
  { 1, 192, 197, 2110, 2113 }, // 456 VMULfq
  { 1, 98, 103, 2113, 2116 }, // 457 VMULpq_VMULslv8i16_VMULv16i8_VMULv8i16_VQDMULHslv8i16_VQDMULHv8i16_VQRDMULHslv8i16_VQRDMULHv8i16
  { 1, 88, 93, 2116, 2119 }, // 458 VMULslfd
  { 1, 98, 103, 2119, 2122 }, // 459 VMULslfq
  { 1, 133, 138, 2122, 2125 }, // 460 VMULslv4i32_VMULv4i32_VQDMULHslv4i32_VQDMULHv4i32_VQRDMULHslv4i32_VQRDMULHv4i32
  { 1, 182, 187, 2125, 2128 }, // 461 VMULD_VNMULD
  { 1, 123, 128, 2128, 2132 }, // 462 VFMAD_VFMSD_VFNMAD_VFNMSD
  { 1, 128, 133, 2132, 2136 }, // 463 VFMAS_VFMSS_VFNMAS_VFNMSS
  { 1, 123, 128, 2136, 2140 }, // 464 VMLAD_VMLSD_VNMLAD_VNMLSD
  { 1, 98, 103, 2140, 2144 }, // 465 VMLALslsv2i32_VMLALsluv2i32_VMLALsv2i64_VMLALuv2i64_VMLAslv2i32_VMLAv2i32_VMLSLslsv2i32_VMLSLsluv2i32_VMLSLsv2i64_VMLSLuv2i64_VMLSslv2i32_VMLSv2i32_VQDMLALslv2i32_VQDMLALv2i64_VQDMLSLslv2i32_VQDMLSLv2i64
  { 1, 88, 93, 2144, 2148 }, // 466 VMLALslsv4i16_VMLALsluv4i16_VMLALsv4i32_VMLALsv8i16_VMLALuv4i32_VMLALuv8i16_VMLAslv4i16_VMLAv4i16_VMLAv8i8_VMLSLslsv4i16_VMLSLsluv4i16_VMLSLsv4i32_VMLSLsv8i16_VMLSLuv4i32_VMLSLuv8i16_VMLSslv4i16_VMLSv4i16_VMLSv8i8_VQDMLALslv4i16_VQDMLALv4i32_VQDMLSLslv4i16_VQDMLSLv4i32
  { 1, 128, 133, 2148, 2152 }, // 467 VMLAS_VMLSS_VNMLAS_VNMLSS
  { 1, 98, 103, 2152, 2156 }, // 468 VMLAfd_VMLAslfd_VMLSfd_VMLSslfd
  { 1, 133, 138, 2156, 2160 }, // 469 VMLAfq_VMLAslfq_VMLSfq_VMLSslfq
  { 1, 133, 138, 2160, 2164 }, // 470 VMLAslv4i32_VMLAv4i32_VMLSslv4i32_VMLSv4i32
  { 1, 98, 103, 2164, 2168 }, // 471 VMLAslv8i16_VMLAv16i8_VMLAv8i16_VMLSslv8i16_VMLSv16i8_VMLSv8i16
  { 1, 98, 103, 2168, 2172 }, // 472 VFMAfd_VFMSfd
  { 1, 133, 138, 2172, 2176 }, // 473 VFMAfq_VFMSfq
  { 0, 0, 0, 0, 0 }, // 474 VCVTANSD_VCVTANSQ_VCVTANUD_VCVTANUQ_VCVTASD_VCVTASS_VCVTAUD_VCVTAUS_VCVTBDH_VCVTBHD_VCVTMNSD_VCVTMNSQ_VCVTMNUD_VCVTMNUQ_VCVTMSD_VCVTMSS_VCVTMUD_VCVTMUS_VCVTNNSD_VCVTNNSQ_VCVTNNUD_VCVTNNUQ_VCVTNSD_VCVTNSS_VCVTNUD_VCVTNUS_VCVTPNSD_VCVTPNSQ_VCVTPNUD_VCVTPNUQ_VCVTPSD_VCVTPSS_VCVTPUD_VCVTPUS_VCVTTDH_VCVTTHD
  { 1, 103, 108, 2176, 2178 }, // 475 VCVTBHS_VCVTTHS
  { 1, 22, 27, 2178, 2180 }, // 476 VCVTBSH_VCVTTSH
  { 1, 103, 108, 2180, 2182 }, // 477 VCVTDS
  { 1, 103, 108, 2182, 2184 }, // 478 VCVTSD
  { 1, 98, 103, 2184, 2186 }, // 479 VCVTf2h_VCVTf2sq_VCVTf2uq_VCVTf2xsq_VCVTf2xuq_VCVTh2f_VCVTs2fq_VCVTu2fq_VCVTxs2fq_VCVTxu2fq
  { 1, 88, 93, 2186, 2188 }, // 480 VCVTf2sd_VCVTf2ud_VCVTf2xsd_VCVTf2xud_VCVTs2fd_VCVTu2fd_VCVTxs2fd_VCVTxu2fd
  { 1, 103, 108, 2188, 2190 }, // 481 VSITOD_VUITOD
  { 1, 103, 108, 2190, 2192 }, // 482 VSITOS_VUITOS
  { 1, 103, 108, 2192, 2194 }, // 483 VTOSHD_VTOSLD_VTOUHD_VTOULD
  { 1, 103, 108, 2194, 2196 }, // 484 VTOSHS_VTOSLS_VTOUHS_VTOULS
  { 1, 103, 108, 2196, 2198 }, // 485 VTOSIRD_VTOSIZD_VTOUIRD_VTOUIZD
  { 1, 103, 108, 2198, 2200 }, // 486 VTOSIRS_VTOSIZS_VTOUIRS_VTOUIZS
  { 1, 22, 27, 2200, 2202 }, // 487 FCONSTD_VMOVD_VMOVDcc
  { 1, 22, 27, 2202, 2204 }, // 488 FCONSTS_VMOVS_VMOVScc
  { 1, 88, 93, 2204, 2205 }, // 489 VMOVv16i8_VMOVv1i64_VMOVv2f32_VMOVv2i32_VMOVv2i64_VMOVv4f32_VMOVv4i16_VMOVv4i32_VMOVv8i16_VMOVv8i8_VMVNv2i32_VMVNv4i16_VMVNv4i32_VMVNv8i16
  { 1, 88, 93, 2205, 2208 }, // 490 VMVNd_VMVNq
  { 1, 88, 93, 2208, 2210 }, // 491 VMOVLsv2i64_VMOVLsv4i32_VMOVLsv8i16_VMOVLuv2i64_VMOVLuv4i32_VMOVLuv8i16
  { 1, 88, 93, 2210, 2212 }, // 492 VMOVNv2i32_VMOVNv4i16_VMOVNv8i8
  { 1, 88, 93, 2212, 2214 }, // 493 VQMOVNsuv2i32_VQMOVNsuv4i16_VQMOVNsuv8i8_VQMOVNsv2i32_VQMOVNsv4i16_VQMOVNsv8i8_VQMOVNuv2i32_VQMOVNuv4i16_VQMOVNuv8i8
  { 1, 88, 93, 2214, 2216 }, // 494 VDUPLN16d_VDUPLN32d_VDUPLN8d
  { 1, 88, 93, 2216, 2218 }, // 495 VDUPLN16q_VDUPLN32q_VDUPLN8q
  { 1, 118, 123, 2218, 2220 }, // 496 VDUP16d_VDUP16q_VDUP32d_VDUP32q_VDUP8d_VDUP8q
  { 1, 180, 182, 2220, 2222 }, // 497 VMOVRS
  { 1, 22, 27, 2222, 2224 }, // 498 VMOVSR
  { 1, 207, 212, 2224, 2227 }, // 499 VSETLNi16_VSETLNi32_VSETLNi8
  { 1, 180, 182, 2227, 2230 }, // 500 VMOVRRD_VMOVRRS
  { 1, 22, 27, 2230, 2233 }, // 501 VMOVDRR
  { 1, 22, 27, 2233, 2236 }, // 502 VMOVSRR
  { 1, 118, 123, 2236, 2238 }, // 503 VGETLNi32_VGETLNu16_VGETLNu8
  { 1, 118, 123, 2238, 2240 }, // 504 VGETLNs16_VGETLNs8
  { 1, 27, 32, 2240, 2241 }, // 505 VMRS_VMRS_FPEXC_VMRS_FPINST_VMRS_FPINST2_VMRS_FPSID_VMRS_MVFR0_VMRS_MVFR1_VMRS_MVFR2
  { 1, 27, 32, 2241, 2242 }, // 506 VMSR_VMSR_FPEXC_VMSR_FPINST_VMSR_FPINST2_VMSR_FPSID
  { 1, 27, 32, 2242, 2243 }, // 507 FMSTAT
  { 1, 174, 180, 2243, 2245 }, // 508 VLDRD
  { 1, 174, 180, 2245, 2247 }, // 509 VLDRS
  { 1, 174, 180, 2247, 2249 }, // 510 VSTRD
  { 1, 174, 180, 2249, 2251 }, // 511 VSTRS
  { -1, 168, 174, 2251, 2255 }, // 512 VLDMQIA
  { -1, 168, 174, 2255, 2259 }, // 513 VSTMQIA
  { -1, 168, 174, 2259, 2263 }, // 514 VLDMDIA_VLDMSIA
  { -1, 168, 174, 2263, 2267 }, // 515 VLDMDDB_UPD_VLDMDIA_UPD_VLDMSDB_UPD_VLDMSIA_UPD
  { -1, 168, 174, 2267, 2271 }, // 516 VSTMDIA_VSTMSIA
  { -1, 168, 174, 2271, 2275 }, // 517 VSTMDDB_UPD_VSTMDIA_UPD_VSTMSDB_UPD_VSTMSIA_UPD
  { 1, 138, 144, 2275, 2277 }, // 518 VLD1d16_VLD1d32_VLD1d64_VLD1d8
  { 1, 138, 144, 2277, 2280 }, // 519 VLD1q16_VLD1q32_VLD1q64_VLD1q8
  { 1, 138, 144, 2280, 2283 }, // 520 VLD1d16wb_fixed_VLD1d16wb_register_VLD1d32wb_fixed_VLD1d32wb_register_VLD1d64wb_fixed_VLD1d64wb_register_VLD1d8wb_fixed_VLD1d8wb_register
  { 1, 138, 144, 2283, 2287 }, // 521 VLD1q16wb_fixed_VLD1q16wb_register_VLD1q32wb_fixed_VLD1q32wb_register_VLD1q64wb_fixed_VLD1q64wb_register_VLD1q8wb_fixed_VLD1q8wb_register
  { 1, 144, 150, 2287, 2291 }, // 522 VLD1d16T_VLD1d32T_VLD1d64T_VLD1d64TPseudo_VLD1d64TPseudoWB_fixed_VLD1d64TPseudoWB_register_VLD1d8T
  { 1, 138, 144, 2291, 2295 }, // 523 VLD1d16Twb_fixed_VLD1d16Twb_register_VLD1d32Twb_fixed_VLD1d32Twb_register_VLD1d64Twb_fixed_VLD1d64Twb_register_VLD1d8Twb_fixed_VLD1d8Twb_register
  { 1, 144, 150, 2295, 2300 }, // 524 VLD1d16Q_VLD1d32Q_VLD1d64Q_VLD1d64QPseudo_VLD1d64QPseudoWB_fixed_VLD1d64QPseudoWB_register_VLD1d8Q
  { 1, 138, 144, 2300, 2304 }, // 525 VLD1d16Qwb_fixed_VLD1d16Qwb_register_VLD1d32Qwb_fixed_VLD1d32Qwb_register_VLD1d64Qwb_fixed_VLD1d64Qwb_register_VLD1d8Qwb_fixed_VLD1d8Qwb_register
  { 1, 138, 144, 2304, 2307 }, // 526 VLD2b16_VLD2b32_VLD2b8_VLD2d16_VLD2d32_VLD2d8
  { 1, 144, 150, 2307, 2312 }, // 527 VLD2q16_VLD2q16Pseudo_VLD2q32_VLD2q32Pseudo_VLD2q8_VLD2q8Pseudo
  { 1, 138, 144, 2312, 2318 }, // 528 VLD2b16wb_fixed_VLD2b16wb_register_VLD2b32wb_fixed_VLD2b32wb_register_VLD2b8wb_fixed_VLD2b8wb_register_VLD2d16wb_fixed_VLD2d16wb_register_VLD2d32wb_fixed_VLD2d32wb_register_VLD2d8wb_fixed_VLD2d8wb_register
  { 1, 144, 150, 2318, 2324 }, // 529 VLD2q16PseudoWB_fixed_VLD2q16PseudoWB_register_VLD2q16wb_fixed_VLD2q16wb_register_VLD2q32PseudoWB_fixed_VLD2q32PseudoWB_register_VLD2q32wb_fixed_VLD2q32wb_register_VLD2q8PseudoWB_fixed_VLD2q8PseudoWB_register_VLD2q8wb_fixed_VLD2q8wb_register
  { 1, 150, 156, 2324, 2328 }, // 530 VLD3d16_VLD3d32_VLD3d8_VLD3q16_VLD3q32_VLD3q8
  { 1, 150, 156, 2328, 2332 }, // 531 VLD3d16Pseudo_VLD3d32Pseudo_VLD3d8Pseudo_VLD3q16oddPseudo_VLD3q32oddPseudo_VLD3q8oddPseudo
  { 1, 150, 156, 2332, 2337 }, // 532 VLD3d16_UPD_VLD3d32_UPD_VLD3d8_UPD_VLD3q16_UPD_VLD3q32_UPD_VLD3q8_UPD
  { 1, 150, 156, 2337, 2342 }, // 533 VLD3d16Pseudo_UPD_VLD3d32Pseudo_UPD_VLD3d8Pseudo_UPD_VLD3q16Pseudo_UPD_VLD3q16oddPseudo_UPD_VLD3q32Pseudo_UPD_VLD3q32oddPseudo_UPD_VLD3q8Pseudo_UPD_VLD3q8oddPseudo_UPD
  { 1, 150, 156, 2342, 2347 }, // 534 VLD4d16_VLD4d32_VLD4d8_VLD4q16_VLD4q32_VLD4q8
  { 1, 150, 156, 2347, 2352 }, // 535 VLD4d16Pseudo_VLD4d32Pseudo_VLD4d8Pseudo_VLD4q16oddPseudo_VLD4q32oddPseudo_VLD4q8oddPseudo
  { 1, 150, 156, 2352, 2358 }, // 536 VLD4d16_UPD_VLD4d32_UPD_VLD4d8_UPD_VLD4q16_UPD_VLD4q32_UPD_VLD4q8_UPD
  { 1, 150, 156, 2358, 2364 }, // 537 VLD4d16Pseudo_UPD_VLD4d32Pseudo_UPD_VLD4d8Pseudo_UPD_VLD4q16Pseudo_UPD_VLD4q16oddPseudo_UPD_VLD4q32Pseudo_UPD_VLD4q32oddPseudo_UPD_VLD4q8Pseudo_UPD_VLD4q8oddPseudo_UPD
  { 1, 138, 144, 2364, 2366 }, // 538 VLD1DUPd16_VLD1DUPd32_VLD1DUPd8_VLD1DUPq16_VLD1DUPq32_VLD1DUPq8
  { 1, 144, 150, 2366, 2370 }, // 539 VLD1LNd16_VLD1LNd32_VLD1LNd8_VLD1LNq16Pseudo_VLD1LNq32Pseudo_VLD1LNq8Pseudo
  { 1, 138, 144, 2370, 2374 }, // 540 VLD1DUPd16wb_fixed_VLD1DUPd16wb_register_VLD1DUPd32wb_fixed_VLD1DUPd32wb_register_VLD1DUPd8wb_fixed_VLD1DUPd8wb_register_VLD1DUPq16wb_fixed_VLD1DUPq16wb_register_VLD1DUPq32wb_fixed_VLD1DUPq32wb_register_VLD1DUPq8wb_fixed_VLD1DUPq8wb_register
  { 1, 144, 150, 2374, 2380 }, // 541 VLD1LNd16_UPD_VLD1LNd32_UPD_VLD1LNd8_UPD_VLD1LNq16Pseudo_UPD_VLD1LNq32Pseudo_UPD_VLD1LNq8Pseudo_UPD
  { 1, 138, 144, 2380, 2383 }, // 542 VLD2DUPd16_VLD2DUPd16x2_VLD2DUPd32_VLD2DUPd32x2_VLD2DUPd8_VLD2DUPd8x2
  { 1, 144, 150, 2383, 2389 }, // 543 VLD2LNd16_VLD2LNd16Pseudo_VLD2LNd32_VLD2LNd32Pseudo_VLD2LNd8_VLD2LNd8Pseudo_VLD2LNq16_VLD2LNq16Pseudo_VLD2LNq32_VLD2LNq32Pseudo
  { 1, 144, 150, 2389, 2397 }, // 544 VLD2LNd16_UPD_VLD2LNd32_UPD_VLD2LNd8_UPD_VLD2LNq16_UPD_VLD2LNq32_UPD
  { 1, 138, 144, 2397, 2402 }, // 545 VLD2DUPd16wb_fixed_VLD2DUPd16wb_register_VLD2DUPd16x2wb_fixed_VLD2DUPd16x2wb_register_VLD2DUPd32wb_fixed_VLD2DUPd32wb_register_VLD2DUPd32x2wb_fixed_VLD2DUPd32x2wb_register_VLD2DUPd8wb_fixed_VLD2DUPd8wb_register_VLD2DUPd8x2wb_fixed_VLD2DUPd8x2wb_register
  { 1, 144, 150, 2402, 2410 }, // 546 VLD2LNd16Pseudo_UPD_VLD2LNd32Pseudo_UPD_VLD2LNd8Pseudo_UPD_VLD2LNq16Pseudo_UPD_VLD2LNq32Pseudo_UPD
  { 1, 150, 156, 2410, 2414 }, // 547 VLD3DUPd16_VLD3DUPd16Pseudo_VLD3DUPd32_VLD3DUPd32Pseudo_VLD3DUPd8_VLD3DUPd8Pseudo_VLD3DUPq16_VLD3DUPq32_VLD3DUPq8
  { 1, 156, 162, 2414, 2422 }, // 548 VLD3LNd16_VLD3LNd16Pseudo_VLD3LNd32_VLD3LNd32Pseudo_VLD3LNd8_VLD3LNd8Pseudo_VLD3LNq16_VLD3LNq16Pseudo_VLD3LNq32_VLD3LNq32Pseudo
  { 1, 150, 156, 2422, 2428 }, // 549 VLD3DUPd16_UPD_VLD3DUPd32_UPD_VLD3DUPd8_UPD_VLD3DUPq16_UPD_VLD3DUPq32_UPD_VLD3DUPq8_UPD
  { 1, 156, 162, 2428, 2438 }, // 550 VLD3LNd16_UPD_VLD3LNd32_UPD_VLD3LNd8_UPD_VLD3LNq16_UPD_VLD3LNq32_UPD
  { 1, 150, 156, 2438, 2444 }, // 551 VLD3DUPd16Pseudo_UPD_VLD3DUPd32Pseudo_UPD_VLD3DUPd8Pseudo_UPD
  { 1, 156, 162, 2444, 2454 }, // 552 VLD3LNd16Pseudo_UPD_VLD3LNd32Pseudo_UPD_VLD3LNd8Pseudo_UPD_VLD3LNq16Pseudo_UPD_VLD3LNq32Pseudo_UPD
  { 1, 144, 150, 2454, 2459 }, // 553 VLD4DUPd16_VLD4DUPd16Pseudo_VLD4DUPd32_VLD4DUPd32Pseudo_VLD4DUPd8_VLD4DUPd8Pseudo_VLD4DUPq16_VLD4DUPq32_VLD4DUPq8
  { 1, 162, 168, 2459, 2469 }, // 554 VLD4LNd16_VLD4LNd16Pseudo_VLD4LNd32_VLD4LNd32Pseudo_VLD4LNd8_VLD4LNd8Pseudo_VLD4LNq16_VLD4LNq16Pseudo_VLD4LNq32_VLD4LNq32Pseudo
  { 1, 144, 150, 2469, 2476 }, // 555 VLD4DUPd16_UPD_VLD4DUPd32_UPD_VLD4DUPd8_UPD_VLD4DUPq16_UPD_VLD4DUPq32_UPD_VLD4DUPq8_UPD
  { 1, 162, 168, 2476, 2488 }, // 556 VLD4LNd16_UPD_VLD4LNd32_UPD_VLD4LNd8_UPD_VLD4LNq16_UPD_VLD4LNq32_UPD
  { 1, 144, 150, 2488, 2495 }, // 557 VLD4DUPd16Pseudo_UPD_VLD4DUPd32Pseudo_UPD_VLD4DUPd8Pseudo_UPD
  { 1, 162, 168, 2495, 2507 }, // 558 VLD4LNd16Pseudo_UPD_VLD4LNd32Pseudo_UPD_VLD4LNd8Pseudo_UPD_VLD4LNq16Pseudo_UPD_VLD4LNq32Pseudo_UPD
  { 1, 222, 228, 2507, 2510 }, // 559 VST1d16_VST1d32_VST1d64_VST1d8
  { 1, 222, 228, 2510, 2514 }, // 560 VST1q16_VST1q32_VST1q64_VST1q8
  { 1, 138, 144, 2514, 2517 }, // 561 VST1d16wb_fixed_VST1d16wb_register_VST1d32wb_fixed_VST1d32wb_register_VST1d64wb_fixed_VST1d64wb_register_VST1d8wb_fixed_VST1d8wb_register
  { 1, 138, 144, 2517, 2521 }, // 562 VST1q16wb_fixed_VST1q16wb_register_VST1q32wb_fixed_VST1q32wb_register_VST1q64wb_fixed_VST1q64wb_register_VST1q8wb_fixed_VST1q8wb_register
  { 1, 228, 234, 2521, 2526 }, // 563 VST1d16T_VST1d32T_VST1d64T_VST1d64TPseudo_VST1d8T
  { 1, 144, 150, 2526, 2531 }, // 564 VST1d16Twb_fixed_VST1d16Twb_register_VST1d32Twb_fixed_VST1d32Twb_register_VST1d64Twb_fixed_VST1d64Twb_register_VST1d8Twb_fixed_VST1d8Twb_register
  { 1, 228, 234, 2531, 2538 }, // 565 VST1d64TPseudoWB_fixed_VST1d64TPseudoWB_register
  { 1, 228, 234, 2538, 2544 }, // 566 VST1d16Q_VST1d32Q_VST1d64Q_VST1d64QPseudo_VST1d8Q
  { 1, 144, 150, 2544, 2550 }, // 567 VST1d16Qwb_fixed_VST1d16Qwb_register_VST1d32Qwb_fixed_VST1d32Qwb_register_VST1d64Qwb_fixed_VST1d64Qwb_register_VST1d8Qwb_fixed_VST1d8Qwb_register
  { 1, 228, 234, 2550, 2558 }, // 568 VST1d64QPseudoWB_fixed_VST1d64QPseudoWB_register
  { 1, 222, 228, 2558, 2562 }, // 569 VST2b16_VST2b32_VST2b8_VST2d16_VST2d32_VST2d8
  { 1, 138, 144, 2562, 2565 }, // 570 VST2b16wb_fixed_VST2b16wb_register_VST2b32wb_fixed_VST2b32wb_register_VST2b8wb_fixed_VST2b8wb_register_VST2d16wb_fixed_VST2d16wb_register_VST2d32wb_fixed_VST2d32wb_register_VST2d8wb_fixed_VST2d8wb_register
  { 1, 234, 240, 2565, 2571 }, // 571 VST2q16_VST2q16Pseudo_VST2q32_VST2q32Pseudo_VST2q8_VST2q8Pseudo
  { 1, 234, 240, 2571, 2579 }, // 572 VST2q16PseudoWB_fixed_VST2q16PseudoWB_register_VST2q32PseudoWB_fixed_VST2q32PseudoWB_register_VST2q8PseudoWB_fixed_VST2q8PseudoWB_register
  { 1, 138, 144, 2579, 2582 }, // 573 VST2q16wb_fixed_VST2q16wb_register_VST2q32wb_fixed_VST2q32wb_register_VST2q8wb_fixed_VST2q8wb_register
  { 1, 228, 234, 2582, 2587 }, // 574 VST3d16_VST3d16Pseudo_VST3d32_VST3d32Pseudo_VST3d8_VST3d8Pseudo_VST3q16_VST3q16oddPseudo_VST3q32_VST3q32oddPseudo_VST3q8_VST3q8oddPseudo
  { 1, 228, 234, 2587, 2594 }, // 575 VST3d16Pseudo_UPD_VST3d16_UPD_VST3d32Pseudo_UPD_VST3d32_UPD_VST3d8Pseudo_UPD_VST3d8_UPD_VST3q16Pseudo_UPD_VST3q16_UPD_VST3q16oddPseudo_UPD_VST3q32Pseudo_UPD_VST3q32_UPD_VST3q32oddPseudo_UPD_VST3q8Pseudo_UPD_VST3q8_UPD_VST3q8oddPseudo_UPD
  { 1, 228, 234, 2594, 2600 }, // 576 VST4d16_VST4d16Pseudo_VST4d32_VST4d32Pseudo_VST4d8_VST4d8Pseudo_VST4q16_VST4q16oddPseudo_VST4q32_VST4q32oddPseudo_VST4q8_VST4q8oddPseudo
  { 1, 228, 234, 2600, 2608 }, // 577 VST4d16Pseudo_UPD_VST4d16_UPD_VST4d32Pseudo_UPD_VST4d32_UPD_VST4d8Pseudo_UPD_VST4d8_UPD_VST4q16Pseudo_UPD_VST4q16_UPD_VST4q16oddPseudo_UPD_VST4q32Pseudo_UPD_VST4q32_UPD_VST4q32oddPseudo_UPD_VST4q8Pseudo_UPD_VST4q8_UPD_VST4q8oddPseudo_UPD
  { 1, 222, 228, 2608, 2611 }, // 578 VST1LNd16_VST1LNd32_VST1LNd8_VST1LNq16Pseudo_VST1LNq32Pseudo_VST1LNq8Pseudo
  { 1, 222, 228, 2611, 2616 }, // 579 VST1LNd16_UPD_VST1LNd32_UPD_VST1LNd8_UPD_VST1LNq16Pseudo_UPD_VST1LNq32Pseudo_UPD_VST1LNq8Pseudo_UPD
  { 1, 222, 228, 2616, 2620 }, // 580 VST2LNd16_VST2LNd16Pseudo_VST2LNd32_VST2LNd32Pseudo_VST2LNd8_VST2LNd8Pseudo_VST2LNq16_VST2LNq16Pseudo_VST2LNq32_VST2LNq32Pseudo
  { 1, 222, 228, 2620, 2626 }, // 581 VST2LNd16Pseudo_UPD_VST2LNd16_UPD_VST2LNd32Pseudo_UPD_VST2LNd32_UPD_VST2LNd8Pseudo_UPD_VST2LNd8_UPD_VST2LNq16Pseudo_UPD_VST2LNq16_UPD_VST2LNq32Pseudo_UPD_VST2LNq32_UPD
  { 1, 234, 240, 2626, 2631 }, // 582 VST3LNd16_VST3LNd16Pseudo_VST3LNd32_VST3LNd32Pseudo_VST3LNd8_VST3LNd8Pseudo_VST3LNq16_VST3LNq16Pseudo_VST3LNq32_VST3LNq32Pseudo
  { 1, 234, 240, 2631, 2638 }, // 583 VST3LNd16Pseudo_UPD_VST3LNd16_UPD_VST3LNd32Pseudo_UPD_VST3LNd32_UPD_VST3LNd8Pseudo_UPD_VST3LNd8_UPD_VST3LNq16Pseudo_UPD_VST3LNq16_UPD_VST3LNq32Pseudo_UPD_VST3LNq32_UPD
  { 1, 228, 234, 2638, 2644 }, // 584 VST4LNd16_VST4LNd16Pseudo_VST4LNd32_VST4LNd32Pseudo_VST4LNd8_VST4LNd8Pseudo_VST4LNq16_VST4LNq16Pseudo_VST4LNq32_VST4LNq32Pseudo
  { 1, 228, 234, 2644, 2652 }, // 585 VST4LNd16Pseudo_UPD_VST4LNd16_UPD_VST4LNd32Pseudo_UPD_VST4LNd32_UPD_VST4LNd8Pseudo_UPD_VST4LNd8_UPD_VST4LNq16Pseudo_UPD_VST4LNq16_UPD_VST4LNq32Pseudo_UPD_VST4LNq32_UPD
  { 1, 113, 118, 2652, 2655 }, // 586 VDIVS
  { 1, 217, 222, 2655, 2657 }, // 587 VSQRTS
  { 1, 108, 113, 2657, 2660 }, // 588 VDIVD
  { 1, 212, 217, 2660, 2662 }, // 589 VSQRTD
  { 0, 0, 0, 0, 0 }, // 590 ABS
  { 0, ~0U, ~0U, ~0U, ~0U } // end marker
};

static const llvm::InstrItinerary CortexA8Itineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 1, 265, 266, 2662, 2664 }, // 1 IIC_iALUi_WriteALU_ReadALU
  { 1, 265, 266, 2664, 2667 }, // 2 IIC_iALUr_WriteALU_ReadALU_ReadALU
  { 1, 265, 266, 2667, 2671 }, // 3 IIC_iALUsr_WriteALUsi_ReadALU
  { 1, 265, 266, 2671, 2675 }, // 4 IIC_iALUsr_WriteALUsr_ReadALUsr
  { 1, 265, 266, 2675, 2679 }, // 5 IIC_iALUsr_WriteALUSsr_ReadALUsr
  { 1, 265, 266, 2679, 2681 }, // 6 IIC_iBITi_WriteALU_ReadALU
  { 1, 265, 266, 2681, 2684 }, // 7 IIC_iBITr_WriteALU_ReadALU_ReadALU
  { 1, 265, 266, 2684, 2688 }, // 8 IIC_iBITsr_WriteALUsi_ReadALU
  { 1, 265, 266, 2688, 2692 }, // 9 IIC_iBITsr_WriteALUsr_ReadALUsr
  { 1, 265, 266, 0, 0 }, // 10 IIC_Br_WriteBr
  { 1, 265, 266, 2692, 2694 }, // 11 IIC_iUNAsi
  { 1, 265, 266, 0, 0 }, // 12 IIC_Br_WriteBrL
  { 0, 0, 0, 0, 0 }, // 13 WriteBrL
  { 1, 265, 266, 0, 0 }, // 14 IIC_Br_WriteBrTbl
  { 0, 0, 0, 0, 0 }, // 15 WriteBr
  { 1, 265, 266, 2694, 2696 }, // 16 IIC_iUNAr_WriteALU
  { 1, 265, 266, 2696, 2697 }, // 17 IIC_iCMPi_WriteCMP_ReadALU
  { 1, 265, 266, 2697, 2699 }, // 18 IIC_iCMPr_WriteCMP_ReadALU_ReadALU
  { 1, 265, 266, 2699, 2702 }, // 19 IIC_iCMPsr_WriteCMPsi_ReadALU
  { 1, 265, 266, 2702, 2705 }, // 20 IIC_iCMPsr_WriteCMPsr_ReadALU
  { 1, 266, 269, 2705, 2707 }, // 21 IIC_fpUNA64
  { 1, 269, 271, 2707, 2709 }, // 22 IIC_fpUNA32
  { 1, 271, 273, 2709, 2710 }, // 23 IIC_fpSTAT
  { -1, 273, 275, 2710, 2715 }, // 24 IIC_iLoad_m
  { -1, 275, 277, 2715, 2720 }, // 25 IIC_iLoad_mu
  { -1, 277, 280, 2720, 2725 }, // 26 IIC_iLoad_mBr
  { 1, 280, 282, 2725, 2729 }, // 27 IIC_iLoad_bh_ru
  { 1, 280, 282, 2729, 2732 }, // 28 IIC_iLoad_bh_iu
  { 1, 280, 282, 2732, 2735 }, // 29 IIC_iLoad_bh_r
  { 1, 282, 284, 2735, 2738 }, // 30 IIC_iLoad_bh_si
  { 1, 280, 282, 2738, 2741 }, // 31 IIC_iLoad_d_r
  { 1, 280, 282, 2741, 2745 }, // 32 IIC_iLoad_d_ru
  { 1, 280, 282, 2745, 2747 }, // 33 IIC_iLoad_i
  { 1, 284, 287, 2747, 2749 }, // 34 IIC_iLoadiALU
  { 1, 280, 282, 2749, 2753 }, // 35 IIC_iLoad_ru
  { 1, 280, 282, 2753, 2756 }, // 36 IIC_iLoad_iu
  { 1, 280, 282, 2756, 2759 }, // 37 IIC_iLoad_r
  { 1, 282, 284, 2759, 2762 }, // 38 IIC_iLoad_si
  { 1, 287, 288, 2762, 2766 }, // 39 IIC_iMAC32
  { 1, 265, 266, 2766, 2767 }, // 40 IIC_iCMOVi_WriteALU
  { 1, 265, 266, 2767, 2768 }, // 41 IIC_iMOVi_WriteALU
  { 1, 288, 290, 2768, 2770 }, // 42 IIC_iCMOVix2
  { 1, 265, 266, 2770, 2772 }, // 43 IIC_iCMOVr_WriteALU
  { 1, 265, 266, 2772, 2775 }, // 44 IIC_iCMOVsr_WriteALU
  { 1, 290, 293, 2775, 2776 }, // 45 IIC_iMOVix2addpc
  { 1, 293, 296, 2776, 2777 }, // 46 IIC_iMOVix2ld
  { 1, 288, 290, 2777, 2778 }, // 47 IIC_iMOVix2
  { 1, 265, 266, 2778, 2780 }, // 48 IIC_iMOVr_WriteALU
  { 1, 265, 266, 2780, 2783 }, // 49 IIC_iMOVsr_WriteALU
  { 1, 265, 266, 2783, 2785 }, // 50 IIC_iMOVsi_WriteALU
  { 1, 287, 288, 2785, 2788 }, // 51 IIC_iMUL32
  { 1, 265, 266, 2788, 2789 }, // 52 IIC_iMVNi_WriteALU
  { 1, 265, 266, 2789, 2791 }, // 53 IIC_iMVNr_WriteALU
  { 1, 265, 266, 2791, 2794 }, // 54 IIC_iMVNsr_WriteALU
  { 1, 265, 266, 2794, 2797 }, // 55 IIC_iALUr_WriteALU_ReadALU
  { 1, 280, 282, 2797, 2800 }, // 56 IIC_iStore_r
  { 1, 280, 282, 2800, 2803 }, // 57 IIC_iStore_bh_r
  { 1, 265, 266, 2803, 2806 }, // 58 IIC_iALUsi_WriteALUsi_ReadALU
  { 1, 265, 266, 2806, 2809 }, // 59 IIC_iBITsi_WriteALUsi_ReadALU
  { 1, 265, 266, 2809, 2811 }, // 60 IIC_Preload_WritePreLd
  { 0, 0, 0, 0, 0 }, // 61 IIC_iDIV
  { 1, 287, 288, 2811, 2815 }, // 62 IIC_iMAC16
  { 1, 296, 297, 2815, 2819 }, // 63 IIC_iMAC64
  { 1, 297, 298, 2819, 2822 }, // 64 IIC_iMUL16
  { 1, 296, 297, 2822, 2826 }, // 65 IIC_iMUL64
  { -1, 273, 275, 0, 0 }, // 66 IIC_iStore_m
  { -1, 273, 275, 2826, 2827 }, // 67 IIC_iStore_mu
  { 1, 280, 282, 2827, 2831 }, // 68 IIC_iStore_bh_ru
  { 1, 280, 282, 2831, 2834 }, // 69 IIC_iStore_bh_iu
  { 1, 280, 282, 2834, 2838 }, // 70 IIC_iStore_ru
  { 1, 298, 300, 2838, 2841 }, // 71 IIC_iStore_bh_si
  { 1, 280, 282, 2841, 2844 }, // 72 IIC_iStore_d_r
  { 1, 280, 282, 2844, 2848 }, // 73 IIC_iStore_d_ru
  { 1, 280, 282, 2848, 2851 }, // 74 IIC_iStore_iu
  { 1, 298, 300, 2851, 2854 }, // 75 IIC_iStore_si
  { 1, 265, 266, 0, 0 }, // 76 IIC_Br
  { 1, 265, 266, 2854, 2857 }, // 77 IIC_iEXTAr_WriteALUsr
  { 1, 265, 266, 2857, 2859 }, // 78 IIC_iEXTr_WriteALUsi
  { 1, 265, 266, 2859, 2860 }, // 79 IIC_iTSTi_WriteCMP_ReadALU
  { 1, 265, 266, 2860, 2862 }, // 80 IIC_iTSTr_WriteCMP_ReadALU_ReadALU
  { 1, 265, 266, 2862, 2865 }, // 81 IIC_iTSTsr_WriteCMPsi_ReadALU
  { 1, 265, 266, 2865, 2868 }, // 82 IIC_iTSTsr_WriteCMPsr_ReadALU
  { 0, 0, 0, 0, 0 }, // 83 WriteALU_ReadALU_ReadALU
  { 1, 269, 271, 2868, 2872 }, // 84 IIC_VABAD
  { 1, 300, 302, 2872, 2876 }, // 85 IIC_VABAQ
  { 1, 269, 271, 2876, 2879 }, // 86 IIC_VSUBi4Q
  { 1, 269, 271, 2879, 2882 }, // 87 IIC_VBIND
  { 1, 300, 302, 2882, 2885 }, // 88 IIC_VBINQ
  { 1, 269, 271, 2885, 2888 }, // 89 IIC_VSUBi4D
  { 1, 269, 271, 2888, 2890 }, // 90 IIC_VUNAD
  { 1, 300, 302, 2890, 2892 }, // 91 IIC_VUNAQ
  { 1, 269, 271, 2892, 2894 }, // 92 IIC_VUNAiQ
  { 1, 269, 271, 2894, 2896 }, // 93 IIC_VUNAiD
  { 1, 302, 305, 2896, 2899 }, // 94 IIC_fpALU64
  { 1, 269, 271, 2899, 2902 }, // 95 IIC_VBINi4D
  { 1, 269, 271, 2902, 2905 }, // 96 IIC_VSHLiD
  { 1, 269, 271, 2905, 2908 }, // 97 IIC_fpALU32
  { 1, 269, 271, 2908, 2911 }, // 98 IIC_VSUBiD
  { 1, 269, 271, 2911, 2914 }, // 99 IIC_VBINiQ
  { 1, 269, 271, 2914, 2917 }, // 100 IIC_VBINiD
  { 1, 269, 271, 2917, 2918 }, // 101 IIC_VMOVImm
  { 1, 269, 271, 2918, 2921 }, // 102 IIC_VCNTiD
  { 1, 300, 302, 2921, 2924 }, // 103 IIC_VCNTiQ
  { 1, 266, 269, 2924, 2926 }, // 104 IIC_fpCMP64
  { 1, 269, 271, 2926, 2928 }, // 105 IIC_fpCMP32
  { 0, 0, 0, 0, 0 }, // 106 IIC_fpCVTSH
  { 0, 0, 0, 0, 0 }, // 107 IIC_fpCVTHS
  { 1, 305, 308, 2928, 2930 }, // 108 IIC_fpCVTDS
  { 1, 308, 311, 2930, 2932 }, // 109 IIC_fpCVTSD
  { 1, 311, 314, 2932, 2935 }, // 110 IIC_fpDIV64
  { 1, 314, 317, 2935, 2938 }, // 111 IIC_fpDIV32
  { 1, 271, 273, 2938, 2940 }, // 112 IIC_VMOVIS
  { 1, 271, 273, 2940, 2942 }, // 113 IIC_VMOVD
  { 1, 317, 319, 2942, 2944 }, // 114 IIC_VMOVQ
  { 1, 271, 273, 2944, 2947 }, // 115 IIC_VEXTD
  { 1, 317, 319, 2947, 2950 }, // 116 IIC_VEXTQ
  { 1, 319, 322, 2950, 2954 }, // 117 IIC_fpFMAC64
  { 1, 269, 271, 2954, 2958 }, // 118 IIC_fpFMAC32
  { 1, 269, 271, 2958, 2962 }, // 119 IIC_VFMACD
  { 1, 300, 302, 2962, 2966 }, // 120 IIC_VFMACQ
  { 1, 271, 273, 2966, 2968 }, // 121 IIC_VMOVSI
  { 1, 269, 271, 2968, 2971 }, // 122 IIC_VBINi4Q
  { 1, 322, 325, 2971, 2973 }, // 123 IIC_VLD1dup
  { 1, 322, 325, 2973, 2977 }, // 124 IIC_VLD1dupu
  { 1, 325, 328, 2977, 2981 }, // 125 IIC_VLD1ln
  { 1, 325, 328, 2981, 2987 }, // 126 IIC_VLD1lnu
  { 1, 328, 331, 2987, 2989 }, // 127 IIC_VLD1
  { 1, 331, 334, 2989, 2994 }, // 128 IIC_VLD1x4
  { 1, 328, 331, 2994, 2998 }, // 129 IIC_VLD1x2u
  { 1, 331, 334, 2998, 3002 }, // 130 IIC_VLD1x3
  { 1, 328, 331, 3002, 3005 }, // 131 IIC_VLD1u
  { 1, 328, 331, 3005, 3008 }, // 132 IIC_VLD1x2
  { 1, 322, 325, 3008, 3011 }, // 133 IIC_VLD2dup
  { 1, 322, 325, 3011, 3016 }, // 134 IIC_VLD2dupu
  { 1, 331, 334, 3016, 3022 }, // 135 IIC_VLD2ln
  { 1, 331, 334, 3022, 3030 }, // 136 IIC_VLD2lnu
  { 1, 328, 331, 3030, 3033 }, // 137 IIC_VLD2
  { 1, 328, 331, 3033, 3039 }, // 138 IIC_VLD2u
  { 1, 331, 334, 3039, 3044 }, // 139 IIC_VLD2x2
  { 1, 331, 334, 3044, 3050 }, // 140 IIC_VLD2x2u
  { 1, 325, 328, 3050, 3054 }, // 141 IIC_VLD3dup
  { 1, 325, 328, 3054, 3060 }, // 142 IIC_VLD3dupu
  { 1, 334, 337, 3060, 3068 }, // 143 IIC_VLD3ln
  { 1, 334, 337, 3068, 3078 }, // 144 IIC_VLD3lnu
  { 1, 337, 340, 3078, 3082 }, // 145 IIC_VLD3
  { 1, 337, 340, 3082, 3087 }, // 146 IIC_VLD3u
  { 1, 325, 328, 3087, 3092 }, // 147 IIC_VLD4dup
  { 1, 325, 328, 3092, 3099 }, // 148 IIC_VLD4dupu
  { 1, 334, 337, 3099, 3109 }, // 149 IIC_VLD4ln
  { 1, 334, 337, 3109, 3121 }, // 150 IIC_VLD4lnu
  { 1, 337, 340, 3121, 3126 }, // 151 IIC_VLD4
  { 1, 337, 340, 3126, 3132 }, // 152 IIC_VLD4u
  { -1, 340, 345, 3132, 3137 }, // 153 IIC_fpLoad_mu
  { -1, 340, 345, 3137, 3141 }, // 154 IIC_fpLoad_m
  { 1, 345, 348, 3141, 3143 }, // 155 IIC_fpLoad64
  { 1, 345, 348, 3143, 3145 }, // 156 IIC_fpLoad32
  { 1, 319, 322, 3145, 3149 }, // 157 IIC_fpMAC64
  { 1, 300, 302, 3149, 3153 }, // 158 IIC_VMACi32D
  { 1, 269, 271, 3153, 3157 }, // 159 IIC_VMACi16D
  { 1, 269, 271, 3157, 3161 }, // 160 IIC_fpMAC32
  { 1, 269, 271, 3161, 3165 }, // 161 IIC_VMACD
  { 1, 300, 302, 3165, 3169 }, // 162 IIC_VMACQ
  { 1, 348, 352, 3169, 3173 }, // 163 IIC_VMACi32Q
  { 1, 300, 302, 3173, 3177 }, // 164 IIC_VMACi16Q
  { 1, 269, 271, 3177, 3180 }, // 165 IIC_fpMOVID
  { 1, 269, 271, 3180, 3182 }, // 166 IIC_VQUNAiD
  { 1, 269, 271, 3182, 3184 }, // 167 IIC_VMOVN
  { 1, 269, 271, 3184, 3187 }, // 168 IIC_fpMOVDI
  { 1, 269, 271, 3187, 3189 }, // 169 IIC_fpMOVSI
  { 1, 269, 271, 3189, 3191 }, // 170 IIC_fpMOVIS
  { 1, 352, 355, 3191, 3194 }, // 171 IIC_fpMUL64
  { 1, 269, 271, 3194, 3197 }, // 172 IIC_VMULi16D
  { 1, 300, 302, 3197, 3200 }, // 173 IIC_VMULi32D
  { 1, 269, 271, 3200, 3203 }, // 174 IIC_fpMUL32
  { 1, 269, 271, 3203, 3206 }, // 175 IIC_VFMULD
  { 1, 269, 271, 3206, 3209 }, // 176 IIC_VFMULQ
  { 1, 300, 302, 3209, 3212 }, // 177 IIC_VMULi16Q
  { 1, 348, 352, 3212, 3215 }, // 178 IIC_VMULi32Q
  { 1, 300, 302, 3215, 3218 }, // 179 IIC_VSHLiQ
  { 1, 300, 302, 3218, 3221 }, // 180 IIC_VPALiQ
  { 1, 269, 271, 3221, 3224 }, // 181 IIC_VPALiD
  { 1, 269, 271, 3224, 3227 }, // 182 IIC_VPBIND
  { 1, 269, 271, 3227, 3229 }, // 183 IIC_VQUNAiQ
  { 1, 300, 302, 3229, 3232 }, // 184 IIC_VSHLi4Q
  { 1, 269, 271, 3232, 3235 }, // 185 IIC_VSHLi4D
  { 1, 269, 271, 3235, 3238 }, // 186 IIC_VRECSD
  { 1, 300, 302, 3238, 3241 }, // 187 IIC_VRECSQ
  { 1, 317, 319, 3241, 3244 }, // 188 IIC_VMOVISL
  { 1, 355, 358, 3244, 3246 }, // 189 IIC_fpCVTID_WriteCvtFP
  { 1, 269, 271, 3246, 3248 }, // 190 IIC_fpCVTIS_WriteCvtFP
  { 1, 355, 358, 3248, 3250 }, // 191 IIC_fpCVTID
  { 1, 269, 271, 3250, 3252 }, // 192 IIC_fpCVTIS
  { 1, 311, 314, 3252, 3254 }, // 193 IIC_fpSQRT64
  { 1, 319, 322, 3254, 3256 }, // 194 IIC_fpSQRT32
  { 1, 322, 325, 3256, 3259 }, // 195 IIC_VST1ln
  { 1, 322, 325, 3259, 3264 }, // 196 IIC_VST1lnu
  { 1, 328, 331, 3264, 3267 }, // 197 IIC_VST1
  { 1, 331, 334, 3267, 3273 }, // 198 IIC_VST1x4
  { 1, 331, 334, 3273, 3279 }, // 199 IIC_VLD1x4u
  { 1, 331, 334, 3279, 3284 }, // 200 IIC_VST1x3
  { 1, 331, 334, 3284, 3289 }, // 201 IIC_VLD1x3u
  { 1, 331, 334, 3289, 3297 }, // 202 IIC_VST1x4u
  { 1, 331, 334, 3297, 3304 }, // 203 IIC_VST1x3u
  { 1, 328, 331, 3304, 3308 }, // 204 IIC_VST1x2
  { 1, 328, 331, 3308, 3312 }, // 205 IIC_VST2ln
  { 1, 328, 331, 3312, 3318 }, // 206 IIC_VST2lnu
  { 1, 328, 331, 3318, 3322 }, // 207 IIC_VST2
  { 1, 337, 340, 3322, 3328 }, // 208 IIC_VST2x2
  { 1, 337, 340, 3328, 3336 }, // 209 IIC_VST2x2u
  { 1, 331, 334, 3336, 3341 }, // 210 IIC_VST3ln
  { 1, 331, 334, 3341, 3348 }, // 211 IIC_VST3lnu
  { 1, 331, 334, 3348, 3353 }, // 212 IIC_VST3
  { 1, 331, 334, 3353, 3360 }, // 213 IIC_VST3u
  { 1, 337, 340, 3360, 3366 }, // 214 IIC_VST4ln
  { 1, 337, 340, 3366, 3374 }, // 215 IIC_VST4lnu
  { 1, 337, 340, 3374, 3380 }, // 216 IIC_VST4
  { 1, 337, 340, 3380, 3388 }, // 217 IIC_VST4u
  { -1, 340, 345, 3388, 3393 }, // 218 IIC_fpStore_mu
  { -1, 340, 345, 3393, 3397 }, // 219 IIC_fpStore_m
  { 1, 345, 348, 3397, 3399 }, // 220 IIC_fpStore64
  { 1, 345, 348, 3399, 3401 }, // 221 IIC_fpStore32
  { 1, 269, 271, 3401, 3404 }, // 222 IIC_VSUBiQ
  { 1, 317, 319, 3404, 3407 }, // 223 IIC_VTB1
  { 1, 317, 319, 3407, 3411 }, // 224 IIC_VTB2
  { 1, 358, 362, 3411, 3416 }, // 225 IIC_VTB3
  { 1, 358, 362, 3416, 3422 }, // 226 IIC_VTB4
  { 1, 317, 319, 3422, 3426 }, // 227 IIC_VTBX1
  { 1, 317, 319, 3426, 3431 }, // 228 IIC_VTBX2
  { 1, 358, 362, 3431, 3437 }, // 229 IIC_VTBX3
  { 1, 358, 362, 3437, 3444 }, // 230 IIC_VTBX4
  { 1, 355, 358, 3444, 3446 }, // 231 IIC_fpCVTDI_WriteCvtFP
  { 1, 269, 271, 3446, 3448 }, // 232 IIC_fpCVTSI_WriteCvtFP
  { 1, 355, 358, 3448, 3450 }, // 233 IIC_fpCVTDI
  { 1, 269, 271, 3450, 3452 }, // 234 IIC_fpCVTSI
  { 1, 271, 273, 3452, 3456 }, // 235 IIC_VPERMD
  { 1, 317, 319, 3456, 3460 }, // 236 IIC_VPERMQ
  { 1, 358, 362, 3460, 3464 }, // 237 IIC_VPERMQ3
  { 1, 265, 266, 3464, 3467 }, // 238 IIC_iALUsi_WriteALUsi_ReadALUsr
  { 1, 265, 266, 3467, 3469 }, // 239 IIC_iBITi
  { 1, 265, 266, 3469, 3471 }, // 240 IIC_iCMPsi_WriteCMPsi_ReadALU_ReadALU
  { 1, 265, 266, 3471, 3472 }, // 241 IIC_iCMPi_WriteCMP
  { 1, 265, 266, 3472, 3474 }, // 242 IIC_iCMPr_WriteCMP
  { 1, 265, 266, 3474, 3476 }, // 243 IIC_iCMPsi_WriteCMPsi
  { 1, 265, 266, 0, 0 }, // 244 IIC_iALUx
  { 1, 280, 282, 3476, 3478 }, // 245 IIC_iLoad_bh_i
  { 1, 280, 282, 3478, 3480 }, // 246 IIC_iLoad_d_i
  { 1, 265, 266, 3480, 3482 }, // 247 IIC_iCMOVsi_WriteALU
  { 1, 265, 266, 3482, 3483 }, // 248 IIC_iMOVi
  { 1, 265, 266, 3483, 3485 }, // 249 IIC_iMVNsi_WriteALU
  { 1, 265, 266, 3485, 3488 }, // 250 IIC_iALUsir_WriteALUsi_ReadALU
  { 1, 280, 282, 3488, 3490 }, // 251 IIC_iStore_bh_i
  { 1, 280, 282, 3490, 3492 }, // 252 IIC_iStore_i
  { 1, 265, 266, 3492, 3496 }, // 253 IIC_iEXTAsr
  { 1, 265, 266, 3496, 3498 }, // 254 IIC_iEXTr
  { 1, 265, 266, 3498, 3499 }, // 255 IIC_iTSTi_WriteCMP
  { 1, 265, 266, 3499, 3501 }, // 256 IIC_iTSTr_WriteCMP
  { 1, 265, 266, 3501, 3503 }, // 257 IIC_iTSTsi_WriteCMPsi
  { 1, 265, 266, 3503, 3506 }, // 258 IIC_iALUr_WriteALU
  { 1, 265, 266, 3506, 3508 }, // 259 IIC_iALUi_WriteALU
  { 1, 265, 266, 3508, 3511 }, // 260 IIC_iBITr_WriteALU
  { -1, 275, 277, 3511, 3514 }, // 261 IIC_iPop
  { -1, 277, 280, 3514, 3517 }, // 262 IIC_iPop_Br_WriteBrL
  { 1, 265, 266, 3517, 3519 }, // 263 IIC_iTSTr_WriteALU
  { 1, 265, 266, 3519, 3521 }, // 264 ANDri_BICri_EORri_ORRri
  { 1, 265, 266, 3521, 3524 }, // 265 ANDrr_BICrr_EORrr_ORRrr
  { 1, 265, 266, 3524, 3528 }, // 266 ANDrsi_BICrsi_EORrsi_ORRrsi
  { 1, 265, 266, 3528, 3532 }, // 267 ANDrsr_BICrsr_EORrsr_ORRrsr
  { 1, 265, 266, 3532, 3535 }, // 268 MOVCCsi_MOVCCsr
  { 1, 265, 266, 3535, 3538 }, // 269 MOVsi_MOVsr
  { 1, 265, 266, 3538, 3540 }, // 270 MOVsra_flag_MOVsrl_flag
  { 1, 265, 266, 3540, 3543 }, // 271 MVNsr
  { 1, 265, 266, 3543, 3545 }, // 272 MVNr
  { 1, 288, 290, 3545, 3547 }, // 273 MOVCCi32imm
  { 1, 288, 290, 3547, 3548 }, // 274 MOVi32imm
  { 1, 290, 293, 3548, 3549 }, // 275 MOV_ga_pcrel
  { 1, 293, 296, 3549, 3550 }, // 276 MOV_ga_pcrel_ldr
  { 0, 0, 0, 0, 0 }, // 277 SEL
  { 1, 265, 266, 3550, 3552 }, // 278 BFC_BFI_SBFX_UBFX
  { 1, 287, 288, 3552, 3556 }, // 279 MLA_MLAv5_MLS_SMMLA_SMMLAR_SMMLS_SMMLSR
  { 1, 287, 288, 3556, 3559 }, // 280 MUL_MULv5_SMMUL_SMMULR
  { 1, 296, 297, 3559, 3563 }, // 281 SMLAL_SMLALBB_SMLALBT_SMLALTB_SMLALTT_SMLALv5_UMAAL_UMLAL_UMLALv5
  { 1, 296, 297, 3563, 3567 }, // 282 SMULL_SMULLv5_UMULL_UMULLv5
  { 0, 0, 0, 0, 0 }, // 283 SMLAD_SMLADX_SMLALD_SMLALDX_SMLSD_SMLSDX_SMLSLD_SMLSLDX_SMUAD_SMUADX_SMUSD_SMUSDX
  { 1, 297, 298, 3567, 3570 }, // 284 SMULBB_SMULBT_SMULTB_SMULTT_SMULWB_SMULWT
  { 1, 287, 288, 3570, 3574 }, // 285 SMLABB_SMLABT_SMLATB_SMLATT_SMLAWB_SMLAWT
  { 1, 280, 282, 3574, 3577 }, // 286 LDRi12_PICLDR
  { 1, 282, 284, 3577, 3580 }, // 287 LDRrs
  { 1, 280, 282, 3580, 3583 }, // 288 LDRBi12_LDRH_LDRSB_LDRSH_PICLDRB_PICLDRH_PICLDRSB_PICLDRSH
  { 1, 280, 282, 3583, 3587 }, // 289 LDRHTi_LDRHTr_LDRH_POST_LDRH_PRE_LDRSBTi_LDRSBTr_LDRSB_POST_LDRSB_PRE_LDRSHTi_LDRSHTr_LDRSH_POST_LDRSH_PRE
  { 1, 265, 266, 3587, 3589 }, // 290 SXTB_SXTB16_SXTH_UXTB_UXTB16_UXTH
  { 1, 265, 266, 3589, 3591 }, // 291 t2SXTB_t2SXTB16_t2SXTH_t2UXTB_t2UXTB16_t2UXTH
  { 1, 288, 290, 3591, 3593 }, // 292 t2MOVCCi32imm
  { 1, 288, 290, 3593, 3594 }, // 293 t2MOVi32imm
  { 1, 290, 293, 3594, 3595 }, // 294 t2MOV_ga_pcrel
  { 1, 265, 266, 3595, 3596 }, // 295 t2MOVi16_ga_pcrel
  { 0, 0, 0, 0, 0 }, // 296 t2SEL
  { 1, 265, 266, 3596, 3598 }, // 297 t2BFC_t2SBFX_t2UBFX
  { 1, 265, 266, 3598, 3600 }, // 298 t2BFI
  { 1, 265, 266, 3600, 3603 }, // 299 QADD_QADD16_QADD8_QASX_QDADD_QDSUB_QSAX_QSUB_QSUB16_QSUB8_UQADD16_UQADD8_UQASX_UQSAX_UQSUB16_UQSUB8
  { 0, 0, 0, 0, 0 }, // 300 SSAT_SSAT16_USAT_USAT16_t2QADD_t2QADD16_t2QADD8_t2QASX_t2QDADD_t2QDSUB_t2QSAX_t2QSUB_t2QSUB16_t2QSUB8_t2SSAT_t2SSAT16_t2UQADD16_t2UQADD8_t2UQASX_t2UQSAX_t2UQSUB16_t2UQSUB8_t2USAT_t2USAT16
  { 1, 265, 266, 3603, 3606 }, // 301 SADD16_SADD8_SASX_SSAX_SSUB16_SSUB8_UADD16_UADD8_UASX_USAX_USUB16_USUB8
  { 0, 0, 0, 0, 0 }, // 302 t2SADD16_t2SADD8_t2SASX_t2SSAX_t2SSUB16_t2SSUB8_t2UADD16_t2UADD8_t2UASX_t2USAX_t2USUB16_t2USUB8
  { 1, 265, 266, 3606, 3609 }, // 303 SHADD16_SHADD8_SHASX_SHSAX_SHSUB16_SHSUB8_UHADD16_UHADD8_UHASX_UHSAX_UHSUB16_UHSUB8
  { 1, 265, 266, 3609, 3612 }, // 304 SXTAB_SXTAB16_SXTAH_UXTAB_UXTAB16_UXTAH
  { 0, 0, 0, 0, 0 }, // 305 t2SHADD16_t2SHADD8_t2SHASX_t2SHSAX_t2SHSUB16_t2SHSUB8_t2UHADD16_t2UHADD8_t2UHASX_t2UHSAX_t2UHSUB16_t2UHSUB8
  { 1, 265, 266, 3612, 3616 }, // 306 t2SXTAB_t2SXTAB16_t2SXTAH_t2UXTAB_t2UXTAB16_t2UXTAH
  { 0, 0, 0, 0, 0 }, // 307 USAD8
  { 0, 0, 0, 0, 0 }, // 308 USADA8
  { 0, 0, 0, 0, 0 }, // 309 SMUSD_SMUSDX
  { 1, 287, 288, 3616, 3619 }, // 310 t2MUL_t2SMMUL_t2SMMULR
  { 1, 297, 298, 3619, 3622 }, // 311 t2SMULBB_t2SMULBT_t2SMULTB_t2SMULTT_t2SMULWB_t2SMULWT
  { 1, 287, 288, 3622, 3626 }, // 312 t2SMUSD_t2SMUSDX
  { 1, 287, 288, 3626, 3630 }, // 313 t2MLA_t2MLS_t2SMMLA_t2SMMLAR_t2SMMLS_t2SMMLSR
  { 0, 0, 0, 0, 0 }, // 314 SMUAD_SMUADX
  { 1, 287, 288, 3630, 3634 }, // 315 t2SMUAD_t2SMUADX
  { 0, 0, 0, 0, 0 }, // 316 SMLSD_SMLSDX
  { 1, 287, 288, 3634, 3638 }, // 317 t2SMLABB_t2SMLABT_t2SMLATB_t2SMLATT_t2SMLAWB_t2SMLAWT
  { 1, 287, 288, 3638, 3642 }, // 318 t2SMLSD_t2SMLSDX
  { 0, 0, 0, 0, 0 }, // 319 SMLAD_SMLADX
  { 1, 287, 288, 3642, 3646 }, // 320 t2SMLAD_t2SMLADX
  { 1, 296, 297, 3646, 3650 }, // 321 SMULL_UMULL
  { 1, 296, 297, 3650, 3654 }, // 322 t2SMULL_t2UMULL
  { 1, 296, 297, 3654, 3658 }, // 323 t2SMLAL_t2SMLALBB_t2SMLALBT_t2SMLALD_t2SMLALDX_t2SMLALTB_t2SMLALTT_t2SMLSLD_t2SMLSLDX_t2UMAAL_t2UMLAL
  { 0, 0, 0, 0, 0 }, // 324 SDIV_UDIV_t2SDIV_t2UDIV
  { 1, 280, 282, 3658, 3661 }, // 325 LDRBi12
  { 1, 282, 284, 3661, 3664 }, // 326 LDRBrs_t2LDRBs_t2LDRHs
  { 0, 0, 0, 0, 0 }, // 327 LDREX_LDREXB_LDREXD_LDREXH_tLDRpci_pic
  { 1, 280, 282, 3664, 3667 }, // 328 LDRi12
  { 1, 280, 282, 3667, 3669 }, // 329 t2LDRBi12_t2LDRBi8_t2LDRBpci_t2LDRHi12_t2LDRHi8_t2LDRHpci_tLDRBi_tLDRHi
  { 1, 280, 282, 3669, 3671 }, // 330 t2LDRi12_t2LDRi8_t2LDRpci_tLDRi_tLDRpci_tLDRspi
  { 1, 284, 287, 3671, 3673 }, // 331 t2LDRpci_pic
  { 1, 282, 284, 3673, 3676 }, // 332 t2LDRs
  { 1, 280, 282, 3676, 3679 }, // 333 tLDRBr_tLDRHr
  { 1, 280, 282, 3679, 3682 }, // 334 tLDRr
  { 1, 280, 282, 3682, 3685 }, // 335 LDRH_PICLDRB_PICLDRH
  { 1, 280, 282, 3685, 3688 }, // 336 LDRcp
  { 1, 280, 282, 3688, 3690 }, // 337 t2LDRSBi12_t2LDRSBi8_t2LDRSBpci_t2LDRSHi12_t2LDRSHi8_t2LDRSHpci
  { 0, 0, 0, 0, 0 }, // 338 t2LDRSBpcrel_t2LDRSHpcrel
  { 1, 282, 284, 3690, 3693 }, // 339 t2LDRSBs_t2LDRSHs
  { 1, 280, 282, 3693, 3696 }, // 340 tLDRSB_tLDRSH
  { 1, 280, 282, 3696, 3700 }, // 341 LDRBT_POST_IMM_LDRBT_POST_REG_LDRB_POST_REG_LDRB_PRE_REG
  { 1, 280, 282, 3700, 3703 }, // 342 LDRB_POST_IMM_LDRB_PRE_IMM_t2LDRB_POST_t2LDRB_PRE_t2LDRH_POST_t2LDRH_PRE
  { 1, 280, 282, 3703, 3707 }, // 343 LDRHTi_LDRHTr_LDRH_POST_LDRH_PRE
  { 1, 280, 282, 3707, 3711 }, // 344 LDRT_POST_IMM_LDRT_POST_REG_LDR_POST_REG_LDR_PRE_REG
  { 1, 280, 282, 3711, 3714 }, // 345 LDR_POST_IMM_LDR_PRE_IMM_t2LDR_POST_t2LDR_PRE
  { 1, 280, 282, 3714, 3716 }, // 346 t2LDRBT_t2LDRHT
  { 1, 280, 282, 3716, 3718 }, // 347 t2LDRT
  { 1, 280, 282, 3718, 3720 }, // 348 t2LDRSBT_t2LDRSHT
  { 1, 280, 282, 3720, 3723 }, // 349 t2LDRSB_POST_t2LDRSB_PRE_t2LDRSH_POST_t2LDRSH_PRE
  { 1, 280, 282, 3723, 3726 }, // 350 LDRD
  { 1, 280, 282, 3726, 3728 }, // 351 t2LDRDi8
  { 1, 280, 282, 3728, 3732 }, // 352 LDRD_POST_LDRD_PRE_t2LDRD_POST_t2LDRD_PRE
  { -1, 273, 275, 3732, 3737 }, // 353 LDMDA_LDMDB_LDMIA_LDMIB_sysLDMDA_sysLDMDB_sysLDMIA_sysLDMIB_t2LDMDB_t2LDMIA_tLDMIA
  { -1, 275, 277, 3737, 3742 }, // 354 LDMDA_UPD_LDMDB_UPD_LDMIA_UPD_LDMIB_UPD_sysLDMDA_UPD_sysLDMDB_UPD_sysLDMIA_UPD_sysLDMIB_UPD_t2LDMDB_UPD_t2LDMIA_UPD_tLDMIA_UPD
  { -1, 277, 280, 3742, 3747 }, // 355 LDMIA_RET_t2LDMIA_RET
  { -1, 275, 277, 3747, 3750 }, // 356 tPOP
  { -1, 277, 280, 3750, 3753 }, // 357 tPOP_RET
  { 1, 280, 282, 3753, 3756 }, // 358 PICSTR_STRi12_tSTRr
  { 1, 280, 282, 3756, 3759 }, // 359 PICSTRB_PICSTRH_STRBi12_STRH_tSTRBr_tSTRHr
  { 1, 298, 300, 3759, 3762 }, // 360 STRBrs_t2STRBs_t2STRHs
  { 0, 0, 0, 0, 0 }, // 361 STREX_STREXB_STREXD_STREXH
  { 1, 298, 300, 3762, 3765 }, // 362 STRrs_t2STRs
  { 1, 280, 282, 3765, 3767 }, // 363 t2STRBi12_t2STRBi8_t2STRHi12_t2STRHi8_tSTRBi_tSTRHi
  { 1, 280, 282, 3767, 3769 }, // 364 t2STRi12_t2STRi8_tSTRi_tSTRspi
  { 0, 0, 0, 0, 0 }, // 365 STRBT_POST_STRT_POST
  { 1, 280, 282, 3769, 3773 }, // 366 STRBT_POST_IMM_STRBT_POST_REG_STRB_POST_REG_STRB_PRE_REG_STRHTi_STRHTr_STRH_POST_STRH_PRE
  { 1, 280, 282, 3773, 3776 }, // 367 STRB_POST_IMM_STRB_PRE_IMM_t2STRB_POST_t2STRB_PRE_t2STRH_POST
  { 1, 280, 282, 3776, 3780 }, // 368 STRBi_preidx_STRBr_preidx_STRH_preidx_STRT_POST_IMM_STRT_POST_REG_STR_POST_REG_STR_PRE_REG_STRi_preidx_STRr_preidx_t2STRB_preidx_t2STRH_preidx_t2STR_preidx
  { 1, 280, 282, 3780, 3783 }, // 369 STR_POST_IMM_STR_PRE_IMM_t2STRH_PRE_t2STR_POST_t2STR_PRE
  { 1, 280, 282, 3783, 3785 }, // 370 t2STRBT_t2STRHT
  { 1, 280, 282, 3785, 3787 }, // 371 t2STRT
  { 1, 280, 282, 3787, 3790 }, // 372 STRD_t2STRDi8
  { 1, 280, 282, 3790, 3794 }, // 373 STRD_POST_STRD_PRE_t2STRD_POST_t2STRD_PRE
  { -1, 273, 275, 0, 0 }, // 374 STMDA_STMDB_STMIA_STMIB_sysSTMDA_sysSTMDB_sysSTMIA_sysSTMIB_t2STMDB_t2STMIA
  { -1, 273, 275, 3794, 3795 }, // 375 STMDA_UPD_STMDB_UPD_STMIA_UPD_STMIB_UPD_sysSTMDA_UPD_sysSTMDB_UPD_sysSTMIA_UPD_sysSTMIB_UPD_t2STMDB_UPD_t2STMIA_UPD_tSTMIA_UPD
  { -1, 273, 275, 0, 0 }, // 376 tPUSH
  { 0, 0, 0, 0, 0 }, // 377 ITasm
  { 1, 265, 266, 0, 0 }, // 378 t2IT
  { 1, 269, 271, 3795, 3798 }, // 379 VADDLsv2i64_VADDLsv4i32_VADDLsv8i16_VADDLuv2i64_VADDLuv4i32_VADDLuv8i16_VNEGs16d_VNEGs32d_VNEGs8d_VPADDLsv16i8_VPADDLsv2i32_VPADDLsv4i16_VPADDLsv4i32_VPADDLsv8i16_VPADDLsv8i8_VPADDLuv16i8_VPADDLuv2i32_VPADDLuv4i16_VPADDLuv4i32_VPADDLuv8i16_VPADDLuv8i8_VPADDi16_VPADDi32_VPADDi8_VSHLLi16_VSHLLi32_VSHLLi8_VSHLLsv2i64_VSHLLsv4i32_VSHLLsv8i16_VSHLLuv2i64_VSHLLuv4i32_VSHLLuv8i16_VSHLiv16i8_VSHLiv1i64_VSHLiv2i32_VSHLiv2i64_VSHLiv4i16_VSHLiv4i32_VSHLiv8i16_VSHLiv8i8_VSHLsv1i64_VSHLsv2i32_VSHLsv4i16_VSHLsv8i8_VSHLuv1i64_VSHLuv2i32_VSHLuv4i16_VSHLuv8i8_VSHRsv16i8_VSHRsv1i64_VSHRsv2i32_VSHRsv2i64_VSHRsv4i16_VSHRsv4i32_VSHRsv8i16_VSHRsv8i8_VSHRuv16i8_VSHRuv1i64_VSHRuv2i32_VSHRuv2i64_VSHRuv4i16_VSHRuv4i32_VSHRuv8i16_VSHRuv8i8_VSLIv1i64_VSLIv2i32_VSLIv4i16_VSLIv8i8_VSRIv1i64_VSRIv2i32_VSRIv4i16_VSRIv8i8_VSUBLsv2i64_VSUBLsv4i32_VSUBLsv8i16_VSUBLuv2i64_VSUBLuv4i32_VSUBLuv8i16
  { 1, 269, 271, 3798, 3801 }, // 380 VADDWsv2i64_VADDWsv4i32_VADDWsv8i16_VADDWuv2i64_VADDWuv4i32_VADDWuv8i16_VSUBWsv2i64_VSUBWsv4i32_VSUBWsv8i16_VSUBWuv2i64_VSUBWuv4i32_VSUBWuv8i16_VSUBv1i64_VSUBv2i32_VSUBv4i16_VSUBv8i8
  { 1, 269, 271, 3801, 3804 }, // 381 VADDv16i8_VADDv2i64_VADDv4i32_VADDv8i16_VANDq_VBICq_VBIFq_VBITq_VEORq_VORNq_VORRq
  { 1, 269, 271, 3804, 3807 }, // 382 VADDv1i64_VADDv2i32_VADDv4i16_VADDv8i8_VANDd_VBICd_VBIFd_VBITd_VEORd_VORNd_VORRd
  { 1, 269, 271, 3807, 3808 }, // 383 VBICiv2i32_VBICiv4i16_VBICiv4i32_VBICiv8i16_VORRiv2i32_VORRiv4i16_VORRiv4i32_VORRiv8i16
  { 1, 269, 271, 3808, 3811 }, // 384 VBSLd_VCLSv2i32_VCLSv4i16_VCLSv8i8_VCLZv2i32_VCLZv4i16_VCLZv8i8_VCNTd
  { 1, 300, 302, 3811, 3814 }, // 385 VBSLq_VCLSv16i8_VCLSv4i32_VCLSv8i16_VCLZv16i8_VCLZv4i32_VCLZv8i16_VCNTq
  { 1, 269, 271, 3814, 3817 }, // 386 VHADDsv16i8_VHADDsv4i32_VHADDsv8i16_VHADDuv16i8_VHADDuv4i32_VHADDuv8i16_VRHADDsv16i8_VRHADDsv4i32_VRHADDsv8i16_VRHADDuv16i8_VRHADDuv4i32_VRHADDuv8i16_VTSTv16i8_VTSTv4i32_VTSTv8i16
  { 1, 269, 271, 3817, 3820 }, // 387 VHADDsv2i32_VHADDsv4i16_VHADDsv8i8_VHADDuv2i32_VHADDuv4i16_VHADDuv8i8_VRHADDsv2i32_VRHADDsv4i16_VRHADDsv8i8_VRHADDuv2i32_VRHADDuv4i16_VRHADDuv8i8_VTSTv2i32_VTSTv4i16_VTSTv8i8
  { 1, 269, 271, 3820, 3823 }, // 388 VHSUBsv16i8_VHSUBsv4i32_VHSUBsv8i16_VHSUBuv16i8_VHSUBuv4i32_VHSUBuv8i16
  { 1, 269, 271, 3823, 3826 }, // 389 VHSUBsv2i32_VHSUBsv4i16_VHSUBsv8i8_VHSUBuv2i32_VHSUBuv4i16_VHSUBuv8i8
  { 1, 300, 302, 3826, 3828 }, // 390 VNEGf32q
  { 1, 269, 271, 3828, 3830 }, // 391 VNEGfd
  { 1, 300, 302, 3830, 3833 }, // 392 VNEGs16q_VNEGs32q_VNEGs8q_VSHLsv16i8_VSHLsv2i64_VSHLsv4i32_VSHLsv8i16_VSHLuv16i8_VSHLuv2i64_VSHLuv4i32_VSHLuv8i16_VSLIv16i8_VSLIv2i64_VSLIv4i32_VSLIv8i16_VSRIv16i8_VSRIv2i64_VSRIv4i32_VSRIv8i16
  { 1, 269, 271, 3833, 3836 }, // 393 VQSHLsiv16i8_VQSHLsiv1i64_VQSHLsiv2i32_VQSHLsiv2i64_VQSHLsiv4i16_VQSHLsiv4i32_VQSHLsiv8i16_VQSHLsiv8i8_VQSHLsuv16i8_VQSHLsuv1i64_VQSHLsuv2i32_VQSHLsuv2i64_VQSHLsuv4i16_VQSHLsuv4i32_VQSHLsuv8i16_VQSHLsuv8i8_VQSHLsv1i64_VQSHLsv2i32_VQSHLsv4i16_VQSHLsv8i8_VQSHLuiv16i8_VQSHLuiv1i64_VQSHLuiv2i32_VQSHLuiv2i64_VQSHLuiv4i16_VQSHLuiv4i32_VQSHLuiv8i16_VQSHLuiv8i8_VQSHLuv1i64_VQSHLuv2i32_VQSHLuv4i16_VQSHLuv8i8
  { 1, 300, 302, 3836, 3839 }, // 394 VQSHLsv16i8_VQSHLsv2i64_VQSHLsv4i32_VQSHLsv8i16_VQSHLuv16i8_VQSHLuv2i64_VQSHLuv4i32_VQSHLuv8i16
  { 1, 269, 271, 3839, 3842 }, // 395 VSUBv16i8_VSUBv2i64_VSUBv4i32_VSUBv8i16
  { 1, 271, 273, 3842, 3845 }, // 396 VEXTd16_VEXTd32_VEXTd8
  { 1, 317, 319, 3845, 3848 }, // 397 VEXTq16_VEXTq32_VEXTq64_VEXTq8
  { 1, 271, 273, 3848, 3850 }, // 398 VREV16d8_VREV32d16_VREV32d8_VREV64d16_VREV64d32_VREV64d8
  { 1, 317, 319, 3850, 3852 }, // 399 VREV16q8_VREV32q16_VREV32q8_VREV64q16_VREV64q32_VREV64q8
  { 1, 269, 271, 3852, 3856 }, // 400 VABALsv2i64_VABALsv4i32_VABALsv8i16_VABALuv2i64_VABALuv4i32_VABALuv8i16_VABAsv2i32_VABAsv4i16_VABAsv8i8_VABAuv2i32_VABAuv4i16_VABAuv8i8
  { 1, 300, 302, 3856, 3860 }, // 401 VABAsv16i8_VABAsv4i32_VABAsv8i16_VABAuv16i8_VABAuv4i32_VABAuv8i16
  { 1, 269, 271, 3860, 3862 }, // 402 VABSfd
  { 1, 300, 302, 3862, 3864 }, // 403 VABSfq
  { 1, 269, 271, 3864, 3866 }, // 404 VABSv16i8_VABSv4i32_VABSv8i16
  { 1, 269, 271, 3866, 3868 }, // 405 VABSv2i32_VABSv4i16_VABSv8i8
  { 1, 269, 271, 3868, 3871 }, // 406 VACGEd_VACGTd_VCEQfd_VCGEfd_VCGTfd
  { 1, 300, 302, 3871, 3874 }, // 407 VACGEq_VACGTq_VCEQfq_VCGEfq_VCGTfq
  { 1, 269, 271, 3874, 3877 }, // 408 VCEQv16i8_VCEQv4i32_VCEQv8i16_VCGEsv16i8_VCGEsv4i32_VCGEsv8i16_VCGEuv16i8_VCGEuv4i32_VCGEuv8i16_VCGTsv16i8_VCGTsv4i32_VCGTsv8i16_VCGTuv16i8_VCGTuv4i32_VCGTuv8i16_VQSUBsv16i8_VQSUBsv2i64_VQSUBsv4i32_VQSUBsv8i16_VQSUBuv16i8_VQSUBuv2i64_VQSUBuv4i32_VQSUBuv8i16
  { 1, 269, 271, 3877, 3880 }, // 409 VCEQv2i32_VCEQv4i16_VCEQv8i8_VCGEsv2i32_VCGEsv4i16_VCGEsv8i8_VCGEuv2i32_VCGEuv4i16_VCGEuv8i8_VCGTsv2i32_VCGTsv4i16_VCGTsv8i8_VCGTuv2i32_VCGTuv4i16_VCGTuv8i8_VQSUBsv1i64_VQSUBsv2i32_VQSUBsv4i16_VQSUBsv8i8_VQSUBuv1i64_VQSUBuv2i32_VQSUBuv4i16_VQSUBuv8i8
  { 0, 0, 0, 0, 0 }, // 410 VCEQzv16i8_VCEQzv2f32_VCEQzv2i32_VCEQzv4f32_VCEQzv4i16_VCEQzv4i32_VCEQzv8i16_VCEQzv8i8_VCGEzv16i8_VCGEzv2f32_VCGEzv2i32_VCGEzv4f32_VCGEzv4i16_VCGEzv4i32_VCGEzv8i16_VCGEzv8i8_VCGTzv16i8_VCGTzv2f32_VCGTzv2i32_VCGTzv4f32_VCGTzv4i16_VCGTzv4i32_VCGTzv8i16_VCGTzv8i8_VCLEzv16i8_VCLEzv2f32_VCLEzv2i32_VCLEzv4f32_VCLEzv4i16_VCLEzv4i32_VCLEzv8i16_VCLEzv8i8_VCLTzv16i8_VCLTzv2f32_VCLTzv2i32_VCLTzv4f32_VCLTzv4i16_VCLTzv4i32_VCLTzv8i16_VCLTzv8i8
  { 1, 300, 302, 3880, 3883 }, // 411 VPADALsv16i8_VPADALsv4i32_VPADALsv8i16_VPADALuv16i8_VPADALuv4i32_VPADALuv8i16
  { 1, 269, 271, 3883, 3886 }, // 412 VPADALsv2i32_VPADALsv4i16_VPADALsv8i8_VPADALuv2i32_VPADALuv4i16_VPADALuv8i8_VRSRAsv16i8_VRSRAsv1i64_VRSRAsv2i32_VRSRAsv2i64_VRSRAsv4i16_VRSRAsv4i32_VRSRAsv8i16_VRSRAsv8i8_VRSRAuv16i8_VRSRAuv1i64_VRSRAuv2i32_VRSRAuv2i64_VRSRAuv4i16_VRSRAuv4i32_VRSRAuv8i16_VRSRAuv8i8_VSRAsv16i8_VSRAsv1i64_VSRAsv2i32_VSRAsv2i64_VSRAsv4i16_VSRAsv4i32_VSRAsv8i16_VSRAsv8i8_VSRAuv16i8_VSRAuv1i64_VSRAuv2i32_VSRAuv2i64_VSRAuv4i16_VSRAuv4i32_VSRAuv8i16_VSRAuv8i8
  { 1, 269, 271, 3886, 3888 }, // 413 VQABSv16i8_VQABSv4i32_VQABSv8i16_VQNEGv16i8_VQNEGv4i32_VQNEGv8i16
  { 1, 269, 271, 3888, 3890 }, // 414 VQABSv2i32_VQABSv4i16_VQABSv8i8_VQNEGv2i32_VQNEGv4i16_VQNEGv8i8
  { 1, 269, 271, 3890, 3893 }, // 415 VQADDsv16i8_VQADDsv2i64_VQADDsv4i32_VQADDsv8i16_VQADDuv16i8_VQADDuv2i64_VQADDuv4i32_VQADDuv8i16
  { 1, 269, 271, 3893, 3896 }, // 416 VQADDsv1i64_VQADDsv2i32_VQADDsv4i16_VQADDsv8i8_VQADDuv1i64_VQADDuv2i32_VQADDuv4i16_VQADDuv8i8
  { 1, 300, 302, 3896, 3899 }, // 417 VQRSHLsv16i8_VQRSHLsv2i64_VQRSHLsv4i32_VQRSHLsv8i16_VQRSHLuv16i8_VQRSHLuv2i64_VQRSHLuv4i32_VQRSHLuv8i16_VRSHLsv16i8_VRSHLsv2i64_VRSHLsv4i32_VRSHLsv8i16_VRSHLuv16i8_VRSHLuv2i64_VRSHLuv4i32_VRSHLuv8i16
  { 1, 269, 271, 3899, 3902 }, // 418 VQRSHLsv1i64_VQRSHLsv2i32_VQRSHLsv4i16_VQRSHLsv8i8_VQRSHLuv1i64_VQRSHLuv2i32_VQRSHLuv4i16_VQRSHLuv8i8_VRSHLsv1i64_VRSHLsv2i32_VRSHLsv4i16_VRSHLsv8i8_VRSHLuv1i64_VRSHLuv2i32_VRSHLuv4i16_VRSHLuv8i8_VRSHRsv16i8_VRSHRsv1i64_VRSHRsv2i32_VRSHRsv2i64_VRSHRsv4i16_VRSHRsv4i32_VRSHRsv8i16_VRSHRsv8i8_VRSHRuv16i8_VRSHRuv1i64_VRSHRuv2i32_VRSHRuv2i64_VRSHRuv4i16_VRSHRuv4i32_VRSHRuv8i16_VRSHRuv8i8
  { 1, 269, 271, 3902, 3904 }, // 419 VRECPEd_VRECPEfd_VRSQRTEd_VRSQRTEfd
  { 1, 300, 302, 3904, 3906 }, // 420 VRECPEfq_VRECPEq_VRSQRTEfq_VRSQRTEq
  { 1, 269, 271, 3906, 3909 }, // 421 VADDHNv2i32_VADDHNv4i16_VADDHNv8i8_VSUBHNv2i32_VSUBHNv4i16_VSUBHNv8i8
  { 1, 269, 271, 3909, 3912 }, // 422 VSHRNv2i32_VSHRNv4i16_VSHRNv8i8
  { 1, 269, 271, 3912, 3915 }, // 423 VQRSHRNsv2i32_VQRSHRNsv4i16_VQRSHRNsv8i8_VQRSHRNuv2i32_VQRSHRNuv4i16_VQRSHRNuv8i8_VQRSHRUNv2i32_VQRSHRUNv4i16_VQRSHRUNv8i8_VQSHRNsv2i32_VQSHRNsv4i16_VQSHRNsv8i8_VQSHRNuv2i32_VQSHRNuv4i16_VQSHRNuv8i8_VQSHRUNv2i32_VQSHRUNv4i16_VQSHRUNv8i8_VRSHRNv2i32_VRSHRNv4i16_VRSHRNv8i8
  { 1, 269, 271, 3915, 3918 }, // 424 VRADDHNv2i32_VRADDHNv4i16_VRADDHNv8i8_VRSUBHNv2i32_VRSUBHNv4i16_VRSUBHNv8i8
  { 1, 317, 319, 3918, 3921 }, // 425 VTBL1
  { 1, 317, 319, 3921, 3925 }, // 426 VTBX1
  { 1, 317, 319, 3925, 3929 }, // 427 VTBL2
  { 1, 317, 319, 3929, 3934 }, // 428 VTBX2
  { 1, 358, 362, 3934, 3939 }, // 429 VTBL3_VTBL3Pseudo
  { 1, 358, 362, 3939, 3945 }, // 430 VTBX3_VTBX3Pseudo
  { 1, 358, 362, 3945, 3951 }, // 431 VTBL4_VTBL4Pseudo
  { 1, 358, 362, 3951, 3958 }, // 432 VTBX4_VTBX4Pseudo
  { 0, 0, 0, 0, 0 }, // 433 VSWPd_VSWPq
  { 1, 271, 273, 3958, 3962 }, // 434 VTRNd16_VTRNd32_VTRNd8_VUZPd16_VUZPd8_VZIPd16_VZIPd8
  { 1, 317, 319, 3962, 3966 }, // 435 VTRNq16_VTRNq32_VTRNq8
  { 1, 358, 362, 3966, 3970 }, // 436 VUZPq16_VUZPq32_VUZPq8_VZIPq16_VZIPq32_VZIPq8
  { 1, 266, 269, 3970, 3972 }, // 437 VABSD_VNEGD
  { 1, 269, 271, 3972, 3974 }, // 438 VABSS_VNEGS
  { 1, 266, 269, 3974, 3976 }, // 439 VCMPD_VCMPED_VCMPEZD_VCMPZD
  { 1, 269, 271, 3976, 3978 }, // 440 VCMPES_VCMPEZS_VCMPS_VCMPZS
  { 1, 269, 271, 3978, 3981 }, // 441 VABDLsv2i64_VABDLsv4i32_VABDLsv8i16_VABDLuv2i64_VABDLuv4i32_VABDLuv8i16_VABDsv16i8_VABDsv4i32_VABDsv8i16_VABDuv16i8_VABDuv4i32_VABDuv8i16_VMAXsv16i8_VMAXsv4i32_VMAXsv8i16_VMAXuv16i8_VMAXuv4i32_VMAXuv8i16_VMINsv16i8_VMINsv4i32_VMINsv8i16_VMINuv16i8_VMINuv4i32_VMINuv8i16
  { 1, 269, 271, 3981, 3984 }, // 442 VABDfd_VADDfd_VMAXfd_VMINfd_VSUBfd
  { 1, 300, 302, 3984, 3987 }, // 443 VABDfq_VADDfq_VMAXfq_VMINfq_VSUBfq
  { 1, 269, 271, 3987, 3990 }, // 444 VABDsv2i32_VABDsv4i16_VABDsv8i8_VABDuv2i32_VABDuv4i16_VABDuv8i8_VMAXsv2i32_VMAXsv4i16_VMAXsv8i8_VMAXuv2i32_VMAXuv4i16_VMAXuv8i8_VMINsv2i32_VMINsv4i16_VMINsv8i8_VMINuv2i32_VMINuv4i16_VMINuv8i8_VPMAXs16_VPMAXs32_VPMAXs8_VPMAXu16_VPMAXu32_VPMAXu8_VPMINs16_VPMINs32_VPMINs8_VPMINu16_VPMINu32_VPMINu8
  { 1, 269, 271, 3990, 3993 }, // 445 VADDS_VSUBS
  { 0, 0, 0, 0, 0 }, // 446 VMAXNMD_VMAXNMND_VMAXNMNQ_VMAXNMS_VMINNMD_VMINNMND_VMINNMNQ_VMINNMS
  { 1, 269, 271, 3993, 3996 }, // 447 VPADDf_VPMAXf_VPMINf
  { 1, 302, 305, 3996, 3999 }, // 448 VADDD_VSUBD
  { 1, 269, 271, 3999, 4002 }, // 449 VRECPSfd_VRSQRTSfd
  { 1, 300, 302, 4002, 4005 }, // 450 VRECPSfq_VRSQRTSfq
  { 0, 0, 0, 0, 0 }, // 451 VMULLp64
  { 1, 269, 271, 4005, 4008 }, // 452 VMULLp8_VMULLslsv2i32_VMULLslsv4i16_VMULLsluv2i32_VMULLsluv4i16_VMULLsv4i32_VMULLsv8i16_VMULLuv4i32_VMULLuv8i16_VMULpd_VMULslv4i16_VMULv4i16_VMULv8i8_VQDMULHslv4i16_VQDMULHv4i16_VQDMULLslv2i32_VQDMULLslv4i16_VQDMULLv4i32_VQRDMULHslv4i16_VQRDMULHv4i16
  { 1, 300, 302, 4008, 4011 }, // 453 VMULLsv2i64_VMULLuv2i64_VMULslv2i32_VMULv2i32_VQDMULHslv2i32_VQDMULHv2i32_VQDMULLv2i64_VQRDMULHslv2i32_VQRDMULHv2i32
  { 1, 269, 271, 4011, 4014 }, // 454 VMULS_VNMULS
  { 1, 269, 271, 4014, 4017 }, // 455 VMULfd
  { 1, 269, 271, 4017, 4020 }, // 456 VMULfq
  { 1, 300, 302, 4020, 4023 }, // 457 VMULpq_VMULslv8i16_VMULv16i8_VMULv8i16_VQDMULHslv8i16_VQDMULHv8i16_VQRDMULHslv8i16_VQRDMULHv8i16
  { 1, 269, 271, 4023, 4026 }, // 458 VMULslfd
  { 1, 300, 302, 4026, 4029 }, // 459 VMULslfq
  { 1, 348, 352, 4029, 4032 }, // 460 VMULslv4i32_VMULv4i32_VQDMULHslv4i32_VQDMULHv4i32_VQRDMULHslv4i32_VQRDMULHv4i32
  { 1, 352, 355, 4032, 4035 }, // 461 VMULD_VNMULD
  { 1, 319, 322, 4035, 4039 }, // 462 VFMAD_VFMSD_VFNMAD_VFNMSD
  { 1, 269, 271, 4039, 4043 }, // 463 VFMAS_VFMSS_VFNMAS_VFNMSS
  { 1, 319, 322, 4043, 4047 }, // 464 VMLAD_VMLSD_VNMLAD_VNMLSD
  { 1, 300, 302, 4047, 4051 }, // 465 VMLALslsv2i32_VMLALsluv2i32_VMLALsv2i64_VMLALuv2i64_VMLAslv2i32_VMLAv2i32_VMLSLslsv2i32_VMLSLsluv2i32_VMLSLsv2i64_VMLSLuv2i64_VMLSslv2i32_VMLSv2i32_VQDMLALslv2i32_VQDMLALv2i64_VQDMLSLslv2i32_VQDMLSLv2i64
  { 1, 269, 271, 4051, 4055 }, // 466 VMLALslsv4i16_VMLALsluv4i16_VMLALsv4i32_VMLALsv8i16_VMLALuv4i32_VMLALuv8i16_VMLAslv4i16_VMLAv4i16_VMLAv8i8_VMLSLslsv4i16_VMLSLsluv4i16_VMLSLsv4i32_VMLSLsv8i16_VMLSLuv4i32_VMLSLuv8i16_VMLSslv4i16_VMLSv4i16_VMLSv8i8_VQDMLALslv4i16_VQDMLALv4i32_VQDMLSLslv4i16_VQDMLSLv4i32
  { 1, 269, 271, 4055, 4059 }, // 467 VMLAS_VMLSS_VNMLAS_VNMLSS
  { 1, 269, 271, 4059, 4063 }, // 468 VMLAfd_VMLAslfd_VMLSfd_VMLSslfd
  { 1, 300, 302, 4063, 4067 }, // 469 VMLAfq_VMLAslfq_VMLSfq_VMLSslfq
  { 1, 348, 352, 4067, 4071 }, // 470 VMLAslv4i32_VMLAv4i32_VMLSslv4i32_VMLSv4i32
  { 1, 300, 302, 4071, 4075 }, // 471 VMLAslv8i16_VMLAv16i8_VMLAv8i16_VMLSslv8i16_VMLSv16i8_VMLSv8i16
  { 1, 269, 271, 4075, 4079 }, // 472 VFMAfd_VFMSfd
  { 1, 300, 302, 4079, 4083 }, // 473 VFMAfq_VFMSfq
  { 0, 0, 0, 0, 0 }, // 474 VCVTANSD_VCVTANSQ_VCVTANUD_VCVTANUQ_VCVTASD_VCVTASS_VCVTAUD_VCVTAUS_VCVTBDH_VCVTBHD_VCVTMNSD_VCVTMNSQ_VCVTMNUD_VCVTMNUQ_VCVTMSD_VCVTMSS_VCVTMUD_VCVTMUS_VCVTNNSD_VCVTNNSQ_VCVTNNUD_VCVTNNUQ_VCVTNSD_VCVTNSS_VCVTNUD_VCVTNUS_VCVTPNSD_VCVTPNSQ_VCVTPNUD_VCVTPNUQ_VCVTPSD_VCVTPSS_VCVTPUD_VCVTPUS_VCVTTDH_VCVTTHD
  { 0, 0, 0, 0, 0 }, // 475 VCVTBHS_VCVTTHS
  { 0, 0, 0, 0, 0 }, // 476 VCVTBSH_VCVTTSH
  { 1, 305, 308, 4083, 4085 }, // 477 VCVTDS
  { 1, 308, 311, 4085, 4087 }, // 478 VCVTSD
  { 1, 300, 302, 4087, 4089 }, // 479 VCVTf2h_VCVTf2sq_VCVTf2uq_VCVTf2xsq_VCVTf2xuq_VCVTh2f_VCVTs2fq_VCVTu2fq_VCVTxs2fq_VCVTxu2fq
  { 1, 269, 271, 4089, 4091 }, // 480 VCVTf2sd_VCVTf2ud_VCVTf2xsd_VCVTf2xud_VCVTs2fd_VCVTu2fd_VCVTxs2fd_VCVTxu2fd
  { 1, 355, 358, 4091, 4093 }, // 481 VSITOD_VUITOD
  { 1, 269, 271, 4093, 4095 }, // 482 VSITOS_VUITOS
  { 1, 355, 358, 4095, 4097 }, // 483 VTOSHD_VTOSLD_VTOUHD_VTOULD
  { 1, 269, 271, 4097, 4099 }, // 484 VTOSHS_VTOSLS_VTOUHS_VTOULS
  { 1, 355, 358, 4099, 4101 }, // 485 VTOSIRD_VTOSIZD_VTOUIRD_VTOUIZD
  { 1, 269, 271, 4101, 4103 }, // 486 VTOSIRS_VTOSIZS_VTOUIRS_VTOUIZS
  { 1, 266, 269, 4103, 4105 }, // 487 FCONSTD_VMOVD_VMOVDcc
  { 1, 269, 271, 4105, 4107 }, // 488 FCONSTS_VMOVS_VMOVScc
  { 1, 269, 271, 4107, 4108 }, // 489 VMOVv16i8_VMOVv1i64_VMOVv2f32_VMOVv2i32_VMOVv2i64_VMOVv4f32_VMOVv4i16_VMOVv4i32_VMOVv8i16_VMOVv8i8_VMVNv2i32_VMVNv4i16_VMVNv4i32_VMVNv8i16
  { 1, 269, 271, 4108, 4111 }, // 490 VMVNd_VMVNq
  { 1, 269, 271, 4111, 4113 }, // 491 VMOVLsv2i64_VMOVLsv4i32_VMOVLsv8i16_VMOVLuv2i64_VMOVLuv4i32_VMOVLuv8i16
  { 1, 269, 271, 4113, 4115 }, // 492 VMOVNv2i32_VMOVNv4i16_VMOVNv8i8
  { 1, 269, 271, 4115, 4117 }, // 493 VQMOVNsuv2i32_VQMOVNsuv4i16_VQMOVNsuv8i8_VQMOVNsv2i32_VQMOVNsv4i16_VQMOVNsv8i8_VQMOVNuv2i32_VQMOVNuv4i16_VQMOVNuv8i8
  { 1, 271, 273, 4117, 4119 }, // 494 VDUPLN16d_VDUPLN32d_VDUPLN8d
  { 1, 317, 319, 4119, 4121 }, // 495 VDUPLN16q_VDUPLN32q_VDUPLN8q
  { 1, 271, 273, 4121, 4123 }, // 496 VDUP16d_VDUP16q_VDUP32d_VDUP32q_VDUP8d_VDUP8q
  { 1, 269, 271, 4123, 4125 }, // 497 VMOVRS
  { 1, 269, 271, 4125, 4127 }, // 498 VMOVSR
  { 1, 317, 319, 4127, 4130 }, // 499 VSETLNi16_VSETLNi32_VSETLNi8
  { 1, 269, 271, 4130, 4133 }, // 500 VMOVRRD_VMOVRRS
  { 1, 269, 271, 4133, 4136 }, // 501 VMOVDRR
  { 1, 269, 271, 4136, 4139 }, // 502 VMOVSRR
  { 1, 271, 273, 4139, 4141 }, // 503 VGETLNi32_VGETLNu16_VGETLNu8
  { 1, 271, 273, 4141, 4143 }, // 504 VGETLNs16_VGETLNs8
  { 1, 271, 273, 4143, 4144 }, // 505 VMRS_VMRS_FPEXC_VMRS_FPINST_VMRS_FPINST2_VMRS_FPSID_VMRS_MVFR0_VMRS_MVFR1_VMRS_MVFR2
  { 1, 271, 273, 4144, 4145 }, // 506 VMSR_VMSR_FPEXC_VMSR_FPINST_VMSR_FPINST2_VMSR_FPSID
  { 1, 271, 273, 4145, 4146 }, // 507 FMSTAT
  { 1, 345, 348, 4146, 4148 }, // 508 VLDRD
  { 1, 345, 348, 4148, 4150 }, // 509 VLDRS
  { 1, 345, 348, 4150, 4152 }, // 510 VSTRD
  { 1, 345, 348, 4152, 4154 }, // 511 VSTRS
  { -1, 340, 345, 4154, 4158 }, // 512 VLDMQIA
  { -1, 340, 345, 4158, 4162 }, // 513 VSTMQIA
  { -1, 340, 345, 4162, 4166 }, // 514 VLDMDIA_VLDMSIA
  { -1, 340, 345, 4166, 4171 }, // 515 VLDMDDB_UPD_VLDMDIA_UPD_VLDMSDB_UPD_VLDMSIA_UPD
  { -1, 340, 345, 4171, 4175 }, // 516 VSTMDIA_VSTMSIA
  { -1, 340, 345, 4175, 4180 }, // 517 VSTMDDB_UPD_VSTMDIA_UPD_VSTMSDB_UPD_VSTMSIA_UPD
  { 1, 328, 331, 4180, 4182 }, // 518 VLD1d16_VLD1d32_VLD1d64_VLD1d8
  { 1, 328, 331, 4182, 4185 }, // 519 VLD1q16_VLD1q32_VLD1q64_VLD1q8
  { 1, 328, 331, 4185, 4188 }, // 520 VLD1d16wb_fixed_VLD1d16wb_register_VLD1d32wb_fixed_VLD1d32wb_register_VLD1d64wb_fixed_VLD1d64wb_register_VLD1d8wb_fixed_VLD1d8wb_register
  { 1, 328, 331, 4188, 4192 }, // 521 VLD1q16wb_fixed_VLD1q16wb_register_VLD1q32wb_fixed_VLD1q32wb_register_VLD1q64wb_fixed_VLD1q64wb_register_VLD1q8wb_fixed_VLD1q8wb_register
  { 1, 331, 334, 4192, 4196 }, // 522 VLD1d16T_VLD1d32T_VLD1d64T_VLD1d64TPseudo_VLD1d64TPseudoWB_fixed_VLD1d64TPseudoWB_register_VLD1d8T
  { 1, 328, 331, 4196, 4200 }, // 523 VLD1d16Twb_fixed_VLD1d16Twb_register_VLD1d32Twb_fixed_VLD1d32Twb_register_VLD1d64Twb_fixed_VLD1d64Twb_register_VLD1d8Twb_fixed_VLD1d8Twb_register
  { 1, 331, 334, 4200, 4205 }, // 524 VLD1d16Q_VLD1d32Q_VLD1d64Q_VLD1d64QPseudo_VLD1d64QPseudoWB_fixed_VLD1d64QPseudoWB_register_VLD1d8Q
  { 1, 328, 331, 4205, 4209 }, // 525 VLD1d16Qwb_fixed_VLD1d16Qwb_register_VLD1d32Qwb_fixed_VLD1d32Qwb_register_VLD1d64Qwb_fixed_VLD1d64Qwb_register_VLD1d8Qwb_fixed_VLD1d8Qwb_register
  { 1, 328, 331, 4209, 4212 }, // 526 VLD2b16_VLD2b32_VLD2b8_VLD2d16_VLD2d32_VLD2d8
  { 1, 331, 334, 4212, 4217 }, // 527 VLD2q16_VLD2q16Pseudo_VLD2q32_VLD2q32Pseudo_VLD2q8_VLD2q8Pseudo
  { 1, 328, 331, 4217, 4223 }, // 528 VLD2b16wb_fixed_VLD2b16wb_register_VLD2b32wb_fixed_VLD2b32wb_register_VLD2b8wb_fixed_VLD2b8wb_register_VLD2d16wb_fixed_VLD2d16wb_register_VLD2d32wb_fixed_VLD2d32wb_register_VLD2d8wb_fixed_VLD2d8wb_register
  { 1, 331, 334, 4223, 4229 }, // 529 VLD2q16PseudoWB_fixed_VLD2q16PseudoWB_register_VLD2q16wb_fixed_VLD2q16wb_register_VLD2q32PseudoWB_fixed_VLD2q32PseudoWB_register_VLD2q32wb_fixed_VLD2q32wb_register_VLD2q8PseudoWB_fixed_VLD2q8PseudoWB_register_VLD2q8wb_fixed_VLD2q8wb_register
  { 1, 337, 340, 4229, 4233 }, // 530 VLD3d16_VLD3d32_VLD3d8_VLD3q16_VLD3q32_VLD3q8
  { 1, 337, 340, 4233, 4237 }, // 531 VLD3d16Pseudo_VLD3d32Pseudo_VLD3d8Pseudo_VLD3q16oddPseudo_VLD3q32oddPseudo_VLD3q8oddPseudo
  { 1, 337, 340, 4237, 4242 }, // 532 VLD3d16_UPD_VLD3d32_UPD_VLD3d8_UPD_VLD3q16_UPD_VLD3q32_UPD_VLD3q8_UPD
  { 1, 337, 340, 4242, 4247 }, // 533 VLD3d16Pseudo_UPD_VLD3d32Pseudo_UPD_VLD3d8Pseudo_UPD_VLD3q16Pseudo_UPD_VLD3q16oddPseudo_UPD_VLD3q32Pseudo_UPD_VLD3q32oddPseudo_UPD_VLD3q8Pseudo_UPD_VLD3q8oddPseudo_UPD
  { 1, 337, 340, 4247, 4252 }, // 534 VLD4d16_VLD4d32_VLD4d8_VLD4q16_VLD4q32_VLD4q8
  { 1, 337, 340, 4252, 4257 }, // 535 VLD4d16Pseudo_VLD4d32Pseudo_VLD4d8Pseudo_VLD4q16oddPseudo_VLD4q32oddPseudo_VLD4q8oddPseudo
  { 1, 337, 340, 4257, 4263 }, // 536 VLD4d16_UPD_VLD4d32_UPD_VLD4d8_UPD_VLD4q16_UPD_VLD4q32_UPD_VLD4q8_UPD
  { 1, 337, 340, 4263, 4269 }, // 537 VLD4d16Pseudo_UPD_VLD4d32Pseudo_UPD_VLD4d8Pseudo_UPD_VLD4q16Pseudo_UPD_VLD4q16oddPseudo_UPD_VLD4q32Pseudo_UPD_VLD4q32oddPseudo_UPD_VLD4q8Pseudo_UPD_VLD4q8oddPseudo_UPD
  { 1, 322, 325, 4269, 4271 }, // 538 VLD1DUPd16_VLD1DUPd32_VLD1DUPd8_VLD1DUPq16_VLD1DUPq32_VLD1DUPq8
  { 1, 325, 328, 4271, 4275 }, // 539 VLD1LNd16_VLD1LNd32_VLD1LNd8_VLD1LNq16Pseudo_VLD1LNq32Pseudo_VLD1LNq8Pseudo
  { 1, 322, 325, 4275, 4279 }, // 540 VLD1DUPd16wb_fixed_VLD1DUPd16wb_register_VLD1DUPd32wb_fixed_VLD1DUPd32wb_register_VLD1DUPd8wb_fixed_VLD1DUPd8wb_register_VLD1DUPq16wb_fixed_VLD1DUPq16wb_register_VLD1DUPq32wb_fixed_VLD1DUPq32wb_register_VLD1DUPq8wb_fixed_VLD1DUPq8wb_register
  { 1, 325, 328, 4279, 4285 }, // 541 VLD1LNd16_UPD_VLD1LNd32_UPD_VLD1LNd8_UPD_VLD1LNq16Pseudo_UPD_VLD1LNq32Pseudo_UPD_VLD1LNq8Pseudo_UPD
  { 1, 322, 325, 4285, 4288 }, // 542 VLD2DUPd16_VLD2DUPd16x2_VLD2DUPd32_VLD2DUPd32x2_VLD2DUPd8_VLD2DUPd8x2
  { 1, 331, 334, 4288, 4294 }, // 543 VLD2LNd16_VLD2LNd16Pseudo_VLD2LNd32_VLD2LNd32Pseudo_VLD2LNd8_VLD2LNd8Pseudo_VLD2LNq16_VLD2LNq16Pseudo_VLD2LNq32_VLD2LNq32Pseudo
  { 1, 331, 334, 4294, 4302 }, // 544 VLD2LNd16_UPD_VLD2LNd32_UPD_VLD2LNd8_UPD_VLD2LNq16_UPD_VLD2LNq32_UPD
  { 1, 322, 325, 4302, 4307 }, // 545 VLD2DUPd16wb_fixed_VLD2DUPd16wb_register_VLD2DUPd16x2wb_fixed_VLD2DUPd16x2wb_register_VLD2DUPd32wb_fixed_VLD2DUPd32wb_register_VLD2DUPd32x2wb_fixed_VLD2DUPd32x2wb_register_VLD2DUPd8wb_fixed_VLD2DUPd8wb_register_VLD2DUPd8x2wb_fixed_VLD2DUPd8x2wb_register
  { 1, 331, 334, 4307, 4315 }, // 546 VLD2LNd16Pseudo_UPD_VLD2LNd32Pseudo_UPD_VLD2LNd8Pseudo_UPD_VLD2LNq16Pseudo_UPD_VLD2LNq32Pseudo_UPD
  { 1, 325, 328, 4315, 4319 }, // 547 VLD3DUPd16_VLD3DUPd16Pseudo_VLD3DUPd32_VLD3DUPd32Pseudo_VLD3DUPd8_VLD3DUPd8Pseudo_VLD3DUPq16_VLD3DUPq32_VLD3DUPq8
  { 1, 334, 337, 4319, 4327 }, // 548 VLD3LNd16_VLD3LNd16Pseudo_VLD3LNd32_VLD3LNd32Pseudo_VLD3LNd8_VLD3LNd8Pseudo_VLD3LNq16_VLD3LNq16Pseudo_VLD3LNq32_VLD3LNq32Pseudo
  { 1, 325, 328, 4327, 4333 }, // 549 VLD3DUPd16_UPD_VLD3DUPd32_UPD_VLD3DUPd8_UPD_VLD3DUPq16_UPD_VLD3DUPq32_UPD_VLD3DUPq8_UPD
  { 1, 334, 337, 4333, 4343 }, // 550 VLD3LNd16_UPD_VLD3LNd32_UPD_VLD3LNd8_UPD_VLD3LNq16_UPD_VLD3LNq32_UPD
  { 1, 325, 328, 4343, 4349 }, // 551 VLD3DUPd16Pseudo_UPD_VLD3DUPd32Pseudo_UPD_VLD3DUPd8Pseudo_UPD
  { 1, 334, 337, 4349, 4359 }, // 552 VLD3LNd16Pseudo_UPD_VLD3LNd32Pseudo_UPD_VLD3LNd8Pseudo_UPD_VLD3LNq16Pseudo_UPD_VLD3LNq32Pseudo_UPD
  { 1, 325, 328, 4359, 4364 }, // 553 VLD4DUPd16_VLD4DUPd16Pseudo_VLD4DUPd32_VLD4DUPd32Pseudo_VLD4DUPd8_VLD4DUPd8Pseudo_VLD4DUPq16_VLD4DUPq32_VLD4DUPq8
  { 1, 334, 337, 4364, 4374 }, // 554 VLD4LNd16_VLD4LNd16Pseudo_VLD4LNd32_VLD4LNd32Pseudo_VLD4LNd8_VLD4LNd8Pseudo_VLD4LNq16_VLD4LNq16Pseudo_VLD4LNq32_VLD4LNq32Pseudo
  { 1, 325, 328, 4374, 4381 }, // 555 VLD4DUPd16_UPD_VLD4DUPd32_UPD_VLD4DUPd8_UPD_VLD4DUPq16_UPD_VLD4DUPq32_UPD_VLD4DUPq8_UPD
  { 1, 334, 337, 4381, 4393 }, // 556 VLD4LNd16_UPD_VLD4LNd32_UPD_VLD4LNd8_UPD_VLD4LNq16_UPD_VLD4LNq32_UPD
  { 1, 325, 328, 4393, 4400 }, // 557 VLD4DUPd16Pseudo_UPD_VLD4DUPd32Pseudo_UPD_VLD4DUPd8Pseudo_UPD
  { 1, 334, 337, 4400, 4412 }, // 558 VLD4LNd16Pseudo_UPD_VLD4LNd32Pseudo_UPD_VLD4LNd8Pseudo_UPD_VLD4LNq16Pseudo_UPD_VLD4LNq32Pseudo_UPD
  { 1, 328, 331, 4412, 4415 }, // 559 VST1d16_VST1d32_VST1d64_VST1d8
  { 1, 328, 331, 4415, 4419 }, // 560 VST1q16_VST1q32_VST1q64_VST1q8
  { 1, 328, 331, 4419, 4422 }, // 561 VST1d16wb_fixed_VST1d16wb_register_VST1d32wb_fixed_VST1d32wb_register_VST1d64wb_fixed_VST1d64wb_register_VST1d8wb_fixed_VST1d8wb_register
  { 1, 328, 331, 4422, 4426 }, // 562 VST1q16wb_fixed_VST1q16wb_register_VST1q32wb_fixed_VST1q32wb_register_VST1q64wb_fixed_VST1q64wb_register_VST1q8wb_fixed_VST1q8wb_register
  { 1, 331, 334, 4426, 4431 }, // 563 VST1d16T_VST1d32T_VST1d64T_VST1d64TPseudo_VST1d8T
  { 1, 331, 334, 4431, 4436 }, // 564 VST1d16Twb_fixed_VST1d16Twb_register_VST1d32Twb_fixed_VST1d32Twb_register_VST1d64Twb_fixed_VST1d64Twb_register_VST1d8Twb_fixed_VST1d8Twb_register
  { 1, 331, 334, 4436, 4443 }, // 565 VST1d64TPseudoWB_fixed_VST1d64TPseudoWB_register
  { 1, 331, 334, 4443, 4449 }, // 566 VST1d16Q_VST1d32Q_VST1d64Q_VST1d64QPseudo_VST1d8Q
  { 1, 331, 334, 4449, 4455 }, // 567 VST1d16Qwb_fixed_VST1d16Qwb_register_VST1d32Qwb_fixed_VST1d32Qwb_register_VST1d64Qwb_fixed_VST1d64Qwb_register_VST1d8Qwb_fixed_VST1d8Qwb_register
  { 1, 331, 334, 4455, 4463 }, // 568 VST1d64QPseudoWB_fixed_VST1d64QPseudoWB_register
  { 1, 328, 331, 4463, 4467 }, // 569 VST2b16_VST2b32_VST2b8_VST2d16_VST2d32_VST2d8
  { 1, 328, 331, 4467, 4470 }, // 570 VST2b16wb_fixed_VST2b16wb_register_VST2b32wb_fixed_VST2b32wb_register_VST2b8wb_fixed_VST2b8wb_register_VST2d16wb_fixed_VST2d16wb_register_VST2d32wb_fixed_VST2d32wb_register_VST2d8wb_fixed_VST2d8wb_register
  { 1, 337, 340, 4470, 4476 }, // 571 VST2q16_VST2q16Pseudo_VST2q32_VST2q32Pseudo_VST2q8_VST2q8Pseudo
  { 1, 337, 340, 4476, 4484 }, // 572 VST2q16PseudoWB_fixed_VST2q16PseudoWB_register_VST2q32PseudoWB_fixed_VST2q32PseudoWB_register_VST2q8PseudoWB_fixed_VST2q8PseudoWB_register
  { 1, 328, 331, 4484, 4487 }, // 573 VST2q16wb_fixed_VST2q16wb_register_VST2q32wb_fixed_VST2q32wb_register_VST2q8wb_fixed_VST2q8wb_register
  { 1, 331, 334, 4487, 4492 }, // 574 VST3d16_VST3d16Pseudo_VST3d32_VST3d32Pseudo_VST3d8_VST3d8Pseudo_VST3q16_VST3q16oddPseudo_VST3q32_VST3q32oddPseudo_VST3q8_VST3q8oddPseudo
  { 1, 331, 334, 4492, 4499 }, // 575 VST3d16Pseudo_UPD_VST3d16_UPD_VST3d32Pseudo_UPD_VST3d32_UPD_VST3d8Pseudo_UPD_VST3d8_UPD_VST3q16Pseudo_UPD_VST3q16_UPD_VST3q16oddPseudo_UPD_VST3q32Pseudo_UPD_VST3q32_UPD_VST3q32oddPseudo_UPD_VST3q8Pseudo_UPD_VST3q8_UPD_VST3q8oddPseudo_UPD
  { 1, 337, 340, 4499, 4505 }, // 576 VST4d16_VST4d16Pseudo_VST4d32_VST4d32Pseudo_VST4d8_VST4d8Pseudo_VST4q16_VST4q16oddPseudo_VST4q32_VST4q32oddPseudo_VST4q8_VST4q8oddPseudo
  { 1, 337, 340, 4505, 4513 }, // 577 VST4d16Pseudo_UPD_VST4d16_UPD_VST4d32Pseudo_UPD_VST4d32_UPD_VST4d8Pseudo_UPD_VST4d8_UPD_VST4q16Pseudo_UPD_VST4q16_UPD_VST4q16oddPseudo_UPD_VST4q32Pseudo_UPD_VST4q32_UPD_VST4q32oddPseudo_UPD_VST4q8Pseudo_UPD_VST4q8_UPD_VST4q8oddPseudo_UPD
  { 1, 322, 325, 4513, 4516 }, // 578 VST1LNd16_VST1LNd32_VST1LNd8_VST1LNq16Pseudo_VST1LNq32Pseudo_VST1LNq8Pseudo
  { 1, 322, 325, 4516, 4521 }, // 579 VST1LNd16_UPD_VST1LNd32_UPD_VST1LNd8_UPD_VST1LNq16Pseudo_UPD_VST1LNq32Pseudo_UPD_VST1LNq8Pseudo_UPD
  { 1, 328, 331, 4521, 4525 }, // 580 VST2LNd16_VST2LNd16Pseudo_VST2LNd32_VST2LNd32Pseudo_VST2LNd8_VST2LNd8Pseudo_VST2LNq16_VST2LNq16Pseudo_VST2LNq32_VST2LNq32Pseudo
  { 1, 328, 331, 4525, 4531 }, // 581 VST2LNd16Pseudo_UPD_VST2LNd16_UPD_VST2LNd32Pseudo_UPD_VST2LNd32_UPD_VST2LNd8Pseudo_UPD_VST2LNd8_UPD_VST2LNq16Pseudo_UPD_VST2LNq16_UPD_VST2LNq32Pseudo_UPD_VST2LNq32_UPD
  { 1, 331, 334, 4531, 4536 }, // 582 VST3LNd16_VST3LNd16Pseudo_VST3LNd32_VST3LNd32Pseudo_VST3LNd8_VST3LNd8Pseudo_VST3LNq16_VST3LNq16Pseudo_VST3LNq32_VST3LNq32Pseudo
  { 1, 331, 334, 4536, 4543 }, // 583 VST3LNd16Pseudo_UPD_VST3LNd16_UPD_VST3LNd32Pseudo_UPD_VST3LNd32_UPD_VST3LNd8Pseudo_UPD_VST3LNd8_UPD_VST3LNq16Pseudo_UPD_VST3LNq16_UPD_VST3LNq32Pseudo_UPD_VST3LNq32_UPD
  { 1, 337, 340, 4543, 4549 }, // 584 VST4LNd16_VST4LNd16Pseudo_VST4LNd32_VST4LNd32Pseudo_VST4LNd8_VST4LNd8Pseudo_VST4LNq16_VST4LNq16Pseudo_VST4LNq32_VST4LNq32Pseudo
  { 1, 337, 340, 4549, 4557 }, // 585 VST4LNd16Pseudo_UPD_VST4LNd16_UPD_VST4LNd32Pseudo_UPD_VST4LNd32_UPD_VST4LNd8Pseudo_UPD_VST4LNd8_UPD_VST4LNq16Pseudo_UPD_VST4LNq16_UPD_VST4LNq32Pseudo_UPD_VST4LNq32_UPD
  { 1, 314, 317, 4557, 4560 }, // 586 VDIVS
  { 1, 319, 322, 4560, 4562 }, // 587 VSQRTS
  { 1, 311, 314, 4562, 4565 }, // 588 VDIVD
  { 1, 311, 314, 4565, 4567 }, // 589 VSQRTD
  { 0, 0, 0, 0, 0 }, // 590 ABS
  { 0, ~0U, ~0U, ~0U, ~0U } // end marker
};

static const llvm::InstrItinerary SwiftItineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 1, 362, 364, 4567, 4569 }, // 1 IIC_iALUi_WriteALU_ReadALU
  { 1, 362, 364, 4569, 4572 }, // 2 IIC_iALUr_WriteALU_ReadALU_ReadALU
  { 1, 362, 364, 4572, 4576 }, // 3 IIC_iALUsr_WriteALUsi_ReadALU
  { 1, 362, 364, 4576, 4580 }, // 4 IIC_iALUsr_WriteALUsr_ReadALUsr
  { 1, 362, 364, 4580, 4584 }, // 5 IIC_iALUsr_WriteALUSsr_ReadALUsr
  { 1, 362, 364, 4584, 4586 }, // 6 IIC_iBITi_WriteALU_ReadALU
  { 1, 362, 364, 4586, 4589 }, // 7 IIC_iBITr_WriteALU_ReadALU_ReadALU
  { 1, 362, 364, 4589, 4593 }, // 8 IIC_iBITsr_WriteALUsi_ReadALU
  { 1, 362, 364, 4593, 4597 }, // 9 IIC_iBITsr_WriteALUsr_ReadALUsr
  { 1, 364, 365, 0, 0 }, // 10 IIC_Br_WriteBr
  { 1, 362, 364, 4597, 4599 }, // 11 IIC_iUNAsi
  { 1, 364, 365, 0, 0 }, // 12 IIC_Br_WriteBrL
  { 0, 0, 0, 0, 0 }, // 13 WriteBrL
  { 1, 364, 365, 0, 0 }, // 14 IIC_Br_WriteBrTbl
  { 0, 0, 0, 0, 0 }, // 15 WriteBr
  { 1, 362, 364, 4599, 4601 }, // 16 IIC_iUNAr_WriteALU
  { 1, 362, 364, 4601, 4602 }, // 17 IIC_iCMPi_WriteCMP_ReadALU
  { 1, 362, 364, 4602, 4604 }, // 18 IIC_iCMPr_WriteCMP_ReadALU_ReadALU
  { 1, 365, 367, 4604, 4607 }, // 19 IIC_iCMPsr_WriteCMPsi_ReadALU
  { 1, 365, 367, 4607, 4610 }, // 20 IIC_iCMPsr_WriteCMPsr_ReadALU
  { 1, 367, 369, 4610, 4612 }, // 21 IIC_fpUNA64
  { 1, 367, 369, 4612, 4614 }, // 22 IIC_fpUNA32
  { 1, 362, 364, 4614, 4615 }, // 23 IIC_fpSTAT
  { -1, 369, 374, 4615, 4620 }, // 24 IIC_iLoad_m
  { -1, 374, 380, 4620, 4625 }, // 25 IIC_iLoad_mu
  { -1, 369, 374, 4625, 4630 }, // 26 IIC_iLoad_mBr
  { 1, 380, 384, 4630, 4634 }, // 27 IIC_iLoad_bh_ru
  { 1, 384, 388, 4634, 4637 }, // 28 IIC_iLoad_bh_iu
  { 1, 388, 390, 4637, 4640 }, // 29 IIC_iLoad_bh_r
  { 1, 390, 394, 4640, 4643 }, // 30 IIC_iLoad_bh_si
  { 1, 394, 400, 4643, 4647 }, // 31 IIC_iLoad_d_r
  { 1, 400, 407, 4647, 4651 }, // 32 IIC_iLoad_d_ru
  { 1, 388, 390, 4651, 4653 }, // 33 IIC_iLoad_i
  { 1, 407, 410, 4653, 4655 }, // 34 IIC_iLoadiALU
  { 1, 380, 384, 4655, 4659 }, // 35 IIC_iLoad_ru
  { 1, 384, 388, 4659, 4662 }, // 36 IIC_iLoad_iu
  { 1, 388, 390, 4662, 4665 }, // 37 IIC_iLoad_r
  { 1, 390, 394, 4665, 4668 }, // 38 IIC_iLoad_si
  { 1, 367, 369, 4668, 4672 }, // 39 IIC_iMAC32
  { 1, 362, 364, 4672, 4673 }, // 40 IIC_iCMOVi_WriteALU
  { 1, 362, 364, 4673, 4674 }, // 41 IIC_iMOVi_WriteALU
  { 1, 410, 414, 4674, 4675 }, // 42 IIC_iCMOVix2
  { 1, 362, 364, 4675, 4677 }, // 43 IIC_iCMOVr_WriteALU
  { 1, 362, 364, 4677, 4680 }, // 44 IIC_iCMOVsr_WriteALU
  { 1, 414, 418, 4680, 4681 }, // 45 IIC_iMOVix2addpc
  { 1, 418, 422, 4681, 4682 }, // 46 IIC_iMOVix2ld
  { 1, 410, 414, 4682, 4683 }, // 47 IIC_iMOVix2
  { 1, 362, 364, 4683, 4684 }, // 48 IIC_iMOVr_WriteALU
  { 1, 362, 364, 4684, 4685 }, // 49 IIC_iMOVsr_WriteALU
  { 1, 362, 364, 4685, 4686 }, // 50 IIC_iMOVsi_WriteALU
  { 1, 367, 369, 4686, 4689 }, // 51 IIC_iMUL32
  { 1, 362, 364, 4689, 4690 }, // 52 IIC_iMVNi_WriteALU
  { 1, 362, 364, 4690, 4691 }, // 53 IIC_iMVNr_WriteALU
  { 1, 362, 364, 4691, 4692 }, // 54 IIC_iMVNsr_WriteALU
  { 1, 362, 364, 4692, 4695 }, // 55 IIC_iALUr_WriteALU_ReadALU
  { 1, 388, 390, 4695, 4698 }, // 56 IIC_iStore_r
  { 1, 388, 390, 4698, 4701 }, // 57 IIC_iStore_bh_r
  { 1, 362, 364, 4701, 4704 }, // 58 IIC_iALUsi_WriteALUsi_ReadALU
  { 1, 362, 364, 4704, 4707 }, // 59 IIC_iBITsi_WriteALUsi_ReadALU
  { 1, 364, 365, 4707, 4709 }, // 60 IIC_Preload_WritePreLd
  { 1, 422, 425, 4709, 4712 }, // 61 IIC_iDIV
  { 1, 367, 369, 4712, 4716 }, // 62 IIC_iMAC16
  { 1, 425, 432, 4716, 4720 }, // 63 IIC_iMAC64
  { 1, 367, 369, 4720, 4723 }, // 64 IIC_iMUL16
  { 1, 432, 438, 4723, 4727 }, // 65 IIC_iMUL64
  { -1, 438, 447, 0, 0 }, // 66 IIC_iStore_m
  { -1, 438, 447, 4727, 4728 }, // 67 IIC_iStore_mu
  { 1, 384, 388, 4728, 4732 }, // 68 IIC_iStore_bh_ru
  { 1, 384, 388, 4732, 4735 }, // 69 IIC_iStore_bh_iu
  { 1, 384, 388, 4735, 4739 }, // 70 IIC_iStore_ru
  { 1, 390, 394, 4739, 4742 }, // 71 IIC_iStore_bh_si
  { 1, 447, 453, 4742, 4745 }, // 72 IIC_iStore_d_r
  { 1, 384, 388, 4745, 4749 }, // 73 IIC_iStore_d_ru
  { 1, 384, 388, 4749, 4752 }, // 74 IIC_iStore_iu
  { 1, 390, 394, 4752, 4755 }, // 75 IIC_iStore_si
  { 1, 364, 365, 0, 0 }, // 76 IIC_Br
  { 1, 362, 364, 4755, 4758 }, // 77 IIC_iEXTAr_WriteALUsr
  { 1, 362, 364, 4758, 4760 }, // 78 IIC_iEXTr_WriteALUsi
  { 1, 362, 364, 4760, 4761 }, // 79 IIC_iTSTi_WriteCMP_ReadALU
  { 1, 362, 364, 4761, 4763 }, // 80 IIC_iTSTr_WriteCMP_ReadALU_ReadALU
  { 1, 365, 367, 4763, 4766 }, // 81 IIC_iTSTsr_WriteCMPsi_ReadALU
  { 1, 365, 367, 4766, 4769 }, // 82 IIC_iTSTsr_WriteCMPsr_ReadALU
  { 0, 0, 0, 0, 0 }, // 83 WriteALU_ReadALU_ReadALU
  { 1, 367, 369, 4769, 4773 }, // 84 IIC_VABAD
  { 1, 367, 369, 4773, 4777 }, // 85 IIC_VABAQ
  { 1, 367, 369, 4777, 4780 }, // 86 IIC_VSUBi4Q
  { 1, 367, 369, 4780, 4783 }, // 87 IIC_VBIND
  { 1, 367, 369, 4783, 4786 }, // 88 IIC_VBINQ
  { 1, 367, 369, 4786, 4789 }, // 89 IIC_VSUBi4D
  { 1, 367, 369, 4789, 4791 }, // 90 IIC_VUNAD
  { 1, 367, 369, 4791, 4793 }, // 91 IIC_VUNAQ
  { 1, 367, 369, 4793, 4795 }, // 92 IIC_VUNAiQ
  { 1, 367, 369, 4795, 4797 }, // 93 IIC_VUNAiD
  { 1, 367, 369, 4797, 4800 }, // 94 IIC_fpALU64
  { 1, 367, 369, 4800, 4803 }, // 95 IIC_VBINi4D
  { 1, 367, 369, 4803, 4806 }, // 96 IIC_VSHLiD
  { 1, 367, 369, 4806, 4809 }, // 97 IIC_fpALU32
  { 1, 367, 369, 4809, 4812 }, // 98 IIC_VSUBiD
  { 1, 367, 369, 4812, 4815 }, // 99 IIC_VBINiQ
  { 1, 367, 369, 4815, 4818 }, // 100 IIC_VBINiD
  { 1, 367, 369, 4818, 4819 }, // 101 IIC_VMOVImm
  { 1, 367, 369, 4819, 4822 }, // 102 IIC_VCNTiD
  { 1, 367, 369, 4822, 4825 }, // 103 IIC_VCNTiQ
  { 1, 367, 369, 4825, 4827 }, // 104 IIC_fpCMP64
  { 1, 367, 369, 4827, 4829 }, // 105 IIC_fpCMP32
  { 1, 453, 457, 4829, 4831 }, // 106 IIC_fpCVTSH
  { 1, 457, 459, 4831, 4833 }, // 107 IIC_fpCVTHS
  { 1, 457, 459, 4833, 4835 }, // 108 IIC_fpCVTDS
  { 1, 457, 459, 4835, 4837 }, // 109 IIC_fpCVTSD
  { 1, 459, 462, 4837, 4840 }, // 110 IIC_fpDIV64
  { 1, 462, 465, 4840, 4843 }, // 111 IIC_fpDIV32
  { 1, 465, 469, 4843, 4845 }, // 112 IIC_VMOVIS
  { 1, 457, 459, 4845, 4847 }, // 113 IIC_VMOVD
  { 1, 457, 459, 4847, 4849 }, // 114 IIC_VMOVQ
  { 1, 457, 459, 4849, 4852 }, // 115 IIC_VEXTD
  { 1, 457, 459, 4852, 4855 }, // 116 IIC_VEXTQ
  { 1, 457, 459, 4855, 4858 }, // 117 IIC_fpFMAC64
  { 1, 457, 459, 4858, 4861 }, // 118 IIC_fpFMAC32
  { 1, 457, 459, 4861, 4864 }, // 119 IIC_VFMACD
  { 1, 457, 459, 4864, 4867 }, // 120 IIC_VFMACQ
  { 1, 388, 390, 4867, 4869 }, // 121 IIC_VMOVSI
  { 1, 367, 369, 4869, 4872 }, // 122 IIC_VBINi4Q
  { 0, 0, 0, 0, 0 }, // 123 IIC_VLD1dup
  { 0, 0, 0, 0, 0 }, // 124 IIC_VLD1dupu
  { 0, 0, 0, 0, 0 }, // 125 IIC_VLD1ln
  { 0, 0, 0, 0, 0 }, // 126 IIC_VLD1lnu
  { 0, 0, 0, 0, 0 }, // 127 IIC_VLD1
  { 0, 0, 0, 0, 0 }, // 128 IIC_VLD1x4
  { 0, 0, 0, 0, 0 }, // 129 IIC_VLD1x2u
  { 0, 0, 0, 0, 0 }, // 130 IIC_VLD1x3
  { 0, 0, 0, 0, 0 }, // 131 IIC_VLD1u
  { 0, 0, 0, 0, 0 }, // 132 IIC_VLD1x2
  { 0, 0, 0, 0, 0 }, // 133 IIC_VLD2dup
  { 0, 0, 0, 0, 0 }, // 134 IIC_VLD2dupu
  { 0, 0, 0, 0, 0 }, // 135 IIC_VLD2ln
  { 0, 0, 0, 0, 0 }, // 136 IIC_VLD2lnu
  { 0, 0, 0, 0, 0 }, // 137 IIC_VLD2
  { 0, 0, 0, 0, 0 }, // 138 IIC_VLD2u
  { 0, 0, 0, 0, 0 }, // 139 IIC_VLD2x2
  { 0, 0, 0, 0, 0 }, // 140 IIC_VLD2x2u
  { 0, 0, 0, 0, 0 }, // 141 IIC_VLD3dup
  { 0, 0, 0, 0, 0 }, // 142 IIC_VLD3dupu
  { 0, 0, 0, 0, 0 }, // 143 IIC_VLD3ln
  { 0, 0, 0, 0, 0 }, // 144 IIC_VLD3lnu
  { 0, 0, 0, 0, 0 }, // 145 IIC_VLD3
  { 0, 0, 0, 0, 0 }, // 146 IIC_VLD3u
  { 0, 0, 0, 0, 0 }, // 147 IIC_VLD4dup
  { 0, 0, 0, 0, 0 }, // 148 IIC_VLD4dupu
  { 0, 0, 0, 0, 0 }, // 149 IIC_VLD4ln
  { 0, 0, 0, 0, 0 }, // 150 IIC_VLD4lnu
  { 0, 0, 0, 0, 0 }, // 151 IIC_VLD4
  { 0, 0, 0, 0, 0 }, // 152 IIC_VLD4u
  { -1, 469, 473, 4872, 4877 }, // 153 IIC_fpLoad_mu
  { -1, 388, 390, 4877, 4881 }, // 154 IIC_fpLoad_m
  { 1, 388, 390, 4881, 4883 }, // 155 IIC_fpLoad64
  { 1, 388, 390, 4883, 4885 }, // 156 IIC_fpLoad32
  { 1, 457, 459, 4885, 4888 }, // 157 IIC_fpMAC64
  { 1, 457, 459, 4888, 4892 }, // 158 IIC_VMACi32D
  { 1, 457, 459, 4892, 4896 }, // 159 IIC_VMACi16D
  { 1, 457, 459, 4896, 4899 }, // 160 IIC_fpMAC32
  { 1, 457, 459, 4899, 4902 }, // 161 IIC_VMACD
  { 1, 457, 459, 4902, 4905 }, // 162 IIC_VMACQ
  { 1, 457, 459, 4905, 4909 }, // 163 IIC_VMACi32Q
  { 1, 457, 459, 4909, 4913 }, // 164 IIC_VMACi16Q
  { 1, 388, 390, 4913, 4915 }, // 165 IIC_fpMOVID
  { 1, 367, 369, 4915, 4917 }, // 166 IIC_VQUNAiD
  { 1, 457, 459, 4917, 4919 }, // 167 IIC_VMOVN
  { 1, 473, 477, 4919, 4922 }, // 168 IIC_fpMOVDI
  { 1, 388, 390, 4922, 4924 }, // 169 IIC_fpMOVSI
  { 1, 465, 469, 4924, 4926 }, // 170 IIC_fpMOVIS
  { 1, 457, 459, 4926, 4929 }, // 171 IIC_fpMUL64
  { 1, 457, 459, 4929, 4932 }, // 172 IIC_VMULi16D
  { 1, 457, 459, 4932, 4935 }, // 173 IIC_VMULi32D
  { 1, 457, 459, 4935, 4938 }, // 174 IIC_fpMUL32
  { 1, 457, 459, 4938, 4941 }, // 175 IIC_VFMULD
  { 1, 457, 459, 4941, 4944 }, // 176 IIC_VFMULQ
  { 1, 457, 459, 4944, 4947 }, // 177 IIC_VMULi16Q
  { 1, 457, 459, 4947, 4950 }, // 178 IIC_VMULi32Q
  { 1, 367, 369, 4950, 4953 }, // 179 IIC_VSHLiQ
  { 1, 367, 369, 4953, 4956 }, // 180 IIC_VPALiQ
  { 1, 367, 369, 4956, 4959 }, // 181 IIC_VPALiD
  { 1, 367, 369, 4959, 4962 }, // 182 IIC_VPBIND
  { 1, 367, 369, 4962, 4964 }, // 183 IIC_VQUNAiQ
  { 1, 367, 369, 4964, 4967 }, // 184 IIC_VSHLi4Q
  { 1, 367, 369, 4967, 4970 }, // 185 IIC_VSHLi4D
  { 1, 457, 459, 4970, 4973 }, // 186 IIC_VRECSD
  { 1, 457, 459, 4973, 4976 }, // 187 IIC_VRECSQ
  { 1, 465, 469, 4976, 4978 }, // 188 IIC_VMOVISL
  { 1, 457, 459, 4978, 4980 }, // 189 IIC_fpCVTID_WriteCvtFP
  { 1, 457, 459, 4980, 4982 }, // 190 IIC_fpCVTIS_WriteCvtFP
  { 1, 457, 459, 4982, 4984 }, // 191 IIC_fpCVTID
  { 1, 457, 459, 4984, 4986 }, // 192 IIC_fpCVTIS
  { 1, 459, 462, 4986, 4989 }, // 193 IIC_fpSQRT64
  { 1, 462, 465, 4989, 4991 }, // 194 IIC_fpSQRT32
  { 0, 0, 0, 0, 0 }, // 195 IIC_VST1ln
  { 0, 0, 0, 0, 0 }, // 196 IIC_VST1lnu
  { 0, 0, 0, 0, 0 }, // 197 IIC_VST1
  { 0, 0, 0, 0, 0 }, // 198 IIC_VST1x4
  { 0, 0, 0, 0, 0 }, // 199 IIC_VLD1x4u
  { 0, 0, 0, 0, 0 }, // 200 IIC_VST1x3
  { 0, 0, 0, 0, 0 }, // 201 IIC_VLD1x3u
  { 0, 0, 0, 0, 0 }, // 202 IIC_VST1x4u
  { 0, 0, 0, 0, 0 }, // 203 IIC_VST1x3u
  { 0, 0, 0, 0, 0 }, // 204 IIC_VST1x2
  { 0, 0, 0, 0, 0 }, // 205 IIC_VST2ln
  { 0, 0, 0, 0, 0 }, // 206 IIC_VST2lnu
  { 0, 0, 0, 0, 0 }, // 207 IIC_VST2
  { 0, 0, 0, 0, 0 }, // 208 IIC_VST2x2
  { 0, 0, 0, 0, 0 }, // 209 IIC_VST2x2u
  { 0, 0, 0, 0, 0 }, // 210 IIC_VST3ln
  { 0, 0, 0, 0, 0 }, // 211 IIC_VST3lnu
  { 0, 0, 0, 0, 0 }, // 212 IIC_VST3
  { 0, 0, 0, 0, 0 }, // 213 IIC_VST3u
  { 0, 0, 0, 0, 0 }, // 214 IIC_VST4ln
  { 0, 0, 0, 0, 0 }, // 215 IIC_VST4lnu
  { 0, 0, 0, 0, 0 }, // 216 IIC_VST4
  { 0, 0, 0, 0, 0 }, // 217 IIC_VST4u
  { -1, 469, 473, 4991, 4995 }, // 218 IIC_fpStore_mu
  { -1, 388, 390, 4995, 4998 }, // 219 IIC_fpStore_m
  { 1, 388, 390, 4998, 5000 }, // 220 IIC_fpStore64
  { 1, 388, 390, 5000, 5002 }, // 221 IIC_fpStore32
  { 1, 367, 369, 5002, 5005 }, // 222 IIC_VSUBiQ
  { 1, 457, 459, 5005, 5008 }, // 223 IIC_VTB1
  { 1, 477, 481, 5008, 5012 }, // 224 IIC_VTB2
  { 1, 481, 487, 5012, 5017 }, // 225 IIC_VTB3
  { 1, 487, 494, 5017, 5023 }, // 226 IIC_VTB4
  { 1, 457, 459, 5023, 5026 }, // 227 IIC_VTBX1
  { 1, 477, 481, 5026, 5030 }, // 228 IIC_VTBX2
  { 1, 481, 487, 5030, 5035 }, // 229 IIC_VTBX3
  { 1, 487, 494, 5035, 5041 }, // 230 IIC_VTBX4
  { 1, 457, 459, 5041, 5043 }, // 231 IIC_fpCVTDI_WriteCvtFP
  { 1, 457, 459, 5043, 5045 }, // 232 IIC_fpCVTSI_WriteCvtFP
  { 1, 457, 459, 5045, 5047 }, // 233 IIC_fpCVTDI
  { 1, 457, 459, 5047, 5049 }, // 234 IIC_fpCVTSI
  { 1, 481, 487, 5049, 5053 }, // 235 IIC_VPERMD
  { 1, 481, 487, 5053, 5057 }, // 236 IIC_VPERMQ
  { 1, 481, 487, 5057, 5061 }, // 237 IIC_VPERMQ3
  { 1, 362, 364, 5061, 5064 }, // 238 IIC_iALUsi_WriteALUsi_ReadALUsr
  { 1, 362, 364, 5064, 5066 }, // 239 IIC_iBITi
  { 1, 365, 367, 5066, 5068 }, // 240 IIC_iCMPsi_WriteCMPsi_ReadALU_ReadALU
  { 1, 362, 364, 5068, 5069 }, // 241 IIC_iCMPi_WriteCMP
  { 1, 362, 364, 5069, 5071 }, // 242 IIC_iCMPr_WriteCMP
  { 1, 365, 367, 5071, 5073 }, // 243 IIC_iCMPsi_WriteCMPsi
  { 1, 362, 364, 0, 0 }, // 244 IIC_iALUx
  { 1, 388, 390, 5073, 5075 }, // 245 IIC_iLoad_bh_i
  { 1, 494, 498, 5075, 5078 }, // 246 IIC_iLoad_d_i
  { 1, 362, 364, 5078, 5080 }, // 247 IIC_iCMOVsi_WriteALU
  { 1, 362, 364, 5080, 5081 }, // 248 IIC_iMOVi
  { 1, 362, 364, 5081, 5082 }, // 249 IIC_iMVNsi_WriteALU
  { 1, 362, 364, 5082, 5085 }, // 250 IIC_iALUsir_WriteALUsi_ReadALU
  { 1, 388, 390, 5085, 5087 }, // 251 IIC_iStore_bh_i
  { 1, 388, 390, 5087, 5089 }, // 252 IIC_iStore_i
  { 1, 362, 364, 5089, 5093 }, // 253 IIC_iEXTAsr
  { 1, 362, 364, 5093, 5095 }, // 254 IIC_iEXTr
  { 1, 362, 364, 5095, 5096 }, // 255 IIC_iTSTi_WriteCMP
  { 1, 362, 364, 5096, 5098 }, // 256 IIC_iTSTr_WriteCMP
  { 1, 365, 367, 5098, 5100 }, // 257 IIC_iTSTsi_WriteCMPsi
  { 1, 362, 364, 5100, 5103 }, // 258 IIC_iALUr_WriteALU
  { 1, 362, 364, 5103, 5105 }, // 259 IIC_iALUi_WriteALU
  { 1, 362, 364, 5105, 5108 }, // 260 IIC_iBITr_WriteALU
  { -1, 384, 388, 5108, 5111 }, // 261 IIC_iPop
  { -1, 384, 388, 5111, 5114 }, // 262 IIC_iPop_Br_WriteBrL
  { 1, 362, 364, 5114, 5116 }, // 263 IIC_iTSTr_WriteALU
  { 1, 362, 364, 5116, 5118 }, // 264 ANDri_BICri_EORri_ORRri
  { 1, 362, 364, 5118, 5121 }, // 265 ANDrr_BICrr_EORrr_ORRrr
  { 1, 362, 364, 5121, 5125 }, // 266 ANDrsi_BICrsi_EORrsi_ORRrsi
  { 1, 362, 364, 5125, 5129 }, // 267 ANDrsr_BICrsr_EORrsr_ORRrsr
  { 1, 362, 364, 5129, 5132 }, // 268 MOVCCsi_MOVCCsr
  { 1, 362, 364, 5132, 5133 }, // 269 MOVsi_MOVsr
  { 1, 362, 364, 5133, 5134 }, // 270 MOVsra_flag_MOVsrl_flag
  { 1, 362, 364, 5134, 5135 }, // 271 MVNsr
  { 1, 362, 364, 5135, 5136 }, // 272 MVNr
  { 1, 410, 414, 5136, 5137 }, // 273 MOVCCi32imm
  { 1, 410, 414, 5137, 5138 }, // 274 MOVi32imm
  { 1, 414, 418, 5138, 5139 }, // 275 MOV_ga_pcrel
  { 1, 418, 422, 5139, 5140 }, // 276 MOV_ga_pcrel_ldr
  { 0, 0, 0, 0, 0 }, // 277 SEL
  { 1, 362, 364, 5140, 5142 }, // 278 BFC_BFI_SBFX_UBFX
  { 1, 367, 369, 5142, 5146 }, // 279 MLA_MLAv5_MLS_SMMLA_SMMLAR_SMMLS_SMMLSR
  { 1, 367, 369, 5146, 5149 }, // 280 MUL_MULv5_SMMUL_SMMULR
  { 1, 425, 432, 5149, 5153 }, // 281 SMLAL_SMLALBB_SMLALBT_SMLALTB_SMLALTT_SMLALv5_UMAAL_UMLAL_UMLALv5
  { 1, 432, 438, 5153, 5157 }, // 282 SMULL_SMULLv5_UMULL_UMULLv5
  { 0, 0, 0, 0, 0 }, // 283 SMLAD_SMLADX_SMLALD_SMLALDX_SMLSD_SMLSDX_SMLSLD_SMLSLDX_SMUAD_SMUADX_SMUSD_SMUSDX
  { 1, 367, 369, 5157, 5160 }, // 284 SMULBB_SMULBT_SMULTB_SMULTT_SMULWB_SMULWT
  { 1, 367, 369, 5160, 5164 }, // 285 SMLABB_SMLABT_SMLATB_SMLATT_SMLAWB_SMLAWT
  { 1, 388, 390, 5164, 5167 }, // 286 LDRi12_PICLDR
  { 1, 390, 394, 5167, 5170 }, // 287 LDRrs
  { 1, 388, 390, 5170, 5173 }, // 288 LDRBi12_LDRH_LDRSB_LDRSH_PICLDRB_PICLDRH_PICLDRSB_PICLDRSH
  { 1, 380, 384, 5173, 5177 }, // 289 LDRHTi_LDRHTr_LDRH_POST_LDRH_PRE_LDRSBTi_LDRSBTr_LDRSB_POST_LDRSB_PRE_LDRSHTi_LDRSHTr_LDRSH_POST_LDRSH_PRE
  { 1, 362, 364, 5177, 5179 }, // 290 SXTB_SXTB16_SXTH_UXTB_UXTB16_UXTH
  { 1, 362, 364, 5179, 5181 }, // 291 t2SXTB_t2SXTB16_t2SXTH_t2UXTB_t2UXTB16_t2UXTH
  { 1, 410, 414, 5181, 5182 }, // 292 t2MOVCCi32imm
  { 1, 410, 414, 5182, 5183 }, // 293 t2MOVi32imm
  { 1, 414, 418, 5183, 5184 }, // 294 t2MOV_ga_pcrel
  { 1, 362, 364, 5184, 5185 }, // 295 t2MOVi16_ga_pcrel
  { 0, 0, 0, 0, 0 }, // 296 t2SEL
  { 1, 362, 364, 5185, 5187 }, // 297 t2BFC_t2SBFX_t2UBFX
  { 1, 362, 364, 5187, 5189 }, // 298 t2BFI
  { 1, 362, 364, 5189, 5192 }, // 299 QADD_QADD16_QADD8_QASX_QDADD_QDSUB_QSAX_QSUB_QSUB16_QSUB8_UQADD16_UQADD8_UQASX_UQSAX_UQSUB16_UQSUB8
  { 0, 0, 0, 0, 0 }, // 300 SSAT_SSAT16_USAT_USAT16_t2QADD_t2QADD16_t2QADD8_t2QASX_t2QDADD_t2QDSUB_t2QSAX_t2QSUB_t2QSUB16_t2QSUB8_t2SSAT_t2SSAT16_t2UQADD16_t2UQADD8_t2UQASX_t2UQSAX_t2UQSUB16_t2UQSUB8_t2USAT_t2USAT16
  { 1, 362, 364, 5192, 5195 }, // 301 SADD16_SADD8_SASX_SSAX_SSUB16_SSUB8_UADD16_UADD8_UASX_USAX_USUB16_USUB8
  { 0, 0, 0, 0, 0 }, // 302 t2SADD16_t2SADD8_t2SASX_t2SSAX_t2SSUB16_t2SSUB8_t2UADD16_t2UADD8_t2UASX_t2USAX_t2USUB16_t2USUB8
  { 1, 362, 364, 5195, 5198 }, // 303 SHADD16_SHADD8_SHASX_SHSAX_SHSUB16_SHSUB8_UHADD16_UHADD8_UHASX_UHSAX_UHSUB16_UHSUB8
  { 1, 362, 364, 5198, 5201 }, // 304 SXTAB_SXTAB16_SXTAH_UXTAB_UXTAB16_UXTAH
  { 0, 0, 0, 0, 0 }, // 305 t2SHADD16_t2SHADD8_t2SHASX_t2SHSAX_t2SHSUB16_t2SHSUB8_t2UHADD16_t2UHADD8_t2UHASX_t2UHSAX_t2UHSUB16_t2UHSUB8
  { 1, 362, 364, 5201, 5205 }, // 306 t2SXTAB_t2SXTAB16_t2SXTAH_t2UXTAB_t2UXTAB16_t2UXTAH
  { 0, 0, 0, 0, 0 }, // 307 USAD8
  { 0, 0, 0, 0, 0 }, // 308 USADA8
  { 0, 0, 0, 0, 0 }, // 309 SMUSD_SMUSDX
  { 1, 367, 369, 5205, 5208 }, // 310 t2MUL_t2SMMUL_t2SMMULR
  { 1, 367, 369, 5208, 5211 }, // 311 t2SMULBB_t2SMULBT_t2SMULTB_t2SMULTT_t2SMULWB_t2SMULWT
  { 1, 367, 369, 5211, 5215 }, // 312 t2SMUSD_t2SMUSDX
  { 1, 367, 369, 5215, 5219 }, // 313 t2MLA_t2MLS_t2SMMLA_t2SMMLAR_t2SMMLS_t2SMMLSR
  { 0, 0, 0, 0, 0 }, // 314 SMUAD_SMUADX
  { 1, 367, 369, 5219, 5223 }, // 315 t2SMUAD_t2SMUADX
  { 0, 0, 0, 0, 0 }, // 316 SMLSD_SMLSDX
  { 1, 367, 369, 5223, 5227 }, // 317 t2SMLABB_t2SMLABT_t2SMLATB_t2SMLATT_t2SMLAWB_t2SMLAWT
  { 1, 367, 369, 5227, 5231 }, // 318 t2SMLSD_t2SMLSDX
  { 0, 0, 0, 0, 0 }, // 319 SMLAD_SMLADX
  { 1, 367, 369, 5231, 5235 }, // 320 t2SMLAD_t2SMLADX
  { 1, 432, 438, 5235, 5239 }, // 321 SMULL_UMULL
  { 1, 432, 438, 5239, 5243 }, // 322 t2SMULL_t2UMULL
  { 1, 425, 432, 5243, 5247 }, // 323 t2SMLAL_t2SMLALBB_t2SMLALBT_t2SMLALD_t2SMLALDX_t2SMLALTB_t2SMLALTT_t2SMLSLD_t2SMLSLDX_t2UMAAL_t2UMLAL
  { 1, 422, 425, 5247, 5250 }, // 324 SDIV_UDIV_t2SDIV_t2UDIV
  { 1, 388, 390, 5250, 5253 }, // 325 LDRBi12
  { 1, 390, 394, 5253, 5256 }, // 326 LDRBrs_t2LDRBs_t2LDRHs
  { 0, 0, 0, 0, 0 }, // 327 LDREX_LDREXB_LDREXD_LDREXH_tLDRpci_pic
  { 1, 388, 390, 5256, 5259 }, // 328 LDRi12
  { 1, 388, 390, 5259, 5261 }, // 329 t2LDRBi12_t2LDRBi8_t2LDRBpci_t2LDRHi12_t2LDRHi8_t2LDRHpci_tLDRBi_tLDRHi
  { 1, 388, 390, 5261, 5263 }, // 330 t2LDRi12_t2LDRi8_t2LDRpci_tLDRi_tLDRpci_tLDRspi
  { 1, 407, 410, 5263, 5265 }, // 331 t2LDRpci_pic
  { 1, 390, 394, 5265, 5268 }, // 332 t2LDRs
  { 1, 388, 390, 5268, 5271 }, // 333 tLDRBr_tLDRHr
  { 1, 388, 390, 5271, 5274 }, // 334 tLDRr
  { 1, 388, 390, 5274, 5277 }, // 335 LDRH_PICLDRB_PICLDRH
  { 1, 388, 390, 5277, 5280 }, // 336 LDRcp
  { 1, 388, 390, 5280, 5282 }, // 337 t2LDRSBi12_t2LDRSBi8_t2LDRSBpci_t2LDRSHi12_t2LDRSHi8_t2LDRSHpci
  { 0, 0, 0, 0, 0 }, // 338 t2LDRSBpcrel_t2LDRSHpcrel
  { 1, 390, 394, 5282, 5285 }, // 339 t2LDRSBs_t2LDRSHs
  { 1, 388, 390, 5285, 5288 }, // 340 tLDRSB_tLDRSH
  { 1, 380, 384, 5288, 5292 }, // 341 LDRBT_POST_IMM_LDRBT_POST_REG_LDRB_POST_REG_LDRB_PRE_REG
  { 1, 384, 388, 5292, 5295 }, // 342 LDRB_POST_IMM_LDRB_PRE_IMM_t2LDRB_POST_t2LDRB_PRE_t2LDRH_POST_t2LDRH_PRE
  { 1, 380, 384, 5295, 5299 }, // 343 LDRHTi_LDRHTr_LDRH_POST_LDRH_PRE
  { 1, 380, 384, 5299, 5303 }, // 344 LDRT_POST_IMM_LDRT_POST_REG_LDR_POST_REG_LDR_PRE_REG
  { 1, 384, 388, 5303, 5306 }, // 345 LDR_POST_IMM_LDR_PRE_IMM_t2LDR_POST_t2LDR_PRE
  { 1, 388, 390, 5306, 5308 }, // 346 t2LDRBT_t2LDRHT
  { 1, 388, 390, 5308, 5310 }, // 347 t2LDRT
  { 1, 388, 390, 5310, 5312 }, // 348 t2LDRSBT_t2LDRSHT
  { 1, 384, 388, 5312, 5315 }, // 349 t2LDRSB_POST_t2LDRSB_PRE_t2LDRSH_POST_t2LDRSH_PRE
  { 1, 394, 400, 5315, 5319 }, // 350 LDRD
  { 1, 494, 498, 5319, 5322 }, // 351 t2LDRDi8
  { 1, 400, 407, 5322, 5326 }, // 352 LDRD_POST_LDRD_PRE_t2LDRD_POST_t2LDRD_PRE
  { -1, 369, 374, 5326, 5331 }, // 353 LDMDA_LDMDB_LDMIA_LDMIB_sysLDMDA_sysLDMDB_sysLDMIA_sysLDMIB_t2LDMDB_t2LDMIA_tLDMIA
  { -1, 374, 380, 5331, 5336 }, // 354 LDMDA_UPD_LDMDB_UPD_LDMIA_UPD_LDMIB_UPD_sysLDMDA_UPD_sysLDMDB_UPD_sysLDMIA_UPD_sysLDMIB_UPD_t2LDMDB_UPD_t2LDMIA_UPD_tLDMIA_UPD
  { -1, 369, 374, 5336, 5341 }, // 355 LDMIA_RET_t2LDMIA_RET
  { -1, 384, 388, 5341, 5344 }, // 356 tPOP
  { -1, 384, 388, 5344, 5347 }, // 357 tPOP_RET
  { 1, 388, 390, 5347, 5350 }, // 358 PICSTR_STRi12_tSTRr
  { 1, 388, 390, 5350, 5353 }, // 359 PICSTRB_PICSTRH_STRBi12_STRH_tSTRBr_tSTRHr
  { 1, 390, 394, 5353, 5356 }, // 360 STRBrs_t2STRBs_t2STRHs
  { 0, 0, 0, 0, 0 }, // 361 STREX_STREXB_STREXD_STREXH
  { 1, 390, 394, 5356, 5359 }, // 362 STRrs_t2STRs
  { 1, 388, 390, 5359, 5361 }, // 363 t2STRBi12_t2STRBi8_t2STRHi12_t2STRHi8_tSTRBi_tSTRHi
  { 1, 388, 390, 5361, 5363 }, // 364 t2STRi12_t2STRi8_tSTRi_tSTRspi
  { 0, 0, 0, 0, 0 }, // 365 STRBT_POST_STRT_POST
  { 1, 384, 388, 5363, 5367 }, // 366 STRBT_POST_IMM_STRBT_POST_REG_STRB_POST_REG_STRB_PRE_REG_STRHTi_STRHTr_STRH_POST_STRH_PRE
  { 1, 384, 388, 5367, 5370 }, // 367 STRB_POST_IMM_STRB_PRE_IMM_t2STRB_POST_t2STRB_PRE_t2STRH_POST
  { 1, 384, 388, 5370, 5374 }, // 368 STRBi_preidx_STRBr_preidx_STRH_preidx_STRT_POST_IMM_STRT_POST_REG_STR_POST_REG_STR_PRE_REG_STRi_preidx_STRr_preidx_t2STRB_preidx_t2STRH_preidx_t2STR_preidx
  { 1, 384, 388, 5374, 5377 }, // 369 STR_POST_IMM_STR_PRE_IMM_t2STRH_PRE_t2STR_POST_t2STR_PRE
  { 1, 388, 390, 5377, 5379 }, // 370 t2STRBT_t2STRHT
  { 1, 388, 390, 5379, 5381 }, // 371 t2STRT
  { 1, 447, 453, 5381, 5384 }, // 372 STRD_t2STRDi8
  { 1, 384, 388, 5384, 5388 }, // 373 STRD_POST_STRD_PRE_t2STRD_POST_t2STRD_PRE
  { -1, 438, 447, 0, 0 }, // 374 STMDA_STMDB_STMIA_STMIB_sysSTMDA_sysSTMDB_sysSTMIA_sysSTMIB_t2STMDB_t2STMIA
  { -1, 438, 447, 5388, 5389 }, // 375 STMDA_UPD_STMDB_UPD_STMIA_UPD_STMIB_UPD_sysSTMDA_UPD_sysSTMDB_UPD_sysSTMIA_UPD_sysSTMIB_UPD_t2STMDB_UPD_t2STMIA_UPD_tSTMIA_UPD
  { -1, 438, 447, 0, 0 }, // 376 tPUSH
  { 0, 0, 0, 0, 0 }, // 377 ITasm
  { 1, 362, 364, 0, 0 }, // 378 t2IT
  { 1, 367, 369, 5389, 5392 }, // 379 VADDLsv2i64_VADDLsv4i32_VADDLsv8i16_VADDLuv2i64_VADDLuv4i32_VADDLuv8i16_VNEGs16d_VNEGs32d_VNEGs8d_VPADDLsv16i8_VPADDLsv2i32_VPADDLsv4i16_VPADDLsv4i32_VPADDLsv8i16_VPADDLsv8i8_VPADDLuv16i8_VPADDLuv2i32_VPADDLuv4i16_VPADDLuv4i32_VPADDLuv8i16_VPADDLuv8i8_VPADDi16_VPADDi32_VPADDi8_VSHLLi16_VSHLLi32_VSHLLi8_VSHLLsv2i64_VSHLLsv4i32_VSHLLsv8i16_VSHLLuv2i64_VSHLLuv4i32_VSHLLuv8i16_VSHLiv16i8_VSHLiv1i64_VSHLiv2i32_VSHLiv2i64_VSHLiv4i16_VSHLiv4i32_VSHLiv8i16_VSHLiv8i8_VSHLsv1i64_VSHLsv2i32_VSHLsv4i16_VSHLsv8i8_VSHLuv1i64_VSHLuv2i32_VSHLuv4i16_VSHLuv8i8_VSHRsv16i8_VSHRsv1i64_VSHRsv2i32_VSHRsv2i64_VSHRsv4i16_VSHRsv4i32_VSHRsv8i16_VSHRsv8i8_VSHRuv16i8_VSHRuv1i64_VSHRuv2i32_VSHRuv2i64_VSHRuv4i16_VSHRuv4i32_VSHRuv8i16_VSHRuv8i8_VSLIv1i64_VSLIv2i32_VSLIv4i16_VSLIv8i8_VSRIv1i64_VSRIv2i32_VSRIv4i16_VSRIv8i8_VSUBLsv2i64_VSUBLsv4i32_VSUBLsv8i16_VSUBLuv2i64_VSUBLuv4i32_VSUBLuv8i16
  { 1, 367, 369, 5392, 5395 }, // 380 VADDWsv2i64_VADDWsv4i32_VADDWsv8i16_VADDWuv2i64_VADDWuv4i32_VADDWuv8i16_VSUBWsv2i64_VSUBWsv4i32_VSUBWsv8i16_VSUBWuv2i64_VSUBWuv4i32_VSUBWuv8i16_VSUBv1i64_VSUBv2i32_VSUBv4i16_VSUBv8i8
  { 1, 367, 369, 5395, 5398 }, // 381 VADDv16i8_VADDv2i64_VADDv4i32_VADDv8i16_VANDq_VBICq_VBIFq_VBITq_VEORq_VORNq_VORRq
  { 1, 367, 369, 5398, 5401 }, // 382 VADDv1i64_VADDv2i32_VADDv4i16_VADDv8i8_VANDd_VBICd_VBIFd_VBITd_VEORd_VORNd_VORRd
  { 1, 367, 369, 5401, 5402 }, // 383 VBICiv2i32_VBICiv4i16_VBICiv4i32_VBICiv8i16_VORRiv2i32_VORRiv4i16_VORRiv4i32_VORRiv8i16
  { 1, 367, 369, 5402, 5405 }, // 384 VBSLd_VCLSv2i32_VCLSv4i16_VCLSv8i8_VCLZv2i32_VCLZv4i16_VCLZv8i8_VCNTd
  { 1, 367, 369, 5405, 5408 }, // 385 VBSLq_VCLSv16i8_VCLSv4i32_VCLSv8i16_VCLZv16i8_VCLZv4i32_VCLZv8i16_VCNTq
  { 1, 367, 369, 5408, 5411 }, // 386 VHADDsv16i8_VHADDsv4i32_VHADDsv8i16_VHADDuv16i8_VHADDuv4i32_VHADDuv8i16_VRHADDsv16i8_VRHADDsv4i32_VRHADDsv8i16_VRHADDuv16i8_VRHADDuv4i32_VRHADDuv8i16_VTSTv16i8_VTSTv4i32_VTSTv8i16
  { 1, 367, 369, 5411, 5414 }, // 387 VHADDsv2i32_VHADDsv4i16_VHADDsv8i8_VHADDuv2i32_VHADDuv4i16_VHADDuv8i8_VRHADDsv2i32_VRHADDsv4i16_VRHADDsv8i8_VRHADDuv2i32_VRHADDuv4i16_VRHADDuv8i8_VTSTv2i32_VTSTv4i16_VTSTv8i8
  { 1, 367, 369, 5414, 5417 }, // 388 VHSUBsv16i8_VHSUBsv4i32_VHSUBsv8i16_VHSUBuv16i8_VHSUBuv4i32_VHSUBuv8i16
  { 1, 367, 369, 5417, 5420 }, // 389 VHSUBsv2i32_VHSUBsv4i16_VHSUBsv8i8_VHSUBuv2i32_VHSUBuv4i16_VHSUBuv8i8
  { 1, 367, 369, 5420, 5422 }, // 390 VNEGf32q
  { 1, 367, 369, 5422, 5424 }, // 391 VNEGfd
  { 1, 367, 369, 5424, 5427 }, // 392 VNEGs16q_VNEGs32q_VNEGs8q_VSHLsv16i8_VSHLsv2i64_VSHLsv4i32_VSHLsv8i16_VSHLuv16i8_VSHLuv2i64_VSHLuv4i32_VSHLuv8i16_VSLIv16i8_VSLIv2i64_VSLIv4i32_VSLIv8i16_VSRIv16i8_VSRIv2i64_VSRIv4i32_VSRIv8i16
  { 1, 367, 369, 5427, 5430 }, // 393 VQSHLsiv16i8_VQSHLsiv1i64_VQSHLsiv2i32_VQSHLsiv2i64_VQSHLsiv4i16_VQSHLsiv4i32_VQSHLsiv8i16_VQSHLsiv8i8_VQSHLsuv16i8_VQSHLsuv1i64_VQSHLsuv2i32_VQSHLsuv2i64_VQSHLsuv4i16_VQSHLsuv4i32_VQSHLsuv8i16_VQSHLsuv8i8_VQSHLsv1i64_VQSHLsv2i32_VQSHLsv4i16_VQSHLsv8i8_VQSHLuiv16i8_VQSHLuiv1i64_VQSHLuiv2i32_VQSHLuiv2i64_VQSHLuiv4i16_VQSHLuiv4i32_VQSHLuiv8i16_VQSHLuiv8i8_VQSHLuv1i64_VQSHLuv2i32_VQSHLuv4i16_VQSHLuv8i8
  { 1, 367, 369, 5430, 5433 }, // 394 VQSHLsv16i8_VQSHLsv2i64_VQSHLsv4i32_VQSHLsv8i16_VQSHLuv16i8_VQSHLuv2i64_VQSHLuv4i32_VQSHLuv8i16
  { 1, 367, 369, 5433, 5436 }, // 395 VSUBv16i8_VSUBv2i64_VSUBv4i32_VSUBv8i16
  { 1, 457, 459, 5436, 5439 }, // 396 VEXTd16_VEXTd32_VEXTd8
  { 1, 457, 459, 5439, 5442 }, // 397 VEXTq16_VEXTq32_VEXTq64_VEXTq8
  { 1, 457, 459, 5442, 5444 }, // 398 VREV16d8_VREV32d16_VREV32d8_VREV64d16_VREV64d32_VREV64d8
  { 1, 457, 459, 5444, 5446 }, // 399 VREV16q8_VREV32q16_VREV32q8_VREV64q16_VREV64q32_VREV64q8
  { 1, 367, 369, 5446, 5450 }, // 400 VABALsv2i64_VABALsv4i32_VABALsv8i16_VABALuv2i64_VABALuv4i32_VABALuv8i16_VABAsv2i32_VABAsv4i16_VABAsv8i8_VABAuv2i32_VABAuv4i16_VABAuv8i8
  { 1, 367, 369, 5450, 5454 }, // 401 VABAsv16i8_VABAsv4i32_VABAsv8i16_VABAuv16i8_VABAuv4i32_VABAuv8i16
  { 1, 367, 369, 5454, 5456 }, // 402 VABSfd
  { 1, 367, 369, 5456, 5458 }, // 403 VABSfq
  { 1, 367, 369, 5458, 5460 }, // 404 VABSv16i8_VABSv4i32_VABSv8i16
  { 1, 367, 369, 5460, 5462 }, // 405 VABSv2i32_VABSv4i16_VABSv8i8
  { 1, 367, 369, 5462, 5465 }, // 406 VACGEd_VACGTd_VCEQfd_VCGEfd_VCGTfd
  { 1, 367, 369, 5465, 5468 }, // 407 VACGEq_VACGTq_VCEQfq_VCGEfq_VCGTfq
  { 1, 367, 369, 5468, 5471 }, // 408 VCEQv16i8_VCEQv4i32_VCEQv8i16_VCGEsv16i8_VCGEsv4i32_VCGEsv8i16_VCGEuv16i8_VCGEuv4i32_VCGEuv8i16_VCGTsv16i8_VCGTsv4i32_VCGTsv8i16_VCGTuv16i8_VCGTuv4i32_VCGTuv8i16_VQSUBsv16i8_VQSUBsv2i64_VQSUBsv4i32_VQSUBsv8i16_VQSUBuv16i8_VQSUBuv2i64_VQSUBuv4i32_VQSUBuv8i16
  { 1, 367, 369, 5471, 5474 }, // 409 VCEQv2i32_VCEQv4i16_VCEQv8i8_VCGEsv2i32_VCGEsv4i16_VCGEsv8i8_VCGEuv2i32_VCGEuv4i16_VCGEuv8i8_VCGTsv2i32_VCGTsv4i16_VCGTsv8i8_VCGTuv2i32_VCGTuv4i16_VCGTuv8i8_VQSUBsv1i64_VQSUBsv2i32_VQSUBsv4i16_VQSUBsv8i8_VQSUBuv1i64_VQSUBuv2i32_VQSUBuv4i16_VQSUBuv8i8
  { 0, 0, 0, 0, 0 }, // 410 VCEQzv16i8_VCEQzv2f32_VCEQzv2i32_VCEQzv4f32_VCEQzv4i16_VCEQzv4i32_VCEQzv8i16_VCEQzv8i8_VCGEzv16i8_VCGEzv2f32_VCGEzv2i32_VCGEzv4f32_VCGEzv4i16_VCGEzv4i32_VCGEzv8i16_VCGEzv8i8_VCGTzv16i8_VCGTzv2f32_VCGTzv2i32_VCGTzv4f32_VCGTzv4i16_VCGTzv4i32_VCGTzv8i16_VCGTzv8i8_VCLEzv16i8_VCLEzv2f32_VCLEzv2i32_VCLEzv4f32_VCLEzv4i16_VCLEzv4i32_VCLEzv8i16_VCLEzv8i8_VCLTzv16i8_VCLTzv2f32_VCLTzv2i32_VCLTzv4f32_VCLTzv4i16_VCLTzv4i32_VCLTzv8i16_VCLTzv8i8
  { 1, 367, 369, 5474, 5477 }, // 411 VPADALsv16i8_VPADALsv4i32_VPADALsv8i16_VPADALuv16i8_VPADALuv4i32_VPADALuv8i16
  { 1, 367, 369, 5477, 5480 }, // 412 VPADALsv2i32_VPADALsv4i16_VPADALsv8i8_VPADALuv2i32_VPADALuv4i16_VPADALuv8i8_VRSRAsv16i8_VRSRAsv1i64_VRSRAsv2i32_VRSRAsv2i64_VRSRAsv4i16_VRSRAsv4i32_VRSRAsv8i16_VRSRAsv8i8_VRSRAuv16i8_VRSRAuv1i64_VRSRAuv2i32_VRSRAuv2i64_VRSRAuv4i16_VRSRAuv4i32_VRSRAuv8i16_VRSRAuv8i8_VSRAsv16i8_VSRAsv1i64_VSRAsv2i32_VSRAsv2i64_VSRAsv4i16_VSRAsv4i32_VSRAsv8i16_VSRAsv8i8_VSRAuv16i8_VSRAuv1i64_VSRAuv2i32_VSRAuv2i64_VSRAuv4i16_VSRAuv4i32_VSRAuv8i16_VSRAuv8i8
  { 1, 367, 369, 5480, 5482 }, // 413 VQABSv16i8_VQABSv4i32_VQABSv8i16_VQNEGv16i8_VQNEGv4i32_VQNEGv8i16
  { 1, 367, 369, 5482, 5484 }, // 414 VQABSv2i32_VQABSv4i16_VQABSv8i8_VQNEGv2i32_VQNEGv4i16_VQNEGv8i8
  { 1, 367, 369, 5484, 5487 }, // 415 VQADDsv16i8_VQADDsv2i64_VQADDsv4i32_VQADDsv8i16_VQADDuv16i8_VQADDuv2i64_VQADDuv4i32_VQADDuv8i16
  { 1, 367, 369, 5487, 5490 }, // 416 VQADDsv1i64_VQADDsv2i32_VQADDsv4i16_VQADDsv8i8_VQADDuv1i64_VQADDuv2i32_VQADDuv4i16_VQADDuv8i8
  { 1, 367, 369, 5490, 5493 }, // 417 VQRSHLsv16i8_VQRSHLsv2i64_VQRSHLsv4i32_VQRSHLsv8i16_VQRSHLuv16i8_VQRSHLuv2i64_VQRSHLuv4i32_VQRSHLuv8i16_VRSHLsv16i8_VRSHLsv2i64_VRSHLsv4i32_VRSHLsv8i16_VRSHLuv16i8_VRSHLuv2i64_VRSHLuv4i32_VRSHLuv8i16
  { 1, 367, 369, 5493, 5496 }, // 418 VQRSHLsv1i64_VQRSHLsv2i32_VQRSHLsv4i16_VQRSHLsv8i8_VQRSHLuv1i64_VQRSHLuv2i32_VQRSHLuv4i16_VQRSHLuv8i8_VRSHLsv1i64_VRSHLsv2i32_VRSHLsv4i16_VRSHLsv8i8_VRSHLuv1i64_VRSHLuv2i32_VRSHLuv4i16_VRSHLuv8i8_VRSHRsv16i8_VRSHRsv1i64_VRSHRsv2i32_VRSHRsv2i64_VRSHRsv4i16_VRSHRsv4i32_VRSHRsv8i16_VRSHRsv8i8_VRSHRuv16i8_VRSHRuv1i64_VRSHRuv2i32_VRSHRuv2i64_VRSHRuv4i16_VRSHRuv4i32_VRSHRuv8i16_VRSHRuv8i8
  { 1, 367, 369, 5496, 5498 }, // 419 VRECPEd_VRECPEfd_VRSQRTEd_VRSQRTEfd
  { 1, 367, 369, 5498, 5500 }, // 420 VRECPEfq_VRECPEq_VRSQRTEfq_VRSQRTEq
  { 1, 367, 369, 5500, 5503 }, // 421 VADDHNv2i32_VADDHNv4i16_VADDHNv8i8_VSUBHNv2i32_VSUBHNv4i16_VSUBHNv8i8
  { 1, 367, 369, 5503, 5506 }, // 422 VSHRNv2i32_VSHRNv4i16_VSHRNv8i8
  { 1, 367, 369, 5506, 5509 }, // 423 VQRSHRNsv2i32_VQRSHRNsv4i16_VQRSHRNsv8i8_VQRSHRNuv2i32_VQRSHRNuv4i16_VQRSHRNuv8i8_VQRSHRUNv2i32_VQRSHRUNv4i16_VQRSHRUNv8i8_VQSHRNsv2i32_VQSHRNsv4i16_VQSHRNsv8i8_VQSHRNuv2i32_VQSHRNuv4i16_VQSHRNuv8i8_VQSHRUNv2i32_VQSHRUNv4i16_VQSHRUNv8i8_VRSHRNv2i32_VRSHRNv4i16_VRSHRNv8i8
  { 1, 367, 369, 5509, 5512 }, // 424 VRADDHNv2i32_VRADDHNv4i16_VRADDHNv8i8_VRSUBHNv2i32_VRSUBHNv4i16_VRSUBHNv8i8
  { 1, 457, 459, 5512, 5515 }, // 425 VTBL1
  { 1, 457, 459, 5515, 5518 }, // 426 VTBX1
  { 1, 477, 481, 5518, 5522 }, // 427 VTBL2
  { 1, 477, 481, 5522, 5526 }, // 428 VTBX2
  { 1, 481, 487, 5526, 5531 }, // 429 VTBL3_VTBL3Pseudo
  { 1, 481, 487, 5531, 5536 }, // 430 VTBX3_VTBX3Pseudo
  { 1, 487, 494, 5536, 5542 }, // 431 VTBL4_VTBL4Pseudo
  { 1, 487, 494, 5542, 5548 }, // 432 VTBX4_VTBX4Pseudo
  { 0, 0, 0, 0, 0 }, // 433 VSWPd_VSWPq
  { 1, 481, 487, 5548, 5552 }, // 434 VTRNd16_VTRNd32_VTRNd8_VUZPd16_VUZPd8_VZIPd16_VZIPd8
  { 1, 481, 487, 5552, 5556 }, // 435 VTRNq16_VTRNq32_VTRNq8
  { 1, 481, 487, 5556, 5560 }, // 436 VUZPq16_VUZPq32_VUZPq8_VZIPq16_VZIPq32_VZIPq8
  { 1, 367, 369, 5560, 5562 }, // 437 VABSD_VNEGD
  { 1, 367, 369, 5562, 5564 }, // 438 VABSS_VNEGS
  { 1, 367, 369, 5564, 5566 }, // 439 VCMPD_VCMPED_VCMPEZD_VCMPZD
  { 1, 367, 369, 5566, 5568 }, // 440 VCMPES_VCMPEZS_VCMPS_VCMPZS
  { 1, 367, 369, 5568, 5571 }, // 441 VABDLsv2i64_VABDLsv4i32_VABDLsv8i16_VABDLuv2i64_VABDLuv4i32_VABDLuv8i16_VABDsv16i8_VABDsv4i32_VABDsv8i16_VABDuv16i8_VABDuv4i32_VABDuv8i16_VMAXsv16i8_VMAXsv4i32_VMAXsv8i16_VMAXuv16i8_VMAXuv4i32_VMAXuv8i16_VMINsv16i8_VMINsv4i32_VMINsv8i16_VMINuv16i8_VMINuv4i32_VMINuv8i16
  { 1, 367, 369, 5571, 5574 }, // 442 VABDfd_VADDfd_VMAXfd_VMINfd_VSUBfd
  { 1, 367, 369, 5574, 5577 }, // 443 VABDfq_VADDfq_VMAXfq_VMINfq_VSUBfq
  { 1, 367, 369, 5577, 5580 }, // 444 VABDsv2i32_VABDsv4i16_VABDsv8i8_VABDuv2i32_VABDuv4i16_VABDuv8i8_VMAXsv2i32_VMAXsv4i16_VMAXsv8i8_VMAXuv2i32_VMAXuv4i16_VMAXuv8i8_VMINsv2i32_VMINsv4i16_VMINsv8i8_VMINuv2i32_VMINuv4i16_VMINuv8i8_VPMAXs16_VPMAXs32_VPMAXs8_VPMAXu16_VPMAXu32_VPMAXu8_VPMINs16_VPMINs32_VPMINs8_VPMINu16_VPMINu32_VPMINu8
  { 1, 367, 369, 5580, 5583 }, // 445 VADDS_VSUBS
  { 0, 0, 0, 0, 0 }, // 446 VMAXNMD_VMAXNMND_VMAXNMNQ_VMAXNMS_VMINNMD_VMINNMND_VMINNMNQ_VMINNMS
  { 1, 367, 369, 5583, 5586 }, // 447 VPADDf_VPMAXf_VPMINf
  { 1, 367, 369, 5586, 5589 }, // 448 VADDD_VSUBD
  { 1, 457, 459, 5589, 5592 }, // 449 VRECPSfd_VRSQRTSfd
  { 1, 457, 459, 5592, 5595 }, // 450 VRECPSfq_VRSQRTSfq
  { 0, 0, 0, 0, 0 }, // 451 VMULLp64
  { 1, 457, 459, 5595, 5598 }, // 452 VMULLp8_VMULLslsv2i32_VMULLslsv4i16_VMULLsluv2i32_VMULLsluv4i16_VMULLsv4i32_VMULLsv8i16_VMULLuv4i32_VMULLuv8i16_VMULpd_VMULslv4i16_VMULv4i16_VMULv8i8_VQDMULHslv4i16_VQDMULHv4i16_VQDMULLslv2i32_VQDMULLslv4i16_VQDMULLv4i32_VQRDMULHslv4i16_VQRDMULHv4i16
  { 1, 457, 459, 5598, 5601 }, // 453 VMULLsv2i64_VMULLuv2i64_VMULslv2i32_VMULv2i32_VQDMULHslv2i32_VQDMULHv2i32_VQDMULLv2i64_VQRDMULHslv2i32_VQRDMULHv2i32
  { 1, 457, 459, 5601, 5604 }, // 454 VMULS_VNMULS
  { 1, 457, 459, 5604, 5607 }, // 455 VMULfd
  { 1, 457, 459, 5607, 5610 }, // 456 VMULfq
  { 1, 457, 459, 5610, 5613 }, // 457 VMULpq_VMULslv8i16_VMULv16i8_VMULv8i16_VQDMULHslv8i16_VQDMULHv8i16_VQRDMULHslv8i16_VQRDMULHv8i16
  { 1, 367, 369, 5613, 5616 }, // 458 VMULslfd
  { 1, 367, 369, 5616, 5619 }, // 459 VMULslfq
  { 1, 457, 459, 5619, 5622 }, // 460 VMULslv4i32_VMULv4i32_VQDMULHslv4i32_VQDMULHv4i32_VQRDMULHslv4i32_VQRDMULHv4i32
  { 1, 457, 459, 5622, 5625 }, // 461 VMULD_VNMULD
  { 1, 457, 459, 5625, 5628 }, // 462 VFMAD_VFMSD_VFNMAD_VFNMSD
  { 1, 457, 459, 5628, 5631 }, // 463 VFMAS_VFMSS_VFNMAS_VFNMSS
  { 1, 457, 459, 5631, 5634 }, // 464 VMLAD_VMLSD_VNMLAD_VNMLSD
  { 1, 457, 459, 5634, 5638 }, // 465 VMLALslsv2i32_VMLALsluv2i32_VMLALsv2i64_VMLALuv2i64_VMLAslv2i32_VMLAv2i32_VMLSLslsv2i32_VMLSLsluv2i32_VMLSLsv2i64_VMLSLuv2i64_VMLSslv2i32_VMLSv2i32_VQDMLALslv2i32_VQDMLALv2i64_VQDMLSLslv2i32_VQDMLSLv2i64
  { 1, 457, 459, 5638, 5642 }, // 466 VMLALslsv4i16_VMLALsluv4i16_VMLALsv4i32_VMLALsv8i16_VMLALuv4i32_VMLALuv8i16_VMLAslv4i16_VMLAv4i16_VMLAv8i8_VMLSLslsv4i16_VMLSLsluv4i16_VMLSLsv4i32_VMLSLsv8i16_VMLSLuv4i32_VMLSLuv8i16_VMLSslv4i16_VMLSv4i16_VMLSv8i8_VQDMLALslv4i16_VQDMLALv4i32_VQDMLSLslv4i16_VQDMLSLv4i32
  { 1, 457, 459, 5642, 5645 }, // 467 VMLAS_VMLSS_VNMLAS_VNMLSS
  { 1, 457, 459, 5645, 5648 }, // 468 VMLAfd_VMLAslfd_VMLSfd_VMLSslfd
  { 1, 457, 459, 5648, 5651 }, // 469 VMLAfq_VMLAslfq_VMLSfq_VMLSslfq
  { 1, 457, 459, 5651, 5655 }, // 470 VMLAslv4i32_VMLAv4i32_VMLSslv4i32_VMLSv4i32
  { 1, 457, 459, 5655, 5659 }, // 471 VMLAslv8i16_VMLAv16i8_VMLAv8i16_VMLSslv8i16_VMLSv16i8_VMLSv8i16
  { 1, 457, 459, 5659, 5662 }, // 472 VFMAfd_VFMSfd
  { 1, 457, 459, 5662, 5665 }, // 473 VFMAfq_VFMSfq
  { 0, 0, 0, 0, 0 }, // 474 VCVTANSD_VCVTANSQ_VCVTANUD_VCVTANUQ_VCVTASD_VCVTASS_VCVTAUD_VCVTAUS_VCVTBDH_VCVTBHD_VCVTMNSD_VCVTMNSQ_VCVTMNUD_VCVTMNUQ_VCVTMSD_VCVTMSS_VCVTMUD_VCVTMUS_VCVTNNSD_VCVTNNSQ_VCVTNNUD_VCVTNNUQ_VCVTNSD_VCVTNSS_VCVTNUD_VCVTNUS_VCVTPNSD_VCVTPNSQ_VCVTPNUD_VCVTPNUQ_VCVTPSD_VCVTPSS_VCVTPUD_VCVTPUS_VCVTTDH_VCVTTHD
  { 1, 453, 457, 5665, 5667 }, // 475 VCVTBHS_VCVTTHS
  { 1, 457, 459, 5667, 5669 }, // 476 VCVTBSH_VCVTTSH
  { 1, 457, 459, 5669, 5671 }, // 477 VCVTDS
  { 1, 457, 459, 5671, 5673 }, // 478 VCVTSD
  { 1, 367, 369, 5673, 5675 }, // 479 VCVTf2h_VCVTf2sq_VCVTf2uq_VCVTf2xsq_VCVTf2xuq_VCVTh2f_VCVTs2fq_VCVTu2fq_VCVTxs2fq_VCVTxu2fq
  { 1, 367, 369, 5675, 5677 }, // 480 VCVTf2sd_VCVTf2ud_VCVTf2xsd_VCVTf2xud_VCVTs2fd_VCVTu2fd_VCVTxs2fd_VCVTxu2fd
  { 1, 457, 459, 5677, 5679 }, // 481 VSITOD_VUITOD
  { 1, 457, 459, 5679, 5681 }, // 482 VSITOS_VUITOS
  { 1, 457, 459, 5681, 5683 }, // 483 VTOSHD_VTOSLD_VTOUHD_VTOULD
  { 1, 457, 459, 5683, 5685 }, // 484 VTOSHS_VTOSLS_VTOUHS_VTOULS
  { 1, 457, 459, 5685, 5687 }, // 485 VTOSIRD_VTOSIZD_VTOUIRD_VTOUIZD
  { 1, 457, 459, 5687, 5689 }, // 486 VTOSIRS_VTOSIZS_VTOUIRS_VTOUIZS
  { 1, 367, 369, 5689, 5691 }, // 487 FCONSTD_VMOVD_VMOVDcc
  { 1, 367, 369, 5691, 5693 }, // 488 FCONSTS_VMOVS_VMOVScc
  { 1, 367, 369, 5693, 5694 }, // 489 VMOVv16i8_VMOVv1i64_VMOVv2f32_VMOVv2i32_VMOVv2i64_VMOVv4f32_VMOVv4i16_VMOVv4i32_VMOVv8i16_VMOVv8i8_VMVNv2i32_VMVNv4i16_VMVNv4i32_VMVNv8i16
  { 1, 367, 369, 5694, 5697 }, // 490 VMVNd_VMVNq
  { 1, 367, 369, 5697, 5699 }, // 491 VMOVLsv2i64_VMOVLsv4i32_VMOVLsv8i16_VMOVLuv2i64_VMOVLuv4i32_VMOVLuv8i16
  { 1, 457, 459, 5699, 5701 }, // 492 VMOVNv2i32_VMOVNv4i16_VMOVNv8i8
  { 1, 367, 369, 5701, 5703 }, // 493 VQMOVNsuv2i32_VQMOVNsuv4i16_VQMOVNsuv8i8_VQMOVNsv2i32_VQMOVNsv4i16_VQMOVNsv8i8_VQMOVNuv2i32_VQMOVNuv4i16_VQMOVNuv8i8
  { 1, 457, 459, 5703, 5705 }, // 494 VDUPLN16d_VDUPLN32d_VDUPLN8d
  { 1, 457, 459, 5705, 5707 }, // 495 VDUPLN16q_VDUPLN32q_VDUPLN8q
  { 1, 465, 469, 5707, 5709 }, // 496 VDUP16d_VDUP16q_VDUP32d_VDUP32q_VDUP8d_VDUP8q
  { 1, 388, 390, 5709, 5711 }, // 497 VMOVRS
  { 1, 465, 469, 5711, 5713 }, // 498 VMOVSR
  { 1, 465, 469, 5713, 5715 }, // 499 VSETLNi16_VSETLNi32_VSETLNi8
  { 1, 473, 477, 5715, 5718 }, // 500 VMOVRRD_VMOVRRS
  { 1, 388, 390, 5718, 5720 }, // 501 VMOVDRR
  { 1, 388, 390, 5720, 5722 }, // 502 VMOVSRR
  { 1, 388, 390, 5722, 5724 }, // 503 VGETLNi32_VGETLNu16_VGETLNu8
  { 1, 388, 390, 5724, 5726 }, // 504 VGETLNs16_VGETLNs8
  { 1, 362, 364, 5726, 5727 }, // 505 VMRS_VMRS_FPEXC_VMRS_FPINST_VMRS_FPINST2_VMRS_FPSID_VMRS_MVFR0_VMRS_MVFR1_VMRS_MVFR2
  { 1, 362, 364, 5727, 5728 }, // 506 VMSR_VMSR_FPEXC_VMSR_FPINST_VMSR_FPINST2_VMSR_FPSID
  { 1, 362, 364, 5728, 5729 }, // 507 FMSTAT
  { 1, 388, 390, 5729, 5731 }, // 508 VLDRD
  { 1, 388, 390, 5731, 5733 }, // 509 VLDRS
  { 1, 388, 390, 5733, 5735 }, // 510 VSTRD
  { 1, 388, 390, 5735, 5737 }, // 511 VSTRS
  { -1, 388, 390, 5737, 5741 }, // 512 VLDMQIA
  { -1, 388, 390, 5741, 5744 }, // 513 VSTMQIA
  { -1, 388, 390, 5744, 5748 }, // 514 VLDMDIA_VLDMSIA
  { -1, 469, 473, 5748, 5753 }, // 515 VLDMDDB_UPD_VLDMDIA_UPD_VLDMSDB_UPD_VLDMSIA_UPD
  { -1, 388, 390, 5753, 5756 }, // 516 VSTMDIA_VSTMSIA
  { -1, 469, 473, 5756, 5760 }, // 517 VSTMDDB_UPD_VSTMDIA_UPD_VSTMSDB_UPD_VSTMSIA_UPD
  { 0, 0, 0, 0, 0 }, // 518 VLD1d16_VLD1d32_VLD1d64_VLD1d8
  { 0, 0, 0, 0, 0 }, // 519 VLD1q16_VLD1q32_VLD1q64_VLD1q8
  { 0, 0, 0, 0, 0 }, // 520 VLD1d16wb_fixed_VLD1d16wb_register_VLD1d32wb_fixed_VLD1d32wb_register_VLD1d64wb_fixed_VLD1d64wb_register_VLD1d8wb_fixed_VLD1d8wb_register
  { 0, 0, 0, 0, 0 }, // 521 VLD1q16wb_fixed_VLD1q16wb_register_VLD1q32wb_fixed_VLD1q32wb_register_VLD1q64wb_fixed_VLD1q64wb_register_VLD1q8wb_fixed_VLD1q8wb_register
  { 0, 0, 0, 0, 0 }, // 522 VLD1d16T_VLD1d32T_VLD1d64T_VLD1d64TPseudo_VLD1d64TPseudoWB_fixed_VLD1d64TPseudoWB_register_VLD1d8T
  { 0, 0, 0, 0, 0 }, // 523 VLD1d16Twb_fixed_VLD1d16Twb_register_VLD1d32Twb_fixed_VLD1d32Twb_register_VLD1d64Twb_fixed_VLD1d64Twb_register_VLD1d8Twb_fixed_VLD1d8Twb_register
  { 0, 0, 0, 0, 0 }, // 524 VLD1d16Q_VLD1d32Q_VLD1d64Q_VLD1d64QPseudo_VLD1d64QPseudoWB_fixed_VLD1d64QPseudoWB_register_VLD1d8Q
  { 0, 0, 0, 0, 0 }, // 525 VLD1d16Qwb_fixed_VLD1d16Qwb_register_VLD1d32Qwb_fixed_VLD1d32Qwb_register_VLD1d64Qwb_fixed_VLD1d64Qwb_register_VLD1d8Qwb_fixed_VLD1d8Qwb_register
  { 0, 0, 0, 0, 0 }, // 526 VLD2b16_VLD2b32_VLD2b8_VLD2d16_VLD2d32_VLD2d8
  { 0, 0, 0, 0, 0 }, // 527 VLD2q16_VLD2q16Pseudo_VLD2q32_VLD2q32Pseudo_VLD2q8_VLD2q8Pseudo
  { 0, 0, 0, 0, 0 }, // 528 VLD2b16wb_fixed_VLD2b16wb_register_VLD2b32wb_fixed_VLD2b32wb_register_VLD2b8wb_fixed_VLD2b8wb_register_VLD2d16wb_fixed_VLD2d16wb_register_VLD2d32wb_fixed_VLD2d32wb_register_VLD2d8wb_fixed_VLD2d8wb_register
  { 0, 0, 0, 0, 0 }, // 529 VLD2q16PseudoWB_fixed_VLD2q16PseudoWB_register_VLD2q16wb_fixed_VLD2q16wb_register_VLD2q32PseudoWB_fixed_VLD2q32PseudoWB_register_VLD2q32wb_fixed_VLD2q32wb_register_VLD2q8PseudoWB_fixed_VLD2q8PseudoWB_register_VLD2q8wb_fixed_VLD2q8wb_register
  { 0, 0, 0, 0, 0 }, // 530 VLD3d16_VLD3d32_VLD3d8_VLD3q16_VLD3q32_VLD3q8
  { 0, 0, 0, 0, 0 }, // 531 VLD3d16Pseudo_VLD3d32Pseudo_VLD3d8Pseudo_VLD3q16oddPseudo_VLD3q32oddPseudo_VLD3q8oddPseudo
  { 0, 0, 0, 0, 0 }, // 532 VLD3d16_UPD_VLD3d32_UPD_VLD3d8_UPD_VLD3q16_UPD_VLD3q32_UPD_VLD3q8_UPD
  { 0, 0, 0, 0, 0 }, // 533 VLD3d16Pseudo_UPD_VLD3d32Pseudo_UPD_VLD3d8Pseudo_UPD_VLD3q16Pseudo_UPD_VLD3q16oddPseudo_UPD_VLD3q32Pseudo_UPD_VLD3q32oddPseudo_UPD_VLD3q8Pseudo_UPD_VLD3q8oddPseudo_UPD
  { 0, 0, 0, 0, 0 }, // 534 VLD4d16_VLD4d32_VLD4d8_VLD4q16_VLD4q32_VLD4q8
  { 0, 0, 0, 0, 0 }, // 535 VLD4d16Pseudo_VLD4d32Pseudo_VLD4d8Pseudo_VLD4q16oddPseudo_VLD4q32oddPseudo_VLD4q8oddPseudo
  { 0, 0, 0, 0, 0 }, // 536 VLD4d16_UPD_VLD4d32_UPD_VLD4d8_UPD_VLD4q16_UPD_VLD4q32_UPD_VLD4q8_UPD
  { 0, 0, 0, 0, 0 }, // 537 VLD4d16Pseudo_UPD_VLD4d32Pseudo_UPD_VLD4d8Pseudo_UPD_VLD4q16Pseudo_UPD_VLD4q16oddPseudo_UPD_VLD4q32Pseudo_UPD_VLD4q32oddPseudo_UPD_VLD4q8Pseudo_UPD_VLD4q8oddPseudo_UPD
  { 0, 0, 0, 0, 0 }, // 538 VLD1DUPd16_VLD1DUPd32_VLD1DUPd8_VLD1DUPq16_VLD1DUPq32_VLD1DUPq8
  { 0, 0, 0, 0, 0 }, // 539 VLD1LNd16_VLD1LNd32_VLD1LNd8_VLD1LNq16Pseudo_VLD1LNq32Pseudo_VLD1LNq8Pseudo
  { 0, 0, 0, 0, 0 }, // 540 VLD1DUPd16wb_fixed_VLD1DUPd16wb_register_VLD1DUPd32wb_fixed_VLD1DUPd32wb_register_VLD1DUPd8wb_fixed_VLD1DUPd8wb_register_VLD1DUPq16wb_fixed_VLD1DUPq16wb_register_VLD1DUPq32wb_fixed_VLD1DUPq32wb_register_VLD1DUPq8wb_fixed_VLD1DUPq8wb_register
  { 0, 0, 0, 0, 0 }, // 541 VLD1LNd16_UPD_VLD1LNd32_UPD_VLD1LNd8_UPD_VLD1LNq16Pseudo_UPD_VLD1LNq32Pseudo_UPD_VLD1LNq8Pseudo_UPD
  { 0, 0, 0, 0, 0 }, // 542 VLD2DUPd16_VLD2DUPd16x2_VLD2DUPd32_VLD2DUPd32x2_VLD2DUPd8_VLD2DUPd8x2
  { 0, 0, 0, 0, 0 }, // 543 VLD2LNd16_VLD2LNd16Pseudo_VLD2LNd32_VLD2LNd32Pseudo_VLD2LNd8_VLD2LNd8Pseudo_VLD2LNq16_VLD2LNq16Pseudo_VLD2LNq32_VLD2LNq32Pseudo
  { 0, 0, 0, 0, 0 }, // 544 VLD2LNd16_UPD_VLD2LNd32_UPD_VLD2LNd8_UPD_VLD2LNq16_UPD_VLD2LNq32_UPD
  { 0, 0, 0, 0, 0 }, // 545 VLD2DUPd16wb_fixed_VLD2DUPd16wb_register_VLD2DUPd16x2wb_fixed_VLD2DUPd16x2wb_register_VLD2DUPd32wb_fixed_VLD2DUPd32wb_register_VLD2DUPd32x2wb_fixed_VLD2DUPd32x2wb_register_VLD2DUPd8wb_fixed_VLD2DUPd8wb_register_VLD2DUPd8x2wb_fixed_VLD2DUPd8x2wb_register
  { 0, 0, 0, 0, 0 }, // 546 VLD2LNd16Pseudo_UPD_VLD2LNd32Pseudo_UPD_VLD2LNd8Pseudo_UPD_VLD2LNq16Pseudo_UPD_VLD2LNq32Pseudo_UPD
  { 0, 0, 0, 0, 0 }, // 547 VLD3DUPd16_VLD3DUPd16Pseudo_VLD3DUPd32_VLD3DUPd32Pseudo_VLD3DUPd8_VLD3DUPd8Pseudo_VLD3DUPq16_VLD3DUPq32_VLD3DUPq8
  { 0, 0, 0, 0, 0 }, // 548 VLD3LNd16_VLD3LNd16Pseudo_VLD3LNd32_VLD3LNd32Pseudo_VLD3LNd8_VLD3LNd8Pseudo_VLD3LNq16_VLD3LNq16Pseudo_VLD3LNq32_VLD3LNq32Pseudo
  { 0, 0, 0, 0, 0 }, // 549 VLD3DUPd16_UPD_VLD3DUPd32_UPD_VLD3DUPd8_UPD_VLD3DUPq16_UPD_VLD3DUPq32_UPD_VLD3DUPq8_UPD
  { 0, 0, 0, 0, 0 }, // 550 VLD3LNd16_UPD_VLD3LNd32_UPD_VLD3LNd8_UPD_VLD3LNq16_UPD_VLD3LNq32_UPD
  { 0, 0, 0, 0, 0 }, // 551 VLD3DUPd16Pseudo_UPD_VLD3DUPd32Pseudo_UPD_VLD3DUPd8Pseudo_UPD
  { 0, 0, 0, 0, 0 }, // 552 VLD3LNd16Pseudo_UPD_VLD3LNd32Pseudo_UPD_VLD3LNd8Pseudo_UPD_VLD3LNq16Pseudo_UPD_VLD3LNq32Pseudo_UPD
  { 0, 0, 0, 0, 0 }, // 553 VLD4DUPd16_VLD4DUPd16Pseudo_VLD4DUPd32_VLD4DUPd32Pseudo_VLD4DUPd8_VLD4DUPd8Pseudo_VLD4DUPq16_VLD4DUPq32_VLD4DUPq8
  { 0, 0, 0, 0, 0 }, // 554 VLD4LNd16_VLD4LNd16Pseudo_VLD4LNd32_VLD4LNd32Pseudo_VLD4LNd8_VLD4LNd8Pseudo_VLD4LNq16_VLD4LNq16Pseudo_VLD4LNq32_VLD4LNq32Pseudo
  { 0, 0, 0, 0, 0 }, // 555 VLD4DUPd16_UPD_VLD4DUPd32_UPD_VLD4DUPd8_UPD_VLD4DUPq16_UPD_VLD4DUPq32_UPD_VLD4DUPq8_UPD
  { 0, 0, 0, 0, 0 }, // 556 VLD4LNd16_UPD_VLD4LNd32_UPD_VLD4LNd8_UPD_VLD4LNq16_UPD_VLD4LNq32_UPD
  { 0, 0, 0, 0, 0 }, // 557 VLD4DUPd16Pseudo_UPD_VLD4DUPd32Pseudo_UPD_VLD4DUPd8Pseudo_UPD
  { 0, 0, 0, 0, 0 }, // 558 VLD4LNd16Pseudo_UPD_VLD4LNd32Pseudo_UPD_VLD4LNd8Pseudo_UPD_VLD4LNq16Pseudo_UPD_VLD4LNq32Pseudo_UPD
  { 0, 0, 0, 0, 0 }, // 559 VST1d16_VST1d32_VST1d64_VST1d8
  { 0, 0, 0, 0, 0 }, // 560 VST1q16_VST1q32_VST1q64_VST1q8
  { 0, 0, 0, 0, 0 }, // 561 VST1d16wb_fixed_VST1d16wb_register_VST1d32wb_fixed_VST1d32wb_register_VST1d64wb_fixed_VST1d64wb_register_VST1d8wb_fixed_VST1d8wb_register
  { 0, 0, 0, 0, 0 }, // 562 VST1q16wb_fixed_VST1q16wb_register_VST1q32wb_fixed_VST1q32wb_register_VST1q64wb_fixed_VST1q64wb_register_VST1q8wb_fixed_VST1q8wb_register
  { 0, 0, 0, 0, 0 }, // 563 VST1d16T_VST1d32T_VST1d64T_VST1d64TPseudo_VST1d8T
  { 0, 0, 0, 0, 0 }, // 564 VST1d16Twb_fixed_VST1d16Twb_register_VST1d32Twb_fixed_VST1d32Twb_register_VST1d64Twb_fixed_VST1d64Twb_register_VST1d8Twb_fixed_VST1d8Twb_register
  { 0, 0, 0, 0, 0 }, // 565 VST1d64TPseudoWB_fixed_VST1d64TPseudoWB_register
  { 0, 0, 0, 0, 0 }, // 566 VST1d16Q_VST1d32Q_VST1d64Q_VST1d64QPseudo_VST1d8Q
  { 0, 0, 0, 0, 0 }, // 567 VST1d16Qwb_fixed_VST1d16Qwb_register_VST1d32Qwb_fixed_VST1d32Qwb_register_VST1d64Qwb_fixed_VST1d64Qwb_register_VST1d8Qwb_fixed_VST1d8Qwb_register
  { 0, 0, 0, 0, 0 }, // 568 VST1d64QPseudoWB_fixed_VST1d64QPseudoWB_register
  { 0, 0, 0, 0, 0 }, // 569 VST2b16_VST2b32_VST2b8_VST2d16_VST2d32_VST2d8
  { 0, 0, 0, 0, 0 }, // 570 VST2b16wb_fixed_VST2b16wb_register_VST2b32wb_fixed_VST2b32wb_register_VST2b8wb_fixed_VST2b8wb_register_VST2d16wb_fixed_VST2d16wb_register_VST2d32wb_fixed_VST2d32wb_register_VST2d8wb_fixed_VST2d8wb_register
  { 0, 0, 0, 0, 0 }, // 571 VST2q16_VST2q16Pseudo_VST2q32_VST2q32Pseudo_VST2q8_VST2q8Pseudo
  { 0, 0, 0, 0, 0 }, // 572 VST2q16PseudoWB_fixed_VST2q16PseudoWB_register_VST2q32PseudoWB_fixed_VST2q32PseudoWB_register_VST2q8PseudoWB_fixed_VST2q8PseudoWB_register
  { 0, 0, 0, 0, 0 }, // 573 VST2q16wb_fixed_VST2q16wb_register_VST2q32wb_fixed_VST2q32wb_register_VST2q8wb_fixed_VST2q8wb_register
  { 0, 0, 0, 0, 0 }, // 574 VST3d16_VST3d16Pseudo_VST3d32_VST3d32Pseudo_VST3d8_VST3d8Pseudo_VST3q16_VST3q16oddPseudo_VST3q32_VST3q32oddPseudo_VST3q8_VST3q8oddPseudo
  { 0, 0, 0, 0, 0 }, // 575 VST3d16Pseudo_UPD_VST3d16_UPD_VST3d32Pseudo_UPD_VST3d32_UPD_VST3d8Pseudo_UPD_VST3d8_UPD_VST3q16Pseudo_UPD_VST3q16_UPD_VST3q16oddPseudo_UPD_VST3q32Pseudo_UPD_VST3q32_UPD_VST3q32oddPseudo_UPD_VST3q8Pseudo_UPD_VST3q8_UPD_VST3q8oddPseudo_UPD
  { 0, 0, 0, 0, 0 }, // 576 VST4d16_VST4d16Pseudo_VST4d32_VST4d32Pseudo_VST4d8_VST4d8Pseudo_VST4q16_VST4q16oddPseudo_VST4q32_VST4q32oddPseudo_VST4q8_VST4q8oddPseudo
  { 0, 0, 0, 0, 0 }, // 577 VST4d16Pseudo_UPD_VST4d16_UPD_VST4d32Pseudo_UPD_VST4d32_UPD_VST4d8Pseudo_UPD_VST4d8_UPD_VST4q16Pseudo_UPD_VST4q16_UPD_VST4q16oddPseudo_UPD_VST4q32Pseudo_UPD_VST4q32_UPD_VST4q32oddPseudo_UPD_VST4q8Pseudo_UPD_VST4q8_UPD_VST4q8oddPseudo_UPD
  { 0, 0, 0, 0, 0 }, // 578 VST1LNd16_VST1LNd32_VST1LNd8_VST1LNq16Pseudo_VST1LNq32Pseudo_VST1LNq8Pseudo
  { 0, 0, 0, 0, 0 }, // 579 VST1LNd16_UPD_VST1LNd32_UPD_VST1LNd8_UPD_VST1LNq16Pseudo_UPD_VST1LNq32Pseudo_UPD_VST1LNq8Pseudo_UPD
  { 0, 0, 0, 0, 0 }, // 580 VST2LNd16_VST2LNd16Pseudo_VST2LNd32_VST2LNd32Pseudo_VST2LNd8_VST2LNd8Pseudo_VST2LNq16_VST2LNq16Pseudo_VST2LNq32_VST2LNq32Pseudo
  { 0, 0, 0, 0, 0 }, // 581 VST2LNd16Pseudo_UPD_VST2LNd16_UPD_VST2LNd32Pseudo_UPD_VST2LNd32_UPD_VST2LNd8Pseudo_UPD_VST2LNd8_UPD_VST2LNq16Pseudo_UPD_VST2LNq16_UPD_VST2LNq32Pseudo_UPD_VST2LNq32_UPD
  { 0, 0, 0, 0, 0 }, // 582 VST3LNd16_VST3LNd16Pseudo_VST3LNd32_VST3LNd32Pseudo_VST3LNd8_VST3LNd8Pseudo_VST3LNq16_VST3LNq16Pseudo_VST3LNq32_VST3LNq32Pseudo
  { 0, 0, 0, 0, 0 }, // 583 VST3LNd16Pseudo_UPD_VST3LNd16_UPD_VST3LNd32Pseudo_UPD_VST3LNd32_UPD_VST3LNd8Pseudo_UPD_VST3LNd8_UPD_VST3LNq16Pseudo_UPD_VST3LNq16_UPD_VST3LNq32Pseudo_UPD_VST3LNq32_UPD
  { 0, 0, 0, 0, 0 }, // 584 VST4LNd16_VST4LNd16Pseudo_VST4LNd32_VST4LNd32Pseudo_VST4LNd8_VST4LNd8Pseudo_VST4LNq16_VST4LNq16Pseudo_VST4LNq32_VST4LNq32Pseudo
  { 0, 0, 0, 0, 0 }, // 585 VST4LNd16Pseudo_UPD_VST4LNd16_UPD_VST4LNd32Pseudo_UPD_VST4LNd32_UPD_VST4LNd8Pseudo_UPD_VST4LNd8_UPD_VST4LNq16Pseudo_UPD_VST4LNq16_UPD_VST4LNq32Pseudo_UPD_VST4LNq32_UPD
  { 1, 462, 465, 5760, 5763 }, // 586 VDIVS
  { 1, 462, 465, 5763, 5765 }, // 587 VSQRTS
  { 1, 459, 462, 5765, 5768 }, // 588 VDIVD
  { 1, 459, 462, 5768, 5771 }, // 589 VSQRTD
  { 0, 0, 0, 0, 0 }, // 590 ABS
  { 0, ~0U, ~0U, ~0U, ~0U } // end marker
};

// ===============================================================
// Data tables for the new per-operand machine model.

// {ProcResourceIdx, Cycles}
extern const llvm::MCWriteProcResEntry ARMWriteProcResTable[] = {
  { 0,  0}, // Invalid
  { 2,  1}, // #1
  { 3,  1}, // #2
  { 1,  1}, // #3
  { 4,  1}, // #4
  { 1,  2}, // #5
  { 5,  1}, // #6
  { 1,  1}, // #7
  { 5,  1}, // #8
  { 1,  1}, // #9
  { 2,  1}, // #10
  { 5,  1}, // #11
  { 2,  3}, // #12
  { 6,  3}, // #13
  { 2,  2}, // #14
  { 2,  2}, // #15
  { 5,  1}, // #16
  { 2,  2}, // #17
  { 6,  2}, // #18
  { 1,  3}, // #19
  { 5,  1}, // #20
  { 1,  1}, // #21
  { 4,  2}, // #22
  { 1,  2}, // #23
  { 4,  2}, // #24
  { 1,  2}, // #25
  { 4,  2}, // #26
  { 5,  1}, // #27
  { 1,  2}, // #28
  { 4,  3}, // #29
  { 5,  2}, // #30
  { 1,  1}, // #31
  { 4,  1}, // #32
  { 5,  1}, // #33
  { 1,  2}, // #34
  { 4,  2}, // #35
  { 5,  2}, // #36
  { 1,  4}, // #37
  { 4,  4}, // #38
  { 5,  3}, // #39
  { 1,  6}, // #40
  { 4,  6}, // #41
  { 5,  5}, // #42
  { 1,  5}, // #43
  { 4,  5}, // #44
  { 5,  4}, // #45
  { 1,  2}, // #46
  { 5,  2}, // #47
  { 1,  3}, // #48
  { 5,  3}, // #49
  { 1,  4}, // #50
  { 5,  4}, // #51
  { 1,  5}, // #52
  { 5,  5}, // #53
  { 1,  6}, // #54
  { 5,  6}, // #55
  { 1,  7}, // #56
  { 5,  7}, // #57
  { 1,  8}, // #58
  { 5,  8}, // #59
  { 1,  1}, // #60
  { 3,  1}, // #61
  { 5,  1}, // #62
  { 1,  2}, // #63
  { 3,  1}, // #64
  { 5,  2}, // #65
  { 1,  3}, // #66
  { 3,  1}, // #67
  { 5,  3}, // #68
  { 1,  4}, // #69
  { 3,  1}, // #70
  { 5,  4}, // #71
  { 1,  5}, // #72
  { 3,  1}, // #73
  { 5,  5}, // #74
  { 1,  6}, // #75
  { 3,  1}, // #76
  { 5,  6}, // #77
  { 1,  7}, // #78
  { 3,  1}, // #79
  { 5,  7}, // #80
  { 1,  8}, // #81
  { 3,  1}, // #82
  { 5,  8}, // #83
  { 1,  3}, // #84
  { 4,  3}, // #85
  { 5,  3}, // #86
  { 1,  4}, // #87
  { 4,  4}, // #88
  { 5,  4}, // #89
  { 1,  5}, // #90
  { 4,  5}, // #91
  { 5,  5}, // #92
  { 1,  6}, // #93
  { 4,  6}, // #94
  { 5,  6}, // #95
  { 1,  7}, // #96
  { 4,  7}, // #97
  { 5,  7}, // #98
  { 1,  8}, // #99
  { 4,  8}, // #100
  { 5,  8}, // #101
  { 3,  1}, // #102
  { 4,  1}, // #103
  { 5,  1}, // #104
  { 4,  0}, // #105
  { 2,  2}, // #106
  { 5,  5}, // #107
  { 4,  1}, // #108
  { 5,  2}, // #109
  { 2,  1}, // #110
  { 3,  1}, // #111
  { 5,  2}, // #112
  { 2,  2}, // #113
  { 5,  3}, // #114
  { 1, 14}, // #115
  { 2,  1}, // #116
  { 5,  1}, // #117
  { 3,  2}, // #118
  { 5,  2}, // #119
  { 3,  3}, // #120
  { 5,  3}, // #121
  { 3,  4}, // #122
  { 5,  4}, // #123
  { 2,  1}, // #124
  { 4,  1}, // #125
  { 5,  1}, // #126
  { 3,  2}, // #127
  { 4,  2}, // #128
  { 5,  2}, // #129
  { 3,  1}, // #130
  { 4,  1}, // #131
  { 5,  2}, // #132
  { 2, 15}, // #133
  { 3, 15}, // #134
  { 4, 15}, // #135
  { 5, 30}, // #136
  { 4,  3}, // #137
  { 5,  1}, // #138
  { 2,  2}, // #139
  { 3,  2}, // #140
  { 4,  1}, // #141
  { 5,  4}, // #142
  { 2,  2}, // #143
  { 3,  2}, // #144
  { 4,  1}, // #145
  { 5,  5}, // #146
  { 3,  3}, // #147
  { 4,  4}, // #148
  { 5,  3}, // #149
  { 3,  3}, // #150
  { 4,  4}, // #151
  { 5,  4}, // #152
  { 2,  2}, // #153
  { 3,  4}, // #154
  { 4,  7}, // #155
  { 5,  6}, // #156
  { 2,  2}, // #157
  { 3,  4}, // #158
  { 4,  4}, // #159
  { 5,  6}, // #160
  { 2,  2}, // #161
  { 3,  4}, // #162
  { 4,  7}, // #163
  { 5,  7}, // #164
  { 2,  2}, // #165
  { 3,  4}, // #166
  { 4,  4}, // #167
  { 5,  7}, // #168
  { 3,  2}, // #169
  { 4,  1}, // #170
  { 5,  2}, // #171
  { 3,  2}, // #172
  { 4,  1}, // #173
  { 5,  3}, // #174
  { 2,  1}, // #175
  { 3,  2}, // #176
  { 4,  2}, // #177
  { 5,  3}, // #178
  { 2,  1}, // #179
  { 3,  2}, // #180
  { 4,  2}, // #181
  { 5,  4}, // #182
  { 2,  1}, // #183
  { 3,  3}, // #184
  { 4,  3}, // #185
  { 5,  4}, // #186
  { 2,  1}, // #187
  { 3,  3}, // #188
  { 4,  3}, // #189
  { 5,  5}, // #190
  { 2,  1}, // #191
  { 3,  5}, // #192
  { 4,  2}, // #193
  { 5,  6}, // #194
  { 2,  1}, // #195
  { 3,  5}, // #196
  { 4,  2}, // #197
  { 5,  7}, // #198
  { 4,  4}, // #199
  { 5,  1}, // #200
  { 3,  2}, // #201
  { 4,  4}, // #202
  { 5,  2}, // #203
  { 3,  2}, // #204
  { 4,  4}, // #205
  { 5,  3}, // #206
  { 3,  4}, // #207
  { 4,  4}, // #208
  { 5,  5}, // #209
  { 1, 15}, // #210
  { 2,  1}, // #211
  { 5,  1}, // #212
  { 1, 30}, // #213
  { 2,  1}, // #214
  { 5,  1}, // #215
  { 2,  3}, // #216
  { 5,  3}, // #217
  { 2,  2}, // #218
  { 5,  2}, // #219
  { 2,  1}, // #220
  { 5,  2}, // #221
  { 4,  5}, // #222
  { 5,  1}, // #223
  { 4,  6}, // #224
  { 5,  1}, // #225
  { 4,  7}, // #226
  { 5,  1}, // #227
  { 4,  8}, // #228
  { 5,  1}, // #229
  { 4,  9}, // #230
  { 5,  1}, // #231
  { 4, 10}, // #232
  { 5,  1}, // #233
  { 4, 11}, // #234
  { 5,  1}, // #235
  { 4, 12}, // #236
  { 5,  1}, // #237
  { 4, 13}, // #238
  { 5,  1}, // #239
  { 4, 14}, // #240
  { 5,  1}, // #241
  { 4, 15}, // #242
  { 5,  1}, // #243
  { 4, 16}, // #244
  { 5,  1}, // #245
  { 4,  5}, // #246
  { 5,  2}, // #247
  { 4,  6}, // #248
  { 5,  2}, // #249
  { 4,  7}, // #250
  { 5,  2}, // #251
  { 4,  8}, // #252
  { 5,  2}, // #253
  { 4,  9}, // #254
  { 5,  2}, // #255
  { 4, 10}, // #256
  { 5,  2}, // #257
  { 4, 11}, // #258
  { 5,  2}, // #259
  { 4, 12}, // #260
  { 5,  2}, // #261
  { 4, 13}, // #262
  { 5,  2}, // #263
  { 4, 14}, // #264
  { 5,  2}, // #265
  { 4, 15}, // #266
  { 5,  2}, // #267
  { 4, 16}, // #268
  { 5,  2}, // #269
  { 3,  1}, // #270
  { 4,  2}, // #271
  { 5,  3}, // #272
  { 3,  1}, // #273
  { 4,  3}, // #274
  { 5,  3}, // #275
  { 3,  1}, // #276
  { 4,  4}, // #277
  { 5,  3}, // #278
  { 3,  1}, // #279
  { 4,  5}, // #280
  { 5,  3}, // #281
  { 3,  1}, // #282
  { 4,  6}, // #283
  { 5,  3}, // #284
  { 3,  1}, // #285
  { 4,  7}, // #286
  { 5,  3}, // #287
  { 3,  1}, // #288
  { 4,  8}, // #289
  { 5,  3}, // #290
  { 3,  1}, // #291
  { 4,  9}, // #292
  { 5,  3}, // #293
  { 3,  1}, // #294
  { 4, 10}, // #295
  { 5,  3}, // #296
  { 3,  1}, // #297
  { 4, 11}, // #298
  { 5,  3}, // #299
  { 3,  1}, // #300
  { 4, 12}, // #301
  { 5,  3}, // #302
  { 3,  1}, // #303
  { 4, 13}, // #304
  { 5,  3}, // #305
  { 3,  1}, // #306
  { 4, 14}, // #307
  { 5,  3}, // #308
  { 3,  1}, // #309
  { 4, 15}, // #310
  { 5,  3}, // #311
  { 3,  1}, // #312
  { 4, 16}, // #313
  { 5,  3}, // #314
  { 4,  9}, // #315
  { 5,  9}, // #316
  { 4, 10}, // #317
  { 5, 10}, // #318
  { 4, 11}, // #319
  { 5, 11}, // #320
  { 4, 12}, // #321
  { 5, 12}, // #322
  { 4, 13}, // #323
  { 5, 13}, // #324
  { 4, 14}, // #325
  { 5, 14}, // #326
  { 4, 15}, // #327
  { 5, 15}, // #328
  { 4, 16}, // #329
  { 5, 16}, // #330
  { 4,  5}, // #331
  { 5,  6}, // #332
  { 4,  6}, // #333
  { 5,  7}, // #334
  { 4,  7}, // #335
  { 5,  8}, // #336
  { 4,  8}, // #337
  { 5,  9}, // #338
  { 4,  9}, // #339
  { 5, 10}, // #340
  { 4, 10}, // #341
  { 5, 11}, // #342
  { 4, 11}, // #343
  { 5, 12}, // #344
  { 4, 12}, // #345
  { 5, 13}, // #346
  { 4, 13}, // #347
  { 5, 14}, // #348
  { 4, 14}, // #349
  { 5, 15}, // #350
  { 4, 15}, // #351
  { 5, 16}, // #352
  { 4, 16}, // #353
  { 5, 17}, // #354
  { 3,  3}, // #355
  { 4,  2}, // #356
  { 5,  4}, // #357
  { 3,  5}, // #358
  { 4,  3}, // #359
  { 5,  6}, // #360
  { 3,  7}, // #361
  { 4,  3}, // #362
  { 5,  8}, // #363
  { 3,  2}, // #364
  { 4,  3}, // #365
  { 5,  3}, // #366
  { 3,  9}, // #367
  { 4,  3}, // #368
  { 5, 10}, // #369
  { 3,  5}, // #370
  { 4,  4}, // #371
  { 5,  6}, // #372
  { 3,  7}, // #373
  { 4,  5}, // #374
  { 5,  8}, // #375
  { 3,  9}, // #376
  { 4,  5}, // #377
  { 5, 10}, // #378
  { 3,  4}, // #379
  { 4,  5}, // #380
  { 5,  5}, // #381
  { 3,  3}, // #382
  { 4,  2}, // #383
  { 5,  6}, // #384
  { 3,  5}, // #385
  { 4,  2}, // #386
  { 5,  8}, // #387
  { 3,  5}, // #388
  { 4,  3}, // #389
  { 5,  8}, // #390
  { 3,  7}, // #391
  { 4,  3}, // #392
  { 5, 10}, // #393
  { 3,  2}, // #394
  { 4,  3}, // #395
  { 5,  5}, // #396
  { 3,  9}, // #397
  { 4,  3}, // #398
  { 5, 12}, // #399
  { 3,  5}, // #400
  { 4,  4}, // #401
  { 5,  8}, // #402
  { 3,  3}, // #403
  { 4,  4}, // #404
  { 5,  6}, // #405
  { 3,  7}, // #406
  { 4,  5}, // #407
  { 5, 10}, // #408
  { 3,  9}, // #409
  { 4,  5}, // #410
  { 5, 12}, // #411
  { 3,  4}, // #412
  { 4,  5}, // #413
  { 5,  7}, // #414
  { 4,  6}, // #415
  { 5,  8}, // #416
  { 4,  8}, // #417
  { 5, 10}, // #418
  { 4, 10}, // #419
  { 5, 12}, // #420
  { 4, 12}, // #421
  { 5, 14}, // #422
  { 4, 14}, // #423
  { 5, 16}, // #424
  { 4, 16}, // #425
  { 5, 18} // #426
}; // ARMWriteProcResTable

// {Cycles, WriteResourceID}
extern const llvm::MCWriteLatencyEntry ARMWriteLatencyTable[] = {
  { 0,  0}, // Invalid
  { 1,  0}, // #1 A9WriteALU_WriteBr_WriteBrL_WriteBrTbl_A9WriteFMov_WritePreLd_A9WriteB_A9WriteV1_WriteCMP_SwiftWriteP01OneCycle_SwiftWriteP0OneCycle
  { 2,  0}, // #2 WriteALUsi_A9WriteI_A9WriteV2_A9WriteIsr_WriteBrL_SwiftWriteP01TwoCycle_SwiftWriteP01OneCycle_SwiftWriteP0TwoCycle_SwiftWriteP1TwoCycle_SwiftWriteP0OneCycle
  { 3,  0}, // #3 A9WriteALUsr_A9WriteV3_SwiftWriteP01OneCycle_SwiftWriteP2ThreeCycle_SwiftWriteP01ThreeCycleTwoUops_SwiftWriteP0ThreeCycleThreeUops
  { 4, 83}, // #4 A9WriteLb
  { 2,  0}, // #5 A9WriteAdr
  { 5, 84}, // #6 A9WriteLbsi
  { 2,  0}, // #7 A9WriteAdr
  { 3, 40}, // #8 A9WriteL
  { 3, 57}, // #9 A9WriteLHi
  { 1,  0}, // #10 A9WriteAdr
  { 3, 40}, // #11 A9WriteL
  { 1,  0}, // #12 A9WriteAdr
  { 3, 40}, // #13 A9WriteL
  { 1,  0}, // #14 A9WriteAdr_A9WriteLfpOp_A9WriteLSfp_A9WriteFMov
  { 1,  0}, // #15 A9WriteALU_A9WriteS_A9WriteAdr_A9WriteFMov_A9WriteLfpOp_A9WriteLSfp
  { 4, 107}, // #16 A9WriteLsi
  { 1,  0}, // #17 A9WriteAdr
  { 4,  0}, // #18 A9WriteM_A9WriteV4_A9WriteF_A9Write2V4_WriteCvtFP_SwiftWriteP0FourCycle_SwiftWriteP2P01FourCyle_SwiftWriteP0P1FourCycle_SwiftWriteP1FourCycle_SwiftWriteP1TwoCycle_SwiftWriteP2FourCycle_SwiftWriteLM4Cy_SwiftWrite3xP2FourCy_SwiftWrite2xP2FourCy
  { 5,  0}, // #19 A9WriteMHi_A9WriteV5_A9WriteFMulS_SwiftWriteP2ThreeCycle_SwiftWriteP0P01FiveCycleTwoUops
  { 5, 40}, // #20 A9WriteL
  { 2,  0}, // #21 A9WriteAdr
  { 1,  0}, // #22 A9WriteS_SwiftWriteLDMAddrWB
  { 3,  0}, // #23 A9WriteM16_A9WriteV3_SwiftWriteP2P2ThreeCycle_SwiftWriteP2ThreeCycle_SwiftWriteLM3Cy
  { 4,  0}, // #24 A9WriteM16Hi_A9WriteV4_SwiftWriteLdFour_SwiftWriteP2FourCycle_SwiftWriteLM4Cy
  { 3,  0}, // #25 A9WriteAdr_SwiftWriteP2P01ThreeCycle
  { 1,  0}, // #26 A9WriteS_SwiftWrBackOne
  { 6,  0}, // #27 A9WriteV6_A9WriteFMulD_SwiftWriteP0P1SixCycle_SwiftWriteP1TwoCycle_SwiftWriteP0SixCycle_SwiftWriteP1SixCycle_SwiftWriteP0TwoCycle_SwiftWriteP01OneCycle
  {25,  0}, // #28 A9WriteFDivD
  {15,  0}, // #29 A9WriteFDivS
  { 2,  0}, // #30 A9WriteV2_A9WriteLfpOp_A9WriteAdr
  { 2,  0}, // #31 A9WriteV2_A9WriteAdr_A9WriteLfpOp
  { 9,  0}, // #32 A9WriteV9_A9WriteFMAD_A9Write2V9
  {10,  0}, // #33 A9WriteV10
  { 5,  0}, // #34 A9WriteLfpOp
  { 1,  0}, // #35 A9WriteAdr
  { 6,  0}, // #36 A9WriteLfpOp
  { 1,  0}, // #37 A9WriteAdr
  { 7,  0}, // #38 A9WriteLfpOp_A9Write2V7_A9WriteV7
  { 3,  0}, // #39 A9WriteAdr
  { 9,  0}, // #40 A9WriteLfpOp
  { 5,  0}, // #41 A9WriteAdr
  { 8,  0}, // #42 A9WriteLfpOp_A9WriteFMAS_SwiftWriteP1TwoCycle_SwiftWriteP1EightCycle
  { 4,  0}, // #43 A9WriteAdr
  {32,  0}, // #44 A9WriteFSqrtD_SwiftDiv32
  {17,  0}, // #45 A9WriteFSqrtS_SwiftDiv17
  { 3,  0}, // #46 A9WriteCycle1_A9WriteAdr_A9WriteLfpOp
  { 3,  0}, // #47 A9WriteCycle1_A9WriteLfpOp_A9WriteAdr
  { 1,  0}, // #48 A9WriteAdr_SwiftWriteP01OneCycle
  { 0,  0}, // #49 A9WriteIssue_SwiftWriteP2_SwiftWriteStIncAddr
  { 3,  0}, // #50 A9WriteCycle1
  { 3,  0}, // #51 A9WriteCycle1
  { 4,  0}, // #52 A9WriteCycle1_A9WriteAdr_A9WriteLfpOp_SwiftWriteP1FourCycle_SwiftWriteLM4Cy
  { 4,  0}, // #53 A9WriteCycle1_A9WriteLfpOp_A9WriteAdr_SwiftWriteP1FourCycle_SwiftWriteLM4CyNo
  { 2,  0}, // #54 A9WriteAdr_SwiftWriteP1TwoCycle_SwiftWriteP01OneCycle
  { 0,  0}, // #55 A9WriteIssue_SwiftWriteStIncAddr
  { 3,  0}, // #56 A9WriteCycle1
  { 3,  0}, // #57 A9WriteCycle1
  { 4,  0}, // #58 A9WriteCycle1
  { 4,  0}, // #59 A9WriteCycle1
  { 5,  0}, // #60 A9WriteCycle1_A9WriteAdr_A9WriteLfpOp_SwiftP0P0P01FiveCycle
  { 5,  0}, // #61 A9WriteCycle1_A9WriteLfpOp_A9WriteAdr_SwiftWrite5Cycle
  { 3,  0}, // #62 A9WriteAdr
  { 0,  0}, // #63 A9WriteIssue
  { 3,  0}, // #64 A9WriteCycle1
  { 3,  0}, // #65 A9WriteCycle1
  { 4,  0}, // #66 A9WriteCycle1
  { 4,  0}, // #67 A9WriteCycle1
  { 5,  0}, // #68 A9WriteCycle1
  { 5,  0}, // #69 A9WriteCycle1
  { 6,  0}, // #70 A9WriteCycle1_A9WriteAdr_A9WriteLfpOp
  { 6,  0}, // #71 A9WriteCycle1_A9WriteLfpOp_A9WriteAdr
  { 4,  0}, // #72 A9WriteAdr
  { 0,  0}, // #73 A9WriteIssue
  { 3,  0}, // #74 A9WriteCycle1
  { 3,  0}, // #75 A9WriteCycle1
  { 4,  0}, // #76 A9WriteCycle1
  { 4,  0}, // #77 A9WriteCycle1
  { 5,  0}, // #78 A9WriteCycle1
  { 5,  0}, // #79 A9WriteCycle1
  { 6,  0}, // #80 A9WriteCycle1
  { 6,  0}, // #81 A9WriteCycle1_SwiftWriteP1TwoCycle
  { 7,  0}, // #82 A9WriteCycle1_A9WriteAdr_A9WriteLfpOp_SwiftWriteP1TwoCycle
  { 7,  0}, // #83 A9WriteCycle1_A9WriteLfpOp_A9WriteAdr
  { 5,  0}, // #84 A9WriteAdr
  { 0,  0}, // #85 A9WriteIssue
  { 3,  0}, // #86 A9WriteCycle1
  { 3,  0}, // #87 A9WriteCycle1
  { 4,  0}, // #88 A9WriteCycle1
  { 4,  0}, // #89 A9WriteCycle1
  { 5,  0}, // #90 A9WriteCycle1
  { 5,  0}, // #91 A9WriteCycle1
  { 6,  0}, // #92 A9WriteCycle1
  { 6,  0}, // #93 A9WriteCycle1
  { 7,  0}, // #94 A9WriteCycle1
  { 7,  0}, // #95 A9WriteCycle1
  { 8,  0}, // #96 A9WriteCycle1_A9WriteAdr_A9WriteLfpOp
  { 8,  0}, // #97 A9WriteCycle1_A9WriteLfpOp_A9WriteAdr
  { 6,  0}, // #98 A9WriteAdr_SwiftWriteLM6Cy
  { 0,  0}, // #99 A9WriteIssue_SwiftVLDMPerm2
  { 3,  0}, // #100 A9WriteCycle1
  { 3,  0}, // #101 A9WriteCycle1
  { 4,  0}, // #102 A9WriteCycle1
  { 4,  0}, // #103 A9WriteCycle1
  { 5,  0}, // #104 A9WriteCycle1
  { 5,  0}, // #105 A9WriteCycle1
  { 6,  0}, // #106 A9WriteCycle1
  { 6,  0}, // #107 A9WriteCycle1
  { 7,  0}, // #108 A9WriteCycle1
  { 7,  0}, // #109 A9WriteCycle1
  { 8,  0}, // #110 A9WriteCycle1
  { 8,  0}, // #111 A9WriteCycle1
  { 9,  0}, // #112 A9WriteCycle1
  { 9,  0}, // #113 A9WriteCycle1
  { 7,  0}, // #114 A9WriteAdr
  { 0,  0}, // #115 A9WriteIssue
  { 3,  0}, // #116 A9WriteCycle1
  { 3,  0}, // #117 A9WriteCycle1
  { 4,  0}, // #118 A9WriteCycle1
  { 4,  0}, // #119 A9WriteCycle1
  { 5,  0}, // #120 A9WriteCycle1
  { 5,  0}, // #121 A9WriteCycle1
  { 6,  0}, // #122 A9WriteCycle1
  { 6,  0}, // #123 A9WriteCycle1
  { 7,  0}, // #124 A9WriteCycle1
  { 7,  0}, // #125 A9WriteCycle1
  { 8,  0}, // #126 A9WriteCycle1
  { 8,  0}, // #127 A9WriteCycle1
  { 9,  0}, // #128 A9WriteCycle1
  { 9,  0}, // #129 A9WriteCycle1
  {10,  0}, // #130 A9WriteCycle1
  {10,  0}, // #131 A9WriteCycle1
  { 8,  0}, // #132 A9WriteAdr
  { 0,  0}, // #133 A9WriteIssue
  { 3,  0}, // #134 A9WriteCycle1
  { 3,  0}, // #135 A9WriteCycle1
  { 4,  0}, // #136 A9WriteCycle1
  { 4,  0}, // #137 A9WriteCycle1
  { 5,  0}, // #138 A9WriteCycle1
  { 5,  0}, // #139 A9WriteCycle1
  { 6,  0}, // #140 A9WriteCycle1
  { 6,  0}, // #141 A9WriteCycle1
  { 7,  0}, // #142 A9WriteCycle1
  { 7,  0}, // #143 A9WriteCycle1
  { 8,  0}, // #144 A9WriteCycle1
  { 8,  0}, // #145 A9WriteCycle1
  { 9,  0}, // #146 A9WriteCycle1
  { 9,  0}, // #147 A9WriteCycle1
  {10,  0}, // #148 A9WriteCycle1
  {10,  0}, // #149 A9WriteCycle1
  { 2,  0}, // #150 A9WriteAdr
  { 0,  0}, // #151 A9WriteIssue
  { 1,  0}, // #152 A9WriteAdr
  { 3,  0}, // #153 A9WriteCycle1
  { 3,  0}, // #154 A9WriteCycle1
  { 0,  0}, // #155 A9WriteIssue
  { 2,  0}, // #156 A9WriteAdr
  { 3,  0}, // #157 A9WriteCycle1
  { 3,  0}, // #158 A9WriteCycle1
  { 4,  0}, // #159 A9WriteCycle1
  { 4,  0}, // #160 A9WriteCycle1
  { 0,  0}, // #161 A9WriteIssue
  { 3,  0}, // #162 A9WriteAdr
  { 3,  0}, // #163 A9WriteCycle1
  { 3,  0}, // #164 A9WriteCycle1
  { 4,  0}, // #165 A9WriteCycle1
  { 4,  0}, // #166 A9WriteCycle1
  { 5,  0}, // #167 A9WriteCycle1
  { 5,  0}, // #168 A9WriteCycle1
  { 0,  0}, // #169 A9WriteIssue
  { 4,  0}, // #170 A9WriteAdr
  { 3,  0}, // #171 A9WriteCycle1
  { 3,  0}, // #172 A9WriteCycle1
  { 4,  0}, // #173 A9WriteCycle1
  { 4,  0}, // #174 A9WriteCycle1
  { 5,  0}, // #175 A9WriteCycle1
  { 5,  0}, // #176 A9WriteCycle1
  { 6,  0}, // #177 A9WriteCycle1
  { 6,  0}, // #178 A9WriteCycle1
  { 0,  0}, // #179 A9WriteIssue
  { 5,  0}, // #180 A9WriteAdr
  { 3,  0}, // #181 A9WriteCycle1
  { 3,  0}, // #182 A9WriteCycle1
  { 4,  0}, // #183 A9WriteCycle1
  { 4,  0}, // #184 A9WriteCycle1
  { 5,  0}, // #185 A9WriteCycle1
  { 5,  0}, // #186 A9WriteCycle1
  { 6,  0}, // #187 A9WriteCycle1
  { 6,  0}, // #188 A9WriteCycle1
  { 7,  0}, // #189 A9WriteCycle1
  { 7,  0}, // #190 A9WriteCycle1
  { 0,  0}, // #191 A9WriteIssue
  { 6,  0}, // #192 A9WriteAdr
  { 3,  0}, // #193 A9WriteCycle1
  { 3,  0}, // #194 A9WriteCycle1
  { 4,  0}, // #195 A9WriteCycle1
  { 4,  0}, // #196 A9WriteCycle1
  { 5,  0}, // #197 A9WriteCycle1
  { 5,  0}, // #198 A9WriteCycle1
  { 6,  0}, // #199 A9WriteCycle1
  { 6,  0}, // #200 A9WriteCycle1
  { 7,  0}, // #201 A9WriteCycle1
  { 7,  0}, // #202 A9WriteCycle1
  { 8,  0}, // #203 A9WriteCycle1
  { 8,  0}, // #204 A9WriteCycle1
  { 0,  0}, // #205 A9WriteIssue
  { 7,  0}, // #206 A9WriteAdr
  { 3,  0}, // #207 A9WriteCycle1
  { 3,  0}, // #208 A9WriteCycle1
  { 4,  0}, // #209 A9WriteCycle1
  { 4,  0}, // #210 A9WriteCycle1
  { 5,  0}, // #211 A9WriteCycle1
  { 5,  0}, // #212 A9WriteCycle1
  { 6,  0}, // #213 A9WriteCycle1
  { 6,  0}, // #214 A9WriteCycle1
  { 7,  0}, // #215 A9WriteCycle1
  { 7,  0}, // #216 A9WriteCycle1
  { 8,  0}, // #217 A9WriteCycle1
  { 8,  0}, // #218 A9WriteCycle1
  { 9,  0}, // #219 A9WriteCycle1
  { 9,  0}, // #220 A9WriteCycle1
  { 0,  0}, // #221 A9WriteIssue
  { 8,  0}, // #222 A9WriteAdr
  { 3,  0}, // #223 A9WriteCycle1
  { 3,  0}, // #224 A9WriteCycle1
  { 4,  0}, // #225 A9WriteCycle1
  { 4,  0}, // #226 A9WriteCycle1
  { 5,  0}, // #227 A9WriteCycle1
  { 5,  0}, // #228 A9WriteCycle1
  { 6,  0}, // #229 A9WriteCycle1
  { 6,  0}, // #230 A9WriteCycle1
  { 7,  0}, // #231 A9WriteCycle1
  { 7,  0}, // #232 A9WriteCycle1
  { 8,  0}, // #233 A9WriteCycle1
  { 8,  0}, // #234 A9WriteCycle1
  { 9,  0}, // #235 A9WriteCycle1
  { 9,  0}, // #236 A9WriteCycle1
  {10,  0}, // #237 A9WriteCycle1
  {10,  0}, // #238 A9WriteCycle1
  { 0,  0}, // #239 A9WriteIssue
  { 2,  0}, // #240 A9WriteAdr
  { 3,  0}, // #241 A9WriteCycle1
  { 3,  0}, // #242 A9WriteCycle1
  { 4,  0}, // #243 A9WriteCycle1
  { 4,  0}, // #244 A9WriteCycle1
  { 5,  0}, // #245 A9WriteCycle1
  { 5,  0}, // #246 A9WriteCycle1
  { 6,  0}, // #247 A9WriteCycle1
  { 6,  0}, // #248 A9WriteCycle1
  { 7,  0}, // #249 A9WriteCycle1
  { 7,  0}, // #250 A9WriteCycle1
  { 8,  0}, // #251 A9WriteCycle1
  { 8,  0}, // #252 A9WriteCycle1
  { 9,  0}, // #253 A9WriteCycle1
  { 9,  0}, // #254 A9WriteCycle1
  {10,  0}, // #255 A9WriteCycle1
  {10,  0}, // #256 A9WriteCycle1
  { 0,  0}, // #257 A9WriteIssue
  { 3,  0}, // #258 A9WriteCycle1
  { 3,  0}, // #259 A9WriteCycle1
  { 1,  0}, // #260 A9WriteAdr
  { 1,  0}, // #261 A9WriteB_A9WriteCycle1
  { 3,  0}, // #262 A9WriteCycle1
  { 3,  0}, // #263 A9WriteCycle1
  { 4,  0}, // #264 A9WriteCycle1
  { 4,  0}, // #265 A9WriteCycle1
  { 2,  0}, // #266 A9WriteAdr
  { 1,  0}, // #267 A9WriteB
  { 3,  0}, // #268 A9WriteCycle1
  { 3,  0}, // #269 A9WriteCycle1
  { 4,  0}, // #270 A9WriteCycle1
  { 4,  0}, // #271 A9WriteCycle1
  { 5,  0}, // #272 A9WriteCycle1
  { 5,  0}, // #273 A9WriteCycle1
  { 3,  0}, // #274 A9WriteAdr
  { 1,  0}, // #275 A9WriteB
  { 3,  0}, // #276 A9WriteCycle1
  { 3,  0}, // #277 A9WriteCycle1
  { 4,  0}, // #278 A9WriteCycle1
  { 4,  0}, // #279 A9WriteCycle1
  { 5,  0}, // #280 A9WriteCycle1
  { 5,  0}, // #281 A9WriteCycle1
  { 6,  0}, // #282 A9WriteCycle1
  { 6,  0}, // #283 A9WriteCycle1
  { 4,  0}, // #284 A9WriteAdr_SwiftWriteP2P01P01FourCycle_SwiftWriteLM4Cy_SwiftWrite3xP2FourCy_SwiftWrite2xP2FourCy
  { 1,  0}, // #285 A9WriteB_SwiftWrBackOne_SwiftWriteP01OneCycle
  { 3,  0}, // #286 A9WriteCycle1
  { 3,  0}, // #287 A9WriteCycle1
  { 4,  0}, // #288 A9WriteCycle1
  { 4,  0}, // #289 A9WriteCycle1
  { 5,  0}, // #290 A9WriteCycle1
  { 5,  0}, // #291 A9WriteCycle1
  { 6,  0}, // #292 A9WriteCycle1
  { 6,  0}, // #293 A9WriteCycle1
  { 7,  0}, // #294 A9WriteCycle1
  { 7,  0}, // #295 A9WriteCycle1
  { 5,  0}, // #296 A9WriteAdr
  { 1,  0}, // #297 A9WriteB
  { 3,  0}, // #298 A9WriteCycle1
  { 3,  0}, // #299 A9WriteCycle1
  { 4,  0}, // #300 A9WriteCycle1
  { 4,  0}, // #301 A9WriteCycle1
  { 5,  0}, // #302 A9WriteCycle1
  { 5,  0}, // #303 A9WriteCycle1
  { 6,  0}, // #304 A9WriteCycle1
  { 6,  0}, // #305 A9WriteCycle1
  { 7,  0}, // #306 A9WriteCycle1
  { 7,  0}, // #307 A9WriteCycle1
  { 8,  0}, // #308 A9WriteCycle1
  { 8,  0}, // #309 A9WriteCycle1
  { 6,  0}, // #310 A9WriteAdr
  { 1,  0}, // #311 A9WriteB
  { 3,  0}, // #312 A9WriteCycle1
  { 3,  0}, // #313 A9WriteCycle1
  { 4,  0}, // #314 A9WriteCycle1
  { 4,  0}, // #315 A9WriteCycle1
  { 5,  0}, // #316 A9WriteCycle1
  { 5,  0}, // #317 A9WriteCycle1
  { 6,  0}, // #318 A9WriteCycle1
  { 6,  0}, // #319 A9WriteCycle1
  { 7,  0}, // #320 A9WriteCycle1
  { 7,  0}, // #321 A9WriteCycle1
  { 8,  0}, // #322 A9WriteCycle1
  { 8,  0}, // #323 A9WriteCycle1
  { 9,  0}, // #324 A9WriteCycle1
  { 9,  0}, // #325 A9WriteCycle1
  { 7,  0}, // #326 A9WriteAdr
  { 1,  0}, // #327 A9WriteB
  { 3,  0}, // #328 A9WriteCycle1
  { 3,  0}, // #329 A9WriteCycle1
  { 4,  0}, // #330 A9WriteCycle1
  { 4,  0}, // #331 A9WriteCycle1
  { 5,  0}, // #332 A9WriteCycle1
  { 5,  0}, // #333 A9WriteCycle1
  { 6,  0}, // #334 A9WriteCycle1
  { 6,  0}, // #335 A9WriteCycle1
  { 7,  0}, // #336 A9WriteCycle1
  { 7,  0}, // #337 A9WriteCycle1
  { 8,  0}, // #338 A9WriteCycle1
  { 8,  0}, // #339 A9WriteCycle1
  { 9,  0}, // #340 A9WriteCycle1
  { 9,  0}, // #341 A9WriteCycle1
  {10,  0}, // #342 A9WriteCycle1
  {10,  0}, // #343 A9WriteCycle1
  { 8,  0}, // #344 A9WriteAdr
  { 1,  0}, // #345 A9WriteB
  { 3,  0}, // #346 A9WriteCycle1
  { 3,  0}, // #347 A9WriteCycle1
  { 4,  0}, // #348 A9WriteCycle1
  { 4,  0}, // #349 A9WriteCycle1
  { 5,  0}, // #350 A9WriteCycle1
  { 5,  0}, // #351 A9WriteCycle1
  { 6,  0}, // #352 A9WriteCycle1
  { 6,  0}, // #353 A9WriteCycle1
  { 7,  0}, // #354 A9WriteCycle1
  { 7,  0}, // #355 A9WriteCycle1
  { 8,  0}, // #356 A9WriteCycle1
  { 8,  0}, // #357 A9WriteCycle1
  { 9,  0}, // #358 A9WriteCycle1
  { 9,  0}, // #359 A9WriteCycle1
  {10,  0}, // #360 A9WriteCycle1
  {10,  0}, // #361 A9WriteCycle1
  { 2,  0}, // #362 A9WriteAdr
  { 1,  0}, // #363 A9WriteB
  { 2,  0}, // #364 A9WriteAdr
  { 1,  0}, // #365 A9WriteCycle1
  { 2,  0}, // #366 A9WriteCycle1_SwiftWriteP01OneCycle
  { 4,  0}, // #367 A9WriteCycle1_SwiftWriteLM4Cy
  { 4,  0}, // #368 A9WriteCycle1_SwiftWriteLM4CyNo
  { 3,  0}, // #369 A9WriteAdr
  { 1,  0}, // #370 A9WriteCycle1
  { 2,  0}, // #371 A9WriteCycle1
  { 3,  0}, // #372 A9WriteCycle1
  { 4,  0}, // #373 A9WriteCycle1
  { 5,  0}, // #374 A9WriteCycle1
  { 5,  0}, // #375 A9WriteCycle1
  { 4,  0}, // #376 A9WriteAdr
  { 1,  0}, // #377 A9WriteCycle1
  { 2,  0}, // #378 A9WriteCycle1
  { 3,  0}, // #379 A9WriteCycle1
  { 4,  0}, // #380 A9WriteCycle1
  { 5,  0}, // #381 A9WriteCycle1
  { 5,  0}, // #382 A9WriteCycle1
  { 6,  0}, // #383 A9WriteCycle1
  { 6,  0}, // #384 A9WriteCycle1
  { 5,  0}, // #385 A9WriteAdr
  { 1,  0}, // #386 A9WriteCycle1
  { 2,  0}, // #387 A9WriteCycle1
  { 3,  0}, // #388 A9WriteCycle1
  { 4,  0}, // #389 A9WriteCycle1
  { 5,  0}, // #390 A9WriteCycle1
  { 5,  0}, // #391 A9WriteCycle1
  { 6,  0}, // #392 A9WriteCycle1
  { 6,  0}, // #393 A9WriteCycle1
  { 7,  0}, // #394 A9WriteCycle1
  { 7,  0}, // #395 A9WriteCycle1
  { 6,  0}, // #396 A9WriteAdr
  { 1,  0}, // #397 A9WriteCycle1
  { 2,  0}, // #398 A9WriteCycle1
  { 3,  0}, // #399 A9WriteCycle1
  { 4,  0}, // #400 A9WriteCycle1
  { 5,  0}, // #401 A9WriteCycle1
  { 6,  0}, // #402 A9WriteCycle1
  { 6,  0}, // #403 A9WriteCycle1
  { 6,  0}, // #404 A9WriteCycle1
  { 7,  0}, // #405 A9WriteCycle1
  { 7,  0}, // #406 A9WriteCycle1
  { 8,  0}, // #407 A9WriteCycle1
  { 8,  0}, // #408 A9WriteCycle1
  { 7,  0}, // #409 A9WriteAdr
  { 1,  0}, // #410 A9WriteCycle1
  { 2,  0}, // #411 A9WriteCycle1
  { 3,  0}, // #412 A9WriteCycle1
  { 4,  0}, // #413 A9WriteCycle1
  { 5,  0}, // #414 A9WriteCycle1
  { 6,  0}, // #415 A9WriteCycle1
  { 7,  0}, // #416 A9WriteCycle1
  { 6,  0}, // #417 A9WriteCycle1
  { 7,  0}, // #418 A9WriteCycle1
  { 7,  0}, // #419 A9WriteCycle1
  { 8,  0}, // #420 A9WriteCycle1
  { 8,  0}, // #421 A9WriteCycle1
  { 9,  0}, // #422 A9WriteCycle1
  { 9,  0}, // #423 A9WriteCycle1
  { 8,  0}, // #424 A9WriteAdr
  { 1,  0}, // #425 A9WriteCycle1
  { 2,  0}, // #426 A9WriteCycle1
  { 3,  0}, // #427 A9WriteCycle1
  { 4,  0}, // #428 A9WriteCycle1
  { 5,  0}, // #429 A9WriteCycle1
  { 6,  0}, // #430 A9WriteCycle1
  { 7,  0}, // #431 A9WriteCycle1
  { 8,  0}, // #432 A9WriteCycle1
  { 7,  0}, // #433 A9WriteCycle1
  { 7,  0}, // #434 A9WriteCycle1
  { 8,  0}, // #435 A9WriteCycle1
  { 8,  0}, // #436 A9WriteCycle1
  { 9,  0}, // #437 A9WriteCycle1
  { 9,  0}, // #438 A9WriteCycle1
  {10,  0}, // #439 A9WriteCycle1
  {10,  0}, // #440 A9WriteCycle1
  { 2,  0}, // #441 A9WriteAdr
  { 1,  0}, // #442 A9WriteCycle1
  { 2,  0}, // #443 A9WriteCycle1
  { 5,  0}, // #444 A9WriteCycle1
  { 6,  0}, // #445 A9WriteCycle1
  { 7,  0}, // #446 A9WriteCycle1
  { 8,  0}, // #447 A9WriteCycle1
  { 9,  0}, // #448 A9WriteCycle1
  {10,  0}, // #449 A9WriteCycle1
  { 7,  0}, // #450 A9WriteCycle1
  { 7,  0}, // #451 A9WriteCycle1
  { 8,  0}, // #452 A9WriteCycle1
  { 8,  0}, // #453 A9WriteCycle1
  { 9,  0}, // #454 A9WriteCycle1
  { 9,  0}, // #455 A9WriteCycle1
  {10,  0}, // #456 A9WriteCycle1
  {10,  0}, // #457 A9WriteCycle1
  { 1,  0}, // #458 A9WriteCycle1
  { 3,  0}, // #459 A9WriteCycle1
  { 1,  0}, // #460 A9WriteAdr
  { 1,  0}, // #461 A9WriteCycle1
  { 2,  0}, // #462 A9WriteCycle1
  { 4,  0}, // #463 A9WriteCycle1
  { 4,  0}, // #464 A9WriteCycle1
  { 2,  0}, // #465 A9WriteAdr
  { 1,  0}, // #466 A9WriteCycle1
  { 2,  0}, // #467 A9WriteCycle1
  { 3,  0}, // #468 A9WriteCycle1
  { 4,  0}, // #469 A9WriteCycle1
  { 5,  0}, // #470 A9WriteCycle1
  { 5,  0}, // #471 A9WriteCycle1
  { 3,  0}, // #472 A9WriteAdr
  { 1,  0}, // #473 A9WriteCycle1
  { 2,  0}, // #474 A9WriteCycle1
  { 3,  0}, // #475 A9WriteCycle1
  { 4,  0}, // #476 A9WriteCycle1
  { 5,  0}, // #477 A9WriteCycle1
  { 5,  0}, // #478 A9WriteCycle1
  { 6,  0}, // #479 A9WriteCycle1
  { 6,  0}, // #480 A9WriteCycle1
  { 4,  0}, // #481 A9WriteAdr
  { 1,  0}, // #482 A9WriteCycle1
  { 2,  0}, // #483 A9WriteCycle1
  { 3,  0}, // #484 A9WriteCycle1
  { 4,  0}, // #485 A9WriteCycle1
  { 5,  0}, // #486 A9WriteCycle1
  { 5,  0}, // #487 A9WriteCycle1
  { 6,  0}, // #488 A9WriteCycle1
  { 6,  0}, // #489 A9WriteCycle1
  { 7,  0}, // #490 A9WriteCycle1
  { 7,  0}, // #491 A9WriteCycle1
  { 5,  0}, // #492 A9WriteAdr
  { 1,  0}, // #493 A9WriteCycle1
  { 2,  0}, // #494 A9WriteCycle1
  { 3,  0}, // #495 A9WriteCycle1
  { 4,  0}, // #496 A9WriteCycle1
  { 5,  0}, // #497 A9WriteCycle1
  { 6,  0}, // #498 A9WriteCycle1
  { 6,  0}, // #499 A9WriteCycle1
  { 6,  0}, // #500 A9WriteCycle1
  { 7,  0}, // #501 A9WriteCycle1
  { 7,  0}, // #502 A9WriteCycle1
  { 8,  0}, // #503 A9WriteCycle1
  { 8,  0}, // #504 A9WriteCycle1
  { 6,  0}, // #505 A9WriteAdr
  { 1,  0}, // #506 A9WriteCycle1
  { 2,  0}, // #507 A9WriteCycle1
  { 3,  0}, // #508 A9WriteCycle1
  { 4,  0}, // #509 A9WriteCycle1
  { 5,  0}, // #510 A9WriteCycle1
  { 6,  0}, // #511 A9WriteCycle1
  { 7,  0}, // #512 A9WriteCycle1
  { 6,  0}, // #513 A9WriteCycle1
  { 7,  0}, // #514 A9WriteCycle1
  { 7,  0}, // #515 A9WriteCycle1
  { 8,  0}, // #516 A9WriteCycle1
  { 8,  0}, // #517 A9WriteCycle1
  { 9,  0}, // #518 A9WriteCycle1
  { 9,  0}, // #519 A9WriteCycle1
  { 7,  0}, // #520 A9WriteAdr
  { 1,  0}, // #521 A9WriteCycle1
  { 2,  0}, // #522 A9WriteCycle1
  { 3,  0}, // #523 A9WriteCycle1
  { 4,  0}, // #524 A9WriteCycle1
  { 5,  0}, // #525 A9WriteCycle1
  { 6,  0}, // #526 A9WriteCycle1
  { 7,  0}, // #527 A9WriteCycle1
  { 8,  0}, // #528 A9WriteCycle1
  { 7,  0}, // #529 A9WriteCycle1
  { 7,  0}, // #530 A9WriteCycle1
  { 8,  0}, // #531 A9WriteCycle1
  { 8,  0}, // #532 A9WriteCycle1
  { 9,  0}, // #533 A9WriteCycle1
  { 9,  0}, // #534 A9WriteCycle1
  {10,  0}, // #535 A9WriteCycle1
  {10,  0}, // #536 A9WriteCycle1
  { 8,  0}, // #537 A9WriteAdr
  { 1,  0}, // #538 A9WriteCycle1
  { 2,  0}, // #539 A9WriteCycle1
  { 5,  0}, // #540 A9WriteCycle1
  { 6,  0}, // #541 A9WriteCycle1
  { 7,  0}, // #542 A9WriteCycle1
  { 8,  0}, // #543 A9WriteCycle1
  { 9,  0}, // #544 A9WriteCycle1
  {10,  0}, // #545 A9WriteCycle1
  { 7,  0}, // #546 A9WriteCycle1
  { 7,  0}, // #547 A9WriteCycle1
  { 8,  0}, // #548 A9WriteCycle1
  { 8,  0}, // #549 A9WriteCycle1
  { 9,  0}, // #550 A9WriteCycle1
  { 9,  0}, // #551 A9WriteCycle1
  {10,  0}, // #552 A9WriteCycle1
  {10,  0}, // #553 A9WriteCycle1
  { 2,  0}, // #554 A9WriteAdr
  { 5,  0}, // #555 SwiftWrite5Cycle
  { 7,  0}, // #556 Swift2P03P01FiveCycle
  {14,  0}, // #557 SwiftDiv
  { 3,  0}, // #558 SwiftWriteP2P2P01ThreeCycle
  { 4,  0}, // #559 SwiftWriteLdFour
  { 1,  0}, // #560 SwiftWrBackOne_SwiftWriteP01OneCycle
  { 0,  0}, // #561 SwiftWriteP2
  { 0,  0}, // #562 SwiftWriteP2_SwiftVLDMPerm1_SwiftVLDMPerm2_SwiftVLDMPerm4
  { 1,  0}, // #563 SwiftWriteP01OneCycle
  {12,  0}, // #564 SwiftWriteP1TwelveCyc
  {15,  0}, // #565 SwiftWaitP0For15Cy
  {15,  0}, // #566 SwiftWaitP1For15Cy
  {15,  0}, // #567 SwiftWaitP2For15Cy
  { 9,  0}, // #568 SwiftWriteLM9Cy
  { 0,  0}, // #569 SwiftExt2xP0
  { 0,  0}, // #570 SwiftVLDMPerm2
  { 9,  0}, // #571 SwiftWriteLM9Cy
  { 1,  0}, // #572 SwiftWriteP01OneCycle
  { 0,  0}, // #573 SwiftExt2xP0
  { 0,  0}, // #574 SwiftVLDMPerm2
  { 9,  0}, // #575 SwiftWriteLM9Cy
  { 9,  0}, // #576 SwiftWriteLM9CyNo
  { 9,  0}, // #577 SwiftWriteLM9CyNo
  { 0,  0}, // #578 SwiftVLDMPerm3
  { 4,  0}, // #579 SwiftWrite3xP2FourCy
  { 9,  0}, // #580 SwiftWriteLM9Cy
  { 9,  0}, // #581 SwiftWriteLM9CyNo
  { 9,  0}, // #582 SwiftWriteLM9CyNo
  { 1,  0}, // #583 SwiftWriteP01OneCycle
  { 0,  0}, // #584 SwiftVLDMPerm3
  { 4,  0}, // #585 SwiftWrite3xP2FourCy
  {11,  0}, // #586 SwiftWriteLM11Cy
  {11,  0}, // #587 SwiftWriteLM11Cy
  {11,  0}, // #588 SwiftWriteLM11Cy
  {11,  0}, // #589 SwiftWriteLM11Cy
  { 0,  0}, // #590 SwiftExt2xP0
  { 0,  0}, // #591 SwiftVLDMPerm4
  { 4,  0}, // #592 SwiftWrite3xP2FourCy
  {11,  0}, // #593 SwiftWriteLM11Cy
  {11,  0}, // #594 SwiftWriteLM11Cy
  {11,  0}, // #595 SwiftWriteLM11Cy
  {11,  0}, // #596 SwiftWriteLM11Cy
  { 1,  0}, // #597 SwiftWriteP01OneCycle
  { 0,  0}, // #598 SwiftExt2xP0
  { 0,  0}, // #599 SwiftVLDMPerm4
  { 4,  0}, // #600 SwiftWrite3xP2FourCy
  { 6,  0}, // #601 SwiftWriteLM6Cy
  { 1,  0}, // #602 SwiftWriteP01OneCycle
  { 0,  0}, // #603 SwiftVLDMPerm2
  { 6,  0}, // #604 SwiftWriteLM6Cy
  { 6,  0}, // #605 SwiftWriteLM6Cy
  { 0,  0}, // #606 SwiftExt1xP0
  { 0,  0}, // #607 SwiftVLDMPerm2
  { 6,  0}, // #608 SwiftWriteLM6Cy
  { 6,  0}, // #609 SwiftWriteLM6Cy
  { 1,  0}, // #610 SwiftWriteP01OneCycle
  { 0,  0}, // #611 SwiftExt1xP0
  { 0,  0}, // #612 SwiftVLDMPerm2
  { 6,  0}, // #613 SwiftWriteLM6Cy
  { 1,  0}, // #614 SwiftWriteP01OneCycle
  { 6,  0}, // #615 SwiftWriteLM6Cy
  { 0,  0}, // #616 SwiftExt1xP0
  { 0,  0}, // #617 SwiftVLDMPerm2
  { 7,  0}, // #618 SwiftWriteLM7Cy
  { 8,  0}, // #619 SwiftWriteLM8Cy
  { 8,  0}, // #620 SwiftWriteLM8Cy
  { 0,  0}, // #621 SwiftExt1xP0
  { 0,  0}, // #622 SwiftVLDMPerm3
  { 7,  0}, // #623 SwiftWriteLM7Cy
  { 8,  0}, // #624 SwiftWriteLM8Cy
  { 8,  0}, // #625 SwiftWriteLM8Cy
  { 1,  0}, // #626 SwiftWriteP01OneCycle
  { 0,  0}, // #627 SwiftExt1xP0
  { 0,  0}, // #628 SwiftVLDMPerm3
  { 7,  0}, // #629 SwiftWriteLM7Cy
  { 1,  0}, // #630 SwiftWriteP01OneCycle
  { 8,  0}, // #631 SwiftWriteLM8Cy
  { 8,  0}, // #632 SwiftWriteLM8Cy
  { 0,  0}, // #633 SwiftExt1xP0
  { 0,  0}, // #634 SwiftVLDMPerm3
  { 8,  0}, // #635 SwiftWriteLM8Cy
  { 9,  0}, // #636 SwiftWriteLM9Cy
  {10,  0}, // #637 SwiftWriteLM10CyNo
  {10,  0}, // #638 SwiftWriteLM10CyNo
  { 0,  0}, // #639 SwiftExt1xP0
  { 0,  0}, // #640 SwiftVLDMPerm5
  { 8,  0}, // #641 SwiftWriteLM8Cy
  { 9,  0}, // #642 SwiftWriteLM9Cy
  {10,  0}, // #643 SwiftWriteLM10CyNo
  {10,  0}, // #644 SwiftWriteLM10CyNo
  { 1,  0}, // #645 SwiftWriteP01OneCycle
  { 0,  0}, // #646 SwiftExt1xP0
  { 0,  0}, // #647 SwiftVLDMPerm5
  { 8,  0}, // #648 SwiftWriteLM8Cy
  { 1,  0}, // #649 SwiftWriteP01OneCycle
  { 9,  0}, // #650 SwiftWriteLM9Cy
  {10,  0}, // #651 SwiftWriteLM10CyNo
  {10,  0}, // #652 SwiftWriteLM10CyNo
  { 0,  0}, // #653 SwiftExt1xP0
  { 0,  0}, // #654 SwiftVLDMPerm5
  { 3,  0}, // #655 SwiftWriteLM3Cy
  { 4,  0}, // #656 SwiftWriteLM4Cy
  { 0,  0}, // #657 SwiftWriteLDMAddrNoWB
  { 3,  0}, // #658 SwiftWriteLM3Cy
  { 4,  0}, // #659 SwiftWriteLM4Cy
  { 5,  0}, // #660 SwiftWriteLM5Cy
  { 0,  0}, // #661 SwiftWriteLDMAddrNoWB
  { 3,  0}, // #662 SwiftWriteLM3Cy
  { 4,  0}, // #663 SwiftWriteLM4Cy
  { 5,  0}, // #664 SwiftWriteLM5Cy
  { 6,  0}, // #665 SwiftWriteLM6Cy
  { 0,  0}, // #666 SwiftWriteLDMAddrNoWB
  { 3,  0}, // #667 SwiftWriteLM3Cy
  { 4,  0}, // #668 SwiftWriteLM4Cy
  { 5,  0}, // #669 SwiftWriteLM5Cy
  { 6,  0}, // #670 SwiftWriteLM6Cy
  { 7,  0}, // #671 SwiftWriteLM7Cy
  { 0,  0}, // #672 SwiftWriteLDMAddrNoWB
  { 3,  0}, // #673 SwiftWriteLM3Cy
  { 4,  0}, // #674 SwiftWriteLM4Cy
  { 5,  0}, // #675 SwiftWriteLM5Cy
  { 6,  0}, // #676 SwiftWriteLM6Cy
  { 7,  0}, // #677 SwiftWriteLM7Cy
  { 8,  0}, // #678 SwiftWriteLM8Cy
  { 0,  0}, // #679 SwiftWriteLDMAddrNoWB
  { 3,  0}, // #680 SwiftWriteLM3Cy
  { 4,  0}, // #681 SwiftWriteLM4Cy
  { 5,  0}, // #682 SwiftWriteLM5Cy
  { 6,  0}, // #683 SwiftWriteLM6Cy
  { 7,  0}, // #684 SwiftWriteLM7Cy
  { 8,  0}, // #685 SwiftWriteLM8Cy
  { 9,  0}, // #686 SwiftWriteLM9Cy
  { 0,  0}, // #687 SwiftWriteLDMAddrNoWB
  { 3,  0}, // #688 SwiftWriteLM3Cy
  { 4,  0}, // #689 SwiftWriteLM4Cy
  { 5,  0}, // #690 SwiftWriteLM5Cy
  { 6,  0}, // #691 SwiftWriteLM6Cy
  { 7,  0}, // #692 SwiftWriteLM7Cy
  { 8,  0}, // #693 SwiftWriteLM8Cy
  { 9,  0}, // #694 SwiftWriteLM9Cy
  {10,  0}, // #695 SwiftWriteLM10Cy
  { 0,  0}, // #696 SwiftWriteLDMAddrNoWB
  { 3,  0}, // #697 SwiftWriteLM3Cy
  { 4,  0}, // #698 SwiftWriteLM4Cy
  { 5,  0}, // #699 SwiftWriteLM5Cy
  { 6,  0}, // #700 SwiftWriteLM6Cy
  { 7,  0}, // #701 SwiftWriteLM7Cy
  { 8,  0}, // #702 SwiftWriteLM8Cy
  { 9,  0}, // #703 SwiftWriteLM9Cy
  {10,  0}, // #704 SwiftWriteLM10Cy
  {11,  0}, // #705 SwiftWriteLM11Cy
  { 0,  0}, // #706 SwiftWriteLDMAddrNoWB
  { 3,  0}, // #707 SwiftWriteLM3Cy
  { 4,  0}, // #708 SwiftWriteLM4Cy
  { 5,  0}, // #709 SwiftWriteLM5Cy
  { 6,  0}, // #710 SwiftWriteLM6Cy
  { 7,  0}, // #711 SwiftWriteLM7Cy
  { 8,  0}, // #712 SwiftWriteLM8Cy
  { 9,  0}, // #713 SwiftWriteLM9Cy
  {10,  0}, // #714 SwiftWriteLM10Cy
  {11,  0}, // #715 SwiftWriteLM11Cy
  {12,  0}, // #716 SwiftWriteLM12Cy
  { 0,  0}, // #717 SwiftWriteLDMAddrNoWB
  { 3,  0}, // #718 SwiftWriteLM3Cy
  { 4,  0}, // #719 SwiftWriteLM4Cy
  { 5,  0}, // #720 SwiftWriteLM5Cy
  { 6,  0}, // #721 SwiftWriteLM6Cy
  { 7,  0}, // #722 SwiftWriteLM7Cy
  { 8,  0}, // #723 SwiftWriteLM8Cy
  { 9,  0}, // #724 SwiftWriteLM9Cy
  {10,  0}, // #725 SwiftWriteLM10Cy
  {11,  0}, // #726 SwiftWriteLM11Cy
  {12,  0}, // #727 SwiftWriteLM12Cy
  {13,  0}, // #728 SwiftWriteLM13Cy
  { 0,  0}, // #729 SwiftWriteLDMAddrNoWB
  { 3,  0}, // #730 SwiftWriteLM3Cy
  { 4,  0}, // #731 SwiftWriteLM4Cy
  { 5,  0}, // #732 SwiftWriteLM5Cy
  { 6,  0}, // #733 SwiftWriteLM6Cy
  { 7,  0}, // #734 SwiftWriteLM7Cy
  { 8,  0}, // #735 SwiftWriteLM8Cy
  { 9,  0}, // #736 SwiftWriteLM9Cy
  {10,  0}, // #737 SwiftWriteLM10Cy
  {11,  0}, // #738 SwiftWriteLM11Cy
  {12,  0}, // #739 SwiftWriteLM12Cy
  {13,  0}, // #740 SwiftWriteLM13Cy
  {14,  0}, // #741 SwiftWriteLM14Cy
  { 0,  0}, // #742 SwiftWriteLDMAddrNoWB
  { 3,  0}, // #743 SwiftWriteLM3Cy
  { 4,  0}, // #744 SwiftWriteLM4Cy
  { 5,  0}, // #745 SwiftWriteLM5Cy
  { 6,  0}, // #746 SwiftWriteLM6Cy
  { 7,  0}, // #747 SwiftWriteLM7Cy
  { 8,  0}, // #748 SwiftWriteLM8Cy
  { 9,  0}, // #749 SwiftWriteLM9Cy
  {10,  0}, // #750 SwiftWriteLM10Cy
  {11,  0}, // #751 SwiftWriteLM11Cy
  {12,  0}, // #752 SwiftWriteLM12Cy
  {13,  0}, // #753 SwiftWriteLM13Cy
  {14,  0}, // #754 SwiftWriteLM14Cy
  {15,  0}, // #755 SwiftWriteLM15Cy
  { 0,  0}, // #756 SwiftWriteLDMAddrNoWB
  { 3,  0}, // #757 SwiftWriteLM3Cy
  { 4,  0}, // #758 SwiftWriteLM4Cy
  { 5,  0}, // #759 SwiftWriteLM5Cy
  { 6,  0}, // #760 SwiftWriteLM6Cy
  { 7,  0}, // #761 SwiftWriteLM7Cy
  { 8,  0}, // #762 SwiftWriteLM8Cy
  { 9,  0}, // #763 SwiftWriteLM9Cy
  {10,  0}, // #764 SwiftWriteLM10Cy
  {11,  0}, // #765 SwiftWriteLM11Cy
  {12,  0}, // #766 SwiftWriteLM12Cy
  {13,  0}, // #767 SwiftWriteLM13Cy
  {14,  0}, // #768 SwiftWriteLM14Cy
  {15,  0}, // #769 SwiftWriteLM15Cy
  {16,  0}, // #770 SwiftWriteLM16Cy
  { 0,  0}, // #771 SwiftWriteLDMAddrNoWB
  { 3,  0}, // #772 SwiftWriteLM3Cy
  { 4,  0}, // #773 SwiftWriteLM4Cy
  { 5,  0}, // #774 SwiftWriteLM5Cy
  { 6,  0}, // #775 SwiftWriteLM6Cy
  { 7,  0}, // #776 SwiftWriteLM7Cy
  { 8,  0}, // #777 SwiftWriteLM8Cy
  { 9,  0}, // #778 SwiftWriteLM9Cy
  {10,  0}, // #779 SwiftWriteLM10Cy
  {11,  0}, // #780 SwiftWriteLM11Cy
  {12,  0}, // #781 SwiftWriteLM12Cy
  {13,  0}, // #782 SwiftWriteLM13Cy
  {14,  0}, // #783 SwiftWriteLM14Cy
  {15,  0}, // #784 SwiftWriteLM15Cy
  {16,  0}, // #785 SwiftWriteLM16Cy
  {17,  0}, // #786 SwiftWriteLM17Cy
  { 0,  0}, // #787 SwiftWriteLDMAddrNoWB
  { 3,  0}, // #788 SwiftWriteLM3Cy
  { 4,  0}, // #789 SwiftWriteLM4Cy
  { 5,  0}, // #790 SwiftWriteLM5Cy_SwiftWriteLM5CyNo
  { 6,  0}, // #791 SwiftWriteLM6Cy_SwiftWriteLM6CyNo
  { 7,  0}, // #792 SwiftWriteLM7Cy_SwiftWriteLM7CyNo
  { 8,  0}, // #793 SwiftWriteLM8Cy_SwiftWriteLM8CyNo
  { 9,  0}, // #794 SwiftWriteLM9Cy_SwiftWriteLM9CyNo
  {10,  0}, // #795 SwiftWriteLM10Cy_SwiftWriteLM10CyNo
  {11,  0}, // #796 SwiftWriteLM11Cy_SwiftWriteLM11CyNo
  {12,  0}, // #797 SwiftWriteLM12Cy_SwiftWriteLM12CyNo
  {13,  0}, // #798 SwiftWriteLM13Cy_SwiftWriteLM13CyNo
  {14,  0}, // #799 SwiftWriteLM14Cy_SwiftWriteLM14CyNo
  {15,  0}, // #800 SwiftWriteLM15Cy_SwiftWriteLM15CyNo
  {16,  0}, // #801 SwiftWriteLM16Cy_SwiftWriteLM16CyNo
  {17,  0}, // #802 SwiftWriteLM17Cy_SwiftWriteLM17CyNo
  {18,  0}, // #803 SwiftWriteLM18Cy_SwiftWriteLM18CyNo
  { 0,  0}, // #804 SwiftWriteLDMAddrNoWB
  { 1,  0}, // #805 SwiftWriteLDMAddrWB
  { 3,  0}, // #806 SwiftWriteLM3Cy
  { 4,  0}, // #807 SwiftWriteLM4Cy
  { 5,  0}, // #808 SwiftWriteLM5Cy
  { 1,  0}, // #809 SwiftWriteLDMAddrWB
  { 3,  0}, // #810 SwiftWriteLM3Cy
  { 4,  0}, // #811 SwiftWriteLM4Cy
  { 5,  0}, // #812 SwiftWriteLM5Cy
  { 6,  0}, // #813 SwiftWriteLM6Cy
  { 1,  0}, // #814 SwiftWriteLDMAddrWB
  { 3,  0}, // #815 SwiftWriteLM3Cy
  { 4,  0}, // #816 SwiftWriteLM4Cy
  { 5,  0}, // #817 SwiftWriteLM5Cy
  { 6,  0}, // #818 SwiftWriteLM6Cy
  { 7,  0}, // #819 SwiftWriteLM7Cy
  { 1,  0}, // #820 SwiftWriteLDMAddrWB
  { 3,  0}, // #821 SwiftWriteLM3Cy
  { 4,  0}, // #822 SwiftWriteLM4Cy
  { 5,  0}, // #823 SwiftWriteLM5Cy
  { 6,  0}, // #824 SwiftWriteLM6Cy
  { 7,  0}, // #825 SwiftWriteLM7Cy
  { 8,  0}, // #826 SwiftWriteLM8Cy
  { 1,  0}, // #827 SwiftWriteLDMAddrWB
  { 3,  0}, // #828 SwiftWriteLM3Cy
  { 4,  0}, // #829 SwiftWriteLM4Cy
  { 5,  0}, // #830 SwiftWriteLM5Cy
  { 6,  0}, // #831 SwiftWriteLM6Cy
  { 7,  0}, // #832 SwiftWriteLM7Cy
  { 8,  0}, // #833 SwiftWriteLM8Cy
  { 9,  0}, // #834 SwiftWriteLM9Cy
  { 1,  0}, // #835 SwiftWriteLDMAddrWB
  { 3,  0}, // #836 SwiftWriteLM3Cy
  { 4,  0}, // #837 SwiftWriteLM4Cy
  { 5,  0}, // #838 SwiftWriteLM5Cy
  { 6,  0}, // #839 SwiftWriteLM6Cy
  { 7,  0}, // #840 SwiftWriteLM7Cy
  { 8,  0}, // #841 SwiftWriteLM8Cy
  { 9,  0}, // #842 SwiftWriteLM9Cy
  {10,  0}, // #843 SwiftWriteLM10Cy
  { 1,  0}, // #844 SwiftWriteLDMAddrWB
  { 3,  0}, // #845 SwiftWriteLM3Cy
  { 4,  0}, // #846 SwiftWriteLM4Cy
  { 5,  0}, // #847 SwiftWriteLM5Cy
  { 6,  0}, // #848 SwiftWriteLM6Cy
  { 7,  0}, // #849 SwiftWriteLM7Cy
  { 8,  0}, // #850 SwiftWriteLM8Cy
  { 9,  0}, // #851 SwiftWriteLM9Cy
  {10,  0}, // #852 SwiftWriteLM10Cy
  {11,  0}, // #853 SwiftWriteLM11Cy
  { 1,  0}, // #854 SwiftWriteLDMAddrWB
  { 3,  0}, // #855 SwiftWriteLM3Cy
  { 4,  0}, // #856 SwiftWriteLM4Cy
  { 5,  0}, // #857 SwiftWriteLM5Cy
  { 6,  0}, // #858 SwiftWriteLM6Cy
  { 7,  0}, // #859 SwiftWriteLM7Cy
  { 8,  0}, // #860 SwiftWriteLM8Cy
  { 9,  0}, // #861 SwiftWriteLM9Cy
  {10,  0}, // #862 SwiftWriteLM10Cy
  {11,  0}, // #863 SwiftWriteLM11Cy
  {12,  0}, // #864 SwiftWriteLM12Cy
  { 1,  0}, // #865 SwiftWriteLDMAddrWB
  { 3,  0}, // #866 SwiftWriteLM3Cy
  { 4,  0}, // #867 SwiftWriteLM4Cy
  { 5,  0}, // #868 SwiftWriteLM5Cy
  { 6,  0}, // #869 SwiftWriteLM6Cy
  { 7,  0}, // #870 SwiftWriteLM7Cy
  { 8,  0}, // #871 SwiftWriteLM8Cy
  { 9,  0}, // #872 SwiftWriteLM9Cy
  {10,  0}, // #873 SwiftWriteLM10Cy
  {11,  0}, // #874 SwiftWriteLM11Cy
  {12,  0}, // #875 SwiftWriteLM12Cy
  {13,  0}, // #876 SwiftWriteLM13Cy
  { 1,  0}, // #877 SwiftWriteLDMAddrWB
  { 3,  0}, // #878 SwiftWriteLM3Cy
  { 4,  0}, // #879 SwiftWriteLM4Cy
  { 5,  0}, // #880 SwiftWriteLM5Cy
  { 6,  0}, // #881 SwiftWriteLM6Cy
  { 7,  0}, // #882 SwiftWriteLM7Cy
  { 8,  0}, // #883 SwiftWriteLM8Cy
  { 9,  0}, // #884 SwiftWriteLM9Cy
  {10,  0}, // #885 SwiftWriteLM10Cy
  {11,  0}, // #886 SwiftWriteLM11Cy
  {12,  0}, // #887 SwiftWriteLM12Cy
  {13,  0}, // #888 SwiftWriteLM13Cy
  {14,  0}, // #889 SwiftWriteLM14Cy
  { 1,  0}, // #890 SwiftWriteLDMAddrWB
  { 3,  0}, // #891 SwiftWriteLM3Cy
  { 4,  0}, // #892 SwiftWriteLM4Cy
  { 5,  0}, // #893 SwiftWriteLM5Cy
  { 6,  0}, // #894 SwiftWriteLM6Cy
  { 7,  0}, // #895 SwiftWriteLM7Cy
  { 8,  0}, // #896 SwiftWriteLM8Cy
  { 9,  0}, // #897 SwiftWriteLM9Cy
  {10,  0}, // #898 SwiftWriteLM10Cy
  {11,  0}, // #899 SwiftWriteLM11Cy
  {12,  0}, // #900 SwiftWriteLM12Cy
  {13,  0}, // #901 SwiftWriteLM13Cy
  {14,  0}, // #902 SwiftWriteLM14Cy
  {15,  0}, // #903 SwiftWriteLM15Cy
  { 1,  0}, // #904 SwiftWriteLDMAddrWB
  { 3,  0}, // #905 SwiftWriteLM3Cy
  { 4,  0}, // #906 SwiftWriteLM4Cy
  { 5,  0}, // #907 SwiftWriteLM5Cy
  { 6,  0}, // #908 SwiftWriteLM6Cy
  { 7,  0}, // #909 SwiftWriteLM7Cy
  { 8,  0}, // #910 SwiftWriteLM8Cy
  { 9,  0}, // #911 SwiftWriteLM9Cy
  {10,  0}, // #912 SwiftWriteLM10Cy
  {11,  0}, // #913 SwiftWriteLM11Cy
  {12,  0}, // #914 SwiftWriteLM12Cy
  {13,  0}, // #915 SwiftWriteLM13Cy
  {14,  0}, // #916 SwiftWriteLM14Cy
  {15,  0}, // #917 SwiftWriteLM15Cy
  {16,  0}, // #918 SwiftWriteLM16Cy
  { 1,  0}, // #919 SwiftWriteLDMAddrWB
  { 3,  0}, // #920 SwiftWriteLM3Cy
  { 4,  0}, // #921 SwiftWriteLM4Cy
  { 5,  0}, // #922 SwiftWriteLM5Cy
  { 6,  0}, // #923 SwiftWriteLM6Cy
  { 7,  0}, // #924 SwiftWriteLM7Cy
  { 8,  0}, // #925 SwiftWriteLM8Cy
  { 9,  0}, // #926 SwiftWriteLM9Cy
  {10,  0}, // #927 SwiftWriteLM10Cy
  {11,  0}, // #928 SwiftWriteLM11Cy
  {12,  0}, // #929 SwiftWriteLM12Cy
  {13,  0}, // #930 SwiftWriteLM13Cy
  {14,  0}, // #931 SwiftWriteLM14Cy
  {15,  0}, // #932 SwiftWriteLM15Cy
  {16,  0}, // #933 SwiftWriteLM16Cy
  {17,  0}, // #934 SwiftWriteLM17Cy
  { 1,  0}, // #935 SwiftWriteLDMAddrWB
  { 3,  0}, // #936 SwiftWriteLM3Cy
  { 4,  0}, // #937 SwiftWriteLM4Cy
  { 5,  0}, // #938 SwiftWriteLM5Cy_SwiftWriteLM5CyNo
  { 6,  0}, // #939 SwiftWriteLM6Cy_SwiftWriteLM6CyNo
  { 7,  0}, // #940 SwiftWriteLM7Cy_SwiftWriteLM7CyNo
  { 8,  0}, // #941 SwiftWriteLM8Cy_SwiftWriteLM8CyNo
  { 9,  0}, // #942 SwiftWriteLM9Cy_SwiftWriteLM9CyNo
  {10,  0}, // #943 SwiftWriteLM10Cy_SwiftWriteLM10CyNo
  {11,  0}, // #944 SwiftWriteLM11Cy_SwiftWriteLM11CyNo
  {12,  0}, // #945 SwiftWriteLM12Cy_SwiftWriteLM12CyNo
  {13,  0}, // #946 SwiftWriteLM13Cy_SwiftWriteLM13CyNo
  {14,  0}, // #947 SwiftWriteLM14Cy_SwiftWriteLM14CyNo
  {15,  0}, // #948 SwiftWriteLM15Cy_SwiftWriteLM15CyNo
  {16,  0}, // #949 SwiftWriteLM16Cy_SwiftWriteLM16CyNo
  {17,  0}, // #950 SwiftWriteLM17Cy_SwiftWriteLM17CyNo
  {18,  0}, // #951 SwiftWriteLM18Cy_SwiftWriteLM18CyNo
  { 1,  0}, // #952 SwiftWriteLDMAddrWB
  { 3,  0}, // #953 SwiftWriteLM3Cy
  { 4,  0}, // #954 SwiftWriteLM4Cy
  { 2,  0}, // #955 SwiftWriteP1TwoCycle
  { 1,  0}, // #956 SwiftWriteLDMAddrWB
  { 3,  0}, // #957 SwiftWriteLM3Cy
  { 4,  0}, // #958 SwiftWriteLM4Cy
  { 5,  0}, // #959 SwiftWriteLM5Cy
  { 2,  0}, // #960 SwiftWriteP1TwoCycle
  { 1,  0}, // #961 SwiftWriteLDMAddrWB
  { 3,  0}, // #962 SwiftWriteLM3Cy
  { 4,  0}, // #963 SwiftWriteLM4Cy
  { 5,  0}, // #964 SwiftWriteLM5Cy
  { 6,  0}, // #965 SwiftWriteLM6Cy
  { 2,  0}, // #966 SwiftWriteP1TwoCycle
  { 1,  0}, // #967 SwiftWriteLDMAddrWB
  { 3,  0}, // #968 SwiftWriteLM3Cy
  { 4,  0}, // #969 SwiftWriteLM4Cy
  { 5,  0}, // #970 SwiftWriteLM5Cy
  { 6,  0}, // #971 SwiftWriteLM6Cy
  { 7,  0}, // #972 SwiftWriteLM7Cy
  { 2,  0}, // #973 SwiftWriteP1TwoCycle
  { 1,  0}, // #974 SwiftWriteLDMAddrWB
  { 3,  0}, // #975 SwiftWriteLM3Cy
  { 4,  0}, // #976 SwiftWriteLM4Cy
  { 5,  0}, // #977 SwiftWriteLM5Cy
  { 6,  0}, // #978 SwiftWriteLM6Cy
  { 7,  0}, // #979 SwiftWriteLM7Cy
  { 8,  0}, // #980 SwiftWriteLM8Cy
  { 2,  0}, // #981 SwiftWriteP1TwoCycle
  { 1,  0}, // #982 SwiftWriteLDMAddrWB
  { 3,  0}, // #983 SwiftWriteLM3Cy
  { 4,  0}, // #984 SwiftWriteLM4Cy
  { 5,  0}, // #985 SwiftWriteLM5Cy
  { 6,  0}, // #986 SwiftWriteLM6Cy
  { 7,  0}, // #987 SwiftWriteLM7Cy
  { 8,  0}, // #988 SwiftWriteLM8Cy
  { 9,  0}, // #989 SwiftWriteLM9Cy
  { 2,  0}, // #990 SwiftWriteP1TwoCycle
  { 1,  0}, // #991 SwiftWriteLDMAddrWB
  { 3,  0}, // #992 SwiftWriteLM3Cy
  { 4,  0}, // #993 SwiftWriteLM4Cy
  { 5,  0}, // #994 SwiftWriteLM5Cy
  { 6,  0}, // #995 SwiftWriteLM6Cy
  { 7,  0}, // #996 SwiftWriteLM7Cy
  { 8,  0}, // #997 SwiftWriteLM8Cy
  { 9,  0}, // #998 SwiftWriteLM9Cy
  {10,  0}, // #999 SwiftWriteLM10Cy
  { 2,  0}, // #1000 SwiftWriteP1TwoCycle
  { 1,  0}, // #1001 SwiftWriteLDMAddrWB
  { 3,  0}, // #1002 SwiftWriteLM3Cy
  { 4,  0}, // #1003 SwiftWriteLM4Cy
  { 5,  0}, // #1004 SwiftWriteLM5Cy
  { 6,  0}, // #1005 SwiftWriteLM6Cy
  { 7,  0}, // #1006 SwiftWriteLM7Cy
  { 8,  0}, // #1007 SwiftWriteLM8Cy
  { 9,  0}, // #1008 SwiftWriteLM9Cy
  {10,  0}, // #1009 SwiftWriteLM10Cy
  {11,  0}, // #1010 SwiftWriteLM11Cy
  { 2,  0}, // #1011 SwiftWriteP1TwoCycle
  { 1,  0}, // #1012 SwiftWriteLDMAddrWB
  { 3,  0}, // #1013 SwiftWriteLM3Cy
  { 4,  0}, // #1014 SwiftWriteLM4Cy
  { 5,  0}, // #1015 SwiftWriteLM5Cy
  { 6,  0}, // #1016 SwiftWriteLM6Cy
  { 7,  0}, // #1017 SwiftWriteLM7Cy
  { 8,  0}, // #1018 SwiftWriteLM8Cy
  { 9,  0}, // #1019 SwiftWriteLM9Cy
  {10,  0}, // #1020 SwiftWriteLM10Cy
  {11,  0}, // #1021 SwiftWriteLM11Cy
  {12,  0}, // #1022 SwiftWriteLM12Cy
  { 2,  0}, // #1023 SwiftWriteP1TwoCycle
  { 1,  0}, // #1024 SwiftWriteLDMAddrWB
  { 3,  0}, // #1025 SwiftWriteLM3Cy
  { 4,  0}, // #1026 SwiftWriteLM4Cy
  { 5,  0}, // #1027 SwiftWriteLM5Cy
  { 6,  0}, // #1028 SwiftWriteLM6Cy
  { 7,  0}, // #1029 SwiftWriteLM7Cy
  { 8,  0}, // #1030 SwiftWriteLM8Cy
  { 9,  0}, // #1031 SwiftWriteLM9Cy
  {10,  0}, // #1032 SwiftWriteLM10Cy
  {11,  0}, // #1033 SwiftWriteLM11Cy
  {12,  0}, // #1034 SwiftWriteLM12Cy
  {13,  0}, // #1035 SwiftWriteLM13Cy
  { 2,  0}, // #1036 SwiftWriteP1TwoCycle
  { 1,  0}, // #1037 SwiftWriteLDMAddrWB
  { 3,  0}, // #1038 SwiftWriteLM3Cy
  { 4,  0}, // #1039 SwiftWriteLM4Cy
  { 5,  0}, // #1040 SwiftWriteLM5Cy
  { 6,  0}, // #1041 SwiftWriteLM6Cy
  { 7,  0}, // #1042 SwiftWriteLM7Cy
  { 8,  0}, // #1043 SwiftWriteLM8Cy
  { 9,  0}, // #1044 SwiftWriteLM9Cy
  {10,  0}, // #1045 SwiftWriteLM10Cy
  {11,  0}, // #1046 SwiftWriteLM11Cy
  {12,  0}, // #1047 SwiftWriteLM12Cy
  {13,  0}, // #1048 SwiftWriteLM13Cy
  {14,  0}, // #1049 SwiftWriteLM14Cy
  { 2,  0}, // #1050 SwiftWriteP1TwoCycle
  { 1,  0}, // #1051 SwiftWriteLDMAddrWB
  { 3,  0}, // #1052 SwiftWriteLM3Cy
  { 4,  0}, // #1053 SwiftWriteLM4Cy
  { 5,  0}, // #1054 SwiftWriteLM5Cy
  { 6,  0}, // #1055 SwiftWriteLM6Cy
  { 7,  0}, // #1056 SwiftWriteLM7Cy
  { 8,  0}, // #1057 SwiftWriteLM8Cy
  { 9,  0}, // #1058 SwiftWriteLM9Cy
  {10,  0}, // #1059 SwiftWriteLM10Cy
  {11,  0}, // #1060 SwiftWriteLM11Cy
  {12,  0}, // #1061 SwiftWriteLM12Cy
  {13,  0}, // #1062 SwiftWriteLM13Cy
  {14,  0}, // #1063 SwiftWriteLM14Cy
  {15,  0}, // #1064 SwiftWriteLM15Cy
  { 2,  0}, // #1065 SwiftWriteP1TwoCycle
  { 1,  0}, // #1066 SwiftWriteLDMAddrWB
  { 3,  0}, // #1067 SwiftWriteLM3Cy
  { 4,  0}, // #1068 SwiftWriteLM4Cy
  { 5,  0}, // #1069 SwiftWriteLM5Cy
  { 6,  0}, // #1070 SwiftWriteLM6Cy
  { 7,  0}, // #1071 SwiftWriteLM7Cy
  { 8,  0}, // #1072 SwiftWriteLM8Cy
  { 9,  0}, // #1073 SwiftWriteLM9Cy
  {10,  0}, // #1074 SwiftWriteLM10Cy
  {11,  0}, // #1075 SwiftWriteLM11Cy
  {12,  0}, // #1076 SwiftWriteLM12Cy
  {13,  0}, // #1077 SwiftWriteLM13Cy
  {14,  0}, // #1078 SwiftWriteLM14Cy
  {15,  0}, // #1079 SwiftWriteLM15Cy
  {16,  0}, // #1080 SwiftWriteLM16Cy
  { 2,  0}, // #1081 SwiftWriteP1TwoCycle
  { 1,  0}, // #1082 SwiftWriteLDMAddrWB
  { 3,  0}, // #1083 SwiftWriteLM3Cy
  { 4,  0}, // #1084 SwiftWriteLM4Cy
  { 5,  0}, // #1085 SwiftWriteLM5Cy
  { 6,  0}, // #1086 SwiftWriteLM6Cy
  { 7,  0}, // #1087 SwiftWriteLM7Cy
  { 8,  0}, // #1088 SwiftWriteLM8Cy
  { 9,  0}, // #1089 SwiftWriteLM9Cy
  {10,  0}, // #1090 SwiftWriteLM10Cy
  {11,  0}, // #1091 SwiftWriteLM11Cy
  {12,  0}, // #1092 SwiftWriteLM12Cy
  {13,  0}, // #1093 SwiftWriteLM13Cy
  {14,  0}, // #1094 SwiftWriteLM14Cy
  {15,  0}, // #1095 SwiftWriteLM15Cy
  {16,  0}, // #1096 SwiftWriteLM16Cy
  {17,  0}, // #1097 SwiftWriteLM17Cy
  { 2,  0}, // #1098 SwiftWriteP1TwoCycle
  { 1,  0}, // #1099 SwiftWriteLDMAddrWB
  { 3,  0}, // #1100 SwiftWriteLM3Cy
  { 4,  0}, // #1101 SwiftWriteLM4Cy
  { 5,  0}, // #1102 SwiftWriteLM5Cy_SwiftWriteLM5CyNo
  { 6,  0}, // #1103 SwiftWriteLM6Cy_SwiftWriteLM6CyNo
  { 7,  0}, // #1104 SwiftWriteLM7Cy_SwiftWriteLM7CyNo
  { 8,  0}, // #1105 SwiftWriteLM8Cy_SwiftWriteLM8CyNo
  { 9,  0}, // #1106 SwiftWriteLM9Cy_SwiftWriteLM9CyNo
  {10,  0}, // #1107 SwiftWriteLM10Cy_SwiftWriteLM10CyNo
  {11,  0}, // #1108 SwiftWriteLM11Cy_SwiftWriteLM11CyNo
  {12,  0}, // #1109 SwiftWriteLM12Cy_SwiftWriteLM12CyNo
  {13,  0}, // #1110 SwiftWriteLM13Cy_SwiftWriteLM13CyNo
  {14,  0}, // #1111 SwiftWriteLM14Cy_SwiftWriteLM14CyNo
  {15,  0}, // #1112 SwiftWriteLM15Cy_SwiftWriteLM15CyNo
  {16,  0}, // #1113 SwiftWriteLM16Cy_SwiftWriteLM16CyNo
  {17,  0}, // #1114 SwiftWriteLM17Cy_SwiftWriteLM17CyNo
  {18,  0}, // #1115 SwiftWriteLM18Cy_SwiftWriteLM18CyNo
  { 2,  0}, // #1116 SwiftWriteP1TwoCycle_SwiftWriteP01OneCycle
  { 9,  0}, // #1117 SwiftWriteLM9Cy
  {10,  0}, // #1118 SwiftWriteLM10Cy
  {13,  0}, // #1119 SwiftWriteLM13CyNo
  { 1,  0}, // #1120 SwiftWriteP01OneCycle
  { 0,  0}, // #1121 SwiftVLDMPerm3
  { 4,  0}, // #1122 SwiftWriteLM4Cy
  { 4,  0}, // #1123 SwiftWriteLM4CyNo
  { 4,  0}, // #1124 SwiftWriteLM4CyNo
  { 4,  0}, // #1125 SwiftWriteLM4CyNo
  { 9,  0}, // #1126 SwiftWriteLM9Cy
  {10,  0}, // #1127 SwiftWriteLM10Cy
  {13,  0}, // #1128 SwiftWriteLM13CyNo
  {14,  0}, // #1129 SwiftWriteLM14CyNo
  {17,  0}, // #1130 SwiftWriteLM17CyNo
  { 1,  0}, // #1131 SwiftWriteP01OneCycle
  { 0,  0}, // #1132 SwiftVLDMPerm5
  { 7,  0}, // #1133 SwiftWriteLM7Cy
  { 8,  0}, // #1134 SwiftWriteLM8Cy
  {10,  0}, // #1135 SwiftWriteLM10Cy
  {14,  0}, // #1136 SwiftWriteLM14CyNo
  {14,  0}, // #1137 SwiftWriteLM14CyNo
  {14,  0}, // #1138 SwiftWriteLM14CyNo
  { 1,  0}, // #1139 SwiftWriteP01OneCycle
  { 0,  0}, // #1140 SwiftVLDMPerm5
  { 9,  0}, // #1141 SwiftWriteLM9Cy
  {10,  0}, // #1142 SwiftWriteLM10Cy
  {13,  0}, // #1143 SwiftWriteLM13Cy
  {14,  0}, // #1144 SwiftWriteLM14CyNo
  {17,  0}, // #1145 SwiftWriteLM17CyNo
  {18,  0}, // #1146 SwiftWriteLM18CyNo
  {21,  0}, // #1147 SwiftWriteLM21CyNo
  { 1,  0}, // #1148 SwiftWriteP01OneCycle
  { 0,  0}, // #1149 SwiftVLDMPerm7
  { 7,  0}, // #1150 SwiftWriteLM7Cy
  { 8,  0}, // #1151 SwiftWriteLM8Cy
  {13,  0}, // #1152 SwiftWriteLM13Cy
  {13,  0}, // #1153 SwiftWriteLM13CyNo
  {13,  0}, // #1154 SwiftWriteLM13CyNo
  {13,  0}, // #1155 SwiftWriteLM13CyNo
  {13,  0}, // #1156 SwiftWriteLM13CyNo
  {13,  0}, // #1157 SwiftWriteLM13CyNo
  { 1,  0}, // #1158 SwiftWriteP01OneCycle
  { 0,  0}, // #1159 SwiftVLDMPerm2
  { 9,  0}, // #1160 SwiftWriteLM9Cy
  {10,  0}, // #1161 SwiftWriteLM10Cy
  {13,  0}, // #1162 SwiftWriteLM13Cy
  {14,  0}, // #1163 SwiftWriteLM14CyNo
  {17,  0}, // #1164 SwiftWriteLM17CyNo
  {18,  0}, // #1165 SwiftWriteLM18CyNo
  {21,  0}, // #1166 SwiftWriteLM21CyNo
  {22,  0}, // #1167 SwiftWriteLM22CyNo
  {25,  0}, // #1168 SwiftWriteLM25CyNo
  { 1,  0}, // #1169 SwiftWriteP01OneCycle
  { 0,  0}, // #1170 SwiftVLDMPerm9
  { 7,  0}, // #1171 SwiftWriteLM7Cy
  { 8,  0}, // #1172 SwiftWriteLM8Cy
  {10,  0}, // #1173 SwiftWriteLM10Cy
  {14,  0}, // #1174 SwiftWriteLM14Cy
  {14,  0}, // #1175 SwiftWriteLM14CyNo
  {14,  0}, // #1176 SwiftWriteLM14CyNo
  {14,  0}, // #1177 SwiftWriteLM14CyNo
  {14,  0}, // #1178 SwiftWriteLM14CyNo
  {14,  0}, // #1179 SwiftWriteLM14CyNo
  {14,  0}, // #1180 SwiftWriteLM14CyNo
  { 1,  0}, // #1181 SwiftWriteP01OneCycle
  { 0,  0}, // #1182 SwiftVLDMPerm5
  { 9,  0}, // #1183 SwiftWriteLM9Cy
  {10,  0}, // #1184 SwiftWriteLM10Cy
  {13,  0}, // #1185 SwiftWriteLM13Cy
  {14,  0}, // #1186 SwiftWriteLM14CyNo
  {17,  0}, // #1187 SwiftWriteLM17CyNo
  {18,  0}, // #1188 SwiftWriteLM18CyNo
  {21,  0}, // #1189 SwiftWriteLM21CyNo
  {22,  0}, // #1190 SwiftWriteLM22CyNo
  {21,  0}, // #1191 SwiftWriteLM21CyNo
  {22,  0}, // #1192 SwiftWriteLM22CyNo
  {25,  0}, // #1193 SwiftWriteLM25CyNo
  { 1,  0}, // #1194 SwiftWriteP01OneCycle
  { 0,  0}, // #1195 SwiftVLDMPerm9
  { 7,  0}, // #1196 SwiftWriteLM7Cy
  { 8,  0}, // #1197 SwiftWriteLM8Cy
  {11,  0}, // #1198 SwiftWriteLM11Cy
  {11,  0}, // #1199 SwiftWriteLM11Cy
  {11,  0}, // #1200 SwiftWriteLM11CyNo
  {11,  0}, // #1201 SwiftWriteLM11CyNo
  {11,  0}, // #1202 SwiftWriteLM11CyNo
  {11,  0}, // #1203 SwiftWriteLM11CyNo
  {11,  0}, // #1204 SwiftWriteLM11CyNo
  {11,  0}, // #1205 SwiftWriteLM11CyNo
  {11,  0}, // #1206 SwiftWriteLM11CyNo
  {11,  0}, // #1207 SwiftWriteLM11CyNo
  { 1,  0}, // #1208 SwiftWriteP01OneCycle
  { 0,  0}, // #1209 SwiftVLDMPerm3
  { 9,  0}, // #1210 SwiftWriteLM9Cy
  {10,  0}, // #1211 SwiftWriteLM10Cy
  {13,  0}, // #1212 SwiftWriteLM13Cy
  {14,  0}, // #1213 SwiftWriteLM14CyNo
  {17,  0}, // #1214 SwiftWriteLM17CyNo
  {18,  0}, // #1215 SwiftWriteLM18CyNo
  {21,  0}, // #1216 SwiftWriteLM21CyNo
  {22,  0}, // #1217 SwiftWriteLM22CyNo
  {21,  0}, // #1218 SwiftWriteLM21CyNo
  {22,  0}, // #1219 SwiftWriteLM22CyNo
  {21,  0}, // #1220 SwiftWriteLM21CyNo
  {22,  0}, // #1221 SwiftWriteLM22CyNo
  {25,  0}, // #1222 SwiftWriteLM25CyNo
  { 1,  0}, // #1223 SwiftWriteP01OneCycle
  { 0,  0}, // #1224 SwiftVLDMPerm9
  { 7,  0}, // #1225 SwiftWriteLM7Cy
  { 8,  0}, // #1226 SwiftWriteLM8Cy
  {10,  0}, // #1227 SwiftWriteLM10Cy
  {14,  0}, // #1228 SwiftWriteLM14Cy
  {14,  0}, // #1229 SwiftWriteLM14Cy
  {14,  0}, // #1230 SwiftWriteLM14CyNo
  {14,  0}, // #1231 SwiftWriteLM14CyNo
  {14,  0}, // #1232 SwiftWriteLM14CyNo
  {14,  0}, // #1233 SwiftWriteLM14CyNo
  {14,  0}, // #1234 SwiftWriteLM14CyNo
  {14,  0}, // #1235 SwiftWriteLM14CyNo
  {14,  0}, // #1236 SwiftWriteLM14CyNo
  { 1,  0}, // #1237 SwiftWriteP01OneCycle
  { 0,  0}, // #1238 SwiftVLDMPerm7
  { 9,  0}, // #1239 SwiftWriteLM9Cy
  {10,  0}, // #1240 SwiftWriteLM10Cy
  {13,  0}, // #1241 SwiftWriteLM13Cy
  {14,  0}, // #1242 SwiftWriteLM14Cy
  {17,  0}, // #1243 SwiftWriteLM17Cy
  {18,  0}, // #1244 SwiftWriteLM18CyNo
  {21,  0}, // #1245 SwiftWriteLM21CyNo
  {22,  0}, // #1246 SwiftWriteLM22CyNo
  {21,  0}, // #1247 SwiftWriteLM21CyNo
  {22,  0}, // #1248 SwiftWriteLM22CyNo
  {21,  0}, // #1249 SwiftWriteLM21CyNo
  {22,  0}, // #1250 SwiftWriteLM22CyNo
  {21,  0}, // #1251 SwiftWriteLM21CyNo
  {22,  0}, // #1252 SwiftWriteLM22CyNo
  {25,  0}, // #1253 SwiftWriteLM25CyNo
  { 1,  0}, // #1254 SwiftWriteP01OneCycle
  { 0,  0}, // #1255 SwiftVLDMPerm9
  { 7,  0}, // #1256 SwiftWriteLM7Cy
  {10,  0}, // #1257 SwiftWriteLM10Cy
  {11,  0}, // #1258 SwiftWriteLM11Cy
  {14,  0}, // #1259 SwiftWriteLM14Cy
  {15,  0}, // #1260 SwiftWriteLM15Cy
  {18,  0}, // #1261 SwiftWriteLM18CyNo
  {19,  0}, // #1262 SwiftWriteLM19CyNo
  {22,  0}, // #1263 SwiftWriteLM22CyNo
  {19,  0}, // #1264 SwiftWriteLM19CyNo
  {22,  0}, // #1265 SwiftWriteLM22CyNo
  {19,  0}, // #1266 SwiftWriteLM19CyNo
  {22,  0}, // #1267 SwiftWriteLM22CyNo
  {19,  0}, // #1268 SwiftWriteLM19CyNo
  {22,  0}, // #1269 SwiftWriteLM22CyNo
  {19,  0}, // #1270 SwiftWriteLM19CyNo
  {22,  0}, // #1271 SwiftWriteLM22CyNo
  { 1,  0}, // #1272 SwiftWriteP01OneCycle
  { 0,  0}, // #1273 SwiftVLDMPerm4
  { 7,  0}, // #1274 SwiftWriteLM7Cy
  { 8,  0}, // #1275 SwiftWriteLM8Cy
  {13,  0}, // #1276 SwiftWriteLM13Cy
  {13,  0}, // #1277 SwiftWriteLM13CyNo
  {13,  0}, // #1278 SwiftWriteLM13CyNo
  {13,  0}, // #1279 SwiftWriteLM13CyNo
  {13,  0}, // #1280 SwiftWriteLM13CyNo
  {13,  0}, // #1281 SwiftWriteLM13CyNo
  {13,  0}, // #1282 SwiftWriteLM13CyNo
  {13,  0}, // #1283 SwiftWriteLM13CyNo
  {13,  0}, // #1284 SwiftWriteLM13CyNo
  {13,  0}, // #1285 SwiftWriteLM13CyNo
  {13,  0}, // #1286 SwiftWriteLM13CyNo
  {13,  0}, // #1287 SwiftWriteLM13CyNo
  {13,  0}, // #1288 SwiftWriteLM13CyNo
  {13,  0}, // #1289 SwiftWriteLM13CyNo
  {13,  0}, // #1290 SwiftWriteLM13CyNo
  {13,  0}, // #1291 SwiftWriteLM13CyNo
  {13,  0}, // #1292 SwiftWriteLM13CyNo
  {13,  0}, // #1293 SwiftWriteLM13CyNo
  {13,  0}, // #1294 SwiftWriteLM13CyNo
  {13,  0}, // #1295 SwiftWriteLM13CyNo
  {13,  0}, // #1296 SwiftWriteLM13CyNo
  {13,  0}, // #1297 SwiftWriteLM13CyNo
  {13,  0}, // #1298 SwiftWriteLM13CyNo
  {13,  0}, // #1299 SwiftWriteLM13CyNo
  {13,  0}, // #1300 SwiftWriteLM13CyNo
  {13,  0}, // #1301 SwiftWriteLM13CyNo
  {13,  0}, // #1302 SwiftWriteLM13CyNo
  {13,  0}, // #1303 SwiftWriteLM13CyNo
  {13,  0}, // #1304 SwiftWriteLM13CyNo
  {13,  0}, // #1305 SwiftWriteLM13CyNo
  { 1,  0}, // #1306 SwiftWriteP01OneCycle
  { 0,  0}, // #1307 SwiftVLDMPerm2
  { 2,  0}, // #1308 SwiftWriteP01OneCycle
  { 4,  0}, // #1309 SwiftWriteLM4Cy
  { 4,  0}, // #1310 SwiftWriteLM4CyNo
  { 4,  0}, // #1311 SwiftWriteLM4CyNo
  { 4,  0}, // #1312 SwiftWriteLM4CyNo
  { 2,  0}, // #1313 SwiftWriteP01OneCycle
  { 9,  0}, // #1314 SwiftWriteLM9Cy
  {10,  0}, // #1315 SwiftWriteLM10Cy
  {13,  0}, // #1316 SwiftWriteLM13CyNo
  {14,  0}, // #1317 SwiftWriteLM14CyNo
  {17,  0}, // #1318 SwiftWriteLM17CyNo
  { 1,  0}, // #1319 SwiftWriteP01OneCycle
  { 0,  0}, // #1320 SwiftVLDMPerm5
  { 2,  0}, // #1321 SwiftWriteP01OneCycle
  { 7,  0}, // #1322 SwiftWriteLM7Cy
  { 8,  0}, // #1323 SwiftWriteLM8Cy
  {10,  0}, // #1324 SwiftWriteLM10Cy
  {14,  0}, // #1325 SwiftWriteLM14CyNo
  {14,  0}, // #1326 SwiftWriteLM14CyNo
  {14,  0}, // #1327 SwiftWriteLM14CyNo
  { 1,  0}, // #1328 SwiftWriteP01OneCycle
  { 0,  0}, // #1329 SwiftVLDMPerm5
  { 2,  0}, // #1330 SwiftWriteP01OneCycle
  { 9,  0}, // #1331 SwiftWriteLM9Cy
  {10,  0}, // #1332 SwiftWriteLM10Cy
  {13,  0}, // #1333 SwiftWriteLM13Cy
  {14,  0}, // #1334 SwiftWriteLM14CyNo
  {17,  0}, // #1335 SwiftWriteLM17CyNo
  {18,  0}, // #1336 SwiftWriteLM18CyNo
  {21,  0}, // #1337 SwiftWriteLM21CyNo
  { 1,  0}, // #1338 SwiftWriteP01OneCycle
  { 0,  0}, // #1339 SwiftVLDMPerm7
  { 2,  0}, // #1340 SwiftWriteP01OneCycle
  { 7,  0}, // #1341 SwiftWriteLM7Cy
  { 8,  0}, // #1342 SwiftWriteLM8Cy
  {13,  0}, // #1343 SwiftWriteLM13Cy
  {13,  0}, // #1344 SwiftWriteLM13CyNo
  {13,  0}, // #1345 SwiftWriteLM13CyNo
  {13,  0}, // #1346 SwiftWriteLM13CyNo
  {13,  0}, // #1347 SwiftWriteLM13CyNo
  {13,  0}, // #1348 SwiftWriteLM13CyNo
  { 1,  0}, // #1349 SwiftWriteP01OneCycle
  { 0,  0}, // #1350 SwiftVLDMPerm2
  { 2,  0}, // #1351 SwiftWriteP01OneCycle
  { 9,  0}, // #1352 SwiftWriteLM9Cy
  {10,  0}, // #1353 SwiftWriteLM10Cy
  {13,  0}, // #1354 SwiftWriteLM13Cy
  {14,  0}, // #1355 SwiftWriteLM14CyNo
  {17,  0}, // #1356 SwiftWriteLM17CyNo
  {18,  0}, // #1357 SwiftWriteLM18CyNo
  {21,  0}, // #1358 SwiftWriteLM21CyNo
  {22,  0}, // #1359 SwiftWriteLM22CyNo
  {25,  0}, // #1360 SwiftWriteLM25CyNo
  { 1,  0}, // #1361 SwiftWriteP01OneCycle
  { 0,  0}, // #1362 SwiftVLDMPerm9
  { 2,  0}, // #1363 SwiftWriteP01OneCycle
  { 7,  0}, // #1364 SwiftWriteLM7Cy
  { 8,  0}, // #1365 SwiftWriteLM8Cy
  {10,  0}, // #1366 SwiftWriteLM10Cy
  {14,  0}, // #1367 SwiftWriteLM14Cy
  {14,  0}, // #1368 SwiftWriteLM14CyNo
  {14,  0}, // #1369 SwiftWriteLM14CyNo
  {14,  0}, // #1370 SwiftWriteLM14CyNo
  {14,  0}, // #1371 SwiftWriteLM14CyNo
  {14,  0}, // #1372 SwiftWriteLM14CyNo
  {14,  0}, // #1373 SwiftWriteLM14CyNo
  { 1,  0}, // #1374 SwiftWriteP01OneCycle
  { 0,  0}, // #1375 SwiftVLDMPerm5
  { 2,  0}, // #1376 SwiftWriteP01OneCycle
  { 9,  0}, // #1377 SwiftWriteLM9Cy
  {10,  0}, // #1378 SwiftWriteLM10Cy
  {13,  0}, // #1379 SwiftWriteLM13Cy
  {14,  0}, // #1380 SwiftWriteLM14CyNo
  {17,  0}, // #1381 SwiftWriteLM17CyNo
  {18,  0}, // #1382 SwiftWriteLM18CyNo
  {21,  0}, // #1383 SwiftWriteLM21CyNo
  {22,  0}, // #1384 SwiftWriteLM22CyNo
  {21,  0}, // #1385 SwiftWriteLM21CyNo
  {22,  0}, // #1386 SwiftWriteLM22CyNo
  {25,  0}, // #1387 SwiftWriteLM25CyNo
  { 1,  0}, // #1388 SwiftWriteP01OneCycle
  { 0,  0}, // #1389 SwiftVLDMPerm9
  { 2,  0}, // #1390 SwiftWriteP01OneCycle
  { 7,  0}, // #1391 SwiftWriteLM7Cy
  { 8,  0}, // #1392 SwiftWriteLM8Cy
  {11,  0}, // #1393 SwiftWriteLM11Cy
  {11,  0}, // #1394 SwiftWriteLM11Cy
  {11,  0}, // #1395 SwiftWriteLM11CyNo
  {11,  0}, // #1396 SwiftWriteLM11CyNo
  {11,  0}, // #1397 SwiftWriteLM11CyNo
  {11,  0}, // #1398 SwiftWriteLM11CyNo
  {11,  0}, // #1399 SwiftWriteLM11CyNo
  {11,  0}, // #1400 SwiftWriteLM11CyNo
  {11,  0}, // #1401 SwiftWriteLM11CyNo
  {11,  0}, // #1402 SwiftWriteLM11CyNo
  { 1,  0}, // #1403 SwiftWriteP01OneCycle
  { 0,  0}, // #1404 SwiftVLDMPerm3
  { 2,  0}, // #1405 SwiftWriteP01OneCycle
  { 9,  0}, // #1406 SwiftWriteLM9Cy
  {10,  0}, // #1407 SwiftWriteLM10Cy
  {13,  0}, // #1408 SwiftWriteLM13Cy
  {14,  0}, // #1409 SwiftWriteLM14CyNo
  {17,  0}, // #1410 SwiftWriteLM17CyNo
  {18,  0}, // #1411 SwiftWriteLM18CyNo
  {21,  0}, // #1412 SwiftWriteLM21CyNo
  {22,  0}, // #1413 SwiftWriteLM22CyNo
  {21,  0}, // #1414 SwiftWriteLM21CyNo
  {22,  0}, // #1415 SwiftWriteLM22CyNo
  {21,  0}, // #1416 SwiftWriteLM21CyNo
  {22,  0}, // #1417 SwiftWriteLM22CyNo
  {25,  0}, // #1418 SwiftWriteLM25CyNo
  { 1,  0}, // #1419 SwiftWriteP01OneCycle
  { 0,  0}, // #1420 SwiftVLDMPerm9
  { 2,  0}, // #1421 SwiftWriteP01OneCycle
  { 7,  0}, // #1422 SwiftWriteLM7Cy
  { 8,  0}, // #1423 SwiftWriteLM8Cy
  {10,  0}, // #1424 SwiftWriteLM10Cy
  {14,  0}, // #1425 SwiftWriteLM14Cy
  {14,  0}, // #1426 SwiftWriteLM14Cy
  {14,  0}, // #1427 SwiftWriteLM14CyNo
  {14,  0}, // #1428 SwiftWriteLM14CyNo
  {14,  0}, // #1429 SwiftWriteLM14CyNo
  {14,  0}, // #1430 SwiftWriteLM14CyNo
  {14,  0}, // #1431 SwiftWriteLM14CyNo
  {14,  0}, // #1432 SwiftWriteLM14CyNo
  {14,  0}, // #1433 SwiftWriteLM14CyNo
  { 1,  0}, // #1434 SwiftWriteP01OneCycle
  { 0,  0}, // #1435 SwiftVLDMPerm7
  { 2,  0}, // #1436 SwiftWriteP01OneCycle
  { 9,  0}, // #1437 SwiftWriteLM9Cy
  {10,  0}, // #1438 SwiftWriteLM10Cy
  {13,  0}, // #1439 SwiftWriteLM13Cy
  {14,  0}, // #1440 SwiftWriteLM14Cy
  {17,  0}, // #1441 SwiftWriteLM17Cy
  {18,  0}, // #1442 SwiftWriteLM18CyNo
  {21,  0}, // #1443 SwiftWriteLM21CyNo
  {22,  0}, // #1444 SwiftWriteLM22CyNo
  {21,  0}, // #1445 SwiftWriteLM21CyNo
  {22,  0}, // #1446 SwiftWriteLM22CyNo
  {21,  0}, // #1447 SwiftWriteLM21CyNo
  {22,  0}, // #1448 SwiftWriteLM22CyNo
  {21,  0}, // #1449 SwiftWriteLM21CyNo
  {22,  0}, // #1450 SwiftWriteLM22CyNo
  {25,  0}, // #1451 SwiftWriteLM25CyNo
  { 1,  0}, // #1452 SwiftWriteP01OneCycle
  { 0,  0}, // #1453 SwiftVLDMPerm9
  { 2,  0}, // #1454 SwiftWriteP01OneCycle
  { 7,  0}, // #1455 SwiftWriteLM7Cy
  {10,  0}, // #1456 SwiftWriteLM10Cy
  {11,  0}, // #1457 SwiftWriteLM11Cy
  {14,  0}, // #1458 SwiftWriteLM14Cy
  {15,  0}, // #1459 SwiftWriteLM15Cy
  {18,  0}, // #1460 SwiftWriteLM18CyNo
  {19,  0}, // #1461 SwiftWriteLM19CyNo
  {22,  0}, // #1462 SwiftWriteLM22CyNo
  {19,  0}, // #1463 SwiftWriteLM19CyNo
  {22,  0}, // #1464 SwiftWriteLM22CyNo
  {19,  0}, // #1465 SwiftWriteLM19CyNo
  {22,  0}, // #1466 SwiftWriteLM22CyNo
  {19,  0}, // #1467 SwiftWriteLM19CyNo
  {22,  0}, // #1468 SwiftWriteLM22CyNo
  {19,  0}, // #1469 SwiftWriteLM19CyNo
  {22,  0}, // #1470 SwiftWriteLM22CyNo
  { 1,  0}, // #1471 SwiftWriteP01OneCycle
  { 0,  0}, // #1472 SwiftVLDMPerm4
  { 2,  0}, // #1473 SwiftWriteP01OneCycle
  { 7,  0}, // #1474 SwiftWriteLM7Cy
  { 8,  0}, // #1475 SwiftWriteLM8Cy
  {13,  0}, // #1476 SwiftWriteLM13Cy
  {13,  0}, // #1477 SwiftWriteLM13CyNo
  {13,  0}, // #1478 SwiftWriteLM13CyNo
  {13,  0}, // #1479 SwiftWriteLM13CyNo
  {13,  0}, // #1480 SwiftWriteLM13CyNo
  {13,  0}, // #1481 SwiftWriteLM13CyNo
  {13,  0}, // #1482 SwiftWriteLM13CyNo
  {13,  0}, // #1483 SwiftWriteLM13CyNo
  {13,  0}, // #1484 SwiftWriteLM13CyNo
  {13,  0}, // #1485 SwiftWriteLM13CyNo
  {13,  0}, // #1486 SwiftWriteLM13CyNo
  {13,  0}, // #1487 SwiftWriteLM13CyNo
  {13,  0}, // #1488 SwiftWriteLM13CyNo
  {13,  0}, // #1489 SwiftWriteLM13CyNo
  {13,  0}, // #1490 SwiftWriteLM13CyNo
  {13,  0}, // #1491 SwiftWriteLM13CyNo
  {13,  0}, // #1492 SwiftWriteLM13CyNo
  {13,  0}, // #1493 SwiftWriteLM13CyNo
  {13,  0}, // #1494 SwiftWriteLM13CyNo
  {13,  0}, // #1495 SwiftWriteLM13CyNo
  {13,  0}, // #1496 SwiftWriteLM13CyNo
  {13,  0}, // #1497 SwiftWriteLM13CyNo
  {13,  0}, // #1498 SwiftWriteLM13CyNo
  {13,  0}, // #1499 SwiftWriteLM13CyNo
  {13,  0}, // #1500 SwiftWriteLM13CyNo
  {13,  0}, // #1501 SwiftWriteLM13CyNo
  {13,  0}, // #1502 SwiftWriteLM13CyNo
  {13,  0}, // #1503 SwiftWriteLM13CyNo
  {13,  0}, // #1504 SwiftWriteLM13CyNo
  {13,  0}, // #1505 SwiftWriteLM13CyNo
  { 1,  0}, // #1506 SwiftWriteP01OneCycle
  { 0,  0} // #1507 SwiftVLDMPerm2
}; // ARMWriteLatencyTable

// {UseIdx, WriteResourceID, Cycles}
extern const llvm::MCReadAdvanceEntry ARMReadAdvanceTable[] = {
  {0,  0,  0}, // Invalid
  {0, 40,  1}, // #1
  {0, 41,  1}, // #2
  {0, 42,  1}, // #3
  {0, 43,  1}, // #4
  {0, 44,  1}, // #5
  {0, 45,  1}, // #6
  {0, 46,  1}, // #7
  {0, 47,  1}, // #8
  {0, 48,  1}, // #9
  {0, 49,  1}, // #10
  {0, 50,  1}, // #11
  {0, 51,  1}, // #12
  {0, 52,  1}, // #13
  {0, 53,  1}, // #14
  {0, 54,  1}, // #15
  {0, 55,  1}, // #16
  {0, 56,  1}, // #17
  {0, 57,  1}, // #18
  {0, 83,  1}, // #19
  {0, 84,  1}, // #20
  {0, 107,  1}, // #21
  {0, 40,  1}, // #22
  {0, 41,  1}, // #23
  {0, 42,  1}, // #24
  {0, 43,  1}, // #25
  {0, 44,  1}, // #26
  {0, 45,  1}, // #27
  {0, 46,  1}, // #28
  {0, 47,  1}, // #29
  {0, 48,  1}, // #30
  {0, 49,  1}, // #31
  {0, 50,  1}, // #32
  {0, 51,  1}, // #33
  {0, 52,  1}, // #34
  {0, 53,  1}, // #35
  {0, 54,  1}, // #36
  {0, 55,  1}, // #37
  {0, 56,  1}, // #38
  {0, 57,  1}, // #39
  {0, 83,  1}, // #40
  {0, 84,  1}, // #41
  {0, 107,  1}, // #42
  {1, 40,  1}, // #43
  {1, 41,  1}, // #44
  {1, 42,  1}, // #45
  {1, 43,  1}, // #46
  {1, 44,  1}, // #47
  {1, 45,  1}, // #48
  {1, 46,  1}, // #49
  {1, 47,  1}, // #50
  {1, 48,  1}, // #51
  {1, 49,  1}, // #52
  {1, 50,  1}, // #53
  {1, 51,  1}, // #54
  {1, 52,  1}, // #55
  {1, 53,  1}, // #56
  {1, 54,  1}, // #57
  {1, 55,  1}, // #58
  {1, 56,  1}, // #59
  {1, 57,  1}, // #60
  {1, 83,  1}, // #61
  {1, 84,  1}, // #62
  {1, 107,  1}, // #63
  {0,  0,  2}, // #64
  {1,  0,  1}, // #65
  {0,  0,  1}, // #66
  {0,  0,  1}, // #67
  {1,  0,  1}, // #68
  {0,  0,  2}, // #69
  {1,  0,  1}, // #70
  {2,  0,  1}, // #71
  {0,  0,  1}, // #72
  {1,  0,  1}, // #73
  {2,  0,  2}, // #74
  {0,  0,  1}, // #75
  {1,  0,  1}, // #76
  {2,  0,  2}, // #77
  {3,  0,  2}, // #78
  {1,  0,  1}, // #79
  {2,  0,  1}, // #80
  {3,  0,  2}, // #81
  {1,  0,  1}, // #82
  {2,  0,  1}, // #83
  {3,  0,  2}, // #84
  {4,  0,  2}, // #85
  {0,  0,  0}, // #86
  {1,  0,  0}, // #87
  {0,  0,  0}, // #88
  {1,  0,  0}, // #89
  {2,  0,  4}, // #90
  {3,  0,  3}, // #91
  {0,  0,  0}, // #92
  {1,  0,  0}, // #93
  {2,  0,  2}, // #94
  {0,  0,  0}, // #95
  {1,  0,  0}, // #96
  {2,  0,  0} // #97
}; // ARMReadAdvanceTable

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc CortexA9ModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  65535, 0, 0,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("IIC_iALUi_WriteALU_ReadALU") 1, 0, 0,  1, 1,  1, 1,  1, 21}, // #1
  {DBGFIELD("IIC_iALUr_WriteALU_ReadALU_ReadALU") 1, 0, 0,  1, 1,  1, 1, 22, 42}, // #2
  {DBGFIELD("IIC_iALUsr_WriteALUsi_ReadALU") 1, 0, 0,  1, 1,  2, 1,  1, 21}, // #3
  {DBGFIELD("IIC_iALUsr_WriteALUsr_ReadALUsr") 1, 0, 0,  1, 1,  3, 1,  1, 21}, // #4
  {DBGFIELD("IIC_iALUsr_WriteALUSsr_ReadALUsr") 1, 0, 0,  1, 1,  3, 1,  1, 21}, // #5
  {DBGFIELD("IIC_iBITi_WriteALU_ReadALU") 1, 0, 0,  1, 1,  1, 1,  1, 21}, // #6
  {DBGFIELD("IIC_iBITr_WriteALU_ReadALU_ReadALU") 1, 0, 0,  1, 1,  1, 1, 22, 42}, // #7
  {DBGFIELD("IIC_iBITsr_WriteALUsi_ReadALU") 1, 0, 0,  1, 1,  2, 1,  1, 21}, // #8
  {DBGFIELD("IIC_iBITsr_WriteALUsr_ReadALUsr") 1, 0, 0,  1, 1,  3, 1,  1, 21}, // #9
  {DBGFIELD("IIC_Br_WriteBr")     1, 0, 0,  2, 1,  1, 1,  0, 0}, // #10
  {DBGFIELD("IIC_iUNAsi")         1, 0, 0,  1, 1,  2, 1,  0, 0}, // #11
  {DBGFIELD("IIC_Br_WriteBrL")    1, 0, 0,  2, 1,  1, 1,  0, 0}, // #12
  {DBGFIELD("WriteBrL")           1, 0, 0,  2, 1,  1, 1,  0, 0}, // #13
  {DBGFIELD("IIC_Br_WriteBrTbl")  1, 0, 0,  2, 1,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteBr")            1, 0, 0,  2, 1,  1, 1,  0, 0}, // #15
  {DBGFIELD("IIC_iUNAr_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #16
  {DBGFIELD("IIC_iCMPi_WriteCMP_ReadALU") 1, 0, 0,  1, 1,  1, 1,  1, 21}, // #17
  {DBGFIELD("IIC_iCMPr_WriteCMP_ReadALU_ReadALU") 1, 0, 0,  1, 1,  1, 1, 22, 42}, // #18
  {DBGFIELD("IIC_iCMPsr_WriteCMPsi_ReadALU") 1, 0, 0,  1, 1,  1, 1,  1, 21}, // #19
  {DBGFIELD("IIC_iCMPsr_WriteCMPsr_ReadALU") 1, 0, 0,  1, 1,  1, 1,  1, 21}, // #20
  {DBGFIELD("IIC_fpUNA64")        1, 0, 0,  3, 2,  1, 1,  0, 0}, // #21
  {DBGFIELD("IIC_fpUNA32")        1, 0, 0,  3, 2,  1, 1,  0, 0}, // #22
  {DBGFIELD("IIC_fpSTAT")         1, 0, 0,  3, 2,  1, 1,  0, 0}, // #23
  {DBGFIELD("IIC_iLoad_m")        65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #24
  {DBGFIELD("IIC_iLoad_mu")       65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #25
  {DBGFIELD("IIC_iLoad_mBr")      65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #26
  {DBGFIELD("IIC_iLoad_bh_ru")    1, 0, 0,  5, 2,  4, 2,  0, 0}, // #27
  {DBGFIELD("IIC_iLoad_bh_iu")    1, 0, 0,  5, 2,  4, 2,  0, 0}, // #28
  {DBGFIELD("IIC_iLoad_bh_r")     1, 0, 0,  5, 2,  4, 2,  0, 0}, // #29
  {DBGFIELD("IIC_iLoad_bh_si")    1, 0, 0,  5, 2,  6, 2,  0, 0}, // #30
  {DBGFIELD("IIC_iLoad_d_r")      1, 0, 0,  7, 2,  8, 3,  0, 0}, // #31
  {DBGFIELD("IIC_iLoad_d_ru")     1, 0, 0,  7, 2,  8, 3,  0, 0}, // #32
  {DBGFIELD("IIC_iLoad_i")        1, 0, 0,  7, 2, 11, 2,  0, 0}, // #33
  {DBGFIELD("IIC_iLoadiALU")      2, 0, 0,  9, 3, 13, 3,  0, 0}, // #34
  {DBGFIELD("IIC_iLoad_ru")       1, 0, 0,  7, 2, 11, 2,  0, 0}, // #35
  {DBGFIELD("IIC_iLoad_iu")       1, 0, 0,  7, 2, 11, 2,  0, 0}, // #36
  {DBGFIELD("IIC_iLoad_r")        1, 0, 0,  7, 2, 11, 2,  0, 0}, // #37
  {DBGFIELD("IIC_iLoad_si")       1, 0, 0,  7, 2, 16, 2,  0, 0}, // #38
  {DBGFIELD("IIC_iMAC32")         1, 0, 0, 12, 2, 18, 2,  0, 0}, // #39
  {DBGFIELD("IIC_iCMOVi_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #40
  {DBGFIELD("IIC_iMOVi_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #41
  {DBGFIELD("IIC_iCMOVix2")       2, 0, 0, 14, 1,  2, 1,  0, 0}, // #42
  {DBGFIELD("IIC_iCMOVr_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #43
  {DBGFIELD("IIC_iCMOVsr_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #44
  {DBGFIELD("IIC_iMOVix2addpc")   3, 0, 0, 12, 1,  3, 1,  0, 0}, // #45
  {DBGFIELD("IIC_iMOVix2ld")      3, 0, 0, 15, 2, 20, 1,  0, 0}, // #46
  {DBGFIELD("IIC_iMOVix2")        2, 0, 0, 14, 1,  2, 1,  0, 0}, // #47
  {DBGFIELD("IIC_iMOVr_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #48
  {DBGFIELD("IIC_iMOVsr_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #49
  {DBGFIELD("IIC_iMOVsi_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #50
  {DBGFIELD("IIC_iMUL32")         1, 0, 0, 12, 2, 18, 2,  0, 0}, // #51
  {DBGFIELD("IIC_iMVNi_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #52
  {DBGFIELD("IIC_iMVNr_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #53
  {DBGFIELD("IIC_iMVNsr_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #54
  {DBGFIELD("IIC_iALUr_WriteALU_ReadALU") 1, 0, 0,  1, 1,  1, 1,  1, 21}, // #55
  {DBGFIELD("IIC_iStore_r")       1, 0, 0,  7, 2, 14, 2,  0, 0}, // #56
  {DBGFIELD("IIC_iStore_bh_r")    1, 0, 0,  5, 2, 21, 2,  0, 0}, // #57
  {DBGFIELD("IIC_iALUsi_WriteALUsi_ReadALU") 1, 0, 0,  1, 1,  2, 1,  1, 21}, // #58
  {DBGFIELD("IIC_iBITsi_WriteALUsi_ReadALU") 1, 0, 0,  1, 1,  2, 1,  1, 21}, // #59
  {DBGFIELD("IIC_Preload_WritePreLd") 1, 0, 0,  0, 0,  1, 1,  0, 0}, // #60
  {DBGFIELD("IIC_iDIV")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #61
  {DBGFIELD("IIC_iMAC16")         1, 0, 0, 17, 2, 23, 2,  0, 0}, // #62
  {DBGFIELD("IIC_iMAC64")         1, 0, 0, 12, 2, 18, 2,  0, 0}, // #63
  {DBGFIELD("IIC_iMUL16")         1, 0, 0, 17, 2, 23, 2,  0, 0}, // #64
  {DBGFIELD("IIC_iMUL64")         1, 0, 0, 12, 2, 18, 2,  0, 0}, // #65
  {DBGFIELD("IIC_iStore_m")       65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #66
  {DBGFIELD("IIC_iStore_mu")      65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #67
  {DBGFIELD("IIC_iStore_bh_ru")   1, 0, 0,  5, 2, 21, 2,  0, 0}, // #68
  {DBGFIELD("IIC_iStore_bh_iu")   1, 0, 0,  5, 2, 21, 2,  0, 0}, // #69
  {DBGFIELD("IIC_iStore_ru")      1, 0, 0,  7, 2, 14, 2,  0, 0}, // #70
  {DBGFIELD("IIC_iStore_bh_si")   1, 0, 0, 19, 2, 25, 2,  0, 0}, // #71
  {DBGFIELD("IIC_iStore_d_r")     1, 0, 0,  7, 2, 14, 2,  0, 0}, // #72
  {DBGFIELD("IIC_iStore_d_ru")    1, 0, 0,  7, 2, 14, 2,  0, 0}, // #73
  {DBGFIELD("IIC_iStore_iu")      1, 0, 0,  7, 2, 14, 2,  0, 0}, // #74
  {DBGFIELD("IIC_iStore_si")      1, 0, 0,  5, 2, 21, 2,  0, 0}, // #75
  {DBGFIELD("IIC_Br")             1, 0, 0,  2, 1,  1, 1,  0, 0}, // #76
  {DBGFIELD("IIC_iEXTAr_WriteALUsr") 1, 0, 0,  1, 1,  3, 1,  0, 0}, // #77
  {DBGFIELD("IIC_iEXTr_WriteALUsi") 1, 0, 0,  1, 1,  2, 1,  0, 0}, // #78
  {DBGFIELD("IIC_iTSTi_WriteCMP_ReadALU") 1, 0, 0,  1, 1,  1, 1,  1, 21}, // #79
  {DBGFIELD("IIC_iTSTr_WriteCMP_ReadALU_ReadALU") 1, 0, 0,  1, 1,  1, 1, 22, 42}, // #80
  {DBGFIELD("IIC_iTSTsr_WriteCMPsi_ReadALU") 1, 0, 0,  1, 1,  1, 1,  1, 21}, // #81
  {DBGFIELD("IIC_iTSTsr_WriteCMPsr_ReadALU") 1, 0, 0,  1, 1,  1, 1,  1, 21}, // #82
  {DBGFIELD("WriteALU_ReadALU_ReadALU") 1, 0, 0,  1, 1,  1, 1, 22, 42}, // #83
  {DBGFIELD("IIC_VABAD")          1, 0, 0,  3, 2, 27, 1, 64, 2}, // #84
  {DBGFIELD("IIC_VABAQ")          1, 0, 0,  3, 2, 27, 1, 64, 2}, // #85
  {DBGFIELD("IIC_VSUBi4Q")        1, 0, 0,  3, 2, 18, 1, 66, 1}, // #86
  {DBGFIELD("IIC_VBIND")          1, 0, 0,  3, 2, 19, 1, 67, 2}, // #87
  {DBGFIELD("IIC_VBINQ")          1, 0, 0,  3, 2, 27, 1, 67, 2}, // #88
  {DBGFIELD("IIC_VSUBi4D")        1, 0, 0,  3, 2, 18, 1, 66, 1}, // #89
  {DBGFIELD("IIC_VUNAD")          1, 0, 0,  3, 2, 19, 1, 66, 1}, // #90
  {DBGFIELD("IIC_VUNAQ")          1, 0, 0,  3, 2, 27, 1, 66, 1}, // #91
  {DBGFIELD("IIC_VUNAiQ")         1, 0, 0,  3, 2, 18, 1, 66, 1}, // #92
  {DBGFIELD("IIC_VUNAiD")         1, 0, 0,  3, 2, 18, 1, 66, 1}, // #93
  {DBGFIELD("IIC_fpALU64")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #94
  {DBGFIELD("IIC_VBINi4D")        1, 0, 0,  3, 2, 18, 1, 67, 2}, // #95
  {DBGFIELD("IIC_VSHLiD")         1, 0, 0,  3, 2,  3, 1,  0, 0}, // #96
  {DBGFIELD("IIC_fpALU32")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #97
  {DBGFIELD("IIC_VSUBiD")         1, 0, 0,  3, 2,  3, 1, 66, 1}, // #98
  {DBGFIELD("IIC_VBINiQ")         1, 0, 0,  3, 2,  3, 1, 67, 2}, // #99
  {DBGFIELD("IIC_VBINiD")         1, 0, 0,  3, 2,  3, 1, 67, 2}, // #100
  {DBGFIELD("IIC_VMOVImm")        1, 0, 0,  3, 2,  3, 1,  0, 0}, // #101
  {DBGFIELD("IIC_VCNTiD")         1, 0, 0,  3, 2,  3, 1, 66, 1}, // #102
  {DBGFIELD("IIC_VCNTiQ")         1, 0, 0, 21, 2, 18, 1, 64, 1}, // #103
  {DBGFIELD("IIC_fpCMP64")        1, 0, 0,  3, 2,  1, 1,  0, 0}, // #104
  {DBGFIELD("IIC_fpCMP32")        1, 0, 0,  3, 2,  1, 1,  0, 0}, // #105
  {DBGFIELD("IIC_fpCVTSH")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #106
  {DBGFIELD("IIC_fpCVTHS")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #107
  {DBGFIELD("IIC_fpCVTDS")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #108
  {DBGFIELD("IIC_fpCVTSD")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #109
  {DBGFIELD("IIC_fpDIV64")        1, 0, 0,  3, 2, 28, 1,  0, 0}, // #110
  {DBGFIELD("IIC_fpDIV32")        1, 0, 0,  3, 2, 29, 1,  0, 0}, // #111
  {DBGFIELD("IIC_VMOVIS")         1, 0, 0,  3, 2,  1, 1,  0, 0}, // #112
  {DBGFIELD("IIC_VMOVD")          1, 0, 0,  3, 2,  2, 1,  0, 0}, // #113
  {DBGFIELD("IIC_VMOVQ")          1, 0, 0,  3, 2,  2, 1,  0, 0}, // #114
  {DBGFIELD("IIC_VEXTD")          2, 0, 0, 23, 2, 30, 2,  0, 0}, // #115
  {DBGFIELD("IIC_VEXTQ")          2, 0, 0, 23, 2, 23, 2, 65, 1}, // #116
  {DBGFIELD("IIC_fpFMAC64")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #117
  {DBGFIELD("IIC_fpFMAC32")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #118
  {DBGFIELD("IIC_VFMACD")         1, 0, 0,  3, 2, 32, 1, 64, 2}, // #119
  {DBGFIELD("IIC_VFMACQ")         1, 0, 0,  3, 2, 33, 1, 64, 2}, // #120
  {DBGFIELD("IIC_VMOVSI")         1, 0, 0,  3, 2,  2, 1,  0, 0}, // #121
  {DBGFIELD("IIC_VBINi4Q")        1, 0, 0,  3, 2, 18, 1, 67, 2}, // #122
  {DBGFIELD("IIC_VLD1dup")        1, 0, 0, 25, 3, 34, 2,  0, 0}, // #123
  {DBGFIELD("IIC_VLD1dupu")       1, 0, 0, 25, 3, 34, 2,  0, 0}, // #124
  {DBGFIELD("IIC_VLD1ln")         1, 0, 0, 28, 3, 36, 2,  0, 0}, // #125
  {DBGFIELD("IIC_VLD1lnu")        1, 0, 0, 28, 3, 36, 2,  0, 0}, // #126
  {DBGFIELD("IIC_VLD1")           1, 0, 0, 31, 3, 14, 2,  0, 0}, // #127
  {DBGFIELD("IIC_VLD1x4")         1, 0, 0, 34, 3, 30, 2,  0, 0}, // #128
  {DBGFIELD("IIC_VLD1x2u")        1, 0, 0, 31, 3, 14, 2,  0, 0}, // #129
  {DBGFIELD("IIC_VLD1x3")         1, 0, 0, 34, 3, 30, 2,  0, 0}, // #130
  {DBGFIELD("IIC_VLD1u")          1, 0, 0, 31, 3, 14, 2,  0, 0}, // #131
  {DBGFIELD("IIC_VLD1x2")         1, 0, 0, 31, 3, 14, 2,  0, 0}, // #132
  {DBGFIELD("IIC_VLD2dup")        1, 0, 0, 25, 3, 34, 2,  0, 0}, // #133
  {DBGFIELD("IIC_VLD2dupu")       1, 0, 0, 25, 3, 34, 2,  0, 0}, // #134
  {DBGFIELD("IIC_VLD2ln")         1, 0, 0, 28, 3, 36, 2,  0, 0}, // #135
  {DBGFIELD("IIC_VLD2lnu")        1, 0, 0, 28, 3, 36, 2,  0, 0}, // #136
  {DBGFIELD("IIC_VLD2")           1, 0, 0, 25, 3, 34, 2,  0, 0}, // #137
  {DBGFIELD("IIC_VLD2u")          1, 0, 0, 25, 3, 34, 2,  0, 0}, // #138
  {DBGFIELD("IIC_VLD2x2")         1, 0, 0, 28, 3, 36, 2,  0, 0}, // #139
  {DBGFIELD("IIC_VLD2x2u")        1, 0, 0, 28, 3, 36, 2,  0, 0}, // #140
  {DBGFIELD("IIC_VLD3dup")        1, 0, 0, 37, 3, 38, 2,  0, 0}, // #141
  {DBGFIELD("IIC_VLD3dupu")       1, 0, 0, 37, 3, 38, 2,  0, 0}, // #142
  {DBGFIELD("IIC_VLD3ln")         1, 0, 0, 40, 3, 40, 2,  0, 0}, // #143
  {DBGFIELD("IIC_VLD3lnu")        1, 0, 0, 40, 3, 40, 2,  0, 0}, // #144
  {DBGFIELD("IIC_VLD3")           1, 0, 0, 37, 3, 38, 2,  0, 0}, // #145
  {DBGFIELD("IIC_VLD3u")          1, 0, 0, 37, 3, 38, 2,  0, 0}, // #146
  {DBGFIELD("IIC_VLD4dup")        1, 0, 0, 34, 3, 30, 2,  0, 0}, // #147
  {DBGFIELD("IIC_VLD4dupu")       1, 0, 0, 34, 3, 30, 2,  0, 0}, // #148
  {DBGFIELD("IIC_VLD4ln")         1, 0, 0, 43, 3, 42, 2,  0, 0}, // #149
  {DBGFIELD("IIC_VLD4lnu")        1, 0, 0, 43, 3, 42, 2,  0, 0}, // #150
  {DBGFIELD("IIC_VLD4")           1, 0, 0, 43, 3, 42, 2,  0, 0}, // #151
  {DBGFIELD("IIC_VLD4u")          1, 0, 0, 43, 3, 42, 2,  0, 0}, // #152
  {DBGFIELD("IIC_fpLoad_mu")      65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #153
  {DBGFIELD("IIC_fpLoad_m")       65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #154
  {DBGFIELD("IIC_fpLoad64")       1, 0, 0, 31, 3, 14, 2,  0, 0}, // #155
  {DBGFIELD("IIC_fpLoad32")       1, 0, 0, 31, 3, 14, 2,  0, 0}, // #156
  {DBGFIELD("IIC_fpMAC64")        1, 0, 0,  3, 2, 32, 1,  0, 0}, // #157
  {DBGFIELD("IIC_VMACi32D")       1, 0, 0, 21, 2, 38, 1, 64, 2}, // #158
  {DBGFIELD("IIC_VMACi16D")       1, 0, 0,  3, 2, 27, 1, 69, 3}, // #159
  {DBGFIELD("IIC_fpMAC32")        1, 0, 0,  3, 2, 42, 1,  0, 0}, // #160
  {DBGFIELD("IIC_VMACD")          1, 0, 0,  3, 2, 32, 1, 64, 2}, // #161
  {DBGFIELD("IIC_VMACQ")          1, 0, 0,  3, 2, 33, 1, 64, 2}, // #162
  {DBGFIELD("IIC_VMACi32Q")       1, 0, 0, 21, 2, 32, 1, 64, 2}, // #163
  {DBGFIELD("IIC_VMACi16Q")       1, 0, 0,  3, 2, 38, 1, 69, 3}, // #164
  {DBGFIELD("IIC_fpMOVID")        1, 0, 0,  3, 2,  1, 1,  0, 0}, // #165
  {DBGFIELD("IIC_VQUNAiD")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #166
  {DBGFIELD("IIC_VMOVN")          1, 0, 0,  3, 2,  3, 1,  0, 0}, // #167
  {DBGFIELD("IIC_fpMOVDI")        2, 0, 0, 23, 2, 14, 2,  0, 0}, // #168
  {DBGFIELD("IIC_fpMOVSI")        1, 0, 0,  3, 2,  1, 1,  0, 0}, // #169
  {DBGFIELD("IIC_fpMOVIS")        1, 0, 0,  3, 2,  1, 1,  0, 0}, // #170
  {DBGFIELD("IIC_fpMUL64")        1, 0, 0,  3, 2, 27, 1,  0, 0}, // #171
  {DBGFIELD("IIC_VMULi16D")       1, 0, 0,  3, 2, 27, 1, 67, 2}, // #172
  {DBGFIELD("IIC_VMULi32D")       1, 0, 0, 21, 2, 38, 1, 66, 1}, // #173
  {DBGFIELD("IIC_fpMUL32")        1, 0, 0,  3, 2, 19, 1,  0, 0}, // #174
  {DBGFIELD("IIC_VFMULD")         1, 0, 0,  3, 2, 19, 1, 66, 1}, // #175
  {DBGFIELD("IIC_VFMULQ")         1, 0, 0,  3, 2, 27, 1, 66, 1}, // #176
  {DBGFIELD("IIC_VMULi16Q")       1, 0, 0,  3, 2, 38, 1, 67, 2}, // #177
  {DBGFIELD("IIC_VMULi32Q")       1, 0, 0, 21, 2, 32, 1, 66, 1}, // #178
  {DBGFIELD("IIC_VSHLiQ")         1, 0, 0,  3, 2,  3, 1,  0, 0}, // #179
  {DBGFIELD("IIC_VPALiQ")         1, 0, 0,  3, 2, 27, 1, 64, 1}, // #180
  {DBGFIELD("IIC_VPALiD")         1, 0, 0,  3, 2, 27, 1, 64, 1}, // #181
  {DBGFIELD("IIC_VPBIND")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #182
  {DBGFIELD("IIC_VQUNAiQ")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #183
  {DBGFIELD("IIC_VSHLi4Q")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #184
  {DBGFIELD("IIC_VSHLi4D")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #185
  {DBGFIELD("IIC_VRECSD")         1, 0, 0,  3, 2, 32, 1, 67, 2}, // #186
  {DBGFIELD("IIC_VRECSQ")         1, 0, 0,  3, 2, 33, 1, 67, 2}, // #187
  {DBGFIELD("IIC_VMOVISL")        1, 0, 0,  3, 2,  3, 1,  0, 0}, // #188
  {DBGFIELD("IIC_fpCVTID_WriteCvtFP") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #189
  {DBGFIELD("IIC_fpCVTIS_WriteCvtFP") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #190
  {DBGFIELD("IIC_fpCVTID")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #191
  {DBGFIELD("IIC_fpCVTIS")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #192
  {DBGFIELD("IIC_fpSQRT64")       1, 0, 0,  3, 2, 44, 1,  0, 0}, // #193
  {DBGFIELD("IIC_fpSQRT32")       1, 0, 0,  3, 2, 45, 1,  0, 0}, // #194
  {DBGFIELD("IIC_VST1ln")         1, 0, 0, 31, 3, 14, 2,  0, 0}, // #195
  {DBGFIELD("IIC_VST1lnu")        1, 0, 0, 31, 3, 14, 2,  0, 0}, // #196
  {DBGFIELD("IIC_VST1")           1, 0, 0, 31, 3, 14, 2,  0, 0}, // #197
  {DBGFIELD("IIC_VST1x4")         1, 0, 0, 34, 3, 30, 2,  0, 0}, // #198
  {DBGFIELD("IIC_VLD1x4u")        1, 0, 0, 34, 3, 30, 2,  0, 0}, // #199
  {DBGFIELD("IIC_VST1x3")         1, 0, 0, 34, 3, 30, 2,  0, 0}, // #200
  {DBGFIELD("IIC_VLD1x3u")        1, 0, 0, 34, 3, 30, 2,  0, 0}, // #201
  {DBGFIELD("IIC_VST1x4u")        1, 0, 0, 34, 3, 30, 2,  0, 0}, // #202
  {DBGFIELD("IIC_VST1x3u")        1, 0, 0, 34, 3, 30, 2,  0, 0}, // #203
  {DBGFIELD("IIC_VST1x2")         1, 0, 0, 31, 3, 14, 2,  0, 0}, // #204
  {DBGFIELD("IIC_VST2ln")         1, 0, 0, 31, 3, 14, 2,  0, 0}, // #205
  {DBGFIELD("IIC_VST2lnu")        1, 0, 0, 31, 3, 14, 2,  0, 0}, // #206
  {DBGFIELD("IIC_VST2")           1, 0, 0, 31, 3, 14, 2,  0, 0}, // #207
  {DBGFIELD("IIC_VST2x2")         1, 0, 0, 31, 3, 14, 2,  0, 0}, // #208
  {DBGFIELD("IIC_VST2x2u")        1, 0, 0, 31, 3, 14, 2,  0, 0}, // #209
  {DBGFIELD("IIC_VST3ln")         1, 0, 0, 34, 3, 30, 2,  0, 0}, // #210
  {DBGFIELD("IIC_VST3lnu")        1, 0, 0, 34, 3, 30, 2,  0, 0}, // #211
  {DBGFIELD("IIC_VST3")           1, 0, 0, 34, 3, 30, 2,  0, 0}, // #212
  {DBGFIELD("IIC_VST3u")          1, 0, 0, 34, 3, 30, 2,  0, 0}, // #213
  {DBGFIELD("IIC_VST4ln")         1, 0, 0, 34, 3, 30, 2,  0, 0}, // #214
  {DBGFIELD("IIC_VST4lnu")        1, 0, 0, 34, 3, 30, 2,  0, 0}, // #215
  {DBGFIELD("IIC_VST4")           1, 0, 0, 34, 3, 30, 2,  0, 0}, // #216
  {DBGFIELD("IIC_VST4u")          1, 0, 0, 34, 3, 30, 2,  0, 0}, // #217
  {DBGFIELD("IIC_fpStore_mu")     1, 0, 0, 31, 3, 14, 2,  0, 0}, // #218
  {DBGFIELD("IIC_fpStore_m")      1, 0, 0, 31, 3, 14, 2,  0, 0}, // #219
  {DBGFIELD("IIC_fpStore64")      1, 0, 0, 31, 3, 14, 2,  0, 0}, // #220
  {DBGFIELD("IIC_fpStore32")      1, 0, 0, 31, 3, 14, 2,  0, 0}, // #221
  {DBGFIELD("IIC_VSUBiQ")         1, 0, 0,  3, 2,  3, 1, 66, 1}, // #222
  {DBGFIELD("IIC_VTB1")           1, 0, 0,  3, 2,  3, 1, 66, 1}, // #223
  {DBGFIELD("IIC_VTB2")           1, 0, 0,  3, 2,  3, 1, 67, 2}, // #224
  {DBGFIELD("IIC_VTB3")           1, 0, 0,  3, 2, 18, 1, 72, 3}, // #225
  {DBGFIELD("IIC_VTB4")           1, 0, 0,  3, 2, 18, 1, 75, 4}, // #226
  {DBGFIELD("IIC_VTBX1")          1, 0, 0,  3, 2,  3, 1, 65, 1}, // #227
  {DBGFIELD("IIC_VTBX2")          1, 0, 0,  3, 2,  3, 1, 70, 2}, // #228
  {DBGFIELD("IIC_VTBX3")          1, 0, 0,  3, 2, 18, 1, 79, 3}, // #229
  {DBGFIELD("IIC_VTBX4")          1, 0, 0,  3, 2, 18, 1, 82, 4}, // #230
  {DBGFIELD("IIC_fpCVTDI_WriteCvtFP") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #231
  {DBGFIELD("IIC_fpCVTSI_WriteCvtFP") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #232
  {DBGFIELD("IIC_fpCVTDI")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #233
  {DBGFIELD("IIC_fpCVTSI")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #234
  {DBGFIELD("IIC_VPERMD")         2, 0, 0, 23, 2, 30, 2,  0, 0}, // #235
  {DBGFIELD("IIC_VPERMQ")         2, 0, 0, 23, 2, 30, 2,  0, 0}, // #236
  {DBGFIELD("IIC_VPERMQ3")        2, 0, 0, 23, 2, 23, 2, 65, 1}, // #237
  {DBGFIELD("IIC_iALUsi_WriteALUsi_ReadALUsr") 1, 0, 0,  1, 1,  2, 1,  1, 21}, // #238
  {DBGFIELD("IIC_iBITi")          1, 0, 0,  1, 1,  1, 1,  0, 0}, // #239
  {DBGFIELD("IIC_iCMPsi_WriteCMPsi_ReadALU_ReadALU") 1, 0, 0,  1, 1,  1, 1, 22, 42}, // #240
  {DBGFIELD("IIC_iCMPi_WriteCMP") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #241
  {DBGFIELD("IIC_iCMPr_WriteCMP") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #242
  {DBGFIELD("IIC_iCMPsi_WriteCMPsi") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #243
  {DBGFIELD("IIC_iALUx")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #244
  {DBGFIELD("IIC_iLoad_bh_i")     1, 0, 0,  5, 2,  4, 2,  0, 0}, // #245
  {DBGFIELD("IIC_iLoad_d_i")      1, 0, 0,  7, 2,  8, 3,  0, 0}, // #246
  {DBGFIELD("IIC_iCMOVsi_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #247
  {DBGFIELD("IIC_iMOVi")          1, 0, 0,  1, 1,  1, 1,  0, 0}, // #248
  {DBGFIELD("IIC_iMVNsi_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #249
  {DBGFIELD("IIC_iALUsir_WriteALUsi_ReadALU") 1, 0, 0,  1, 1,  2, 1,  1, 21}, // #250
  {DBGFIELD("IIC_iStore_bh_i")    1, 0, 0,  5, 2, 21, 2,  0, 0}, // #251
  {DBGFIELD("IIC_iStore_i")       1, 0, 0,  7, 2, 14, 2,  0, 0}, // #252
  {DBGFIELD("IIC_iEXTAsr")        1, 0, 0,  1, 1,  3, 1,  0, 0}, // #253
  {DBGFIELD("IIC_iEXTr")          1, 0, 0,  1, 1,  2, 1,  0, 0}, // #254
  {DBGFIELD("IIC_iTSTi_WriteCMP") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #255
  {DBGFIELD("IIC_iTSTr_WriteCMP") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #256
  {DBGFIELD("IIC_iTSTsi_WriteCMPsi") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #257
  {DBGFIELD("IIC_iALUr_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #258
  {DBGFIELD("IIC_iALUi_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #259
  {DBGFIELD("IIC_iBITr_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #260
  {DBGFIELD("IIC_iPop")           65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #261
  {DBGFIELD("IIC_iPop_Br_WriteBrL") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #262
  {DBGFIELD("IIC_iTSTr_WriteALU") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #263
  {DBGFIELD("ANDri_BICri_EORri_ORRri") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #264
  {DBGFIELD("ANDrr_BICrr_EORrr_ORRrr") 1, 0, 0,  1, 1,  1, 1,  0, 0}, // #265
  {DBGFIELD("ANDrsi_BICrsi_EORrsi_ORRrsi") 1, 0, 0,  1, 1,  2, 1,  0, 0}, // #266
  {DBGFIELD("ANDrsr_BICrsr_EORrsr_ORRrsr") 1, 0, 0,  1, 1,  3, 1,  0, 0}, // #267
  {DBGFIELD("MOVCCsi_MOVCCsr")    1, 0, 0,  1, 1,  2, 1,  0, 0}, // #268
  {DBGFIELD("MOVsi_MOVsr")        1, 0, 0,  1, 1,  2, 1,  0, 0}, // #269
  {DBGFIELD("MOVsra_flag_MOVsrl_flag") 1, 0, 0,  1, 1,  2, 1,  0, 0}, // #270
  {DBGFIELD("MVNsr")              1, 0, 0,  1, 1,  2, 1,  0, 0}, // #271
  {DBGFIELD("MVNr")               1, 0, 0,  1, 1,  1, 1,  1, 21}, // #272
  {DBGFIELD("MOVCCi32imm")        2, 0, 0, 14, 1,  2, 1,  0, 0}, // #273
  {DBGFIELD("MOVi32imm")          2, 0, 0, 14, 1,  2, 1,  0, 0}, // #274
  {DBGFIELD("MOV_ga_pcrel")       3, 0, 0, 12, 1,  3, 1,  0, 0}, // #275
  {DBGFIELD("MOV_ga_pcrel_ldr")   3, 0, 0, 12, 1,  3, 1,  0, 0}, // #276
  {DBGFIELD("SEL")                1, 0, 0,  1, 1,  1, 1,  0, 0}, // #277
  {DBGFIELD("BFC_BFI_SBFX_UBFX")  1, 0, 0,  1, 1,  2, 1,  0, 0}, // #278
  {DBGFIELD("MLA_MLAv5_MLS_SMMLA_SMMLAR_SMMLS_SMMLSR") 1, 0, 0, 17, 2, 18, 1,  0, 0}, // #279
  {DBGFIELD("MUL_MULv5_SMMUL_SMMULR") 1, 0, 0, 17, 2, 18, 1,  0, 0}, // #280
  {DBGFIELD("SMLAL_SMLALBB_SMLALBT_SMLALTB_SMLALTT_SMLALv5_UMAAL_UMLAL_UMLALv5") 1, 0, 0, 12, 2, 18, 2,  0, 0}, // #281
  {DBGFIELD("SMULL_SMULLv5_UMULL_UMULLv5") 1, 0, 0, 12, 2, 18, 2,  0, 0}, // #282
  {DBGFIELD("SMLAD_SMLADX_SMLALD_SMLALDX_SMLSD_SMLSDX_SMLSLD_SMLSLDX_SMUAD_SMUADX_SMUSD_SMUSDX") 1, 0, 0, 12, 2, 18, 2,  0, 0}, // #283
  {DBGFIELD("SMULBB_SMULBT_SMULTB_SMULTT_SMULWB_SMULWT") 1, 0, 0, 17, 2, 23, 2,  0, 0}, // #284
  {DBGFIELD("SMLABB_SMLABT_SMLATB_SMLATT_SMLAWB_SMLAWT") 1, 0, 0, 17, 2, 23, 2,  0, 0}, // #285
  {DBGFIELD("LDRi12_PICLDR")      1, 0, 0,  6, 1,  8, 1,  0, 0}, // #286
  {DBGFIELD("LDRrs")              1, 0, 0,  6, 1, 16, 1,  0, 0}, // #287
  {DBGFIELD("LDRBi12_LDRH_LDRSB_LDRSH_PICLDRB_PICLDRH_PICLDRSB_PICLDRSH") 1, 0, 0,  6, 1,  4, 1,  0, 0}, // #288
  {DBGFIELD("LDRHTi_LDRHTr_LDRH_POST_LDRH_PRE_LDRSBTi_LDRSBTr_LDRSB_POST_LDRSB_PRE_LDRSHTi_LDRSHTr_LDRSH_POST_LDRSH_PRE") 1, 0, 0,  6, 1,  4, 1,  0, 0}, // #289
  {DBGFIELD("SXTB_SXTB16_SXTH_UXTB_UXTB16_UXTH") 1, 0, 0,  1, 1,  2, 1,  0, 0}, // #290
  {DBGFIELD("t2SXTB_t2SXTB16_t2SXTH_t2UXTB_t2UXTB16_t2UXTH") 1, 0, 0,  1, 1,  2, 1,  0, 0}, // #291
  {DBGFIELD("t2MOVCCi32imm")      2, 0, 0, 14, 1,  2, 1,  0, 0}, // #292
  {DBGFIELD("t2MOVi32imm")        2, 0, 0, 14, 1,  2, 1,  0, 0}, // #293
  {DBGFIELD("t2MOV_ga_pcrel")     3, 0, 0, 12, 1,  3, 1,  0, 0}, // #294
  {DBGFIELD("t2MOVi16_ga_pcrel")  1, 0, 0,  1, 1,  1, 1,  0, 0}, // #295
  {DBGFIELD("t2SEL")              0, 0, 0,  0, 0,  0, 0,  0, 0}, // #296
  {DBGFIELD("t2BFC_t2SBFX_t2UBFX") 1, 0, 0,  1, 1,  2, 1,  0, 0}, // #297
  {DBGFIELD("t2BFI")              1, 0, 0,  1, 1,  1, 1,  0, 0}, // #298
  {DBGFIELD("QADD_QADD16_QADD8_QASX_QDADD_QDSUB_QSAX_QSUB_QSUB16_QSUB8_UQADD16_UQADD8_UQASX_UQSAX_UQSUB16_UQSUB8") 1, 0, 0,  1, 1,  1, 1, 22, 42}, // #299
  {DBGFIELD("SSAT_SSAT16_USAT_USAT16_t2QADD_t2QADD16_t2QADD8_t2QASX_t2QDADD_t2QDSUB_t2QSAX_t2QSUB_t2QSUB16_t2QSUB8_t2SSAT_t2SSAT16_t2UQADD16_t2UQADD8_t2UQASX_t2UQSAX_t2UQSUB16_t2UQSUB8_t2USAT_t2USAT16") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #300
  {DBGFIELD("SADD16_SADD8_SASX_SSAX_SSUB16_SSUB8_UADD16_UADD8_UASX_USAX_USUB16_USUB8") 1, 0, 0,  1, 1,  1, 1, 22, 42}, // #301
  {DBGFIELD("t2SADD16_t2SADD8_t2SASX_t2SSAX_t2SSUB16_t2SSUB8_t2UADD16_t2UADD8_t2UASX_t2USAX_t2USUB16_t2USUB8") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #302
  {DBGFIELD("SHADD16_SHADD8_SHASX_SHSAX_SHSUB16_SHSUB8_UHADD16_UHADD8_UHASX_UHSAX_UHSUB16_UHSUB8") 1, 0, 0,  1, 1,  1, 1, 22, 42}, // #303
  {DBGFIELD("SXTAB_SXTAB16_SXTAH_UXTAB_UXTAB16_UXTAH") 1, 0, 0,  1, 1,  3, 1,  0, 0}, // #304
  {DBGFIELD("t2SHADD16_t2SHADD8_t2SHASX_t2SHSAX_t2SHSUB16_t2SHSUB8_t2UHADD16_t2UHADD8_t2UHASX_t2UHSAX_t2UHSUB16_t2UHSUB8") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #305
  {DBGFIELD("t2SXTAB_t2SXTAB16_t2SXTAH_t2UXTAB_t2UXTAB16_t2UXTAH") 1, 0, 0,  1, 1,  3, 1,  0, 0}, // #306
  {DBGFIELD("USAD8")              1, 0, 0,  1, 1,  1, 1, 22, 42}, // #307
  {DBGFIELD("USADA8")             1, 0, 0,  1, 1,  1, 1, 22, 42}, // #308
  {DBGFIELD("SMUSD_SMUSDX")       1, 0, 0, 12, 2, 18, 2,  0, 0}, // #309
  {DBGFIELD("t2MUL_t2SMMUL_t2SMMULR") 1, 0, 0, 12, 2, 18, 2,  0, 0}, // #310
  {DBGFIELD("t2SMULBB_t2SMULBT_t2SMULTB_t2SMULTT_t2SMULWB_t2SMULWT") 1, 0, 0, 17, 2, 23, 2,  0, 0}, // #311
  {DBGFIELD("t2SMUSD_t2SMUSDX")   1, 0, 0, 12, 2, 18, 2,  0, 0}, // #312
  {DBGFIELD("t2MLA_t2MLS_t2SMMLA_t2SMMLAR_t2SMMLS_t2SMMLSR") 1, 0, 0, 12, 2, 18, 2,  0, 0}, // #313
  {DBGFIELD("SMUAD_SMUADX")       1, 0, 0, 12, 2, 18, 2,  0, 0}, // #314
  {DBGFIELD("t2SMUAD_t2SMUADX")   1, 0, 0, 12, 2, 18, 2,  0, 0}, // #315
  {DBGFIELD("SMLSD_SMLSDX")       1, 0, 0, 12, 2, 18, 2,  0, 0}, // #316
  {DBGFIELD("t2SMLABB_t2SMLABT_t2SMLATB_t2SMLATT_t2SMLAWB_t2SMLAWT") 1, 0, 0, 17, 2, 23, 2,  0, 0}, // #317
  {DBGFIELD("t2SMLSD_t2SMLSDX")   1, 0, 0, 12, 2, 18, 2,  0, 0}, // #318
  {DBGFIELD("SMLAD_SMLADX")       1, 0, 0, 12, 2, 18, 2,  0, 0}, // #319
  {DBGFIELD("t2SMLAD_t2SMLADX")   1, 0, 0, 12, 2, 18, 2,  0, 0}, // #320
  {DBGFIELD("SMULL_UMULL")        1, 0, 0, 12, 2, 18, 2,  0, 0}, // #321
  {DBGFIELD("t2SMULL_t2UMULL")    1, 0, 0, 12, 2, 18, 2,  0, 0}, // #322
  {DBGFIELD("t2SMLAL_t2SMLALBB_t2SMLALBT_t2SMLALD_t2SMLALDX_t2SMLALTB_t2SMLALTT_t2SMLSLD_t2SMLSLDX_t2UMAAL_t2UMLAL") 1, 0, 0, 12, 2, 18, 2,  0, 0}, // #323
  {DBGFIELD("SDIV_UDIV_t2SDIV_t2UDIV") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #324
  {DBGFIELD("LDRBi12")            1, 0, 0,  6, 1,  4, 1,  0, 0}, // #325
  {DBGFIELD("LDRBrs_t2LDRBs_t2LDRHs") 1, 0, 0,  5, 2,  6, 2,  0, 0}, // #326
  {DBGFIELD("LDREX_LDREXB_LDREXD_LDREXH_tLDRpci_pic") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #327
  {DBGFIELD("LDRi12")             1, 0, 0,  6, 1,  8, 1,  0, 0}, // #328
  {DBGFIELD("t2LDRBi12_t2LDRBi8_t2LDRBpci_t2LDRHi12_t2LDRHi8_t2LDRHpci_tLDRBi_tLDRHi") 1, 0, 0,  5, 2,  4, 2,  0, 0}, // #329
  {DBGFIELD("t2LDRi12_t2LDRi8_t2LDRpci_tLDRi_tLDRpci_tLDRspi") 1, 0, 0,  7, 2, 11, 2,  0, 0}, // #330
  {DBGFIELD("t2LDRpci_pic")       2, 0, 0,  9, 3, 13, 3,  0, 0}, // #331
  {DBGFIELD("t2LDRs")             1, 0, 0,  7, 2, 16, 2,  0, 0}, // #332
  {DBGFIELD("tLDRBr_tLDRHr")      1, 0, 0,  5, 2,  4, 2,  0, 0}, // #333
  {DBGFIELD("tLDRr")              1, 0, 0,  7, 2, 11, 2,  0, 0}, // #334
  {DBGFIELD("LDRH_PICLDRB_PICLDRH") 1, 0, 0,  6, 1,  4, 1,  0, 0}, // #335
  {DBGFIELD("LDRcp")              1, 0, 0,  7, 2, 11, 2,  0, 0}, // #336
  {DBGFIELD("t2LDRSBi12_t2LDRSBi8_t2LDRSBpci_t2LDRSHi12_t2LDRSHi8_t2LDRSHpci") 1, 0, 0,  5, 2,  4, 2,  0, 0}, // #337
  {DBGFIELD("t2LDRSBpcrel_t2LDRSHpcrel") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("t2LDRSBs_t2LDRSHs")  1, 0, 0,  5, 2,  6, 2,  0, 0}, // #339
  {DBGFIELD("tLDRSB_tLDRSH")      1, 0, 0,  5, 2,  4, 2,  0, 0}, // #340
  {DBGFIELD("LDRBT_POST_IMM_LDRBT_POST_REG_LDRB_POST_REG_LDRB_PRE_REG") 1, 0, 0,  5, 2,  4, 2,  0, 0}, // #341
  {DBGFIELD("LDRB_POST_IMM_LDRB_PRE_IMM_t2LDRB_POST_t2LDRB_PRE_t2LDRH_POST_t2LDRH_PRE") 1, 0, 0,  5, 2,  4, 2,  0, 0}, // #342
  {DBGFIELD("LDRHTi_LDRHTr_LDRH_POST_LDRH_PRE") 1, 0, 0,  6, 1,  4, 1,  0, 0}, // #343
  {DBGFIELD("LDRT_POST_IMM_LDRT_POST_REG_LDR_POST_REG_LDR_PRE_REG") 1, 0, 0,  7, 2, 11, 2,  0, 0}, // #344
  {DBGFIELD("LDR_POST_IMM_LDR_PRE_IMM_t2LDR_POST_t2LDR_PRE") 1, 0, 0,  7, 2, 11, 2,  0, 0}, // #345
  {DBGFIELD("t2LDRBT_t2LDRHT")    1, 0, 0,  5, 2,  4, 2,  0, 0}, // #346
  {DBGFIELD("t2LDRT")             1, 0, 0,  7, 2, 11, 2,  0, 0}, // #347
  {DBGFIELD("t2LDRSBT_t2LDRSHT")  1, 0, 0,  5, 2,  4, 2,  0, 0}, // #348
  {DBGFIELD("t2LDRSB_POST_t2LDRSB_PRE_t2LDRSH_POST_t2LDRSH_PRE") 1, 0, 0,  5, 2,  4, 2,  0, 0}, // #349
  {DBGFIELD("LDRD")               1, 0, 0,  7, 2,  8, 3,  0, 0}, // #350
  {DBGFIELD("t2LDRDi8")           1, 0, 0,  7, 2,  8, 3,  0, 0}, // #351
  {DBGFIELD("LDRD_POST_LDRD_PRE_t2LDRD_POST_t2LDRD_PRE") 1, 0, 0,  7, 2,  8, 3,  0, 0}, // #352
  {DBGFIELD("LDMDA_LDMDB_LDMIA_LDMIB_sysLDMDA_sysLDMDB_sysLDMIA_sysLDMIB_t2LDMDB_t2LDMIA_tLDMIA") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("LDMDA_UPD_LDMDB_UPD_LDMIA_UPD_LDMIB_UPD_sysLDMDA_UPD_sysLDMDB_UPD_sysLDMIA_UPD_sysLDMIB_UPD_t2LDMDB_UPD_t2LDMIA_UPD_tLDMIA_UPD") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #354
  {DBGFIELD("LDMIA_RET_t2LDMIA_RET") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("tPOP")               65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("tPOP_RET")           65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("PICSTR_STRi12_tSTRr") 1, 0, 0,  7, 2, 14, 2,  0, 0}, // #358
  {DBGFIELD("PICSTRB_PICSTRH_STRBi12_STRH_tSTRBr_tSTRHr") 1, 0, 0,  5, 2, 21, 2,  0, 0}, // #359
  {DBGFIELD("STRBrs_t2STRBs_t2STRHs") 1, 0, 0, 19, 2, 25, 2,  0, 0}, // #360
  {DBGFIELD("STREX_STREXB_STREXD_STREXH") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("STRrs_t2STRs")       1, 0, 0,  5, 2, 21, 2,  0, 0}, // #362
  {DBGFIELD("t2STRBi12_t2STRBi8_t2STRHi12_t2STRHi8_tSTRBi_tSTRHi") 1, 0, 0,  5, 2, 21, 2,  0, 0}, // #363
  {DBGFIELD("t2STRi12_t2STRi8_tSTRi_tSTRspi") 1, 0, 0,  7, 2, 14, 2,  0, 0}, // #364
  {DBGFIELD("STRBT_POST_STRT_POST") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("STRBT_POST_IMM_STRBT_POST_REG_STRB_POST_REG_STRB_PRE_REG_STRHTi_STRHTr_STRH_POST_STRH_PRE") 1, 0, 0,  5, 2, 21, 2,  0, 0}, // #366
  {DBGFIELD("STRB_POST_IMM_STRB_PRE_IMM_t2STRB_POST_t2STRB_PRE_t2STRH_POST") 1, 0, 0,  5, 2, 21, 2,  0, 0}, // #367
  {DBGFIELD("STRBi_preidx_STRBr_preidx_STRH_preidx_STRT_POST_IMM_STRT_POST_REG_STR_POST_REG_STR_PRE_REG_STRi_preidx_STRr_preidx_t2STRB_preidx_t2STRH_preidx_t2STR_preidx") 1, 0, 0,  7, 2, 14, 2,  0, 0}, // #368
  {DBGFIELD("STR_POST_IMM_STR_PRE_IMM_t2STRH_PRE_t2STR_POST_t2STR_PRE") 1, 0, 0,  7, 2, 14, 2,  0, 0}, // #369
  {DBGFIELD("t2STRBT_t2STRHT")    1, 0, 0,  5, 2, 21, 2,  0, 0}, // #370
  {DBGFIELD("t2STRT")             1, 0, 0,  7, 2, 14, 2,  0, 0}, // #371
  {DBGFIELD("STRD_t2STRDi8")      1, 0, 0,  7, 2, 14, 2,  0, 0}, // #372
  {DBGFIELD("STRD_POST_STRD_PRE_t2STRD_POST_t2STRD_PRE") 1, 0, 0,  7, 2, 14, 2,  0, 0}, // #373
  {DBGFIELD("STMDA_STMDB_STMIA_STMIB_sysSTMDA_sysSTMDB_sysSTMIA_sysSTMIB_t2STMDB_t2STMIA") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("STMDA_UPD_STMDB_UPD_STMIA_UPD_STMIB_UPD_sysSTMDA_UPD_sysSTMDB_UPD_sysSTMIA_UPD_sysSTMIB_UPD_t2STMDB_UPD_t2STMIA_UPD_tSTMIA_UPD") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("tPUSH")              65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #376
  {DBGFIELD("ITasm")              0, 0, 0,  0, 0,  0, 0,  0, 0}, // #377
  {DBGFIELD("t2IT")               0, 0, 0,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("VADDLsv2i64_VADDLsv4i32_VADDLsv8i16_VADDLuv2i64_VADDLuv4i32_VADDLuv8i16_VNEGs16d_VNEGs32d_VNEGs8d_VPADDLsv16i8_VPADDLsv2i32_VPADDLsv4i16_VPADDLsv4i32_VPADDLsv8i16_VPADDLsv8i8_VPADDLuv16i8_VPADDLuv2i32_VPADDLuv4i16_VPADDLuv4i32_VPADDLuv8i16_VPADDLuv8i8_VPADDi16_VPADDi32_VPADDi8_VSHLLi16_VSHLLi32_VSHLLi8_VSHLLsv2i64_VSHLLsv4i32_VSHLLsv8i16_VSHLLuv2i64_VSHLLuv4i32_VSHLLuv8i16_VSHLiv16i8_VSHLiv1i64_VSHLiv2i32_VSHLiv2i64_VSHLiv4i16_VSHLiv4i32_VSHLiv8i16_VSHLiv8i8_VSHLsv1i64_VSHLsv2i32_VSHLsv4i16_VSHLsv8i8_VSHLuv1i64_VSHLuv2i32_VSHLuv4i16_VSHLuv8i8_VSHRsv16i8_VSHRsv1i64_VSHRsv2i32_VSHRsv2i64_VSHRsv4i16_VSHRsv4i32_VSHRsv8i16_VSHRsv8i8_VSHRuv16i8_VSHRuv1i64_VSHRuv2i32_VSHRuv2i64_VSHRuv4i16_VSHRuv4i32_VSHRuv8i16_VSHRuv8i8_VSLIv1i64_VSLIv2i32_VSLIv4i16_VSLIv8i8_VSRIv1i64_VSRIv2i32_VSRIv4i16_VSRIv8i8_VSUBLsv2i64_VSUBLsv4i32_VSUBLsv8i16_VSUBLuv2i64_VSUBLuv4i32_VSUBLuv8i16") 1, 0, 0,  3, 2,  3, 1,  0, 0}, // #379
  {DBGFIELD("VADDWsv2i64_VADDWsv4i32_VADDWsv8i16_VADDWuv2i64_VADDWuv4i32_VADDWuv8i16_VSUBWsv2i64_VSUBWsv4i32_VSUBWsv8i16_VSUBWuv2i64_VSUBWuv4i32_VSUBWuv8i16_VSUBv1i64_VSUBv2i32_VSUBv4i16_VSUBv8i8") 1, 0, 0,  3, 2,  3, 1, 66, 1}, // #380
  {DBGFIELD("VADDv16i8_VADDv2i64_VADDv4i32_VADDv8i16_VANDq_VBICq_VBIFq_VBITq_VEORq_VORNq_VORRq") 1, 0, 0,  3, 2,  3, 1, 67, 2}, // #381
  {DBGFIELD("VADDv1i64_VADDv2i32_VADDv4i16_VADDv8i8_VANDd_VBICd_VBIFd_VBITd_VEORd_VORNd_VORRd") 1, 0, 0,  3, 2,  3, 1, 67, 2}, // #382
  {DBGFIELD("VBICiv2i32_VBICiv4i16_VBICiv4i32_VBICiv8i16_VORRiv2i32_VORRiv4i16_VORRiv4i32_VORRiv8i16") 1, 0, 0,  3, 2,  3, 1,  0, 0}, // #383
  {DBGFIELD("VBSLd_VCLSv2i32_VCLSv4i16_VCLSv8i8_VCLZv2i32_VCLZv4i16_VCLZv8i8_VCNTd") 1, 0, 0,  3, 2,  3, 1, 66, 1}, // #384
  {DBGFIELD("VBSLq_VCLSv16i8_VCLSv4i32_VCLSv8i16_VCLZv16i8_VCLZv4i32_VCLZv8i16_VCNTq") 1, 0, 0, 21, 2, 18, 1, 64, 1}, // #385
  {DBGFIELD("VHADDsv16i8_VHADDsv4i32_VHADDsv8i16_VHADDuv16i8_VHADDuv4i32_VHADDuv8i16_VRHADDsv16i8_VRHADDsv4i32_VRHADDsv8i16_VRHADDuv16i8_VRHADDuv4i32_VRHADDuv8i16_VTSTv16i8_VTSTv4i32_VTSTv8i16") 1, 0, 0,  3, 2, 18, 1, 67, 2}, // #386
  {DBGFIELD("VHADDsv2i32_VHADDsv4i16_VHADDsv8i8_VHADDuv2i32_VHADDuv4i16_VHADDuv8i8_VRHADDsv2i32_VRHADDsv4i16_VRHADDsv8i8_VRHADDuv2i32_VRHADDuv4i16_VRHADDuv8i8_VTSTv2i32_VTSTv4i16_VTSTv8i8") 1, 0, 0,  3, 2, 18, 1, 67, 2}, // #387
  {DBGFIELD("VHSUBsv16i8_VHSUBsv4i32_VHSUBsv8i16_VHSUBuv16i8_VHSUBuv4i32_VHSUBuv8i16") 1, 0, 0,  3, 2, 18, 1, 66, 1}, // #388
  {DBGFIELD("VHSUBsv2i32_VHSUBsv4i16_VHSUBsv8i8_VHSUBuv2i32_VHSUBuv4i16_VHSUBuv8i8") 1, 0, 0,  3, 2, 18, 1, 66, 1}, // #389
  {DBGFIELD("VNEGf32q")           1, 0, 0,  3, 2, 27, 1, 66, 1}, // #390
  {DBGFIELD("VNEGfd")             1, 0, 0,  3, 2, 19, 1, 66, 1}, // #391
  {DBGFIELD("VNEGs16q_VNEGs32q_VNEGs8q_VSHLsv16i8_VSHLsv2i64_VSHLsv4i32_VSHLsv8i16_VSHLuv16i8_VSHLuv2i64_VSHLuv4i32_VSHLuv8i16_VSLIv16i8_VSLIv2i64_VSLIv4i32_VSLIv8i16_VSRIv16i8_VSRIv2i64_VSRIv4i32_VSRIv8i16") 1, 0, 0,  3, 2,  3, 1,  0, 0}, // #392
  {DBGFIELD("VQSHLsiv16i8_VQSHLsiv1i64_VQSHLsiv2i32_VQSHLsiv2i64_VQSHLsiv4i16_VQSHLsiv4i32_VQSHLsiv8i16_VQSHLsiv8i8_VQSHLsuv16i8_VQSHLsuv1i64_VQSHLsuv2i32_VQSHLsuv2i64_VQSHLsuv4i16_VQSHLsuv4i32_VQSHLsuv8i16_VQSHLsuv8i8_VQSHLsv1i64_VQSHLsv2i32_VQSHLsv4i16_VQSHLsv8i8_VQSHLuiv16i8_VQSHLuiv1i64_VQSHLuiv2i32_VQSHLuiv2i64_VQSHLuiv4i16_VQSHLuiv4i32_VQSHLuiv8i16_VQSHLuiv8i8_VQSHLuv1i64_VQSHLuv2i32_VQSHLuv4i16_VQSHLuv8i8") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #393
  {DBGFIELD("VQSHLsv16i8_VQSHLsv2i64_VQSHLsv4i32_VQSHLsv8i16_VQSHLuv16i8_VQSHLuv2i64_VQSHLuv4i32_VQSHLuv8i16") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #394
  {DBGFIELD("VSUBv16i8_VSUBv2i64_VSUBv4i32_VSUBv8i16") 1, 0, 0,  3, 2,  3, 1, 66, 1}, // #395
  {DBGFIELD("VEXTd16_VEXTd32_VEXTd8") 2, 0, 0, 23, 2, 30, 2,  0, 0}, // #396
  {DBGFIELD("VEXTq16_VEXTq32_VEXTq64_VEXTq8") 2, 0, 0, 23, 2, 23, 2, 65, 1}, // #397
  {DBGFIELD("VREV16d8_VREV32d16_VREV32d8_VREV64d16_VREV64d32_VREV64d8") 1, 0, 0,  3, 2,  2, 1,  0, 0}, // #398
  {DBGFIELD("VREV16q8_VREV32q16_VREV32q8_VREV64q16_VREV64q32_VREV64q8") 1, 0, 0,  3, 2,  2, 1,  0, 0}, // #399
  {DBGFIELD("VABALsv2i64_VABALsv4i32_VABALsv8i16_VABALuv2i64_VABALuv4i32_VABALuv8i16_VABAsv2i32_VABAsv4i16_VABAsv8i8_VABAuv2i32_VABAuv4i16_VABAuv8i8") 1, 0, 0,  3, 2, 27, 1, 64, 2}, // #400
  {DBGFIELD("VABAsv16i8_VABAsv4i32_VABAsv8i16_VABAuv16i8_VABAuv4i32_VABAuv8i16") 1, 0, 0,  3, 2, 27, 1, 64, 2}, // #401
  {DBGFIELD("VABSfd")             1, 0, 0,  3, 2, 19, 1, 66, 1}, // #402
  {DBGFIELD("VABSfq")             1, 0, 0,  3, 2, 27, 1, 66, 1}, // #403
  {DBGFIELD("VABSv16i8_VABSv4i32_VABSv8i16") 1, 0, 0,  3, 2, 18, 1, 66, 1}, // #404
  {DBGFIELD("VABSv2i32_VABSv4i16_VABSv8i8") 1, 0, 0,  3, 2, 18, 1, 66, 1}, // #405
  {DBGFIELD("VACGEd_VACGTd_VCEQfd_VCGEfd_VCGTfd") 1, 0, 0,  3, 2, 19, 1, 67, 2}, // #406
  {DBGFIELD("VACGEq_VACGTq_VCEQfq_VCGEfq_VCGTfq") 1, 0, 0,  3, 2, 27, 1, 67, 2}, // #407
  {DBGFIELD("VCEQv16i8_VCEQv4i32_VCEQv8i16_VCGEsv16i8_VCGEsv4i32_VCGEsv8i16_VCGEuv16i8_VCGEuv4i32_VCGEuv8i16_VCGTsv16i8_VCGTsv4i32_VCGTsv8i16_VCGTuv16i8_VCGTuv4i32_VCGTuv8i16_VQSUBsv16i8_VQSUBsv2i64_VQSUBsv4i32_VQSUBsv8i16_VQSUBuv16i8_VQSUBuv2i64_VQSUBuv4i32_VQSUBuv8i16") 1, 0, 0,  3, 2, 18, 1, 66, 1}, // #408
  {DBGFIELD("VCEQv2i32_VCEQv4i16_VCEQv8i8_VCGEsv2i32_VCGEsv4i16_VCGEsv8i8_VCGEuv2i32_VCGEuv4i16_VCGEuv8i8_VCGTsv2i32_VCGTsv4i16_VCGTsv8i8_VCGTuv2i32_VCGTuv4i16_VCGTuv8i8_VQSUBsv1i64_VQSUBsv2i32_VQSUBsv4i16_VQSUBsv8i8_VQSUBuv1i64_VQSUBuv2i32_VQSUBuv4i16_VQSUBuv8i8") 1, 0, 0,  3, 2, 18, 1, 66, 1}, // #409
  {DBGFIELD("VCEQzv16i8_VCEQzv2f32_VCEQzv2i32_VCEQzv4f32_VCEQzv4i16_VCEQzv4i32_VCEQzv8i16_VCEQzv8i8_VCGEzv16i8_VCGEzv2f32_VCGEzv2i32_VCGEzv4f32_VCGEzv4i16_VCGEzv4i32_VCGEzv8i16_VCGEzv8i8_VCGTzv16i8_VCGTzv2f32_VCGTzv2i32_VCGTzv4f32_VCGTzv4i16_VCGTzv4i32_VCGTzv8i16_VCGTzv8i8_VCLEzv16i8_VCLEzv2f32_VCLEzv2i32_VCLEzv4f32_VCLEzv4i16_VCLEzv4i32_VCLEzv8i16_VCLEzv8i8_VCLTzv16i8_VCLTzv2f32_VCLTzv2i32_VCLTzv4f32_VCLTzv4i16_VCLTzv4i32_VCLTzv8i16_VCLTzv8i8") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("VPADALsv16i8_VPADALsv4i32_VPADALsv8i16_VPADALuv16i8_VPADALuv4i32_VPADALuv8i16") 1, 0, 0,  3, 2, 27, 1, 64, 1}, // #411
  {DBGFIELD("VPADALsv2i32_VPADALsv4i16_VPADALsv8i8_VPADALuv2i32_VPADALuv4i16_VPADALuv8i8_VRSRAsv16i8_VRSRAsv1i64_VRSRAsv2i32_VRSRAsv2i64_VRSRAsv4i16_VRSRAsv4i32_VRSRAsv8i16_VRSRAsv8i8_VRSRAuv16i8_VRSRAuv1i64_VRSRAuv2i32_VRSRAuv2i64_VRSRAuv4i16_VRSRAuv4i32_VRSRAuv8i16_VRSRAuv8i8_VSRAsv16i8_VSRAsv1i64_VSRAsv2i32_VSRAsv2i64_VSRAsv4i16_VSRAsv4i32_VSRAsv8i16_VSRAsv8i8_VSRAuv16i8_VSRAuv1i64_VSRAuv2i32_VSRAuv2i64_VSRAuv4i16_VSRAuv4i32_VSRAuv8i16_VSRAuv8i8") 1, 0, 0,  3, 2, 27, 1, 64, 1}, // #412
  {DBGFIELD("VQABSv16i8_VQABSv4i32_VQABSv8i16_VQNEGv16i8_VQNEGv4i32_VQNEGv8i16") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #413
  {DBGFIELD("VQABSv2i32_VQABSv4i16_VQABSv8i8_VQNEGv2i32_VQNEGv4i16_VQNEGv8i8") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #414
  {DBGFIELD("VQADDsv16i8_VQADDsv2i64_VQADDsv4i32_VQADDsv8i16_VQADDuv16i8_VQADDuv2i64_VQADDuv4i32_VQADDuv8i16") 1, 0, 0,  3, 2, 18, 1, 67, 2}, // #415
  {DBGFIELD("VQADDsv1i64_VQADDsv2i32_VQADDsv4i16_VQADDsv8i8_VQADDuv1i64_VQADDuv2i32_VQADDuv4i16_VQADDuv8i8") 1, 0, 0,  3, 2, 18, 1, 67, 2}, // #416
  {DBGFIELD("VQRSHLsv16i8_VQRSHLsv2i64_VQRSHLsv4i32_VQRSHLsv8i16_VQRSHLuv16i8_VQRSHLuv2i64_VQRSHLuv4i32_VQRSHLuv8i16_VRSHLsv16i8_VRSHLsv2i64_VRSHLsv4i32_VRSHLsv8i16_VRSHLuv16i8_VRSHLuv2i64_VRSHLuv4i32_VRSHLuv8i16") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #417
  {DBGFIELD("VQRSHLsv1i64_VQRSHLsv2i32_VQRSHLsv4i16_VQRSHLsv8i8_VQRSHLuv1i64_VQRSHLuv2i32_VQRSHLuv4i16_VQRSHLuv8i8_VRSHLsv1i64_VRSHLsv2i32_VRSHLsv4i16_VRSHLsv8i8_VRSHLuv1i64_VRSHLuv2i32_VRSHLuv4i16_VRSHLuv8i8_VRSHRsv16i8_VRSHRsv1i64_VRSHRsv2i32_VRSHRsv2i64_VRSHRsv4i16_VRSHRsv4i32_VRSHRsv8i16_VRSHRsv8i8_VRSHRuv16i8_VRSHRuv1i64_VRSHRuv2i32_VRSHRuv2i64_VRSHRuv4i16_VRSHRuv4i32_VRSHRuv8i16_VRSHRuv8i8") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #418
  {DBGFIELD("VRECPEd_VRECPEfd_VRSQRTEd_VRSQRTEfd") 1, 0, 0,  3, 2, 19, 1, 66, 1}, // #419
  {DBGFIELD("VRECPEfq_VRECPEq_VRSQRTEfq_VRSQRTEq") 1, 0, 0,  3, 2, 27, 1, 66, 1}, // #420
  {DBGFIELD("VADDHNv2i32_VADDHNv4i16_VADDHNv8i8_VSUBHNv2i32_VSUBHNv4i16_VSUBHNv8i8") 1, 0, 0,  3, 2, 18, 1, 67, 2}, // #421
  {DBGFIELD("VSHRNv2i32_VSHRNv4i16_VSHRNv8i8") 1, 0, 0,  3, 2,  3, 1,  0, 0}, // #422
  {DBGFIELD("VQRSHRNsv2i32_VQRSHRNsv4i16_VQRSHRNsv8i8_VQRSHRNuv2i32_VQRSHRNuv4i16_VQRSHRNuv8i8_VQRSHRUNv2i32_VQRSHRUNv4i16_VQRSHRUNv8i8_VQSHRNsv2i32_VQSHRNsv4i16_VQSHRNsv8i8_VQSHRNuv2i32_VQSHRNuv4i16_VQSHRNuv8i8_VQSHRUNv2i32_VQSHRUNv4i16_VQSHRUNv8i8_VRSHRNv2i32_VRSHRNv4i16_VRSHRNv8i8") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #423
  {DBGFIELD("VRADDHNv2i32_VRADDHNv4i16_VRADDHNv8i8_VRSUBHNv2i32_VRSUBHNv4i16_VRSUBHNv8i8") 1, 0, 0,  3, 2, 18, 1, 67, 2}, // #424
  {DBGFIELD("VTBL1")              1, 0, 0,  3, 2,  3, 1, 66, 1}, // #425
  {DBGFIELD("VTBX1")              1, 0, 0,  3, 2,  3, 1, 65, 1}, // #426
  {DBGFIELD("VTBL2")              1, 0, 0,  3, 2,  3, 1, 67, 2}, // #427
  {DBGFIELD("VTBX2")              1, 0, 0,  3, 2,  3, 1, 70, 2}, // #428
  {DBGFIELD("VTBL3_VTBL3Pseudo")  1, 0, 0,  3, 2, 18, 1, 72, 3}, // #429
  {DBGFIELD("VTBX3_VTBX3Pseudo")  1, 0, 0,  3, 2, 18, 1, 79, 3}, // #430
  {DBGFIELD("VTBL4_VTBL4Pseudo")  1, 0, 0,  3, 2, 18, 1, 75, 4}, // #431
  {DBGFIELD("VTBX4_VTBX4Pseudo")  1, 0, 0,  3, 2, 18, 1, 82, 4}, // #432
  {DBGFIELD("VSWPd_VSWPq")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("VTRNd16_VTRNd32_VTRNd8_VUZPd16_VUZPd8_VZIPd16_VZIPd8") 2, 0, 0, 23, 2, 30, 2,  0, 0}, // #434
  {DBGFIELD("VTRNq16_VTRNq32_VTRNq8") 2, 0, 0, 23, 2, 30, 2,  0, 0}, // #435
  {DBGFIELD("VUZPq16_VUZPq32_VUZPq8_VZIPq16_VZIPq32_VZIPq8") 2, 0, 0, 23, 2, 23, 2, 65, 1}, // #436
  {DBGFIELD("VABSD_VNEGD")        1, 0, 0,  3, 2,  1, 1,  0, 0}, // #437
  {DBGFIELD("VABSS_VNEGS")        1, 0, 0,  3, 2,  1, 1,  0, 0}, // #438
  {DBGFIELD("VCMPD_VCMPED_VCMPEZD_VCMPZD") 1, 0, 0,  3, 2,  1, 1,  0, 0}, // #439
  {DBGFIELD("VCMPES_VCMPEZS_VCMPS_VCMPZS") 1, 0, 0,  3, 2,  1, 1,  0, 0}, // #440
  {DBGFIELD("VABDLsv2i64_VABDLsv4i32_VABDLsv8i16_VABDLuv2i64_VABDLuv4i32_VABDLuv8i16_VABDsv16i8_VABDsv4i32_VABDsv8i16_VABDuv16i8_VABDuv4i32_VABDuv8i16_VMAXsv16i8_VMAXsv4i32_VMAXsv8i16_VMAXuv16i8_VMAXuv4i32_VMAXuv8i16_VMINsv16i8_VMINsv4i32_VMINsv8i16_VMINuv16i8_VMINuv4i32_VMINuv8i16") 1, 0, 0,  3, 2, 18, 1, 66, 1}, // #441
  {DBGFIELD("VABDfd_VADDfd_VMAXfd_VMINfd_VSUBfd") 1, 0, 0,  3, 2, 19, 1, 67, 2}, // #442
  {DBGFIELD("VABDfq_VADDfq_VMAXfq_VMINfq_VSUBfq") 1, 0, 0,  3, 2, 27, 1, 67, 2}, // #443
  {DBGFIELD("VABDsv2i32_VABDsv4i16_VABDsv8i8_VABDuv2i32_VABDuv4i16_VABDuv8i8_VMAXsv2i32_VMAXsv4i16_VMAXsv8i8_VMAXuv2i32_VMAXuv4i16_VMAXuv8i8_VMINsv2i32_VMINsv4i16_VMINsv8i8_VMINuv2i32_VMINuv4i16_VMINuv8i8_VPMAXs16_VPMAXs32_VPMAXs8_VPMAXu16_VPMAXu32_VPMAXu8_VPMINs16_VPMINs32_VPMINs8_VPMINu16_VPMINu32_VPMINu8") 1, 0, 0,  3, 2, 18, 1, 66, 1}, // #444
  {DBGFIELD("VADDS_VSUBS")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #445
  {DBGFIELD("VMAXNMD_VMAXNMND_VMAXNMNQ_VMAXNMS_VMINNMD_VMINNMND_VMINNMNQ_VMINNMS") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("VPADDf_VPMAXf_VPMINf") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("VADDD_VSUBD")        1, 0, 0,  3, 2, 18, 1,  0, 0}, // #448
  {DBGFIELD("VRECPSfd_VRSQRTSfd") 1, 0, 0,  3, 2, 32, 1, 67, 2}, // #449
  {DBGFIELD("VRECPSfq_VRSQRTSfq") 1, 0, 0,  3, 2, 33, 1, 67, 2}, // #450
  {DBGFIELD("VMULLp64")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("VMULLp8_VMULLslsv2i32_VMULLslsv4i16_VMULLsluv2i32_VMULLsluv4i16_VMULLsv4i32_VMULLsv8i16_VMULLuv4i32_VMULLuv8i16_VMULpd_VMULslv4i16_VMULv4i16_VMULv8i8_VQDMULHslv4i16_VQDMULHv4i16_VQDMULLslv2i32_VQDMULLslv4i16_VQDMULLv4i32_VQRDMULHslv4i16_VQRDMULHv4i16") 1, 0, 0,  3, 2, 27, 1, 67, 2}, // #452
  {DBGFIELD("VMULLsv2i64_VMULLuv2i64_VMULslv2i32_VMULv2i32_VQDMULHslv2i32_VQDMULHv2i32_VQDMULLv2i64_VQRDMULHslv2i32_VQRDMULHv2i32") 1, 0, 0, 21, 2, 38, 1, 66, 1}, // #453
  {DBGFIELD("VMULS_VNMULS")       1, 0, 0,  3, 2, 19, 1,  0, 0}, // #454
  {DBGFIELD("VMULfd")             1, 0, 0,  3, 2, 19, 1, 66, 1}, // #455
  {DBGFIELD("VMULfq")             1, 0, 0,  3, 2, 27, 1, 66, 1}, // #456
  {DBGFIELD("VMULpq_VMULslv8i16_VMULv16i8_VMULv8i16_VQDMULHslv8i16_VQDMULHv8i16_VQRDMULHslv8i16_VQRDMULHv8i16") 1, 0, 0,  3, 2, 38, 1, 67, 2}, // #457
  {DBGFIELD("VMULslfd")           1, 0, 0,  3, 2, 19, 1, 67, 2}, // #458
  {DBGFIELD("VMULslfq")           1, 0, 0,  3, 2, 27, 1, 67, 2}, // #459
  {DBGFIELD("VMULslv4i32_VMULv4i32_VQDMULHslv4i32_VQDMULHv4i32_VQRDMULHslv4i32_VQRDMULHv4i32") 1, 0, 0, 21, 2, 32, 1, 66, 1}, // #460
  {DBGFIELD("VMULD_VNMULD")       1, 0, 0,  3, 2, 27, 1,  0, 0}, // #461
  {DBGFIELD("VFMAD_VFMSD_VFNMAD_VFNMSD") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("VFMAS_VFMSS_VFNMAS_VFNMSS") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("VMLAD_VMLSD_VNMLAD_VNMLSD") 1, 0, 0,  3, 2, 32, 1,  0, 0}, // #464
  {DBGFIELD("VMLALslsv2i32_VMLALsluv2i32_VMLALsv2i64_VMLALuv2i64_VMLAslv2i32_VMLAv2i32_VMLSLslsv2i32_VMLSLsluv2i32_VMLSLsv2i64_VMLSLuv2i64_VMLSslv2i32_VMLSv2i32_VQDMLALslv2i32_VQDMLALv2i64_VQDMLSLslv2i32_VQDMLSLv2i64") 1, 0, 0, 21, 2, 38, 1, 64, 2}, // #465
  {DBGFIELD("VMLALslsv4i16_VMLALsluv4i16_VMLALsv4i32_VMLALsv8i16_VMLALuv4i32_VMLALuv8i16_VMLAslv4i16_VMLAv4i16_VMLAv8i8_VMLSLslsv4i16_VMLSLsluv4i16_VMLSLsv4i32_VMLSLsv8i16_VMLSLuv4i32_VMLSLuv8i16_VMLSslv4i16_VMLSv4i16_VMLSv8i8_VQDMLALslv4i16_VQDMLALv4i32_VQDMLSLslv4i16_VQDMLSLv4i32") 1, 0, 0,  3, 2, 27, 1, 69, 3}, // #466
  {DBGFIELD("VMLAS_VMLSS_VNMLAS_VNMLSS") 1, 0, 0,  3, 2, 42, 1,  0, 0}, // #467
  {DBGFIELD("VMLAfd_VMLAslfd_VMLSfd_VMLSslfd") 1, 0, 0,  3, 2, 32, 1, 64, 2}, // #468
  {DBGFIELD("VMLAfq_VMLAslfq_VMLSfq_VMLSslfq") 1, 0, 0,  3, 2, 33, 1, 64, 2}, // #469
  {DBGFIELD("VMLAslv4i32_VMLAv4i32_VMLSslv4i32_VMLSv4i32") 1, 0, 0, 21, 2, 32, 1, 64, 2}, // #470
  {DBGFIELD("VMLAslv8i16_VMLAv16i8_VMLAv8i16_VMLSslv8i16_VMLSv16i8_VMLSv8i16") 1, 0, 0,  3, 2, 38, 1, 69, 3}, // #471
  {DBGFIELD("VFMAfd_VFMSfd")      1, 0, 0,  3, 2, 32, 1, 64, 2}, // #472
  {DBGFIELD("VFMAfq_VFMSfq")      1, 0, 0,  3, 2, 33, 1, 64, 2}, // #473
  {DBGFIELD("VCVTANSD_VCVTANSQ_VCVTANUD_VCVTANUQ_VCVTASD_VCVTASS_VCVTAUD_VCVTAUS_VCVTBDH_VCVTBHD_VCVTMNSD_VCVTMNSQ_VCVTMNUD_VCVTMNUQ_VCVTMSD_VCVTMSS_VCVTMUD_VCVTMUS_VCVTNNSD_VCVTNNSQ_VCVTNNUD_VCVTNNUQ_VCVTNSD_VCVTNSS_VCVTNUD_VCVTNUS_VCVTPNSD_VCVTPNSQ_VCVTPNUD_VCVTPNUQ_VCVTPSD_VCVTPSS_VCVTPUD_VCVTPUS_VCVTTDH_VCVTTHD") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("VCVTBHS_VCVTTHS")    1, 0, 0,  3, 2, 18, 1,  0, 0}, // #475
  {DBGFIELD("VCVTBSH_VCVTTSH")    1, 0, 0,  3, 2, 18, 1,  0, 0}, // #476
  {DBGFIELD("VCVTDS")             1, 0, 0,  3, 2, 18, 1,  0, 0}, // #477
  {DBGFIELD("VCVTSD")             1, 0, 0,  3, 2, 18, 1,  0, 0}, // #478
  {DBGFIELD("VCVTf2h_VCVTf2sq_VCVTf2uq_VCVTf2xsq_VCVTf2xuq_VCVTh2f_VCVTs2fq_VCVTu2fq_VCVTxs2fq_VCVTxu2fq") 1, 0, 0,  3, 2, 27, 1, 66, 1}, // #479
  {DBGFIELD("VCVTf2sd_VCVTf2ud_VCVTf2xsd_VCVTf2xud_VCVTs2fd_VCVTu2fd_VCVTxs2fd_VCVTxu2fd") 1, 0, 0,  3, 2, 19, 1, 66, 1}, // #480
  {DBGFIELD("VSITOD_VUITOD")      1, 0, 0,  3, 2, 18, 1,  0, 0}, // #481
  {DBGFIELD("VSITOS_VUITOS")      1, 0, 0,  3, 2, 18, 1,  0, 0}, // #482
  {DBGFIELD("VTOSHD_VTOSLD_VTOUHD_VTOULD") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #483
  {DBGFIELD("VTOSHS_VTOSLS_VTOUHS_VTOULS") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #484
  {DBGFIELD("VTOSIRD_VTOSIZD_VTOUIRD_VTOUIZD") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #485
  {DBGFIELD("VTOSIRS_VTOSIZS_VTOUIRS_VTOUIZS") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #486
  {DBGFIELD("FCONSTD_VMOVD_VMOVDcc") 1, 0, 0,  3, 2,  1, 1,  0, 0}, // #487
  {DBGFIELD("FCONSTS_VMOVS_VMOVScc") 1, 0, 0,  3, 2,  1, 1,  0, 0}, // #488
  {DBGFIELD("VMOVv16i8_VMOVv1i64_VMOVv2f32_VMOVv2i32_VMOVv2i64_VMOVv4f32_VMOVv4i16_VMOVv4i32_VMOVv8i16_VMOVv8i8_VMVNv2i32_VMVNv4i16_VMVNv4i32_VMVNv8i16") 1, 0, 0,  3, 2,  3, 1,  0, 0}, // #489
  {DBGFIELD("VMVNd_VMVNq")        1, 0, 0,  3, 2,  3, 1, 66, 1}, // #490
  {DBGFIELD("VMOVLsv2i64_VMOVLsv4i32_VMOVLsv8i16_VMOVLuv2i64_VMOVLuv4i32_VMOVLuv8i16") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #491
  {DBGFIELD("VMOVNv2i32_VMOVNv4i16_VMOVNv8i8") 1, 0, 0,  3, 2,  3, 1,  0, 0}, // #492
  {DBGFIELD("VQMOVNsuv2i32_VQMOVNsuv4i16_VQMOVNsuv8i8_VQMOVNsv2i32_VQMOVNsv4i16_VQMOVNsv8i8_VQMOVNuv2i32_VQMOVNuv4i16_VQMOVNuv8i8") 1, 0, 0,  3, 2, 18, 1,  0, 0}, // #493
  {DBGFIELD("VDUPLN16d_VDUPLN32d_VDUPLN8d") 1, 0, 0,  3, 2,  2, 1,  0, 0}, // #494
  {DBGFIELD("VDUPLN16q_VDUPLN32q_VDUPLN8q") 1, 0, 0,  3, 2,  2, 1,  0, 0}, // #495
  {DBGFIELD("VDUP16d_VDUP16q_VDUP32d_VDUP32q_VDUP8d_VDUP8q") 1, 0, 0,  3, 2,  1, 1,  0, 0}, // #496
  {DBGFIELD("VMOVRS")             1, 0, 0,  3, 2,  1, 1,  0, 0}, // #497
  {DBGFIELD("VMOVSR")             1, 0, 0,  3, 2,  1, 1,  0, 0}, // #498
  {DBGFIELD("VSETLNi16_VSETLNi32_VSETLNi8") 1, 0, 0,  3, 2,  3, 1,  0, 0}, // #499
  {DBGFIELD("VMOVRRD_VMOVRRS")    2, 0, 0, 23, 2, 14, 2,  0, 0}, // #500
  {DBGFIELD("VMOVDRR")            1, 0, 0,  3, 2,  1, 1,  0, 0}, // #501
  {DBGFIELD("VMOVSRR")            1, 0, 0,  3, 2,  1, 1,  0, 0}, // #502
  {DBGFIELD("VGETLNi32_VGETLNu16_VGETLNu8") 1, 0, 0,  3, 2,  2, 1,  0, 0}, // #503
  {DBGFIELD("VGETLNs16_VGETLNs8") 1, 0, 0,  3, 2,  2, 1,  0, 0}, // #504
  {DBGFIELD("VMRS_VMRS_FPEXC_VMRS_FPINST_VMRS_FPINST2_VMRS_FPSID_VMRS_MVFR0_VMRS_MVFR1_VMRS_MVFR2") 1, 0, 0,  3, 2,  1, 1,  0, 0}, // #505
  {DBGFIELD("VMSR_VMSR_FPEXC_VMSR_FPINST_VMSR_FPINST2_VMSR_FPSID") 1, 0, 0,  3, 2,  1, 1,  0, 0}, // #506
  {DBGFIELD("FMSTAT")             1, 0, 0,  3, 2,  1, 1,  0, 0}, // #507
  {DBGFIELD("VLDRD")              1, 0, 0, 31, 3, 14, 2,  0, 0}, // #508
  {DBGFIELD("VLDRS")              1, 0, 0, 31, 3, 14, 2,  0, 0}, // #509
  {DBGFIELD("VSTRD")              1, 0, 0, 31, 3, 14, 2,  0, 0}, // #510
  {DBGFIELD("VSTRS")              1, 0, 0, 31, 3, 14, 2,  0, 0}, // #511
  {DBGFIELD("VLDMQIA")            65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("VSTMQIA")            1, 0, 0, 31, 3, 14, 2,  0, 0}, // #513
  {DBGFIELD("VLDMDIA_VLDMSIA")    65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("VLDMDDB_UPD_VLDMDIA_UPD_VLDMSDB_UPD_VLDMSIA_UPD") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("VSTMDIA_VSTMSIA")    1, 0, 0, 31, 3, 14, 2,  0, 0}, // #516
  {DBGFIELD("VSTMDDB_UPD_VSTMDIA_UPD_VSTMSDB_UPD_VSTMSIA_UPD") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #517
  {DBGFIELD("VLD1d16_VLD1d32_VLD1d64_VLD1d8") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #518
  {DBGFIELD("VLD1q16_VLD1q32_VLD1q64_VLD1q8") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #519
  {DBGFIELD("VLD1d16wb_fixed_VLD1d16wb_register_VLD1d32wb_fixed_VLD1d32wb_register_VLD1d64wb_fixed_VLD1d64wb_register_VLD1d8wb_fixed_VLD1d8wb_register") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #520
  {DBGFIELD("VLD1q16wb_fixed_VLD1q16wb_register_VLD1q32wb_fixed_VLD1q32wb_register_VLD1q64wb_fixed_VLD1q64wb_register_VLD1q8wb_fixed_VLD1q8wb_register") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #521
  {DBGFIELD("VLD1d16T_VLD1d32T_VLD1d64T_VLD1d64TPseudo_VLD1d64TPseudoWB_fixed_VLD1d64TPseudoWB_register_VLD1d8T") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #522
  {DBGFIELD("VLD1d16Twb_fixed_VLD1d16Twb_register_VLD1d32Twb_fixed_VLD1d32Twb_register_VLD1d64Twb_fixed_VLD1d64Twb_register_VLD1d8Twb_fixed_VLD1d8Twb_register") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #523
  {DBGFIELD("VLD1d16Q_VLD1d32Q_VLD1d64Q_VLD1d64QPseudo_VLD1d64QPseudoWB_fixed_VLD1d64QPseudoWB_register_VLD1d8Q") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #524
  {DBGFIELD("VLD1d16Qwb_fixed_VLD1d16Qwb_register_VLD1d32Qwb_fixed_VLD1d32Qwb_register_VLD1d64Qwb_fixed_VLD1d64Qwb_register_VLD1d8Qwb_fixed_VLD1d8Qwb_register") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #525
  {DBGFIELD("VLD2b16_VLD2b32_VLD2b8_VLD2d16_VLD2d32_VLD2d8") 1, 0, 0, 25, 3, 34, 2,  0, 0}, // #526
  {DBGFIELD("VLD2q16_VLD2q16Pseudo_VLD2q32_VLD2q32Pseudo_VLD2q8_VLD2q8Pseudo") 1, 0, 0, 28, 3, 36, 2,  0, 0}, // #527
  {DBGFIELD("VLD2b16wb_fixed_VLD2b16wb_register_VLD2b32wb_fixed_VLD2b32wb_register_VLD2b8wb_fixed_VLD2b8wb_register_VLD2d16wb_fixed_VLD2d16wb_register_VLD2d32wb_fixed_VLD2d32wb_register_VLD2d8wb_fixed_VLD2d8wb_register") 1, 0, 0, 25, 3, 34, 2,  0, 0}, // #528
  {DBGFIELD("VLD2q16PseudoWB_fixed_VLD2q16PseudoWB_register_VLD2q16wb_fixed_VLD2q16wb_register_VLD2q32PseudoWB_fixed_VLD2q32PseudoWB_register_VLD2q32wb_fixed_VLD2q32wb_register_VLD2q8PseudoWB_fixed_VLD2q8PseudoWB_register_VLD2q8wb_fixed_VLD2q8wb_register") 1, 0, 0, 28, 3, 36, 2,  0, 0}, // #529
  {DBGFIELD("VLD3d16_VLD3d32_VLD3d8_VLD3q16_VLD3q32_VLD3q8") 1, 0, 0, 37, 3, 38, 2,  0, 0}, // #530
  {DBGFIELD("VLD3d16Pseudo_VLD3d32Pseudo_VLD3d8Pseudo_VLD3q16oddPseudo_VLD3q32oddPseudo_VLD3q8oddPseudo") 1, 0, 0, 37, 3, 38, 2,  0, 0}, // #531
  {DBGFIELD("VLD3d16_UPD_VLD3d32_UPD_VLD3d8_UPD_VLD3q16_UPD_VLD3q32_UPD_VLD3q8_UPD") 1, 0, 0, 37, 3, 38, 2,  0, 0}, // #532
  {DBGFIELD("VLD3d16Pseudo_UPD_VLD3d32Pseudo_UPD_VLD3d8Pseudo_UPD_VLD3q16Pseudo_UPD_VLD3q16oddPseudo_UPD_VLD3q32Pseudo_UPD_VLD3q32oddPseudo_UPD_VLD3q8Pseudo_UPD_VLD3q8oddPseudo_UPD") 1, 0, 0, 37, 3, 38, 2,  0, 0}, // #533
  {DBGFIELD("VLD4d16_VLD4d32_VLD4d8_VLD4q16_VLD4q32_VLD4q8") 1, 0, 0, 43, 3, 42, 2,  0, 0}, // #534
  {DBGFIELD("VLD4d16Pseudo_VLD4d32Pseudo_VLD4d8Pseudo_VLD4q16oddPseudo_VLD4q32oddPseudo_VLD4q8oddPseudo") 1, 0, 0, 43, 3, 42, 2,  0, 0}, // #535
  {DBGFIELD("VLD4d16_UPD_VLD4d32_UPD_VLD4d8_UPD_VLD4q16_UPD_VLD4q32_UPD_VLD4q8_UPD") 1, 0, 0, 43, 3, 42, 2,  0, 0}, // #536
  {DBGFIELD("VLD4d16Pseudo_UPD_VLD4d32Pseudo_UPD_VLD4d8Pseudo_UPD_VLD4q16Pseudo_UPD_VLD4q16oddPseudo_UPD_VLD4q32Pseudo_UPD_VLD4q32oddPseudo_UPD_VLD4q8Pseudo_UPD_VLD4q8oddPseudo_UPD") 1, 0, 0, 43, 3, 42, 2,  0, 0}, // #537
  {DBGFIELD("VLD1DUPd16_VLD1DUPd32_VLD1DUPd8_VLD1DUPq16_VLD1DUPq32_VLD1DUPq8") 1, 0, 0, 25, 3, 34, 2,  0, 0}, // #538
  {DBGFIELD("VLD1LNd16_VLD1LNd32_VLD1LNd8_VLD1LNq16Pseudo_VLD1LNq32Pseudo_VLD1LNq8Pseudo") 1, 0, 0, 28, 3, 36, 2,  0, 0}, // #539
  {DBGFIELD("VLD1DUPd16wb_fixed_VLD1DUPd16wb_register_VLD1DUPd32wb_fixed_VLD1DUPd32wb_register_VLD1DUPd8wb_fixed_VLD1DUPd8wb_register_VLD1DUPq16wb_fixed_VLD1DUPq16wb_register_VLD1DUPq32wb_fixed_VLD1DUPq32wb_register_VLD1DUPq8wb_fixed_VLD1DUPq8wb_register") 1, 0, 0, 25, 3, 34, 2,  0, 0}, // #540
  {DBGFIELD("VLD1LNd16_UPD_VLD1LNd32_UPD_VLD1LNd8_UPD_VLD1LNq16Pseudo_UPD_VLD1LNq32Pseudo_UPD_VLD1LNq8Pseudo_UPD") 1, 0, 0, 28, 3, 36, 2,  0, 0}, // #541
  {DBGFIELD("VLD2DUPd16_VLD2DUPd16x2_VLD2DUPd32_VLD2DUPd32x2_VLD2DUPd8_VLD2DUPd8x2") 1, 0, 0, 25, 3, 34, 2,  0, 0}, // #542
  {DBGFIELD("VLD2LNd16_VLD2LNd16Pseudo_VLD2LNd32_VLD2LNd32Pseudo_VLD2LNd8_VLD2LNd8Pseudo_VLD2LNq16_VLD2LNq16Pseudo_VLD2LNq32_VLD2LNq32Pseudo") 1, 0, 0, 28, 3, 36, 2,  0, 0}, // #543
  {DBGFIELD("VLD2LNd16_UPD_VLD2LNd32_UPD_VLD2LNd8_UPD_VLD2LNq16_UPD_VLD2LNq32_UPD") 1, 0, 0, 28, 3, 36, 2,  0, 0}, // #544
  {DBGFIELD("VLD2DUPd16wb_fixed_VLD2DUPd16wb_register_VLD2DUPd16x2wb_fixed_VLD2DUPd16x2wb_register_VLD2DUPd32wb_fixed_VLD2DUPd32wb_register_VLD2DUPd32x2wb_fixed_VLD2DUPd32x2wb_register_VLD2DUPd8wb_fixed_VLD2DUPd8wb_register_VLD2DUPd8x2wb_fixed_VLD2DUPd8x2wb_register") 1, 0, 0, 25, 3, 34, 2,  0, 0}, // #545
  {DBGFIELD("VLD2LNd16Pseudo_UPD_VLD2LNd32Pseudo_UPD_VLD2LNd8Pseudo_UPD_VLD2LNq16Pseudo_UPD_VLD2LNq32Pseudo_UPD") 1, 0, 0, 28, 3, 36, 2,  0, 0}, // #546
  {DBGFIELD("VLD3DUPd16_VLD3DUPd16Pseudo_VLD3DUPd32_VLD3DUPd32Pseudo_VLD3DUPd8_VLD3DUPd8Pseudo_VLD3DUPq16_VLD3DUPq32_VLD3DUPq8") 1, 0, 0, 37, 3, 38, 2,  0, 0}, // #547
  {DBGFIELD("VLD3LNd16_VLD3LNd16Pseudo_VLD3LNd32_VLD3LNd32Pseudo_VLD3LNd8_VLD3LNd8Pseudo_VLD3LNq16_VLD3LNq16Pseudo_VLD3LNq32_VLD3LNq32Pseudo") 1, 0, 0, 40, 3, 40, 2,  0, 0}, // #548
  {DBGFIELD("VLD3DUPd16_UPD_VLD3DUPd32_UPD_VLD3DUPd8_UPD_VLD3DUPq16_UPD_VLD3DUPq32_UPD_VLD3DUPq8_UPD") 1, 0, 0, 37, 3, 38, 2,  0, 0}, // #549
  {DBGFIELD("VLD3LNd16_UPD_VLD3LNd32_UPD_VLD3LNd8_UPD_VLD3LNq16_UPD_VLD3LNq32_UPD") 1, 0, 0, 40, 3, 40, 2,  0, 0}, // #550
  {DBGFIELD("VLD3DUPd16Pseudo_UPD_VLD3DUPd32Pseudo_UPD_VLD3DUPd8Pseudo_UPD") 1, 0, 0, 37, 3, 38, 2,  0, 0}, // #551
  {DBGFIELD("VLD3LNd16Pseudo_UPD_VLD3LNd32Pseudo_UPD_VLD3LNd8Pseudo_UPD_VLD3LNq16Pseudo_UPD_VLD3LNq32Pseudo_UPD") 1, 0, 0, 40, 3, 40, 2,  0, 0}, // #552
  {DBGFIELD("VLD4DUPd16_VLD4DUPd16Pseudo_VLD4DUPd32_VLD4DUPd32Pseudo_VLD4DUPd8_VLD4DUPd8Pseudo_VLD4DUPq16_VLD4DUPq32_VLD4DUPq8") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #553
  {DBGFIELD("VLD4LNd16_VLD4LNd16Pseudo_VLD4LNd32_VLD4LNd32Pseudo_VLD4LNd8_VLD4LNd8Pseudo_VLD4LNq16_VLD4LNq16Pseudo_VLD4LNq32_VLD4LNq32Pseudo") 1, 0, 0, 43, 3, 42, 2,  0, 0}, // #554
  {DBGFIELD("VLD4DUPd16_UPD_VLD4DUPd32_UPD_VLD4DUPd8_UPD_VLD4DUPq16_UPD_VLD4DUPq32_UPD_VLD4DUPq8_UPD") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #555
  {DBGFIELD("VLD4LNd16_UPD_VLD4LNd32_UPD_VLD4LNd8_UPD_VLD4LNq16_UPD_VLD4LNq32_UPD") 1, 0, 0, 43, 3, 42, 2,  0, 0}, // #556
  {DBGFIELD("VLD4DUPd16Pseudo_UPD_VLD4DUPd32Pseudo_UPD_VLD4DUPd8Pseudo_UPD") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #557
  {DBGFIELD("VLD4LNd16Pseudo_UPD_VLD4LNd32Pseudo_UPD_VLD4LNd8Pseudo_UPD_VLD4LNq16Pseudo_UPD_VLD4LNq32Pseudo_UPD") 1, 0, 0, 43, 3, 42, 2,  0, 0}, // #558
  {DBGFIELD("VST1d16_VST1d32_VST1d64_VST1d8") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #559
  {DBGFIELD("VST1q16_VST1q32_VST1q64_VST1q8") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #560
  {DBGFIELD("VST1d16wb_fixed_VST1d16wb_register_VST1d32wb_fixed_VST1d32wb_register_VST1d64wb_fixed_VST1d64wb_register_VST1d8wb_fixed_VST1d8wb_register") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #561
  {DBGFIELD("VST1q16wb_fixed_VST1q16wb_register_VST1q32wb_fixed_VST1q32wb_register_VST1q64wb_fixed_VST1q64wb_register_VST1q8wb_fixed_VST1q8wb_register") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #562
  {DBGFIELD("VST1d16T_VST1d32T_VST1d64T_VST1d64TPseudo_VST1d8T") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #563
  {DBGFIELD("VST1d16Twb_fixed_VST1d16Twb_register_VST1d32Twb_fixed_VST1d32Twb_register_VST1d64Twb_fixed_VST1d64Twb_register_VST1d8Twb_fixed_VST1d8Twb_register") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #564
  {DBGFIELD("VST1d64TPseudoWB_fixed_VST1d64TPseudoWB_register") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #565
  {DBGFIELD("VST1d16Q_VST1d32Q_VST1d64Q_VST1d64QPseudo_VST1d8Q") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #566
  {DBGFIELD("VST1d16Qwb_fixed_VST1d16Qwb_register_VST1d32Qwb_fixed_VST1d32Qwb_register_VST1d64Qwb_fixed_VST1d64Qwb_register_VST1d8Qwb_fixed_VST1d8Qwb_register") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #567
  {DBGFIELD("VST1d64QPseudoWB_fixed_VST1d64QPseudoWB_register") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #568
  {DBGFIELD("VST2b16_VST2b32_VST2b8_VST2d16_VST2d32_VST2d8") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #569
  {DBGFIELD("VST2b16wb_fixed_VST2b16wb_register_VST2b32wb_fixed_VST2b32wb_register_VST2b8wb_fixed_VST2b8wb_register_VST2d16wb_fixed_VST2d16wb_register_VST2d32wb_fixed_VST2d32wb_register_VST2d8wb_fixed_VST2d8wb_register") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #570
  {DBGFIELD("VST2q16_VST2q16Pseudo_VST2q32_VST2q32Pseudo_VST2q8_VST2q8Pseudo") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #571
  {DBGFIELD("VST2q16PseudoWB_fixed_VST2q16PseudoWB_register_VST2q32PseudoWB_fixed_VST2q32PseudoWB_register_VST2q8PseudoWB_fixed_VST2q8PseudoWB_register") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #572
  {DBGFIELD("VST2q16wb_fixed_VST2q16wb_register_VST2q32wb_fixed_VST2q32wb_register_VST2q8wb_fixed_VST2q8wb_register") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #573
  {DBGFIELD("VST3d16_VST3d16Pseudo_VST3d32_VST3d32Pseudo_VST3d8_VST3d8Pseudo_VST3q16_VST3q16oddPseudo_VST3q32_VST3q32oddPseudo_VST3q8_VST3q8oddPseudo") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #574
  {DBGFIELD("VST3d16Pseudo_UPD_VST3d16_UPD_VST3d32Pseudo_UPD_VST3d32_UPD_VST3d8Pseudo_UPD_VST3d8_UPD_VST3q16Pseudo_UPD_VST3q16_UPD_VST3q16oddPseudo_UPD_VST3q32Pseudo_UPD_VST3q32_UPD_VST3q32oddPseudo_UPD_VST3q8Pseudo_UPD_VST3q8_UPD_VST3q8oddPseudo_UPD") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #575
  {DBGFIELD("VST4d16_VST4d16Pseudo_VST4d32_VST4d32Pseudo_VST4d8_VST4d8Pseudo_VST4q16_VST4q16oddPseudo_VST4q32_VST4q32oddPseudo_VST4q8_VST4q8oddPseudo") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #576
  {DBGFIELD("VST4d16Pseudo_UPD_VST4d16_UPD_VST4d32Pseudo_UPD_VST4d32_UPD_VST4d8Pseudo_UPD_VST4d8_UPD_VST4q16Pseudo_UPD_VST4q16_UPD_VST4q16oddPseudo_UPD_VST4q32Pseudo_UPD_VST4q32_UPD_VST4q32oddPseudo_UPD_VST4q8Pseudo_UPD_VST4q8_UPD_VST4q8oddPseudo_UPD") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #577
  {DBGFIELD("VST1LNd16_VST1LNd32_VST1LNd8_VST1LNq16Pseudo_VST1LNq32Pseudo_VST1LNq8Pseudo") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #578
  {DBGFIELD("VST1LNd16_UPD_VST1LNd32_UPD_VST1LNd8_UPD_VST1LNq16Pseudo_UPD_VST1LNq32Pseudo_UPD_VST1LNq8Pseudo_UPD") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #579
  {DBGFIELD("VST2LNd16_VST2LNd16Pseudo_VST2LNd32_VST2LNd32Pseudo_VST2LNd8_VST2LNd8Pseudo_VST2LNq16_VST2LNq16Pseudo_VST2LNq32_VST2LNq32Pseudo") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #580
  {DBGFIELD("VST2LNd16Pseudo_UPD_VST2LNd16_UPD_VST2LNd32Pseudo_UPD_VST2LNd32_UPD_VST2LNd8Pseudo_UPD_VST2LNd8_UPD_VST2LNq16Pseudo_UPD_VST2LNq16_UPD_VST2LNq32Pseudo_UPD_VST2LNq32_UPD") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #581
  {DBGFIELD("VST3LNd16_VST3LNd16Pseudo_VST3LNd32_VST3LNd32Pseudo_VST3LNd8_VST3LNd8Pseudo_VST3LNq16_VST3LNq16Pseudo_VST3LNq32_VST3LNq32Pseudo") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #582
  {DBGFIELD("VST3LNd16Pseudo_UPD_VST3LNd16_UPD_VST3LNd32Pseudo_UPD_VST3LNd32_UPD_VST3LNd8Pseudo_UPD_VST3LNd8_UPD_VST3LNq16Pseudo_UPD_VST3LNq16_UPD_VST3LNq32Pseudo_UPD_VST3LNq32_UPD") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #583
  {DBGFIELD("VST4LNd16_VST4LNd16Pseudo_VST4LNd32_VST4LNd32Pseudo_VST4LNd8_VST4LNd8Pseudo_VST4LNq16_VST4LNq16Pseudo_VST4LNq32_VST4LNq32Pseudo") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #584
  {DBGFIELD("VST4LNd16Pseudo_UPD_VST4LNd16_UPD_VST4LNd32Pseudo_UPD_VST4LNd32_UPD_VST4LNd8Pseudo_UPD_VST4LNd8_UPD_VST4LNq16Pseudo_UPD_VST4LNq16_UPD_VST4LNq32Pseudo_UPD_VST4LNq32_UPD") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #585
  {DBGFIELD("VDIVS")              1, 0, 0,  3, 2, 29, 1,  0, 0}, // #586
  {DBGFIELD("VSQRTS")             1, 0, 0,  3, 2, 45, 1,  0, 0}, // #587
  {DBGFIELD("VDIVD")              1, 0, 0,  3, 2, 28, 1,  0, 0}, // #588
  {DBGFIELD("VSQRTD")             1, 0, 0,  3, 2, 44, 1,  0, 0}, // #589
  {DBGFIELD("ABS")                0, 0, 0,  0, 0,  0, 0,  0, 0}, // #590
  {DBGFIELD("SwiftWriteP01TwoCycle_ReadALU") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #591
  {DBGFIELD("WriteALU_ReadALU")   0, 0, 0,  0, 0,  0, 0,  0, 0}, // #592
  {DBGFIELD("SwiftWriteP01ThreeCycleTwoUops_anonymous_3761") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #593
  {DBGFIELD("SwiftWriteP01TwoCycle_NoReadAdvance") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #594
  {DBGFIELD("SwiftWriteP0ThreeCycleThreeUops_anonymous_3761") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #595
  {DBGFIELD("SwiftWriteP01OneCycle_ReadALU") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #596
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_A9WriteAdr_A9WriteIssue") 1, 0, 0,  7, 2, 46, 4,  0, 0}, // #597
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteIssue") 1, 0, 0, 46, 2, 50, 6,  0, 0}, // #598
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue") 1, 0, 0, 48, 2, 56, 8,  0, 0}, // #599
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue") 1, 0, 0, 50, 2, 64, 10,  0, 0}, // #600
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue") 1, 0, 0, 52, 2, 74, 12,  0, 0}, // #601
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue") 1, 0, 0, 54, 2, 86, 14,  0, 0}, // #602
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue") 1, 0, 0, 56, 2, 100, 16,  0, 0}, // #603
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue") 1, 0, 0, 58, 2, 116, 18,  0, 0}, // #604
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteIssue") 1, 0, 0, 46, 2, 134, 18,  0, 0}, // #605
  {DBGFIELD("A9WriteAdr_A9WriteL1_A9WriteL1Hi_A9WriteIssue") 1, 0, 0,  7, 2, 152, 4,  0, 0}, // #606
  {DBGFIELD("(A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 1, 0, 0, 46, 2, 156, 6,  0, 0}, // #607
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 1, 0, 0, 48, 2, 162, 8,  0, 0}, // #608
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 1, 0, 0, 50, 2, 170, 10,  0, 0}, // #609
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 1, 0, 0, 52, 2, 180, 12,  0, 0}, // #610
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 1, 0, 0, 54, 2, 192, 14,  0, 0}, // #611
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 1, 0, 0, 56, 2, 206, 16,  0, 0}, // #612
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 1, 0, 0, 58, 2, 222, 18,  0, 0}, // #613
  {DBGFIELD("(A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 1, 0, 0, 46, 2, 240, 18,  0, 0}, // #614
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_A9WriteAdr_A9WriteB") 1, 0, 0, 60, 3, 258, 4,  0, 0}, // #615
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteB") 1, 0, 0, 63, 3, 262, 6,  0, 0}, // #616
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB") 1, 0, 0, 66, 3, 268, 8,  0, 0}, // #617
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB") 1, 0, 0, 69, 3, 276, 10,  0, 0}, // #618
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB") 1, 0, 0, 72, 3, 286, 12,  0, 0}, // #619
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB") 1, 0, 0, 75, 3, 298, 14,  0, 0}, // #620
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB") 1, 0, 0, 78, 3, 312, 16,  0, 0}, // #621
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB") 1, 0, 0, 81, 3, 328, 18,  0, 0}, // #622
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteB") 1, 0, 0, 63, 3, 346, 18,  0, 0}, // #623
  {DBGFIELD("SwiftWriteP01ThreeCycleTwoUops") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #624
  {DBGFIELD("SwiftWriteP01TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #625
  {DBGFIELD("WriteALU")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #626
  {DBGFIELD("A9WriteAdr_(A9WriteIssue_A9WriteLfpOp)") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #627
  {DBGFIELD("(A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp)") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #628
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)") 1, 0, 0, 84, 3, 46, 2,  0, 0}, // #629
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)") 1, 0, 0, 87, 3, 52, 2,  0, 0}, // #630
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)") 1, 0, 0, 90, 3, 60, 2,  0, 0}, // #631
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)") 1, 0, 0, 93, 3, 70, 2,  0, 0}, // #632
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)") 1, 0, 0, 96, 3, 82, 2,  0, 0}, // #633
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)") 1, 0, 0, 99, 3, 96, 2,  0, 0}, // #634
  {DBGFIELD("A9WriteAdr_A9WriteLMfp1_A9WriteL1Hi") 1, 0, 0, 31, 3, 260, 3,  0, 0}, // #635
  {DBGFIELD("(A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)") 2, 0, 0, 34, 3, 364, 5,  0, 0}, // #636
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)") 3, 0, 0, 84, 3, 369, 7,  0, 0}, // #637
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)") 4, 0, 0, 87, 3, 376, 9,  0, 0}, // #638
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)") 5, 0, 0, 90, 3, 385, 11,  0, 0}, // #639
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)") 6, 0, 0, 93, 3, 396, 13,  0, 0}, // #640
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)") 7, 0, 0, 96, 3, 409, 15,  0, 0}, // #641
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)") 8, 0, 0, 99, 3, 424, 17,  0, 0}, // #642
  {DBGFIELD("(A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)") 2, 0, 0, 34, 3, 441, 17,  0, 0}, // #643
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp)_A9WriteAdr") 1, 0, 0, 31, 3, 14, 2,  0, 0}, // #644
  {DBGFIELD("A9WriteLMfp1_A9WriteL1Hi_A9WriteAdr") 1, 0, 0, 31, 3, 458, 3,  0, 0}, // #645
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr)") 1, 0, 0, 34, 3, 30, 2,  0, 0}, // #646
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)") 1, 0, 0, 84, 3, 46, 2,  0, 0}, // #647
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 1, 0, 0, 87, 3, 52, 2,  0, 0}, // #648
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 1, 0, 0, 90, 3, 60, 2,  0, 0}, // #649
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 1, 0, 0, 93, 3, 70, 2,  0, 0}, // #650
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 1, 0, 0, 96, 3, 82, 2,  0, 0}, // #651
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 1, 0, 0, 99, 3, 96, 2,  0, 0}, // #652
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)") 2, 0, 0, 34, 3, 461, 5,  0, 0}, // #653
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)") 3, 0, 0, 84, 3, 466, 7,  0, 0}, // #654
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 4, 0, 0, 87, 3, 473, 9,  0, 0}, // #655
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 5, 0, 0, 90, 3, 482, 11,  0, 0}, // #656
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 6, 0, 0, 93, 3, 493, 13,  0, 0}, // #657
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 7, 0, 0, 96, 3, 506, 15,  0, 0}, // #658
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 8, 0, 0, 99, 3, 521, 17,  0, 0}, // #659
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)") 2, 0, 0, 34, 3, 538, 17,  0, 0}, // #660
  {DBGFIELD("SwiftWriteP01TwoCycle_anonymous_3761") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #661
  {DBGFIELD("WriteALU_anonymous_3761") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #662
  {DBGFIELD("WriteALU_NoReadAdvance") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #663
  {DBGFIELD("SwiftWriteP01OneCycle_ReadALU_ReadALU") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #664
  {DBGFIELD("SwiftWriteP01TwoCycle_ReadALU_ReadALU") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #665
  {DBGFIELD("SwiftWriteP01OneCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #666
  {DBGFIELD("(SwiftWriteP0OneCycle_SwiftWriteP0OneCycle)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #667
  {DBGFIELD("SwiftWriteP0OneCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #668
  {DBGFIELD("SwiftWriteP0P01FiveCycleTwoUops_ReadALU_ReadALU_anonymous_3792") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #669
  {DBGFIELD("SwiftWriteP0FourCycle_ReadALU_ReadALU_ReadALU") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #670
  {DBGFIELD("SwiftWriteP0P01FiveCycleTwoUops") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #671
  {DBGFIELD("SwiftWriteP0FourCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #672
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #673
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #674
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #675
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #676
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #677
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #678
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #679
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #680
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #681
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #682
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #683
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #684
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #685
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #686
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteLM18Cy_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #687
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5CyNo_SwiftWriteLM6CyNo_SwiftWriteLM7CyNo_SwiftWriteLM8CyNo_SwiftWriteLM9CyNo_SwiftWriteLM10CyNo_SwiftWriteLM11CyNo_SwiftWriteLM12CyNo_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM15CyNo_SwiftWriteLM16CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLDMAddrNoWB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #688
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #689
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #690
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #691
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #692
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #693
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #694
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #695
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #696
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #697
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #698
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #699
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #700
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #701
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #702
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteLM18Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #703
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5CyNo_SwiftWriteLM6CyNo_SwiftWriteLM7CyNo_SwiftWriteLM8CyNo_SwiftWriteLM9CyNo_SwiftWriteLM10CyNo_SwiftWriteLM11CyNo_SwiftWriteLM12CyNo_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM15CyNo_SwiftWriteLM16CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #704
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #705
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #706
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #707
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #708
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #709
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #710
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #711
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #712
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #713
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #714
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #715
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #716
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #717
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #718
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteLM18Cy_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #719
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5CyNo_SwiftWriteLM6CyNo_SwiftWriteLM7CyNo_SwiftWriteLM8CyNo_SwiftWriteLM9CyNo_SwiftWriteLM10CyNo_SwiftWriteLM11CyNo_SwiftWriteLM12CyNo_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM15CyNo_SwiftWriteLM16CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteP1TwoCycle") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #720
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #721
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #722
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #723
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #724
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #725
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #726
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #727
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #728
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #729
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #730
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #731
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #732
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #733
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #734
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #735
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #736
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #737
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #738
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #739
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #740
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #741
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #742
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #743
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #744
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #745
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #746
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #747
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #748
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #749
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #750
  {DBGFIELD("SwiftWriteLM4Cy")    0, 0, 0,  0, 0,  0, 0,  0, 0}, // #751
  {DBGFIELD("SwiftWriteLM4Cy_SwiftWriteLM4CyNo") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #752
  {DBGFIELD("SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm3") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #753
  {DBGFIELD("SwiftWriteLM4Cy_SwiftWriteLM4CyNo_SwiftWriteLM4CyNo_SwiftWriteLM4CyNo") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #754
  {DBGFIELD("SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #755
  {DBGFIELD("SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #756
  {DBGFIELD("SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm7") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #757
  {DBGFIELD("SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM13Cy_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm2") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #758
  {DBGFIELD("SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #759
  {DBGFIELD("SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #760
  {DBGFIELD("SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #761
  {DBGFIELD("SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM11Cy_SwiftWriteLM11Cy_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm3") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #762
  {DBGFIELD("SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #763
  {DBGFIELD("SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14Cy_SwiftWriteLM14Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm7") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #764
  {DBGFIELD("SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM17Cy_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #765
  {DBGFIELD("SwiftWriteLM7Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM18CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm4") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #766
  {DBGFIELD("SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM13Cy_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm2") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #767
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM4Cy") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #768
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM4Cy_SwiftWriteLM4CyNo") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #769
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm3") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #770
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM4Cy_SwiftWriteLM4CyNo_SwiftWriteLM4CyNo_SwiftWriteLM4CyNo") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #771
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #772
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #773
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm7") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #774
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM13Cy_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm2") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #775
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #776
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #777
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #778
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM11Cy_SwiftWriteLM11Cy_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm3") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #779
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #780
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14Cy_SwiftWriteLM14Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm7") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #781
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM17Cy_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #782
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM18CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm4") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #783
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM13Cy_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm2") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #784
  {DBGFIELD("SwiftWriteStIncAddr") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #785
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteStIncAddr") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #786
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #787
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #788
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #789
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #790
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #791
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #792
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #793
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #794
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 0, 0, 0,  0, 0,  0, 0,  0, 0} // #795
}; // CortexA9ModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc SwiftModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  65535, 0, 0,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("IIC_iALUi_WriteALU_ReadALU") 1, 0, 0,  6, 1,  1, 1,  0, 1}, // #1
  {DBGFIELD("IIC_iALUr_WriteALU_ReadALU_ReadALU") 1, 0, 0,  6, 1,  1, 1, 86, 2}, // #2
  {DBGFIELD("IIC_iALUsr_WriteALUsi_ReadALU") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #3
  {DBGFIELD("IIC_iALUsr_WriteALUsr_ReadALUsr") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #4
  {DBGFIELD("IIC_iALUsr_WriteALUSsr_ReadALUsr") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #5
  {DBGFIELD("IIC_iBITi_WriteALU_ReadALU") 1, 0, 0,  6, 1,  1, 1,  0, 1}, // #6
  {DBGFIELD("IIC_iBITr_WriteALU_ReadALU_ReadALU") 1, 0, 0,  6, 1,  1, 1, 86, 2}, // #7
  {DBGFIELD("IIC_iBITsr_WriteALUsi_ReadALU") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #8
  {DBGFIELD("IIC_iBITsr_WriteALUsr_ReadALUsr") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #9
  {DBGFIELD("IIC_Br_WriteBr")     1, 0, 0, 61, 2,  0, 1,  0, 0}, // #10
  {DBGFIELD("IIC_iUNAsi")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #11
  {DBGFIELD("IIC_Br_WriteBrL")    1, 0, 0, 61, 2,  2, 1,  0, 0}, // #12
  {DBGFIELD("WriteBrL")           1, 0, 0, 61, 2,  2, 1,  0, 0}, // #13
  {DBGFIELD("IIC_Br_WriteBrTbl")  1, 0, 0, 102, 3,  0, 1,  0, 0}, // #14
  {DBGFIELD("WriteBr")            1, 0, 0, 61, 2,  0, 1,  0, 0}, // #15
  {DBGFIELD("IIC_iUNAr_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #16
  {DBGFIELD("IIC_iCMPi_WriteCMP_ReadALU") 1, 0, 0,  6, 1,  1, 1,  0, 1}, // #17
  {DBGFIELD("IIC_iCMPr_WriteCMP_ReadALU_ReadALU") 1, 0, 0,  6, 1,  1, 1, 86, 2}, // #18
  {DBGFIELD("IIC_iCMPsr_WriteCMPsi_ReadALU") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #19
  {DBGFIELD("IIC_iCMPsr_WriteCMPsr_ReadALU") 1, 0, 0,  6, 1,  2, 1,  0, 1}, // #20
  {DBGFIELD("IIC_fpUNA64")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #21
  {DBGFIELD("IIC_fpUNA32")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #22
  {DBGFIELD("IIC_fpSTAT")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #23
  {DBGFIELD("IIC_iLoad_m")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #24
  {DBGFIELD("IIC_iLoad_mu")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #25
  {DBGFIELD("IIC_iLoad_mBr")      0, 0, 0,  0, 0,  0, 0,  0, 0}, // #26
  {DBGFIELD("IIC_iLoad_bh_ru")    0, 0, 0,  0, 0,  0, 0,  0, 0}, // #27
  {DBGFIELD("IIC_iLoad_bh_iu")    0, 0, 0,  0, 0,  0, 0,  0, 0}, // #28
  {DBGFIELD("IIC_iLoad_bh_r")     0, 0, 0,  0, 0,  0, 0,  0, 0}, // #29
  {DBGFIELD("IIC_iLoad_bh_si")    0, 0, 0,  0, 0,  0, 0,  0, 0}, // #30
  {DBGFIELD("IIC_iLoad_d_r")      0, 0, 0,  0, 0,  0, 0,  0, 0}, // #31
  {DBGFIELD("IIC_iLoad_d_ru")     0, 0, 0,  0, 0,  0, 0,  0, 0}, // #32
  {DBGFIELD("IIC_iLoad_i")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #33
  {DBGFIELD("IIC_iLoadiALU")      0, 0, 0,  0, 0,  0, 0,  0, 0}, // #34
  {DBGFIELD("IIC_iLoad_ru")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #35
  {DBGFIELD("IIC_iLoad_iu")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #36
  {DBGFIELD("IIC_iLoad_r")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #37
  {DBGFIELD("IIC_iLoad_si")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #38
  {DBGFIELD("IIC_iMAC32")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #39
  {DBGFIELD("IIC_iCMOVi_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #40
  {DBGFIELD("IIC_iMOVi_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #41
  {DBGFIELD("IIC_iCMOVix2")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #42
  {DBGFIELD("IIC_iCMOVr_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #43
  {DBGFIELD("IIC_iCMOVsr_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #44
  {DBGFIELD("IIC_iMOVix2addpc")   0, 0, 0,  0, 0,  0, 0,  0, 0}, // #45
  {DBGFIELD("IIC_iMOVix2ld")      0, 0, 0,  0, 0,  0, 0,  0, 0}, // #46
  {DBGFIELD("IIC_iMOVix2")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #47
  {DBGFIELD("IIC_iMOVr_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #48
  {DBGFIELD("IIC_iMOVsr_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #49
  {DBGFIELD("IIC_iMOVsi_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #50
  {DBGFIELD("IIC_iMUL32")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #51
  {DBGFIELD("IIC_iMVNi_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #52
  {DBGFIELD("IIC_iMVNr_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #53
  {DBGFIELD("IIC_iMVNsr_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #54
  {DBGFIELD("IIC_iALUr_WriteALU_ReadALU") 1, 0, 0,  6, 1,  1, 1,  0, 1}, // #55
  {DBGFIELD("IIC_iStore_r")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #56
  {DBGFIELD("IIC_iStore_bh_r")    0, 0, 0,  0, 0,  0, 0,  0, 0}, // #57
  {DBGFIELD("IIC_iALUsi_WriteALUsi_ReadALU") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #58
  {DBGFIELD("IIC_iBITsi_WriteALUsi_ReadALU") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #59
  {DBGFIELD("IIC_Preload_WritePreLd") 1, 0, 0, 105, 1,  0, 1,  0, 0}, // #60
  {DBGFIELD("IIC_iDIV")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #61
  {DBGFIELD("IIC_iMAC16")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #62
  {DBGFIELD("IIC_iMAC64")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #63
  {DBGFIELD("IIC_iMUL16")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #64
  {DBGFIELD("IIC_iMUL64")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #65
  {DBGFIELD("IIC_iStore_m")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #66
  {DBGFIELD("IIC_iStore_mu")      0, 0, 0,  0, 0,  0, 0,  0, 0}, // #67
  {DBGFIELD("IIC_iStore_bh_ru")   0, 0, 0,  0, 0,  0, 0,  0, 0}, // #68
  {DBGFIELD("IIC_iStore_bh_iu")   0, 0, 0,  0, 0,  0, 0,  0, 0}, // #69
  {DBGFIELD("IIC_iStore_ru")      0, 0, 0,  0, 0,  0, 0,  0, 0}, // #70
  {DBGFIELD("IIC_iStore_bh_si")   0, 0, 0,  0, 0,  0, 0,  0, 0}, // #71
  {DBGFIELD("IIC_iStore_d_r")     0, 0, 0,  0, 0,  0, 0,  0, 0}, // #72
  {DBGFIELD("IIC_iStore_d_ru")    0, 0, 0,  0, 0,  0, 0,  0, 0}, // #73
  {DBGFIELD("IIC_iStore_iu")      0, 0, 0,  0, 0,  0, 0,  0, 0}, // #74
  {DBGFIELD("IIC_iStore_si")      0, 0, 0,  0, 0,  0, 0,  0, 0}, // #75
  {DBGFIELD("IIC_Br")             0, 0, 0,  0, 0,  0, 0,  0, 0}, // #76
  {DBGFIELD("IIC_iEXTAr_WriteALUsr") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #77
  {DBGFIELD("IIC_iEXTr_WriteALUsi") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #78
  {DBGFIELD("IIC_iTSTi_WriteCMP_ReadALU") 1, 0, 0,  6, 1,  1, 1,  0, 1}, // #79
  {DBGFIELD("IIC_iTSTr_WriteCMP_ReadALU_ReadALU") 1, 0, 0,  6, 1,  1, 1, 86, 2}, // #80
  {DBGFIELD("IIC_iTSTsr_WriteCMPsi_ReadALU") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #81
  {DBGFIELD("IIC_iTSTsr_WriteCMPsr_ReadALU") 1, 0, 0,  6, 1,  2, 1,  0, 1}, // #82
  {DBGFIELD("WriteALU_ReadALU_ReadALU") 1, 0, 0,  6, 1,  1, 1, 86, 2}, // #83
  {DBGFIELD("IIC_VABAD")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #84
  {DBGFIELD("IIC_VABAQ")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #85
  {DBGFIELD("IIC_VSUBi4Q")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #86
  {DBGFIELD("IIC_VBIND")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #87
  {DBGFIELD("IIC_VBINQ")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #88
  {DBGFIELD("IIC_VSUBi4D")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #89
  {DBGFIELD("IIC_VUNAD")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #90
  {DBGFIELD("IIC_VUNAQ")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #91
  {DBGFIELD("IIC_VUNAiQ")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #92
  {DBGFIELD("IIC_VUNAiD")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #93
  {DBGFIELD("IIC_fpALU64")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #94
  {DBGFIELD("IIC_VBINi4D")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #95
  {DBGFIELD("IIC_VSHLiD")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #96
  {DBGFIELD("IIC_fpALU32")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #97
  {DBGFIELD("IIC_VSUBiD")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #98
  {DBGFIELD("IIC_VBINiQ")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #99
  {DBGFIELD("IIC_VBINiD")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #100
  {DBGFIELD("IIC_VMOVImm")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #101
  {DBGFIELD("IIC_VCNTiD")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #102
  {DBGFIELD("IIC_VCNTiQ")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #103
  {DBGFIELD("IIC_fpCMP64")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #104
  {DBGFIELD("IIC_fpCMP32")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #105
  {DBGFIELD("IIC_fpCVTSH")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #106
  {DBGFIELD("IIC_fpCVTHS")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #107
  {DBGFIELD("IIC_fpCVTDS")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #108
  {DBGFIELD("IIC_fpCVTSD")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #109
  {DBGFIELD("IIC_fpDIV64")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #110
  {DBGFIELD("IIC_fpDIV32")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #111
  {DBGFIELD("IIC_VMOVIS")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #112
  {DBGFIELD("IIC_VMOVD")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #113
  {DBGFIELD("IIC_VMOVQ")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #114
  {DBGFIELD("IIC_VEXTD")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #115
  {DBGFIELD("IIC_VEXTQ")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #116
  {DBGFIELD("IIC_fpFMAC64")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #117
  {DBGFIELD("IIC_fpFMAC32")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #118
  {DBGFIELD("IIC_VFMACD")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #119
  {DBGFIELD("IIC_VFMACQ")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #120
  {DBGFIELD("IIC_VMOVSI")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #121
  {DBGFIELD("IIC_VBINi4Q")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #122
  {DBGFIELD("IIC_VLD1dup")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #123
  {DBGFIELD("IIC_VLD1dupu")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #124
  {DBGFIELD("IIC_VLD1ln")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #125
  {DBGFIELD("IIC_VLD1lnu")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #126
  {DBGFIELD("IIC_VLD1")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #127
  {DBGFIELD("IIC_VLD1x4")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #128
  {DBGFIELD("IIC_VLD1x2u")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #129
  {DBGFIELD("IIC_VLD1x3")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #130
  {DBGFIELD("IIC_VLD1u")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #131
  {DBGFIELD("IIC_VLD1x2")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #132
  {DBGFIELD("IIC_VLD2dup")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #133
  {DBGFIELD("IIC_VLD2dupu")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #134
  {DBGFIELD("IIC_VLD2ln")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #135
  {DBGFIELD("IIC_VLD2lnu")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #136
  {DBGFIELD("IIC_VLD2")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #137
  {DBGFIELD("IIC_VLD2u")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #138
  {DBGFIELD("IIC_VLD2x2")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #139
  {DBGFIELD("IIC_VLD2x2u")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #140
  {DBGFIELD("IIC_VLD3dup")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #141
  {DBGFIELD("IIC_VLD3dupu")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #142
  {DBGFIELD("IIC_VLD3ln")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #143
  {DBGFIELD("IIC_VLD3lnu")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #144
  {DBGFIELD("IIC_VLD3")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #145
  {DBGFIELD("IIC_VLD3u")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #146
  {DBGFIELD("IIC_VLD4dup")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #147
  {DBGFIELD("IIC_VLD4dupu")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #148
  {DBGFIELD("IIC_VLD4ln")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #149
  {DBGFIELD("IIC_VLD4lnu")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #150
  {DBGFIELD("IIC_VLD4")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #151
  {DBGFIELD("IIC_VLD4u")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #152
  {DBGFIELD("IIC_fpLoad_mu")      0, 0, 0,  0, 0,  0, 0,  0, 0}, // #153
  {DBGFIELD("IIC_fpLoad_m")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #154
  {DBGFIELD("IIC_fpLoad64")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #155
  {DBGFIELD("IIC_fpLoad32")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #156
  {DBGFIELD("IIC_fpMAC64")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #157
  {DBGFIELD("IIC_VMACi32D")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #158
  {DBGFIELD("IIC_VMACi16D")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #159
  {DBGFIELD("IIC_fpMAC32")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #160
  {DBGFIELD("IIC_VMACD")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #161
  {DBGFIELD("IIC_VMACQ")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #162
  {DBGFIELD("IIC_VMACi32Q")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #163
  {DBGFIELD("IIC_VMACi16Q")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #164
  {DBGFIELD("IIC_fpMOVID")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #165
  {DBGFIELD("IIC_VQUNAiD")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #166
  {DBGFIELD("IIC_VMOVN")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #167
  {DBGFIELD("IIC_fpMOVDI")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #168
  {DBGFIELD("IIC_fpMOVSI")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #169
  {DBGFIELD("IIC_fpMOVIS")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #170
  {DBGFIELD("IIC_fpMUL64")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #171
  {DBGFIELD("IIC_VMULi16D")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #172
  {DBGFIELD("IIC_VMULi32D")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #173
  {DBGFIELD("IIC_fpMUL32")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #174
  {DBGFIELD("IIC_VFMULD")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #175
  {DBGFIELD("IIC_VFMULQ")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #176
  {DBGFIELD("IIC_VMULi16Q")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #177
  {DBGFIELD("IIC_VMULi32Q")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #178
  {DBGFIELD("IIC_VSHLiQ")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #179
  {DBGFIELD("IIC_VPALiQ")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #180
  {DBGFIELD("IIC_VPALiD")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #181
  {DBGFIELD("IIC_VPBIND")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #182
  {DBGFIELD("IIC_VQUNAiQ")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #183
  {DBGFIELD("IIC_VSHLi4Q")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #184
  {DBGFIELD("IIC_VSHLi4D")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #185
  {DBGFIELD("IIC_VRECSD")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #186
  {DBGFIELD("IIC_VRECSQ")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #187
  {DBGFIELD("IIC_VMOVISL")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #188
  {DBGFIELD("IIC_fpCVTID_WriteCvtFP") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #189
  {DBGFIELD("IIC_fpCVTIS_WriteCvtFP") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #190
  {DBGFIELD("IIC_fpCVTID")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #191
  {DBGFIELD("IIC_fpCVTIS")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #192
  {DBGFIELD("IIC_fpSQRT64")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #193
  {DBGFIELD("IIC_fpSQRT32")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #194
  {DBGFIELD("IIC_VST1ln")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #195
  {DBGFIELD("IIC_VST1lnu")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #196
  {DBGFIELD("IIC_VST1")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #197
  {DBGFIELD("IIC_VST1x4")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #198
  {DBGFIELD("IIC_VLD1x4u")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #199
  {DBGFIELD("IIC_VST1x3")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #200
  {DBGFIELD("IIC_VLD1x3u")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #201
  {DBGFIELD("IIC_VST1x4u")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #202
  {DBGFIELD("IIC_VST1x3u")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #203
  {DBGFIELD("IIC_VST1x2")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #204
  {DBGFIELD("IIC_VST2ln")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #205
  {DBGFIELD("IIC_VST2lnu")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #206
  {DBGFIELD("IIC_VST2")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #207
  {DBGFIELD("IIC_VST2x2")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #208
  {DBGFIELD("IIC_VST2x2u")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #209
  {DBGFIELD("IIC_VST3ln")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #210
  {DBGFIELD("IIC_VST3lnu")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #211
  {DBGFIELD("IIC_VST3")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #212
  {DBGFIELD("IIC_VST3u")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #213
  {DBGFIELD("IIC_VST4ln")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #214
  {DBGFIELD("IIC_VST4lnu")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #215
  {DBGFIELD("IIC_VST4")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #216
  {DBGFIELD("IIC_VST4u")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #217
  {DBGFIELD("IIC_fpStore_mu")     0, 0, 0,  0, 0,  0, 0,  0, 0}, // #218
  {DBGFIELD("IIC_fpStore_m")      0, 0, 0,  0, 0,  0, 0,  0, 0}, // #219
  {DBGFIELD("IIC_fpStore64")      0, 0, 0,  0, 0,  0, 0,  0, 0}, // #220
  {DBGFIELD("IIC_fpStore32")      0, 0, 0,  0, 0,  0, 0,  0, 0}, // #221
  {DBGFIELD("IIC_VSUBiQ")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #222
  {DBGFIELD("IIC_VTB1")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #223
  {DBGFIELD("IIC_VTB2")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #224
  {DBGFIELD("IIC_VTB3")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #225
  {DBGFIELD("IIC_VTB4")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #226
  {DBGFIELD("IIC_VTBX1")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #227
  {DBGFIELD("IIC_VTBX2")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #228
  {DBGFIELD("IIC_VTBX3")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #229
  {DBGFIELD("IIC_VTBX4")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #230
  {DBGFIELD("IIC_fpCVTDI_WriteCvtFP") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #231
  {DBGFIELD("IIC_fpCVTSI_WriteCvtFP") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #232
  {DBGFIELD("IIC_fpCVTDI")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #233
  {DBGFIELD("IIC_fpCVTSI")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #234
  {DBGFIELD("IIC_VPERMD")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #235
  {DBGFIELD("IIC_VPERMQ")         0, 0, 0,  0, 0,  0, 0,  0, 0}, // #236
  {DBGFIELD("IIC_VPERMQ3")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #237
  {DBGFIELD("IIC_iALUsi_WriteALUsi_ReadALUsr") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #238
  {DBGFIELD("IIC_iBITi")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #239
  {DBGFIELD("IIC_iCMPsi_WriteCMPsi_ReadALU_ReadALU") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #240
  {DBGFIELD("IIC_iCMPi_WriteCMP") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #241
  {DBGFIELD("IIC_iCMPr_WriteCMP") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #242
  {DBGFIELD("IIC_iCMPsi_WriteCMPsi") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #243
  {DBGFIELD("IIC_iALUx")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #244
  {DBGFIELD("IIC_iLoad_bh_i")     0, 0, 0,  0, 0,  0, 0,  0, 0}, // #245
  {DBGFIELD("IIC_iLoad_d_i")      0, 0, 0,  0, 0,  0, 0,  0, 0}, // #246
  {DBGFIELD("IIC_iCMOVsi_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #247
  {DBGFIELD("IIC_iMOVi")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #248
  {DBGFIELD("IIC_iMVNsi_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #249
  {DBGFIELD("IIC_iALUsir_WriteALUsi_ReadALU") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #250
  {DBGFIELD("IIC_iStore_bh_i")    0, 0, 0,  0, 0,  0, 0,  0, 0}, // #251
  {DBGFIELD("IIC_iStore_i")       0, 0, 0,  0, 0,  0, 0,  0, 0}, // #252
  {DBGFIELD("IIC_iEXTAsr")        0, 0, 0,  0, 0,  0, 0,  0, 0}, // #253
  {DBGFIELD("IIC_iEXTr")          0, 0, 0,  0, 0,  0, 0,  0, 0}, // #254
  {DBGFIELD("IIC_iTSTi_WriteCMP") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #255
  {DBGFIELD("IIC_iTSTr_WriteCMP") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #256
  {DBGFIELD("IIC_iTSTsi_WriteCMPsi") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #257
  {DBGFIELD("IIC_iALUr_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #258
  {DBGFIELD("IIC_iALUi_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #259
  {DBGFIELD("IIC_iBITr_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #260
  {DBGFIELD("IIC_iPop")           0, 0, 0,  0, 0,  0, 0,  0, 0}, // #261
  {DBGFIELD("IIC_iPop_Br_WriteBrL") 1, 0, 0, 61, 2,  2, 1,  0, 0}, // #262
  {DBGFIELD("IIC_iTSTr_WriteALU") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #263
  {DBGFIELD("ANDri_BICri_EORri_ORRri") 1, 0, 0,  6, 1,  1, 1,  0, 1}, // #264
  {DBGFIELD("ANDrr_BICrr_EORrr_ORRrr") 1, 0, 0,  6, 1,  1, 1, 86, 2}, // #265
  {DBGFIELD("ANDrsi_BICrsi_EORrsi_ORRrsi") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #266
  {DBGFIELD("ANDrsr_BICrsr_EORrsr_ORRrsr") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #267
  {DBGFIELD("MOVCCsi_MOVCCsr")    1, 0, 0,  6, 1,  1, 1,  0, 0}, // #268
  {DBGFIELD("MOVsi_MOVsr")        1, 0, 0,  6, 1,  1, 1,  0, 0}, // #269
  {DBGFIELD("MOVsra_flag_MOVsrl_flag") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #270
  {DBGFIELD("MVNsr")              1, 0, 0,  6, 1,  1, 1,  0, 0}, // #271
  {DBGFIELD("MVNr")               1, 0, 0,  6, 1,  1, 1,  0, 0}, // #272
  {DBGFIELD("MOVCCi32imm")        2, 0, 0, 30, 1,  2, 1,  0, 0}, // #273
  {DBGFIELD("MOVi32imm")          2, 0, 0, 30, 1,  2, 1,  0, 0}, // #274
  {DBGFIELD("MOV_ga_pcrel")       3, 0, 0, 39, 1,  3, 1,  0, 0}, // #275
  {DBGFIELD("MOV_ga_pcrel_ldr")   3, 0, 0, 39, 1,  3, 1,  0, 0}, // #276
  {DBGFIELD("SEL")                65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #277
  {DBGFIELD("BFC_BFI_SBFX_UBFX")  1, 0, 0,  6, 1,  2, 1,  0, 0}, // #278
  {DBGFIELD("MLA_MLAv5_MLS_SMMLA_SMMLAR_SMMLS_SMMLSR") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #279
  {DBGFIELD("MUL_MULv5_SMMUL_SMMULR") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #280
  {DBGFIELD("SMLAL_SMLALBB_SMLALBT_SMLALTB_SMLALTT_SMLALv5_UMAAL_UMLAL_UMLALv5") 5, 0, 0, 106, 2, 555, 2, 88, 4}, // #281
  {DBGFIELD("SMULL_SMULLv5_UMULL_UMULLv5") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #282
  {DBGFIELD("SMLAD_SMLADX_SMLALD_SMLALDX_SMLSD_SMLSDX_SMLSLD_SMLSLDX_SMUAD_SMUADX_SMUSD_SMUSDX") 5, 0, 0, 106, 2, 555, 2, 88, 4}, // #283
  {DBGFIELD("SMULBB_SMULBT_SMULTB_SMULTT_SMULWB_SMULWT") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #284
  {DBGFIELD("SMLABB_SMLABT_SMLATB_SMLATT_SMLAWB_SMLAWT") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #285
  {DBGFIELD("LDRi12_PICLDR")      1, 0, 0,  4, 1,  3, 1,  0, 0}, // #286
  {DBGFIELD("LDRrs")              1, 0, 0,  4, 1,  3, 1,  0, 0}, // #287
  {DBGFIELD("LDRBi12_LDRH_LDRSB_LDRSH_PICLDRB_PICLDRH_PICLDRSB_PICLDRSH") 2, 0, 0, 32, 2, 18, 1,  0, 0}, // #288
  {DBGFIELD("LDRHTi_LDRHTr_LDRH_POST_LDRH_PRE_LDRSBTi_LDRSBTr_LDRSB_POST_LDRSB_PRE_LDRSHTi_LDRSHTr_LDRSH_POST_LDRSH_PRE") 3, 0, 0, 108, 2, 284, 2,  0, 0}, // #289
  {DBGFIELD("SXTB_SXTB16_SXTH_UXTB_UXTB16_UXTH") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #290
  {DBGFIELD("t2SXTB_t2SXTB16_t2SXTH_t2UXTB_t2UXTB16_t2UXTH") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #291
  {DBGFIELD("t2MOVCCi32imm")      2, 0, 0, 30, 1,  2, 1,  0, 0}, // #292
  {DBGFIELD("t2MOVi32imm")        2, 0, 0, 30, 1,  2, 1,  0, 0}, // #293
  {DBGFIELD("t2MOV_ga_pcrel")     3, 0, 0, 39, 1,  3, 1,  0, 0}, // #294
  {DBGFIELD("t2MOVi16_ga_pcrel")  3, 0, 0, 39, 1,  3, 1,  0, 0}, // #295
  {DBGFIELD("t2SEL")              65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #296
  {DBGFIELD("t2BFC_t2SBFX_t2UBFX") 1, 0, 0,  6, 1,  2, 1,  0, 0}, // #297
  {DBGFIELD("t2BFI")              1, 0, 0,  6, 1,  2, 1,  0, 0}, // #298
  {DBGFIELD("QADD_QADD16_QADD8_QASX_QDADD_QDSUB_QSAX_QSUB_QSUB16_QSUB8_UQADD16_UQADD8_UQASX_UQSAX_UQSUB16_UQSUB8") 1, 0, 0,  6, 1,  2, 1,  0, 0}, // #299
  {DBGFIELD("SSAT_SSAT16_USAT_USAT16_t2QADD_t2QADD16_t2QADD8_t2QASX_t2QDADD_t2QDSUB_t2QSAX_t2QSUB_t2QSUB16_t2QSUB8_t2SSAT_t2SSAT16_t2UQADD16_t2UQADD8_t2UQASX_t2UQSAX_t2UQSUB16_t2UQSUB8_t2USAT_t2USAT16") 1, 0, 0,  6, 1,  2, 1,  0, 0}, // #300
  {DBGFIELD("SADD16_SADD8_SASX_SSAX_SSUB16_SSUB8_UADD16_UADD8_UASX_USAX_USUB16_USUB8") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #301
  {DBGFIELD("t2SADD16_t2SADD8_t2SASX_t2SSAX_t2SSUB16_t2SSUB8_t2UADD16_t2UADD8_t2UASX_t2USAX_t2USUB16_t2USUB8") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #302
  {DBGFIELD("SHADD16_SHADD8_SHASX_SHSAX_SHSUB16_SHSUB8_UHADD16_UHADD8_UHASX_UHSAX_UHSUB16_UHSUB8") 1, 0, 0,  6, 1,  2, 1,  0, 0}, // #303
  {DBGFIELD("SXTAB_SXTAB16_SXTAH_UXTAB_UXTAB16_UXTAH") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #304
  {DBGFIELD("t2SHADD16_t2SHADD8_t2SHASX_t2SHSAX_t2SHSUB16_t2SHSUB8_t2UHADD16_t2UHADD8_t2UHASX_t2UHSAX_t2UHSUB16_t2UHSUB8") 1, 0, 0,  6, 1,  2, 1,  0, 0}, // #305
  {DBGFIELD("t2SXTAB_t2SXTAB16_t2SXTAH_t2UXTAB_t2UXTAB16_t2UXTAH") 1, 0, 0,  6, 1,  2, 1,  0, 0}, // #306
  {DBGFIELD("USAD8")              1, 0, 0, 110, 3, 18, 1,  0, 0}, // #307
  {DBGFIELD("USADA8")             1, 0, 0, 110, 3, 18, 1, 92, 3}, // #308
  {DBGFIELD("SMUSD_SMUSDX")       1, 0, 0, 10, 2, 18, 1,  0, 0}, // #309
  {DBGFIELD("t2MUL_t2SMMUL_t2SMMULR") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #310
  {DBGFIELD("t2SMULBB_t2SMULBT_t2SMULTB_t2SMULTT_t2SMULWB_t2SMULWT") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #311
  {DBGFIELD("t2SMUSD_t2SMUSDX")   1, 0, 0, 10, 2, 18, 1,  0, 0}, // #312
  {DBGFIELD("t2MLA_t2MLS_t2SMMLA_t2SMMLAR_t2SMMLS_t2SMMLSR") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #313
  {DBGFIELD("SMUAD_SMUADX")       1, 0, 0, 10, 2, 18, 1,  0, 0}, // #314
  {DBGFIELD("t2SMUAD_t2SMUADX")   1, 0, 0, 10, 2, 18, 1,  0, 0}, // #315
  {DBGFIELD("SMLSD_SMLSDX")       65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #316
  {DBGFIELD("t2SMLABB_t2SMLABT_t2SMLATB_t2SMLATT_t2SMLAWB_t2SMLAWT") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #317
  {DBGFIELD("t2SMLSD_t2SMLSDX")   65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #318
  {DBGFIELD("SMLAD_SMLADX")       65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #319
  {DBGFIELD("t2SMLAD_t2SMLADX")   65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #320
  {DBGFIELD("SMULL_UMULL")        3, 0, 0, 113, 2, 60, 2,  0, 0}, // #321
  {DBGFIELD("t2SMULL_t2UMULL")    3, 0, 0, 113, 2, 60, 2,  0, 0}, // #322
  {DBGFIELD("t2SMLAL_t2SMLALBB_t2SMLALBT_t2SMLALD_t2SMLALDX_t2SMLALTB_t2SMLALTT_t2SMLSLD_t2SMLSLDX_t2UMAAL_t2UMLAL") 5, 0, 0, 106, 2, 555, 2, 88, 4}, // #323
  {DBGFIELD("SDIV_UDIV_t2SDIV_t2UDIV") 1, 0, 0, 115, 3, 557, 1,  0, 0}, // #324
  {DBGFIELD("LDRBi12")            1, 0, 0,  4, 1,  3, 1,  0, 0}, // #325
  {DBGFIELD("LDRBrs_t2LDRBs_t2LDRHs") 1, 0, 0,  4, 1,  3, 1,  0, 0}, // #326
  {DBGFIELD("LDREX_LDREXB_LDREXD_LDREXH_tLDRpci_pic") 1, 0, 0,  4, 1,  3, 1,  0, 0}, // #327
  {DBGFIELD("LDRi12")             1, 0, 0,  4, 1,  3, 1,  0, 0}, // #328
  {DBGFIELD("t2LDRBi12_t2LDRBi8_t2LDRBpci_t2LDRHi12_t2LDRHi8_t2LDRHpci_tLDRBi_tLDRHi") 1, 0, 0,  4, 1,  3, 1,  0, 0}, // #329
  {DBGFIELD("t2LDRi12_t2LDRi8_t2LDRpci_tLDRi_tLDRpci_tLDRspi") 1, 0, 0,  4, 1,  3, 1,  0, 0}, // #330
  {DBGFIELD("t2LDRpci_pic")       1, 0, 0,  4, 1,  3, 1,  0, 0}, // #331
  {DBGFIELD("t2LDRs")             1, 0, 0,  4, 1,  3, 1,  0, 0}, // #332
  {DBGFIELD("tLDRBr_tLDRHr")      1, 0, 0,  4, 1,  3, 1,  0, 0}, // #333
  {DBGFIELD("tLDRr")              1, 0, 0,  4, 1,  3, 1,  0, 0}, // #334
  {DBGFIELD("LDRH_PICLDRB_PICLDRH") 1, 0, 0,  4, 1,  3, 1,  0, 0}, // #335
  {DBGFIELD("LDRcp")              1, 0, 0,  4, 1,  3, 1,  0, 0}, // #336
  {DBGFIELD("t2LDRSBi12_t2LDRSBi8_t2LDRSBpci_t2LDRSHi12_t2LDRSHi8_t2LDRSHpci") 2, 0, 0, 32, 2, 18, 1,  0, 0}, // #337
  {DBGFIELD("t2LDRSBpcrel_t2LDRSHpcrel") 2, 0, 0, 32, 2, 18, 1,  0, 0}, // #338
  {DBGFIELD("t2LDRSBs_t2LDRSHs")  2, 0, 0, 32, 2, 18, 1,  0, 0}, // #339
  {DBGFIELD("tLDRSB_tLDRSH")      2, 0, 0, 32, 2, 18, 1,  0, 0}, // #340
  {DBGFIELD("LDRBT_POST_IMM_LDRBT_POST_REG_LDRB_POST_REG_LDRB_PRE_REG") 2, 0, 0, 32, 2, 25, 2,  0, 0}, // #341
  {DBGFIELD("LDRB_POST_IMM_LDRB_PRE_IMM_t2LDRB_POST_t2LDRB_PRE_t2LDRH_POST_t2LDRH_PRE") 2, 0, 0, 32, 2, 25, 2,  0, 0}, // #342
  {DBGFIELD("LDRHTi_LDRHTr_LDRH_POST_LDRH_PRE") 2, 0, 0, 32, 2, 25, 2,  0, 0}, // #343
  {DBGFIELD("LDRT_POST_IMM_LDRT_POST_REG_LDR_POST_REG_LDR_PRE_REG") 2, 0, 0, 32, 2, 25, 2,  0, 0}, // #344
  {DBGFIELD("LDR_POST_IMM_LDR_PRE_IMM_t2LDR_POST_t2LDR_PRE") 2, 0, 0, 32, 2, 25, 2,  0, 0}, // #345
  {DBGFIELD("t2LDRBT_t2LDRHT")    2, 0, 0, 32, 2, 25, 2,  0, 0}, // #346
  {DBGFIELD("t2LDRT")             2, 0, 0, 32, 2, 25, 2,  0, 0}, // #347
  {DBGFIELD("t2LDRSBT_t2LDRSHT")  3, 0, 0, 108, 2, 284, 2,  0, 0}, // #348
  {DBGFIELD("t2LDRSB_POST_t2LDRSB_PRE_t2LDRSH_POST_t2LDRSH_PRE") 3, 0, 0, 108, 2, 284, 2,  0, 0}, // #349
  {DBGFIELD("LDRD")               2, 0, 0, 22, 1, 23, 2,  0, 0}, // #350
  {DBGFIELD("t2LDRDi8")           2, 0, 0, 22, 1, 23, 2,  0, 0}, // #351
  {DBGFIELD("LDRD_POST_LDRD_PRE_t2LDRD_POST_t2LDRD_PRE") 3, 0, 0, 26, 2, 558, 3,  0, 0}, // #352
  {DBGFIELD("LDMDA_LDMDB_LDMIA_LDMIB_sysLDMDA_sysLDMDB_sysLDMIA_sysLDMIB_t2LDMDB_t2LDMIA_tLDMIA") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("LDMDA_UPD_LDMDB_UPD_LDMIA_UPD_LDMIB_UPD_sysLDMDA_UPD_sysLDMDB_UPD_sysLDMIA_UPD_sysLDMIB_UPD_t2LDMDB_UPD_t2LDMIA_UPD_tLDMIA_UPD") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #354
  {DBGFIELD("LDMIA_RET_t2LDMIA_RET") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("tPOP")               65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("tPOP_RET")           65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("PICSTR_STRi12_tSTRr") 1, 0, 0,  4, 1,  0, 1,  0, 0}, // #358
  {DBGFIELD("PICSTRB_PICSTRH_STRBi12_STRH_tSTRBr_tSTRHr") 1, 0, 0,  4, 1,  0, 1,  0, 0}, // #359
  {DBGFIELD("STRBrs_t2STRBs_t2STRHs") 1, 0, 0,  4, 1,  0, 1,  0, 0}, // #360
  {DBGFIELD("STREX_STREXB_STREXD_STREXH") 1, 0, 0,  4, 1,  0, 1,  0, 0}, // #361
  {DBGFIELD("STRrs_t2STRs")       1, 0, 0,  4, 1,  0, 1,  0, 0}, // #362
  {DBGFIELD("t2STRBi12_t2STRBi8_t2STRHi12_t2STRHi8_tSTRBi_tSTRHi") 1, 0, 0,  4, 1,  0, 1,  0, 0}, // #363
  {DBGFIELD("t2STRi12_t2STRi8_tSTRi_tSTRspi") 1, 0, 0,  4, 1,  0, 1,  0, 0}, // #364
  {DBGFIELD("STRBT_POST_STRT_POST") 2, 0, 0, 32, 2, 48, 2,  0, 0}, // #365
  {DBGFIELD("STRBT_POST_IMM_STRBT_POST_REG_STRB_POST_REG_STRB_PRE_REG_STRHTi_STRHTr_STRH_POST_STRH_PRE") 2, 0, 0, 32, 2, 48, 2,  0, 0}, // #366
  {DBGFIELD("STRB_POST_IMM_STRB_PRE_IMM_t2STRB_POST_t2STRB_PRE_t2STRH_POST") 2, 0, 0, 32, 2, 48, 2,  0, 0}, // #367
  {DBGFIELD("STRBi_preidx_STRBr_preidx_STRH_preidx_STRT_POST_IMM_STRT_POST_REG_STR_POST_REG_STR_PRE_REG_STRi_preidx_STRr_preidx_t2STRB_preidx_t2STRH_preidx_t2STR_preidx") 2, 0, 0, 32, 2, 48, 2,  0, 0}, // #368
  {DBGFIELD("STR_POST_IMM_STR_PRE_IMM_t2STRH_PRE_t2STR_POST_t2STR_PRE") 2, 0, 0, 32, 2, 48, 2,  0, 0}, // #369
  {DBGFIELD("t2STRBT_t2STRHT")    2, 0, 0, 32, 2, 48, 2,  0, 0}, // #370
  {DBGFIELD("t2STRT")             2, 0, 0, 32, 2, 48, 2,  0, 0}, // #371
  {DBGFIELD("STRD_t2STRDi8")      3, 0, 0, 26, 2, 561, 3,  0, 0}, // #372
  {DBGFIELD("STRD_POST_STRD_PRE_t2STRD_POST_t2STRD_PRE") 4, 0, 0, 35, 2, 560, 4,  0, 0}, // #373
  {DBGFIELD("STMDA_STMDB_STMIA_STMIB_sysSTMDA_sysSTMDB_sysSTMIA_sysSTMIB_t2STMDB_t2STMIA") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("STMDA_UPD_STMDB_UPD_STMIA_UPD_STMIB_UPD_sysSTMDA_UPD_sysSTMDB_UPD_sysSTMIA_UPD_sysSTMIB_UPD_t2STMDB_UPD_t2STMIA_UPD_tSTMIA_UPD") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("tPUSH")              65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #376
  {DBGFIELD("ITasm")              0, 0, 0,  0, 0,  0, 1,  0, 0}, // #377
  {DBGFIELD("t2IT")               0, 0, 0,  0, 0,  0, 1,  0, 0}, // #378
  {DBGFIELD("VADDLsv2i64_VADDLsv4i32_VADDLsv8i16_VADDLuv2i64_VADDLuv4i32_VADDLuv8i16_VNEGs16d_VNEGs32d_VNEGs8d_VPADDLsv16i8_VPADDLsv2i32_VPADDLsv4i16_VPADDLsv4i32_VPADDLsv8i16_VPADDLsv8i8_VPADDLuv16i8_VPADDLuv2i32_VPADDLuv4i16_VPADDLuv4i32_VPADDLuv8i16_VPADDLuv8i8_VPADDi16_VPADDi32_VPADDi8_VSHLLi16_VSHLLi32_VSHLLi8_VSHLLsv2i64_VSHLLsv4i32_VSHLLsv8i16_VSHLLuv2i64_VSHLLuv4i32_VSHLLuv8i16_VSHLiv16i8_VSHLiv1i64_VSHLiv2i32_VSHLiv2i64_VSHLiv4i16_VSHLiv4i32_VSHLiv8i16_VSHLiv8i8_VSHLsv1i64_VSHLsv2i32_VSHLsv4i16_VSHLsv8i8_VSHLuv1i64_VSHLuv2i32_VSHLuv4i16_VSHLuv8i8_VSHRsv16i8_VSHRsv1i64_VSHRsv2i32_VSHRsv2i64_VSHRsv4i16_VSHRsv4i32_VSHRsv8i16_VSHRsv8i8_VSHRuv16i8_VSHRuv1i64_VSHRuv2i32_VSHRuv2i64_VSHRuv4i16_VSHRuv4i32_VSHRuv8i16_VSHRuv8i8_VSLIv1i64_VSLIv2i32_VSLIv4i16_VSLIv8i8_VSRIv1i64_VSRIv2i32_VSRIv4i16_VSRIv8i8_VSUBLsv2i64_VSUBLsv4i32_VSUBLsv8i16_VSUBLuv2i64_VSUBLuv4i32_VSUBLuv8i16") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #379
  {DBGFIELD("VADDWsv2i64_VADDWsv4i32_VADDWsv8i16_VADDWuv2i64_VADDWuv4i32_VADDWuv8i16_VSUBWsv2i64_VSUBWsv4i32_VSUBWsv8i16_VSUBWuv2i64_VSUBWuv4i32_VSUBWuv8i16_VSUBv1i64_VSUBv2i32_VSUBv4i16_VSUBv8i8") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #380
  {DBGFIELD("VADDv16i8_VADDv2i64_VADDv4i32_VADDv8i16_VANDq_VBICq_VBIFq_VBITq_VEORq_VORNq_VORRq") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #381
  {DBGFIELD("VADDv1i64_VADDv2i32_VADDv4i16_VADDv8i8_VANDd_VBICd_VBIFd_VBITd_VEORd_VORNd_VORRd") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #382
  {DBGFIELD("VBICiv2i32_VBICiv4i16_VBICiv4i32_VBICiv8i16_VORRiv2i32_VORRiv4i16_VORRiv4i32_VORRiv8i16") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #383
  {DBGFIELD("VBSLd_VCLSv2i32_VCLSv4i16_VCLSv8i8_VCLZv2i32_VCLZv4i16_VCLZv8i8_VCNTd") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #384
  {DBGFIELD("VBSLq_VCLSv16i8_VCLSv4i32_VCLSv8i16_VCLZv16i8_VCLZv4i32_VCLZv8i16_VCNTq") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #385
  {DBGFIELD("VHADDsv16i8_VHADDsv4i32_VHADDsv8i16_VHADDuv16i8_VHADDuv4i32_VHADDuv8i16_VRHADDsv16i8_VRHADDsv4i32_VRHADDsv8i16_VRHADDuv16i8_VRHADDuv4i32_VRHADDuv8i16_VTSTv16i8_VTSTv4i32_VTSTv8i16") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #386
  {DBGFIELD("VHADDsv2i32_VHADDsv4i16_VHADDsv8i8_VHADDuv2i32_VHADDuv4i16_VHADDuv8i8_VRHADDsv2i32_VRHADDsv4i16_VRHADDsv8i8_VRHADDuv2i32_VRHADDuv4i16_VRHADDuv8i8_VTSTv2i32_VTSTv4i16_VTSTv8i8") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #387
  {DBGFIELD("VHSUBsv16i8_VHSUBsv4i32_VHSUBsv8i16_VHSUBuv16i8_VHSUBuv4i32_VHSUBuv8i16") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #388
  {DBGFIELD("VHSUBsv2i32_VHSUBsv4i16_VHSUBsv8i8_VHSUBuv2i32_VHSUBuv4i16_VHSUBuv8i8") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #389
  {DBGFIELD("VNEGf32q")           1, 0, 0, 10, 2,  2, 1,  0, 0}, // #390
  {DBGFIELD("VNEGfd")             1, 0, 0, 10, 2,  2, 1,  0, 0}, // #391
  {DBGFIELD("VNEGs16q_VNEGs32q_VNEGs8q_VSHLsv16i8_VSHLsv2i64_VSHLsv4i32_VSHLsv8i16_VSHLuv16i8_VSHLuv2i64_VSHLuv4i32_VSHLuv8i16_VSLIv16i8_VSLIv2i64_VSLIv4i32_VSLIv8i16_VSRIv16i8_VSRIv2i64_VSRIv4i32_VSRIv8i16") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #392
  {DBGFIELD("VQSHLsiv16i8_VQSHLsiv1i64_VQSHLsiv2i32_VQSHLsiv2i64_VQSHLsiv4i16_VQSHLsiv4i32_VQSHLsiv8i16_VQSHLsiv8i8_VQSHLsuv16i8_VQSHLsuv1i64_VQSHLsuv2i32_VQSHLsuv2i64_VQSHLsuv4i16_VQSHLsuv4i32_VQSHLsuv8i16_VQSHLsuv8i8_VQSHLsv1i64_VQSHLsv2i32_VQSHLsv4i16_VQSHLsv8i8_VQSHLuiv16i8_VQSHLuiv1i64_VQSHLuiv2i32_VQSHLuiv2i64_VQSHLuiv4i16_VQSHLuiv4i32_VQSHLuiv8i16_VQSHLuiv8i8_VQSHLuv1i64_VQSHLuv2i32_VQSHLuv4i16_VQSHLuv8i8") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #393
  {DBGFIELD("VQSHLsv16i8_VQSHLsv2i64_VQSHLsv4i32_VQSHLsv8i16_VQSHLuv16i8_VQSHLuv2i64_VQSHLuv4i32_VQSHLuv8i16") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #394
  {DBGFIELD("VSUBv16i8_VSUBv2i64_VSUBv4i32_VSUBv8i16") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #395
  {DBGFIELD("VEXTd16_VEXTd32_VEXTd8") 1, 0, 0, 61, 2,  2, 1,  0, 0}, // #396
  {DBGFIELD("VEXTq16_VEXTq32_VEXTq64_VEXTq8") 1, 0, 0, 61, 2,  2, 1,  0, 0}, // #397
  {DBGFIELD("VREV16d8_VREV32d16_VREV32d8_VREV64d16_VREV64d32_VREV64d8") 1, 0, 0, 61, 2,  2, 1,  0, 0}, // #398
  {DBGFIELD("VREV16q8_VREV32q16_VREV32q8_VREV64q16_VREV64q32_VREV64q8") 1, 0, 0, 61, 2,  2, 1,  0, 0}, // #399
  {DBGFIELD("VABALsv2i64_VABALsv4i32_VABALsv8i16_VABALuv2i64_VABALuv4i32_VABALuv8i16_VABAsv2i32_VABAsv4i16_VABAsv8i8_VABAuv2i32_VABAuv4i16_VABAuv8i8") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #400
  {DBGFIELD("VABAsv16i8_VABAsv4i32_VABAsv8i16_VABAuv16i8_VABAuv4i32_VABAuv8i16") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #401
  {DBGFIELD("VABSfd")             1, 0, 0, 10, 2, 18, 1,  0, 0}, // #402
  {DBGFIELD("VABSfq")             1, 0, 0, 10, 2, 18, 1,  0, 0}, // #403
  {DBGFIELD("VABSv16i8_VABSv4i32_VABSv8i16") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #404
  {DBGFIELD("VABSv2i32_VABSv4i16_VABSv8i8") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #405
  {DBGFIELD("VACGEd_VACGTd_VCEQfd_VCGEfd_VCGTfd") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #406
  {DBGFIELD("VACGEq_VACGTq_VCEQfq_VCGEfq_VCGTfq") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #407
  {DBGFIELD("VCEQv16i8_VCEQv4i32_VCEQv8i16_VCGEsv16i8_VCGEsv4i32_VCGEsv8i16_VCGEuv16i8_VCGEuv4i32_VCGEuv8i16_VCGTsv16i8_VCGTsv4i32_VCGTsv8i16_VCGTuv16i8_VCGTuv4i32_VCGTuv8i16_VQSUBsv16i8_VQSUBsv2i64_VQSUBsv4i32_VQSUBsv8i16_VQSUBuv16i8_VQSUBuv2i64_VQSUBuv4i32_VQSUBuv8i16") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #408
  {DBGFIELD("VCEQv2i32_VCEQv4i16_VCEQv8i8_VCGEsv2i32_VCGEsv4i16_VCGEsv8i8_VCGEuv2i32_VCGEuv4i16_VCGEuv8i8_VCGTsv2i32_VCGTsv4i16_VCGTsv8i8_VCGTuv2i32_VCGTuv4i16_VCGTuv8i8_VQSUBsv1i64_VQSUBsv2i32_VQSUBsv4i16_VQSUBsv8i8_VQSUBuv1i64_VQSUBuv2i32_VQSUBuv4i16_VQSUBuv8i8") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #409
  {DBGFIELD("VCEQzv16i8_VCEQzv2f32_VCEQzv2i32_VCEQzv4f32_VCEQzv4i16_VCEQzv4i32_VCEQzv8i16_VCEQzv8i8_VCGEzv16i8_VCGEzv2f32_VCGEzv2i32_VCGEzv4f32_VCGEzv4i16_VCGEzv4i32_VCGEzv8i16_VCGEzv8i8_VCGTzv16i8_VCGTzv2f32_VCGTzv2i32_VCGTzv4f32_VCGTzv4i16_VCGTzv4i32_VCGTzv8i16_VCGTzv8i8_VCLEzv16i8_VCLEzv2f32_VCLEzv2i32_VCLEzv4f32_VCLEzv4i16_VCLEzv4i32_VCLEzv8i16_VCLEzv8i8_VCLTzv16i8_VCLTzv2f32_VCLTzv2i32_VCLTzv4f32_VCLTzv4i16_VCLTzv4i32_VCLTzv8i16_VCLTzv8i8") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #410
  {DBGFIELD("VPADALsv16i8_VPADALsv4i32_VPADALsv8i16_VPADALuv16i8_VPADALuv4i32_VPADALuv8i16") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #411
  {DBGFIELD("VPADALsv2i32_VPADALsv4i16_VPADALsv8i8_VPADALuv2i32_VPADALuv4i16_VPADALuv8i8_VRSRAsv16i8_VRSRAsv1i64_VRSRAsv2i32_VRSRAsv2i64_VRSRAsv4i16_VRSRAsv4i32_VRSRAsv8i16_VRSRAsv8i8_VRSRAuv16i8_VRSRAuv1i64_VRSRAuv2i32_VRSRAuv2i64_VRSRAuv4i16_VRSRAuv4i32_VRSRAuv8i16_VRSRAuv8i8_VSRAsv16i8_VSRAsv1i64_VSRAsv2i32_VSRAsv2i64_VSRAsv4i16_VSRAsv4i32_VSRAsv8i16_VSRAsv8i8_VSRAuv16i8_VSRAuv1i64_VSRAuv2i32_VSRAuv2i64_VSRAuv4i16_VSRAuv4i32_VSRAuv8i16_VSRAuv8i8") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #412
  {DBGFIELD("VQABSv16i8_VQABSv4i32_VQABSv8i16_VQNEGv16i8_VQNEGv4i32_VQNEGv8i16") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #413
  {DBGFIELD("VQABSv2i32_VQABSv4i16_VQABSv8i8_VQNEGv2i32_VQNEGv4i16_VQNEGv8i8") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #414
  {DBGFIELD("VQADDsv16i8_VQADDsv2i64_VQADDsv4i32_VQADDsv8i16_VQADDuv16i8_VQADDuv2i64_VQADDuv4i32_VQADDuv8i16") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #415
  {DBGFIELD("VQADDsv1i64_VQADDsv2i32_VQADDsv4i16_VQADDsv8i8_VQADDuv1i64_VQADDuv2i32_VQADDuv4i16_VQADDuv8i8") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #416
  {DBGFIELD("VQRSHLsv16i8_VQRSHLsv2i64_VQRSHLsv4i32_VQRSHLsv8i16_VQRSHLuv16i8_VQRSHLuv2i64_VQRSHLuv4i32_VQRSHLuv8i16_VRSHLsv16i8_VRSHLsv2i64_VRSHLsv4i32_VRSHLsv8i16_VRSHLuv16i8_VRSHLuv2i64_VRSHLuv4i32_VRSHLuv8i16") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #417
  {DBGFIELD("VQRSHLsv1i64_VQRSHLsv2i32_VQRSHLsv4i16_VQRSHLsv8i8_VQRSHLuv1i64_VQRSHLuv2i32_VQRSHLuv4i16_VQRSHLuv8i8_VRSHLsv1i64_VRSHLsv2i32_VRSHLsv4i16_VRSHLsv8i8_VRSHLuv1i64_VRSHLuv2i32_VRSHLuv4i16_VRSHLuv8i8_VRSHRsv16i8_VRSHRsv1i64_VRSHRsv2i32_VRSHRsv2i64_VRSHRsv4i16_VRSHRsv4i32_VRSHRsv8i16_VRSHRsv8i8_VRSHRuv16i8_VRSHRuv1i64_VRSHRuv2i32_VRSHRuv2i64_VRSHRuv4i16_VRSHRuv4i32_VRSHRuv8i16_VRSHRuv8i8") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #418
  {DBGFIELD("VRECPEd_VRECPEfd_VRSQRTEd_VRSQRTEfd") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #419
  {DBGFIELD("VRECPEfq_VRECPEq_VRSQRTEfq_VRSQRTEq") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #420
  {DBGFIELD("VADDHNv2i32_VADDHNv4i16_VADDHNv8i8_VSUBHNv2i32_VSUBHNv4i16_VSUBHNv8i8") 1, 0, 0, 110, 3, 18, 1,  0, 0}, // #421
  {DBGFIELD("VSHRNv2i32_VSHRNv4i16_VSHRNv8i8") 1, 0, 0, 110, 3, 18, 1,  0, 0}, // #422
  {DBGFIELD("VQRSHRNsv2i32_VQRSHRNsv4i16_VQRSHRNsv8i8_VQRSHRNuv2i32_VQRSHRNuv4i16_VQRSHRNuv8i8_VQRSHRUNv2i32_VQRSHRUNv4i16_VQRSHRUNv8i8_VQSHRNsv2i32_VQSHRNsv4i16_VQSHRNsv8i8_VQSHRNuv2i32_VQSHRNuv4i16_VQSHRNuv8i8_VQSHRUNv2i32_VQSHRUNv4i16_VQSHRUNv8i8_VRSHRNv2i32_VRSHRNv4i16_VRSHRNv8i8") 1, 0, 0, 110, 3, 27, 1,  0, 0}, // #423
  {DBGFIELD("VRADDHNv2i32_VRADDHNv4i16_VRADDHNv8i8_VRSUBHNv2i32_VRSUBHNv4i16_VRSUBHNv8i8") 1, 0, 0, 110, 3, 27, 1,  0, 0}, // #424
  {DBGFIELD("VTBL1")              1, 0, 0, 61, 2,  2, 1,  0, 0}, // #425
  {DBGFIELD("VTBX1")              1, 0, 0, 61, 2,  2, 1,  0, 0}, // #426
  {DBGFIELD("VTBL2")              2, 0, 0, 118, 2, 18, 1,  0, 0}, // #427
  {DBGFIELD("VTBX2")              2, 0, 0, 118, 2, 18, 1,  0, 0}, // #428
  {DBGFIELD("VTBL3_VTBL3Pseudo")  3, 0, 0, 120, 2, 27, 1,  0, 0}, // #429
  {DBGFIELD("VTBX3_VTBX3Pseudo")  3, 0, 0, 120, 2, 27, 1,  0, 0}, // #430
  {DBGFIELD("VTBL4_VTBL4Pseudo")  4, 0, 0, 122, 2, 42, 1,  0, 0}, // #431
  {DBGFIELD("VTBX4_VTBX4Pseudo")  4, 0, 0, 122, 2, 42, 1,  0, 0}, // #432
  {DBGFIELD("VSWPd_VSWPq")        3, 0, 0, 120, 2, 52, 3, 64, 1}, // #433
  {DBGFIELD("VTRNd16_VTRNd32_VTRNd8_VUZPd16_VUZPd8_VZIPd16_VZIPd8") 3, 0, 0, 120, 2, 52, 3, 64, 1}, // #434
  {DBGFIELD("VTRNq16_VTRNq32_VTRNq8") 3, 0, 0, 120, 2, 52, 3, 64, 1}, // #435
  {DBGFIELD("VUZPq16_VUZPq32_VUZPq8_VZIPq16_VZIPq32_VZIPq8") 3, 0, 0, 120, 2, 52, 3, 64, 1}, // #436
  {DBGFIELD("VABSD_VNEGD")        1, 0, 0, 10, 2,  2, 1,  0, 0}, // #437
  {DBGFIELD("VABSS_VNEGS")        1, 0, 0, 10, 2,  2, 1,  0, 0}, // #438
  {DBGFIELD("VCMPD_VCMPED_VCMPEZD_VCMPZD") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #439
  {DBGFIELD("VCMPES_VCMPEZS_VCMPS_VCMPZS") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #440
  {DBGFIELD("VABDLsv2i64_VABDLsv4i32_VABDLsv8i16_VABDLuv2i64_VABDLuv4i32_VABDLuv8i16_VABDsv16i8_VABDsv4i32_VABDsv8i16_VABDuv16i8_VABDuv4i32_VABDuv8i16_VMAXsv16i8_VMAXsv4i32_VMAXsv8i16_VMAXuv16i8_VMAXuv4i32_VMAXuv8i16_VMINsv16i8_VMINsv4i32_VMINsv8i16_VMINuv16i8_VMINuv4i32_VMINuv8i16") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #441
  {DBGFIELD("VABDfd_VADDfd_VMAXfd_VMINfd_VSUBfd") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #442
  {DBGFIELD("VABDfq_VADDfq_VMAXfq_VMINfq_VSUBfq") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #443
  {DBGFIELD("VABDsv2i32_VABDsv4i16_VABDsv8i8_VABDuv2i32_VABDuv4i16_VABDuv8i8_VMAXsv2i32_VMAXsv4i16_VMAXsv8i8_VMAXuv2i32_VMAXuv4i16_VMAXuv8i8_VMINsv2i32_VMINsv4i16_VMINsv8i8_VMINuv2i32_VMINuv4i16_VMINuv8i8_VPMAXs16_VPMAXs32_VPMAXs8_VPMAXu16_VPMAXu32_VPMAXu8_VPMINs16_VPMINs32_VPMINs8_VPMINu16_VPMINu32_VPMINu8") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #444
  {DBGFIELD("VADDS_VSUBS")        1, 0, 0, 10, 2, 18, 1,  0, 0}, // #445
  {DBGFIELD("VMAXNMD_VMAXNMND_VMAXNMNQ_VMAXNMS_VMINNMD_VMINNMND_VMINNMNQ_VMINNMS") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #446
  {DBGFIELD("VPADDf_VPMAXf_VPMINf") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #447
  {DBGFIELD("VADDD_VSUBD")        1, 0, 0, 10, 2, 27, 1,  0, 0}, // #448
  {DBGFIELD("VRECPSfd_VRSQRTSfd") 1, 0, 0, 61, 2, 42, 1,  0, 0}, // #449
  {DBGFIELD("VRECPSfq_VRSQRTSfq") 1, 0, 0, 61, 2, 42, 1,  0, 0}, // #450
  {DBGFIELD("VMULLp64")           1, 0, 0, 61, 2, 18, 1,  0, 0}, // #451
  {DBGFIELD("VMULLp8_VMULLslsv2i32_VMULLslsv4i16_VMULLsluv2i32_VMULLsluv4i16_VMULLsv4i32_VMULLsv8i16_VMULLuv4i32_VMULLuv8i16_VMULpd_VMULslv4i16_VMULv4i16_VMULv8i8_VQDMULHslv4i16_VQDMULHv4i16_VQDMULLslv2i32_VQDMULLslv4i16_VQDMULLv4i32_VQRDMULHslv4i16_VQRDMULHv4i16") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #452
  {DBGFIELD("VMULLsv2i64_VMULLuv2i64_VMULslv2i32_VMULv2i32_VQDMULHslv2i32_VQDMULHv2i32_VQDMULLv2i64_VQRDMULHslv2i32_VQRDMULHv2i32") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #453
  {DBGFIELD("VMULS_VNMULS")       1, 0, 0, 61, 2, 18, 1,  0, 0}, // #454
  {DBGFIELD("VMULfd")             1, 0, 0, 61, 2, 18, 1,  0, 0}, // #455
  {DBGFIELD("VMULfq")             1, 0, 0, 61, 2, 18, 1,  0, 0}, // #456
  {DBGFIELD("VMULpq_VMULslv8i16_VMULv16i8_VMULv8i16_VQDMULHslv8i16_VQDMULHv8i16_VQRDMULHslv8i16_VQRDMULHv8i16") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #457
  {DBGFIELD("VMULslfd")           1, 0, 0, 61, 2, 18, 1,  0, 0}, // #458
  {DBGFIELD("VMULslfq")           1, 0, 0, 61, 2, 18, 1,  0, 0}, // #459
  {DBGFIELD("VMULslv4i32_VMULv4i32_VQDMULHslv4i32_VQDMULHv4i32_VQRDMULHslv4i32_VQRDMULHv4i32") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #460
  {DBGFIELD("VMULD_VNMULD")       1, 0, 0, 61, 2, 27, 1,  0, 0}, // #461
  {DBGFIELD("VFMAD_VFMSD_VFNMAD_VFNMSD") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #462
  {DBGFIELD("VFMAS_VFMSS_VFNMAS_VFNMSS") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #463
  {DBGFIELD("VMLAD_VMLSD_VNMLAD_VNMLSD") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #464
  {DBGFIELD("VMLALslsv2i32_VMLALsluv2i32_VMLALsv2i64_VMLALuv2i64_VMLAslv2i32_VMLAv2i32_VMLSLslsv2i32_VMLSLsluv2i32_VMLSLsv2i64_VMLSLuv2i64_VMLSslv2i32_VMLSv2i32_VQDMLALslv2i32_VQDMLALv2i64_VQDMLSLslv2i32_VQDMLSLv2i64") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #465
  {DBGFIELD("VMLALslsv4i16_VMLALsluv4i16_VMLALsv4i32_VMLALsv8i16_VMLALuv4i32_VMLALuv8i16_VMLAslv4i16_VMLAv4i16_VMLAv8i8_VMLSLslsv4i16_VMLSLsluv4i16_VMLSLsv4i32_VMLSLsv8i16_VMLSLuv4i32_VMLSLuv8i16_VMLSslv4i16_VMLSv4i16_VMLSv8i8_VQDMLALslv4i16_VQDMLALv4i32_VQDMLSLslv4i16_VQDMLSLv4i32") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #466
  {DBGFIELD("VMLAS_VMLSS_VNMLAS_VNMLSS") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #467
  {DBGFIELD("VMLAfd_VMLAslfd_VMLSfd_VMLSslfd") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #468
  {DBGFIELD("VMLAfq_VMLAslfq_VMLSfq_VMLSslfq") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #469
  {DBGFIELD("VMLAslv4i32_VMLAv4i32_VMLSslv4i32_VMLSv4i32") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #470
  {DBGFIELD("VMLAslv8i16_VMLAv16i8_VMLAv8i16_VMLSslv8i16_VMLSv16i8_VMLSv8i16") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #471
  {DBGFIELD("VFMAfd_VFMSfd")      1, 0, 0, 61, 2, 42, 1,  0, 0}, // #472
  {DBGFIELD("VFMAfq_VFMSfq")      1, 0, 0, 61, 2, 564, 1,  0, 0}, // #473
  {DBGFIELD("VCVTANSD_VCVTANSQ_VCVTANUD_VCVTANUQ_VCVTASD_VCVTASS_VCVTAUD_VCVTAUS_VCVTBDH_VCVTBHD_VCVTMNSD_VCVTMNSQ_VCVTMNUD_VCVTMNUQ_VCVTMSD_VCVTMSS_VCVTMUD_VCVTMUS_VCVTNNSD_VCVTNNSQ_VCVTNNUD_VCVTNNUQ_VCVTNSD_VCVTNSS_VCVTNUD_VCVTNUS_VCVTPNSD_VCVTPNSQ_VCVTPNUD_VCVTPNUQ_VCVTPSD_VCVTPSS_VCVTPUD_VCVTPUS_VCVTTDH_VCVTTHD") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #474
  {DBGFIELD("VCVTBHS_VCVTTHS")    1, 0, 0, 61, 2, 18, 1,  0, 0}, // #475
  {DBGFIELD("VCVTBSH_VCVTTSH")    1, 0, 0, 61, 2, 18, 1,  0, 0}, // #476
  {DBGFIELD("VCVTDS")             1, 0, 0, 61, 2, 18, 1,  0, 0}, // #477
  {DBGFIELD("VCVTSD")             1, 0, 0, 61, 2, 18, 1,  0, 0}, // #478
  {DBGFIELD("VCVTf2h_VCVTf2sq_VCVTf2uq_VCVTf2xsq_VCVTf2xuq_VCVTh2f_VCVTs2fq_VCVTu2fq_VCVTxs2fq_VCVTxu2fq") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #479
  {DBGFIELD("VCVTf2sd_VCVTf2ud_VCVTf2xsd_VCVTf2xud_VCVTs2fd_VCVTu2fd_VCVTxs2fd_VCVTxu2fd") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #480
  {DBGFIELD("VSITOD_VUITOD")      1, 0, 0, 61, 2, 18, 1,  0, 0}, // #481
  {DBGFIELD("VSITOS_VUITOS")      1, 0, 0, 61, 2, 18, 1,  0, 0}, // #482
  {DBGFIELD("VTOSHD_VTOSLD_VTOUHD_VTOULD") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #483
  {DBGFIELD("VTOSHS_VTOSLS_VTOUHS_VTOULS") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #484
  {DBGFIELD("VTOSIRD_VTOSIZD_VTOUIRD_VTOUIZD") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #485
  {DBGFIELD("VTOSIRS_VTOSIZS_VTOUIRS_VTOUIZS") 1, 0, 0, 61, 2, 18, 1,  0, 0}, // #486
  {DBGFIELD("FCONSTD_VMOVD_VMOVDcc") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #487
  {DBGFIELD("FCONSTS_VMOVS_VMOVScc") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #488
  {DBGFIELD("VMOVv16i8_VMOVv1i64_VMOVv2f32_VMOVv2i32_VMOVv2i64_VMOVv4f32_VMOVv4i16_VMOVv4i32_VMOVv8i16_VMOVv8i8_VMVNv2i32_VMVNv4i16_VMVNv4i32_VMVNv8i16") 1, 0, 0, 10, 2,  2, 1,  0, 0}, // #489
  {DBGFIELD("VMVNd_VMVNq")        1, 0, 0, 10, 2,  2, 1,  0, 0}, // #490
  {DBGFIELD("VMOVLsv2i64_VMOVLsv4i32_VMOVLsv8i16_VMOVLuv2i64_VMOVLuv4i32_VMOVLuv8i16") 1, 0, 0, 61, 2,  2, 1,  0, 0}, // #491
  {DBGFIELD("VMOVNv2i32_VMOVNv4i16_VMOVNv8i8") 1, 0, 0, 61, 2,  2, 1,  0, 0}, // #492
  {DBGFIELD("VQMOVNsuv2i32_VQMOVNsuv4i16_VQMOVNsuv8i8_VQMOVNsv2i32_VQMOVNsv4i16_VQMOVNsv8i8_VQMOVNuv2i32_VQMOVNuv4i16_VQMOVNuv8i8") 2, 0, 0, 110, 3, 27, 1,  0, 0}, // #493
  {DBGFIELD("VDUPLN16d_VDUPLN32d_VDUPLN8d") 1, 0, 0, 61, 2,  2, 1,  0, 0}, // #494
  {DBGFIELD("VDUPLN16q_VDUPLN32q_VDUPLN8q") 1, 0, 0, 61, 2,  2, 1,  0, 0}, // #495
  {DBGFIELD("VDUP16d_VDUP16q_VDUP32d_VDUP32q_VDUP8d_VDUP8q") 2, 0, 0, 102, 3, 27, 1,  0, 0}, // #496
  {DBGFIELD("VMOVRS")             1, 0, 0,  4, 1,  3, 1,  0, 0}, // #497
  {DBGFIELD("VMOVSR")             2, 0, 0, 124, 3, 27, 1,  0, 0}, // #498
  {DBGFIELD("VSETLNi16_VSETLNi32_VSETLNi8") 2, 0, 0, 124, 3, 27, 1,  0, 0}, // #499
  {DBGFIELD("VMOVRRD_VMOVRRS")    2, 0, 0, 22, 1, 23, 2,  0, 0}, // #500
  {DBGFIELD("VMOVDRR")            1, 0, 0,  4, 1, 18, 1,  0, 0}, // #501
  {DBGFIELD("VMOVSRR")            4, 0, 0, 127, 3, 81, 2,  0, 0}, // #502
  {DBGFIELD("VGETLNi32_VGETLNu16_VGETLNu8") 2, 0, 0, 102, 3, 19, 1,  0, 0}, // #503
  {DBGFIELD("VGETLNs16_VGETLNs8") 3, 0, 0, 130, 3, 27, 1,  0, 0}, // #504
  {DBGFIELD("VMRS_VMRS_FPEXC_VMRS_FPINST_VMRS_FPINST2_VMRS_FPSID_VMRS_MVFR0_VMRS_MVFR1_VMRS_MVFR2") 3, 0, 0, 133, 4, 565, 3,  0, 0}, // #505
  {DBGFIELD("VMSR_VMSR_FPEXC_VMSR_FPINST_VMSR_FPINST2_VMSR_FPSID") 3, 0, 0, 133, 4, 565, 3,  0, 0}, // #506
  {DBGFIELD("FMSTAT")             1, 0, 0, 10, 2,  2, 1,  0, 0}, // #507
  {DBGFIELD("VLDRD")              1, 0, 0,  4, 1, 18, 1,  0, 0}, // #508
  {DBGFIELD("VLDRS")              1, 0, 0,  4, 1, 18, 1,  0, 0}, // #509
  {DBGFIELD("VSTRD")              1, 0, 0,  4, 1, 18, 1,  0, 0}, // #510
  {DBGFIELD("VSTRS")              1, 0, 0,  4, 1, 18, 1,  0, 0}, // #511
  {DBGFIELD("VLDMQIA")            1, 0, 0,  4, 1, 18, 1,  0, 0}, // #512
  {DBGFIELD("VSTMQIA")            1, 0, 0,  4, 1, 18, 1,  0, 0}, // #513
  {DBGFIELD("VLDMDIA_VLDMSIA")    65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("VLDMDDB_UPD_VLDMDIA_UPD_VLDMSDB_UPD_VLDMSIA_UPD") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("VSTMDIA_VSTMSIA")    65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("VSTMDDB_UPD_VSTMDIA_UPD_VSTMSDB_UPD_VSTMSIA_UPD") 65534, 0, 0,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("VLD1d16_VLD1d32_VLD1d64_VLD1d8") 1, 0, 0,  4, 1, 18, 1,  0, 0}, // #518
  {DBGFIELD("VLD1q16_VLD1q32_VLD1q64_VLD1q8") 1, 0, 0,  4, 1, 18, 1,  0, 0}, // #519
  {DBGFIELD("VLD1d16wb_fixed_VLD1d16wb_register_VLD1d32wb_fixed_VLD1d32wb_register_VLD1d64wb_fixed_VLD1d64wb_register_VLD1d8wb_fixed_VLD1d8wb_register") 2, 0, 0, 32, 2, 284, 2,  0, 0}, // #520
  {DBGFIELD("VLD1q16wb_fixed_VLD1q16wb_register_VLD1q32wb_fixed_VLD1q32wb_register_VLD1q64wb_fixed_VLD1q64wb_register_VLD1q8wb_fixed_VLD1q8wb_register") 2, 0, 0, 32, 2, 284, 2,  0, 0}, // #521
  {DBGFIELD("VLD1d16T_VLD1d32T_VLD1d64T_VLD1d64TPseudo_VLD1d64TPseudoWB_fixed_VLD1d64TPseudoWB_register_VLD1d8T") 1, 0, 0, 29, 1, 18, 1,  0, 0}, // #522
  {DBGFIELD("VLD1d16Twb_fixed_VLD1d16Twb_register_VLD1d32Twb_fixed_VLD1d32Twb_register_VLD1d64Twb_fixed_VLD1d64Twb_register_VLD1d8Twb_fixed_VLD1d8Twb_register") 2, 0, 0, 137, 2, 284, 2,  0, 0}, // #523
  {DBGFIELD("VLD1d16Q_VLD1d32Q_VLD1d64Q_VLD1d64QPseudo_VLD1d64QPseudoWB_fixed_VLD1d64QPseudoWB_register_VLD1d8Q") 1, 0, 0, 22, 1, 18, 1,  0, 0}, // #524
  {DBGFIELD("VLD1d16Qwb_fixed_VLD1d16Qwb_register_VLD1d32Qwb_fixed_VLD1d32Qwb_register_VLD1d64Qwb_fixed_VLD1d64Qwb_register_VLD1d8Qwb_fixed_VLD1d8Qwb_register") 2, 0, 0, 26, 2, 284, 2,  0, 0}, // #525
  {DBGFIELD("VLD2b16_VLD2b32_VLD2b8_VLD2d16_VLD2d32_VLD2d8") 5, 0, 0, 139, 4, 568, 3,  0, 0}, // #526
  {DBGFIELD("VLD2q16_VLD2q16Pseudo_VLD2q32_VLD2q32Pseudo_VLD2q8_VLD2q8Pseudo") 5, 0, 0, 139, 4, 568, 3,  0, 0}, // #527
  {DBGFIELD("VLD2b16wb_fixed_VLD2b16wb_register_VLD2b32wb_fixed_VLD2b32wb_register_VLD2b8wb_fixed_VLD2b8wb_register_VLD2d16wb_fixed_VLD2d16wb_register_VLD2d32wb_fixed_VLD2d32wb_register_VLD2d8wb_fixed_VLD2d8wb_register") 6, 0, 0, 143, 4, 571, 4,  0, 0}, // #528
  {DBGFIELD("VLD2q16PseudoWB_fixed_VLD2q16PseudoWB_register_VLD2q16wb_fixed_VLD2q16wb_register_VLD2q32PseudoWB_fixed_VLD2q32PseudoWB_register_VLD2q32wb_fixed_VLD2q32wb_register_VLD2q8PseudoWB_fixed_VLD2q8PseudoWB_register_VLD2q8wb_fixed_VLD2q8wb_register") 6, 0, 0, 143, 4, 571, 4,  0, 0}, // #529
  {DBGFIELD("VLD3d16_VLD3d32_VLD3d8_VLD3q16_VLD3q32_VLD3q8") 5, 0, 0, 147, 3, 575, 5,  0, 0}, // #530
  {DBGFIELD("VLD3d16Pseudo_VLD3d32Pseudo_VLD3d8Pseudo_VLD3q16oddPseudo_VLD3q32oddPseudo_VLD3q8oddPseudo") 5, 0, 0, 147, 3, 577, 3,  0, 0}, // #531
  {DBGFIELD("VLD3d16_UPD_VLD3d32_UPD_VLD3d8_UPD_VLD3q16_UPD_VLD3q32_UPD_VLD3q8_UPD") 6, 0, 0, 150, 3, 580, 6,  0, 0}, // #532
  {DBGFIELD("VLD3d16Pseudo_UPD_VLD3d32Pseudo_UPD_VLD3d8Pseudo_UPD_VLD3q16Pseudo_UPD_VLD3q16oddPseudo_UPD_VLD3q32Pseudo_UPD_VLD3q32oddPseudo_UPD_VLD3q8Pseudo_UPD_VLD3q8oddPseudo_UPD") 6, 0, 0, 150, 3, 582, 4,  0, 0}, // #533
  {DBGFIELD("VLD4d16_VLD4d32_VLD4d8_VLD4q16_VLD4q32_VLD4q8") 11, 0, 0, 153, 4, 586, 7,  0, 0}, // #534
  {DBGFIELD("VLD4d16Pseudo_VLD4d32Pseudo_VLD4d8Pseudo_VLD4q16oddPseudo_VLD4q32oddPseudo_VLD4q8oddPseudo") 8, 0, 0, 157, 4, 589, 4,  0, 0}, // #535
  {DBGFIELD("VLD4d16_UPD_VLD4d32_UPD_VLD4d8_UPD_VLD4q16_UPD_VLD4q32_UPD_VLD4q8_UPD") 12, 0, 0, 161, 4, 593, 8,  0, 0}, // #536
  {DBGFIELD("VLD4d16Pseudo_UPD_VLD4d32Pseudo_UPD_VLD4d8Pseudo_UPD_VLD4q16Pseudo_UPD_VLD4q16oddPseudo_UPD_VLD4q32Pseudo_UPD_VLD4q32oddPseudo_UPD_VLD4q8Pseudo_UPD_VLD4q8oddPseudo_UPD") 9, 0, 0, 165, 4, 596, 5,  0, 0}, // #537
  {DBGFIELD("VLD1DUPd16_VLD1DUPd32_VLD1DUPd8_VLD1DUPq16_VLD1DUPq32_VLD1DUPq8") 3, 0, 0, 169, 3, 98, 2,  0, 0}, // #538
  {DBGFIELD("VLD1LNd16_VLD1LNd32_VLD1LNd8_VLD1LNq16Pseudo_VLD1LNq32Pseudo_VLD1LNq8Pseudo") 3, 0, 0, 169, 3, 98, 2,  0, 0}, // #539
  {DBGFIELD("VLD1DUPd16wb_fixed_VLD1DUPd16wb_register_VLD1DUPd32wb_fixed_VLD1DUPd32wb_register_VLD1DUPd8wb_fixed_VLD1DUPd8wb_register_VLD1DUPq16wb_fixed_VLD1DUPq16wb_register_VLD1DUPq32wb_fixed_VLD1DUPq32wb_register_VLD1DUPq8wb_fixed_VLD1DUPq8wb_register") 4, 0, 0, 172, 3, 601, 3,  0, 0}, // #540
  {DBGFIELD("VLD1LNd16_UPD_VLD1LNd32_UPD_VLD1LNd8_UPD_VLD1LNq16Pseudo_UPD_VLD1LNq32Pseudo_UPD_VLD1LNq8Pseudo_UPD") 4, 0, 0, 172, 3, 601, 3,  0, 0}, // #541
  {DBGFIELD("VLD2DUPd16_VLD2DUPd16x2_VLD2DUPd32_VLD2DUPd32x2_VLD2DUPd8_VLD2DUPd8x2") 5, 0, 0, 175, 4, 604, 4,  0, 0}, // #542
  {DBGFIELD("VLD2LNd16_VLD2LNd16Pseudo_VLD2LNd32_VLD2LNd32Pseudo_VLD2LNd8_VLD2LNd8Pseudo_VLD2LNq16_VLD2LNq16Pseudo_VLD2LNq32_VLD2LNq32Pseudo") 5, 0, 0, 175, 4, 604, 4,  0, 0}, // #543
  {DBGFIELD("VLD2LNd16_UPD_VLD2LNd32_UPD_VLD2LNd8_UPD_VLD2LNq16_UPD_VLD2LNq32_UPD") 6, 0, 0, 179, 4, 608, 5,  0, 0}, // #544
  {DBGFIELD("VLD2DUPd16wb_fixed_VLD2DUPd16wb_register_VLD2DUPd16x2wb_fixed_VLD2DUPd16x2wb_register_VLD2DUPd32wb_fixed_VLD2DUPd32wb_register_VLD2DUPd32x2wb_fixed_VLD2DUPd32x2wb_register_VLD2DUPd8wb_fixed_VLD2DUPd8wb_register_VLD2DUPd8x2wb_fixed_VLD2DUPd8x2wb_register") 6, 0, 0, 179, 4, 613, 5,  0, 0}, // #545
  {DBGFIELD("VLD2LNd16Pseudo_UPD_VLD2LNd32Pseudo_UPD_VLD2LNd8Pseudo_UPD_VLD2LNq16Pseudo_UPD_VLD2LNq32Pseudo_UPD") 6, 0, 0, 179, 4, 613, 5,  0, 0}, // #546
  {DBGFIELD("VLD3DUPd16_VLD3DUPd16Pseudo_VLD3DUPd32_VLD3DUPd32Pseudo_VLD3DUPd8_VLD3DUPd8Pseudo_VLD3DUPq16_VLD3DUPq32_VLD3DUPq8") 7, 0, 0, 183, 4, 618, 5,  0, 0}, // #547
  {DBGFIELD("VLD3LNd16_VLD3LNd16Pseudo_VLD3LNd32_VLD3LNd32Pseudo_VLD3LNd8_VLD3LNd8Pseudo_VLD3LNq16_VLD3LNq16Pseudo_VLD3LNq32_VLD3LNq32Pseudo") 7, 0, 0, 183, 4, 618, 5,  0, 0}, // #548
  {DBGFIELD("VLD3DUPd16_UPD_VLD3DUPd32_UPD_VLD3DUPd8_UPD_VLD3DUPq16_UPD_VLD3DUPq32_UPD_VLD3DUPq8_UPD") 8, 0, 0, 187, 4, 623, 6,  0, 0}, // #549
  {DBGFIELD("VLD3LNd16_UPD_VLD3LNd32_UPD_VLD3LNd8_UPD_VLD3LNq16_UPD_VLD3LNq32_UPD") 8, 0, 0, 187, 4, 623, 6,  0, 0}, // #550
  {DBGFIELD("VLD3DUPd16Pseudo_UPD_VLD3DUPd32Pseudo_UPD_VLD3DUPd8Pseudo_UPD") 8, 0, 0, 187, 4, 629, 6,  0, 0}, // #551
  {DBGFIELD("VLD3LNd16Pseudo_UPD_VLD3LNd32Pseudo_UPD_VLD3LNd8Pseudo_UPD_VLD3LNq16Pseudo_UPD_VLD3LNq32Pseudo_UPD") 8, 0, 0, 187, 4, 629, 6,  0, 0}, // #552
  {DBGFIELD("VLD4DUPd16_VLD4DUPd16Pseudo_VLD4DUPd32_VLD4DUPd32Pseudo_VLD4DUPd8_VLD4DUPd8Pseudo_VLD4DUPq16_VLD4DUPq32_VLD4DUPq8") 8, 0, 0, 191, 4, 635, 6,  0, 0}, // #553
  {DBGFIELD("VLD4LNd16_VLD4LNd16Pseudo_VLD4LNd32_VLD4LNd32Pseudo_VLD4LNd8_VLD4LNd8Pseudo_VLD4LNq16_VLD4LNq16Pseudo_VLD4LNq32_VLD4LNq32Pseudo") 8, 0, 0, 191, 4, 635, 6,  0, 0}, // #554
  {DBGFIELD("VLD4DUPd16_UPD_VLD4DUPd32_UPD_VLD4DUPd8_UPD_VLD4DUPq16_UPD_VLD4DUPq32_UPD_VLD4DUPq8_UPD") 9, 0, 0, 195, 4, 641, 7,  0, 0}, // #555
  {DBGFIELD("VLD4LNd16_UPD_VLD4LNd32_UPD_VLD4LNd8_UPD_VLD4LNq16_UPD_VLD4LNq32_UPD") 9, 0, 0, 195, 4, 641, 7,  0, 0}, // #556
  {DBGFIELD("VLD4DUPd16Pseudo_UPD_VLD4DUPd32Pseudo_UPD_VLD4DUPd8Pseudo_UPD") 9, 0, 0, 195, 4, 648, 7,  0, 0}, // #557
  {DBGFIELD("VLD4LNd16Pseudo_UPD_VLD4LNd32Pseudo_UPD_VLD4LNd8Pseudo_UPD_VLD4LNq16Pseudo_UPD_VLD4LNq32Pseudo_UPD") 9, 0, 0, 195, 4, 648, 7,  0, 0}, // #558
  {DBGFIELD("VST1d16_VST1d32_VST1d64_VST1d8") 1, 0, 0,  4, 1,  0, 1,  0, 0}, // #559
  {DBGFIELD("VST1q16_VST1q32_VST1q64_VST1q8") 2, 0, 0, 22, 1,  0, 1,  0, 0}, // #560
  {DBGFIELD("VST1d16wb_fixed_VST1d16wb_register_VST1d32wb_fixed_VST1d32wb_register_VST1d64wb_fixed_VST1d64wb_register_VST1d8wb_fixed_VST1d8wb_register") 2, 0, 0, 32, 2, 48, 2,  0, 0}, // #561
  {DBGFIELD("VST1q16wb_fixed_VST1q16wb_register_VST1q32wb_fixed_VST1q32wb_register_VST1q64wb_fixed_VST1q64wb_register_VST1q8wb_fixed_VST1q8wb_register") 3, 0, 0, 26, 2, 48, 2,  0, 0}, // #562
  {DBGFIELD("VST1d16T_VST1d32T_VST1d64T_VST1d64TPseudo_VST1d8T") 3, 0, 0, 29, 1,  0, 1,  0, 0}, // #563
  {DBGFIELD("VST1d16Twb_fixed_VST1d16Twb_register_VST1d32Twb_fixed_VST1d32Twb_register_VST1d64Twb_fixed_VST1d64Twb_register_VST1d8Twb_fixed_VST1d8Twb_register") 4, 0, 0, 137, 2, 48, 2,  0, 0}, // #564
  {DBGFIELD("VST1d64TPseudoWB_fixed_VST1d64TPseudoWB_register") 4, 0, 0, 137, 2, 48, 2,  0, 0}, // #565
  {DBGFIELD("VST1d16Q_VST1d32Q_VST1d64Q_VST1d64QPseudo_VST1d8Q") 4, 0, 0, 38, 1,  0, 1,  0, 0}, // #566
  {DBGFIELD("VST1d16Qwb_fixed_VST1d16Qwb_register_VST1d32Qwb_fixed_VST1d32Qwb_register_VST1d64Qwb_fixed_VST1d64Qwb_register_VST1d8Qwb_fixed_VST1d8Qwb_register") 5, 0, 0, 199, 2, 48, 2,  0, 0}, // #567
  {DBGFIELD("VST1d64QPseudoWB_fixed_VST1d64QPseudoWB_register") 5, 0, 0, 199, 2, 48, 2,  0, 0}, // #568
  {DBGFIELD("VST2b16_VST2b32_VST2b8_VST2d16_VST2d32_VST2d8") 2, 0, 0, 102, 3, 561, 2,  0, 0}, // #569
  {DBGFIELD("VST2b16wb_fixed_VST2b16wb_register_VST2b32wb_fixed_VST2b32wb_register_VST2b8wb_fixed_VST2b8wb_register_VST2d16wb_fixed_VST2d16wb_register_VST2d32wb_fixed_VST2d32wb_register_VST2d8wb_fixed_VST2d8wb_register") 3, 0, 0, 130, 3, 560, 3,  0, 0}, // #570
  {DBGFIELD("VST2q16_VST2q16Pseudo_VST2q32_VST2q32Pseudo_VST2q8_VST2q8Pseudo") 4, 0, 0, 127, 3, 561, 2,  0, 0}, // #571
  {DBGFIELD("VST2q16PseudoWB_fixed_VST2q16PseudoWB_register_VST2q32PseudoWB_fixed_VST2q32PseudoWB_register_VST2q8PseudoWB_fixed_VST2q8PseudoWB_register") 4, 0, 0, 127, 3, 561, 2,  0, 0}, // #572
  {DBGFIELD("VST2q16wb_fixed_VST2q16wb_register_VST2q32wb_fixed_VST2q32wb_register_VST2q8wb_fixed_VST2q8wb_register") 4, 0, 0, 127, 3, 561, 2,  0, 0}, // #573
  {DBGFIELD("VST3d16_VST3d16Pseudo_VST3d32_VST3d32Pseudo_VST3d8_VST3d8Pseudo_VST3q16_VST3q16oddPseudo_VST3q32_VST3q32oddPseudo_VST3q8_VST3q8oddPseudo") 6, 0, 0, 201, 3, 561, 2,  0, 0}, // #574
  {DBGFIELD("VST3d16Pseudo_UPD_VST3d16_UPD_VST3d32Pseudo_UPD_VST3d32_UPD_VST3d8Pseudo_UPD_VST3d8_UPD_VST3q16Pseudo_UPD_VST3q16_UPD_VST3q16oddPseudo_UPD_VST3q32Pseudo_UPD_VST3q32_UPD_VST3q32oddPseudo_UPD_VST3q8Pseudo_UPD_VST3q8_UPD_VST3q8oddPseudo_UPD") 7, 0, 0, 204, 3, 560, 3,  0, 0}, // #575
  {DBGFIELD("VST4d16_VST4d16Pseudo_VST4d32_VST4d32Pseudo_VST4d8_VST4d8Pseudo_VST4q16_VST4q16oddPseudo_VST4q32_VST4q32oddPseudo_VST4q8_VST4q8oddPseudo") 6, 0, 0, 201, 3, 561, 2,  0, 0}, // #576
  {DBGFIELD("VST4d16Pseudo_UPD_VST4d16_UPD_VST4d32Pseudo_UPD_VST4d32_UPD_VST4d8Pseudo_UPD_VST4d8_UPD_VST4q16Pseudo_UPD_VST4q16_UPD_VST4q16oddPseudo_UPD_VST4q32Pseudo_UPD_VST4q32_UPD_VST4q32oddPseudo_UPD_VST4q8Pseudo_UPD_VST4q8_UPD_VST4q8oddPseudo_UPD") 9, 0, 0, 207, 3, 560, 3,  0, 0}, // #577
  {DBGFIELD("VST1LNd16_VST1LNd32_VST1LNd8_VST1LNq16Pseudo_VST1LNq32Pseudo_VST1LNq8Pseudo") 2, 0, 0, 102, 3, 561, 2,  0, 0}, // #578
  {DBGFIELD("VST1LNd16_UPD_VST1LNd32_UPD_VST1LNd8_UPD_VST1LNq16Pseudo_UPD_VST1LNq32Pseudo_UPD_VST1LNq8Pseudo_UPD") 3, 0, 0, 130, 3, 560, 3,  0, 0}, // #579
  {DBGFIELD("VST2LNd16_VST2LNd16Pseudo_VST2LNd32_VST2LNd32Pseudo_VST2LNd8_VST2LNd8Pseudo_VST2LNq16_VST2LNq16Pseudo_VST2LNq32_VST2LNq32Pseudo") 3, 0, 0, 169, 3, 561, 2,  0, 0}, // #580
  {DBGFIELD("VST2LNd16Pseudo_UPD_VST2LNd16_UPD_VST2LNd32Pseudo_UPD_VST2LNd32_UPD_VST2LNd8Pseudo_UPD_VST2LNd8_UPD_VST2LNq16Pseudo_UPD_VST2LNq16_UPD_VST2LNq32Pseudo_UPD_VST2LNq32_UPD") 4, 0, 0, 172, 3, 560, 3,  0, 0}, // #581
  {DBGFIELD("VST3LNd16_VST3LNd16Pseudo_VST3LNd32_VST3LNd32Pseudo_VST3LNd8_VST3LNd8Pseudo_VST3LNq16_VST3LNq16Pseudo_VST3LNq32_VST3LNq32Pseudo") 6, 0, 0, 201, 3, 561, 2,  0, 0}, // #582
  {DBGFIELD("VST3LNd16Pseudo_UPD_VST3LNd16_UPD_VST3LNd32Pseudo_UPD_VST3LNd32_UPD_VST3LNd8Pseudo_UPD_VST3LNd8_UPD_VST3LNq16Pseudo_UPD_VST3LNq16_UPD_VST3LNq32Pseudo_UPD_VST3LNq32_UPD") 7, 0, 0, 204, 3, 560, 3,  0, 0}, // #583
  {DBGFIELD("VST4LNd16_VST4LNd16Pseudo_VST4LNd32_VST4LNd32Pseudo_VST4LNd8_VST4LNd8Pseudo_VST4LNq16_VST4LNq16Pseudo_VST4LNq32_VST4LNq32Pseudo") 4, 0, 0, 127, 3, 561, 2,  0, 0}, // #584
  {DBGFIELD("VST4LNd16Pseudo_UPD_VST4LNd16_UPD_VST4LNd32Pseudo_UPD_VST4LNd32_UPD_VST4LNd8Pseudo_UPD_VST4LNd8_UPD_VST4LNq16Pseudo_UPD_VST4LNq16_UPD_VST4LNq32Pseudo_UPD_VST4LNq32_UPD") 5, 0, 0, 176, 3, 560, 3,  0, 0}, // #585
  {DBGFIELD("VDIVS")              1, 0, 0, 210, 3, 45, 1,  0, 0}, // #586
  {DBGFIELD("VSQRTS")             1, 0, 0, 210, 3, 45, 1,  0, 0}, // #587
  {DBGFIELD("VDIVD")              1, 0, 0, 213, 3, 44, 1,  0, 0}, // #588
  {DBGFIELD("VSQRTD")             1, 0, 0, 213, 3, 44, 1,  0, 0}, // #589
  {DBGFIELD("ABS")                2, 0, 0, 30, 1,  2, 1,  0, 0}, // #590
  {DBGFIELD("SwiftWriteP01TwoCycle_ReadALU") 1, 0, 0,  6, 1,  2, 1,  0, 1}, // #591
  {DBGFIELD("WriteALU_ReadALU")   1, 0, 0,  6, 1,  1, 1,  0, 1}, // #592
  {DBGFIELD("SwiftWriteP01ThreeCycleTwoUops_anonymous_3761") 2, 0, 0, 30, 1,  3, 1, 64, 1}, // #593
  {DBGFIELD("SwiftWriteP01TwoCycle_NoReadAdvance") 1, 0, 0,  6, 1,  2, 1,  0, 1}, // #594
  {DBGFIELD("SwiftWriteP0ThreeCycleThreeUops_anonymous_3761") 3, 0, 0, 216, 2,  3, 1, 64, 1}, // #595
  {DBGFIELD("SwiftWriteP01OneCycle_ReadALU") 1, 0, 0,  6, 1,  1, 1,  0, 1}, // #596
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_A9WriteAdr_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #597
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #598
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #599
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #600
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #601
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #602
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #603
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #604
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #605
  {DBGFIELD("A9WriteAdr_A9WriteL1_A9WriteL1Hi_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #606
  {DBGFIELD("(A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #607
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #608
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #609
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #610
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #611
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #612
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #613
  {DBGFIELD("(A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #614
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_A9WriteAdr_A9WriteB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #615
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #616
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #617
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #618
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #619
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #620
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #621
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #622
  {DBGFIELD("A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteB") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #623
  {DBGFIELD("SwiftWriteP01ThreeCycleTwoUops") 2, 0, 0, 30, 1,  3, 1,  0, 0}, // #624
  {DBGFIELD("SwiftWriteP01TwoCycle") 1, 0, 0,  6, 1,  2, 1,  0, 0}, // #625
  {DBGFIELD("WriteALU")           1, 0, 0,  6, 1,  1, 1,  0, 0}, // #626
  {DBGFIELD("A9WriteAdr_(A9WriteIssue_A9WriteLfpOp)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #627
  {DBGFIELD("(A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #628
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #629
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #630
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #631
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #632
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #633
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #634
  {DBGFIELD("A9WriteAdr_A9WriteLMfp1_A9WriteL1Hi") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #635
  {DBGFIELD("(A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #636
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #637
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #638
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #639
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #640
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #641
  {DBGFIELD("(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #642
  {DBGFIELD("(A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #643
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp)_A9WriteAdr") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #644
  {DBGFIELD("A9WriteLMfp1_A9WriteL1Hi_A9WriteAdr") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #645
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #646
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #647
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #648
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #649
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #650
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #651
  {DBGFIELD("(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #652
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #653
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #654
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #655
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #656
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #657
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #658
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #659
  {DBGFIELD("A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)") 0, 0, 0,  0, 0,  0, 0,  0, 0}, // #660
  {DBGFIELD("SwiftWriteP01TwoCycle_anonymous_3761") 1, 0, 0,  6, 1,  2, 1, 64, 1}, // #661
  {DBGFIELD("WriteALU_anonymous_3761") 1, 0, 0,  6, 1,  1, 1, 64, 1}, // #662
  {DBGFIELD("WriteALU_NoReadAdvance") 1, 0, 0,  6, 1,  1, 1,  0, 1}, // #663
  {DBGFIELD("SwiftWriteP01OneCycle_ReadALU_ReadALU") 1, 0, 0,  6, 1,  1, 1, 86, 2}, // #664
  {DBGFIELD("SwiftWriteP01TwoCycle_ReadALU_ReadALU") 1, 0, 0,  6, 1,  2, 1, 86, 2}, // #665
  {DBGFIELD("SwiftWriteP01OneCycle") 1, 0, 0,  6, 1,  1, 1,  0, 0}, // #666
  {DBGFIELD("(SwiftWriteP0OneCycle_SwiftWriteP0OneCycle)") 2, 0, 0, 218, 2,  2, 1,  0, 0}, // #667
  {DBGFIELD("SwiftWriteP0OneCycle") 1, 0, 0, 10, 2,  1, 1,  0, 0}, // #668
  {DBGFIELD("SwiftWriteP0P01FiveCycleTwoUops_ReadALU_ReadALU_anonymous_3792") 1, 0, 0, 220, 2, 19, 1, 88, 3}, // #669
  {DBGFIELD("SwiftWriteP0FourCycle_ReadALU_ReadALU_ReadALU") 1, 0, 0, 10, 2, 18, 1, 95, 3}, // #670
  {DBGFIELD("SwiftWriteP0P01FiveCycleTwoUops") 1, 0, 0, 220, 2, 19, 1,  0, 0}, // #671
  {DBGFIELD("SwiftWriteP0FourCycle") 1, 0, 0, 10, 2, 18, 1,  0, 0}, // #672
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLDMAddrNoWB") 3, 0, 0, 26, 2, 655, 3,  0, 0}, // #673
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLDMAddrNoWB") 4, 0, 0, 137, 2, 658, 4,  0, 0}, // #674
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLDMAddrNoWB") 5, 0, 0, 199, 2, 662, 5,  0, 0}, // #675
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLDMAddrNoWB") 6, 0, 0, 222, 2, 667, 6,  0, 0}, // #676
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLDMAddrNoWB") 7, 0, 0, 224, 2, 673, 7,  0, 0}, // #677
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLDMAddrNoWB") 8, 0, 0, 226, 2, 680, 8,  0, 0}, // #678
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLDMAddrNoWB") 9, 0, 0, 228, 2, 688, 9,  0, 0}, // #679
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLDMAddrNoWB") 10, 0, 0, 230, 2, 697, 10,  0, 0}, // #680
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLDMAddrNoWB") 11, 0, 0, 232, 2, 707, 11,  0, 0}, // #681
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLDMAddrNoWB") 12, 0, 0, 234, 2, 718, 12,  0, 0}, // #682
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLDMAddrNoWB") 13, 0, 0, 236, 2, 730, 13,  0, 0}, // #683
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLDMAddrNoWB") 14, 0, 0, 238, 2, 743, 14,  0, 0}, // #684
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLDMAddrNoWB") 15, 0, 0, 240, 2, 757, 15,  0, 0}, // #685
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteLDMAddrNoWB") 16, 0, 0, 242, 2, 772, 16,  0, 0}, // #686
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteLM18Cy_SwiftWriteLDMAddrNoWB") 17, 0, 0, 244, 2, 788, 17,  0, 0}, // #687
  {DBGFIELD("SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5CyNo_SwiftWriteLM6CyNo_SwiftWriteLM7CyNo_SwiftWriteLM8CyNo_SwiftWriteLM9CyNo_SwiftWriteLM10CyNo_SwiftWriteLM11CyNo_SwiftWriteLM12CyNo_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM15CyNo_SwiftWriteLM16CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLDMAddrNoWB") 3, 0, 0, 26, 2, 788, 17,  0, 0}, // #688
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy") 3, 0, 0, 35, 2, 22, 3,  0, 0}, // #689
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy") 4, 0, 0, 29, 2, 805, 4,  0, 0}, // #690
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy") 5, 0, 0, 202, 2, 809, 5,  0, 0}, // #691
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy") 6, 0, 0, 246, 2, 814, 6,  0, 0}, // #692
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy") 7, 0, 0, 248, 2, 820, 7,  0, 0}, // #693
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy") 8, 0, 0, 250, 2, 827, 8,  0, 0}, // #694
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy") 9, 0, 0, 252, 2, 835, 9,  0, 0}, // #695
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy") 10, 0, 0, 254, 2, 844, 10,  0, 0}, // #696
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy") 11, 0, 0, 256, 2, 854, 11,  0, 0}, // #697
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy") 12, 0, 0, 258, 2, 865, 12,  0, 0}, // #698
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy") 13, 0, 0, 260, 2, 877, 13,  0, 0}, // #699
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy") 14, 0, 0, 262, 2, 890, 14,  0, 0}, // #700
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy") 15, 0, 0, 264, 2, 904, 15,  0, 0}, // #701
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy") 16, 0, 0, 266, 2, 919, 16,  0, 0}, // #702
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteLM18Cy") 17, 0, 0, 268, 2, 935, 17,  0, 0}, // #703
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5CyNo_SwiftWriteLM6CyNo_SwiftWriteLM7CyNo_SwiftWriteLM8CyNo_SwiftWriteLM9CyNo_SwiftWriteLM10CyNo_SwiftWriteLM11CyNo_SwiftWriteLM12CyNo_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM15CyNo_SwiftWriteLM16CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo") 3, 0, 0, 35, 2, 935, 17,  0, 0}, // #704
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteP1TwoCycle") 4, 0, 0, 270, 3, 952, 4,  0, 0}, // #705
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteP1TwoCycle") 5, 0, 0, 273, 3, 956, 5,  0, 0}, // #706
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteP1TwoCycle") 6, 0, 0, 276, 3, 961, 6,  0, 0}, // #707
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteP1TwoCycle") 7, 0, 0, 279, 3, 967, 7,  0, 0}, // #708
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteP1TwoCycle") 8, 0, 0, 282, 3, 974, 8,  0, 0}, // #709
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteP1TwoCycle") 9, 0, 0, 285, 3, 982, 9,  0, 0}, // #710
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteP1TwoCycle") 10, 0, 0, 288, 3, 991, 10,  0, 0}, // #711
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteP1TwoCycle") 11, 0, 0, 291, 3, 1001, 11,  0, 0}, // #712
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteP1TwoCycle") 12, 0, 0, 294, 3, 1012, 12,  0, 0}, // #713
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteP1TwoCycle") 13, 0, 0, 297, 3, 1024, 13,  0, 0}, // #714
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteP1TwoCycle") 14, 0, 0, 300, 3, 1037, 14,  0, 0}, // #715
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteP1TwoCycle") 15, 0, 0, 303, 3, 1051, 15,  0, 0}, // #716
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteP1TwoCycle") 16, 0, 0, 306, 3, 1066, 16,  0, 0}, // #717
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteP1TwoCycle") 17, 0, 0, 309, 3, 1082, 17,  0, 0}, // #718
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteLM18Cy_SwiftWriteP1TwoCycle") 18, 0, 0, 312, 3, 1099, 18,  0, 0}, // #719
  {DBGFIELD("SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5CyNo_SwiftWriteLM6CyNo_SwiftWriteLM7CyNo_SwiftWriteLM8CyNo_SwiftWriteLM9CyNo_SwiftWriteLM10CyNo_SwiftWriteLM11CyNo_SwiftWriteLM12CyNo_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM15CyNo_SwiftWriteLM16CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteP1TwoCycle") 4, 0, 0, 270, 3, 1099, 18,  0, 0}, // #720
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 4, 0, 0, 35, 2,  0, 1,  0, 0}, // #721
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 6, 0, 0, 85, 2,  0, 1,  0, 0}, // #722
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 8, 0, 0, 88, 2,  0, 1,  0, 0}, // #723
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 10, 0, 0, 91, 2,  0, 1,  0, 0}, // #724
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 12, 0, 0, 94, 2,  0, 1,  0, 0}, // #725
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 14, 0, 0, 97, 2,  0, 1,  0, 0}, // #726
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 16, 0, 0, 100, 2,  0, 1,  0, 0}, // #727
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 18, 0, 0, 315, 2,  0, 1,  0, 0}, // #728
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 20, 0, 0, 317, 2,  0, 1,  0, 0}, // #729
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 22, 0, 0, 319, 2,  0, 1,  0, 0}, // #730
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 24, 0, 0, 321, 2,  0, 1,  0, 0}, // #731
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 26, 0, 0, 323, 2,  0, 1,  0, 0}, // #732
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 28, 0, 0, 325, 2,  0, 1,  0, 0}, // #733
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 30, 0, 0, 327, 2,  0, 1,  0, 0}, // #734
  {DBGFIELD("(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 32, 0, 0, 329, 2,  0, 1,  0, 0}, // #735
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 5, 0, 0, 177, 2, 48, 2,  0, 0}, // #736
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 7, 0, 0, 185, 2, 48, 2,  0, 0}, // #737
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 9, 0, 0, 208, 2, 48, 2,  0, 0}, // #738
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 11, 0, 0, 331, 2, 48, 2,  0, 0}, // #739
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 13, 0, 0, 333, 2, 48, 2,  0, 0}, // #740
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 15, 0, 0, 335, 2, 48, 2,  0, 0}, // #741
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 17, 0, 0, 337, 2, 48, 2,  0, 0}, // #742
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 19, 0, 0, 339, 2, 48, 2,  0, 0}, // #743
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 21, 0, 0, 341, 2, 48, 2,  0, 0}, // #744
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 23, 0, 0, 343, 2, 48, 2,  0, 0}, // #745
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 25, 0, 0, 345, 2, 48, 2,  0, 0}, // #746
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 27, 0, 0, 347, 2, 48, 2,  0, 0}, // #747
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 29, 0, 0, 349, 2, 48, 2,  0, 0}, // #748
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 31, 0, 0, 351, 2, 48, 2,  0, 0}, // #749
  {DBGFIELD("SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 33, 0, 0, 353, 2, 48, 2,  0, 0}, // #750
  {DBGFIELD("SwiftWriteLM4Cy")    1, 0, 0,  4, 1, 18, 1,  0, 0}, // #751
  {DBGFIELD("SwiftWriteLM4Cy_SwiftWriteLM4CyNo") 1, 0, 0,  4, 1, 52, 2,  0, 0}, // #752
  {DBGFIELD("SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm3") 6, 0, 0, 355, 3, 1117, 5,  0, 0}, // #753
  {DBGFIELD("SwiftWriteLM4Cy_SwiftWriteLM4CyNo_SwiftWriteLM4CyNo_SwiftWriteLM4CyNo") 1, 0, 0,  4, 1, 1122, 4,  0, 0}, // #754
  {DBGFIELD("SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5") 8, 0, 0, 192, 3, 1126, 7,  0, 0}, // #755
  {DBGFIELD("SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5") 9, 0, 0, 358, 3, 1133, 8,  0, 0}, // #756
  {DBGFIELD("SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm7") 11, 0, 0, 361, 3, 1141, 9,  0, 0}, // #757
  {DBGFIELD("SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM13Cy_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm2") 6, 0, 0, 364, 3, 1150, 10,  0, 0}, // #758
  {DBGFIELD("SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 13, 0, 0, 367, 3, 1160, 11,  0, 0}, // #759
  {DBGFIELD("SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5") 10, 0, 0, 370, 3, 1171, 12,  0, 0}, // #760
  {DBGFIELD("SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 13, 0, 0, 367, 3, 1183, 13,  0, 0}, // #761
  {DBGFIELD("SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM11Cy_SwiftWriteLM11Cy_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm3") 8, 0, 0, 150, 3, 1196, 14,  0, 0}, // #762
  {DBGFIELD("SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 13, 0, 0, 367, 3, 1210, 15,  0, 0}, // #763
  {DBGFIELD("SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14Cy_SwiftWriteLM14Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm7") 13, 0, 0, 373, 3, 1225, 14,  0, 0}, // #764
  {DBGFIELD("SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM17Cy_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 15, 0, 0, 376, 3, 1239, 17,  0, 0}, // #765
  {DBGFIELD("SwiftWriteLM7Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM18CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm4") 10, 0, 0, 379, 3, 1256, 18,  0, 0}, // #766
  {DBGFIELD("SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM13Cy_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm2") 6, 0, 0, 364, 3, 1274, 34,  0, 0}, // #767
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM4Cy") 3, 0, 0, 108, 2, 366, 2,  0, 0}, // #768
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM4Cy_SwiftWriteLM4CyNo") 3, 0, 0, 108, 2, 366, 3,  0, 0}, // #769
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm3") 8, 0, 0, 382, 3, 1116, 6,  0, 0}, // #770
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM4Cy_SwiftWriteLM4CyNo_SwiftWriteLM4CyNo_SwiftWriteLM4CyNo") 3, 0, 0, 108, 2, 1308, 5,  0, 0}, // #771
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5") 10, 0, 0, 385, 3, 1313, 8,  0, 0}, // #772
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5") 11, 0, 0, 388, 3, 1321, 9,  0, 0}, // #773
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm7") 13, 0, 0, 391, 3, 1330, 10,  0, 0}, // #774
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM13Cy_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm2") 8, 0, 0, 394, 3, 1340, 11,  0, 0}, // #775
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 15, 0, 0, 397, 3, 1351, 12,  0, 0}, // #776
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5") 12, 0, 0, 400, 3, 1363, 13,  0, 0}, // #777
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 15, 0, 0, 397, 3, 1376, 14,  0, 0}, // #778
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM11Cy_SwiftWriteLM11Cy_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm3") 10, 0, 0, 403, 3, 1390, 15,  0, 0}, // #779
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 15, 0, 0, 397, 3, 1405, 16,  0, 0}, // #780
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14Cy_SwiftWriteLM14Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm7") 15, 0, 0, 406, 3, 1421, 15,  0, 0}, // #781
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM17Cy_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9") 17, 0, 0, 409, 3, 1436, 18,  0, 0}, // #782
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM18CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm4") 12, 0, 0, 412, 3, 1454, 19,  0, 0}, // #783
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM13Cy_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm2") 8, 0, 0, 394, 3, 1473, 35,  0, 0}, // #784
  {DBGFIELD("SwiftWriteStIncAddr") 2, 0, 0, 32, 2,  0, 1,  0, 0}, // #785
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteStIncAddr") 4, 0, 0, 173, 2, 54, 2,  0, 0}, // #786
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 10, 0, 0, 159, 2, 54, 2,  0, 0}, // #787
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 14, 0, 0, 415, 2, 54, 2,  0, 0}, // #788
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 18, 0, 0, 417, 2, 54, 2,  0, 0}, // #789
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 8, 0, 0, 189, 2, 54, 2,  0, 0}, // #790
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 22, 0, 0, 419, 2, 54, 2,  0, 0}, // #791
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 26, 0, 0, 421, 2, 54, 2,  0, 0}, // #792
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 30, 0, 0, 423, 2, 54, 2,  0, 0}, // #793
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 34, 0, 0, 425, 2, 54, 2,  0, 0}, // #794
  {DBGFIELD("(SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)") 12, 0, 0, 413, 2, 54, 2,  0, 0} // #795
}; // SwiftModelSchedClasses

static const llvm::MCSchedModel NoSchedModel = {
  MCSchedModel::DefaultIssueWidth,
  MCSchedModel::DefaultMicroOpBufferSize,
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  MCSchedModel::DefaultLoadLatency,
  MCSchedModel::DefaultHighLatency,
  MCSchedModel::DefaultMispredictPenalty,
  0, // PostRAScheduler
  1, // CompleteModel
  0, // Processor ID
  0, 0, 0, 0, // No instruction-level machine model.
  nullptr}; // No Itinerary

static const llvm::MCSchedModel ARMV6ItinerariesModel = {
  MCSchedModel::DefaultIssueWidth,
  MCSchedModel::DefaultMicroOpBufferSize,
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  MCSchedModel::DefaultLoadLatency,
  MCSchedModel::DefaultHighLatency,
  MCSchedModel::DefaultMispredictPenalty,
  0, // PostRAScheduler
  1, // CompleteModel
  1, // Processor ID
  0, 0, 0, 0, // No instruction-level machine model.
  ARMV6Itineraries};

// {Name, NumUnits, SuperIdx, IsBuffered}
static const llvm::MCProcResourceDesc CortexA9ModelProcResources[] = {
  {DBGFIELD("InvalidUnit")     0, 0, 0},
  {DBGFIELD("A9UnitAGU")       1, 0, 1}, // #1
  {DBGFIELD("A9UnitALU")       2, 0, -1}, // #2
  {DBGFIELD("A9UnitB")         1, 0, -1}, // #3
  {DBGFIELD("A9UnitFP")        1, 0, 0}, // #4
  {DBGFIELD("A9UnitLS")        1, 0, -1}, // #5
  {DBGFIELD("A9UnitMul")       1, 2, -1}  // #6, Super=A9UnitALU
};

static const llvm::MCSchedModel CortexA9Model = {
  2, // IssueWidth
  56, // MicroOpBufferSize
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  2, // LoadLatency
  MCSchedModel::DefaultHighLatency,
  8, // MispredictPenalty
  0, // PostRAScheduler
  0, // CompleteModel
  2, // Processor ID
  CortexA9ModelProcResources,
  CortexA9ModelSchedClasses,
  7,
  796,
  CortexA9Itineraries};

static const llvm::MCSchedModel CortexA8Model = {
  2, // IssueWidth
  MCSchedModel::DefaultMicroOpBufferSize,
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  2, // LoadLatency
  MCSchedModel::DefaultHighLatency,
  13, // MispredictPenalty
  0, // PostRAScheduler
  1, // CompleteModel
  3, // Processor ID
  0, 0, 0, 0, // No instruction-level machine model.
  CortexA8Itineraries};

// {Name, NumUnits, SuperIdx, IsBuffered}
static const llvm::MCProcResourceDesc SwiftModelProcResources[] = {
  {DBGFIELD("InvalidUnit")     0, 0, 0},
  {DBGFIELD("SwiftUnitDiv")    1, 0, -1}, // #1
  {DBGFIELD("SwiftUnitP0")     1, 5, -1}, // #2, Super=SwiftUnitP01
  {DBGFIELD("SwiftUnitP1")     1, 5, -1}, // #3, Super=SwiftUnitP01
  {DBGFIELD("SwiftUnitP2")     1, 0, -1}, // #4
  {DBGFIELD("SwiftUnitP01")    2, 0, -1}  // #5
};

static const llvm::MCSchedModel SwiftModel = {
  3, // IssueWidth
  45, // MicroOpBufferSize
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  3, // LoadLatency
  MCSchedModel::DefaultHighLatency,
  14, // MispredictPenalty
  0, // PostRAScheduler
  1, // CompleteModel
  4, // Processor ID
  SwiftModelProcResources,
  SwiftModelSchedClasses,
  6,
  796,
  SwiftItineraries};

// Sorted (by key) array of itineraries for CPU subtype.
extern const llvm::SubtargetInfoKV ARMProcSchedKV[] = {
  { "arm1020e", (const void *)&NoSchedModel },
  { "arm1020t", (const void *)&NoSchedModel },
  { "arm1022e", (const void *)&NoSchedModel },
  { "arm10e", (const void *)&NoSchedModel },
  { "arm10tdmi", (const void *)&NoSchedModel },
  { "arm1136j-s", (const void *)&ARMV6ItinerariesModel },
  { "arm1136jf-s", (const void *)&ARMV6ItinerariesModel },
  { "arm1156t2-s", (const void *)&ARMV6ItinerariesModel },
  { "arm1156t2f-s", (const void *)&ARMV6ItinerariesModel },
  { "arm1176jz-s", (const void *)&ARMV6ItinerariesModel },
  { "arm1176jzf-s", (const void *)&ARMV6ItinerariesModel },
  { "arm710t", (const void *)&NoSchedModel },
  { "arm720t", (const void *)&NoSchedModel },
  { "arm7tdmi", (const void *)&NoSchedModel },
  { "arm7tdmi-s", (const void *)&NoSchedModel },
  { "arm8", (const void *)&NoSchedModel },
  { "arm810", (const void *)&NoSchedModel },
  { "arm9", (const void *)&NoSchedModel },
  { "arm920", (const void *)&NoSchedModel },
  { "arm920t", (const void *)&NoSchedModel },
  { "arm922t", (const void *)&NoSchedModel },
  { "arm926ej-s", (const void *)&NoSchedModel },
  { "arm940t", (const void *)&NoSchedModel },
  { "arm946e-s", (const void *)&NoSchedModel },
  { "arm966e-s", (const void *)&NoSchedModel },
  { "arm968e-s", (const void *)&NoSchedModel },
  { "arm9e", (const void *)&NoSchedModel },
  { "arm9tdmi", (const void *)&NoSchedModel },
  { "cortex-a12", (const void *)&CortexA9Model },
  { "cortex-a15", (const void *)&CortexA9Model },
  { "cortex-a17", (const void *)&CortexA9Model },
  { "cortex-a5", (const void *)&CortexA8Model },
  { "cortex-a53", (const void *)&NoSchedModel },
  { "cortex-a57", (const void *)&NoSchedModel },
  { "cortex-a7", (const void *)&CortexA8Model },
  { "cortex-a72", (const void *)&NoSchedModel },
  { "cortex-a8", (const void *)&CortexA8Model },
  { "cortex-a9", (const void *)&CortexA9Model },
  { "cortex-m0", (const void *)&ARMV6ItinerariesModel },
  { "cortex-m0plus", (const void *)&ARMV6ItinerariesModel },
  { "cortex-m1", (const void *)&ARMV6ItinerariesModel },
  { "cortex-m3", (const void *)&NoSchedModel },
  { "cortex-m4", (const void *)&NoSchedModel },
  { "cortex-m7", (const void *)&NoSchedModel },
  { "cortex-r4", (const void *)&CortexA8Model },
  { "cortex-r4f", (const void *)&CortexA8Model },
  { "cortex-r5", (const void *)&CortexA8Model },
  { "cortex-r7", (const void *)&CortexA8Model },
  { "cyclone", (const void *)&SwiftModel },
  { "ep9312", (const void *)&NoSchedModel },
  { "generic", (const void *)&NoSchedModel },
  { "iwmmxt", (const void *)&NoSchedModel },
  { "krait", (const void *)&CortexA9Model },
  { "mpcore", (const void *)&ARMV6ItinerariesModel },
  { "mpcorenovfp", (const void *)&ARMV6ItinerariesModel },
  { "sc000", (const void *)&ARMV6ItinerariesModel },
  { "sc300", (const void *)&NoSchedModel },
  { "strongarm", (const void *)&NoSchedModel },
  { "strongarm110", (const void *)&NoSchedModel },
  { "strongarm1100", (const void *)&NoSchedModel },
  { "strongarm1110", (const void *)&NoSchedModel },
  { "swift", (const void *)&SwiftModel },
  { "xscale", (const void *)&NoSchedModel }
};
#undef DBGFIELD
static inline MCSubtargetInfo *createARMMCSubtargetInfoImpl(const Triple &TT, StringRef CPU, StringRef FS) {
  return new MCSubtargetInfo(TT, CPU, FS, ARMFeatureKV, ARMSubTypeKV, 
                      ARMProcSchedKV, ARMWriteProcResTable, ARMWriteLatencyTable, ARMReadAdvanceTable, 
                      ARMStages, ARMOperandCycles, ARMForwardingPaths);
}

} // End llvm namespace 
#endif // GET_SUBTARGETINFO_MC_DESC


#ifdef GET_SUBTARGETINFO_TARGET_DESC
#undef GET_SUBTARGETINFO_TARGET_DESC
#include "llvm/Support/Debug.h"
#include "llvm/Support/raw_ostream.h"
// ParseSubtargetFeatures - Parses features string setting specified
// subtarget options.
void llvm::ARMSubtarget::ParseSubtargetFeatures(StringRef CPU, StringRef FS) {
  DEBUG(dbgs() << "\nFeatures:" << FS);
  DEBUG(dbgs() << "\nCPU:" << CPU << "\n\n");
  InitMCProcessorInfo(CPU, FS);
  const FeatureBitset& Bits = getFeatureBits();
  if (Bits[ARM::FeatureAClass] && ARMProcClass < AClass) ARMProcClass = AClass;
  if (Bits[ARM::FeatureAvoidMOVsShOp]) AvoidMOVsShifterOperand = true;
  if (Bits[ARM::FeatureAvoidPartialCPSR]) AvoidCPSRPartialUpdate = true;
  if (Bits[ARM::FeatureCRC]) HasCRC = true;
  if (Bits[ARM::FeatureCrypto]) HasCrypto = true;
  if (Bits[ARM::FeatureD16]) HasD16 = true;
  if (Bits[ARM::FeatureDB]) HasDataBarrier = true;
  if (Bits[ARM::FeatureDSPThumb2]) Thumb2DSP = true;
  if (Bits[ARM::FeatureFP16]) HasFP16 = true;
  if (Bits[ARM::FeatureFPARMv8]) HasFPARMv8 = true;
  if (Bits[ARM::FeatureHWDiv]) HasHardwareDivide = true;
  if (Bits[ARM::FeatureHWDivARM]) HasHardwareDivideInARM = true;
  if (Bits[ARM::FeatureHasRAS]) HasRAS = true;
  if (Bits[ARM::FeatureHasSlowFPVMLx]) SlowFPVMLx = true;
  if (Bits[ARM::FeatureLongCalls]) GenLongCalls = true;
  if (Bits[ARM::FeatureMClass] && ARMProcClass < MClass) ARMProcClass = MClass;
  if (Bits[ARM::FeatureMP]) HasMPExtension = true;
  if (Bits[ARM::FeatureNEON]) HasNEON = true;
  if (Bits[ARM::FeatureNEONForFP]) UseNEONForSinglePrecisionFP = true;
  if (Bits[ARM::FeatureNaClTrap]) UseNaClTrap = true;
  if (Bits[ARM::FeatureNoARM]) NoARM = true;
  if (Bits[ARM::FeaturePerfMon]) HasPerfMon = true;
  if (Bits[ARM::FeaturePref32BitThumb]) Pref32BitThumb = true;
  if (Bits[ARM::FeatureRClass] && ARMProcClass < RClass) ARMProcClass = RClass;
  if (Bits[ARM::FeatureSlowFPBrcc]) SlowFPBrcc = true;
  if (Bits[ARM::FeatureT2XtPk]) HasT2ExtractPack = true;
  if (Bits[ARM::FeatureThumb2]) HasThumb2 = true;
  if (Bits[ARM::FeatureTrustZone]) HasTrustZone = true;
  if (Bits[ARM::FeatureVFP2]) HasVFPv2 = true;
  if (Bits[ARM::FeatureVFP3]) HasVFPv3 = true;
  if (Bits[ARM::FeatureVFP4]) HasVFPv4 = true;
  if (Bits[ARM::FeatureVFPOnlySP]) FPOnlySP = true;
  if (Bits[ARM::FeatureVMLxForwarding]) HasVMLxForwarding = true;
  if (Bits[ARM::FeatureVirtualization]) HasVirtualization = true;
  if (Bits[ARM::FeatureZCZeroing]) HasZeroCycleZeroing = true;
  if (Bits[ARM::HasV4TOps]) HasV4TOps = true;
  if (Bits[ARM::HasV5TEOps]) HasV5TEOps = true;
  if (Bits[ARM::HasV5TOps]) HasV5TOps = true;
  if (Bits[ARM::HasV6KOps]) HasV6KOps = true;
  if (Bits[ARM::HasV6MOps]) HasV6MOps = true;
  if (Bits[ARM::HasV6Ops]) HasV6Ops = true;
  if (Bits[ARM::HasV6T2Ops]) HasV6T2Ops = true;
  if (Bits[ARM::HasV7Ops]) HasV7Ops = true;
  if (Bits[ARM::HasV8Ops]) HasV8Ops = true;
  if (Bits[ARM::HasV8_1aOps]) HasV8_1aOps = true;
  if (Bits[ARM::ModeSoftFloat]) UseSoftFloat = true;
  if (Bits[ARM::ModeThumb]) InThumbMode = true;
  if (Bits[ARM::ProcA5] && ARMProcFamily < CortexA5) ARMProcFamily = CortexA5;
  if (Bits[ARM::ProcA7] && ARMProcFamily < CortexA7) ARMProcFamily = CortexA7;
  if (Bits[ARM::ProcA8] && ARMProcFamily < CortexA8) ARMProcFamily = CortexA8;
  if (Bits[ARM::ProcA9] && ARMProcFamily < CortexA9) ARMProcFamily = CortexA9;
  if (Bits[ARM::ProcA12] && ARMProcFamily < CortexA12) ARMProcFamily = CortexA12;
  if (Bits[ARM::ProcA15] && ARMProcFamily < CortexA15) ARMProcFamily = CortexA15;
  if (Bits[ARM::ProcA17] && ARMProcFamily < CortexA17) ARMProcFamily = CortexA17;
  if (Bits[ARM::ProcA53] && ARMProcFamily < CortexA53) ARMProcFamily = CortexA53;
  if (Bits[ARM::ProcA57] && ARMProcFamily < CortexA57) ARMProcFamily = CortexA57;
  if (Bits[ARM::ProcKrait] && ARMProcFamily < Krait) ARMProcFamily = Krait;
  if (Bits[ARM::ProcR4] && ARMProcFamily < CortexR4) ARMProcFamily = CortexR4;
  if (Bits[ARM::ProcR5] && ARMProcFamily < CortexR5) ARMProcFamily = CortexR5;
  if (Bits[ARM::ProcSwift] && ARMProcFamily < Swift) ARMProcFamily = Swift;
}
#endif // GET_SUBTARGETINFO_TARGET_DESC


#ifdef GET_SUBTARGETINFO_HEADER
#undef GET_SUBTARGETINFO_HEADER
namespace llvm {
class DFAPacketizer;
struct ARMGenSubtargetInfo : public TargetSubtargetInfo {
  explicit ARMGenSubtargetInfo(const Triple &TT, StringRef CPU, StringRef FS);
public:
  unsigned resolveSchedClass(unsigned SchedClass,  const MachineInstr *DefMI, const TargetSchedModel *SchedModel) const override;
  DFAPacketizer *createDFAPacketizer(const InstrItineraryData *IID) const;
};
} // End llvm namespace 
#endif // GET_SUBTARGETINFO_HEADER


#ifdef GET_SUBTARGETINFO_CTOR
#undef GET_SUBTARGETINFO_CTOR
#include "llvm/CodeGen/TargetSchedule.h"
namespace llvm {
extern const llvm::SubtargetFeatureKV ARMFeatureKV[];
extern const llvm::SubtargetFeatureKV ARMSubTypeKV[];
extern const llvm::SubtargetInfoKV ARMProcSchedKV[];
extern const llvm::MCWriteProcResEntry ARMWriteProcResTable[];
extern const llvm::MCWriteLatencyEntry ARMWriteLatencyTable[];
extern const llvm::MCReadAdvanceEntry ARMReadAdvanceTable[];
extern const llvm::InstrStage ARMStages[];
extern const unsigned ARMOperandCycles[];
extern const unsigned ARMForwardingPaths[];
ARMGenSubtargetInfo::ARMGenSubtargetInfo(const Triple &TT, StringRef CPU, StringRef FS)
  : TargetSubtargetInfo(TT, CPU, FS, makeArrayRef(ARMFeatureKV, 60), makeArrayRef(ARMSubTypeKV, 63), 
                        ARMProcSchedKV, ARMWriteProcResTable, ARMWriteLatencyTable, ARMReadAdvanceTable, 
                        ARMStages, ARMOperandCycles, ARMForwardingPaths) {}

unsigned ARMGenSubtargetInfo
::resolveSchedClass(unsigned SchedClass, const MachineInstr *MI, const TargetSchedModel *SchedModel) const {

  const ARMBaseInstrInfo *TII =
    static_cast<const ARMBaseInstrInfo*>(SchedModel->getInstrInfo());
  (void)TII;

  switch (SchedClass) {
  case 3: // IIC_iALUsr_WriteALUsi_ReadALU
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isSwiftFastImmShift(MI)))
        return 591; // SwiftWriteP01TwoCycle_ReadALU
      if ((true))
        return 592; // WriteALU_ReadALU
    }
    break;
  case 4: // IIC_iALUsr_WriteALUsr_ReadALUsr
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 593; // SwiftWriteP01ThreeCycleTwoUops_anonymous_3761
      if ((true))
        return 594; // SwiftWriteP01TwoCycle_NoReadAdvance
    }
    break;
  case 5: // IIC_iALUsr_WriteALUSsr_ReadALUsr
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 595; // SwiftWriteP0ThreeCycleThreeUops_anonymous_3761
      if ((true))
        return 594; // SwiftWriteP01TwoCycle_NoReadAdvance
    }
    break;
  case 8: // IIC_iBITsr_WriteALUsi_ReadALU
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isSwiftFastImmShift(MI)))
        return 591; // SwiftWriteP01TwoCycle_ReadALU
      if ((true))
        return 592; // WriteALU_ReadALU
    }
    break;
  case 9: // IIC_iBITsr_WriteALUsr_ReadALUsr
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 593; // SwiftWriteP01ThreeCycleTwoUops_anonymous_3761
      if ((true))
        return 594; // SwiftWriteP01TwoCycle_NoReadAdvance
    }
    break;
  case 19: // IIC_iCMPsr_WriteCMPsi_ReadALU
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isSwiftFastImmShift(MI)))
        return 596; // SwiftWriteP01OneCycle_ReadALU
      if ((true))
        return 591; // SwiftWriteP01TwoCycle_ReadALU
    }
    break;
  case 24: // IIC_iLoad_m
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 597; // A9WriteL1_A9WriteL1Hi_A9WriteAdr_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 598; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 599; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 600; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 601; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 602; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 603; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 604; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 605; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteIssue
    }
    break;
  case 25: // IIC_iLoad_mu
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 606; // A9WriteAdr_A9WriteL1_A9WriteL1Hi_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 607; // (A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 608; // (A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 609; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 610; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 611; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 612; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 613; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 614; // (A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
    }
    break;
  case 26: // IIC_iLoad_mBr
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 615; // A9WriteL1_A9WriteL1Hi_A9WriteAdr_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 616; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 617; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 618; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 619; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 620; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 621; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 622; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 623; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteB
    }
    break;
  case 58: // IIC_iALUsi_WriteALUsi_ReadALU
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isSwiftFastImmShift(MI)))
        return 591; // SwiftWriteP01TwoCycle_ReadALU
      if ((true))
        return 592; // WriteALU_ReadALU
    }
    break;
  case 59: // IIC_iBITsi_WriteALUsi_ReadALU
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isSwiftFastImmShift(MI)))
        return 591; // SwiftWriteP01TwoCycle_ReadALU
      if ((true))
        return 592; // WriteALU_ReadALU
    }
    break;
  case 66: // IIC_iStore_m
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 606; // A9WriteAdr_A9WriteL1_A9WriteL1Hi_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 607; // (A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 608; // (A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 609; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 610; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 611; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 612; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 613; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 614; // (A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
    }
    break;
  case 67: // IIC_iStore_mu
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 606; // A9WriteAdr_A9WriteL1_A9WriteL1Hi_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 607; // (A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 608; // (A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 609; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 610; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 611; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 612; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 613; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 614; // (A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
    }
    break;
  case 77: // IIC_iEXTAr_WriteALUsr
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 624; // SwiftWriteP01ThreeCycleTwoUops
      if ((true))
        return 625; // SwiftWriteP01TwoCycle
    }
    break;
  case 78: // IIC_iEXTr_WriteALUsi
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isSwiftFastImmShift(MI)))
        return 625; // SwiftWriteP01TwoCycle
      if ((true))
        return 626; // WriteALU
    }
    break;
  case 81: // IIC_iTSTsr_WriteCMPsi_ReadALU
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isSwiftFastImmShift(MI)))
        return 596; // SwiftWriteP01OneCycle_ReadALU
      if ((true))
        return 591; // SwiftWriteP01TwoCycle_ReadALU
    }
    break;
  case 153: // IIC_fpLoad_mu
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 627; // A9WriteAdr_(A9WriteIssue_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 628; // (A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 629; // (A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 630; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 631; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 632; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 633; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 634; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)
      if ((TII->getNumLDMAddresses(MI) == 0)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && (TII->getNumLDMAddresses(MI) == 0))
        return 628; // (A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 635; // A9WriteAdr_A9WriteLMfp1_A9WriteL1Hi
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 636; // (A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 637; // (A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 638; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 639; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 640; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 641; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 642; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)
      if ((TII->getNumLDMAddresses(MI) == 0)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && (TII->getNumLDMAddresses(MI) == 0))
        return 643; // (A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)
    }
    break;
  case 154: // IIC_fpLoad_m
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 644; // (A9WriteIssue_A9WriteLfpOp)_A9WriteAdr
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 645; // A9WriteLMfp1_A9WriteL1Hi_A9WriteAdr
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 646; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 647; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 648; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 649; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 650; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 651; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 652; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && (TII->getNumLDMAddresses(MI) == 0))
        return 646; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 653; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 654; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 655; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 656; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 657; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 658; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 659; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && (TII->getNumLDMAddresses(MI) == 0))
        return 660; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)
    }
    break;
  case 238: // IIC_iALUsi_WriteALUsi_ReadALUsr
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isSwiftFastImmShift(MI))
          && (TII->isPredicated(MI)))
        return 661; // SwiftWriteP01TwoCycle_anonymous_3761
      if ((true)
          && (TII->isPredicated(MI)))
        return 662; // WriteALU_anonymous_3761
      if ((true))
        return 663; // WriteALU_NoReadAdvance
    }
    break;
  case 240: // IIC_iCMPsi_WriteCMPsi_ReadALU_ReadALU
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isSwiftFastImmShift(MI)))
        return 664; // SwiftWriteP01OneCycle_ReadALU_ReadALU
      if ((true))
        return 665; // SwiftWriteP01TwoCycle_ReadALU_ReadALU
    }
    break;
  case 243: // IIC_iCMPsi_WriteCMPsi
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isSwiftFastImmShift(MI)))
        return 666; // SwiftWriteP01OneCycle
      if ((true))
        return 625; // SwiftWriteP01TwoCycle
    }
    break;
  case 250: // IIC_iALUsir_WriteALUsi_ReadALU
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isSwiftFastImmShift(MI)))
        return 591; // SwiftWriteP01TwoCycle_ReadALU
      if ((true))
        return 592; // WriteALU_ReadALU
    }
    break;
  case 257: // IIC_iTSTsi_WriteCMPsi
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isSwiftFastImmShift(MI)))
        return 666; // SwiftWriteP01OneCycle
      if ((true))
        return 625; // SwiftWriteP01TwoCycle
    }
    break;
  case 261: // IIC_iPop
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 597; // A9WriteL1_A9WriteL1Hi_A9WriteAdr_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 598; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 599; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 600; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 601; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 602; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 603; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 604; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 605; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteIssue
    }
    break;
  case 262: // IIC_iPop_Br_WriteBrL
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 615; // A9WriteL1_A9WriteL1Hi_A9WriteAdr_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 616; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 617; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 618; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 619; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 620; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 621; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 622; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 623; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteB
    }
    break;
  case 266: // ANDrsi_BICrsi_EORrsi_ORRrsi
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isSwiftFastImmShift(MI)))
        return 591; // SwiftWriteP01TwoCycle_ReadALU
      if ((true))
        return 592; // WriteALU_ReadALU
    }
    break;
  case 267: // ANDrsr_BICrsr_EORrsr_ORRrsr
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 593; // SwiftWriteP01ThreeCycleTwoUops_anonymous_3761
      if ((true))
        return 594; // SwiftWriteP01TwoCycle_NoReadAdvance
    }
    break;
  case 277: // SEL
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 667; // (SwiftWriteP0OneCycle_SwiftWriteP0OneCycle)
      if ((true))
        return 668; // SwiftWriteP0OneCycle
    }
    break;
  case 279: // MLA_MLAv5_MLS_SMMLA_SMMLAR_SMMLS_SMMLSR
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 669; // SwiftWriteP0P01FiveCycleTwoUops_ReadALU_ReadALU_anonymous_3792
      if ((true))
        return 670; // SwiftWriteP0FourCycle_ReadALU_ReadALU_ReadALU
    }
    break;
  case 285: // SMLABB_SMLABT_SMLATB_SMLATT_SMLAWB_SMLAWT
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 669; // SwiftWriteP0P01FiveCycleTwoUops_ReadALU_ReadALU_anonymous_3792
      if ((true))
        return 670; // SwiftWriteP0FourCycle_ReadALU_ReadALU_ReadALU
    }
    break;
  case 290: // SXTB_SXTB16_SXTH_UXTB_UXTB16_UXTH
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isSwiftFastImmShift(MI)))
        return 625; // SwiftWriteP01TwoCycle
      if ((true))
        return 626; // WriteALU
    }
    break;
  case 296: // t2SEL
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 667; // (SwiftWriteP0OneCycle_SwiftWriteP0OneCycle)
      if ((true))
        return 668; // SwiftWriteP0OneCycle
    }
    break;
  case 301: // SADD16_SADD8_SASX_SSAX_SSUB16_SSUB8_UADD16_UADD8_UASX_USAX_USUB16_USUB8
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 624; // SwiftWriteP01ThreeCycleTwoUops
      if ((true))
        return 625; // SwiftWriteP01TwoCycle
    }
    break;
  case 302: // t2SADD16_t2SADD8_t2SASX_t2SSAX_t2SSUB16_t2SSUB8_t2UADD16_t2UADD8_t2UASX_t2USAX_t2USUB16_t2USUB8
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 624; // SwiftWriteP01ThreeCycleTwoUops
      if ((true))
        return 625; // SwiftWriteP01TwoCycle
    }
    break;
  case 304: // SXTAB_SXTAB16_SXTAH_UXTAB_UXTAB16_UXTAH
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 624; // SwiftWriteP01ThreeCycleTwoUops
      if ((true))
        return 625; // SwiftWriteP01TwoCycle
    }
    break;
  case 313: // t2MLA_t2MLS_t2SMMLA_t2SMMLAR_t2SMMLS_t2SMMLSR
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 669; // SwiftWriteP0P01FiveCycleTwoUops_ReadALU_ReadALU_anonymous_3792
      if ((true))
        return 670; // SwiftWriteP0FourCycle_ReadALU_ReadALU_ReadALU
    }
    break;
  case 316: // SMLSD_SMLSDX
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 669; // SwiftWriteP0P01FiveCycleTwoUops_ReadALU_ReadALU_anonymous_3792
      if ((true))
        return 670; // SwiftWriteP0FourCycle_ReadALU_ReadALU_ReadALU
    }
    break;
  case 317: // t2SMLABB_t2SMLABT_t2SMLATB_t2SMLATT_t2SMLAWB_t2SMLAWT
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 669; // SwiftWriteP0P01FiveCycleTwoUops_ReadALU_ReadALU_anonymous_3792
      if ((true))
        return 670; // SwiftWriteP0FourCycle_ReadALU_ReadALU_ReadALU
    }
    break;
  case 318: // t2SMLSD_t2SMLSDX
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 669; // SwiftWriteP0P01FiveCycleTwoUops_ReadALU_ReadALU_anonymous_3792
      if ((true))
        return 670; // SwiftWriteP0FourCycle_ReadALU_ReadALU_ReadALU
    }
    break;
  case 319: // SMLAD_SMLADX
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 671; // SwiftWriteP0P01FiveCycleTwoUops
      if ((true))
        return 672; // SwiftWriteP0FourCycle
    }
    break;
  case 320: // t2SMLAD_t2SMLADX
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->isPredicated(MI)))
        return 671; // SwiftWriteP0P01FiveCycleTwoUops
      if ((true))
        return 672; // SwiftWriteP0FourCycle
    }
    break;
  case 353: // LDMDA_LDMDB_LDMIA_LDMIB_sysLDMDA_sysLDMDB_sysLDMIA_sysLDMIB_t2LDMDB_t2LDMIA_tLDMIA
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 597; // A9WriteL1_A9WriteL1Hi_A9WriteAdr_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 598; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 599; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 600; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 601; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 602; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 603; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 604; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 605; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteIssue
    }
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->getNumLDMAddresses(MI) == 2))
        return 673; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLDMAddrNoWB
      if ((TII->getNumLDMAddresses(MI) == 3))
        return 674; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLDMAddrNoWB
      if ((TII->getNumLDMAddresses(MI) == 4))
        return 675; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLDMAddrNoWB
      if ((TII->getNumLDMAddresses(MI) == 5))
        return 676; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLDMAddrNoWB
      if ((TII->getNumLDMAddresses(MI) == 6))
        return 677; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLDMAddrNoWB
      if ((TII->getNumLDMAddresses(MI) == 7))
        return 678; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLDMAddrNoWB
      if ((TII->getNumLDMAddresses(MI) == 8))
        return 679; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLDMAddrNoWB
      if ((TII->getNumLDMAddresses(MI) == 9))
        return 680; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLDMAddrNoWB
      if ((TII->getNumLDMAddresses(MI) == 10))
        return 681; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLDMAddrNoWB
      if ((TII->getNumLDMAddresses(MI) == 11))
        return 682; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLDMAddrNoWB
      if ((TII->getNumLDMAddresses(MI) == 12))
        return 683; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLDMAddrNoWB
      if ((TII->getNumLDMAddresses(MI) == 13))
        return 684; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLDMAddrNoWB
      if ((TII->getNumLDMAddresses(MI) == 14))
        return 685; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLDMAddrNoWB
      if ((TII->getNumLDMAddresses(MI) == 15))
        return 686; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteLDMAddrNoWB
      if ((TII->getNumLDMAddresses(MI) == 16))
        return 687; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteLM18Cy_SwiftWriteLDMAddrNoWB
      if ((true))
        return 688; // SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5CyNo_SwiftWriteLM6CyNo_SwiftWriteLM7CyNo_SwiftWriteLM8CyNo_SwiftWriteLM9CyNo_SwiftWriteLM10CyNo_SwiftWriteLM11CyNo_SwiftWriteLM12CyNo_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM15CyNo_SwiftWriteLM16CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLDMAddrNoWB
    }
    break;
  case 354: // LDMDA_UPD_LDMDB_UPD_LDMIA_UPD_LDMIB_UPD_sysLDMDA_UPD_sysLDMDB_UPD_sysLDMIA_UPD_sysLDMIB_UPD_t2LDMDB_UPD_t2LDMIA_UPD_tLDMIA_UPD
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 606; // A9WriteAdr_A9WriteL1_A9WriteL1Hi_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 607; // (A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 608; // (A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 609; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 610; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 611; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 612; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 613; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 614; // (A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
    }
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->getNumLDMAddresses(MI) == 2))
        return 689; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy
      if ((TII->getNumLDMAddresses(MI) == 3))
        return 690; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy
      if ((TII->getNumLDMAddresses(MI) == 4))
        return 691; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy
      if ((TII->getNumLDMAddresses(MI) == 5))
        return 692; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy
      if ((TII->getNumLDMAddresses(MI) == 6))
        return 693; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy
      if ((TII->getNumLDMAddresses(MI) == 7))
        return 694; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy
      if ((TII->getNumLDMAddresses(MI) == 8))
        return 695; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy
      if ((TII->getNumLDMAddresses(MI) == 9))
        return 696; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy
      if ((TII->getNumLDMAddresses(MI) == 10))
        return 697; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy
      if ((TII->getNumLDMAddresses(MI) == 11))
        return 698; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy
      if ((TII->getNumLDMAddresses(MI) == 12))
        return 699; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy
      if ((TII->getNumLDMAddresses(MI) == 13))
        return 700; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy
      if ((TII->getNumLDMAddresses(MI) == 14))
        return 701; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy
      if ((TII->getNumLDMAddresses(MI) == 15))
        return 702; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy
      if ((TII->getNumLDMAddresses(MI) == 16))
        return 703; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteLM18Cy
      if ((true))
        return 704; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5CyNo_SwiftWriteLM6CyNo_SwiftWriteLM7CyNo_SwiftWriteLM8CyNo_SwiftWriteLM9CyNo_SwiftWriteLM10CyNo_SwiftWriteLM11CyNo_SwiftWriteLM12CyNo_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM15CyNo_SwiftWriteLM16CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo
    }
    break;
  case 355: // LDMIA_RET_t2LDMIA_RET
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 615; // A9WriteL1_A9WriteL1Hi_A9WriteAdr_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 616; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 617; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 618; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 619; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 620; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 621; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 622; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 623; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteB
    }
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->getNumLDMAddresses(MI) == 2))
        return 705; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 3))
        return 706; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 4))
        return 707; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 5))
        return 708; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 6))
        return 709; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 7))
        return 710; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 8))
        return 711; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 9))
        return 712; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 10))
        return 713; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 11))
        return 714; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 12))
        return 715; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 13))
        return 716; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 14))
        return 717; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 15))
        return 718; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 16))
        return 719; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteLM18Cy_SwiftWriteP1TwoCycle
      if ((true))
        return 720; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5CyNo_SwiftWriteLM6CyNo_SwiftWriteLM7CyNo_SwiftWriteLM8CyNo_SwiftWriteLM9CyNo_SwiftWriteLM10CyNo_SwiftWriteLM11CyNo_SwiftWriteLM12CyNo_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM15CyNo_SwiftWriteLM16CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteP1TwoCycle
    }
    break;
  case 356: // tPOP
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 597; // A9WriteL1_A9WriteL1Hi_A9WriteAdr_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 598; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 599; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 600; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 601; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 602; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 603; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 604; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteIssue
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 605; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteIssue
    }
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->getNumLDMAddresses(MI) == 2))
        return 705; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 3))
        return 706; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 4))
        return 707; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 5))
        return 708; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 6))
        return 709; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 7))
        return 710; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 8))
        return 711; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 9))
        return 712; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 10))
        return 713; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 11))
        return 714; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 12))
        return 715; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 13))
        return 716; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 14))
        return 717; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 15))
        return 718; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 16))
        return 719; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteLM18Cy_SwiftWriteP1TwoCycle
      if ((true))
        return 720; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5CyNo_SwiftWriteLM6CyNo_SwiftWriteLM7CyNo_SwiftWriteLM8CyNo_SwiftWriteLM9CyNo_SwiftWriteLM10CyNo_SwiftWriteLM11CyNo_SwiftWriteLM12CyNo_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM15CyNo_SwiftWriteLM16CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteP1TwoCycle
    }
    break;
  case 357: // tPOP_RET
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 615; // A9WriteL1_A9WriteL1Hi_A9WriteAdr_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 616; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 617; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 618; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 619; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 620; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 621; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 622; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteB
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 623; // A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)_A9WriteB
    }
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->getNumLDMAddresses(MI) == 2))
        return 705; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 3))
        return 706; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 4))
        return 707; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 5))
        return 708; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 6))
        return 709; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 7))
        return 710; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 8))
        return 711; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 9))
        return 712; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 10))
        return 713; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 11))
        return 714; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 12))
        return 715; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 13))
        return 716; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 14))
        return 717; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 15))
        return 718; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteP1TwoCycle
      if ((TII->getNumLDMAddresses(MI) == 16))
        return 719; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5Cy_SwiftWriteLM6Cy_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM12Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM16Cy_SwiftWriteLM17Cy_SwiftWriteLM18Cy_SwiftWriteP1TwoCycle
      if ((true))
        return 720; // SwiftWriteLDMAddrWB_SwiftWriteLM3Cy_SwiftWriteLM4Cy_SwiftWriteLM5CyNo_SwiftWriteLM6CyNo_SwiftWriteLM7CyNo_SwiftWriteLM8CyNo_SwiftWriteLM9CyNo_SwiftWriteLM10CyNo_SwiftWriteLM11CyNo_SwiftWriteLM12CyNo_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM15CyNo_SwiftWriteLM16CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteP1TwoCycle
    }
    break;
  case 374: // STMDA_STMDB_STMIA_STMIB_sysSTMDA_sysSTMDB_sysSTMIA_sysSTMIB_t2STMDB_t2STMIA
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 606; // A9WriteAdr_A9WriteL1_A9WriteL1Hi_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 607; // (A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 608; // (A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 609; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 610; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 611; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 612; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 613; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 614; // (A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
    }
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->getNumLDMAddresses(MI) == 2))
        return 721; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 3))
        return 722; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 4))
        return 723; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 5))
        return 724; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 6))
        return 725; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 7))
        return 726; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 8))
        return 727; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 9))
        return 728; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 10))
        return 729; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 11))
        return 730; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 12))
        return 731; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 13))
        return 732; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 14))
        return 733; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 15))
        return 734; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 16))
        return 735; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((true))
        return 721; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr)
    }
    break;
  case 375: // STMDA_UPD_STMDB_UPD_STMIA_UPD_STMIB_UPD_sysSTMDA_UPD_sysSTMDB_UPD_sysSTMIA_UPD_sysSTMIB_UPD_t2STMDB_UPD_t2STMIA_UPD_tSTMIA_UPD
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 606; // A9WriteAdr_A9WriteL1_A9WriteL1Hi_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 607; // (A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 608; // (A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 609; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 610; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 611; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 612; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 613; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 614; // (A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
    }
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->getNumLDMAddresses(MI) == 2))
        return 736; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 3))
        return 737; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 4))
        return 738; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 5))
        return 739; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 6))
        return 740; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 7))
        return 741; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 8))
        return 742; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 9))
        return 743; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 10))
        return 744; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 11))
        return 745; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 12))
        return 746; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 13))
        return 747; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 14))
        return 748; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 15))
        return 749; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 16))
        return 750; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((true))
        return 736; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr)
    }
    break;
  case 376: // tPUSH
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 606; // A9WriteAdr_A9WriteL1_A9WriteL1Hi_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 607; // (A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 608; // (A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 609; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 610; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 611; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 612; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 613; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
      if ((TII->getNumLDMAddresses(MI) == 0))
        return 614; // (A9WriteAdr_A9WriteAdr)_A9WriteL1_A9WriteL1Hi_(A9WriteLMLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_A9WriteIssue
    }
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->getNumLDMAddresses(MI) == 2))
        return 736; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 3))
        return 737; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 4))
        return 738; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 5))
        return 739; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 6))
        return 740; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 7))
        return 741; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 8))
        return 742; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 9))
        return 743; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 10))
        return 744; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 11))
        return 745; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 12))
        return 746; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 13))
        return 747; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 14))
        return 748; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 15))
        return 749; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 16))
        return 750; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((true))
        return 736; // SwiftWriteP01OneCycle_(SwiftWriteStIncAddr_SwiftWriteStIncAddr)
    }
    break;
  case 512: // VLDMQIA
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 644; // (A9WriteIssue_A9WriteLfpOp)_A9WriteAdr
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 645; // A9WriteLMfp1_A9WriteL1Hi_A9WriteAdr
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 646; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 647; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 648; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 649; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 650; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 651; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 652; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && (TII->getNumLDMAddresses(MI) == 0))
        return 646; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 653; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 654; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 655; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 656; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 657; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 658; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 659; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && (TII->getNumLDMAddresses(MI) == 0))
        return 660; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)
    }
    break;
  case 514: // VLDMDIA_VLDMSIA
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 644; // (A9WriteIssue_A9WriteLfpOp)_A9WriteAdr
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 645; // A9WriteLMfp1_A9WriteL1Hi_A9WriteAdr
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 646; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 647; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 648; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 649; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 650; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 651; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 652; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && (TII->getNumLDMAddresses(MI) == 0))
        return 646; // (A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp)_(A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 653; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 654; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 655; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 656; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 657; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 658; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 659; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)
      if ((TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && (TII->getNumLDMAddresses(MI) == 0))
        return 660; // A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteAdr_A9WriteAdr)
    }
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->getNumLDMAddresses(MI) == 1))
        return 751; // SwiftWriteLM4Cy
      if ((TII->getNumLDMAddresses(MI) == 2))
        return 752; // SwiftWriteLM4Cy_SwiftWriteLM4CyNo
      if ((TII->getNumLDMAddresses(MI) == 3))
        return 753; // SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm3
      if ((TII->getNumLDMAddresses(MI) == 4))
        return 754; // SwiftWriteLM4Cy_SwiftWriteLM4CyNo_SwiftWriteLM4CyNo_SwiftWriteLM4CyNo
      if ((TII->getNumLDMAddresses(MI) == 5))
        return 755; // SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5
      if ((TII->getNumLDMAddresses(MI) == 6))
        return 756; // SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5
      if ((TII->getNumLDMAddresses(MI) == 7))
        return 757; // SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm7
      if ((TII->getNumLDMAddresses(MI) == 8))
        return 758; // SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM13Cy_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm2
      if ((TII->getNumLDMAddresses(MI) == 9))
        return 759; // SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9
      if ((TII->getNumLDMAddresses(MI) == 10))
        return 760; // SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5
      if ((TII->getNumLDMAddresses(MI) == 11))
        return 761; // SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9
      if ((TII->getNumLDMAddresses(MI) == 12))
        return 762; // SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM11Cy_SwiftWriteLM11Cy_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm3
      if ((TII->getNumLDMAddresses(MI) == 13))
        return 763; // SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9
      if ((TII->getNumLDMAddresses(MI) == 14))
        return 764; // SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14Cy_SwiftWriteLM14Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm7
      if ((TII->getNumLDMAddresses(MI) == 15))
        return 765; // SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM17Cy_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9
      if ((TII->getNumLDMAddresses(MI) == 16))
        return 766; // SwiftWriteLM7Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM18CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm4
      if ((true))
        return 767; // SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM13Cy_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm2
    }
    break;
  case 515: // VLDMDDB_UPD_VLDMDIA_UPD_VLDMSDB_UPD_VLDMSIA_UPD
    if (SchedModel->getProcessorID() == 2) { // CortexA9Model
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 627; // A9WriteAdr_(A9WriteIssue_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 628; // (A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 629; // (A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 630; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 631; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 632; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 633; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 634; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp_A9WriteLfpOp)
      if ((TII->getNumLDMAddresses(MI) == 0)
          && (TargetRegisterInfo::isVirtualRegister(MI->getOperand(0).getReg()))
          && (TII->getNumLDMAddresses(MI) == 0))
        return 628; // (A9WriteAdr_A9WriteAdr)_(A9WriteIssue_A9WriteLfpOp_A9WriteLfpOp)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 1)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 1))
        return 635; // A9WriteAdr_A9WriteLMfp1_A9WriteL1Hi
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 2)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 2))
        return 636; // (A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 3)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 3))
        return 637; // (A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 4)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 4))
        return 638; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 5)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 5))
        return 639; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 6)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 6))
        return 640; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 7)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 7))
        return 641; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)
      if (((TII->getNumLDMAddresses(MI)+1)/2 == 8)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && ((TII->getNumLDMAddresses(MI)+1)/2 == 8))
        return 642; // (A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)
      if ((TII->getNumLDMAddresses(MI) == 0)
          && (TargetRegisterInfo::isPhysicalRegister(MI->getOperand(0).getReg()))
          && (TII->getNumLDMAddresses(MI) == 0))
        return 643; // (A9WriteAdr_A9WriteAdr)_A9WriteLMfp1_(A9WriteLMfpLo_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)_(A9WriteLMHi_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1_A9WriteCycle1)
    }
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->getNumLDMAddresses(MI) == 1))
        return 768; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM4Cy
      if ((TII->getNumLDMAddresses(MI) == 2))
        return 769; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM4Cy_SwiftWriteLM4CyNo
      if ((TII->getNumLDMAddresses(MI) == 3))
        return 770; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm3
      if ((TII->getNumLDMAddresses(MI) == 4))
        return 771; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM4Cy_SwiftWriteLM4CyNo_SwiftWriteLM4CyNo_SwiftWriteLM4CyNo
      if ((TII->getNumLDMAddresses(MI) == 5))
        return 772; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13CyNo_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5
      if ((TII->getNumLDMAddresses(MI) == 6))
        return 773; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5
      if ((TII->getNumLDMAddresses(MI) == 7))
        return 774; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm7
      if ((TII->getNumLDMAddresses(MI) == 8))
        return 775; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM13Cy_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm2
      if ((TII->getNumLDMAddresses(MI) == 9))
        return 776; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9
      if ((TII->getNumLDMAddresses(MI) == 10))
        return 777; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm5
      if ((TII->getNumLDMAddresses(MI) == 11))
        return 778; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9
      if ((TII->getNumLDMAddresses(MI) == 12))
        return 779; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM11Cy_SwiftWriteLM11Cy_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteLM11CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm3
      if ((TII->getNumLDMAddresses(MI) == 13))
        return 780; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14CyNo_SwiftWriteLM17CyNo_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9
      if ((TII->getNumLDMAddresses(MI) == 14))
        return 781; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM10Cy_SwiftWriteLM14Cy_SwiftWriteLM14Cy_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteLM14CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm7
      if ((TII->getNumLDMAddresses(MI) == 15))
        return 782; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM9Cy_SwiftWriteLM10Cy_SwiftWriteLM13Cy_SwiftWriteLM14Cy_SwiftWriteLM17Cy_SwiftWriteLM18CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM21CyNo_SwiftWriteLM22CyNo_SwiftWriteLM25CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm9
      if ((TII->getNumLDMAddresses(MI) == 16))
        return 783; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM10Cy_SwiftWriteLM11Cy_SwiftWriteLM14Cy_SwiftWriteLM15Cy_SwiftWriteLM18CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteLM19CyNo_SwiftWriteLM22CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm4
      if ((true))
        return 784; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteLM7Cy_SwiftWriteLM8Cy_SwiftWriteLM13Cy_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteLM13CyNo_SwiftWriteP01OneCycle_SwiftVLDMPerm2
    }
    break;
  case 516: // VSTMDIA_VSTMSIA
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->getNumLDMAddresses(MI) == 1))
        return 785; // SwiftWriteStIncAddr
      if ((TII->getNumLDMAddresses(MI) == 2))
        return 785; // SwiftWriteStIncAddr
      if ((TII->getNumLDMAddresses(MI) == 3))
        return 723; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 4))
        return 785; // SwiftWriteStIncAddr
      if ((TII->getNumLDMAddresses(MI) == 5))
        return 725; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 6))
        return 723; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 7))
        return 727; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 8))
        return 722; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 9))
        return 729; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 10))
        return 725; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 11))
        return 731; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 12))
        return 723; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 13))
        return 733; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 14))
        return 727; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 15))
        return 735; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 16))
        return 724; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((true))
        return 722; // (SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
    }
    break;
  case 517: // VSTMDDB_UPD_VSTMDIA_UPD_VSTMSDB_UPD_VSTMSIA_UPD
    if (SchedModel->getProcessorID() == 4) { // SwiftModel
      if ((TII->getNumLDMAddresses(MI) == 1))
        return 786; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteStIncAddr
      if ((TII->getNumLDMAddresses(MI) == 2))
        return 786; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteStIncAddr
      if ((TII->getNumLDMAddresses(MI) == 3))
        return 787; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 4))
        return 786; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_SwiftWriteStIncAddr
      if ((TII->getNumLDMAddresses(MI) == 5))
        return 788; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 6))
        return 787; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 7))
        return 789; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 8))
        return 790; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 9))
        return 791; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 10))
        return 788; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 11))
        return 792; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 12))
        return 787; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 13))
        return 793; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 14))
        return 789; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 15))
        return 794; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((TII->getNumLDMAddresses(MI) == 16))
        return 795; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
      if ((true))
        return 790; // (SwiftWriteP01OneCycle_SwiftWriteP01OneCycle)_(SwiftWriteStIncAddr_SwiftWriteStIncAddr_SwiftWriteStIncAddr)
    }
    break;
  };
  report_fatal_error("Expected a variant SchedClass");
} // ARMGenSubtargetInfo::resolveSchedClass
} // End llvm namespace 
#endif // GET_SUBTARGETINFO_CTOR

