


#include <libgda/libgda.h>
#include <glib-object.h>
GType
gda_batch_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_BATCH_CONFLICTING_PARAMETER_ERROR, "GDA_BATCH_CONFLICTING_PARAMETER_ERROR", "error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaBatchError", values);
  }
  return etype;
}
GType
gda_config_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_CONFIG_DSN_NOT_FOUND_ERROR, "GDA_CONFIG_DSN_NOT_FOUND_ERROR", "dsn-not-found-error" },
      { GDA_CONFIG_PERMISSION_ERROR, "GDA_CONFIG_PERMISSION_ERROR", "permission-error" },
      { GDA_CONFIG_PROVIDER_NOT_FOUND_ERROR, "GDA_CONFIG_PROVIDER_NOT_FOUND_ERROR", "provider-not-found-error" },
      { GDA_CONFIG_PROVIDER_CREATION_ERROR, "GDA_CONFIG_PROVIDER_CREATION_ERROR", "provider-creation-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaConfigError", values);
  }
  return etype;
}
GType
gda_connection_event_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_CONNECTION_EVENT_NOTICE, "GDA_CONNECTION_EVENT_NOTICE", "notice" },
      { GDA_CONNECTION_EVENT_WARNING, "GDA_CONNECTION_EVENT_WARNING", "warning" },
      { GDA_CONNECTION_EVENT_ERROR, "GDA_CONNECTION_EVENT_ERROR", "error" },
      { GDA_CONNECTION_EVENT_COMMAND, "GDA_CONNECTION_EVENT_COMMAND", "command" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaConnectionEventType", values);
  }
  return etype;
}
GType
gda_connection_event_code_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_CONNECTION_EVENT_CODE_CONSTRAINT_VIOLATION, "GDA_CONNECTION_EVENT_CODE_CONSTRAINT_VIOLATION", "constraint-violation" },
      { GDA_CONNECTION_EVENT_CODE_RESTRICT_VIOLATION, "GDA_CONNECTION_EVENT_CODE_RESTRICT_VIOLATION", "restrict-violation" },
      { GDA_CONNECTION_EVENT_CODE_NOT_NULL_VIOLATION, "GDA_CONNECTION_EVENT_CODE_NOT_NULL_VIOLATION", "not-null-violation" },
      { GDA_CONNECTION_EVENT_CODE_FOREIGN_KEY_VIOLATION, "GDA_CONNECTION_EVENT_CODE_FOREIGN_KEY_VIOLATION", "foreign-key-violation" },
      { GDA_CONNECTION_EVENT_CODE_UNIQUE_VIOLATION, "GDA_CONNECTION_EVENT_CODE_UNIQUE_VIOLATION", "unique-violation" },
      { GDA_CONNECTION_EVENT_CODE_CHECK_VIOLATION, "GDA_CONNECTION_EVENT_CODE_CHECK_VIOLATION", "check-violation" },
      { GDA_CONNECTION_EVENT_CODE_INSUFFICIENT_PRIVILEGES, "GDA_CONNECTION_EVENT_CODE_INSUFFICIENT_PRIVILEGES", "insufficient-privileges" },
      { GDA_CONNECTION_EVENT_CODE_UNDEFINED_COLUMN, "GDA_CONNECTION_EVENT_CODE_UNDEFINED_COLUMN", "undefined-column" },
      { GDA_CONNECTION_EVENT_CODE_UNDEFINED_FUNCTION, "GDA_CONNECTION_EVENT_CODE_UNDEFINED_FUNCTION", "undefined-function" },
      { GDA_CONNECTION_EVENT_CODE_UNDEFINED_TABLE, "GDA_CONNECTION_EVENT_CODE_UNDEFINED_TABLE", "undefined-table" },
      { GDA_CONNECTION_EVENT_CODE_DUPLICATE_COLUMN, "GDA_CONNECTION_EVENT_CODE_DUPLICATE_COLUMN", "duplicate-column" },
      { GDA_CONNECTION_EVENT_CODE_DUPLICATE_DATABASE, "GDA_CONNECTION_EVENT_CODE_DUPLICATE_DATABASE", "duplicate-database" },
      { GDA_CONNECTION_EVENT_CODE_DUPLICATE_FUNCTION, "GDA_CONNECTION_EVENT_CODE_DUPLICATE_FUNCTION", "duplicate-function" },
      { GDA_CONNECTION_EVENT_CODE_DUPLICATE_SCHEMA, "GDA_CONNECTION_EVENT_CODE_DUPLICATE_SCHEMA", "duplicate-schema" },
      { GDA_CONNECTION_EVENT_CODE_DUPLICATE_TABLE, "GDA_CONNECTION_EVENT_CODE_DUPLICATE_TABLE", "duplicate-table" },
      { GDA_CONNECTION_EVENT_CODE_DUPLICATE_ALIAS, "GDA_CONNECTION_EVENT_CODE_DUPLICATE_ALIAS", "duplicate-alias" },
      { GDA_CONNECTION_EVENT_CODE_DUPLICATE_OBJECT, "GDA_CONNECTION_EVENT_CODE_DUPLICATE_OBJECT", "duplicate-object" },
      { GDA_CONNECTION_EVENT_CODE_SYNTAX_ERROR, "GDA_CONNECTION_EVENT_CODE_SYNTAX_ERROR", "syntax-error" },
      { GDA_CONNECTION_EVENT_CODE_UNKNOWN, "GDA_CONNECTION_EVENT_CODE_UNKNOWN", "unknown" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaConnectionEventCode", values);
  }
  return etype;
}
GType
gda_connection_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_CONNECTION_DSN_NOT_FOUND_ERROR, "GDA_CONNECTION_DSN_NOT_FOUND_ERROR", "dsn-not-found-error" },
      { GDA_CONNECTION_PROVIDER_NOT_FOUND_ERROR, "GDA_CONNECTION_PROVIDER_NOT_FOUND_ERROR", "provider-not-found-error" },
      { GDA_CONNECTION_PROVIDER_ERROR, "GDA_CONNECTION_PROVIDER_ERROR", "provider-error" },
      { GDA_CONNECTION_NO_CNC_SPEC_ERROR, "GDA_CONNECTION_NO_CNC_SPEC_ERROR", "no-cnc-spec-error" },
      { GDA_CONNECTION_NO_PROVIDER_SPEC_ERROR, "GDA_CONNECTION_NO_PROVIDER_SPEC_ERROR", "no-provider-spec-error" },
      { GDA_CONNECTION_OPEN_ERROR, "GDA_CONNECTION_OPEN_ERROR", "open-error" },
      { GDA_CONNECTION_STATEMENT_TYPE_ERROR, "GDA_CONNECTION_STATEMENT_TYPE_ERROR", "statement-type-error" },
      { GDA_CONNECTION_CANT_LOCK_ERROR, "GDA_CONNECTION_CANT_LOCK_ERROR", "cant-lock-error" },
      { GDA_CONNECTION_TASK_NOT_FOUND_ERROR, "GDA_CONNECTION_TASK_NOT_FOUND_ERROR", "task-not-found-error" },
      { GDA_CONNECTION_UNSUPPORTED_THREADS_ERROR, "GDA_CONNECTION_UNSUPPORTED_THREADS_ERROR", "unsupported-threads-error" },
      { GDA_CONNECTION_CLOSED_ERROR, "GDA_CONNECTION_CLOSED_ERROR", "closed-error" },
      { GDA_CONNECTION_META_DATA_CONTEXT_ERROR, "GDA_CONNECTION_META_DATA_CONTEXT_ERROR", "meta-data-context-error" },
      { GDA_CONNECTION_UNSUPPORTED_ASYNC_EXEC_ERROR, "GDA_CONNECTION_UNSUPPORTED_ASYNC_EXEC_ERROR", "unsupported-async-exec-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaConnectionError", values);
  }
  return etype;
}
GType
gda_connection_options_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { GDA_CONNECTION_OPTIONS_NONE, "GDA_CONNECTION_OPTIONS_NONE", "none" },
      { GDA_CONNECTION_OPTIONS_READ_ONLY, "GDA_CONNECTION_OPTIONS_READ_ONLY", "read-only" },
      { GDA_CONNECTION_OPTIONS_SQL_IDENTIFIERS_CASE_SENSITIVE, "GDA_CONNECTION_OPTIONS_SQL_IDENTIFIERS_CASE_SENSITIVE", "sql-identifiers-case-sensitive" },
      { GDA_CONNECTION_OPTIONS_THREAD_SAFE, "GDA_CONNECTION_OPTIONS_THREAD_SAFE", "thread-safe" },
      { GDA_CONNECTION_OPTIONS_THREAD_ISOLATED, "GDA_CONNECTION_OPTIONS_THREAD_ISOLATED", "thread-isolated" },
      { GDA_CONNECTION_OPTIONS_AUTO_META_DATA, "GDA_CONNECTION_OPTIONS_AUTO_META_DATA", "auto-meta-data" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("GdaConnectionOptions", values);
  }
  return etype;
}
GType
gda_connection_feature_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_CONNECTION_FEATURE_AGGREGATES, "GDA_CONNECTION_FEATURE_AGGREGATES", "aggregates" },
      { GDA_CONNECTION_FEATURE_BLOBS, "GDA_CONNECTION_FEATURE_BLOBS", "blobs" },
      { GDA_CONNECTION_FEATURE_INDEXES, "GDA_CONNECTION_FEATURE_INDEXES", "indexes" },
      { GDA_CONNECTION_FEATURE_INHERITANCE, "GDA_CONNECTION_FEATURE_INHERITANCE", "inheritance" },
      { GDA_CONNECTION_FEATURE_NAMESPACES, "GDA_CONNECTION_FEATURE_NAMESPACES", "namespaces" },
      { GDA_CONNECTION_FEATURE_PROCEDURES, "GDA_CONNECTION_FEATURE_PROCEDURES", "procedures" },
      { GDA_CONNECTION_FEATURE_SEQUENCES, "GDA_CONNECTION_FEATURE_SEQUENCES", "sequences" },
      { GDA_CONNECTION_FEATURE_SQL, "GDA_CONNECTION_FEATURE_SQL", "sql" },
      { GDA_CONNECTION_FEATURE_TRANSACTIONS, "GDA_CONNECTION_FEATURE_TRANSACTIONS", "transactions" },
      { GDA_CONNECTION_FEATURE_SAVEPOINTS, "GDA_CONNECTION_FEATURE_SAVEPOINTS", "savepoints" },
      { GDA_CONNECTION_FEATURE_SAVEPOINTS_REMOVE, "GDA_CONNECTION_FEATURE_SAVEPOINTS_REMOVE", "savepoints-remove" },
      { GDA_CONNECTION_FEATURE_TRIGGERS, "GDA_CONNECTION_FEATURE_TRIGGERS", "triggers" },
      { GDA_CONNECTION_FEATURE_UPDATABLE_CURSOR, "GDA_CONNECTION_FEATURE_UPDATABLE_CURSOR", "updatable-cursor" },
      { GDA_CONNECTION_FEATURE_USERS, "GDA_CONNECTION_FEATURE_USERS", "users" },
      { GDA_CONNECTION_FEATURE_VIEWS, "GDA_CONNECTION_FEATURE_VIEWS", "views" },
      { GDA_CONNECTION_FEATURE_XA_TRANSACTIONS, "GDA_CONNECTION_FEATURE_XA_TRANSACTIONS", "xa-transactions" },
      { GDA_CONNECTION_FEATURE_MULTI_THREADING, "GDA_CONNECTION_FEATURE_MULTI_THREADING", "multi-threading" },
      { GDA_CONNECTION_FEATURE_ASYNC_EXEC, "GDA_CONNECTION_FEATURE_ASYNC_EXEC", "async-exec" },
      { GDA_CONNECTION_FEATURE_LAST, "GDA_CONNECTION_FEATURE_LAST", "last" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaConnectionFeature", values);
  }
  return etype;
}
GType
gda_connection_meta_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_CONNECTION_META_NAMESPACES, "GDA_CONNECTION_META_NAMESPACES", "namespaces" },
      { GDA_CONNECTION_META_TYPES, "GDA_CONNECTION_META_TYPES", "types" },
      { GDA_CONNECTION_META_TABLES, "GDA_CONNECTION_META_TABLES", "tables" },
      { GDA_CONNECTION_META_VIEWS, "GDA_CONNECTION_META_VIEWS", "views" },
      { GDA_CONNECTION_META_FIELDS, "GDA_CONNECTION_META_FIELDS", "fields" },
      { GDA_CONNECTION_META_INDEXES, "GDA_CONNECTION_META_INDEXES", "indexes" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaConnectionMetaType", values);
  }
  return etype;
}
GType
gda_data_comparator_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_DATA_COMPARATOR_MISSING_DATA_MODEL_ERROR, "GDA_DATA_COMPARATOR_MISSING_DATA_MODEL_ERROR", "missing-data-model-error" },
      { GDA_DATA_COMPARATOR_COLUMN_TYPES_MISMATCH_ERROR, "GDA_DATA_COMPARATOR_COLUMN_TYPES_MISMATCH_ERROR", "column-types-mismatch-error" },
      { GDA_DATA_COMPARATOR_MODEL_ACCESS_ERROR, "GDA_DATA_COMPARATOR_MODEL_ACCESS_ERROR", "model-access-error" },
      { GDA_DATA_COMPARATOR_USER_CANCELLED_ERROR, "GDA_DATA_COMPARATOR_USER_CANCELLED_ERROR", "user-cancelled-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaDataComparatorError", values);
  }
  return etype;
}
GType
gda_diff_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_DIFF_ADD_ROW, "GDA_DIFF_ADD_ROW", "add-row" },
      { GDA_DIFF_REMOVE_ROW, "GDA_DIFF_REMOVE_ROW", "remove-row" },
      { GDA_DIFF_MODIFY_ROW, "GDA_DIFF_MODIFY_ROW", "modify-row" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaDiffType", values);
  }
  return etype;
}
GType
gda_data_model_access_flags_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { GDA_DATA_MODEL_ACCESS_RANDOM, "GDA_DATA_MODEL_ACCESS_RANDOM", "random" },
      { GDA_DATA_MODEL_ACCESS_CURSOR_FORWARD, "GDA_DATA_MODEL_ACCESS_CURSOR_FORWARD", "cursor-forward" },
      { GDA_DATA_MODEL_ACCESS_CURSOR_BACKWARD, "GDA_DATA_MODEL_ACCESS_CURSOR_BACKWARD", "cursor-backward" },
      { GDA_DATA_MODEL_ACCESS_CURSOR, "GDA_DATA_MODEL_ACCESS_CURSOR", "cursor" },
      { GDA_DATA_MODEL_ACCESS_INSERT, "GDA_DATA_MODEL_ACCESS_INSERT", "insert" },
      { GDA_DATA_MODEL_ACCESS_UPDATE, "GDA_DATA_MODEL_ACCESS_UPDATE", "update" },
      { GDA_DATA_MODEL_ACCESS_DELETE, "GDA_DATA_MODEL_ACCESS_DELETE", "delete" },
      { GDA_DATA_MODEL_ACCESS_WRITE, "GDA_DATA_MODEL_ACCESS_WRITE", "write" },
      { GDA_DATA_MODEL_ACCESS_DELETE, "GDA_DATA_MODEL_ACCESS_DELETE", "delete" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("GdaDataModelAccessFlags", values);
  }
  return etype;
}
GType
gda_data_model_hint_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_DATA_MODEL_HINT_START_BATCH_UPDATE, "GDA_DATA_MODEL_HINT_START_BATCH_UPDATE", "start-batch-update" },
      { GDA_DATA_MODEL_HINT_END_BATCH_UPDATE, "GDA_DATA_MODEL_HINT_END_BATCH_UPDATE", "end-batch-update" },
      { GDA_DATA_MODEL_HINT_REFRESH, "GDA_DATA_MODEL_HINT_REFRESH", "refresh" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaDataModelHint", values);
  }
  return etype;
}
GType
gda_data_model_io_format_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_DATA_MODEL_IO_DATA_ARRAY_XML, "GDA_DATA_MODEL_IO_DATA_ARRAY_XML", "data-array-xml" },
      { GDA_DATA_MODEL_IO_TEXT_SEPARATED, "GDA_DATA_MODEL_IO_TEXT_SEPARATED", "text-separated" },
      { GDA_DATA_MODEL_IO_TEXT_TABLE, "GDA_DATA_MODEL_IO_TEXT_TABLE", "text-table" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaDataModelIOFormat", values);
  }
  return etype;
}
GType
gda_data_model_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_DATA_MODEL_ROW_OUT_OF_RANGE_ERROR, "GDA_DATA_MODEL_ROW_OUT_OF_RANGE_ERROR", "row-out-of-range-error" },
      { GDA_DATA_MODEL_COLUMN_OUT_OF_RANGE_ERROR, "GDA_DATA_MODEL_COLUMN_OUT_OF_RANGE_ERROR", "column-out-of-range-error" },
      { GDA_DATA_MODEL_VALUES_LIST_ERROR, "GDA_DATA_MODEL_VALUES_LIST_ERROR", "values-list-error" },
      { GDA_DATA_MODEL_VALUE_TYPE_ERROR, "GDA_DATA_MODEL_VALUE_TYPE_ERROR", "value-type-error" },
      { GDA_DATA_MODEL_ROW_NOT_FOUND_ERROR, "GDA_DATA_MODEL_ROW_NOT_FOUND_ERROR", "row-not-found-error" },
      { GDA_DATA_MODEL_ACCESS_ERROR, "GDA_DATA_MODEL_ACCESS_ERROR", "access-error" },
      { GDA_DATA_MODEL_FEATURE_NON_SUPPORTED_ERROR, "GDA_DATA_MODEL_FEATURE_NON_SUPPORTED_ERROR", "feature-non-supported-error" },
      { GDA_DATA_MODEL_FILE_EXIST_ERROR, "GDA_DATA_MODEL_FILE_EXIST_ERROR", "file-exist-error" },
      { GDA_DATA_MODEL_XML_FORMAT_ERROR, "GDA_DATA_MODEL_XML_FORMAT_ERROR", "xml-format-error" },
      { GDA_DATA_MODEL_TRUNCATED_ERROR, "GDA_DATA_MODEL_TRUNCATED_ERROR", "truncated-error" },
      { GDA_DATA_MODEL_OTHER_ERROR, "GDA_DATA_MODEL_OTHER_ERROR", "other-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaDataModelError", values);
  }
  return etype;
}
GType
gda_ldap_search_scope_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_LDAP_SEARCH_BASE, "GDA_LDAP_SEARCH_BASE", "base" },
      { GDA_LDAP_SEARCH_ONELEVEL, "GDA_LDAP_SEARCH_ONELEVEL", "onelevel" },
      { GDA_LDAP_SEARCH_SUBTREE, "GDA_LDAP_SEARCH_SUBTREE", "subtree" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaLdapSearchScope", values);
  }
  return etype;
}
GType
gda_data_model_iter_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_DATA_MODEL_ITER_COLUMN_OUT_OF_RANGE_ERROR, "GDA_DATA_MODEL_ITER_COLUMN_OUT_OF_RANGE_ERROR", "error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaDataModelIterError", values);
  }
  return etype;
}
GType
gda_data_proxy_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_DATA_PROXY_COMMIT_ERROR, "GDA_DATA_PROXY_COMMIT_ERROR", "commit-error" },
      { GDA_DATA_PROXY_COMMIT_CANCELLED, "GDA_DATA_PROXY_COMMIT_CANCELLED", "commit-cancelled" },
      { GDA_DATA_PROXY_READ_ONLY_VALUE, "GDA_DATA_PROXY_READ_ONLY_VALUE", "read-only-value" },
      { GDA_DATA_PROXY_READ_ONLY_ROW, "GDA_DATA_PROXY_READ_ONLY_ROW", "read-only-row" },
      { GDA_DATA_PROXY_FILTER_ERROR, "GDA_DATA_PROXY_FILTER_ERROR", "filter-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaDataProxyError", values);
  }
  return etype;
}
GType
gda_data_select_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_DATA_SELECT_MODIFICATION_STATEMENT_ERROR, "GDA_DATA_SELECT_MODIFICATION_STATEMENT_ERROR", "modification-statement-error" },
      { GDA_DATA_SELECT_MISSING_MODIFICATION_STATEMENT_ERROR, "GDA_DATA_SELECT_MISSING_MODIFICATION_STATEMENT_ERROR", "missing-modification-statement-error" },
      { GDA_DATA_SELECT_CONNECTION_ERROR, "GDA_DATA_SELECT_CONNECTION_ERROR", "connection-error" },
      { GDA_DATA_SELECT_ACCESS_ERROR, "GDA_DATA_SELECT_ACCESS_ERROR", "access-error" },
      { GDA_DATA_SELECT_SQL_ERROR, "GDA_DATA_SELECT_SQL_ERROR", "sql-error" },
      { GDA_DATA_SELECT_SAFETY_LOCKED_ERROR, "GDA_DATA_SELECT_SAFETY_LOCKED_ERROR", "safety-locked-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaDataSelectError", values);
  }
  return etype;
}
GType
gda_data_select_condition_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_DATA_SELECT_COND_PK, "GDA_DATA_SELECT_COND_PK", "pk" },
      { GDA_DATA_SELECT_COND_ALL_COLUMNS, "GDA_DATA_SELECT_COND_ALL_COLUMNS", "all-columns" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaDataSelectConditionType", values);
  }
  return etype;
}
GType
gda_transaction_isolation_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_TRANSACTION_ISOLATION_UNKNOWN, "GDA_TRANSACTION_ISOLATION_UNKNOWN", "unknown" },
      { GDA_TRANSACTION_ISOLATION_READ_COMMITTED, "GDA_TRANSACTION_ISOLATION_READ_COMMITTED", "read-committed" },
      { GDA_TRANSACTION_ISOLATION_READ_UNCOMMITTED, "GDA_TRANSACTION_ISOLATION_READ_UNCOMMITTED", "read-uncommitted" },
      { GDA_TRANSACTION_ISOLATION_REPEATABLE_READ, "GDA_TRANSACTION_ISOLATION_REPEATABLE_READ", "repeatable-read" },
      { GDA_TRANSACTION_ISOLATION_SERIALIZABLE, "GDA_TRANSACTION_ISOLATION_SERIALIZABLE", "serializable" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaTransactionIsolation", values);
  }
  return etype;
}
GType
gda_value_attribute_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { GDA_VALUE_ATTR_NONE, "GDA_VALUE_ATTR_NONE", "none" },
      { GDA_VALUE_ATTR_IS_NULL, "GDA_VALUE_ATTR_IS_NULL", "is-null" },
      { GDA_VALUE_ATTR_CAN_BE_NULL, "GDA_VALUE_ATTR_CAN_BE_NULL", "can-be-null" },
      { GDA_VALUE_ATTR_IS_DEFAULT, "GDA_VALUE_ATTR_IS_DEFAULT", "is-default" },
      { GDA_VALUE_ATTR_CAN_BE_DEFAULT, "GDA_VALUE_ATTR_CAN_BE_DEFAULT", "can-be-default" },
      { GDA_VALUE_ATTR_IS_UNCHANGED, "GDA_VALUE_ATTR_IS_UNCHANGED", "is-unchanged" },
      { GDA_VALUE_ATTR_ACTIONS_SHOWN, "GDA_VALUE_ATTR_ACTIONS_SHOWN", "actions-shown" },
      { GDA_VALUE_ATTR_DATA_NON_VALID, "GDA_VALUE_ATTR_DATA_NON_VALID", "data-non-valid" },
      { GDA_VALUE_ATTR_HAS_VALUE_ORIG, "GDA_VALUE_ATTR_HAS_VALUE_ORIG", "has-value-orig" },
      { GDA_VALUE_ATTR_NO_MODIF, "GDA_VALUE_ATTR_NO_MODIF", "no-modif" },
      { GDA_VALUE_ATTR_UNUSED, "GDA_VALUE_ATTR_UNUSED", "unused" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("GdaValueAttribute", values);
  }
  return etype;
}
GType
gda_sql_identifier_style_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { GDA_SQL_IDENTIFIERS_LOWER_CASE, "GDA_SQL_IDENTIFIERS_LOWER_CASE", "lower-case" },
      { GDA_SQL_IDENTIFIERS_UPPER_CASE, "GDA_SQL_IDENTIFIERS_UPPER_CASE", "upper-case" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("GdaSqlIdentifierStyle", values);
  }
  return etype;
}
GType
gda_holder_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_HOLDER_STRING_CONVERSION_ERROR, "GDA_HOLDER_STRING_CONVERSION_ERROR", "string-conversion-error" },
      { GDA_HOLDER_VALUE_TYPE_ERROR, "GDA_HOLDER_VALUE_TYPE_ERROR", "value-type-error" },
      { GDA_HOLDER_VALUE_NULL_ERROR, "GDA_HOLDER_VALUE_NULL_ERROR", "value-null-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaHolderError", values);
  }
  return etype;
}
GType
gda_meta_store_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_META_STORE_INCORRECT_SCHEMA_ERROR, "GDA_META_STORE_INCORRECT_SCHEMA_ERROR", "incorrect-schema-error" },
      { GDA_META_STORE_UNSUPPORTED_PROVIDER_ERROR, "GDA_META_STORE_UNSUPPORTED_PROVIDER_ERROR", "unsupported-provider-error" },
      { GDA_META_STORE_INTERNAL_ERROR, "GDA_META_STORE_INTERNAL_ERROR", "internal-error" },
      { GDA_META_STORE_META_CONTEXT_ERROR, "GDA_META_STORE_META_CONTEXT_ERROR", "meta-context-error" },
      { GDA_META_STORE_MODIFY_CONTENTS_ERROR, "GDA_META_STORE_MODIFY_CONTENTS_ERROR", "modify-contents-error" },
      { GDA_META_STORE_EXTRACT_SQL_ERROR, "GDA_META_STORE_EXTRACT_SQL_ERROR", "extract-sql-error" },
      { GDA_META_STORE_ATTRIBUTE_NOT_FOUND_ERROR, "GDA_META_STORE_ATTRIBUTE_NOT_FOUND_ERROR", "attribute-not-found-error" },
      { GDA_META_STORE_ATTRIBUTE_ERROR, "GDA_META_STORE_ATTRIBUTE_ERROR", "attribute-error" },
      { GDA_META_STORE_SCHEMA_OBJECT_NOT_FOUND_ERROR, "GDA_META_STORE_SCHEMA_OBJECT_NOT_FOUND_ERROR", "schema-object-not-found-error" },
      { GDA_META_STORE_SCHEMA_OBJECT_CONFLICT_ERROR, "GDA_META_STORE_SCHEMA_OBJECT_CONFLICT_ERROR", "schema-object-conflict-error" },
      { GDA_META_STORE_SCHEMA_OBJECT_DESCR_ERROR, "GDA_META_STORE_SCHEMA_OBJECT_DESCR_ERROR", "schema-object-descr-error" },
      { GDA_META_STORE_TRANSACTION_ALREADY_STARTED_ERROR, "GDA_META_STORE_TRANSACTION_ALREADY_STARTED_ERROR", "transaction-already-started-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaMetaStoreError", values);
  }
  return etype;
}
GType
gda_meta_store_change_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_META_STORE_ADD, "GDA_META_STORE_ADD", "add" },
      { GDA_META_STORE_REMOVE, "GDA_META_STORE_REMOVE", "remove" },
      { GDA_META_STORE_MODIFY, "GDA_META_STORE_MODIFY", "modify" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaMetaStoreChangeType", values);
  }
  return etype;
}
GType
gda_meta_struct_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_META_STRUCT_UNKNOWN_OBJECT_ERROR, "GDA_META_STRUCT_UNKNOWN_OBJECT_ERROR", "unknown-object-error" },
      { GDA_META_STRUCT_DUPLICATE_OBJECT_ERROR, "GDA_META_STRUCT_DUPLICATE_OBJECT_ERROR", "duplicate-object-error" },
      { GDA_META_STRUCT_INCOHERENCE_ERROR, "GDA_META_STRUCT_INCOHERENCE_ERROR", "incoherence-error" },
      { GDA_META_STRUCT_XML_ERROR, "GDA_META_STRUCT_XML_ERROR", "xml-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaMetaStructError", values);
  }
  return etype;
}
GType
gda_meta_db_object_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_META_DB_UNKNOWN, "GDA_META_DB_UNKNOWN", "unknown" },
      { GDA_META_DB_TABLE, "GDA_META_DB_TABLE", "table" },
      { GDA_META_DB_VIEW, "GDA_META_DB_VIEW", "view" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaMetaDbObjectType", values);
  }
  return etype;
}
GType
gda_meta_struct_feature_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { GDA_META_STRUCT_FEATURE_NONE, "GDA_META_STRUCT_FEATURE_NONE", "none" },
      { GDA_META_STRUCT_FEATURE_FOREIGN_KEYS, "GDA_META_STRUCT_FEATURE_FOREIGN_KEYS", "foreign-keys" },
      { GDA_META_STRUCT_FEATURE_VIEW_DEPENDENCIES, "GDA_META_STRUCT_FEATURE_VIEW_DEPENDENCIES", "view-dependencies" },
      { GDA_META_STRUCT_FEATURE_ALL, "GDA_META_STRUCT_FEATURE_ALL", "all" },
      { GDA_META_STRUCT_FEATURE_VIEW_DEPENDENCIES, "GDA_META_STRUCT_FEATURE_VIEW_DEPENDENCIES", "view-dependencies" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("GdaMetaStructFeature", values);
  }
  return etype;
}
GType
gda_meta_sort_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_META_SORT_ALHAPETICAL, "GDA_META_SORT_ALHAPETICAL", "alhapetical" },
      { GDA_META_SORT_DEPENDENCIES, "GDA_META_SORT_DEPENDENCIES", "dependencies" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaMetaSortType", values);
  }
  return etype;
}
GType
gda_meta_foreign_key_policy_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_META_FOREIGN_KEY_UNKNOWN, "GDA_META_FOREIGN_KEY_UNKNOWN", "unknown" },
      { GDA_META_FOREIGN_KEY_NONE, "GDA_META_FOREIGN_KEY_NONE", "none" },
      { GDA_META_FOREIGN_KEY_NO_ACTION, "GDA_META_FOREIGN_KEY_NO_ACTION", "no-action" },
      { GDA_META_FOREIGN_KEY_RESTRICT, "GDA_META_FOREIGN_KEY_RESTRICT", "restrict" },
      { GDA_META_FOREIGN_KEY_CASCADE, "GDA_META_FOREIGN_KEY_CASCADE", "cascade" },
      { GDA_META_FOREIGN_KEY_SET_NULL, "GDA_META_FOREIGN_KEY_SET_NULL", "set-null" },
      { GDA_META_FOREIGN_KEY_SET_DEFAULT, "GDA_META_FOREIGN_KEY_SET_DEFAULT", "set-default" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaMetaForeignKeyPolicy", values);
  }
  return etype;
}
GType
gda_meta_graph_info_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { GDA_META_GRAPH_COLUMNS, "GDA_META_GRAPH_COLUMNS", "columns" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("GdaMetaGraphInfo", values);
  }
  return etype;
}
GType
gda_set_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SET_XML_SPEC_ERROR, "GDA_SET_XML_SPEC_ERROR", "xml-spec-error" },
      { GDA_SET_HOLDER_NOT_FOUND_ERROR, "GDA_SET_HOLDER_NOT_FOUND_ERROR", "holder-not-found-error" },
      { GDA_SET_INVALID_ERROR, "GDA_SET_INVALID_ERROR", "invalid-error" },
      { GDA_SET_READ_ONLY_ERROR, "GDA_SET_READ_ONLY_ERROR", "read-only-error" },
      { GDA_SET_IMPLEMENTATION_ERROR, "GDA_SET_IMPLEMENTATION_ERROR", "implementation-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaSetError", values);
  }
  return etype;
}
GType
gda_server_operation_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SERVER_OPERATION_CREATE_DB, "GDA_SERVER_OPERATION_CREATE_DB", "create-db" },
      { GDA_SERVER_OPERATION_DROP_DB, "GDA_SERVER_OPERATION_DROP_DB", "drop-db" },
      { GDA_SERVER_OPERATION_CREATE_TABLE, "GDA_SERVER_OPERATION_CREATE_TABLE", "create-table" },
      { GDA_SERVER_OPERATION_DROP_TABLE, "GDA_SERVER_OPERATION_DROP_TABLE", "drop-table" },
      { GDA_SERVER_OPERATION_RENAME_TABLE, "GDA_SERVER_OPERATION_RENAME_TABLE", "rename-table" },
      { GDA_SERVER_OPERATION_ADD_COLUMN, "GDA_SERVER_OPERATION_ADD_COLUMN", "add-column" },
      { GDA_SERVER_OPERATION_DROP_COLUMN, "GDA_SERVER_OPERATION_DROP_COLUMN", "drop-column" },
      { GDA_SERVER_OPERATION_CREATE_INDEX, "GDA_SERVER_OPERATION_CREATE_INDEX", "create-index" },
      { GDA_SERVER_OPERATION_DROP_INDEX, "GDA_SERVER_OPERATION_DROP_INDEX", "drop-index" },
      { GDA_SERVER_OPERATION_CREATE_VIEW, "GDA_SERVER_OPERATION_CREATE_VIEW", "create-view" },
      { GDA_SERVER_OPERATION_DROP_VIEW, "GDA_SERVER_OPERATION_DROP_VIEW", "drop-view" },
      { GDA_SERVER_OPERATION_COMMENT_TABLE, "GDA_SERVER_OPERATION_COMMENT_TABLE", "comment-table" },
      { GDA_SERVER_OPERATION_COMMENT_COLUMN, "GDA_SERVER_OPERATION_COMMENT_COLUMN", "comment-column" },
      { GDA_SERVER_OPERATION_CREATE_USER, "GDA_SERVER_OPERATION_CREATE_USER", "create-user" },
      { GDA_SERVER_OPERATION_ALTER_USER, "GDA_SERVER_OPERATION_ALTER_USER", "alter-user" },
      { GDA_SERVER_OPERATION_DROP_USER, "GDA_SERVER_OPERATION_DROP_USER", "drop-user" },
      { GDA_SERVER_OPERATION_LAST, "GDA_SERVER_OPERATION_LAST", "last" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaServerOperationType", values);
  }
  return etype;
}
GType
gda_server_operation_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SERVER_OPERATION_OBJECT_NAME_ERROR, "GDA_SERVER_OPERATION_OBJECT_NAME_ERROR", "object-name-error" },
      { GDA_SERVER_OPERATION_INCORRECT_VALUE_ERROR, "GDA_SERVER_OPERATION_INCORRECT_VALUE_ERROR", "incorrect-value-error" },
      { GDA_SERVER_OPERATION_XML_ERROR, "GDA_SERVER_OPERATION_XML_ERROR", "xml-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaServerOperationError", values);
  }
  return etype;
}
GType
gda_server_operation_create_table_flag_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { GDA_SERVER_OPERATION_CREATE_TABLE_NOTHING_FLAG, "GDA_SERVER_OPERATION_CREATE_TABLE_NOTHING_FLAG", "nothing-flag" },
      { GDA_SERVER_OPERATION_CREATE_TABLE_PKEY_FLAG, "GDA_SERVER_OPERATION_CREATE_TABLE_PKEY_FLAG", "pkey-flag" },
      { GDA_SERVER_OPERATION_CREATE_TABLE_NOT_NULL_FLAG, "GDA_SERVER_OPERATION_CREATE_TABLE_NOT_NULL_FLAG", "not-null-flag" },
      { GDA_SERVER_OPERATION_CREATE_TABLE_UNIQUE_FLAG, "GDA_SERVER_OPERATION_CREATE_TABLE_UNIQUE_FLAG", "unique-flag" },
      { GDA_SERVER_OPERATION_CREATE_TABLE_AUTOINC_FLAG, "GDA_SERVER_OPERATION_CREATE_TABLE_AUTOINC_FLAG", "autoinc-flag" },
      { GDA_SERVER_OPERATION_CREATE_TABLE_FKEY_FLAG, "GDA_SERVER_OPERATION_CREATE_TABLE_FKEY_FLAG", "fkey-flag" },
      { GDA_SERVER_OPERATION_CREATE_TABLE_PKEY_AUTOINC_FLAG, "GDA_SERVER_OPERATION_CREATE_TABLE_PKEY_AUTOINC_FLAG", "pkey-autoinc-flag" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("GdaServerOperationCreateTableFlag", values);
  }
  return etype;
}
GType
gda_server_operation_node_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SERVER_OPERATION_NODE_PARAMLIST, "GDA_SERVER_OPERATION_NODE_PARAMLIST", "paramlist" },
      { GDA_SERVER_OPERATION_NODE_DATA_MODEL, "GDA_SERVER_OPERATION_NODE_DATA_MODEL", "data-model" },
      { GDA_SERVER_OPERATION_NODE_PARAM, "GDA_SERVER_OPERATION_NODE_PARAM", "param" },
      { GDA_SERVER_OPERATION_NODE_SEQUENCE, "GDA_SERVER_OPERATION_NODE_SEQUENCE", "sequence" },
      { GDA_SERVER_OPERATION_NODE_SEQUENCE_ITEM, "GDA_SERVER_OPERATION_NODE_SEQUENCE_ITEM", "sequence-item" },
      { GDA_SERVER_OPERATION_NODE_DATA_MODEL_COLUMN, "GDA_SERVER_OPERATION_NODE_DATA_MODEL_COLUMN", "data-model-column" },
      { GDA_SERVER_OPERATION_NODE_UNKNOWN, "GDA_SERVER_OPERATION_NODE_UNKNOWN", "unknown" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaServerOperationNodeType", values);
  }
  return etype;
}
GType
gda_server_operation_node_status_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SERVER_OPERATION_STATUS_OPTIONAL, "GDA_SERVER_OPERATION_STATUS_OPTIONAL", "optional" },
      { GDA_SERVER_OPERATION_STATUS_REQUIRED, "GDA_SERVER_OPERATION_STATUS_REQUIRED", "required" },
      { GDA_SERVER_OPERATION_STATUS_UNKNOWN, "GDA_SERVER_OPERATION_STATUS_UNKNOWN", "unknown" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaServerOperationNodeStatus", values);
  }
  return etype;
}
GType
gda_server_provider_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SERVER_PROVIDER_METHOD_NON_IMPLEMENTED_ERROR, "GDA_SERVER_PROVIDER_METHOD_NON_IMPLEMENTED_ERROR", "method-non-implemented-error" },
      { GDA_SERVER_PROVIDER_PREPARE_STMT_ERROR, "GDA_SERVER_PROVIDER_PREPARE_STMT_ERROR", "prepare-stmt-error" },
      { GDA_SERVER_PROVIDER_EMPTY_STMT_ERROR, "GDA_SERVER_PROVIDER_EMPTY_STMT_ERROR", "empty-stmt-error" },
      { GDA_SERVER_PROVIDER_MISSING_PARAM_ERROR, "GDA_SERVER_PROVIDER_MISSING_PARAM_ERROR", "missing-param-error" },
      { GDA_SERVER_PROVIDER_STATEMENT_EXEC_ERROR, "GDA_SERVER_PROVIDER_STATEMENT_EXEC_ERROR", "statement-exec-error" },
      { GDA_SERVER_PROVIDER_OPERATION_ERROR, "GDA_SERVER_PROVIDER_OPERATION_ERROR", "operation-error" },
      { GDA_SERVER_PROVIDER_INTERNAL_ERROR, "GDA_SERVER_PROVIDER_INTERNAL_ERROR", "internal-error" },
      { GDA_SERVER_PROVIDER_BUSY_ERROR, "GDA_SERVER_PROVIDER_BUSY_ERROR", "busy-error" },
      { GDA_SERVER_PROVIDER_NON_SUPPORTED_ERROR, "GDA_SERVER_PROVIDER_NON_SUPPORTED_ERROR", "non-supported-error" },
      { GDA_SERVER_PROVIDER_SERVER_VERSION_ERROR, "GDA_SERVER_PROVIDER_SERVER_VERSION_ERROR", "server-version-error" },
      { GDA_SERVER_PROVIDER_DATA_ERROR, "GDA_SERVER_PROVIDER_DATA_ERROR", "data-error" },
      { GDA_SERVER_PROVIDER_DEFAULT_VALUE_HANDLING_ERROR, "GDA_SERVER_PROVIDER_DEFAULT_VALUE_HANDLING_ERROR", "default-value-handling-error" },
      { GDA_SERVER_PROVIDER_MISUSE_ERROR, "GDA_SERVER_PROVIDER_MISUSE_ERROR", "misuse-error" },
      { GDA_SERVER_PROVIDER_FILE_NOT_FOUND_ERROR, "GDA_SERVER_PROVIDER_FILE_NOT_FOUND_ERROR", "file-not-found-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaServerProviderError", values);
  }
  return etype;
}
GType
gda_statement_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_STATEMENT_PARSE_ERROR, "GDA_STATEMENT_PARSE_ERROR", "parse-error" },
      { GDA_STATEMENT_SYNTAX_ERROR, "GDA_STATEMENT_SYNTAX_ERROR", "syntax-error" },
      { GDA_STATEMENT_NO_CNC_ERROR, "GDA_STATEMENT_NO_CNC_ERROR", "no-cnc-error" },
      { GDA_STATEMENT_CNC_CLOSED_ERROR, "GDA_STATEMENT_CNC_CLOSED_ERROR", "cnc-closed-error" },
      { GDA_STATEMENT_EXEC_ERROR, "GDA_STATEMENT_EXEC_ERROR", "exec-error" },
      { GDA_STATEMENT_PARAM_TYPE_ERROR, "GDA_STATEMENT_PARAM_TYPE_ERROR", "param-type-error" },
      { GDA_STATEMENT_PARAM_ERROR, "GDA_STATEMENT_PARAM_ERROR", "param-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaStatementError", values);
  }
  return etype;
}
GType
gda_statement_model_usage_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { GDA_STATEMENT_MODEL_RANDOM_ACCESS, "GDA_STATEMENT_MODEL_RANDOM_ACCESS", "random-access" },
      { GDA_STATEMENT_MODEL_CURSOR_FORWARD, "GDA_STATEMENT_MODEL_CURSOR_FORWARD", "cursor-forward" },
      { GDA_STATEMENT_MODEL_CURSOR_BACKWARD, "GDA_STATEMENT_MODEL_CURSOR_BACKWARD", "cursor-backward" },
      { GDA_STATEMENT_MODEL_CURSOR, "GDA_STATEMENT_MODEL_CURSOR", "cursor" },
      { GDA_STATEMENT_MODEL_ALLOW_NOPARAM, "GDA_STATEMENT_MODEL_ALLOW_NOPARAM", "allow-noparam" },
      { GDA_STATEMENT_MODEL_OFFLINE, "GDA_STATEMENT_MODEL_OFFLINE", "offline" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("GdaStatementModelUsage", values);
  }
  return etype;
}
GType
gda_statement_sql_flag_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { GDA_STATEMENT_SQL_PARAMS_AS_VALUES, "GDA_STATEMENT_SQL_PARAMS_AS_VALUES", "params-as-values" },
      { GDA_STATEMENT_SQL_PRETTY, "GDA_STATEMENT_SQL_PRETTY", "pretty" },
      { GDA_STATEMENT_SQL_PARAMS_LONG, "GDA_STATEMENT_SQL_PARAMS_LONG", "params-long" },
      { GDA_STATEMENT_SQL_PARAMS_SHORT, "GDA_STATEMENT_SQL_PARAMS_SHORT", "params-short" },
      { GDA_STATEMENT_SQL_PARAMS_AS_COLON, "GDA_STATEMENT_SQL_PARAMS_AS_COLON", "params-as-colon" },
      { GDA_STATEMENT_SQL_PARAMS_AS_DOLLAR, "GDA_STATEMENT_SQL_PARAMS_AS_DOLLAR", "params-as-dollar" },
      { GDA_STATEMENT_SQL_PARAMS_AS_QMARK, "GDA_STATEMENT_SQL_PARAMS_AS_QMARK", "params-as-qmark" },
      { GDA_STATEMENT_SQL_PARAMS_AS_UQMARK, "GDA_STATEMENT_SQL_PARAMS_AS_UQMARK", "params-as-uqmark" },
      { GDA_STATEMENT_SQL_TIMEZONE_TO_GMT, "GDA_STATEMENT_SQL_TIMEZONE_TO_GMT", "timezone-to-gmt" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("GdaStatementSqlFlag", values);
  }
  return etype;
}
GType
gda_sql_builder_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SQL_BUILDER_WRONG_TYPE_ERROR, "GDA_SQL_BUILDER_WRONG_TYPE_ERROR", "wrong-type-error" },
      { GDA_SQL_BUILDER_MISUSE_ERROR, "GDA_SQL_BUILDER_MISUSE_ERROR", "misuse-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaSqlBuilderError", values);
  }
  return etype;
}
GType
gda_transaction_status_event_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_TRANSACTION_STATUS_EVENT_SAVEPOINT, "GDA_TRANSACTION_STATUS_EVENT_SAVEPOINT", "savepoint" },
      { GDA_TRANSACTION_STATUS_EVENT_SQL, "GDA_TRANSACTION_STATUS_EVENT_SQL", "sql" },
      { GDA_TRANSACTION_STATUS_EVENT_SUB_TRANSACTION, "GDA_TRANSACTION_STATUS_EVENT_SUB_TRANSACTION", "sub-transaction" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaTransactionStatusEventType", values);
  }
  return etype;
}
GType
gda_transaction_status_state_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_TRANSACTION_STATUS_STATE_OK, "GDA_TRANSACTION_STATUS_STATE_OK", "ok" },
      { GDA_TRANSACTION_STATUS_STATE_FAILED, "GDA_TRANSACTION_STATUS_STATE_FAILED", "failed" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaTransactionStatusState", values);
  }
  return etype;
}
GType
gda_tree_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_TREE_UNKNOWN_ERROR, "GDA_TREE_UNKNOWN_ERROR", "error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaTreeError", values);
  }
  return etype;
}
GType
gda_tree_node_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_TREE_NODE_UNKNOWN_ERROR, "GDA_TREE_NODE_UNKNOWN_ERROR", "error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaTreeNodeError", values);
  }
  return etype;
}
GType
gda_tree_manager_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_TREE_MANAGER_UNKNOWN_ERROR, "GDA_TREE_MANAGER_UNKNOWN_ERROR", "error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaTreeManagerError", values);
  }
  return etype;
}
GType
gda_xa_transaction_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_XA_TRANSACTION_ALREADY_REGISTERED_ERROR, "GDA_XA_TRANSACTION_ALREADY_REGISTERED_ERROR", "already-registered-error" },
      { GDA_XA_TRANSACTION_DTP_NOT_SUPPORTED_ERROR, "GDA_XA_TRANSACTION_DTP_NOT_SUPPORTED_ERROR", "dtp-not-supported-error" },
      { GDA_XA_TRANSACTION_CONNECTION_BRANCH_LENGTH_ERROR, "GDA_XA_TRANSACTION_CONNECTION_BRANCH_LENGTH_ERROR", "connection-branch-length-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaXaTransactionError", values);
  }
  return etype;
}
GType
gda_data_pivot_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_DATA_PIVOT_INTERNAL_ERROR, "GDA_DATA_PIVOT_INTERNAL_ERROR", "internal-error" },
      { GDA_DATA_PIVOT_SOURCE_MODEL_ERROR, "GDA_DATA_PIVOT_SOURCE_MODEL_ERROR", "source-model-error" },
      { GDA_DATA_PIVOT_FIELD_FORMAT_ERROR, "GDA_DATA_PIVOT_FIELD_FORMAT_ERROR", "field-format-error" },
      { GDA_DATA_PIVOT_USAGE_ERROR, "GDA_DATA_PIVOT_USAGE_ERROR", "usage-error" },
      { GDA_DATA_PIVOT_OVERFLOW_ERROR, "GDA_DATA_PIVOT_OVERFLOW_ERROR", "overflow-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaDataPivotError", values);
  }
  return etype;
}
GType
gda_data_pivot_aggregate_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_DATA_PIVOT_AVG, "GDA_DATA_PIVOT_AVG", "avg" },
      { GDA_DATA_PIVOT_COUNT, "GDA_DATA_PIVOT_COUNT", "count" },
      { GDA_DATA_PIVOT_MAX, "GDA_DATA_PIVOT_MAX", "max" },
      { GDA_DATA_PIVOT_MIN, "GDA_DATA_PIVOT_MIN", "min" },
      { GDA_DATA_PIVOT_SUM, "GDA_DATA_PIVOT_SUM", "sum" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaDataPivotAggregate", values);
  }
  return etype;
}
GType
gda_data_pivot_field_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_DATA_PIVOT_FIELD_ROW, "GDA_DATA_PIVOT_FIELD_ROW", "row" },
      { GDA_DATA_PIVOT_FIELD_COLUMN, "GDA_DATA_PIVOT_FIELD_COLUMN", "column" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaDataPivotFieldType", values);
  }
  return etype;
}



