/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import gnu.xml.stream.XMLEventImpl;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;

public class StartElementImpl
extends XMLEventImpl
implements StartElement {
    protected final QName name;
    protected final List attributes;
    protected final List namespaces;
    protected final NamespaceContext namespaceContext;

    protected StartElementImpl(Location location, QName name, List attributes, List namespaces, NamespaceContext namespaceContext) {
        super(location);
        this.name = name;
        this.attributes = attributes;
        this.namespaces = namespaces;
        this.namespaceContext = namespaceContext;
    }

    public int getEventType() {
        return 1;
    }

    public QName getName() {
        return this.name;
    }

    public Iterator getAttributes() {
        return this.attributes.iterator();
    }

    public Iterator getNamespaces() {
        return this.namespaces.iterator();
    }

    public Attribute getAttributeByName(QName name) {
        for (Attribute attr : this.attributes) {
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public String getNamespaceURI(String prefix) {
        return this.namespaceContext.getNamespaceURI(prefix);
    }

    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            writer.write(60);
            String prefix = this.name.getPrefix();
            if (prefix != null && !"".equals(prefix)) {
                writer.write(prefix);
                writer.write(58);
            }
            writer.write(this.name.getLocalPart());
            Iterator i = this.namespaces.iterator();
            while (i.hasNext()) {
                writer.write(32);
                ((Namespace)i.next()).writeAsEncodedUnicode(writer);
            }
            i = this.attributes.iterator();
            while (i.hasNext()) {
                writer.write(32);
                ((Attribute)i.next()).writeAsEncodedUnicode(writer);
            }
            writer.write(62);
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
    }
}

