/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SourcePosition;
import gnu.classpath.tools.gjdoc.DocImpl;

public abstract class ProgramElementDocImpl
extends DocImpl
implements ProgramElementDoc {
    protected ClassDoc containingClass;
    protected PackageDoc containingPackage;
    protected boolean isFinal;
    protected boolean isStatic;
    protected int accessLevel = 2;
    public static final int ACCESS_PUBLIC = 0;
    public static final int ACCESS_PROTECTED = 1;
    public static final int ACCESS_PACKAGEPRIVATE = 2;
    public static final int ACCESS_PRIVATE = 3;
    private static final String[] accessModifiers = new String[]{"public ", "protected ", "", "private "};

    public ProgramElementDocImpl(ClassDoc containingClass, PackageDoc containingPackage, SourcePosition position) {
        super(position);
        this.containingClass = containingClass;
        this.containingPackage = containingPackage;
    }

    public ProgramElementDocImpl(ClassDoc containingClass, SourcePosition position) {
        super(position);
        this.containingClass = containingClass;
        this.containingPackage = containingClass.containingPackage();
    }

    public ProgramElementDocImpl(ClassDoc containingClass, PackageDoc containingPackage, int accessLevel, boolean isFinal, boolean isStatic, SourcePosition position) {
        super(position);
        this.containingClass = containingClass;
        this.containingPackage = containingPackage;
        this.accessLevel = accessLevel;
        this.isFinal = isFinal;
        this.isStatic = isStatic;
    }

    public ClassDoc containingClass() {
        return this.containingClass;
    }

    public PackageDoc containingPackage() {
        return this.containingPackage;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isPackagePrivate() {
        return this.accessLevel == 2;
    }

    public boolean isPrivate() {
        return this.accessLevel == 3;
    }

    public boolean isProtected() {
        return this.accessLevel == 1;
    }

    public boolean isPublic() {
        return this.accessLevel == 0;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String modifiers() {
        return (String.valueOf(accessModifiers[this.accessLevel]) + (this.isStatic() ? "static " : "") + (this.isFinal() ? "final " : "")).trim();
    }

    public int modifierSpecifier() {
        return (this.isStatic() ? 8 : 0) | (this.isFinal() ? 16 : 0) | (this.isPublic() ? 1 : 0) | (this.isProtected() ? 4 : 0) | (this.isPrivate() ? 2 : 0);
    }

    public abstract String qualifiedName();

    protected boolean processModifier(String word) {
        if (word.equals("public")) {
            this.accessLevel = 0;
            return true;
        }
        if (word.equals("protected")) {
            this.accessLevel = 1;
            return true;
        }
        if (word.equals("private")) {
            this.accessLevel = 3;
            return true;
        }
        if (word.equals("static")) {
            this.isStatic = true;
            return true;
        }
        if (word.equals("final")) {
            this.isFinal = true;
            return true;
        }
        return false;
    }

    void setIsStatic(boolean b) {
        this.isStatic = b;
    }
}

