/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.transform;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ErrorListenerErrorHandler
implements ErrorHandler {
    private ErrorListener listener;

    ErrorListenerErrorHandler(ErrorListener listener) {
        this.listener = listener;
    }

    public void warning(SAXParseException e) throws SAXException {
        try {
            this.listener.warning(new TransformerException(e));
        }
        catch (TransformerException te) {
            throw this.getSAXException(te);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        try {
            this.listener.error(new TransformerException(e));
        }
        catch (TransformerException te) {
            throw this.getSAXException(te);
        }
    }

    public void fatalError(SAXParseException e) throws SAXException {
        try {
            this.listener.fatalError(new TransformerException(e));
        }
        catch (TransformerException te) {
            throw this.getSAXException(te);
        }
    }

    private SAXException getSAXException(TransformerException e) {
        Throwable cause = e.getCause();
        if (cause instanceof SAXException) {
            return (SAXException)cause;
        }
        return new SAXException(e);
    }
}

