/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.SignatureAlgorithm;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;

public class Signature
implements Builder,
Constructed {
    private final ByteBuffer buffer;
    private final SignatureAlgorithm alg;

    public Signature(ByteBuffer buffer, SignatureAlgorithm alg) {
        this.buffer = buffer;
        this.alg = alg;
    }

    public Signature(byte[] sigValue, SignatureAlgorithm alg) {
        this.buffer = ByteBuffer.allocate(sigValue.length + 2);
        this.buffer.putShort((short)sigValue.length);
        this.buffer.put(sigValue);
        this.buffer.position(0);
        this.alg = alg;
    }

    public int length() {
        if (this.alg.equals((Object)SignatureAlgorithm.ANONYMOUS)) {
            return 0;
        }
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().limit(this.length());
    }

    public byte[] signature() {
        if (this.alg.equals((Object)SignatureAlgorithm.ANONYMOUS)) {
            return new byte[0];
        }
        int length = this.buffer.getShort(0) & 0xFFFF;
        byte[] buf = new byte[length];
        ((ByteBuffer)this.buffer.duplicate().position(2)).get(buf);
        return buf;
    }

    public void setSignature(byte[] signature) {
        this.setSignature(signature, 0, signature.length);
    }

    public void setSignature(byte[] signature, int offset, int length) {
        if (this.alg.equals((Object)SignatureAlgorithm.ANONYMOUS)) {
            return;
        }
        this.buffer.putShort(0, (short)length);
        this.buffer.position(2);
        this.buffer.put(signature, offset, length);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (!this.alg.equals((Object)SignatureAlgorithm.ANONYMOUS)) {
            String subprefix = "  ";
            if (prefix != null) {
                subprefix = String.valueOf(prefix) + subprefix;
            }
            out.print(Util.hexDump(this.signature(), subprefix));
        }
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} Signature;");
        return str.toString();
    }
}

