/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ServerKeyExchangeParams;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class ServerPSKParameters
implements Builder,
Constructed,
ServerKeyExchangeParams {
    private ByteBuffer buffer;

    public ServerPSKParameters(ByteBuffer buffer) {
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public ServerPSKParameters(String identityHint) {
        Charset utf8 = Charset.forName("UTF-8");
        ByteBuffer identityHintBuffer = utf8.encode(identityHint);
        this.buffer = ByteBuffer.allocate(2 + identityHintBuffer.remaining());
        this.buffer.putShort((short)identityHintBuffer.remaining());
        this.buffer.put(identityHintBuffer);
        this.buffer.rewind();
    }

    public KeyExchangeAlgorithm algorithm() {
        return KeyExchangeAlgorithm.PSK;
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().rewind().limit(this.length());
    }

    public int length() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public String identityHint() {
        Charset utf8 = Charset.forName("UTF-8");
        return utf8.decode((ByteBuffer)this.buffer.duplicate().position(2).limit(this.length())).toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  identity_hint = ");
        out.print(this.identityHint());
        out.println(";");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} ServerPSKParamaters;");
        return str.toString();
    }
}

