/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.gif;

import gnu.javax.imageio.IIOInputStream;
import gnu.javax.imageio.gif.GIFFile;
import gnu.javax.imageio.gif.GIFImageReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class GIFImageReaderSpi
extends ImageReaderSpi {
    static final String vendorName = "GNU";
    static final String version = "0.1";
    static final String readerClassName = "gnu.javax.imageio.gif.GIFImageReader";
    static final String[] names = new String[]{"Compuserve GIF"};
    static final String[] suffixes = new String[]{".gif"};
    static final String[] MIMETypes = new String[]{"image/gif", "image/x-gif"};
    static final String[] writerSpiNames = null;
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName = null;
    static final String nativeStreamMetadataFormatClassName = null;
    static final String[] extraStreamMetadataFormatNames = null;
    static final String[] extraStreamMetadataFormatClassNames = null;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName = null;
    static final String nativeImageMetadataFormatClassName = null;
    static final String[] extraImageMetadataFormatNames = null;
    static final String[] extraImageMetadataFormatClassNames = null;

    public GIFImageReaderSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, new Class[]{ImageInputStream.class, InputStream.class}, writerSpiNames, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    public String getDescription(Locale locale) {
        return "Compuserve GIF";
    }

    public boolean canDecodeInput(Object input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input object cannot be null.");
        }
        if (!(input instanceof ImageInputStream) && !(input instanceof InputStream)) {
            return false;
        }
        InputStream in = input instanceof ImageInputStream ? new IIOInputStream((ImageInputStream)input) : (InputStream)input;
        in.mark(10);
        boolean retval = GIFFile.readSignature(in);
        in.reset();
        return retval;
    }

    public ImageReader createReaderInstance(Object extension) {
        return new GIFImageReader(this);
    }
}

