/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.prng;

import gnu.java.security.jce.prng.SecureRandomAdapter;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.prng.PRNGFactory;
import java.security.SecureRandomSpi;
import java.util.HashMap;

public class ARCFourRandomSpi
extends SecureRandomSpi {
    private IRandom adaptee = PRNGFactory.getInstance("arcfour");
    private boolean virgin = true;

    public byte[] engineGenerateSeed(int numBytes) {
        return SecureRandomAdapter.getSeed(numBytes);
    }

    public void engineNextBytes(byte[] bytes) {
        if (this.virgin) {
            this.engineSetSeed(this.engineGenerateSeed(32));
        }
        try {
            this.adaptee.nextBytes(bytes, 0, bytes.length);
        }
        catch (LimitReachedException limitReachedException) {}
    }

    public void engineSetSeed(byte[] seed) {
        HashMap<String, byte[]> attributes = new HashMap<String, byte[]>();
        attributes.put("gnu.crypto.prng.arcfour.key-material", seed);
        this.adaptee.init(attributes);
        this.virgin = false;
    }
}

