#! /bin/bash

# $Id: build.sh,v 1.13 2007/02/09 12:37:02 jt Exp $

# vim: tabstop=4

# parse arguments
version=$1
port=$2

# constants
pkg=fetchmail

# dir variables
Prefix=/usr
TmpDir=/tmp/$pkg.$$
InstallPrefix=$TmpDir$Prefix

DataDir=$InstallPrefix/share
ManDir=$DataDir/man
DocDir=$DataDir/doc/$pkg-$version
CygDocDir=$DataDir/doc/Cygwin
PatchDir=CYGWIN-PATCHES

# configure
configure --prefix=/usr --datadir=/usr/share --mandir=/usr/share/man \
	--enable-NTLM --with-ssl --enable-fallback=procmail --sysconfdir=/etc

# make
make

# make install
make DESTDIR=$TmpDir install

# strip executables
find $InstallPrefix -name '*.exe' | xargs strip

# copy Cygwin fetchmail README file
mkdir -p $CygDocDir
cp $PatchDir/README $CygDocDir/$pkg-$version.README

# copy fetchmail COPYRIGHT, README, etc. files
TopFiles=(ABOUT-NLS COPYING FAQ FEATURES INSTALL NEWS NOTES OLDNEWS README \
	README.NTLM README.SSL TODO fetchmail-FAQ.html design-notes.html \
	esrs-design-notes.html fetchmail-features.html todo.html)
mkdir -p $DocDir
cp ${TopFiles[*]} $DocDir

# create package
tar -C $TmpDir -cjf $pkg-$version-$port.tar.bz2 usr

# remove temporary directory
rm -fr $TmpDir
