.TH e2fsimage 1 "_DATE_" "_VERSION_" 
.SH NAME
e2fsimage \- create and populate an ext2 filesystem image as non-root user
.SH SYNOPSIS
.B e2fsimage
.RI [ -f\ imgfile ]
.RI [ -d\ rootdir ]
.RI [ -u\ uid ]
.RI [ -g\ gid ]
.RI [ -D\ file ]
.RI [ -U\ file ]
.RI [ -P\ file ]
.RI [ -p ]
.RI [ -v ]
.RI [ -n ]
.RI [ -s\ size ]
.SH DESCRIPTION
.LP
.B e2fsimage
creates an ext2 filesystem image by recursively copying the files from 
the existing directory structure
.I rootdir
to the image-file.

.br
Supported filetypes are: regular files, directorys, hard-links,
soft-links, block special devices, character special devices
and fifos.
Hard links are resolved to result in hard links in the image.
The content (target) of softlinks is copied \*(lq as-is \*(rq and will not be resolved or altered in any way.

.LP
The usual way to create ext2 filesystem images for initial ramdisks,
boot-floppys or bootable CDs is to create an image with eg. 
.LP
.TS
tab (@);
l l.
1@ dd if=/dev/zero of=e2img bs=1024 count=4096
2@ mke2fs -F e2img
3@ mount -o loop e2img mounpoint
4@ cp -r rootdir/* mountpoint
.TE
.LP
At least the last 2 commands must be executed as root.
In order to set the different ownerships (usually root) and to create
the special device files root permissions are also needed.
.LP
Since all this results in a file that may belong to an 
ordinary user, this file can be created and filled with the filesystem
structure by her. This application manages to create such an
image as ordinary user without sudo or suid-root bit set. 
Of course suid-root programs in the filesystem image are possible 
by making them suid-user.
When this files are copied, the user is set to root and there you
have your suid-root program.  
.br
It is also not mandatory to have the rootdir on an ext2 filesystem.

.SH OPTIONS

.TP
.BI \-d\  rootdir
The content of the filesystemimage is a recursive copy of 
.IR rootdir . 
All files are copied while preserving all attributes but the uid/gid.
They will usually be set to 
.IR root.root .
This can be overwritten with the 
.BR -u \ and\  -g
options respectively

.TP
.BI \-D\  devicefile
The devicefile contains all special devices to be created, see
.IR DEVICES .
.br
The default filename is 
.BR .DEVICES .

.TP
.BI \-U\  uidgidfile
The uidgidfile contains the uids and gids different from 0, see
.IR USERS .
.br
The default filename is 
.BR .UIDGID .

.TP
.BI \-P\  passwd
The password file in this parameter is used to convert user names to uids and gids.
It tries to use the default in 
.IR rootdir /etc/passwd,
if it is omitted, 

.TP
.BI \-f\  imgfile
This is the target file for the filesystem image. An existing file will be overwritten as long as 
.B \-n
is not given.

.TP
.BI \-g\  gid
Change the default group id from 0 to
.IR gid .
Until now there is only 1 gid for all files supported.

.TP
.B \-n
This option allows to reuse an existing filesystem image defined by
.B \-f
The existing content is not modified by any means but there
may not exist a file with the same name as a newly created one.

.TP
.B \-p
Preserve original file owner. If this option is omitted all files in the 
image will belong to root. (This is usually what you want)

.TP
.BI \-s\  size
When the filesystem is created the size will be
.I size
Kbytes large. The default is 4096 kilo bytes.

.TP
.BI \-u\  uid
Change the default user-id from 0 to
.IR uid .
Until now there is only 1 uid for all files supported.

.TP
.BI \-v
Be more verbose.

.SH DEVICES
.LP
Usually the devices are created using
.B mknod
by root. Obviously this would absurd the existence of 
.B e2fsimage
to be a non-root tool. A device special file called
.B .DEVICES
can be placed in every directory (usually 
.I dev
) that will contain device special files. The format of this file is:
.LP
.I <name> <type> <major> <minor> 
.RI [ \ <mode>\  [ \ <uid>\  [ \ <gid>\  ]]]
.TP
.B name
the name of the file like 
.I ttyS0
.TP
.B type 
Actually supported are
.IR c , u
for character special devices,
.I b
for block special devices and
.IR p , f
for fifos.
.TP
.BR major\ minor .
This are the major and minor numbers of the device
.TP
.B mode
The access mode for the file like 0644. The default mode for
devices is 0600 if 
.I mode
is omitted.
.TP
.BI uid
The uid of the device, 0 if omitted.
.TP
.BI gid
The gid of the device, 0 if omitted.
.LP
A call to mknod like 
.B mknod -m 0600 ttyS1 c 4 65
would result in a line in
.B dev/.DEVICES 
as "ttyS1 c 4 65 0600"

.SH USERS
.LP
Every directory may contain a file named .UIDGID and can be changed
by the 
.I -U
option. The format of this file is:
.LP
.I <name> <uid> 
.RI [ \ <gid> \ ]
.LP
.I <name> <username> 
.LP
If <name> is ".", then the owner and group information
will be kept recursively for all files and directorys below.
For a "chown 500 /home/user" one would write "user 500" to "home/.UIDGID and have
such a directory "home/user" of course. For a "chown -R 500 /home/user"
one would write a ". 500" to "home/user/.UIDGID".
Userid information given in .UIDGID overrides user info in .DEVICES. 
.LP
If the uid entry is not numeric it will be resolved by using
.IR passwd ,
provided by the option
.IR \-P .
In this case the gid is also taken from 
.IR passwd .

.TP
.B name
is the name of the file.
.TP
.B uid 
is the numeric userid of the file.
.TP
.B gid 
is the numeric groupid of the file. It will be zero if omitted.
.TP
.B username 
is the user name of the file owner, resolved by 
.IR passwd .
.SH BUGS
.LP
Bugs ?

.SH SEE ALSO
.BR mke2fs( 8 )

.SH AUTHOR
.LP
This program was written by 
.br
Christian Hohnstaedt <christian@hohnstaedt.de>
.br
The project homepage is http://www.hohnstaedt.de/e2fsimage
