/* ModifySnippetDialog.c generated by valac 0.30.0, the Vala compiler
 * generated from ModifySnippetDialog.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_MODIFY_SNIPPET_DIALOG (modify_snippet_dialog_get_type ())
#define MODIFY_SNIPPET_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFY_SNIPPET_DIALOG, ModifySnippetDialog))
#define MODIFY_SNIPPET_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFY_SNIPPET_DIALOG, ModifySnippetDialogClass))
#define IS_MODIFY_SNIPPET_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFY_SNIPPET_DIALOG))
#define IS_MODIFY_SNIPPET_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFY_SNIPPET_DIALOG))
#define MODIFY_SNIPPET_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFY_SNIPPET_DIALOG, ModifySnippetDialogClass))

typedef struct _ModifySnippetDialog ModifySnippetDialog;
typedef struct _ModifySnippetDialogClass ModifySnippetDialogClass;
typedef struct _ModifySnippetDialogPrivate ModifySnippetDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SNIPPET_MANAGER (snippet_manager_get_type ())
#define SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNIPPET_MANAGER, SnippetManager))
#define SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNIPPET_MANAGER, SnippetManagerClass))
#define IS_SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNIPPET_MANAGER))
#define IS_SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNIPPET_MANAGER))
#define SNIPPET_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNIPPET_MANAGER, SnippetManagerClass))

typedef struct _SnippetManager SnippetManager;
typedef struct _SnippetManagerClass SnippetManagerClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ModifySnippetDialog {
	GtkDialog parent_instance;
	ModifySnippetDialogPrivate * priv;
};

struct _ModifySnippetDialogClass {
	GtkDialogClass parent_class;
};

struct _ModifySnippetDialogPrivate {
	GtkEntry* key_entry;
	GtkEntry* value_entry;
	GtkLabel* error_label;
	GtkButton* save_button;
	GtkButton* delete_button;
	gchar* old_key;
};


static gpointer modify_snippet_dialog_parent_class = NULL;
extern SnippetManager* corebird_snippet_manager;

GType modify_snippet_dialog_get_type (void) G_GNUC_CONST;
#define MODIFY_SNIPPET_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MODIFY_SNIPPET_DIALOG, ModifySnippetDialogPrivate))
enum  {
	MODIFY_SNIPPET_DIALOG_DUMMY_PROPERTY
};
ModifySnippetDialog* modify_snippet_dialog_new (const gchar* key, const gchar* value);
ModifySnippetDialog* modify_snippet_dialog_construct (GType object_type, const gchar* key, const gchar* value);
static void modify_snippet_dialog_validate_input (ModifySnippetDialog* self);
static void _modify_snippet_dialog_validate_input_gtk_entry_buffer_inserted_text (GtkEntryBuffer* _sender, guint position, const gchar* chars, guint n_chars, gpointer self);
static void _modify_snippet_dialog_validate_input_gtk_entry_buffer_deleted_text (GtkEntryBuffer* _sender, guint position, guint n_chars, gpointer self);
GType snippet_manager_get_type (void) G_GNUC_CONST;
gchar* snippet_manager_get_snippet (SnippetManager* self, const gchar* key);
static void modify_snippet_dialog_save_snippet (ModifySnippetDialog* self);
void snippet_manager_set_snippet (SnippetManager* self, const gchar* old_key, const gchar* key, const gchar* new_value);
void snippet_manager_insert_snippet (SnippetManager* self, const gchar* key, const gchar* value);
static void modify_snippet_dialog_delete_button_clicked_cb (ModifySnippetDialog* self);
void snippet_manager_remove_snippet (SnippetManager* self, const gchar* snippet_key);
static void _modify_snippet_dialog_delete_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void modify_snippet_dialog_real_response (GtkDialog* base, gint response_id);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void modify_snippet_dialog_finalize (GObject* obj);


static void _modify_snippet_dialog_validate_input_gtk_entry_buffer_inserted_text (GtkEntryBuffer* _sender, guint position, const gchar* chars, guint n_chars, gpointer self) {
	modify_snippet_dialog_validate_input ((ModifySnippetDialog*) self);
}


static void _modify_snippet_dialog_validate_input_gtk_entry_buffer_deleted_text (GtkEntryBuffer* _sender, guint position, guint n_chars, gpointer self) {
	modify_snippet_dialog_validate_input ((ModifySnippetDialog*) self);
}


ModifySnippetDialog* modify_snippet_dialog_construct (GType object_type, const gchar* key, const gchar* value) {
	ModifySnippetDialog * self = NULL;
	gint _tmp0_ = 0;
	GtkSettings* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	GtkEntry* _tmp14_ = NULL;
	GtkEntryBuffer* _tmp15_ = NULL;
	GtkEntryBuffer* _tmp16_ = NULL;
	GtkEntry* _tmp17_ = NULL;
	GtkEntryBuffer* _tmp18_ = NULL;
	GtkEntryBuffer* _tmp19_ = NULL;
	GtkEntry* _tmp20_ = NULL;
	GtkEntryBuffer* _tmp21_ = NULL;
	GtkEntryBuffer* _tmp22_ = NULL;
	GtkEntry* _tmp23_ = NULL;
	GtkEntryBuffer* _tmp24_ = NULL;
	GtkEntryBuffer* _tmp25_ = NULL;
	_tmp1_ = gtk_settings_get_default ();
	g_object_get (_tmp1_, "gtk-dialogs-use-header", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	self = (ModifySnippetDialog*) g_object_new (object_type, "use-header-bar", _tmp0_, NULL);
	_tmp4_ = key;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GtkEntry* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GtkEntry* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GtkButton* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp5_ = value;
		_vala_assert (_tmp5_ != NULL, "value != null");
		_tmp6_ = key;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (self->priv->old_key);
		self->priv->old_key = _tmp7_;
		_tmp8_ = self->priv->key_entry;
		_tmp9_ = key;
		gtk_entry_set_text (_tmp8_, _tmp9_);
		_tmp10_ = self->priv->value_entry;
		_tmp11_ = value;
		gtk_entry_set_text (_tmp10_, _tmp11_);
		_tmp12_ = self->priv->delete_button;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
		_tmp13_ = _ ("Modify Snippet");
		gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp13_);
	}
	_tmp14_ = self->priv->key_entry;
	_tmp15_ = gtk_entry_get_buffer (_tmp14_);
	_tmp16_ = _tmp15_;
	g_signal_connect_object (_tmp16_, "inserted-text", (GCallback) _modify_snippet_dialog_validate_input_gtk_entry_buffer_inserted_text, self, 0);
	_tmp17_ = self->priv->key_entry;
	_tmp18_ = gtk_entry_get_buffer (_tmp17_);
	_tmp19_ = _tmp18_;
	g_signal_connect_object (_tmp19_, "deleted-text", (GCallback) _modify_snippet_dialog_validate_input_gtk_entry_buffer_deleted_text, self, 0);
	_tmp20_ = self->priv->value_entry;
	_tmp21_ = gtk_entry_get_buffer (_tmp20_);
	_tmp22_ = _tmp21_;
	g_signal_connect_object (_tmp22_, "inserted-text", (GCallback) _modify_snippet_dialog_validate_input_gtk_entry_buffer_inserted_text, self, 0);
	_tmp23_ = self->priv->value_entry;
	_tmp24_ = gtk_entry_get_buffer (_tmp23_);
	_tmp25_ = _tmp24_;
	g_signal_connect_object (_tmp25_, "deleted-text", (GCallback) _modify_snippet_dialog_validate_input_gtk_entry_buffer_deleted_text, self, 0);
	return self;
}


ModifySnippetDialog* modify_snippet_dialog_new (const gchar* key, const gchar* value) {
	return modify_snippet_dialog_construct (TYPE_MODIFY_SNIPPET_DIALOG, key, value);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void modify_snippet_dialog_validate_input (ModifySnippetDialog* self) {
	gchar* key = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* value = NULL;
	GtkEntry* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GtkEntry* _tmp8_ = NULL;
	GtkStyleContext* _tmp9_ = NULL;
	GtkEntry* _tmp10_ = NULL;
	GtkStyleContext* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkButton* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp20_ = NULL;
	gboolean _tmp26_ = FALSE;
	const gchar* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp36_ = FALSE;
	SnippetManager* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	g_return_if_fail (IS_MODIFY_SNIPPET_DIALOG (self));
	_tmp0_ = self->priv->key_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	key = _tmp3_;
	_tmp4_ = self->priv->value_entry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = string_strip (_tmp6_);
	value = _tmp7_;
	_tmp8_ = self->priv->key_entry;
	_tmp9_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_remove_class (_tmp9_, "error");
	_tmp10_ = self->priv->value_entry;
	_tmp11_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_remove_class (_tmp11_, "error");
	_tmp12_ = self->priv->error_label;
	gtk_label_set_label (_tmp12_, "");
	_tmp13_ = self->priv->save_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp14_ = key;
	if (g_strcmp0 (_tmp14_, "") == 0) {
		GtkLabel* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GtkEntry* _tmp17_ = NULL;
		GtkStyleContext* _tmp18_ = NULL;
		GtkButton* _tmp19_ = NULL;
		_tmp15_ = self->priv->error_label;
		_tmp16_ = _ ("Snippet can't be empty");
		gtk_label_set_label (_tmp15_, _tmp16_);
		_tmp17_ = self->priv->key_entry;
		_tmp18_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp18_, "error");
		_tmp19_ = self->priv->save_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget), FALSE);
		_g_free0 (value);
		_g_free0 (key);
		return;
	}
	_tmp20_ = value;
	if (g_strcmp0 (_tmp20_, "") == 0) {
		GtkLabel* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		GtkEntry* _tmp23_ = NULL;
		GtkStyleContext* _tmp24_ = NULL;
		GtkButton* _tmp25_ = NULL;
		_tmp21_ = self->priv->error_label;
		_tmp22_ = _ ("Replacement can't be empty");
		gtk_label_set_label (_tmp21_, _tmp22_);
		_tmp23_ = self->priv->value_entry;
		_tmp24_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp24_, "error");
		_tmp25_ = self->priv->save_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget), FALSE);
		_g_free0 (value);
		_g_free0 (key);
		return;
	}
	_tmp27_ = key;
	_tmp28_ = string_contains (_tmp27_, " ");
	if (_tmp28_) {
		_tmp26_ = TRUE;
	} else {
		const gchar* _tmp29_ = NULL;
		gboolean _tmp30_ = FALSE;
		_tmp29_ = key;
		_tmp30_ = string_contains (_tmp29_, "\t");
		_tmp26_ = _tmp30_;
	}
	if (_tmp26_) {
		GtkLabel* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		GtkEntry* _tmp33_ = NULL;
		GtkStyleContext* _tmp34_ = NULL;
		GtkButton* _tmp35_ = NULL;
		_tmp31_ = self->priv->error_label;
		_tmp32_ = _ ("Snippet may not contain whitespace");
		gtk_label_set_label (_tmp31_, _tmp32_);
		_tmp33_ = self->priv->key_entry;
		_tmp34_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp34_, "error");
		_tmp35_ = self->priv->save_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget), FALSE);
		_g_free0 (value);
		_g_free0 (key);
		return;
	}
	_tmp37_ = corebird_snippet_manager;
	_tmp38_ = key;
	_tmp39_ = snippet_manager_get_snippet (_tmp37_, _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = _tmp40_ != NULL;
	_g_free0 (_tmp40_);
	if (_tmp41_) {
		const gchar* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		_tmp42_ = self->priv->old_key;
		_tmp43_ = key;
		_tmp36_ = g_strcmp0 (_tmp42_, _tmp43_) != 0;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		GtkLabel* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		GtkButton* _tmp46_ = NULL;
		_tmp44_ = self->priv->error_label;
		_tmp45_ = _ ("Snippet already exists");
		gtk_label_set_label (_tmp44_, _tmp45_);
		_tmp46_ = self->priv->save_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_widget_get_type (), GtkWidget), FALSE);
		_g_free0 (value);
		_g_free0 (key);
		return;
	}
	_g_free0 (value);
	_g_free0 (key);
}


static void modify_snippet_dialog_save_snippet (ModifySnippetDialog* self) {
	gchar* new_value = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* new_key = NULL;
	GtkEntry* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	g_return_if_fail (IS_MODIFY_SNIPPET_DIALOG (self));
	_tmp0_ = self->priv->value_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	new_value = _tmp3_;
	_tmp4_ = self->priv->key_entry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup (_tmp6_);
	new_key = _tmp7_;
	_tmp8_ = self->priv->old_key;
	if (_tmp8_ != NULL) {
		SnippetManager* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp9_ = corebird_snippet_manager;
		_tmp10_ = self->priv->old_key;
		_tmp11_ = new_key;
		_tmp12_ = new_value;
		snippet_manager_set_snippet (_tmp9_, _tmp10_, _tmp11_, _tmp12_);
	} else {
		SnippetManager* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_tmp13_ = corebird_snippet_manager;
		_tmp14_ = new_key;
		_tmp15_ = new_value;
		snippet_manager_insert_snippet (_tmp13_, _tmp14_, _tmp15_);
	}
	_tmp16_ = self->priv->old_key;
	_tmp17_ = new_key;
	_tmp18_ = new_value;
	g_signal_emit_by_name (self, "snippet-updated", _tmp16_, _tmp17_, _tmp18_);
	_g_free0 (new_key);
	_g_free0 (new_value);
}


static void modify_snippet_dialog_delete_button_clicked_cb (ModifySnippetDialog* self) {
	const gchar* _tmp0_ = NULL;
	SnippetManager* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (IS_MODIFY_SNIPPET_DIALOG (self));
	_tmp0_ = self->priv->old_key;
	_vala_assert (_tmp0_ != NULL, "this.old_key != null");
	_tmp1_ = corebird_snippet_manager;
	_tmp2_ = self->priv->old_key;
	snippet_manager_remove_snippet (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->old_key;
	g_signal_emit_by_name (self, "snippet-updated", _tmp3_, NULL, NULL);
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}


static void _modify_snippet_dialog_delete_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	modify_snippet_dialog_delete_button_clicked_cb ((ModifySnippetDialog*) self);
}


static void modify_snippet_dialog_real_response (GtkDialog* base, gint response_id) {
	ModifySnippetDialog * self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MODIFY_SNIPPET_DIALOG, ModifySnippetDialog);
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_CANCEL)) {
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	} else {
		gint _tmp1_ = 0;
		_tmp1_ = response_id;
		if (_tmp1_ == ((gint) GTK_RESPONSE_OK)) {
			modify_snippet_dialog_save_snippet (self);
			gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		}
	}
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static void modify_snippet_dialog_class_init (ModifySnippetDialogClass * klass) {
	gint ModifySnippetDialog_private_offset;
	modify_snippet_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ModifySnippetDialogPrivate));
	((GtkDialogClass *) klass)->response = modify_snippet_dialog_real_response;
	G_OBJECT_CLASS (klass)->finalize = modify_snippet_dialog_finalize;
	ModifySnippetDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/modify-snippet-dialog.ui");
	g_signal_new ("snippet_updated", TYPE_MODIFY_SNIPPET_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "key_entry", FALSE, ModifySnippetDialog_private_offset + G_STRUCT_OFFSET (ModifySnippetDialogPrivate, key_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "value_entry", FALSE, ModifySnippetDialog_private_offset + G_STRUCT_OFFSET (ModifySnippetDialogPrivate, value_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_label", FALSE, ModifySnippetDialog_private_offset + G_STRUCT_OFFSET (ModifySnippetDialogPrivate, error_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "save_button", FALSE, ModifySnippetDialog_private_offset + G_STRUCT_OFFSET (ModifySnippetDialogPrivate, save_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_button", FALSE, ModifySnippetDialog_private_offset + G_STRUCT_OFFSET (ModifySnippetDialogPrivate, delete_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_button_clicked_cb", G_CALLBACK(_modify_snippet_dialog_delete_button_clicked_cb_gtk_button_clicked));
}


static void modify_snippet_dialog_instance_init (ModifySnippetDialog * self) {
	self->priv = MODIFY_SNIPPET_DIALOG_GET_PRIVATE (self);
	self->priv->old_key = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void modify_snippet_dialog_finalize (GObject* obj) {
	ModifySnippetDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MODIFY_SNIPPET_DIALOG, ModifySnippetDialog);
	_g_object_unref0 (self->priv->key_entry);
	_g_object_unref0 (self->priv->value_entry);
	_g_object_unref0 (self->priv->error_label);
	_g_object_unref0 (self->priv->save_button);
	_g_object_unref0 (self->priv->delete_button);
	_g_free0 (self->priv->old_key);
	G_OBJECT_CLASS (modify_snippet_dialog_parent_class)->finalize (obj);
}


GType modify_snippet_dialog_get_type (void) {
	static volatile gsize modify_snippet_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&modify_snippet_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ModifySnippetDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) modify_snippet_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ModifySnippetDialog), 0, (GInstanceInitFunc) modify_snippet_dialog_instance_init, NULL };
		GType modify_snippet_dialog_type_id;
		modify_snippet_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "ModifySnippetDialog", &g_define_type_info, 0);
		g_once_init_leave (&modify_snippet_dialog_type_id__volatile, modify_snippet_dialog_type_id);
	}
	return modify_snippet_dialog_type_id__volatile;
}



