/* ImageCropDialog.c generated by valac 0.30.0, the Vala compiler
 * generated from ImageCropDialog.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_IMAGE_CROP_DIALOG (image_crop_dialog_get_type ())
#define IMAGE_CROP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMAGE_CROP_DIALOG, ImageCropDialog))
#define IMAGE_CROP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_CROP_DIALOG, ImageCropDialogClass))
#define IS_IMAGE_CROP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMAGE_CROP_DIALOG))
#define IS_IMAGE_CROP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_CROP_DIALOG))
#define IMAGE_CROP_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMAGE_CROP_DIALOG, ImageCropDialogClass))

typedef struct _ImageCropDialog ImageCropDialog;
typedef struct _ImageCropDialogClass ImageCropDialogClass;
typedef struct _ImageCropDialogPrivate ImageCropDialogPrivate;

#define TYPE_CROP_WIDGET (crop_widget_get_type ())
#define CROP_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CROP_WIDGET, CropWidget))
#define CROP_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CROP_WIDGET, CropWidgetClass))
#define IS_CROP_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CROP_WIDGET))
#define IS_CROP_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CROP_WIDGET))
#define CROP_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CROP_WIDGET, CropWidgetClass))

typedef struct _CropWidget CropWidget;
typedef struct _CropWidgetClass CropWidgetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ImageCropDialogNextData ImageCropDialogNextData;

struct _ImageCropDialog {
	GtkDialog parent_instance;
	ImageCropDialogPrivate * priv;
	gint min_width;
	gint min_height;
};

struct _ImageCropDialogClass {
	GtkDialogClass parent_class;
};

struct _ImageCropDialogPrivate {
	GtkStack* stack;
	GtkFileChooserWidget* file_chooser;
	CropWidget* crop_widget;
	GtkButton* back_button;
	GtkButton* next_button;
	GtkLabel* error_label;
};

struct _ImageCropDialogNextData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ImageCropDialog* self;
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkFileChooserWidget* _tmp3_;
	gchar* selected_file;
	GtkFileChooserWidget* _tmp4_;
	gchar* _tmp5_;
	GtkStack* _tmp6_;
	CropWidget* _tmp7_;
	GdkPixbuf* image;
	GdkPixbuf* _tmp8_;
	const gchar* _tmp9_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_;
	GdkPixbuf* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GdkPixbuf* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	CropWidget* _tmp21_;
	GdkPixbuf* _tmp22_;
	GtkButton* _tmp23_;
	const gchar* _tmp24_;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_;
	gchar* error_str;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	gint _tmp34_;
	const gchar* _tmp35_;
	gint _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	gint _tmp43_;
	const gchar* _tmp44_;
	gint _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GtkLabel* _tmp49_;
	const gchar* _tmp50_;
	GtkStack* _tmp51_;
	GtkLabel* _tmp52_;
	GtkButton* _tmp53_;
	GtkButton* _tmp54_;
	CropWidget* _tmp55_;
	GdkPixbuf* _tmp56_;
	GdkPixbuf* _tmp57_;
	GError * _inner_error_;
};


static gpointer image_crop_dialog_parent_class = NULL;

GType image_crop_dialog_get_type (void) G_GNUC_CONST;
GType crop_widget_get_type (void) G_GNUC_CONST;
#define IMAGE_CROP_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IMAGE_CROP_DIALOG, ImageCropDialogPrivate))
enum  {
	IMAGE_CROP_DIALOG_DUMMY_PROPERTY
};
ImageCropDialog* image_crop_dialog_new (gdouble aspect_ratio);
ImageCropDialog* image_crop_dialog_construct (GType object_type, gdouble aspect_ratio);
void crop_widget_set_desired_aspect_ratio (CropWidget* self, gdouble value);
static void image_crop_dialog_real_response (GtkDialog* base, gint response_id);
static void image_crop_dialog_next (ImageCropDialog* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void image_crop_dialog_next_finish (ImageCropDialog* self, GAsyncResult* _res_);
static void image_crop_dialog_selection_changed_cb (ImageCropDialog* self);
static void _image_crop_dialog_selection_changed_cb_gtk_file_chooser_selection_changed (GtkFileChooser* _sender, gpointer self);
static void image_crop_dialog_next_data_free (gpointer _data);
static gboolean image_crop_dialog_next_co (ImageCropDialogNextData* _data_);
void crop_widget_set_image (CropWidget* self, GdkPixbuf* image);
GdkPixbuf* crop_widget_get_cropped_image (CropWidget* self);
static void _image_crop_dialog_next_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
void image_crop_dialog_set_min_size (ImageCropDialog* self, gint min_width);
void crop_widget_set_min_size (CropWidget* self, gint min_width);
static void image_crop_dialog_finalize (GObject* obj);


ImageCropDialog* image_crop_dialog_construct (GType object_type, gdouble aspect_ratio) {
	ImageCropDialog * self = NULL;
	gint _tmp0_ = 0;
	GtkSettings* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp4_ = NULL;
	GtkFileChooserWidget* _tmp5_ = NULL;
	CropWidget* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	_tmp1_ = gtk_settings_get_default ();
	g_object_get (_tmp1_, "gtk-dialogs-use-header", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	self = (ImageCropDialog*) g_object_new (object_type, "use-header-bar", _tmp0_, NULL);
	_tmp4_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp4_);
	filter = _tmp4_;
	gtk_file_filter_add_mime_type (filter, "image/png");
	gtk_file_filter_add_mime_type (filter, "image/jpeg");
	_tmp5_ = self->priv->file_chooser;
	gtk_file_chooser_set_filter (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), filter);
	_tmp6_ = self->priv->crop_widget;
	_tmp7_ = aspect_ratio;
	crop_widget_set_desired_aspect_ratio (_tmp6_, _tmp7_);
	_g_object_unref0 (filter);
	return self;
}


ImageCropDialog* image_crop_dialog_new (gdouble aspect_ratio) {
	return image_crop_dialog_construct (TYPE_IMAGE_CROP_DIALOG, aspect_ratio);
}


static void image_crop_dialog_real_response (GtkDialog* base, gint response_id) {
	ImageCropDialog * self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_IMAGE_CROP_DIALOG, ImageCropDialog);
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_CANCEL)) {
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	} else {
		gint _tmp1_ = 0;
		_tmp1_ = response_id;
		if (_tmp1_ == ((gint) GTK_RESPONSE_OK)) {
			image_crop_dialog_next (self, NULL, NULL);
		} else {
			gint _tmp2_ = 0;
			_tmp2_ = response_id;
			if (_tmp2_ == 1) {
				GtkStack* _tmp3_ = NULL;
				GtkFileChooserWidget* _tmp4_ = NULL;
				GtkButton* _tmp5_ = NULL;
				GtkButton* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				_tmp3_ = self->priv->stack;
				_tmp4_ = self->priv->file_chooser;
				gtk_stack_set_visible_child (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
				_tmp5_ = self->priv->back_button;
				gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), FALSE);
				_tmp6_ = self->priv->next_button;
				_tmp7_ = _ ("Next");
				gtk_button_set_label (_tmp6_, _tmp7_);
				image_crop_dialog_selection_changed_cb (self);
			}
		}
	}
}


static void image_crop_dialog_selection_changed_cb (ImageCropDialog* self) {
	gchar* selected_file = NULL;
	GtkFileChooserWidget* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GFile* f = NULL;
	const gchar* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFileType file_type = 0;
	GFile* _tmp5_ = NULL;
	GFileType _tmp6_ = 0;
	GFileType _tmp7_ = 0;
	g_return_if_fail (IS_IMAGE_CROP_DIALOG (self));
	_tmp0_ = self->priv->file_chooser;
	_tmp1_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser));
	selected_file = _tmp1_;
	_tmp2_ = selected_file;
	if (_tmp2_ == NULL) {
		_g_free0 (selected_file);
		return;
	}
	_tmp3_ = selected_file;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	f = _tmp4_;
	_tmp5_ = f;
	_tmp6_ = g_file_query_file_type (_tmp5_, G_FILE_QUERY_INFO_NONE, NULL);
	file_type = _tmp6_;
	_tmp7_ = file_type;
	if (_tmp7_ == G_FILE_TYPE_DIRECTORY) {
		GtkButton* _tmp8_ = NULL;
		_tmp8_ = self->priv->next_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), FALSE);
	} else {
		GtkButton* _tmp9_ = NULL;
		_tmp9_ = self->priv->next_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), TRUE);
	}
	_g_object_unref0 (f);
	_g_free0 (selected_file);
}


static void _image_crop_dialog_selection_changed_cb_gtk_file_chooser_selection_changed (GtkFileChooser* _sender, gpointer self) {
	image_crop_dialog_selection_changed_cb ((ImageCropDialog*) self);
}


static void image_crop_dialog_next_data_free (gpointer _data) {
	ImageCropDialogNextData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ImageCropDialogNextData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void image_crop_dialog_next (ImageCropDialog* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ImageCropDialogNextData* _data_;
	ImageCropDialog* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ImageCropDialogNextData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, image_crop_dialog_next);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, image_crop_dialog_next_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	image_crop_dialog_next_co (_data_);
}


static void image_crop_dialog_next_finish (ImageCropDialog* self, GAsyncResult* _res_) {
	ImageCropDialogNextData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean image_crop_dialog_next_co (ImageCropDialogNextData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->stack;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = gtk_stack_get_visible_child (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->priv->file_chooser;
	if (_data_->_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, gtk_widget_get_type (), GtkWidget)) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->self->priv->file_chooser;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser));
		_data_->selected_file = _data_->_tmp5_;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->self->priv->stack;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->self->priv->crop_widget;
		gtk_stack_set_visible_child (_data_->_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, gtk_widget_get_type (), GtkWidget));
		_data_->image = NULL;
		{
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->selected_file;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = gdk_pixbuf_new_from_file (_data_->_tmp9_, &_data_->_inner_error_);
			_data_->_tmp8_ = _data_->_tmp10_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch113_g_error;
			}
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->_tmp8_;
			_data_->_tmp8_ = NULL;
			_g_object_unref0 (_data_->image);
			_data_->image = _data_->_tmp11_;
			_g_object_unref0 (_data_->_tmp8_);
		}
		goto __finally113;
		__catch113_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->e;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->_tmp12_->message;
			g_warning ("ImageCropDialog.vala:91: %s", _data_->_tmp13_);
			_g_error_free0 (_data_->e);
			_g_object_unref0 (_data_->image);
			_g_free0 (_data_->selected_file);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally113:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->image);
			_g_free0 (_data_->selected_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->image;
		_data_->_tmp16_ = 0;
		_data_->_tmp16_ = gdk_pixbuf_get_width (_data_->_tmp15_);
		_data_->_tmp17_ = 0;
		_data_->_tmp17_ = _data_->self->min_width;
		if (_data_->_tmp16_ >= _data_->_tmp17_) {
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->image;
			_data_->_tmp19_ = 0;
			_data_->_tmp19_ = gdk_pixbuf_get_height (_data_->_tmp18_);
			_data_->_tmp20_ = 0;
			_data_->_tmp20_ = _data_->self->min_height;
			_data_->_tmp14_ = _data_->_tmp19_ >= _data_->_tmp20_;
		} else {
			_data_->_tmp14_ = FALSE;
		}
		if (_data_->_tmp14_) {
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->self->priv->crop_widget;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _data_->image;
			crop_widget_set_image (_data_->_tmp21_, _data_->_tmp22_);
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->self->priv->next_button;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _ ("Save");
			gtk_button_set_label (_data_->_tmp23_, _data_->_tmp24_);
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->self->priv->next_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp25_, gtk_widget_get_type (), GtkWidget), TRUE);
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->self->priv->back_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp26_, gtk_widget_get_type (), GtkWidget), TRUE);
		} else {
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = g_strdup ("");
			_data_->error_str = _data_->_tmp27_;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = _data_->error_str;
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = _ ("Image does not meet minimum size requirements:");
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = g_strconcat (_data_->_tmp29_, "\n", NULL);
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = _data_->_tmp30_;
			_data_->_tmp32_ = NULL;
			_data_->_tmp32_ = g_strconcat (_data_->_tmp28_, _data_->_tmp31_, NULL);
			_g_free0 (_data_->error_str);
			_data_->error_str = _data_->_tmp32_;
			_g_free0 (_data_->_tmp31_);
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = _data_->error_str;
			_data_->_tmp34_ = 0;
			_data_->_tmp34_ = _data_->self->min_width;
			_data_->_tmp35_ = NULL;
			_data_->_tmp35_ = ngettext ("Minimum width: %d pixel", "Minimum width: %d pixels", (gulong) _data_->_tmp34_);
			_data_->_tmp36_ = 0;
			_data_->_tmp36_ = _data_->self->min_width;
			_data_->_tmp37_ = NULL;
			_data_->_tmp37_ = g_strdup_printf (_data_->_tmp35_, _data_->_tmp36_);
			_data_->_tmp38_ = NULL;
			_data_->_tmp38_ = _data_->_tmp37_;
			_data_->_tmp39_ = NULL;
			_data_->_tmp39_ = g_strconcat (_data_->_tmp38_, "\n", NULL);
			_data_->_tmp40_ = NULL;
			_data_->_tmp40_ = _data_->_tmp39_;
			_data_->_tmp41_ = NULL;
			_data_->_tmp41_ = g_strconcat (_data_->_tmp33_, _data_->_tmp40_, NULL);
			_g_free0 (_data_->error_str);
			_data_->error_str = _data_->_tmp41_;
			_g_free0 (_data_->_tmp40_);
			_g_free0 (_data_->_tmp38_);
			_data_->_tmp42_ = NULL;
			_data_->_tmp42_ = _data_->error_str;
			_data_->_tmp43_ = 0;
			_data_->_tmp43_ = _data_->self->min_height;
			_data_->_tmp44_ = NULL;
			_data_->_tmp44_ = ngettext ("Minimum height: %d pixel", "Minimum height: %d pixels", (gulong) _data_->_tmp43_);
			_data_->_tmp45_ = 0;
			_data_->_tmp45_ = _data_->self->min_height;
			_data_->_tmp46_ = NULL;
			_data_->_tmp46_ = g_strdup_printf (_data_->_tmp44_, _data_->_tmp45_);
			_data_->_tmp47_ = NULL;
			_data_->_tmp47_ = _data_->_tmp46_;
			_data_->_tmp48_ = NULL;
			_data_->_tmp48_ = g_strconcat (_data_->_tmp42_, _data_->_tmp47_, NULL);
			_g_free0 (_data_->error_str);
			_data_->error_str = _data_->_tmp48_;
			_g_free0 (_data_->_tmp47_);
			_data_->_tmp49_ = NULL;
			_data_->_tmp49_ = _data_->self->priv->error_label;
			_data_->_tmp50_ = NULL;
			_data_->_tmp50_ = _data_->error_str;
			gtk_label_set_label (_data_->_tmp49_, _data_->_tmp50_);
			_data_->_tmp51_ = NULL;
			_data_->_tmp51_ = _data_->self->priv->stack;
			_data_->_tmp52_ = NULL;
			_data_->_tmp52_ = _data_->self->priv->error_label;
			gtk_stack_set_visible_child (_data_->_tmp51_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp52_, gtk_widget_get_type (), GtkWidget));
			_data_->_tmp53_ = NULL;
			_data_->_tmp53_ = _data_->self->priv->back_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp53_, gtk_widget_get_type (), GtkWidget), TRUE);
			_data_->_tmp54_ = NULL;
			_data_->_tmp54_ = _data_->self->priv->next_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp54_, gtk_widget_get_type (), GtkWidget), FALSE);
			_g_free0 (_data_->error_str);
		}
		_g_object_unref0 (_data_->image);
		_g_free0 (_data_->selected_file);
	} else {
		_data_->_tmp55_ = NULL;
		_data_->_tmp55_ = _data_->self->priv->crop_widget;
		_data_->_tmp56_ = NULL;
		_data_->_tmp56_ = crop_widget_get_cropped_image (_data_->_tmp55_);
		_data_->_tmp57_ = NULL;
		_data_->_tmp57_ = _data_->_tmp56_;
		g_signal_emit_by_name (_data_->self, "image-cropped", _data_->_tmp57_);
		_g_object_unref0 (_data_->_tmp57_);
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget));
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _image_crop_dialog_next_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
	image_crop_dialog_next ((ImageCropDialog*) self, NULL, NULL);
}


void image_crop_dialog_set_min_size (ImageCropDialog* self, gint min_width) {
	CropWidget* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_if_fail (IS_IMAGE_CROP_DIALOG (self));
	_tmp0_ = self->priv->crop_widget;
	_tmp1_ = min_width;
	crop_widget_set_min_size (_tmp0_, _tmp1_);
}


static void image_crop_dialog_class_init (ImageCropDialogClass * klass) {
	gint ImageCropDialog_private_offset;
	image_crop_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ImageCropDialogPrivate));
	((GtkDialogClass *) klass)->response = image_crop_dialog_real_response;
	G_OBJECT_CLASS (klass)->finalize = image_crop_dialog_finalize;
	ImageCropDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/image-crop-dialog.ui");
	g_signal_new ("image_cropped", TYPE_IMAGE_CROP_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GDK_TYPE_PIXBUF);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ImageCropDialog_private_offset + G_STRUCT_OFFSET (ImageCropDialogPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "file_chooser", FALSE, ImageCropDialog_private_offset + G_STRUCT_OFFSET (ImageCropDialogPrivate, file_chooser));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "crop_widget", FALSE, ImageCropDialog_private_offset + G_STRUCT_OFFSET (ImageCropDialogPrivate, crop_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_button", FALSE, ImageCropDialog_private_offset + G_STRUCT_OFFSET (ImageCropDialogPrivate, back_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "next_button", FALSE, ImageCropDialog_private_offset + G_STRUCT_OFFSET (ImageCropDialogPrivate, next_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_label", FALSE, ImageCropDialog_private_offset + G_STRUCT_OFFSET (ImageCropDialogPrivate, error_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "selection_changed_cb", G_CALLBACK(_image_crop_dialog_selection_changed_cb_gtk_file_chooser_selection_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "next", G_CALLBACK(_image_crop_dialog_next_gtk_file_chooser_file_activated));
}


static void image_crop_dialog_instance_init (ImageCropDialog * self) {
	self->priv = IMAGE_CROP_DIALOG_GET_PRIVATE (self);
	g_type_ensure (TYPE_CROP_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void image_crop_dialog_finalize (GObject* obj) {
	ImageCropDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IMAGE_CROP_DIALOG, ImageCropDialog);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->file_chooser);
	_g_object_unref0 (self->priv->crop_widget);
	_g_object_unref0 (self->priv->back_button);
	_g_object_unref0 (self->priv->next_button);
	_g_object_unref0 (self->priv->error_label);
	G_OBJECT_CLASS (image_crop_dialog_parent_class)->finalize (obj);
}


GType image_crop_dialog_get_type (void) {
	static volatile gsize image_crop_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&image_crop_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ImageCropDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) image_crop_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImageCropDialog), 0, (GInstanceInitFunc) image_crop_dialog_instance_init, NULL };
		GType image_crop_dialog_type_id;
		image_crop_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "ImageCropDialog", &g_define_type_info, 0);
		g_once_init_leave (&image_crop_dialog_type_id__volatile, image_crop_dialog_type_id);
	}
	return image_crop_dialog_type_id__volatile;
}



