/* CompletionTextView.c generated by valac 0.30.0, the Vala compiler
 * generated from CompletionTextView.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>


#define TYPE_COMPLETION_TEXT_VIEW (completion_text_view_get_type ())
#define COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextView))
#define COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))
#define IS_COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_TEXT_VIEW))
#define IS_COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_TEXT_VIEW))
#define COMPLETION_TEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))

typedef struct _CompletionTextView CompletionTextView;
typedef struct _CompletionTextViewClass CompletionTextViewClass;
typedef struct _CompletionTextViewPrivate CompletionTextViewPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SNIPPET_MANAGER (snippet_manager_get_type ())
#define SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNIPPET_MANAGER, SnippetManager))
#define SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNIPPET_MANAGER, SnippetManagerClass))
#define IS_SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNIPPET_MANAGER))
#define IS_SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNIPPET_MANAGER))
#define SNIPPET_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNIPPET_MANAGER, SnippetManagerClass))

typedef struct _SnippetManager SnippetManager;
typedef struct _SnippetManagerClass SnippetManagerClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_USER_INFO (user_info_get_type ())
#define USER_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INFO, UserInfo))
#define USER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_INFO, UserInfoClass))
#define IS_USER_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INFO))
#define IS_USER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_INFO))
#define USER_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_INFO, UserInfoClass))

typedef struct _UserInfo UserInfo;
typedef struct _UserInfoClass UserInfoClass;

#define TYPE_USER_COUNTER (user_counter_get_type ())
#define USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COUNTER, UserCounter))
#define USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COUNTER, UserCounterClass))
#define IS_USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COUNTER))
#define IS_USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COUNTER))
#define USER_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COUNTER, UserCounterClass))

typedef struct _UserCounter UserCounter;
typedef struct _UserCounterClass UserCounterClass;
typedef struct _UserInfoPrivate UserInfoPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CompletionTextView {
	GtkTextView parent_instance;
	CompletionTextViewPrivate * priv;
};

struct _CompletionTextViewClass {
	GtkTextViewClass parent_class;
};

struct _CompletionTextViewPrivate {
	GtkListBox* completion_list;
	GtkWindow* completion_window;
	gint current_match;
	Account* account;
};

struct _UserInfo {
	GObject parent_instance;
	UserInfoPrivate * priv;
	gint64 id;
	gchar* screen_name;
	gchar* name;
	gint score;
	gboolean changed;
};

struct _UserInfoClass {
	GObjectClass parent_class;
};


static gpointer completion_text_view_parent_class = NULL;
extern SnippetManager* corebird_snippet_manager;

GType completion_text_view_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define COMPLETION_TEXT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewPrivate))
enum  {
	COMPLETION_TEXT_VIEW_DUMMY_PROPERTY
};
void completion_text_view_set_account (CompletionTextView* self, Account* account);
static gboolean completion_text_view_insert_snippet (CompletionTextView* self);
static gchar* completion_text_view_get_cursor_word (CompletionTextView* self, GtkTextIter* start_iter, GtkTextIter* end_iter);
GType snippet_manager_get_type (void) G_GNUC_CONST;
gchar* snippet_manager_get_snippet (SnippetManager* self, const gchar* key);
static inline gboolean completion_text_view_snippets_configured (CompletionTextView* self);
gint snippet_manager_n_snippets (SnippetManager* self);
gboolean completion_text_view_key_press_event_cb (CompletionTextView* self, GdkEventKey* evt);
static void completion_text_view_insert_completion (CompletionTextView* self, const gchar* compl);
static void completion_text_view_buffer_changed_cb (CompletionTextView* self);
static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self);
void tweet_utils_annotate_text (GtkTextBuffer* buffer);
static void completion_text_view_show_completion_window (CompletionTextView* self);
static void __lambda59_ (CompletionTextView* self, GtkWidget* w);
static void ___lambda59__gtk_callback (GtkWidget* widget, gpointer self);
static gboolean completion_text_view_completion_window_focus_out_cb (CompletionTextView* self);
static void completion_text_view_update_completion (CompletionTextView* self);
GType user_info_get_type (void) G_GNUC_CONST;
GType user_counter_get_type (void) G_GNUC_CONST;
UserCounter* account_get_user_counter (Account* self);
UserInfo** user_counter_query_by_prefix (UserCounter* self, const gchar* prefix, gint max_results, gint* num_results, int* result_length1);
CompletionTextView* completion_text_view_new (void);
CompletionTextView* completion_text_view_construct (GType object_type);
static GObject * completion_text_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void _completion_text_view_update_completion_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _completion_text_view_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static gboolean _completion_text_view_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void completion_text_view_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void completion_text_view_set_account (CompletionTextView* self, Account* account) {
	Account* _tmp0_ = NULL;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	g_return_if_fail (IS_ACCOUNT (account));
	_tmp0_ = account;
	self->priv->account = _tmp0_;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean completion_text_view_insert_snippet (CompletionTextView* self) {
	gboolean result = FALSE;
	GtkTextIter cursor_word_start = {0};
	GtkTextIter cursor_word_end = {0};
	gchar* cursor_word = NULL;
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gunichar _tmp6_ = 0U;
	gchar* snippet = NULL;
	SnippetManager* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GtkTextIter start_word_iter = {0};
	GtkTextBuffer* _tmp21_ = NULL;
	GtkTextBuffer* _tmp22_ = NULL;
	GtkTextBuffer* _tmp23_ = NULL;
	GtkTextBuffer* _tmp24_ = NULL;
	GtkTextIter _tmp25_ = {0};
	GtkTextIter _tmp26_ = {0};
	GtkTextMark* cursor_mark = NULL;
	GtkTextBuffer* _tmp27_ = NULL;
	GtkTextBuffer* _tmp28_ = NULL;
	GtkTextMark* _tmp29_ = NULL;
	GtkTextMark* _tmp30_ = NULL;
	GtkTextBuffer* _tmp31_ = NULL;
	GtkTextBuffer* _tmp32_ = NULL;
	GtkTextMark* _tmp33_ = NULL;
	GtkTextIter _tmp34_ = {0};
	GtkTextBuffer* _tmp35_ = NULL;
	GtkTextBuffer* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	GtkTextBuffer* _tmp41_ = NULL;
	GtkTextBuffer* _tmp42_ = NULL;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	_tmp2_ = completion_text_view_get_cursor_word (self, &_tmp0_, &_tmp1_);
	cursor_word_start = _tmp0_;
	cursor_word_end = _tmp1_;
	cursor_word = _tmp2_;
	_tmp5_ = cursor_word;
	_tmp6_ = string_get_char (_tmp5_, (glong) 0);
	if (_tmp6_ == ((gunichar) ' ')) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp7_ = NULL;
		gunichar _tmp8_ = 0U;
		_tmp7_ = cursor_word;
		_tmp8_ = string_get_char (_tmp7_, (glong) 0);
		_tmp4_ = _tmp8_ == ((gunichar) '\t');
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp9_ = NULL;
		gunichar _tmp10_ = 0U;
		_tmp9_ = cursor_word;
		_tmp10_ = string_get_char (_tmp9_, (glong) 0);
		_tmp3_ = _tmp10_ == ((gunichar) '\n');
	}
	if (_tmp3_) {
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp11_ = cursor_word;
		_tmp12_ = string_substring (_tmp11_, (glong) 1, (glong) -1);
		_g_free0 (cursor_word);
		cursor_word = _tmp12_;
		gtk_text_iter_forward_char (&cursor_word_start);
	}
	_tmp13_ = corebird_snippet_manager;
	_tmp14_ = cursor_word;
	_tmp15_ = string_strip (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = snippet_manager_get_snippet (_tmp13_, _tmp16_);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	snippet = _tmp18_;
	_tmp19_ = snippet;
	if (_tmp19_ == NULL) {
		const gchar* _tmp20_ = NULL;
		_tmp20_ = cursor_word;
		g_debug ("CompletionTextView.vala:92: No snippet for cursor_word '%s' found.", _tmp20_);
		result = FALSE;
		_g_free0 (snippet);
		_g_free0 (cursor_word);
		return result;
	}
	_tmp21_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp22_ = _tmp21_;
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, G_TYPE_OBJECT, GObject));
	_tmp23_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp24_ = _tmp23_;
	_tmp25_ = cursor_word_start;
	_tmp26_ = cursor_word_end;
	g_signal_emit_by_name (_tmp24_, "delete-range", &_tmp25_, &_tmp26_);
	_tmp27_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp28_ = _tmp27_;
	_tmp29_ = gtk_text_buffer_get_insert (_tmp28_);
	_tmp30_ = _g_object_ref0 (_tmp29_);
	cursor_mark = _tmp30_;
	_tmp31_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp32_ = _tmp31_;
	_tmp33_ = cursor_mark;
	gtk_text_buffer_get_iter_at_mark (_tmp32_, &_tmp34_, _tmp33_);
	start_word_iter = _tmp34_;
	_tmp35_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp36_ = _tmp35_;
	_tmp37_ = snippet;
	_tmp38_ = snippet;
	_tmp39_ = strlen (_tmp38_);
	_tmp40_ = _tmp39_;
	g_signal_emit_by_name (_tmp36_, "insert-text", &start_word_iter, _tmp37_, _tmp40_);
	_tmp41_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp42_ = _tmp41_;
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, G_TYPE_OBJECT, GObject));
	result = TRUE;
	_g_object_unref0 (cursor_mark);
	_g_free0 (snippet);
	_g_free0 (cursor_word);
	return result;
}


static inline gboolean completion_text_view_snippets_configured (CompletionTextView* self) {
	gboolean result = FALSE;
	SnippetManager* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	_tmp0_ = corebird_snippet_manager;
	_tmp1_ = snippet_manager_n_snippets (_tmp0_);
	result = _tmp1_ > 0;
	return result;
}


gboolean completion_text_view_key_press_event_cb (CompletionTextView* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GtkWindow* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gint n_results = 0;
	GtkListBox* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	GList* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	gint _tmp12_ = 0;
	GdkEventKey* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->keyval;
	if (_tmp2_ == ((guint) GDK_KEY_Tab)) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = completion_text_view_snippets_configured (self);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = completion_text_view_insert_snippet (self);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = self->priv->completion_window;
	_tmp6_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = self->priv->completion_list;
	_tmp9_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_container_get_type (), GtkContainer));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_list_length (_tmp10_);
	_tmp12_ = (gint) _tmp11_;
	_g_list_free0 (_tmp10_);
	n_results = _tmp12_;
	_tmp13_ = evt;
	_tmp14_ = _tmp13_->keyval;
	if (_tmp14_ == ((guint) GDK_KEY_Down)) {
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		GtkListBoxRow* row = NULL;
		GtkListBox* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		GtkListBoxRow* _tmp20_ = NULL;
		GtkListBoxRow* _tmp21_ = NULL;
		GtkListBox* _tmp22_ = NULL;
		GtkListBoxRow* _tmp23_ = NULL;
		_tmp15_ = n_results;
		if (_tmp15_ == 0) {
			result = FALSE;
			return result;
		}
		_tmp16_ = self->priv->current_match;
		_tmp17_ = n_results;
		self->priv->current_match = (_tmp16_ + 1) % _tmp17_;
		_tmp18_ = self->priv->completion_list;
		_tmp19_ = self->priv->current_match;
		_tmp20_ = gtk_list_box_get_row_at_index (_tmp18_, _tmp19_);
		_tmp21_ = _g_object_ref0 (_tmp20_);
		row = _tmp21_;
		_tmp22_ = self->priv->completion_list;
		_tmp23_ = row;
		gtk_list_box_select_row (_tmp22_, _tmp23_);
		result = TRUE;
		_g_object_unref0 (row);
		return result;
	} else {
		GdkEventKey* _tmp24_ = NULL;
		guint _tmp25_ = 0U;
		_tmp24_ = evt;
		_tmp25_ = _tmp24_->keyval;
		if (_tmp25_ == ((guint) GDK_KEY_Up)) {
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			GtkListBoxRow* row = NULL;
			GtkListBox* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			GtkListBoxRow* _tmp31_ = NULL;
			GtkListBoxRow* _tmp32_ = NULL;
			GtkListBox* _tmp33_ = NULL;
			GtkListBoxRow* _tmp34_ = NULL;
			_tmp26_ = self->priv->current_match;
			self->priv->current_match = _tmp26_ - 1;
			_tmp27_ = self->priv->current_match;
			if (_tmp27_ < 0) {
				gint _tmp28_ = 0;
				_tmp28_ = n_results;
				self->priv->current_match = _tmp28_ - 1;
			}
			_tmp29_ = self->priv->completion_list;
			_tmp30_ = self->priv->current_match;
			_tmp31_ = gtk_list_box_get_row_at_index (_tmp29_, _tmp30_);
			_tmp32_ = _g_object_ref0 (_tmp31_);
			row = _tmp32_;
			_tmp33_ = self->priv->completion_list;
			_tmp34_ = row;
			gtk_list_box_select_row (_tmp33_, _tmp34_);
			result = TRUE;
			_g_object_unref0 (row);
			return result;
		} else {
			GdkEventKey* _tmp35_ = NULL;
			guint _tmp36_ = 0U;
			_tmp35_ = evt;
			_tmp36_ = _tmp35_->keyval;
			if (_tmp36_ == ((guint) GDK_KEY_Return)) {
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				GtkListBoxRow* row = NULL;
				GtkListBox* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				GtkListBoxRow* _tmp41_ = NULL;
				GtkListBoxRow* _tmp42_ = NULL;
				gchar* compl = NULL;
				GtkListBoxRow* _tmp43_ = NULL;
				GtkWidget* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				gchar* _tmp50_ = NULL;
				GtkWindow* _tmp51_ = NULL;
				_tmp37_ = n_results;
				if (_tmp37_ == 0) {
					result = FALSE;
					return result;
				}
				_tmp38_ = self->priv->current_match;
				if (_tmp38_ == -1) {
					self->priv->current_match = 0;
				}
				_tmp39_ = self->priv->completion_list;
				_tmp40_ = self->priv->current_match;
				_tmp41_ = gtk_list_box_get_row_at_index (_tmp39_, _tmp40_);
				_tmp42_ = _g_object_ref0 (_tmp41_);
				row = _tmp42_;
				_tmp43_ = row;
				_tmp44_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_list_box_row_get_type (), GtkListBoxRow), gtk_bin_get_type (), GtkBin));
				_tmp45_ = gtk_label_get_label (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_label_get_type (), GtkLabel));
				_tmp46_ = _tmp45_;
				_tmp47_ = g_strdup (_tmp46_);
				compl = _tmp47_;
				_tmp48_ = compl;
				_tmp49_ = string_substring (_tmp48_, (glong) 1, (glong) -1);
				_tmp50_ = _tmp49_;
				completion_text_view_insert_completion (self, _tmp50_);
				_g_free0 (_tmp50_);
				self->priv->current_match = -1;
				_tmp51_ = self->priv->completion_window;
				gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_widget_get_type (), GtkWidget));
				result = TRUE;
				_g_free0 (compl);
				_g_object_unref0 (row);
				return result;
			} else {
				GdkEventKey* _tmp52_ = NULL;
				guint _tmp53_ = 0U;
				_tmp52_ = evt;
				_tmp53_ = _tmp52_->keyval;
				if (_tmp53_ == ((guint) GDK_KEY_Escape)) {
					GtkWindow* _tmp54_ = NULL;
					_tmp54_ = self->priv->completion_window;
					gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_widget_get_type (), GtkWidget));
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self) {
	GtkTextIter* dup;
	dup = g_new0 (GtkTextIter, 1);
	memcpy (dup, self, sizeof (GtkTextIter));
	return dup;
}


static gpointer __gtk_text_iter_dup0 (gpointer self) {
	return self ? _gtk_text_iter_dup (self) : NULL;
}


static void completion_text_view_buffer_changed_cb (CompletionTextView* self) {
	GtkTextIter* start_iter = NULL;
	GtkTextIter* end_iter = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_ = {0};
	GtkTextIter* _tmp9_ = NULL;
	GtkTextBuffer* _tmp10_ = NULL;
	GtkTextBuffer* _tmp11_ = NULL;
	GtkTextIter _tmp12_ = {0};
	GtkTextIter _tmp13_ = {0};
	GtkTextBuffer* _tmp14_ = NULL;
	GtkTextBuffer* _tmp15_ = NULL;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	_tmp0_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_start_iter (_tmp1_, &_tmp2_);
	_g_free0 (start_iter);
	_tmp3_ = _tmp2_;
	_tmp4_ = __gtk_text_iter_dup0 (&_tmp3_);
	start_iter = _tmp4_;
	_tmp5_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp6_ = _tmp5_;
	gtk_text_buffer_get_end_iter (_tmp6_, &_tmp7_);
	_g_free0 (end_iter);
	_tmp8_ = _tmp7_;
	_tmp9_ = __gtk_text_iter_dup0 (&_tmp8_);
	end_iter = _tmp9_;
	_tmp10_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp11_ = _tmp10_;
	_tmp12_ = *start_iter;
	_tmp13_ = *end_iter;
	gtk_text_buffer_remove_all_tags (_tmp11_, &_tmp12_, &_tmp13_);
	_tmp14_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp15_ = _tmp14_;
	tweet_utils_annotate_text (_tmp15_);
	_g_free0 (end_iter);
	_g_free0 (start_iter);
}


static void __lambda59_ (CompletionTextView* self, GtkWidget* w) {
	GtkListBox* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = self->priv->completion_list;
	_tmp1_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), _tmp1_);
}


static void ___lambda59__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda59_ ((CompletionTextView*) self, widget);
}


static void completion_text_view_show_completion_window (CompletionTextView* self) {
	gboolean _tmp0_ = FALSE;
	gint x = 0;
	gint y = 0;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp1_ = {0};
	GdkWindow* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	GtkWindow* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GtkWindow* _tmp11_ = NULL;
	GtkAllocation _tmp12_ = {0};
	gint _tmp13_ = 0;
	GtkListBox* _tmp14_ = NULL;
	GtkWindow* _tmp15_ = NULL;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	g_debug ("CompletionTextView.vala:173: show_completion_window");
	_tmp0_ = gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (!_tmp0_) {
		return;
	}
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp1_);
	alloc = _tmp1_;
	_tmp2_ = gtk_text_view_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), GTK_TEXT_WINDOW_WIDGET);
	gdk_window_get_origin (_tmp2_, &_tmp3_, &_tmp4_);
	x = _tmp3_;
	y = _tmp4_;
	_tmp5_ = y;
	_tmp6_ = alloc;
	_tmp7_ = _tmp6_.height;
	y = _tmp5_ + _tmp7_;
	_tmp8_ = self->priv->completion_window;
	_tmp9_ = x;
	_tmp10_ = y;
	gtk_window_move (_tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = self->priv->completion_window;
	_tmp12_ = alloc;
	_tmp13_ = _tmp12_.width;
	gtk_window_resize (_tmp11_, _tmp13_, 50);
	_tmp14_ = self->priv->completion_list;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_container_get_type (), GtkContainer), ___lambda59__gtk_callback, self);
	_tmp15_ = self->priv->completion_window;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
}


static gboolean completion_text_view_completion_window_focus_out_cb (CompletionTextView* self) {
	gboolean result = FALSE;
	GtkWindow* _tmp0_ = NULL;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	_tmp0_ = self->priv->completion_window;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	result = FALSE;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void completion_text_view_update_completion (CompletionTextView* self) {
	gchar* cur_word = NULL;
	gchar* _tmp0_ = NULL;
	gchar end_char = '\0';
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar _tmp4_ = '\0';
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gchar _tmp8_ = '\0';
	gboolean _tmp9_ = FALSE;
	gboolean word_has_alpha_end = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gint corpus_size = 0;
	UserInfo** corpus = NULL;
	Account* _tmp27_ = NULL;
	UserCounter* _tmp28_ = NULL;
	UserCounter* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	UserInfo** _tmp33_ = NULL;
	gint corpus_length1 = 0;
	gint _corpus_size_ = 0;
	gint _tmp49_ = 0;
	GtkListBox* _tmp53_ = NULL;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	_tmp0_ = completion_text_view_get_cursor_word (self, NULL, NULL);
	cur_word = _tmp0_;
	_tmp1_ = cur_word;
	_tmp2_ = cur_word;
	_tmp3_ = g_utf8_strlen (_tmp2_, (gssize) -1);
	_tmp4_ = string_get (_tmp1_, (glong) (_tmp3_ - 1));
	end_char = _tmp4_;
	_tmp8_ = end_char;
	_tmp9_ = g_ascii_isalpha (_tmp8_);
	if (_tmp9_) {
		_tmp7_ = TRUE;
	} else {
		gchar _tmp10_ = '\0';
		gboolean _tmp11_ = FALSE;
		_tmp10_ = end_char;
		_tmp11_ = g_ascii_isdigit (_tmp10_);
		_tmp7_ = _tmp11_;
	}
	if (_tmp7_) {
		gchar _tmp12_ = '\0';
		gboolean _tmp13_ = FALSE;
		_tmp12_ = end_char;
		_tmp13_ = g_ascii_isgraph (_tmp12_);
		_tmp6_ = _tmp13_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		gchar _tmp14_ = '\0';
		_tmp14_ = end_char;
		_tmp5_ = _tmp14_ == '@';
	}
	word_has_alpha_end = _tmp5_;
	_tmp17_ = cur_word;
	_tmp18_ = g_str_has_prefix (_tmp17_, "@");
	if (!_tmp18_) {
		_tmp16_ = TRUE;
	} else {
		gboolean _tmp19_ = FALSE;
		_tmp19_ = word_has_alpha_end;
		_tmp16_ = !_tmp19_;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		GtkTextBuffer* _tmp20_ = NULL;
		GtkTextBuffer* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		_tmp20_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
		_tmp21_ = _tmp20_;
		_tmp22_ = gtk_text_buffer_get_has_selection (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp15_ = _tmp23_;
	}
	if (_tmp15_) {
		GtkWindow* _tmp24_ = NULL;
		_tmp24_ = self->priv->completion_window;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
		_g_free0 (cur_word);
		return;
	}
	completion_text_view_show_completion_window (self);
	_tmp25_ = cur_word;
	_tmp26_ = string_substring (_tmp25_, (glong) 1, (glong) -1);
	_g_free0 (cur_word);
	cur_word = _tmp26_;
	corpus_size = 0;
	_tmp27_ = self->priv->account;
	_tmp28_ = account_get_user_counter (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = cur_word;
	_tmp33_ = user_counter_query_by_prefix (_tmp29_, _tmp30_, 10, &_tmp31_, &_tmp32_);
	corpus_size = _tmp31_;
	corpus = _tmp33_;
	corpus_length1 = _tmp32_;
	_corpus_size_ = corpus_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp34_ = FALSE;
			_tmp34_ = TRUE;
			while (TRUE) {
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				GtkLabel* l = NULL;
				UserInfo** _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
				gint _tmp39_ = 0;
				UserInfo* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				GtkLabel* _tmp44_ = NULL;
				GtkLabel* _tmp45_ = NULL;
				GtkLabel* _tmp46_ = NULL;
				GtkListBox* _tmp47_ = NULL;
				GtkLabel* _tmp48_ = NULL;
				if (!_tmp34_) {
					gint _tmp35_ = 0;
					_tmp35_ = i;
					i = _tmp35_ + 1;
				}
				_tmp34_ = FALSE;
				_tmp36_ = i;
				_tmp37_ = corpus_size;
				if (!(_tmp36_ < _tmp37_)) {
					break;
				}
				_tmp38_ = corpus;
				_tmp38__length1 = corpus_length1;
				_tmp39_ = i;
				_tmp40_ = _tmp38_[_tmp39_];
				_tmp41_ = _tmp40_->screen_name;
				_tmp42_ = g_strconcat ("@", _tmp41_, NULL);
				_tmp43_ = _tmp42_;
				_tmp44_ = (GtkLabel*) gtk_label_new (_tmp43_);
				g_object_ref_sink (_tmp44_);
				_tmp45_ = _tmp44_;
				_g_free0 (_tmp43_);
				l = _tmp45_;
				_tmp46_ = l;
				gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
				_tmp47_ = self->priv->completion_list;
				_tmp48_ = l;
				gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (l);
			}
		}
	}
	_tmp49_ = corpus_size;
	if (_tmp49_ > 0) {
		GtkListBox* _tmp50_ = NULL;
		GtkListBox* _tmp51_ = NULL;
		GtkListBoxRow* _tmp52_ = NULL;
		_tmp50_ = self->priv->completion_list;
		_tmp51_ = self->priv->completion_list;
		_tmp52_ = gtk_list_box_get_row_at_index (_tmp51_, 0);
		gtk_list_box_select_row (_tmp50_, _tmp52_);
		self->priv->current_match = 0;
	}
	_tmp53_ = self->priv->completion_list;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_widget_get_type (), GtkWidget));
	corpus = (_vala_array_free (corpus, corpus_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_free0 (cur_word);
}


static gchar* completion_text_view_get_cursor_word (CompletionTextView* self, GtkTextIter* start_iter, GtkTextIter* end_iter) {
	GtkTextIter _vala_start_iter = {0};
	GtkTextIter _vala_end_iter = {0};
	gchar* result = NULL;
	GtkTextMark* cursor_mark = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextMark* _tmp3_ = NULL;
	GtkTextIter cursor_iter = {0};
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextMark* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter test_iter = {0};
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp31_ = {0};
	GtkTextIter _tmp32_ = {0};
	GtkTextIter _tmp33_ = {0};
	GtkTextIter _tmp34_ = {0};
	GtkTextBuffer* _tmp35_ = NULL;
	GtkTextBuffer* _tmp36_ = NULL;
	GtkTextIter _tmp37_ = {0};
	GtkTextIter _tmp38_ = {0};
	gchar* _tmp39_ = NULL;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), NULL);
	_tmp0_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	cursor_mark = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp5_ = _tmp4_;
	_tmp6_ = cursor_mark;
	gtk_text_buffer_get_iter_at_mark (_tmp5_, &_tmp7_, _tmp6_);
	cursor_iter = _tmp7_;
	memset (&test_iter, 0, sizeof (GtkTextIter));
	_tmp8_ = cursor_iter;
	gtk_text_iter_assign (&test_iter, &_tmp8_);
	{
		gboolean _tmp9_ = FALSE;
		_tmp9_ = TRUE;
		while (TRUE) {
			GtkTextIter left_iter = {0};
			GtkTextIter _tmp10_ = {0};
			GtkTextIter _tmp11_ = {0};
			gchar* s = NULL;
			GtkTextBuffer* _tmp12_ = NULL;
			GtkTextBuffer* _tmp13_ = NULL;
			GtkTextIter _tmp14_ = {0};
			GtkTextIter _tmp15_ = {0};
			gchar* _tmp16_ = NULL;
			gunichar c = 0U;
			const gchar* _tmp17_ = NULL;
			gunichar _tmp18_ = 0U;
			gboolean _tmp19_ = FALSE;
			const gchar* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp26_ = FALSE;
			gunichar _tmp27_ = 0U;
			gboolean _tmp28_ = FALSE;
			GtkTextIter _tmp30_ = {0};
			if (!_tmp9_) {
			}
			_tmp9_ = FALSE;
			_tmp10_ = test_iter;
			left_iter = _tmp10_;
			_tmp11_ = test_iter;
			gtk_text_iter_assign (&left_iter, &_tmp11_);
			gtk_text_iter_backward_char (&left_iter);
			_tmp12_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
			_tmp13_ = _tmp12_;
			_tmp14_ = left_iter;
			_tmp15_ = test_iter;
			_tmp16_ = gtk_text_buffer_get_text (_tmp13_, &_tmp14_, &_tmp15_, FALSE);
			s = _tmp16_;
			_tmp17_ = s;
			_tmp18_ = string_get_char (_tmp17_, (glong) 0);
			c = _tmp18_;
			_tmp20_ = s;
			_tmp21_ = g_utf8_strlen (_tmp20_, (gssize) -1);
			if (_tmp21_ == 1) {
				_tmp19_ = TRUE;
			} else {
				const gchar* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				_tmp22_ = s;
				_tmp23_ = g_utf8_strlen (_tmp22_, (gssize) -1);
				_tmp19_ = _tmp23_ == 0;
			}
			_vala_assert (_tmp19_, "s.char_count () == 1 ||               s.char_count () == 0");
			_tmp24_ = gtk_text_iter_is_start (&left_iter);
			if (_tmp24_) {
				GtkTextIter _tmp25_ = {0};
				_tmp25_ = left_iter;
				gtk_text_iter_assign (&test_iter, &_tmp25_);
			}
			_tmp27_ = c;
			_tmp28_ = g_unichar_isspace (_tmp27_);
			if (_tmp28_) {
				_tmp26_ = TRUE;
			} else {
				gboolean _tmp29_ = FALSE;
				_tmp29_ = gtk_text_iter_is_start (&left_iter);
				_tmp26_ = _tmp29_;
			}
			if (_tmp26_) {
				_g_free0 (s);
				break;
			}
			_tmp30_ = left_iter;
			gtk_text_iter_assign (&test_iter, &_tmp30_);
			_g_free0 (s);
		}
	}
	_tmp31_ = test_iter;
	_vala_start_iter = _tmp31_;
	_tmp32_ = test_iter;
	gtk_text_iter_assign (&_vala_start_iter, &_tmp32_);
	_tmp33_ = cursor_iter;
	_vala_end_iter = _tmp33_;
	_tmp34_ = cursor_iter;
	gtk_text_iter_assign (&_vala_end_iter, &_tmp34_);
	_tmp35_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp36_ = _tmp35_;
	_tmp37_ = test_iter;
	_tmp38_ = cursor_iter;
	_tmp39_ = gtk_text_buffer_get_text (_tmp36_, &_tmp37_, &_tmp38_, FALSE);
	result = _tmp39_;
	_g_object_unref0 (cursor_mark);
	if (start_iter) {
		*start_iter = _vala_start_iter;
	}
	if (end_iter) {
		*end_iter = _vala_end_iter;
	}
	return result;
}


static void completion_text_view_insert_completion (CompletionTextView* self, const gchar* compl) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextIter start_word_iter = {0};
	GtkTextIter end_word_iter = {0};
	gchar* word_to_delete = NULL;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	gchar* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_ = {0};
	GtkTextMark* cursor_mark = NULL;
	GtkTextBuffer* _tmp9_ = NULL;
	GtkTextBuffer* _tmp10_ = NULL;
	GtkTextMark* _tmp11_ = NULL;
	GtkTextMark* _tmp12_ = NULL;
	GtkTextBuffer* _tmp13_ = NULL;
	GtkTextBuffer* _tmp14_ = NULL;
	GtkTextIter _tmp15_ = {0};
	GtkTextBuffer* _tmp16_ = NULL;
	GtkTextBuffer* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GtkTextBuffer* _tmp26_ = NULL;
	GtkTextBuffer* _tmp27_ = NULL;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	g_return_if_fail (compl != NULL);
	_tmp0_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp1_ = _tmp0_;
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject));
	_tmp4_ = completion_text_view_get_cursor_word (self, &_tmp2_, &_tmp3_);
	start_word_iter = _tmp2_;
	end_word_iter = _tmp3_;
	word_to_delete = _tmp4_;
	g_debug ("CompletionTextView.vala:273: Delete word: %s", word_to_delete);
	_tmp5_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp6_ = _tmp5_;
	_tmp7_ = start_word_iter;
	_tmp8_ = end_word_iter;
	g_signal_emit_by_name (_tmp6_, "delete-range", &_tmp7_, &_tmp8_);
	_tmp9_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_text_buffer_get_insert (_tmp10_);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	cursor_mark = _tmp12_;
	_tmp13_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp14_ = _tmp13_;
	gtk_text_buffer_get_iter_at_mark (_tmp14_, &_tmp15_, cursor_mark);
	start_word_iter = _tmp15_;
	_tmp16_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp17_ = _tmp16_;
	_tmp18_ = compl;
	_tmp19_ = g_strconcat ("@", _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp20_, " ", NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = compl;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	g_signal_emit_by_name (_tmp17_, "insert-text", &start_word_iter, _tmp22_, _tmp25_ + 2);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_tmp26_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp27_ = _tmp26_;
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, G_TYPE_OBJECT, GObject));
	_g_object_unref0 (cursor_mark);
	_g_free0 (word_to_delete);
}


CompletionTextView* completion_text_view_construct (GType object_type) {
	CompletionTextView * self = NULL;
	self = (CompletionTextView*) g_object_new (object_type, NULL);
	return self;
}


CompletionTextView* completion_text_view_new (void) {
	return completion_text_view_construct (TYPE_COMPLETION_TEXT_VIEW);
}


static gboolean _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = completion_text_view_completion_window_focus_out_cb ((CompletionTextView*) self);
	return result;
}


static void _completion_text_view_update_completion_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	completion_text_view_update_completion ((CompletionTextView*) self);
}


static void _completion_text_view_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	completion_text_view_buffer_changed_cb ((CompletionTextView*) self);
}


static gboolean _completion_text_view_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = completion_text_view_key_press_event_cb ((CompletionTextView*) self, event);
	return result;
}


static GObject * completion_text_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	CompletionTextView * self;
	GtkWindow* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	GdkScreen* _tmp4_ = NULL;
	GtkListBox* _tmp5_ = NULL;
	GtkScrolledWindow* scroller = NULL;
	GtkScrolledWindow* _tmp6_ = NULL;
	GtkScrolledWindow* _tmp7_ = NULL;
	GtkListBox* _tmp8_ = NULL;
	GtkWindow* _tmp9_ = NULL;
	GtkScrolledWindow* _tmp10_ = NULL;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp11_ = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	GdkRGBA link_color = {0};
	GtkStyleContext* _tmp13_ = NULL;
	GdkRGBA _tmp14_ = {0};
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	GdkRGBA _tmp18_ = {0};
	gdouble _tmp19_ = 0.0;
	GtkTextBuffer* _tmp27_ = NULL;
	GtkTextBuffer* _tmp28_ = NULL;
	GdkRGBA _tmp29_ = {0};
	GtkTextBuffer* _tmp30_ = NULL;
	GtkTextBuffer* _tmp31_ = NULL;
	GdkRGBA _tmp32_ = {0};
	GtkTextBuffer* _tmp33_ = NULL;
	GtkTextBuffer* _tmp34_ = NULL;
	GdkRGBA _tmp35_ = {0};
	GtkTextBuffer* _tmp36_ = NULL;
	GtkTextBuffer* _tmp37_ = NULL;
	GtkTextBuffer* _tmp38_ = NULL;
	GtkTextBuffer* _tmp39_ = NULL;
	parent_class = G_OBJECT_CLASS (completion_text_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_TEXT_VIEW, CompletionTextView);
	_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->completion_window);
	self->priv->completion_window = _tmp0_;
	_tmp1_ = self->priv->completion_window;
	gtk_window_set_type_hint (_tmp1_, GDK_WINDOW_TYPE_HINT_COMBO);
	_tmp2_ = self->priv->completion_window;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event, self, 0);
	_tmp3_ = self->priv->completion_window;
	_tmp4_ = gtk_widget_get_screen (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_window_set_screen (_tmp3_, _tmp4_);
	_tmp5_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->completion_list);
	self->priv->completion_list = _tmp5_;
	_tmp6_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp6_);
	scroller = _tmp6_;
	_tmp7_ = scroller;
	_tmp8_ = self->priv->completion_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = self->priv->completion_window;
	_tmp10_ = scroller;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event, self, 0);
	_tmp11_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp12_ = _g_object_ref0 (_tmp11_);
	style_context = _tmp12_;
	_tmp13_ = style_context;
	gtk_style_context_get_color (_tmp13_, GTK_STATE_FLAG_LINK, &_tmp14_);
	link_color = _tmp14_;
	_tmp18_ = link_color;
	_tmp19_ = _tmp18_.red;
	if (_tmp19_ == 1.0) {
		GdkRGBA _tmp20_ = {0};
		gdouble _tmp21_ = 0.0;
		_tmp20_ = link_color;
		_tmp21_ = _tmp20_.green;
		_tmp17_ = _tmp21_ == 1.0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		GdkRGBA _tmp22_ = {0};
		gdouble _tmp23_ = 0.0;
		_tmp22_ = link_color;
		_tmp23_ = _tmp22_.blue;
		_tmp16_ = _tmp23_ == 1.0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		GdkRGBA _tmp24_ = {0};
		gdouble _tmp25_ = 0.0;
		_tmp24_ = link_color;
		_tmp25_ = _tmp24_.alpha;
		_tmp15_ = _tmp25_ == 1.0;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		GdkRGBA _tmp26_ = {0};
		_tmp26_.red = 0.16470;
		_tmp26_.green = 0.462735;
		_tmp26_.blue = 0.77647;
		_tmp26_.alpha = 1.0;
		link_color = _tmp26_;
	}
	_tmp27_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp28_ = _tmp27_;
	_tmp29_ = link_color;
	gtk_text_buffer_create_tag (_tmp28_, "link", "foreground_rgba", &_tmp29_, NULL, NULL);
	_tmp30_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp31_ = _tmp30_;
	_tmp32_ = link_color;
	gtk_text_buffer_create_tag (_tmp31_, "mention", "foreground_rgba", &_tmp32_, NULL, NULL);
	_tmp33_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp34_ = _tmp33_;
	_tmp35_ = link_color;
	gtk_text_buffer_create_tag (_tmp34_, "hashtag", "foreground_rgba", &_tmp35_, NULL, NULL);
	_tmp36_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp37_ = _tmp36_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, G_TYPE_OBJECT, GObject), "notify::cursor-position", (GCallback) _completion_text_view_update_completion_g_object_notify, self, 0);
	_tmp38_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp39_ = _tmp38_;
	g_signal_connect_object (_tmp39_, "changed", (GCallback) _completion_text_view_buffer_changed_cb_gtk_text_buffer_changed, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "key-press-event", (GCallback) _completion_text_view_key_press_event_cb_gtk_widget_key_press_event, self, 0);
	_g_object_unref0 (style_context);
	_g_object_unref0 (scroller);
	return obj;
}


static void completion_text_view_class_init (CompletionTextViewClass * klass) {
	completion_text_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CompletionTextViewPrivate));
	G_OBJECT_CLASS (klass)->constructor = completion_text_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = completion_text_view_finalize;
}


static void completion_text_view_instance_init (CompletionTextView * self) {
	self->priv = COMPLETION_TEXT_VIEW_GET_PRIVATE (self);
	self->priv->current_match = 0;
}


static void completion_text_view_finalize (GObject* obj) {
	CompletionTextView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_TEXT_VIEW, CompletionTextView);
	_g_object_unref0 (self->priv->completion_list);
	_g_object_unref0 (self->priv->completion_window);
	G_OBJECT_CLASS (completion_text_view_parent_class)->finalize (obj);
}


GType completion_text_view_get_type (void) {
	static volatile gsize completion_text_view_type_id__volatile = 0;
	if (g_once_init_enter (&completion_text_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CompletionTextViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_text_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionTextView), 0, (GInstanceInitFunc) completion_text_view_instance_init, NULL };
		GType completion_text_view_type_id;
		completion_text_view_type_id = g_type_register_static (gtk_text_view_get_type (), "CompletionTextView", &g_define_type_info, 0);
		g_once_init_leave (&completion_text_view_type_id__volatile, completion_text_view_type_id);
	}
	return completion_text_view_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



