/* TweetUtils.c generated by valac 0.30.0, the Vala compiler
 * generated from TweetUtils.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libsoup/soup.h>
#include <gtk/gtk.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
typedef struct _Block53Data Block53Data;
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MINI_TWEET (mini_tweet_get_type ())
#define MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINI_TWEET, MiniTweet))
#define MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINI_TWEET, MiniTweetClass))
#define IS_MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINI_TWEET))
#define IS_MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINI_TWEET))
#define MINI_TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINI_TWEET, MiniTweetClass))

typedef struct _MiniTweet MiniTweet;
typedef struct _MiniTweetClass MiniTweetClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TweetUtilsDeleteTweetData TweetUtilsDeleteTweetData;
typedef struct _Block54Data Block54Data;
typedef struct _TweetUtilsReplyToTweetData TweetUtilsReplyToTweetData;
typedef struct _Block55Data Block55Data;
typedef struct _TweetUtilsToggleFavoriteTweetData TweetUtilsToggleFavoriteTweetData;
typedef struct _Block56Data Block56Data;
typedef struct _TweetUtilsToggleRetweetTweetData TweetUtilsToggleRetweetTweetData;
typedef struct _Block57Data Block57Data;
typedef struct _TweetUtilsDownloadAvatarData TweetUtilsDownloadAvatarData;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block58Data Block58Data;
typedef struct _Block59Data Block59Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_USER_COUNTER (user_counter_get_type ())
#define USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COUNTER, UserCounter))
#define USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COUNTER, UserCounterClass))
#define IS_USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COUNTER))
#define IS_USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COUNTER))
#define USER_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COUNTER, UserCounterClass))

typedef struct _UserCounter UserCounter;
typedef struct _UserCounterClass UserCounterClass;

#define TYPE_USER_IDENTITY (user_identity_get_type ())
typedef struct _UserIdentity UserIdentity;
typedef struct _MiniTweetPrivate MiniTweetPrivate;

#define TYPE_TEXT_ENTITY (text_entity_get_type ())
typedef struct _TextEntity TextEntity;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _TweetUtilsWorkArrayData TweetUtilsWorkArrayData;

#define TYPE_MEDIA_DIALOG (media_dialog_get_type ())
#define MEDIA_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_DIALOG, MediaDialog))
#define MEDIA_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_DIALOG, MediaDialogClass))
#define IS_MEDIA_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_DIALOG))
#define IS_MEDIA_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_DIALOG))
#define MEDIA_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_DIALOG, MediaDialogClass))

typedef struct _MediaDialog MediaDialog;
typedef struct _MediaDialogClass MediaDialogClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _Block60Data Block60Data;
typedef struct _TweetUtilsLoadThreadedData TweetUtilsLoadThreadedData;

struct _Block53Data {
	int _ref_count_;
	RestProxyCall* call;
	gpointer _async_data_;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	guint hidden_flags;
	gint64 id;
	MiniTweet* source_tweet;
	MiniTweet* retweeted_tweet;
	MiniTweet* quoted_tweet;
	gchar* avatar_url;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gchar* notification_id;
	gint64 reply_id;
	gint retweet_count;
	gint favorite_count;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _TweetUtilsDeleteTweetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	Tweet* tweet;
	Block53Data* _data53_;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	Tweet* _tmp4_;
	gint64 _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	Tweet* _tmp12_;
	gint64 _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
};

struct _Block54Data {
	int _ref_count_;
	gpointer _async_data_;
};

struct _TweetUtilsReplyToTweetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	Tweet* tweet;
	gchar* text;
	Block54Data* _data54_;
	RestProxyCall* call;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	Tweet* _tmp4_;
	gint64 _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
};

struct _Block55Data {
	int _ref_count_;
	RestProxyCall* call;
	Tweet* tweet;
	gboolean unfavorite;
	gpointer _async_data_;
};

struct _TweetUtilsToggleFavoriteTweetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	Tweet* tweet;
	gboolean unfavorite;
	Block55Data* _data55_;
	Tweet* _tmp0_;
	gboolean _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	OAuthProxy* _tmp4_;
	RestProxyCall* _tmp5_;
	gboolean _tmp6_;
	RestProxyCall* _tmp7_;
	RestProxyCall* _tmp8_;
	RestProxyCall* _tmp9_;
	RestProxyCall* _tmp10_;
	Tweet* _tmp11_;
	gint64 _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	RestProxyCall* _tmp15_;
};

struct _Block56Data {
	int _ref_count_;
	RestProxyCall* call;
	Tweet* tweet;
	gboolean unretweet;
	gpointer _async_data_;
};

struct _TweetUtilsToggleRetweetTweetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	Tweet* tweet;
	gboolean unretweet;
	Block56Data* _data56_;
	Tweet* _tmp0_;
	gboolean _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	OAuthProxy* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	gboolean _tmp7_;
	RestProxyCall* _tmp8_;
	Tweet* _tmp9_;
	gint64 _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	RestProxyCall* _tmp15_;
	Tweet* _tmp16_;
	gint64 _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	RestProxyCall* _tmp22_;
};

struct _Block57Data {
	int _ref_count_;
	GdkPixbuf* avatar;
	GError* err;
	gint size;
	gpointer _async_data_;
};

struct _TweetUtilsDownloadAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* avatar_url;
	gint size;
	GdkPixbuf* result;
	Block57Data* _data57_;
	gint _tmp0_;
	SoupMessage* msg;
	const gchar* _tmp1_;
	SoupMessage* _tmp2_;
	SoupSession* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	GError * _inner_error_;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Block58Data {
	int _ref_count_;
	JsonArray* json_array;
	TweetListBox* tweet_list;
	Account* account;
	gpointer _async_data_;
};

struct _Block59Data {
	int _ref_count_;
	Block58Data * _data58_;
	Tweet** tweet_array;
	gint tweet_array_length1;
	gint _tweet_array_size_;
	GDateTime* now;
	gint index;
};

struct _UserIdentity {
	gint64 id;
	gchar* screen_name;
	gchar* user_name;
};

struct _TextEntity {
	guint from;
	guint to;
	gchar* display_text;
	gchar* tooltip_text;
	gchar* target;
	guint info;
};

struct _MiniTweet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MiniTweetPrivate * priv;
	gint64 id;
	gint64 created_at;
	UserIdentity author;
	gchar* text;
	TextEntity* entities;
	gint entities_length1;
	Media** medias;
	gint medias_length1;
};

struct _MiniTweetClass {
	GTypeClass parent_class;
	void (*finalize) (MiniTweet *self);
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	DeltaUpdater* delta_updater;
	Account* account;
	TweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _TweetUtilsWorkArrayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	JsonArray* json_array;
	TweetListBox* tweet_list;
	MainWindow* main_window;
	Account* account;
	Block58Data* _data58_;
	JsonArray* _tmp0_;
	TweetListBox* _tmp1_;
	Account* _tmp2_;
	GThread* _tmp3_;
	GThread* _tmp4_;
};

struct _Block60Data {
	int _ref_count_;
	JsonNode* _result_;
	GError* err;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	RestProxyCall* call;
	gpointer _async_data_;
};

struct _TweetUtilsLoadThreadedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RestProxyCall* call;
	JsonNode* result;
	Block60Data* _data60_;
	RestProxyCall* _tmp0_;
	GThread* _tmp1_;
	GThread* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	GError* _tmp5_;
	JsonNode* _tmp6_;
	JsonNode* _tmp7_;
	GError * _inner_error_;
};


extern SoupSession* SOUP_SESSION;
extern gint twitter_short_url_length_https;
extern gint twitter_short_url_length;

static void tweet_utils_delete_tweet_data_free (gpointer _data);
GType account_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
void tweet_utils_delete_tweet (Account* account, Tweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_delete_tweet_finish (GAsyncResult* _res_);
static gboolean tweet_utils_delete_tweet_co (TweetUtilsDeleteTweetData* _data_);
static Block53Data* block53_data_ref (Block53Data* _data53_);
static void block53_data_unref (void * _userdata_);
OAuthProxy* account_get_proxy (Account* self);
gpointer mini_tweet_ref (gpointer instance);
void mini_tweet_unref (gpointer instance);
GParamSpec* param_spec_mini_tweet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_mini_tweet (GValue* value, gpointer v_object);
void value_take_mini_tweet (GValue* value, gpointer v_object);
gpointer value_get_mini_tweet (const GValue* value);
GType mini_tweet_get_type (void) G_GNUC_CONST;
static void __lambda214_ (Block53Data* _data53_, GObject* obj, GAsyncResult* res);
static void ___lambda214__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_reply_to_tweet_data_free (gpointer _data);
void tweet_utils_reply_to_tweet (Account* account, Tweet* tweet, const gchar* text, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_reply_to_tweet_finish (GAsyncResult* _res_);
static gboolean tweet_utils_reply_to_tweet_co (TweetUtilsReplyToTweetData* _data_);
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
static void __lambda230_ (Block54Data* _data54_);
static void ___lambda230__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_toggle_favorite_tweet_data_free (gpointer _data);
void tweet_utils_toggle_favorite_tweet (Account* account, Tweet* tweet, gboolean unfavorite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_toggle_favorite_tweet_finish (GAsyncResult* _res_);
static gboolean tweet_utils_toggle_favorite_tweet_co (TweetUtilsToggleFavoriteTweetData* _data_);
static Block55Data* block55_data_ref (Block55Data* _data55_);
static void block55_data_unref (void * _userdata_);
static void __lambda85_ (Block55Data* _data55_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file);
void tweet_set_favorited (Tweet* self, gboolean value);
static void ___lambda85__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_toggle_retweet_tweet_data_free (gpointer _data);
void tweet_utils_toggle_retweet_tweet (Account* account, Tweet* tweet, gboolean unretweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_toggle_retweet_tweet_finish (GAsyncResult* _res_);
static gboolean tweet_utils_toggle_retweet_tweet_co (TweetUtilsToggleRetweetTweetData* _data_);
static Block56Data* block56_data_ref (Block56Data* _data56_);
static void block56_data_unref (void * _userdata_);
static void __lambda87_ (Block56Data* _data56_, GObject* obj, GAsyncResult* res);
void tweet_set_retweeted (Tweet* self, gboolean value);
static void ___lambda87__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_download_avatar_data_free (gpointer _data);
void tweet_utils_download_avatar (const gchar* avatar_url, gint size, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error);
static gboolean tweet_utils_download_avatar_co (TweetUtilsDownloadAvatarData* _data_);
static Block57Data* block57_data_ref (Block57Data* _data57_);
static void block57_data_unref (void * _userdata_);
static void __lambda9_ (Block57Data* _data57_, SoupSession* s, SoupMessage* _msg);
static guint8* _vala_array_dup8 (guint8* self, int length);
static void ___lambda9__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
gint tweet_utils_calc_tweet_length (const gchar* text, gint media_count);
gint tweet_utils_get_word_length (const gchar* s);
GType main_window_get_type (void) G_GNUC_CONST;
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
GType bundle_get_type (void) G_GNUC_CONST;
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
void bundle_put_int (Bundle* self, const gchar* key, gint value);
#define TWEET_INFO_PAGE_BY_ID 2
static void tweet_utils_work_array_data_free (gpointer _data);
GType tweet_list_box_get_type (void) G_GNUC_CONST;
void tweet_utils_work_array (JsonArray* json_array, TweetListBox* tweet_list, MainWindow* main_window, Account* account, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_work_array_finish (GAsyncResult* _res_);
static gboolean tweet_utils_work_array_co (TweetUtilsWorkArrayData* _data_);
static Block58Data* block58_data_ref (Block58Data* _data58_);
static void block58_data_unref (void * _userdata_);
static void* __lambda50_ (Block58Data* _data58_);
static Block59Data* block59_data_ref (Block59Data* _data59_);
static void block59_data_unref (void * _userdata_);
static gboolean ___lambda51_ (Block59Data* _data59_);
static gboolean ____lambda51__gsource_func (gpointer self);
static void __lambda52_ (Block59Data* _data59_, JsonArray* array, guint index, JsonNode* node);
Tweet* tweet_new (void);
Tweet* tweet_construct (GType object_type);
void tweet_load_from_json (Tweet* self, JsonNode* status_node, GDateTime* now, Account* account);
static void ___lambda52__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static gboolean __lambda53_ (Block59Data* _data59_);
GType user_counter_get_type (void) G_GNUC_CONST;
UserCounter* account_get_user_counter (Account* self);
GType user_identity_get_type (void) G_GNUC_CONST;
UserIdentity* user_identity_dup (const UserIdentity* self);
void user_identity_free (UserIdentity* self);
void user_identity_copy (const UserIdentity* self, UserIdentity* dest);
void user_identity_destroy (UserIdentity* self);
void user_counter_id_seen (UserCounter* self, UserIdentity* id);
GType text_entity_get_type (void) G_GNUC_CONST;
TextEntity* text_entity_dup (const TextEntity* self);
void text_entity_free (TextEntity* self);
void text_entity_copy (const TextEntity* self, TextEntity* dest);
void text_entity_destroy (TextEntity* self);
GType media_get_type (void) G_GNUC_CONST;
gboolean account_filter_matches (Account* self, Tweet* t);
#define TWEET_HIDDEN_FILTERED ((guint) (1 << 2))
GType delta_updater_get_type (void) G_GNUC_CONST;
GType tweet_model_get_type (void) G_GNUC_CONST;
void tweet_model_add (TweetModel* self, Tweet* tweet);
static gboolean ___lambda53__gsource_func (gpointer self);
static gpointer ___lambda50__gthread_func (gpointer self);
void tweet_utils_handle_media_click (Tweet* t, MainWindow* window, gint index);
GType media_dialog_get_type (void) G_GNUC_CONST;
MediaDialog* media_dialog_new (Tweet* tweet, gint start_media_index);
MediaDialog* media_dialog_construct (GType object_type, Tweet* tweet, gint start_media_index);
gboolean tweet_utils_is_link (const gchar* word);
gboolean tweet_utils_is_mention (const gchar* word, gint* at_pos);
static gboolean _vala_unichar_array_contains (gunichar* stack, int stack_length, gunichar needle);
gboolean tweet_utils_is_hashtag (const gchar* word);
void tweet_utils_highlight_link (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end);
static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self);
void tweet_utils_highlight_mention (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end);
void tweet_utils_highlight_hashtag (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end);
void tweet_utils_annotate_text (GtkTextBuffer* buffer);
static void _vala_JsonNode_free (JsonNode* self);
static void tweet_utils_load_threaded_data_free (gpointer _data);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error);
static gboolean tweet_utils_load_threaded_co (TweetUtilsLoadThreadedData* _data_);
static Block60Data* block60_data_ref (Block60Data* _data60_);
static void block60_data_unref (void * _userdata_);
static gboolean _tweet_utils_load_threaded_co_gsource_func (gpointer self);
static void* __lambda17_ (Block60Data* _data60_);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static gboolean __lambda18_ (Block60Data* _data60_);
static gboolean ___lambda18__gsource_func (gpointer self);
static gpointer ___lambda17__gthread_func (gpointer self);
void tweet_utils_sort_entities (TextEntity** entities, int* entities_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const gchar* TWEET_UTILS_DOMAINS[24] = {".com", ".net", ".org", ".xxx", ".sexy", ".pro", ".biz", ".name", ".info", ".arpa", ".gov", ".aero", ".asia", ".cat", ".coop", ".edu", ".int", ".jobs", ".mil", ".mobi", ".museum", ".post", ".tel", ".travel"};
const gunichar TWEET_UTILS_non_mention_chars[15] = {8220U, (gunichar) '"', (gunichar) '-', (gunichar) '`', (gunichar) ',', (gunichar) '.', (gunichar) '^', (gunichar) '(', (gunichar) ')', (gunichar) '[', (gunichar) ']', (gunichar) '{', (gunichar) '}', (gunichar) '+', (gunichar) '='};

static void tweet_utils_delete_tweet_data_free (gpointer _data) {
	TweetUtilsDeleteTweetData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->tweet);
	g_slice_free (TweetUtilsDeleteTweetData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void tweet_utils_delete_tweet (Account* account, Tweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsDeleteTweetData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	Tweet* _tmp3_ = NULL;
	_data_ = g_slice_new0 (TweetUtilsDeleteTweetData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_delete_tweet);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_delete_tweet_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	tweet_utils_delete_tweet_co (_data_);
}


void tweet_utils_delete_tweet_finish (GAsyncResult* _res_) {
	TweetUtilsDeleteTweetData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Deletes the given tweet.
   *
   * @param account The account to delete the tweet from
   * @param tweet the tweet to delete
   */
static Block53Data* block53_data_ref (Block53Data* _data53_) {
	g_atomic_int_inc (&_data53_->_ref_count_);
	return _data53_;
}


static void block53_data_unref (void * _userdata_) {
	Block53Data* _data53_;
	_data53_ = (Block53Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data53_->_ref_count_)) {
		_g_object_unref0 (_data53_->call);
		g_slice_free (Block53Data, _data53_);
	}
}


static void __lambda214_ (Block53Data* _data53_, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data53_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch72_g_error;
		}
	}
	goto __finally72;
	__catch72_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("TweetUtils.vala:42: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally72:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_delete_tweet_co (_data53_->_async_data_);
}


static void ___lambda214__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda214_ (self, source_object, res);
	block53_data_unref (self);
}


static gboolean tweet_utils_delete_tweet_co (TweetUtilsDeleteTweetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data53_ = g_slice_new0 (Block53Data);
	_data_->_data53_->_ref_count_ = 1;
	_data_->_data53_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = account_get_proxy (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, rest_proxy_get_type (), RestProxy));
	_data_->_data53_->call = _data_->_tmp3_;
	rest_proxy_call_set_method (_data_->_data53_->call, "POST");
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->tweet;
	_data_->_tmp5_ = 0LL;
	_data_->_tmp5_ = _data_->_tmp4_->id;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp5_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_strconcat ("1.1/statuses/destroy/", _data_->_tmp7_, NULL);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strconcat (_data_->_tmp9_, ".json", NULL);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_;
	rest_proxy_call_set_function (_data_->_data53_->call, _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	_g_free0 (_data_->_tmp9_);
	_g_free0 (_data_->_tmp7_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->tweet;
	_data_->_tmp13_ = 0LL;
	_data_->_tmp13_ = _data_->_tmp12_->id;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp13_);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_tmp14_;
	rest_proxy_call_add_param (_data_->_data53_->call, "id", _data_->_tmp15_);
	_g_free0 (_data_->_tmp15_);
	rest_proxy_call_invoke_async (_data_->_data53_->call, NULL, ___lambda214__gasync_ready_callback, block53_data_ref (_data_->_data53_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block53_data_unref (_data_->_data53_);
	_data_->_data53_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_reply_to_tweet_data_free (gpointer _data) {
	TweetUtilsReplyToTweetData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->tweet);
	_g_free0 (_data_->text);
	g_slice_free (TweetUtilsReplyToTweetData, _data_);
}


void tweet_utils_reply_to_tweet (Account* account, Tweet* tweet, const gchar* text, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsReplyToTweetData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	Tweet* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	_data_ = g_slice_new0 (TweetUtilsReplyToTweetData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_reply_to_tweet);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_reply_to_tweet_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	_tmp4_ = text;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (_data_->text);
	_data_->text = _tmp5_;
	tweet_utils_reply_to_tweet_co (_data_);
}


void tweet_utils_reply_to_tweet_finish (GAsyncResult* _res_) {
	TweetUtilsReplyToTweetData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Replies to the given tweet. This intended for quick/easy replies, without any
   * additional data such as media.
   *
   * @param account The account to reply from
   * @param tweet The tweet to reply to
   * @param text The text to reply
   */
static Block54Data* block54_data_ref (Block54Data* _data54_) {
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}


static void block54_data_unref (void * _userdata_) {
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		g_slice_free (Block54Data, _data54_);
	}
}


static void __lambda230_ (Block54Data* _data54_) {
	tweet_utils_reply_to_tweet_co (_data54_->_async_data_);
}


static void ___lambda230__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda230_ (self);
	block54_data_unref (self);
}


static gboolean tweet_utils_reply_to_tweet_co (TweetUtilsReplyToTweetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data54_ = g_slice_new0 (Block54Data);
	_data_->_data54_->_ref_count_ = 1;
	_data_->_data54_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = account_get_proxy (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp3_;
	rest_proxy_call_set_function (_data_->call, "1.1/statuses/update.json");
	rest_proxy_call_set_method (_data_->call, "POST");
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->tweet;
	_data_->_tmp5_ = 0LL;
	_data_->_tmp5_ = _data_->_tmp4_->id;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp5_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_;
	rest_proxy_call_add_param (_data_->call, "in_reply_to_status_id", _data_->_tmp7_);
	_g_free0 (_data_->_tmp7_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->text;
	rest_proxy_call_add_param (_data_->call, "status", _data_->_tmp8_);
	rest_proxy_call_invoke_async (_data_->call, NULL, ___lambda230__gasync_ready_callback, block54_data_ref (_data_->_data54_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_g_object_unref0 (_data_->call);
	block54_data_unref (_data_->_data54_);
	_data_->_data54_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_toggle_favorite_tweet_data_free (gpointer _data) {
	TweetUtilsToggleFavoriteTweetData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	g_slice_free (TweetUtilsToggleFavoriteTweetData, _data_);
}


void tweet_utils_toggle_favorite_tweet (Account* account, Tweet* tweet, gboolean unfavorite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsToggleFavoriteTweetData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	Tweet* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	_data_ = g_slice_new0 (TweetUtilsToggleFavoriteTweetData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_toggle_favorite_tweet);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_toggle_favorite_tweet_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	_tmp4_ = unfavorite;
	_data_->unfavorite = _tmp4_;
	tweet_utils_toggle_favorite_tweet_co (_data_);
}


void tweet_utils_toggle_favorite_tweet_finish (GAsyncResult* _res_) {
	TweetUtilsToggleFavoriteTweetData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * (Un)favorites the given tweet.
   *
   * @param account The account to (un)favorite from
   * @param tweet The tweet to (un)favorite
   * @param unfavorite If set to true, this function will unfavorite the tiven tweet,
   *                   else it will favorite it.
   */
static Block55Data* block55_data_ref (Block55Data* _data55_) {
	g_atomic_int_inc (&_data55_->_ref_count_);
	return _data55_;
}


static void block55_data_unref (void * _userdata_) {
	Block55Data* _data55_;
	_data55_ = (Block55Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data55_->_ref_count_)) {
		_g_object_unref0 (_data55_->call);
		_g_object_unref0 (_data55_->tweet);
		g_slice_free (Block55Data, _data55_);
	}
}


static void __lambda85_ (Block55Data* _data55_, GObject* obj, GAsyncResult* res) {
	Tweet* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data55_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch73_g_error;
		}
	}
	goto __finally73;
	__catch73_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data55_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		utils_show_error_object (_tmp3_, _tmp5_, 92, "TweetUtils.vala");
		_g_error_free0 (e);
	}
	__finally73:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = _data55_->tweet;
	_tmp7_ = _data55_->unfavorite;
	tweet_set_favorited (_tmp6_, !_tmp7_);
	tweet_utils_toggle_favorite_tweet_co (_data55_->_async_data_);
}


static void ___lambda85__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda85_ (self, source_object, res);
	block55_data_unref (self);
}


static gboolean tweet_utils_toggle_favorite_tweet_co (TweetUtilsToggleFavoriteTweetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data55_ = g_slice_new0 (Block55Data);
	_data_->_data55_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->tweet;
	_g_object_unref0 (_data_->_data55_->tweet);
	_data_->_data55_->tweet = _data_->_tmp0_;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->unfavorite;
	_data_->_data55_->unfavorite = _data_->_tmp1_;
	_data_->_data55_->_async_data_ = _data_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->account;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = account_get_proxy (_data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, rest_proxy_get_type (), RestProxy));
	_data_->_data55_->call = _data_->_tmp5_;
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = _data_->_data55_->unfavorite;
	if (!_data_->_tmp6_) {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_data55_->call;
		rest_proxy_call_set_function (_data_->_tmp7_, "1.1/favorites/create.json");
	} else {
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_data55_->call;
		rest_proxy_call_set_function (_data_->_tmp8_, "1.1/favorites/destroy.json");
	}
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_data55_->call;
	rest_proxy_call_set_method (_data_->_tmp9_, "POST");
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_data55_->call;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_data55_->tweet;
	_data_->_tmp12_ = 0LL;
	_data_->_tmp12_ = _data_->_tmp11_->id;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp12_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->_tmp13_;
	rest_proxy_call_add_param (_data_->_tmp10_, "id", _data_->_tmp14_);
	_g_free0 (_data_->_tmp14_);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_data55_->call;
	rest_proxy_call_invoke_async (_data_->_tmp15_, NULL, ___lambda85__gasync_ready_callback, block55_data_ref (_data_->_data55_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block55_data_unref (_data_->_data55_);
	_data_->_data55_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_toggle_retweet_tweet_data_free (gpointer _data) {
	TweetUtilsToggleRetweetTweetData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	g_slice_free (TweetUtilsToggleRetweetTweetData, _data_);
}


void tweet_utils_toggle_retweet_tweet (Account* account, Tweet* tweet, gboolean unretweet, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsToggleRetweetTweetData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	Tweet* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	_data_ = g_slice_new0 (TweetUtilsToggleRetweetTweetData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_toggle_retweet_tweet);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_toggle_retweet_tweet_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	_tmp4_ = unretweet;
	_data_->unretweet = _tmp4_;
	tweet_utils_toggle_retweet_tweet_co (_data_);
}


void tweet_utils_toggle_retweet_tweet_finish (GAsyncResult* _res_) {
	TweetUtilsToggleRetweetTweetData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * (Un)retweets the given tweet.
   *
   * @param account The account to (un)retweet from
   * @param tweet The tweet to (un)retweet
   * @param unretweet If set to true, this function will delete te retweet of #tweet,
   *                  else it will retweet it.
   */
static Block56Data* block56_data_ref (Block56Data* _data56_) {
	g_atomic_int_inc (&_data56_->_ref_count_);
	return _data56_;
}


static void block56_data_unref (void * _userdata_) {
	Block56Data* _data56_;
	_data56_ = (Block56Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data56_->_ref_count_)) {
		_g_object_unref0 (_data56_->call);
		_g_object_unref0 (_data56_->tweet);
		g_slice_free (Block56Data, _data56_);
	}
}


static void __lambda87_ (Block56Data* _data56_, GObject* obj, GAsyncResult* res) {
	gchar* back = NULL;
	RestProxyCall* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data56_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch74_g_error;
		}
	}
	goto __finally74;
	__catch74_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data56_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		utils_show_error_object (_tmp3_, _tmp5_, 121, "TweetUtils.vala");
		_g_error_free0 (e);
	}
	__finally74:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = _data56_->call;
	_tmp7_ = rest_proxy_call_get_payload (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	back = _tmp8_;
	_tmp9_ = json_parser_new ();
	parser = _tmp9_;
	{
		gboolean _tmp10_ = FALSE;
		Tweet* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		json_parser_load_from_data (parser, back, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch75_g_error;
		}
		_tmp10_ = _data56_->unretweet;
		if (!_tmp10_) {
			gint64 new_id = 0LL;
			JsonNode* _tmp11_ = NULL;
			JsonObject* _tmp12_ = NULL;
			gint64 _tmp13_ = 0LL;
			Tweet* _tmp14_ = NULL;
			gint64 _tmp15_ = 0LL;
			_tmp11_ = json_parser_get_root (parser);
			_tmp12_ = json_node_get_object (_tmp11_);
			_tmp13_ = json_object_get_int_member (_tmp12_, "id");
			new_id = _tmp13_;
			_tmp14_ = _data56_->tweet;
			_tmp15_ = new_id;
			_tmp14_->my_retweet = _tmp15_;
		} else {
			Tweet* _tmp16_ = NULL;
			_tmp16_ = _data56_->tweet;
			_tmp16_->my_retweet = (gint64) 0;
		}
		_tmp17_ = _data56_->tweet;
		_tmp18_ = _data56_->unretweet;
		tweet_set_retweeted (_tmp17_, !_tmp18_);
	}
	goto __finally75;
	__catch75_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_critical ("TweetUtils.vala:135: %s", _tmp20_);
		g_critical ("TweetUtils.vala:136: %s", back);
		_g_error_free0 (e);
	}
	__finally75:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		_g_free0 (back);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_toggle_retweet_tweet_co (_data56_->_async_data_);
	_g_object_unref0 (parser);
	_g_free0 (back);
}


static void ___lambda87__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda87_ (self, source_object, res);
	block56_data_unref (self);
}


static gboolean tweet_utils_toggle_retweet_tweet_co (TweetUtilsToggleRetweetTweetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data56_ = g_slice_new0 (Block56Data);
	_data_->_data56_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->tweet;
	_g_object_unref0 (_data_->_data56_->tweet);
	_data_->_data56_->tweet = _data_->_tmp0_;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->unretweet;
	_data_->_data56_->unretweet = _data_->_tmp1_;
	_data_->_data56_->_async_data_ = _data_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->account;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = account_get_proxy (_data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, rest_proxy_get_type (), RestProxy));
	_data_->_data56_->call = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_data56_->call;
	rest_proxy_call_set_method (_data_->_tmp6_, "POST");
	_data_->_tmp7_ = FALSE;
	_data_->_tmp7_ = _data_->_data56_->unretweet;
	if (!_data_->_tmp7_) {
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_data56_->call;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_data56_->tweet;
		_data_->_tmp10_ = 0LL;
		_data_->_tmp10_ = _data_->_tmp9_->id;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp10_);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = g_strconcat ("1.1/statuses/retweet/", _data_->_tmp12_, ".json", NULL);
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_tmp13_;
		rest_proxy_call_set_function (_data_->_tmp8_, _data_->_tmp14_);
		_g_free0 (_data_->_tmp14_);
		_g_free0 (_data_->_tmp12_);
	} else {
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_data56_->call;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->_data56_->tweet;
		_data_->_tmp17_ = 0LL;
		_data_->_tmp17_ = _data_->_tmp16_->my_retweet;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp17_);
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = g_strconcat ("1.1/statuses/destroy/", _data_->_tmp19_, ".json", NULL);
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->_tmp20_;
		rest_proxy_call_set_function (_data_->_tmp15_, _data_->_tmp21_);
		_g_free0 (_data_->_tmp21_);
		_g_free0 (_data_->_tmp19_);
	}
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->_data56_->call;
	rest_proxy_call_invoke_async (_data_->_tmp22_, NULL, ___lambda87__gasync_ready_callback, block56_data_ref (_data_->_data56_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block56_data_unref (_data_->_data56_);
	_data_->_data56_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_download_avatar_data_free (gpointer _data) {
	TweetUtilsDownloadAvatarData* _data_;
	_data_ = _data;
	_g_free0 (_data_->avatar_url);
	_g_object_unref0 (_data_->result);
	g_slice_free (TweetUtilsDownloadAvatarData, _data_);
}


void tweet_utils_download_avatar (const gchar* avatar_url, gint size, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsDownloadAvatarData* _data_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	_data_ = g_slice_new0 (TweetUtilsDownloadAvatarData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_download_avatar);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_download_avatar_data_free);
	_tmp0_ = avatar_url;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->avatar_url);
	_data_->avatar_url = _tmp1_;
	_tmp2_ = size;
	_data_->size = _tmp2_;
	tweet_utils_download_avatar_co (_data_);
}


GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error) {
	GdkPixbuf* result;
	TweetUtilsDownloadAvatarData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Downloads the avatar from the given url.
   *
   * @param avatar_url The avatar url to download
   *
   * @return The loaded avatar.
   */
static Block57Data* block57_data_ref (Block57Data* _data57_) {
	g_atomic_int_inc (&_data57_->_ref_count_);
	return _data57_;
}


static void block57_data_unref (void * _userdata_) {
	Block57Data* _data57_;
	_data57_ = (Block57Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data57_->_ref_count_)) {
		_g_error_free0 (_data57_->err);
		_g_object_unref0 (_data57_->avatar);
		g_slice_free (Block57Data, _data57_);
	}
}


static guint8* _vala_array_dup8 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void __lambda9_ (Block57Data* _data57_, SoupSession* s, SoupMessage* _msg) {
	GMemoryInputStream* memory_stream = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageBody* _tmp1_ = NULL;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GMemoryInputStream* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (SOUP_IS_SESSION (s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _msg;
	_tmp1_ = _tmp0_->response_body;
	_tmp2_ = _tmp1_->data;
	_tmp2__length1 = (gint) _tmp1_->length;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup8 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	_tmp4_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp3_, _tmp3__length1, NULL);
	memory_stream = _tmp4_;
	{
		GdkPixbuf* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		GdkPixbuf* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_ = NULL;
		_tmp6_ = _data57_->size;
		_tmp7_ = _data57_->size;
		_tmp8_ = gdk_pixbuf_new_from_stream_at_scale (G_TYPE_CHECK_INSTANCE_CAST (memory_stream, G_TYPE_INPUT_STREAM, GInputStream), _tmp6_, _tmp7_, FALSE, NULL, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch76_g_error;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (_data57_->avatar);
		_data57_->avatar = _tmp9_;
		_g_object_unref0 (_tmp5_);
	}
	goto __finally76;
	__catch76_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _g_error_copy0 (_tmp10_);
		_g_error_free0 (_data57_->err);
		_data57_->err = _tmp11_;
		_g_error_free0 (e);
	}
	__finally76:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (memory_stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_download_avatar_co (_data57_->_async_data_);
	_g_object_unref0 (memory_stream);
}


static void ___lambda9__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda9_ (self, session, msg);
	block57_data_unref (self);
}


static gboolean tweet_utils_download_avatar_co (TweetUtilsDownloadAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data57_ = g_slice_new0 (Block57Data);
	_data_->_data57_->_ref_count_ = 1;
	_data_->_tmp0_ = 0;
	_data_->_tmp0_ = _data_->size;
	_data_->_data57_->size = _data_->_tmp0_;
	_data_->_data57_->_async_data_ = _data_;
	_data_->_data57_->avatar = NULL;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->avatar_url;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = soup_message_new ("GET", _data_->_tmp1_);
	_data_->msg = _data_->_tmp2_;
	_data_->_data57_->err = NULL;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = SOUP_SESSION;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->msg;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
	soup_session_queue_message (_data_->_tmp3_, _data_->_tmp5_, ___lambda9__soup_session_callback, block57_data_ref (_data_->_data57_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_data57_->err;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_data57_->err;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _g_error_copy0 (_data_->_tmp7_);
		_data_->_inner_error_ = _data_->_tmp8_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->msg);
		block57_data_unref (_data_->_data57_);
		_data_->_data57_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_data57_->avatar;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
	_data_->result = _data_->_tmp10_;
	_g_object_unref0 (_data_->msg);
	block57_data_unref (_data_->_data57_);
	_data_->_data57_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->msg);
	block57_data_unref (_data_->_data57_);
	_data_->_data57_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Calculates the length of a tweet.
   * See https://dev.twitter.com/docs/faq#5810 for details
   *
   * @param text The text to calculate the length for
   *
   * @return The length of the tweet, taking Twitter's rules for
   *         tweet length into account.
   */
gint tweet_utils_calc_tweet_length (const gchar* text, gint media_count) {
	gint result = 0;
	gchar** words = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint words_length1 = 0;
	gint _words_size_ = 0;
	gint length = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp15_ = 0;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp17_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	g_return_val_if_fail (text != NULL, 0);
	_tmp0_ = text;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, " ", 0);
	words = _tmp2_;
	words_length1 = _vala_array_length (_tmp1_);
	_words_size_ = words_length1;
	length = 0;
	_tmp3_ = words;
	_tmp3__length1 = words_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp3_;
		s_collection_length1 = _tmp3__length1;
		for (s_it = 0; s_it < _tmp3__length1; s_it = s_it + 1) {
			gchar* _tmp4_ = NULL;
			gchar* s = NULL;
			_tmp4_ = g_strdup (s_collection[s_it]);
			s = _tmp4_;
			{
				gchar** subwords = NULL;
				const gchar* _tmp5_ = NULL;
				gchar** _tmp6_ = NULL;
				gchar** _tmp7_ = NULL;
				gint subwords_length1 = 0;
				gint _subwords_size_ = 0;
				gchar** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp13_ = 0;
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				_tmp5_ = s;
				_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
				subwords = _tmp7_;
				subwords_length1 = _vala_array_length (_tmp6_);
				_subwords_size_ = subwords_length1;
				_tmp8_ = subwords;
				_tmp8__length1 = subwords_length1;
				{
					gchar** sw_collection = NULL;
					gint sw_collection_length1 = 0;
					gint _sw_collection_size_ = 0;
					gint sw_it = 0;
					sw_collection = _tmp8_;
					sw_collection_length1 = _tmp8__length1;
					for (sw_it = 0; sw_it < _tmp8__length1; sw_it = sw_it + 1) {
						gchar* _tmp9_ = NULL;
						gchar* sw = NULL;
						_tmp9_ = g_strdup (sw_collection[sw_it]);
						sw = _tmp9_;
						{
							gint _tmp10_ = 0;
							const gchar* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							_tmp10_ = length;
							_tmp11_ = sw;
							_tmp12_ = tweet_utils_get_word_length (_tmp11_);
							length = _tmp10_ + _tmp12_;
							_g_free0 (sw);
						}
					}
				}
				_tmp13_ = length;
				_tmp14_ = subwords;
				_tmp14__length1 = subwords_length1;
				length = _tmp13_ + (_tmp14__length1 - 1);
				subwords = (_vala_array_free (subwords, subwords_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (s);
			}
		}
	}
	_tmp15_ = length;
	_tmp16_ = words;
	_tmp16__length1 = words_length1;
	length = _tmp15_ + (_tmp16__length1 - 1);
	_tmp17_ = length;
	if (_tmp17_ < 0) {
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		_tmp18_ = twitter_short_url_length_https;
		_tmp19_ = media_count;
		result = _tmp18_ * _tmp19_;
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp20_ = length;
	_tmp21_ = twitter_short_url_length_https;
	_tmp22_ = media_count;
	length = _tmp20_ + (_tmp21_ * _tmp22_);
	result = length;
	words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gint tweet_utils_get_word_length (const gchar* s) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	g_return_val_if_fail (s != NULL, 0);
	_tmp1_ = s;
	_tmp2_ = g_str_has_prefix (_tmp1_, "www.");
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = s;
		_tmp4_ = g_str_has_prefix (_tmp3_, "http://");
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		gint _tmp5_ = 0;
		_tmp5_ = twitter_short_url_length;
		result = _tmp5_;
		return result;
	}
	_tmp6_ = s;
	_tmp7_ = g_str_has_prefix (_tmp6_, "https://");
	if (_tmp7_) {
		gint _tmp8_ = 0;
		_tmp8_ = twitter_short_url_length_https;
		result = _tmp8_;
		return result;
	}
	{
		const gchar** tld_collection = NULL;
		gint tld_collection_length1 = 0;
		gint _tld_collection_size_ = 0;
		gint tld_it = 0;
		tld_collection = TWEET_UTILS_DOMAINS;
		tld_collection_length1 = G_N_ELEMENTS (TWEET_UTILS_DOMAINS);
		for (tld_it = 0; tld_it < G_N_ELEMENTS (TWEET_UTILS_DOMAINS); tld_it = tld_it + 1) {
			gchar* _tmp9_ = NULL;
			gchar* tld = NULL;
			_tmp9_ = g_strdup (tld_collection[tld_it]);
			tld = _tmp9_;
			{
				gchar** parts = NULL;
				const gchar* _tmp10_ = NULL;
				gchar** _tmp11_ = NULL;
				gchar** _tmp12_ = NULL;
				gint parts_length1 = 0;
				gint _parts_size_ = 0;
				gboolean _tmp13_ = FALSE;
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				_tmp10_ = s;
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "/", 0);
				parts = _tmp12_;
				parts_length1 = _vala_array_length (_tmp11_);
				_parts_size_ = parts_length1;
				_tmp14_ = parts;
				_tmp14__length1 = parts_length1;
				if (_tmp14__length1 > 0) {
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					_tmp15_ = parts;
					_tmp15__length1 = parts_length1;
					_tmp16_ = _tmp15_[0];
					_tmp17_ = tld;
					_tmp18_ = g_str_has_suffix (_tmp16_, _tmp17_);
					_tmp13_ = _tmp18_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					gint _tmp19_ = 0;
					_tmp19_ = twitter_short_url_length;
					result = _tmp19_;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (tld);
					return result;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (tld);
			}
		}
	}
	_tmp20_ = s;
	_tmp21_ = g_utf8_strlen (_tmp20_, (gssize) -1);
	result = _tmp21_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* term = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (uri != NULL, FALSE);
	g_return_val_if_fail (IS_MAIN_WINDOW (window), FALSE);
	_tmp0_ = uri;
	_tmp1_ = g_strstrip (_tmp0_);
	uri = _tmp1_;
	_tmp2_ = uri;
	_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) -1);
	term = _tmp3_;
	_tmp4_ = uri;
	_tmp5_ = g_str_has_prefix (_tmp4_, "@");
	if (_tmp5_) {
		gint slash_index = 0;
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		Bundle* bundle = NULL;
		Bundle* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp6_ = uri;
		_tmp7_ = string_index_of (_tmp6_, "/", 0);
		slash_index = _tmp7_;
		_tmp8_ = bundle_new ();
		bundle = _tmp8_;
		_tmp9_ = slash_index;
		if (_tmp9_ == -1) {
			Bundle* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			MainWindow* _tmp13_ = NULL;
			MainWidget* _tmp14_ = NULL;
			Bundle* _tmp15_ = NULL;
			_tmp10_ = bundle;
			_tmp11_ = term;
			_tmp12_ = int64_parse (_tmp11_);
			bundle_put_int64 (_tmp10_, "user_id", _tmp12_);
			_tmp13_ = window;
			_tmp14_ = _tmp13_->main_widget;
			_tmp15_ = bundle;
			main_widget_switch_page (_tmp14_, (gint) PAGE_PROFILE, _tmp15_);
		} else {
			Bundle* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gint64 _tmp21_ = 0LL;
			Bundle* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			const gchar* _tmp25_ = NULL;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			MainWindow* _tmp31_ = NULL;
			MainWidget* _tmp32_ = NULL;
			Bundle* _tmp33_ = NULL;
			_tmp16_ = bundle;
			_tmp17_ = term;
			_tmp18_ = slash_index;
			_tmp19_ = string_substring (_tmp17_, (glong) 0, (glong) (_tmp18_ - 1));
			_tmp20_ = _tmp19_;
			_tmp21_ = int64_parse (_tmp20_);
			bundle_put_int64 (_tmp16_, "user_id", _tmp21_);
			_g_free0 (_tmp20_);
			_tmp22_ = bundle;
			_tmp23_ = term;
			_tmp24_ = slash_index;
			_tmp25_ = term;
			_tmp26_ = strlen (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = slash_index;
			_tmp29_ = string_substring (_tmp23_, (glong) (_tmp24_ + 1), (glong) ((_tmp27_ - _tmp28_) - 1));
			_tmp30_ = _tmp29_;
			bundle_put_string (_tmp22_, "screen_name", _tmp30_);
			_g_free0 (_tmp30_);
			_tmp31_ = window;
			_tmp32_ = _tmp31_->main_widget;
			_tmp33_ = bundle;
			main_widget_switch_page (_tmp32_, (gint) PAGE_PROFILE, _tmp33_);
		}
		result = TRUE;
		_g_object_unref0 (bundle);
		_g_free0 (term);
		return result;
	} else {
		const gchar* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		_tmp34_ = uri;
		_tmp35_ = g_str_has_prefix (_tmp34_, "#");
		if (_tmp35_) {
			Bundle* bundle = NULL;
			Bundle* _tmp36_ = NULL;
			Bundle* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			MainWindow* _tmp39_ = NULL;
			MainWidget* _tmp40_ = NULL;
			Bundle* _tmp41_ = NULL;
			_tmp36_ = bundle_new ();
			bundle = _tmp36_;
			_tmp37_ = bundle;
			_tmp38_ = uri;
			bundle_put_string (_tmp37_, "query", _tmp38_);
			_tmp39_ = window;
			_tmp40_ = _tmp39_->main_widget;
			_tmp41_ = bundle;
			main_widget_switch_page (_tmp40_, (gint) PAGE_SEARCH, _tmp41_);
			result = TRUE;
			_g_object_unref0 (bundle);
			_g_free0 (term);
			return result;
		} else {
			const gchar* _tmp42_ = NULL;
			gboolean _tmp43_ = FALSE;
			_tmp42_ = uri;
			_tmp43_ = g_str_has_prefix (_tmp42_, "https://twitter.com/");
			if (_tmp43_) {
				gchar** parts = NULL;
				const gchar* _tmp44_ = NULL;
				gchar** _tmp45_ = NULL;
				gchar** _tmp46_ = NULL;
				gint parts_length1 = 0;
				gint _parts_size_ = 0;
				gchar** _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				const gchar* _tmp48_ = NULL;
				_tmp44_ = uri;
				_tmp46_ = _tmp45_ = g_strsplit (_tmp44_, "/", 0);
				parts = _tmp46_;
				parts_length1 = _vala_array_length (_tmp45_);
				_parts_size_ = parts_length1;
				_tmp47_ = parts;
				_tmp47__length1 = parts_length1;
				_tmp48_ = _tmp47_[4];
				if (g_strcmp0 (_tmp48_, "status") == 0) {
					gint64 tweet_id = 0LL;
					gchar** _tmp49_ = NULL;
					gint _tmp49__length1 = 0;
					const gchar* _tmp50_ = NULL;
					gint64 _tmp51_ = 0LL;
					Bundle* bundle = NULL;
					Bundle* _tmp52_ = NULL;
					Bundle* _tmp53_ = NULL;
					Bundle* _tmp54_ = NULL;
					gint64 _tmp55_ = 0LL;
					Bundle* _tmp56_ = NULL;
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					const gchar* _tmp58_ = NULL;
					MainWindow* _tmp59_ = NULL;
					MainWidget* _tmp60_ = NULL;
					Bundle* _tmp61_ = NULL;
					_tmp49_ = parts;
					_tmp49__length1 = parts_length1;
					_tmp50_ = _tmp49_[5];
					_tmp51_ = int64_parse (_tmp50_);
					tweet_id = _tmp51_;
					_tmp52_ = bundle_new ();
					bundle = _tmp52_;
					_tmp53_ = bundle;
					bundle_put_int (_tmp53_, "mode", TWEET_INFO_PAGE_BY_ID);
					_tmp54_ = bundle;
					_tmp55_ = tweet_id;
					bundle_put_int64 (_tmp54_, "tweet_id", _tmp55_);
					_tmp56_ = bundle;
					_tmp57_ = parts;
					_tmp57__length1 = parts_length1;
					_tmp58_ = _tmp57_[3];
					bundle_put_string (_tmp56_, "screen_name", _tmp58_);
					_tmp59_ = window;
					_tmp60_ = _tmp59_->main_widget;
					_tmp61_ = bundle;
					main_widget_switch_page (_tmp60_, (gint) PAGE_TWEET_INFO, _tmp61_);
					result = TRUE;
					_g_object_unref0 (bundle);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (term);
					return result;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	result = FALSE;
	_g_free0 (term);
	return result;
}


static void tweet_utils_work_array_data_free (gpointer _data) {
	TweetUtilsWorkArrayData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->main_window);
	g_slice_free (TweetUtilsWorkArrayData, _data_);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


void tweet_utils_work_array (JsonArray* json_array, TweetListBox* tweet_list, MainWindow* main_window, Account* account, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsWorkArrayData* _data_;
	JsonArray* _tmp0_ = NULL;
	JsonArray* _tmp1_ = NULL;
	TweetListBox* _tmp2_ = NULL;
	TweetListBox* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	MainWindow* _tmp5_ = NULL;
	Account* _tmp6_ = NULL;
	Account* _tmp7_ = NULL;
	_data_ = g_slice_new0 (TweetUtilsWorkArrayData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_work_array);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_work_array_data_free);
	_tmp0_ = json_array;
	_tmp1_ = _json_array_ref0 (_tmp0_);
	_json_array_unref0 (_data_->json_array);
	_data_->json_array = _tmp1_;
	_tmp2_ = tweet_list;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet_list);
	_data_->tweet_list = _tmp3_;
	_tmp4_ = main_window;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_data_->main_window);
	_data_->main_window = _tmp5_;
	_tmp6_ = account;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp7_;
	tweet_utils_work_array_co (_data_);
}


void tweet_utils_work_array_finish (GAsyncResult* _res_) {
	TweetUtilsWorkArrayData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block58Data* block58_data_ref (Block58Data* _data58_) {
	g_atomic_int_inc (&_data58_->_ref_count_);
	return _data58_;
}


static void block58_data_unref (void * _userdata_) {
	Block58Data* _data58_;
	_data58_ = (Block58Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data58_->_ref_count_)) {
		_json_array_unref0 (_data58_->json_array);
		_g_object_unref0 (_data58_->tweet_list);
		_g_object_unref0 (_data58_->account);
		g_slice_free (Block58Data, _data58_);
	}
}


static Block59Data* block59_data_ref (Block59Data* _data59_) {
	g_atomic_int_inc (&_data59_->_ref_count_);
	return _data59_;
}


static void block59_data_unref (void * _userdata_) {
	Block59Data* _data59_;
	_data59_ = (Block59Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data59_->_ref_count_)) {
		_g_date_time_unref0 (_data59_->now);
		_data59_->tweet_array = (_vala_array_free (_data59_->tweet_array, _data59_->tweet_array_length1, (GDestroyNotify) g_object_unref), NULL);
		block58_data_unref (_data59_->_data58_);
		_data59_->_data58_ = NULL;
		g_slice_free (Block59Data, _data59_);
	}
}


static gboolean ___lambda51_ (Block59Data* _data59_) {
	Block58Data* _data58_;
	gboolean result = FALSE;
	_data58_ = _data59_->_data58_;
	tweet_utils_work_array_co (_data58_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean ____lambda51__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda51_ (self);
	return result;
}


static void __lambda52_ (Block59Data* _data59_, JsonArray* array, guint index, JsonNode* node) {
	Block58Data* _data58_;
	Tweet* t = NULL;
	Tweet* _tmp0_ = NULL;
	JsonNode* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	Tweet** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guint _tmp5_ = 0U;
	Tweet* _tmp6_ = NULL;
	Tweet* _tmp7_ = NULL;
	_data58_ = _data59_->_data58_;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = tweet_new ();
	t = _tmp0_;
	_tmp1_ = node;
	_tmp2_ = _data59_->now;
	_tmp3_ = _data58_->account;
	tweet_load_from_json (t, _tmp1_, _tmp2_, _tmp3_);
	_tmp4_ = _data59_->tweet_array;
	_tmp4__length1 = _data59_->tweet_array_length1;
	_tmp5_ = index;
	_tmp6_ = _g_object_ref0 (t);
	_g_object_unref0 (_tmp4_[_tmp5_]);
	_tmp4_[_tmp5_] = _tmp6_;
	_tmp7_ = _tmp4_[_tmp5_];
	_g_object_unref0 (t);
}


static void ___lambda52__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda52_ (self, array, index_, element_node);
}


static gboolean __lambda53_ (Block59Data* _data59_) {
	Block58Data* _data58_;
	gboolean result = FALSE;
	Tweet* tweet = NULL;
	Tweet** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	Tweet* _tmp2_ = NULL;
	Tweet* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	UserCounter* _tmp5_ = NULL;
	UserCounter* _tmp6_ = NULL;
	Account* _tmp7_ = NULL;
	UserCounter* _tmp8_ = NULL;
	UserCounter* _tmp9_ = NULL;
	Tweet* _tmp10_ = NULL;
	MiniTweet* _tmp11_ = NULL;
	Tweet* _tmp12_ = NULL;
	MiniTweet* _tmp13_ = NULL;
	Account* _tmp19_ = NULL;
	Tweet* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	TweetListBox* _tmp25_ = NULL;
	TweetModel* _tmp26_ = NULL;
	Tweet* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	Tweet** _tmp30_ = NULL;
	gint _tmp30__length1 = 0;
	_data58_ = _data59_->_data58_;
	_tmp0_ = _data59_->tweet_array;
	_tmp0__length1 = _data59_->tweet_array_length1;
	_tmp1_ = _data59_->index;
	_tmp2_ = _tmp0_[_tmp1_];
	_tmp3_ = _g_object_ref0 (_tmp2_);
	tweet = _tmp3_;
	_tmp4_ = _data58_->account;
	_tmp5_ = account_get_user_counter (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NULL) {
		result = FALSE;
		_g_object_unref0 (tweet);
		return result;
	}
	_tmp7_ = _data58_->account;
	_tmp8_ = account_get_user_counter (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = tweet;
	_tmp11_ = _tmp10_->source_tweet;
	user_counter_id_seen (_tmp9_, &_tmp11_->author);
	_tmp12_ = tweet;
	_tmp13_ = _tmp12_->retweeted_tweet;
	if (_tmp13_ != NULL) {
		Account* _tmp14_ = NULL;
		UserCounter* _tmp15_ = NULL;
		UserCounter* _tmp16_ = NULL;
		Tweet* _tmp17_ = NULL;
		MiniTweet* _tmp18_ = NULL;
		_tmp14_ = _data58_->account;
		_tmp15_ = account_get_user_counter (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = tweet;
		_tmp18_ = _tmp17_->retweeted_tweet;
		user_counter_id_seen (_tmp16_, &_tmp18_->author);
	}
	_tmp19_ = _data58_->account;
	_tmp20_ = tweet;
	_tmp21_ = account_filter_matches (_tmp19_, _tmp20_);
	if (_tmp21_) {
		Tweet* _tmp22_ = NULL;
		Tweet* _tmp23_ = NULL;
		guint _tmp24_ = 0U;
		_tmp22_ = tweet;
		_tmp23_ = tweet;
		_tmp24_ = _tmp23_->hidden_flags;
		_tmp23_->hidden_flags = _tmp24_ | TWEET_HIDDEN_FILTERED;
	}
	_tmp25_ = _data58_->tweet_list;
	_tmp26_ = _tmp25_->model;
	_tmp27_ = tweet;
	tweet_model_add (_tmp26_, _tmp27_);
	_tmp28_ = _data59_->index;
	_data59_->index = _tmp28_ + 1;
	_tmp29_ = _data59_->index;
	_tmp30_ = _data59_->tweet_array;
	_tmp30__length1 = _data59_->tweet_array_length1;
	if (_tmp29_ == _tmp30__length1) {
		tweet_utils_work_array_co (_data58_->_async_data_);
		result = FALSE;
		_g_object_unref0 (tweet);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (tweet);
	return result;
}


static gboolean ___lambda53__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda53_ (self);
	return result;
}


static void* __lambda50_ (Block58Data* _data58_) {
	void* result = NULL;
	Block59Data* _data59_;
	JsonArray* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Tweet** _tmp2_ = NULL;
	Tweet** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GDateTime* _tmp4_ = NULL;
	JsonArray* _tmp5_ = NULL;
	_data59_ = g_slice_new0 (Block59Data);
	_data59_->_ref_count_ = 1;
	_data59_->_data58_ = block58_data_ref (_data58_);
	_tmp0_ = _data58_->json_array;
	_tmp1_ = json_array_get_length (_tmp0_);
	_tmp2_ = g_new0 (Tweet*, _tmp1_ + 1);
	_data59_->tweet_array = _tmp2_;
	_data59_->tweet_array_length1 = _tmp1_;
	_data59_->_tweet_array_size_ = _data59_->tweet_array_length1;
	_tmp3_ = _data59_->tweet_array;
	_tmp3__length1 = _data59_->tweet_array_length1;
	if (_tmp3__length1 == 0) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda51__gsource_func, block59_data_ref (_data59_), block59_data_unref);
		result = NULL;
		block59_data_unref (_data59_);
		_data59_ = NULL;
		return result;
	}
	_tmp4_ = g_date_time_new_now_local ();
	_data59_->now = _tmp4_;
	_tmp5_ = _data58_->json_array;
	json_array_foreach_element (_tmp5_, ___lambda52__json_array_foreach, _data59_);
	_data59_->index = 0;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda53__gsource_func, block59_data_ref (_data59_), block59_data_unref);
	result = NULL;
	block59_data_unref (_data59_);
	_data59_ = NULL;
	return result;
}


static gpointer ___lambda50__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda50_ (self);
	block58_data_unref (self);
	return result;
}


static gboolean tweet_utils_work_array_co (TweetUtilsWorkArrayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data58_ = g_slice_new0 (Block58Data);
	_data_->_data58_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->json_array;
	_json_array_unref0 (_data_->_data58_->json_array);
	_data_->_data58_->json_array = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->tweet_list;
	_g_object_unref0 (_data_->_data58_->tweet_list);
	_data_->_data58_->tweet_list = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->account;
	_g_object_unref0 (_data_->_data58_->account);
	_data_->_data58_->account = _data_->_tmp2_;
	_data_->_data58_->_async_data_ = _data_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_thread_new ("TweetWorker", ___lambda50__gthread_func, block58_data_ref (_data_->_data58_));
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_thread_unref0 (_data_->_tmp4_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block58_data_unref (_data_->_data58_);
	_data_->_data58_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void tweet_utils_handle_media_click (Tweet* t, MainWindow* window, gint index) {
	MediaDialog* media_dialog = NULL;
	Tweet* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	MediaDialog* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	g_return_if_fail (IS_TWEET (t));
	g_return_if_fail (IS_MAIN_WINDOW (window));
	_tmp0_ = t;
	_tmp1_ = index;
	_tmp2_ = media_dialog_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	media_dialog = _tmp2_;
	_tmp3_ = window;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow));
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (media_dialog);
}


gboolean tweet_utils_is_link (const gchar* word) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (word != NULL, FALSE);
	_tmp1_ = word;
	_tmp2_ = g_str_has_prefix (_tmp1_, "http://");
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp3_ = word;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ > 7;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp7_ = word;
	_tmp8_ = g_str_has_prefix (_tmp7_, "https://");
	if (_tmp8_) {
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp9_ = word;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp6_ = _tmp11_ > 8;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = TRUE;
		return result;
	}
	{
		const gchar** tld_collection = NULL;
		gint tld_collection_length1 = 0;
		gint _tld_collection_size_ = 0;
		gint tld_it = 0;
		tld_collection = TWEET_UTILS_DOMAINS;
		tld_collection_length1 = G_N_ELEMENTS (TWEET_UTILS_DOMAINS);
		for (tld_it = 0; tld_it < G_N_ELEMENTS (TWEET_UTILS_DOMAINS); tld_it = tld_it + 1) {
			gchar* _tmp12_ = NULL;
			gchar* tld = NULL;
			_tmp12_ = g_strdup (tld_collection[tld_it]);
			tld = _tmp12_;
			{
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				_tmp13_ = word;
				_tmp14_ = tld;
				_tmp15_ = g_str_has_suffix (_tmp13_, _tmp14_);
				if (_tmp15_) {
					result = TRUE;
					_g_free0 (tld);
					return result;
				}
				_g_free0 (tld);
			}
		}
	}
	result = FALSE;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean _vala_unichar_array_contains (gunichar* stack, int stack_length, gunichar needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_ = 0L;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


gboolean tweet_utils_is_mention (const gchar* word, gint* at_pos) {
	gint _vala_at_pos = 0;
	gboolean result = FALSE;
	gint k = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gunichar _tmp11_ = 0U;
	g_return_val_if_fail (word != NULL, FALSE);
	k = 0;
	while (TRUE) {
		const gchar* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gunichar _tmp2_ = 0U;
		gint _tmp3_ = 0;
		_tmp0_ = word;
		_tmp1_ = k;
		_tmp2_ = string_get_char (_tmp0_, (glong) _tmp1_);
		if (!_vala_unichar_array_contains (TWEET_UTILS_non_mention_chars, G_N_ELEMENTS (TWEET_UTILS_non_mention_chars), _tmp2_)) {
			break;
		}
		_tmp3_ = k;
		k = _tmp3_ + 1;
	}
	_tmp4_ = k;
	_vala_at_pos = _tmp4_;
	_tmp7_ = word;
	_tmp8_ = word;
	_tmp9_ = k;
	_tmp10_ = string_index_of_nth_char (_tmp8_, (glong) _tmp9_);
	_tmp11_ = string_get_char (_tmp7_, (glong) _tmp10_);
	if (_tmp11_ == ((gunichar) '@')) {
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp12_ = word;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp6_ = _tmp14_ > 1;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		_tmp15_ = word;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = k;
		_tmp5_ = (_tmp17_ - _tmp18_) > 1;
	} else {
		_tmp5_ = FALSE;
	}
	result = _tmp5_;
	if (at_pos) {
		*at_pos = _vala_at_pos;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gboolean tweet_utils_is_hashtag (const gchar* word) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gchar _tmp2_ = '\0';
	g_return_val_if_fail (word != NULL, FALSE);
	_tmp1_ = word;
	_tmp2_ = string_get (_tmp1_, (glong) 0);
	if (_tmp2_ == '#') {
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp3_ = word;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ > 1;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self) {
	GtkTextIter* dup;
	dup = g_new0 (GtkTextIter, 1);
	memcpy (dup, self, sizeof (GtkTextIter));
	return dup;
}


static gpointer __gtk_text_iter_dup0 (gpointer self) {
	return self ? _gtk_text_iter_dup (self) : NULL;
}


void tweet_utils_highlight_link (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end) {
	GtkTextIter* iter1 = NULL;
	GtkTextIter* _tmp0_ = NULL;
	GtkTextIter* _tmp1_ = NULL;
	GtkTextIter* iter2 = NULL;
	GtkTextIter* _tmp2_ = NULL;
	GtkTextIter* _tmp3_ = NULL;
	GtkTextIter* _tmp4_ = NULL;
	GtkTextIter* _tmp5_ = NULL;
	GtkTextBuffer* _tmp23_ = NULL;
	GtkTextIter* _tmp24_ = NULL;
	GtkTextIter* _tmp25_ = NULL;
	GtkTextIter _tmp26_ = {0};
	GtkTextIter _tmp27_ = {0};
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = word_start;
	_tmp1_ = __gtk_text_iter_dup0 (_tmp0_);
	iter1 = _tmp1_;
	_tmp2_ = word_start;
	_tmp3_ = __gtk_text_iter_dup0 (_tmp2_);
	iter2 = _tmp3_;
	_tmp4_ = iter1;
	gtk_text_iter_forward_char (_tmp4_);
	_tmp5_ = iter2;
	gtk_text_iter_forward_chars (_tmp5_, 2);
	while (TRUE) {
		GtkTextIter* _tmp6_ = NULL;
		GtkTextIter* _tmp7_ = NULL;
		GtkTextIter _tmp8_ = {0};
		gint _tmp9_ = 0;
		gchar* t = NULL;
		GtkTextBuffer* _tmp10_ = NULL;
		GtkTextIter* _tmp11_ = NULL;
		GtkTextIter* _tmp12_ = NULL;
		GtkTextIter _tmp13_ = {0};
		GtkTextIter _tmp14_ = {0};
		gchar* _tmp15_ = NULL;
		gunichar c = 0U;
		const gchar* _tmp16_ = NULL;
		gunichar _tmp17_ = 0U;
		gboolean _tmp18_ = FALSE;
		gunichar _tmp19_ = 0U;
		GtkTextIter* _tmp21_ = NULL;
		GtkTextIter* _tmp22_ = NULL;
		_tmp6_ = iter1;
		_tmp7_ = word_end;
		_tmp8_ = *_tmp7_;
		_tmp9_ = gtk_text_iter_compare (_tmp6_, &_tmp8_);
		if (!(_tmp9_ < 0)) {
			break;
		}
		_tmp10_ = buffer;
		_tmp11_ = iter1;
		_tmp12_ = iter2;
		_tmp13_ = *_tmp11_;
		_tmp14_ = *_tmp12_;
		_tmp15_ = gtk_text_buffer_get_text (_tmp10_, &_tmp13_, &_tmp14_, FALSE);
		t = _tmp15_;
		_tmp16_ = t;
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
		c = _tmp17_;
		_tmp19_ = c;
		if (_tmp19_ == ((gunichar) '"')) {
			_tmp18_ = TRUE;
		} else {
			gunichar _tmp20_ = 0U;
			_tmp20_ = c;
			_tmp18_ = _tmp20_ == 8220U;
		}
		if (_tmp18_) {
			_g_free0 (t);
			break;
		}
		_tmp21_ = iter1;
		gtk_text_iter_forward_char (_tmp21_);
		_tmp22_ = iter2;
		gtk_text_iter_forward_char (_tmp22_);
		_g_free0 (t);
	}
	_tmp23_ = buffer;
	_tmp24_ = word_start;
	_tmp25_ = iter1;
	_tmp26_ = *_tmp24_;
	_tmp27_ = *_tmp25_;
	gtk_text_buffer_apply_tag_by_name (_tmp23_, "link", &_tmp26_, &_tmp27_);
	_g_free0 (iter2);
	_g_free0 (iter1);
}


/** Invariant: The word passed to this function starts with a @ */
void tweet_utils_highlight_mention (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end) {
	GtkTextIter* iter1 = NULL;
	GtkTextIter* _tmp0_ = NULL;
	GtkTextIter* _tmp1_ = NULL;
	GtkTextIter* iter2 = NULL;
	GtkTextIter* _tmp2_ = NULL;
	GtkTextIter* _tmp3_ = NULL;
	GtkTextIter* _tmp4_ = NULL;
	GtkTextIter* _tmp5_ = NULL;
	GtkTextBuffer* _tmp28_ = NULL;
	GtkTextIter* _tmp29_ = NULL;
	GtkTextIter* _tmp30_ = NULL;
	GtkTextIter _tmp31_ = {0};
	GtkTextIter _tmp32_ = {0};
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = word_start;
	_tmp1_ = __gtk_text_iter_dup0 (_tmp0_);
	iter1 = _tmp1_;
	_tmp2_ = word_start;
	_tmp3_ = __gtk_text_iter_dup0 (_tmp2_);
	iter2 = _tmp3_;
	_tmp4_ = iter1;
	gtk_text_iter_forward_char (_tmp4_);
	_tmp5_ = iter2;
	gtk_text_iter_forward_chars (_tmp5_, 2);
	while (TRUE) {
		GtkTextIter* _tmp6_ = NULL;
		GtkTextIter* _tmp7_ = NULL;
		GtkTextIter _tmp8_ = {0};
		gint _tmp9_ = 0;
		gchar* t = NULL;
		GtkTextBuffer* _tmp10_ = NULL;
		GtkTextIter* _tmp11_ = NULL;
		GtkTextIter* _tmp12_ = NULL;
		GtkTextIter _tmp13_ = {0};
		GtkTextIter _tmp14_ = {0};
		gchar* _tmp15_ = NULL;
		gunichar c = 0U;
		const gchar* _tmp16_ = NULL;
		gunichar _tmp17_ = 0U;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gunichar _tmp21_ = 0U;
		gboolean _tmp22_ = FALSE;
		GtkTextIter* _tmp26_ = NULL;
		GtkTextIter* _tmp27_ = NULL;
		_tmp6_ = iter1;
		_tmp7_ = word_end;
		_tmp8_ = *_tmp7_;
		_tmp9_ = gtk_text_iter_compare (_tmp6_, &_tmp8_);
		if (!(_tmp9_ < 0)) {
			break;
		}
		_tmp10_ = buffer;
		_tmp11_ = iter1;
		_tmp12_ = iter2;
		_tmp13_ = *_tmp11_;
		_tmp14_ = *_tmp12_;
		_tmp15_ = gtk_text_buffer_get_text (_tmp10_, &_tmp13_, &_tmp14_, FALSE);
		t = _tmp15_;
		_tmp16_ = t;
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
		c = _tmp17_;
		_tmp21_ = c;
		_tmp22_ = g_unichar_ispunct (_tmp21_);
		if (_tmp22_) {
			gunichar _tmp23_ = 0U;
			_tmp23_ = c;
			_tmp20_ = _tmp23_ != ((gunichar) '_');
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			gunichar _tmp24_ = 0U;
			_tmp24_ = c;
			_tmp19_ = _tmp24_ == ((gunichar) '"');
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gunichar _tmp25_ = 0U;
			_tmp25_ = c;
			_tmp18_ = _tmp25_ == 8220U;
		}
		if (_tmp18_) {
			_g_free0 (t);
			break;
		}
		_tmp26_ = iter1;
		gtk_text_iter_forward_char (_tmp26_);
		_tmp27_ = iter2;
		gtk_text_iter_forward_char (_tmp27_);
		_g_free0 (t);
	}
	_tmp28_ = buffer;
	_tmp29_ = word_start;
	_tmp30_ = iter1;
	_tmp31_ = *_tmp29_;
	_tmp32_ = *_tmp30_;
	gtk_text_buffer_apply_tag_by_name (_tmp28_, "mention", &_tmp31_, &_tmp32_);
	_g_free0 (iter2);
	_g_free0 (iter1);
}


/** Invariant: the word passed to this function starts with a # */
void tweet_utils_highlight_hashtag (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end) {
	GtkTextIter* iter1 = NULL;
	GtkTextIter* _tmp0_ = NULL;
	GtkTextIter* _tmp1_ = NULL;
	GtkTextIter* iter2 = NULL;
	GtkTextIter* _tmp2_ = NULL;
	GtkTextIter* _tmp3_ = NULL;
	GtkTextIter* _tmp4_ = NULL;
	GtkTextIter* _tmp5_ = NULL;
	GtkTextBuffer* _tmp26_ = NULL;
	GtkTextIter* _tmp27_ = NULL;
	GtkTextIter* _tmp28_ = NULL;
	GtkTextIter _tmp29_ = {0};
	GtkTextIter _tmp30_ = {0};
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = word_start;
	_tmp1_ = __gtk_text_iter_dup0 (_tmp0_);
	iter1 = _tmp1_;
	_tmp2_ = word_start;
	_tmp3_ = __gtk_text_iter_dup0 (_tmp2_);
	iter2 = _tmp3_;
	_tmp4_ = iter1;
	gtk_text_iter_forward_char (_tmp4_);
	_tmp5_ = iter2;
	gtk_text_iter_forward_chars (_tmp5_, 2);
	while (TRUE) {
		GtkTextIter* _tmp6_ = NULL;
		GtkTextIter* _tmp7_ = NULL;
		GtkTextIter _tmp8_ = {0};
		gint _tmp9_ = 0;
		gchar* t = NULL;
		GtkTextBuffer* _tmp10_ = NULL;
		GtkTextIter* _tmp11_ = NULL;
		GtkTextIter* _tmp12_ = NULL;
		GtkTextIter _tmp13_ = {0};
		GtkTextIter _tmp14_ = {0};
		gchar* _tmp15_ = NULL;
		gunichar c = 0U;
		const gchar* _tmp16_ = NULL;
		gunichar _tmp17_ = 0U;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gunichar _tmp20_ = 0U;
		gboolean _tmp21_ = FALSE;
		GtkTextIter* _tmp24_ = NULL;
		GtkTextIter* _tmp25_ = NULL;
		_tmp6_ = iter1;
		_tmp7_ = word_end;
		_tmp8_ = *_tmp7_;
		_tmp9_ = gtk_text_iter_compare (_tmp6_, &_tmp8_);
		if (!(_tmp9_ < 0)) {
			break;
		}
		_tmp10_ = buffer;
		_tmp11_ = iter1;
		_tmp12_ = iter2;
		_tmp13_ = *_tmp11_;
		_tmp14_ = *_tmp12_;
		_tmp15_ = gtk_text_buffer_get_text (_tmp10_, &_tmp13_, &_tmp14_, FALSE);
		t = _tmp15_;
		_tmp16_ = t;
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
		c = _tmp17_;
		_tmp20_ = c;
		_tmp21_ = g_unichar_ispunct (_tmp20_);
		if (_tmp21_) {
			gunichar _tmp22_ = 0U;
			_tmp22_ = c;
			_tmp19_ = _tmp22_ != ((gunichar) '_');
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gunichar _tmp23_ = 0U;
			_tmp23_ = c;
			_tmp18_ = _tmp23_ == 8221U;
		}
		if (_tmp18_) {
			_g_free0 (t);
			break;
		}
		_tmp24_ = iter1;
		gtk_text_iter_forward_char (_tmp24_);
		_tmp25_ = iter2;
		gtk_text_iter_forward_char (_tmp25_);
		_g_free0 (t);
	}
	_tmp26_ = buffer;
	_tmp27_ = word_start;
	_tmp28_ = iter1;
	_tmp29_ = *_tmp27_;
	_tmp30_ = *_tmp28_;
	gtk_text_buffer_apply_tag_by_name (_tmp26_, "hashtag", &_tmp29_, &_tmp30_);
	_g_free0 (iter2);
	_g_free0 (iter1);
}


void tweet_utils_annotate_text (GtkTextBuffer* buffer) {
	GtkTextIter* start_iter = NULL;
	GtkTextIter* cur_iter = NULL;
	GtkTextIter* word_start_iter = NULL;
	GtkTextIter* next_iter = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	GtkTextIter* _tmp3_ = NULL;
	GtkTextIter* _tmp4_ = NULL;
	GtkTextIter* _tmp5_ = NULL;
	GtkTextIter* _tmp6_ = NULL;
	GtkTextIter* _tmp7_ = NULL;
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = buffer;
	gtk_text_buffer_get_start_iter (_tmp0_, &_tmp1_);
	_g_free0 (start_iter);
	_tmp2_ = _tmp1_;
	_tmp3_ = __gtk_text_iter_dup0 (&_tmp2_);
	start_iter = _tmp3_;
	_tmp4_ = start_iter;
	_tmp5_ = __gtk_text_iter_dup0 (_tmp4_);
	_g_free0 (cur_iter);
	cur_iter = _tmp5_;
	_tmp6_ = cur_iter;
	_tmp7_ = __gtk_text_iter_dup0 (_tmp6_);
	_g_free0 (word_start_iter);
	word_start_iter = _tmp7_;
	while (TRUE) {
		GtkTextIter* _tmp8_ = NULL;
		gunichar _tmp9_ = 0U;
		gboolean _tmp10_ = FALSE;
		GtkTextIter* _tmp14_ = NULL;
		GtkTextIter* _tmp15_ = NULL;
		gboolean done = FALSE;
		GtkTextIter* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean word_end = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp52_ = FALSE;
		GtkTextIter* _tmp53_ = NULL;
		GtkTextIter* _tmp54_ = NULL;
		_tmp8_ = cur_iter;
		_tmp9_ = gtk_text_iter_get_char (_tmp8_);
		_tmp10_ = g_unichar_isspace (_tmp9_);
		if (_tmp10_) {
			GtkTextIter* _tmp11_ = NULL;
			GtkTextIter* _tmp12_ = NULL;
			GtkTextIter* _tmp13_ = NULL;
			_tmp11_ = cur_iter;
			_tmp12_ = __gtk_text_iter_dup0 (_tmp11_);
			_g_free0 (word_start_iter);
			word_start_iter = _tmp12_;
			_tmp13_ = word_start_iter;
			gtk_text_iter_forward_char (_tmp13_);
		}
		_tmp14_ = cur_iter;
		_tmp15_ = __gtk_text_iter_dup0 (_tmp14_);
		_g_free0 (next_iter);
		next_iter = _tmp15_;
		_tmp16_ = next_iter;
		_tmp17_ = gtk_text_iter_forward_char (_tmp16_);
		done = !_tmp17_;
		_tmp19_ = done;
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gboolean _tmp20_ = FALSE;
			GtkTextIter* _tmp21_ = NULL;
			gunichar _tmp22_ = 0U;
			gboolean _tmp23_ = FALSE;
			_tmp21_ = next_iter;
			_tmp22_ = gtk_text_iter_get_char (_tmp21_);
			_tmp23_ = g_unichar_isspace (_tmp22_);
			if (_tmp23_) {
				GtkTextIter* _tmp24_ = NULL;
				gunichar _tmp25_ = 0U;
				gboolean _tmp26_ = FALSE;
				_tmp24_ = cur_iter;
				_tmp25_ = gtk_text_iter_get_char (_tmp24_);
				_tmp26_ = g_unichar_isspace (_tmp25_);
				_tmp20_ = !_tmp26_;
			} else {
				_tmp20_ = FALSE;
			}
			_tmp18_ = _tmp20_;
		}
		word_end = _tmp18_;
		_tmp27_ = word_end;
		if (_tmp27_) {
			gint k = 0;
			gchar* w = NULL;
			GtkTextBuffer* _tmp28_ = NULL;
			GtkTextIter* _tmp29_ = NULL;
			GtkTextIter* _tmp30_ = NULL;
			GtkTextIter _tmp31_ = {0};
			GtkTextIter _tmp32_ = {0};
			gchar* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			gboolean _tmp35_ = FALSE;
			_tmp28_ = buffer;
			_tmp29_ = word_start_iter;
			_tmp30_ = next_iter;
			_tmp31_ = *_tmp29_;
			_tmp32_ = *_tmp30_;
			_tmp33_ = gtk_text_buffer_get_text (_tmp28_, &_tmp31_, &_tmp32_, FALSE);
			w = _tmp33_;
			_tmp34_ = w;
			_tmp35_ = tweet_utils_is_link (_tmp34_);
			if (_tmp35_) {
				GtkTextBuffer* _tmp36_ = NULL;
				GtkTextIter* _tmp37_ = NULL;
				GtkTextIter* _tmp38_ = NULL;
				_tmp36_ = buffer;
				_tmp37_ = word_start_iter;
				_tmp38_ = next_iter;
				tweet_utils_highlight_link (_tmp36_, _tmp37_, _tmp38_);
			} else {
				const gchar* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				gboolean _tmp41_ = FALSE;
				_tmp39_ = w;
				_tmp41_ = tweet_utils_is_mention (_tmp39_, &_tmp40_);
				k = _tmp40_;
				if (_tmp41_) {
					GtkTextIter* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					GtkTextBuffer* _tmp44_ = NULL;
					GtkTextIter* _tmp45_ = NULL;
					GtkTextIter* _tmp46_ = NULL;
					_tmp42_ = word_start_iter;
					_tmp43_ = k;
					gtk_text_iter_forward_chars (_tmp42_, _tmp43_);
					_tmp44_ = buffer;
					_tmp45_ = word_start_iter;
					_tmp46_ = next_iter;
					tweet_utils_highlight_mention (_tmp44_, _tmp45_, _tmp46_);
				} else {
					const gchar* _tmp47_ = NULL;
					gboolean _tmp48_ = FALSE;
					_tmp47_ = w;
					_tmp48_ = tweet_utils_is_hashtag (_tmp47_);
					if (_tmp48_) {
						GtkTextBuffer* _tmp49_ = NULL;
						GtkTextIter* _tmp50_ = NULL;
						GtkTextIter* _tmp51_ = NULL;
						_tmp49_ = buffer;
						_tmp50_ = word_start_iter;
						_tmp51_ = next_iter;
						tweet_utils_highlight_hashtag (_tmp49_, _tmp50_, _tmp51_);
					}
				}
			}
			_g_free0 (w);
		}
		_tmp52_ = done;
		if (_tmp52_) {
			break;
		}
		_tmp53_ = next_iter;
		_tmp54_ = __gtk_text_iter_dup0 (_tmp53_);
		_g_free0 (cur_iter);
		cur_iter = _tmp54_;
	}
	_g_free0 (next_iter);
	_g_free0 (word_start_iter);
	_g_free0 (cur_iter);
	_g_free0 (start_iter);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void tweet_utils_load_threaded_data_free (gpointer _data) {
	TweetUtilsLoadThreadedData* _data_;
	_data_ = _data;
	__vala_JsonNode_free0 (_data_->result);
	g_slice_free (TweetUtilsLoadThreadedData, _data_);
}


void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsLoadThreadedData* _data_;
	RestProxyCall* _tmp0_ = NULL;
	RestProxyCall* _tmp1_ = NULL;
	_data_ = g_slice_new0 (TweetUtilsLoadThreadedData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_load_threaded);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_load_threaded_data_free);
	_tmp0_ = call;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->call);
	_data_->call = _tmp1_;
	tweet_utils_load_threaded_co (_data_);
}


JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error) {
	JsonNode* result;
	TweetUtilsLoadThreadedData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block60Data* block60_data_ref (Block60Data* _data60_) {
	g_atomic_int_inc (&_data60_->_ref_count_);
	return _data60_;
}


static void block60_data_unref (void * _userdata_) {
	Block60Data* _data60_;
	_data60_ = (Block60Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data60_->_ref_count_)) {
		(_data60_->callback_target_destroy_notify == NULL) ? NULL : (_data60_->callback_target_destroy_notify (_data60_->callback_target), NULL);
		_data60_->callback = NULL;
		_data60_->callback_target = NULL;
		_data60_->callback_target_destroy_notify = NULL;
		_g_error_free0 (_data60_->err);
		__vala_JsonNode_free0 (_data60_->_result_);
		_g_object_unref0 (_data60_->call);
		g_slice_free (Block60Data, _data60_);
	}
}


static gboolean _tweet_utils_load_threaded_co_gsource_func (gpointer self) {
	gboolean result;
	result = tweet_utils_load_threaded_co (self);
	return result;
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static gboolean __lambda18_ (Block60Data* _data60_) {
	gboolean result = FALSE;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	_tmp0_ = _data60_->callback;
	_tmp0__target = _data60_->callback_target;
	_tmp0_ (_tmp0__target);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ___lambda18__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda18_ (self);
	return result;
}


static void* __lambda17_ (Block60Data* _data60_) {
	void* result = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_ = NULL;
	JsonParser* _tmp9_ = NULL;
	JsonNode* _tmp10_ = NULL;
	JsonNode* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	{
		RestProxyCall* _tmp0_ = NULL;
		_tmp0_ = _data60_->call;
		rest_proxy_call_sync (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch77_g_error;
		}
	}
	goto __finally77;
	__catch77_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _g_error_copy0 (_tmp1_);
		_g_error_free0 (_data60_->err);
		_data60_->err = _tmp2_;
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally77:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_ = NULL;
		RestProxyCall* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = parser;
		_tmp5_ = _data60_->call;
		_tmp6_ = rest_proxy_call_get_payload (_tmp5_);
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch78_g_error;
		}
	}
	goto __finally78;
	__catch78_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _g_error_copy0 (_tmp7_);
		_g_error_free0 (_data60_->err);
		_data60_->err = _tmp8_;
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return result;
	}
	__finally78:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = parser;
	_tmp10_ = json_parser_get_root (_tmp9_);
	_tmp11_ = __vala_JsonNode_copy0 (_tmp10_);
	__vala_JsonNode_free0 (_data60_->_result_);
	_data60_->_result_ = _tmp11_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda18__gsource_func, block60_data_ref (_data60_), block60_data_unref);
	result = NULL;
	_g_object_unref0 (parser);
	return result;
}


static gpointer ___lambda17__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda17_ (self);
	block60_data_unref (self);
	return result;
}


static gboolean tweet_utils_load_threaded_co (TweetUtilsLoadThreadedData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data60_ = g_slice_new0 (Block60Data);
	_data_->_data60_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->call;
	_g_object_unref0 (_data_->_data60_->call);
	_data_->_data60_->call = _data_->_tmp0_;
	_data_->_data60_->_async_data_ = _data_;
	_data_->_data60_->_result_ = NULL;
	_data_->_data60_->err = NULL;
	_data_->_data60_->callback = _tweet_utils_load_threaded_co_gsource_func;
	_data_->_data60_->callback_target = _data_;
	_data_->_data60_->callback_target_destroy_notify = NULL;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_thread_new ("json parser", ___lambda17__gthread_func, block60_data_ref (_data_->_data60_));
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_g_thread_unref0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_data60_->err;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->_data60_->err;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _g_error_copy0 (_data_->_tmp4_);
		_data_->_inner_error_ = _data_->_tmp5_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		block60_data_unref (_data_->_data60_);
		_data_->_data60_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_data60_->_result_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = __vala_JsonNode_copy0 (_data_->_tmp6_);
	_data_->result = _data_->_tmp7_;
	block60_data_unref (_data_->_data60_);
	_data_->_data60_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block60_data_unref (_data_->_data60_);
	_data_->_data60_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void tweet_utils_sort_entities (TextEntity** entities, int* entities_length1) {
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				TextEntity* _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = *entities;
				_tmp3__length1 = *entities_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				{
					gint k = 0;
					k = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_ = 0;
							TextEntity* _tmp7_ = NULL;
							gint _tmp7__length1 = 0;
							TextEntity* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp9_ = 0;
							TextEntity _tmp10_ = {0};
							guint _tmp11_ = 0U;
							TextEntity* _tmp12_ = NULL;
							gint _tmp12__length1 = 0;
							gint _tmp13_ = 0;
							TextEntity _tmp14_ = {0};
							guint _tmp15_ = 0U;
							if (!_tmp4_) {
								gint _tmp5_ = 0;
								_tmp5_ = k;
								k = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = k;
							_tmp7_ = *entities;
							_tmp7__length1 = *entities_length1;
							if (!(_tmp6_ < _tmp7__length1)) {
								break;
							}
							_tmp8_ = *entities;
							_tmp8__length1 = *entities_length1;
							_tmp9_ = i;
							_tmp10_ = _tmp8_[_tmp9_];
							_tmp11_ = _tmp10_.from;
							_tmp12_ = *entities;
							_tmp12__length1 = *entities_length1;
							_tmp13_ = k;
							_tmp14_ = _tmp12_[_tmp13_];
							_tmp15_ = _tmp14_.from;
							if (_tmp11_ < _tmp15_) {
								TextEntity c = {0};
								TextEntity* _tmp16_ = NULL;
								gint _tmp16__length1 = 0;
								gint _tmp17_ = 0;
								TextEntity _tmp18_ = {0};
								TextEntity _tmp19_ = {0};
								TextEntity* _tmp20_ = NULL;
								gint _tmp20__length1 = 0;
								gint _tmp21_ = 0;
								TextEntity* _tmp22_ = NULL;
								gint _tmp22__length1 = 0;
								gint _tmp23_ = 0;
								TextEntity _tmp24_ = {0};
								TextEntity _tmp25_ = {0};
								TextEntity _tmp26_ = {0};
								TextEntity* _tmp27_ = NULL;
								gint _tmp27__length1 = 0;
								gint _tmp28_ = 0;
								TextEntity _tmp29_ = {0};
								TextEntity _tmp30_ = {0};
								TextEntity _tmp31_ = {0};
								_tmp16_ = *entities;
								_tmp16__length1 = *entities_length1;
								_tmp17_ = i;
								_tmp18_ = _tmp16_[_tmp17_];
								text_entity_copy (&_tmp18_, &_tmp19_);
								c = _tmp19_;
								_tmp20_ = *entities;
								_tmp20__length1 = *entities_length1;
								_tmp21_ = i;
								_tmp22_ = *entities;
								_tmp22__length1 = *entities_length1;
								_tmp23_ = k;
								_tmp24_ = _tmp22_[_tmp23_];
								text_entity_copy (&_tmp24_, &_tmp25_);
								text_entity_destroy (&_tmp20_[_tmp21_]);
								_tmp20_[_tmp21_] = _tmp25_;
								_tmp26_ = _tmp20_[_tmp21_];
								_tmp27_ = *entities;
								_tmp27__length1 = *entities_length1;
								_tmp28_ = k;
								_tmp29_ = c;
								text_entity_copy (&_tmp29_, &_tmp30_);
								text_entity_destroy (&_tmp27_[_tmp28_]);
								_tmp27_[_tmp28_] = _tmp30_;
								_tmp31_ = _tmp27_[_tmp28_];
								text_entity_destroy (&c);
							}
						}
					}
				}
			}
		}
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



