/* UserFilterEntry.c generated by valac 0.26.2, the Vala compiler
 * generated from UserFilterEntry.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;

#define TYPE_USER_FILTER_ENTRY (user_filter_entry_get_type ())
#define USER_FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_FILTER_ENTRY, UserFilterEntry))
#define USER_FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_FILTER_ENTRY, UserFilterEntryClass))
#define IS_USER_FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_FILTER_ENTRY))
#define IS_USER_FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_FILTER_ENTRY))
#define USER_FILTER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_FILTER_ENTRY, UserFilterEntryClass))

typedef struct _UserFilterEntry UserFilterEntry;
typedef struct _UserFilterEntryClass UserFilterEntryClass;
typedef struct _UserFilterEntryPrivate UserFilterEntryPrivate;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
	gboolean (*get_seen) (ITwitterItem* self);
	void (*set_seen) (ITwitterItem* self, gboolean value);
};

struct _UserFilterEntry {
	GtkListBoxRow parent_instance;
	UserFilterEntryPrivate * priv;
};

struct _UserFilterEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _UserFilterEntryPrivate {
	GtkLabel* name_label;
	GtkLabel* screen_name_label;
	AvatarWidget* avatar_image;
	GtkStack* stack;
	GtkBox* delete_box;
	GtkGrid* grid;
	GtkRevealer* revealer;
	gint64 _user_id;
};

typedef void (*TwitterAvatarDownloadedFunc) (GdkPixbuf* avatar, void* user_data);

static gpointer user_filter_entry_parent_class = NULL;
static ITwitterItemIface* user_filter_entry_itwitter_item_parent_iface = NULL;

GType itwitter_item_get_type (void) G_GNUC_CONST;
GType user_filter_entry_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
#define USER_FILTER_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_FILTER_ENTRY, UserFilterEntryPrivate))
enum  {
	USER_FILTER_ENTRY_DUMMY_PROPERTY,
	USER_FILTER_ENTRY_NAME,
	USER_FILTER_ENTRY_SCREEN_NAME,
	USER_FILTER_ENTRY_AVATAR,
	USER_FILTER_ENTRY_SEEN,
	USER_FILTER_ENTRY_SORT_FACTOR,
	USER_FILTER_ENTRY_USER_ID
};
static void user_filter_entry_real_set_avatar (UserFilterEntry* self, const gchar* avatar_url);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
GdkPixbuf* twitter_get_avatar (Twitter* self, const gchar* url, TwitterAvatarDownloadedFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
static void __lambda149_ (UserFilterEntry* self, GdkPixbuf* a);
static void ___lambda149__twitter_avatar_downloaded_func (GdkPixbuf* avatar, gpointer self);
static gint user_filter_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now);
static void user_filter_entry_menu_button_clicked_cb (UserFilterEntry* self);
static void _user_filter_entry_menu_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void user_filter_entry_cancel_button_clicked_cb (UserFilterEntry* self);
static void _user_filter_entry_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void user_filter_entry_delete_button_clicked_cb (UserFilterEntry* self);
static void __lambda150_ (UserFilterEntry* self);
gint64 user_filter_entry_get_user_id (UserFilterEntry* self);
static void ___lambda150__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _user_filter_entry_delete_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
UserFilterEntry* user_filter_entry_new (void);
UserFilterEntry* user_filter_entry_construct (GType object_type);
void user_filter_entry_set_name (UserFilterEntry* self, const gchar* value);
void user_filter_entry_set_screen_name (UserFilterEntry* self, const gchar* value);
void user_filter_entry_set_avatar (UserFilterEntry* self, const gchar* value);
void user_filter_entry_set_user_id (UserFilterEntry* self, gint64 value);
static void g_cclosure_user_marshal_VOID__INT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void user_filter_entry_finalize (GObject* obj);
gboolean itwitter_item_get_seen (ITwitterItem* self);
gint64 itwitter_item_get_sort_factor (ITwitterItem* self);
static void _vala_user_filter_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void itwitter_item_set_seen (ITwitterItem* self, gboolean value);
static void _vala_user_filter_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void __lambda149_ (UserFilterEntry* self, GdkPixbuf* a) {
	AvatarWidget* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	g_return_if_fail (GDK_IS_PIXBUF (a));
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = a;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_image_get_type (), GtkImage), "pixbuf", _tmp1_, NULL);
}


static void ___lambda149__twitter_avatar_downloaded_func (GdkPixbuf* avatar, gpointer self) {
	__lambda149_ ((UserFilterEntry*) self, avatar);
}


static void user_filter_entry_real_set_avatar (UserFilterEntry* self, const gchar* avatar_url) {
	AvatarWidget* _tmp0_ = NULL;
	Twitter* _tmp1_ = NULL;
	Twitter* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	g_return_if_fail (IS_USER_FILTER_ENTRY (self));
	g_return_if_fail (avatar_url != NULL);
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = twitter_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = avatar_url;
	_tmp4_ = twitter_get_avatar (_tmp2_, _tmp3_, ___lambda149__twitter_avatar_downloaded_func, g_object_ref (self), g_object_unref);
	_tmp5_ = _tmp4_;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_image_get_type (), GtkImage), "pixbuf", _tmp5_, NULL);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp2_);
}


static gint user_filter_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now) {
	UserFilterEntry * self;
	gint result = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_USER_FILTER_ENTRY, UserFilterEntry);
	result = 0;
	return result;
}


static void user_filter_entry_menu_button_clicked_cb (UserFilterEntry* self) {
	GtkStack* _tmp0_ = NULL;
	GtkBox* _tmp1_ = NULL;
	g_return_if_fail (IS_USER_FILTER_ENTRY (self));
	_tmp0_ = self->priv->stack;
	_tmp1_ = self->priv->delete_box;
	gtk_stack_set_visible_child (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
}


static void _user_filter_entry_menu_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	user_filter_entry_menu_button_clicked_cb ((UserFilterEntry*) self);
}


static void user_filter_entry_cancel_button_clicked_cb (UserFilterEntry* self) {
	GtkStack* _tmp0_ = NULL;
	GtkGrid* _tmp1_ = NULL;
	g_return_if_fail (IS_USER_FILTER_ENTRY (self));
	_tmp0_ = self->priv->stack;
	_tmp1_ = self->priv->grid;
	gtk_stack_set_visible_child (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
}


static void _user_filter_entry_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	user_filter_entry_cancel_button_clicked_cb ((UserFilterEntry*) self);
}


static void __lambda150_ (UserFilterEntry* self) {
	gint64 _tmp0_ = 0LL;
	_tmp0_ = self->priv->_user_id;
	g_signal_emit_by_name (self, "deleted", _tmp0_);
}


static void ___lambda150__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda150_ ((UserFilterEntry*) self);
}


static void user_filter_entry_delete_button_clicked_cb (UserFilterEntry* self) {
	GtkRevealer* _tmp0_ = NULL;
	GtkRevealer* _tmp1_ = NULL;
	g_return_if_fail (IS_USER_FILTER_ENTRY (self));
	_tmp0_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	_tmp1_ = self->priv->revealer;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject), "notify::child-revealed", (GCallback) ___lambda150__g_object_notify, self, 0);
}


static void _user_filter_entry_delete_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	user_filter_entry_delete_button_clicked_cb ((UserFilterEntry*) self);
}


UserFilterEntry* user_filter_entry_construct (GType object_type) {
	UserFilterEntry * self = NULL;
	self = (UserFilterEntry*) g_object_new (object_type, NULL);
	return self;
}


UserFilterEntry* user_filter_entry_new (void) {
	return user_filter_entry_construct (TYPE_USER_FILTER_ENTRY);
}


void user_filter_entry_set_name (UserFilterEntry* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_USER_FILTER_ENTRY (self));
	_tmp0_ = self->priv->name_label;
	_tmp1_ = value;
	gtk_label_set_label (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "name");
}


void user_filter_entry_set_screen_name (UserFilterEntry* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (IS_USER_FILTER_ENTRY (self));
	_tmp0_ = self->priv->screen_name_label;
	_tmp1_ = value;
	_tmp2_ = g_strconcat ("@", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	g_object_notify ((GObject *) self, "screen-name");
}


void user_filter_entry_set_avatar (UserFilterEntry* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (IS_USER_FILTER_ENTRY (self));
	_tmp0_ = value;
	user_filter_entry_real_set_avatar (self, _tmp0_);
	g_object_notify ((GObject *) self, "avatar");
}


static gboolean user_filter_entry_real_get_seen (ITwitterItem* base) {
	gboolean result;
	UserFilterEntry* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_USER_FILTER_ENTRY, UserFilterEntry);
	result = TRUE;
	return result;
}


static void user_filter_entry_real_set_seen (ITwitterItem* base, gboolean value) {
	UserFilterEntry* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_USER_FILTER_ENTRY, UserFilterEntry);
	g_object_notify ((GObject *) self, "seen");
}


static gint64 user_filter_entry_real_get_sort_factor (ITwitterItem* base) {
	gint64 result;
	UserFilterEntry* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_USER_FILTER_ENTRY, UserFilterEntry);
	result = (gint64) 2;
	return result;
}


gint64 user_filter_entry_get_user_id (UserFilterEntry* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (IS_USER_FILTER_ENTRY (self), 0LL);
	_tmp0_ = self->priv->_user_id;
	result = _tmp0_;
	return result;
}


void user_filter_entry_set_user_id (UserFilterEntry* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (IS_USER_FILTER_ENTRY (self));
	_tmp0_ = value;
	self->priv->_user_id = _tmp0_;
	g_object_notify ((GObject *) self, "user-id");
}


static void g_cclosure_user_marshal_VOID__INT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT64) (gpointer data1, gint64 arg_1, gpointer data2);
	register GMarshalFunc_VOID__INT64 callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT64) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int64 (param_values + 1), data2);
}


static void user_filter_entry_class_init (UserFilterEntryClass * klass) {
	gint UserFilterEntry_private_offset;
	user_filter_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserFilterEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_user_filter_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_user_filter_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = user_filter_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_FILTER_ENTRY_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_FILTER_ENTRY_SCREEN_NAME, g_param_spec_string ("screen-name", "screen-name", "screen-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_FILTER_ENTRY_AVATAR, g_param_spec_string ("avatar", "avatar", "avatar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_FILTER_ENTRY_SEEN, g_param_spec_boolean ("seen", "seen", "seen", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_FILTER_ENTRY_SORT_FACTOR, g_param_spec_int64 ("sort-factor", "sort-factor", "sort-factor", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_FILTER_ENTRY_USER_ID, g_param_spec_int64 ("user-id", "user-id", "user-id", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	UserFilterEntry_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/user-filter-entry.ui");
	g_signal_new ("deleted", TYPE_USER_FILTER_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT64, G_TYPE_NONE, 1, G_TYPE_INT64);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, UserFilterEntry_private_offset + G_STRUCT_OFFSET (UserFilterEntryPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "screen_name_label", FALSE, UserFilterEntry_private_offset + G_STRUCT_OFFSET (UserFilterEntryPrivate, screen_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, UserFilterEntry_private_offset + G_STRUCT_OFFSET (UserFilterEntryPrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, UserFilterEntry_private_offset + G_STRUCT_OFFSET (UserFilterEntryPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_box", FALSE, UserFilterEntry_private_offset + G_STRUCT_OFFSET (UserFilterEntryPrivate, delete_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid", FALSE, UserFilterEntry_private_offset + G_STRUCT_OFFSET (UserFilterEntryPrivate, grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "revealer", FALSE, UserFilterEntry_private_offset + G_STRUCT_OFFSET (UserFilterEntryPrivate, revealer));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "menu_button_clicked_cb", G_CALLBACK(_user_filter_entry_menu_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_button_clicked_cb", G_CALLBACK(_user_filter_entry_cancel_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_button_clicked_cb", G_CALLBACK(_user_filter_entry_delete_button_clicked_cb_gtk_button_clicked));
}


static void user_filter_entry_itwitter_item_interface_init (ITwitterItemIface * iface) {
	user_filter_entry_itwitter_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_time_delta = (gint (*)(ITwitterItem*, GDateTime*)) user_filter_entry_real_update_time_delta;
	iface->get_seen = user_filter_entry_real_get_seen;
	iface->set_seen = user_filter_entry_real_set_seen;
	iface->get_sort_factor = user_filter_entry_real_get_sort_factor;
}


static void user_filter_entry_instance_init (UserFilterEntry * self) {
	self->priv = USER_FILTER_ENTRY_GET_PRIVATE (self);
	g_type_ensure (TYPE_AVATAR_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void user_filter_entry_finalize (GObject* obj) {
	UserFilterEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_FILTER_ENTRY, UserFilterEntry);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->delete_box);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->revealer);
	G_OBJECT_CLASS (user_filter_entry_parent_class)->finalize (obj);
}


GType user_filter_entry_get_type (void) {
	static volatile gsize user_filter_entry_type_id__volatile = 0;
	if (g_once_init_enter (&user_filter_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserFilterEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_filter_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserFilterEntry), 0, (GInstanceInitFunc) user_filter_entry_instance_init, NULL };
		static const GInterfaceInfo itwitter_item_info = { (GInterfaceInitFunc) user_filter_entry_itwitter_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType user_filter_entry_type_id;
		user_filter_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "UserFilterEntry", &g_define_type_info, 0);
		g_type_add_interface_static (user_filter_entry_type_id, TYPE_ITWITTER_ITEM, &itwitter_item_info);
		g_once_init_leave (&user_filter_entry_type_id__volatile, user_filter_entry_type_id);
	}
	return user_filter_entry_type_id__volatile;
}


static void _vala_user_filter_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UserFilterEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_FILTER_ENTRY, UserFilterEntry);
	switch (property_id) {
		case USER_FILTER_ENTRY_SEEN:
		g_value_set_boolean (value, itwitter_item_get_seen (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem)));
		break;
		case USER_FILTER_ENTRY_SORT_FACTOR:
		g_value_set_int64 (value, itwitter_item_get_sort_factor (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem)));
		break;
		case USER_FILTER_ENTRY_USER_ID:
		g_value_set_int64 (value, user_filter_entry_get_user_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_user_filter_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UserFilterEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_FILTER_ENTRY, UserFilterEntry);
	switch (property_id) {
		case USER_FILTER_ENTRY_NAME:
		user_filter_entry_set_name (self, g_value_get_string (value));
		break;
		case USER_FILTER_ENTRY_SCREEN_NAME:
		user_filter_entry_set_screen_name (self, g_value_get_string (value));
		break;
		case USER_FILTER_ENTRY_AVATAR:
		user_filter_entry_set_avatar (self, g_value_get_string (value));
		break;
		case USER_FILTER_ENTRY_SEEN:
		itwitter_item_set_seen (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem), g_value_get_boolean (value));
		break;
		case USER_FILTER_ENTRY_USER_ID:
		user_filter_entry_set_user_id (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



