/* UserStream.c generated by valac 0.26.2, the Vala compiler
 * generated from UserStream.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */
/* See https://dev.twitter.com/docs/streaming-apis/messages*/

#include <glib.h>
#include <glib-object.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy-call.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rest/rest-proxy.h>


#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;
typedef struct _UserStreamPrivate UserStreamPrivate;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE
} StreamMessageType;

struct _UserStream {
	GObject parent_instance;
	UserStreamPrivate * priv;
};

struct _UserStreamClass {
	GObjectClass parent_class;
};

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _UserStreamPrivate {
	OAuthProxy* proxy;
	RestProxyCall* proxy_call;
	GString* data;
	GSList* receivers;
	GNetworkMonitor* network_monitor;
	gboolean network_available;
	guint network_timeout_id;
	guint heartbeat_timeout_id;
	gboolean running;
	gchar* account_name;
	Account* account;
};


static gpointer user_stream_parent_class = NULL;

GType stream_message_type_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define USER_STREAM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_STREAM, UserStreamPrivate))
enum  {
	USER_STREAM_DUMMY_PROPERTY,
	USER_STREAM_TOKEN,
	USER_STREAM_TOKEN_SECRET
};
UserStream* user_stream_new (Account* account);
UserStream* user_stream_construct (GType object_type, Account* account);
const gchar* account_get_screen_name (Account* self);
gchar* settings_get_consumer_key (void);
gchar* settings_get_consumer_secret (void);
static void user_stream_network_changed_cb (UserStream* self, gboolean available);
static void _user_stream_network_changed_cb_g_network_monitor_network_changed (GNetworkMonitor* _sender, gboolean available, gpointer self);
static void user_stream_start_network_timeout (UserStream* self);
void user_stream_register (UserStream* self, IMessageReceiver* receiver);
static void user_stream_restart (UserStream* self);
void user_stream_start (UserStream* self);
static void user_stream_start_heartbeat_timeout (UserStream* self);
static void user_stream_parse_data_cb (UserStream* self, RestProxyCall* call, const gchar* buf, gsize length, GError* _error_);
static void _user_stream_parse_data_cb_rest_proxy_call_continuous_callback (RestProxyCall* call, const gchar* buf, gsize len, GError* _error_, GObject* weak_object, gpointer self);
void user_stream_stop (UserStream* self);
static gboolean __lambda12_ (UserStream* self);
static gboolean ___lambda12__gsource_func (gpointer self);
static gboolean __lambda11_ (UserStream* self);
static gboolean ___lambda11__gsource_func (gpointer self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
void account_set_friends (Account* self, JsonArray* friends_array);
static StreamMessageType user_stream_get_event_type (UserStream* self, const gchar* evt_str);
void imessage_receiver_stream_message_received (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
static void _vala_JsonNode_free (JsonNode* self);
void user_stream_set_token (UserStream* self, const gchar* value);
void user_stream_set_token_secret (UserStream* self, const gchar* value);
static void user_stream_finalize (GObject* obj);
static void _vala_user_stream_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType stream_message_type_get_type (void) {
	static volatile gsize stream_message_type_type_id__volatile = 0;
	if (g_once_init_enter (&stream_message_type_type_id__volatile)) {
		static const GEnumValue values[] = {{STREAM_MESSAGE_TYPE_UNSUPPORTED, "STREAM_MESSAGE_TYPE_UNSUPPORTED", "unsupported"}, {STREAM_MESSAGE_TYPE_DELETE, "STREAM_MESSAGE_TYPE_DELETE", "delete"}, {STREAM_MESSAGE_TYPE_SCRUB_GEO, "STREAM_MESSAGE_TYPE_SCRUB_GEO", "scrub-geo"}, {STREAM_MESSAGE_TYPE_LIMIT, "STREAM_MESSAGE_TYPE_LIMIT", "limit"}, {STREAM_MESSAGE_TYPE_DISCONNECT, "STREAM_MESSAGE_TYPE_DISCONNECT", "disconnect"}, {STREAM_MESSAGE_TYPE_FRIENDS, "STREAM_MESSAGE_TYPE_FRIENDS", "friends"}, {STREAM_MESSAGE_TYPE_EVENT, "STREAM_MESSAGE_TYPE_EVENT", "event"}, {STREAM_MESSAGE_TYPE_WARNING, "STREAM_MESSAGE_TYPE_WARNING", "warning"}, {STREAM_MESSAGE_TYPE_DIRECT_MESSAGE, "STREAM_MESSAGE_TYPE_DIRECT_MESSAGE", "direct-message"}, {STREAM_MESSAGE_TYPE_TWEET, "STREAM_MESSAGE_TYPE_TWEET", "tweet"}, {STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED, "STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED", "event-list-created"}, {STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED, "STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED", "event-list-destroyed"}, {STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED, "STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED", "event-list-updated"}, {STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED, "STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED", "event-list-unsubscribed"}, {STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED, "STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED", "event-list-subscribed"}, {STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED, "STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED", "event-list-member-added"}, {STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED, "STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED", "event-list-member-removed"}, {STREAM_MESSAGE_TYPE_EVENT_FAVORITE, "STREAM_MESSAGE_TYPE_EVENT_FAVORITE", "event-favorite"}, {STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE, "STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE", "event-unfavorite"}, {STREAM_MESSAGE_TYPE_EVENT_FOLLOW, "STREAM_MESSAGE_TYPE_EVENT_FOLLOW", "event-follow"}, {STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW, "STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW", "event-unfollow"}, {STREAM_MESSAGE_TYPE_EVENT_BLOCK, "STREAM_MESSAGE_TYPE_EVENT_BLOCK", "event-block"}, {STREAM_MESSAGE_TYPE_EVENT_UNBLOCK, "STREAM_MESSAGE_TYPE_EVENT_UNBLOCK", "event-unblock"}, {STREAM_MESSAGE_TYPE_EVENT_MUTE, "STREAM_MESSAGE_TYPE_EVENT_MUTE", "event-mute"}, {STREAM_MESSAGE_TYPE_EVENT_UNMUTE, "STREAM_MESSAGE_TYPE_EVENT_UNMUTE", "event-unmute"}, {STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE, "STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE", "event-user-update"}, {0, NULL, NULL}};
		GType stream_message_type_type_id;
		stream_message_type_type_id = g_enum_register_static ("StreamMessageType", values);
		g_once_init_leave (&stream_message_type_type_id__volatile, stream_message_type_type_id);
	}
	return stream_message_type_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _user_stream_network_changed_cb_g_network_monitor_network_changed (GNetworkMonitor* _sender, gboolean available, gpointer self) {
	user_stream_network_changed_cb ((UserStream*) self, available);
}


UserStream* user_stream_construct (GType object_type, Account* account) {
	UserStream * self = NULL;
	Account* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	OAuthProxy* _tmp12_ = NULL;
	GNetworkMonitor* _tmp13_ = NULL;
	GNetworkMonitor* _tmp14_ = NULL;
	GNetworkMonitor* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GNetworkMonitor* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (UserStream*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	_tmp1_ = account_get_screen_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->account_name);
	self->priv->account_name = _tmp3_;
	_tmp4_ = account;
	self->priv->account = _tmp4_;
	_tmp5_ = self->priv->account_name;
	_tmp6_ = g_strconcat ("CREATING USER STREAM FOR ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	g_debug ("UserStream.vala:80: %s", _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = settings_get_consumer_key ();
	_tmp9_ = _tmp8_;
	_tmp10_ = settings_get_consumer_secret ();
	_tmp11_ = _tmp10_;
	_tmp12_ = (OAuthProxy*) oauth_proxy_new (_tmp9_, _tmp11_, "https://userstream.twitter.com/", FALSE);
	_g_object_unref0 (self->priv->proxy);
	self->priv->proxy = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp13_ = g_network_monitor_get_default ();
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (self->priv->network_monitor);
	self->priv->network_monitor = _tmp14_;
	_tmp15_ = self->priv->network_monitor;
	_tmp16_ = g_network_monitor_get_network_available (_tmp15_);
	self->priv->network_available = _tmp16_;
	_tmp17_ = self->priv->network_monitor;
	g_signal_connect_object (_tmp17_, "network-changed", (GCallback) _user_stream_network_changed_cb_g_network_monitor_network_changed, self, 0);
	_tmp18_ = self->priv->network_available;
	if (!_tmp18_) {
		user_stream_start_network_timeout (self);
	}
	return self;
}


UserStream* user_stream_new (Account* account) {
	return user_stream_construct (TYPE_USER_STREAM, account);
}


void user_stream_register (UserStream* self, IMessageReceiver* receiver) {
	IMessageReceiver* _tmp0_ = NULL;
	g_return_if_fail (IS_USER_STREAM (self));
	g_return_if_fail (IS_IMESSAGE_RECEIVER (receiver));
	_tmp0_ = receiver;
	self->priv->receivers = g_slist_append (self->priv->receivers, _tmp0_);
}


static void user_stream_network_changed_cb (UserStream* self, gboolean available) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (IS_USER_STREAM (self));
	_tmp0_ = available;
	_tmp1_ = self->priv->network_available;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = available;
	self->priv->network_available = _tmp2_;
	_tmp3_ = self->priv->network_available;
	if (_tmp3_) {
		g_debug ("UserStream.vala:107: Restarting stream (reason: Network available (cal" \
"lback))");
		user_stream_restart (self);
		g_signal_emit_by_name (self, "resumed");
	} else {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = self->priv->account_name;
		g_debug ("UserStream.vala:111: Connection lost (%s) Reason: network unavailable", _tmp4_);
		g_signal_emit_by_name (self, "interrupted");
		user_stream_start_network_timeout (self);
	}
}


/**
   * Starts the UserStream
   */
static void _user_stream_parse_data_cb_rest_proxy_call_continuous_callback (RestProxyCall* call, const gchar* buf, gsize len, GError* _error_, GObject* weak_object, gpointer self) {
	user_stream_parse_data_cb ((UserStream*) self, call, buf, len, _error_);
}


void user_stream_start (UserStream* self) {
	const gchar* _tmp0_ = NULL;
	OAuthProxy* _tmp1_ = NULL;
	RestProxyCall* _tmp2_ = NULL;
	RestProxyCall* _tmp3_ = NULL;
	RestProxyCall* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_USER_STREAM (self));
	_tmp0_ = self->priv->account_name;
	g_debug ("UserStream.vala:123: Starting stream for %s", _tmp0_);
	_tmp1_ = self->priv->proxy;
	_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, rest_proxy_get_type (), RestProxy));
	_g_object_unref0 (self->priv->proxy_call);
	self->priv->proxy_call = _tmp2_;
	_tmp3_ = self->priv->proxy_call;
	rest_proxy_call_set_function (_tmp3_, "1.1/user.json");
	_tmp4_ = self->priv->proxy_call;
	rest_proxy_call_set_method (_tmp4_, "GET");
	user_stream_start_heartbeat_timeout (self);
	{
		RestProxyCall* _tmp5_ = NULL;
		RestProxyCall* _tmp6_ = NULL;
		_tmp5_ = self->priv->proxy_call;
		_tmp6_ = self->priv->proxy_call;
		rest_proxy_call_continuous (_tmp5_, _user_stream_parse_data_cb_rest_proxy_call_continuous_callback, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, G_TYPE_OBJECT, GObject), self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e->message;
		g_error ("UserStream.vala:133: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
   * Stops the UserStream
   */
void user_stream_stop (UserStream* self) {
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	RestProxyCall* _tmp7_ = NULL;
	g_return_if_fail (IS_USER_STREAM (self));
	self->priv->running = FALSE;
	_tmp0_ = self->priv->network_timeout_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->network_timeout_id;
		g_source_remove (_tmp1_);
		self->priv->network_timeout_id = (guint) 0;
	}
	_tmp2_ = self->priv->heartbeat_timeout_id;
	if (_tmp2_ != ((guint) 0)) {
		guint _tmp3_ = 0U;
		_tmp3_ = self->priv->heartbeat_timeout_id;
		g_source_remove (_tmp3_);
		self->priv->heartbeat_timeout_id = (guint) 0;
	}
	_tmp4_ = self->priv->account_name;
	_tmp5_ = g_strconcat ("STOPPING STREAM FOR ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	g_debug ("UserStream.vala:153: %s", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->proxy_call;
	rest_proxy_call_cancel (_tmp7_);
}


static void user_stream_restart (UserStream* self) {
	g_return_if_fail (IS_USER_STREAM (self));
	user_stream_stop (self);
	user_stream_start (self);
}


static gboolean __lambda12_ (UserStream* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean available = FALSE;
	GNetworkMonitor* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = self->priv->running;
	if (_tmp0_) {
		result = G_SOURCE_REMOVE;
		return result;
	}
	_tmp1_ = self->priv->network_monitor;
	_tmp2_ = g_network_monitor_get_network_available (_tmp1_);
	available = _tmp2_;
	_tmp3_ = available;
	if (_tmp3_) {
		g_debug ("UserStream.vala:169: Restarting stream (reason: network available (tim" \
"eout))");
		user_stream_restart (self);
		result = G_SOURCE_REMOVE;
		return result;
	}
	result = G_SOURCE_CONTINUE;
	return result;
}


static gboolean ___lambda12__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda12_ ((UserStream*) self);
	return result;
}


static void user_stream_start_network_timeout (UserStream* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (IS_USER_STREAM (self));
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (30 * 1000), ___lambda12__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->network_timeout_id = _tmp0_;
}


static gboolean __lambda11_ (UserStream* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = self->priv->account_name;
	g_debug ("UserStream.vala:182: Connection lost (%s) Reason: heartbeat. Restartin" \
"g...", _tmp0_);
	user_stream_restart (self);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ___lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda11_ ((UserStream*) self);
	return result;
}


static void user_stream_start_heartbeat_timeout (UserStream* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (IS_USER_STREAM (self));
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (45 * 1000), ___lambda11__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->heartbeat_timeout_id = _tmp0_;
}


/**
   * Callback called by the Rest.ProxyCall whenever it receives data.
   *
   * @param call The Rest.ProxyCall created when the UserStream was started.
   * @param buf The string received
   * @param length The buffer's length
   * @param error
   */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void user_stream_parse_data_cb (UserStream* self, RestProxyCall* call, const gchar* buf, gsize length, GError* _error_) {
	const gchar* _tmp0_ = NULL;
	gchar* real = NULL;
	const gchar* _tmp1_ = NULL;
	gsize _tmp2_ = 0UL;
	gchar* _tmp3_ = NULL;
	GString* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_USER_STREAM (self));
	g_return_if_fail (REST_IS_PROXY_CALL (call));
	_tmp0_ = buf;
	if (_tmp0_ == NULL) {
		g_warning ("UserStream.vala:206: buf == NULL");
		return;
	}
	_tmp1_ = buf;
	_tmp2_ = length;
	_tmp3_ = string_substring (_tmp1_, (glong) 0, (glong) ((gint) _tmp2_));
	real = _tmp3_;
	_tmp4_ = self->priv->data;
	_tmp5_ = real;
	g_string_append (_tmp4_, _tmp5_);
	_tmp7_ = real;
	_tmp8_ = g_str_has_suffix (_tmp7_, "\r\n");
	if (_tmp8_) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = real;
		_tmp10_ = g_str_has_suffix (_tmp9_, "\r");
		_tmp6_ = _tmp10_;
	}
	if (_tmp6_) {
		const gchar* _tmp11_ = NULL;
		GString* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		JsonParser* parser = NULL;
		JsonParser* _tmp22_ = NULL;
		JsonNode* root_node = NULL;
		JsonParser* _tmp31_ = NULL;
		JsonNode* _tmp32_ = NULL;
		JsonNode* _tmp33_ = NULL;
		JsonObject* root = NULL;
		JsonNode* _tmp34_ = NULL;
		JsonObject* _tmp35_ = NULL;
		JsonObject* _tmp36_ = NULL;
		StreamMessageType type = 0;
		JsonObject* _tmp37_ = NULL;
		gboolean _tmp38_ = FALSE;
		GSList* _tmp65_ = NULL;
		GString* _tmp70_ = NULL;
		_tmp11_ = real;
		if (g_strcmp0 (_tmp11_, "\r\n") == 0) {
			const gchar* _tmp12_ = NULL;
			GString* _tmp13_ = NULL;
			guint _tmp14_ = 0U;
			_tmp12_ = self->priv->account_name;
			g_debug ("UserStream.vala:217: HEARTBEAT(%s)", _tmp12_);
			_tmp13_ = self->priv->data;
			g_string_erase (_tmp13_, (gssize) 0, (gssize) (-1));
			_tmp14_ = self->priv->heartbeat_timeout_id;
			if (_tmp14_ != ((guint) 0)) {
				guint _tmp15_ = 0U;
				_tmp15_ = self->priv->heartbeat_timeout_id;
				g_source_remove (_tmp15_);
				self->priv->heartbeat_timeout_id = (guint) 0;
			}
			user_stream_start_heartbeat_timeout (self);
			_g_free0 (real);
			return;
		}
		_tmp16_ = self->priv->data;
		_tmp17_ = _tmp16_->str;
		_tmp18_ = string_strip (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strcmp0 (_tmp19_, "OK") == 0;
		_g_free0 (_tmp19_);
		if (_tmp20_) {
			GString* _tmp21_ = NULL;
			_tmp21_ = self->priv->data;
			g_string_erase (_tmp21_, (gssize) 0, (gssize) (-1));
			_g_free0 (real);
			return;
		}
		_tmp22_ = json_parser_new ();
		parser = _tmp22_;
		{
			JsonParser* _tmp23_ = NULL;
			GString* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			_tmp23_ = parser;
			_tmp24_ = self->priv->data;
			_tmp25_ = _tmp24_->str;
			json_parser_load_from_data (_tmp23_, _tmp25_, (gssize) (-1), &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch8_g_error;
			}
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError* e = NULL;
			GError* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			GString* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			GString* _tmp30_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp26_ = e;
			_tmp27_ = _tmp26_->message;
			g_critical ("UserStream.vala:240: %s", _tmp27_);
			_tmp28_ = self->priv->data;
			_tmp29_ = _tmp28_->str;
			g_critical ("UserStream.vala:241: %s", _tmp29_);
			_tmp30_ = self->priv->data;
			g_string_erase (_tmp30_, (gssize) 0, (gssize) (-1));
			_g_error_free0 (e);
			_g_object_unref0 (parser);
			_g_free0 (real);
			return;
		}
		__finally8:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (parser);
			_g_free0 (real);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->running = TRUE;
		_tmp31_ = parser;
		_tmp32_ = json_parser_get_root (_tmp31_);
		_tmp33_ = __vala_JsonNode_copy0 (_tmp32_);
		root_node = _tmp33_;
		_tmp34_ = root_node;
		_tmp35_ = json_node_get_object (_tmp34_);
		_tmp36_ = _json_object_ref0 (_tmp35_);
		root = _tmp36_;
		type = 0;
		_tmp37_ = root;
		_tmp38_ = json_object_has_member (_tmp37_, "delete");
		if (_tmp38_) {
			type = STREAM_MESSAGE_TYPE_DELETE;
		} else {
			JsonObject* _tmp39_ = NULL;
			gboolean _tmp40_ = FALSE;
			_tmp39_ = root;
			_tmp40_ = json_object_has_member (_tmp39_, "scrub_geo");
			if (_tmp40_) {
				type = STREAM_MESSAGE_TYPE_SCRUB_GEO;
			} else {
				JsonObject* _tmp41_ = NULL;
				gboolean _tmp42_ = FALSE;
				_tmp41_ = root;
				_tmp42_ = json_object_has_member (_tmp41_, "limit");
				if (_tmp42_) {
					type = STREAM_MESSAGE_TYPE_LIMIT;
				} else {
					JsonObject* _tmp43_ = NULL;
					gboolean _tmp44_ = FALSE;
					_tmp43_ = root;
					_tmp44_ = json_object_has_member (_tmp43_, "disconnect");
					if (_tmp44_) {
						type = STREAM_MESSAGE_TYPE_DISCONNECT;
					} else {
						JsonObject* _tmp45_ = NULL;
						gboolean _tmp46_ = FALSE;
						_tmp45_ = root;
						_tmp46_ = json_object_has_member (_tmp45_, "friends");
						if (_tmp46_) {
							Account* _tmp47_ = NULL;
							JsonObject* _tmp48_ = NULL;
							JsonArray* _tmp49_ = NULL;
							_tmp47_ = self->priv->account;
							_tmp48_ = root;
							_tmp49_ = json_object_get_array_member (_tmp48_, "friends");
							account_set_friends (_tmp47_, _tmp49_);
							type = STREAM_MESSAGE_TYPE_FRIENDS;
						} else {
							JsonObject* _tmp50_ = NULL;
							gboolean _tmp51_ = FALSE;
							_tmp50_ = root;
							_tmp51_ = json_object_has_member (_tmp50_, "text");
							if (_tmp51_) {
								type = STREAM_MESSAGE_TYPE_TWEET;
							} else {
								JsonObject* _tmp52_ = NULL;
								gboolean _tmp53_ = FALSE;
								_tmp52_ = root;
								_tmp53_ = json_object_has_member (_tmp52_, "event");
								if (_tmp53_) {
									gchar* evt_str = NULL;
									JsonObject* _tmp54_ = NULL;
									const gchar* _tmp55_ = NULL;
									gchar* _tmp56_ = NULL;
									const gchar* _tmp57_ = NULL;
									StreamMessageType _tmp58_ = 0;
									_tmp54_ = root;
									_tmp55_ = json_object_get_string_member (_tmp54_, "event");
									_tmp56_ = g_strdup (_tmp55_);
									evt_str = _tmp56_;
									_tmp57_ = evt_str;
									_tmp58_ = user_stream_get_event_type (self, _tmp57_);
									type = _tmp58_;
									_g_free0 (evt_str);
								} else {
									JsonObject* _tmp59_ = NULL;
									gboolean _tmp60_ = FALSE;
									_tmp59_ = root;
									_tmp60_ = json_object_has_member (_tmp59_, "warning");
									if (_tmp60_) {
										type = STREAM_MESSAGE_TYPE_WARNING;
									} else {
										JsonObject* _tmp61_ = NULL;
										gboolean _tmp62_ = FALSE;
										_tmp61_ = root;
										_tmp62_ = json_object_has_member (_tmp61_, "direct_message");
										if (_tmp62_) {
											type = STREAM_MESSAGE_TYPE_DIRECT_MESSAGE;
										} else {
											JsonObject* _tmp63_ = NULL;
											gboolean _tmp64_ = FALSE;
											_tmp63_ = root;
											_tmp64_ = json_object_has_member (_tmp63_, "status_withheld");
											if (_tmp64_) {
												type = STREAM_MESSAGE_TYPE_UNSUPPORTED;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		_tmp65_ = self->priv->receivers;
		{
			GSList* it_collection = NULL;
			GSList* it_it = NULL;
			it_collection = _tmp65_;
			for (it_it = it_collection; it_it != NULL; it_it = it_it->next) {
				IMessageReceiver* _tmp66_ = NULL;
				IMessageReceiver* it = NULL;
				_tmp66_ = _g_object_ref0 ((IMessageReceiver*) it_it->data);
				it = _tmp66_;
				{
					IMessageReceiver* _tmp67_ = NULL;
					StreamMessageType _tmp68_ = 0;
					JsonNode* _tmp69_ = NULL;
					_tmp67_ = it;
					_tmp68_ = type;
					_tmp69_ = root_node;
					imessage_receiver_stream_message_received (_tmp67_, _tmp68_, _tmp69_);
					_g_object_unref0 (it);
				}
			}
		}
		_tmp70_ = self->priv->data;
		g_string_erase (_tmp70_, (gssize) 0, (gssize) (-1));
		_json_object_unref0 (root);
		__vala_JsonNode_free0 (root_node);
		_g_object_unref0 (parser);
	}
	_g_free0 (real);
}


static StreamMessageType user_stream_get_event_type (UserStream* self, const gchar* evt_str) {
	StreamMessageType result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	static GQuark _tmp2_label13 = 0;
	static GQuark _tmp2_label14 = 0;
	static GQuark _tmp2_label15 = 0;
	g_return_val_if_fail (IS_USER_STREAM (self), 0);
	g_return_val_if_fail (evt_str != NULL, 0);
	_tmp0_ = evt_str;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("follow")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_FOLLOW;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("list_created")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("list_destroyed")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("list_updated")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("list_user_unsubscribed")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("list_user_subscribed")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("list_member_added")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("list_member_removed")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("favorite")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_FAVORITE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("unfavorite")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("unfollow")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("block")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_BLOCK;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("unblock")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_UNBLOCK;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("mute")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_MUTE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("unmute")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_UNMUTE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label15) ? _tmp2_label15 : (_tmp2_label15 = g_quark_from_static_string ("user_update")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE;
				return result;
			}
		}
	}
	result = 0;
	return result;
}


void user_stream_set_token (UserStream* self, const gchar* value) {
	OAuthProxy* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_USER_STREAM (self));
	_tmp0_ = self->priv->proxy;
	_tmp1_ = value;
	oauth_proxy_set_token (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "token");
}


void user_stream_set_token_secret (UserStream* self, const gchar* value) {
	OAuthProxy* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_USER_STREAM (self));
	_tmp0_ = self->priv->proxy;
	_tmp1_ = value;
	oauth_proxy_set_token_secret (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "token-secret");
}


static void user_stream_class_init (UserStreamClass * klass) {
	user_stream_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserStreamPrivate));
	G_OBJECT_CLASS (klass)->set_property = _vala_user_stream_set_property;
	G_OBJECT_CLASS (klass)->finalize = user_stream_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_STREAM_TOKEN, g_param_spec_string ("token", "token", "token", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_STREAM_TOKEN_SECRET, g_param_spec_string ("token-secret", "token-secret", "token-secret", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_signal_new ("interrupted", TYPE_USER_STREAM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("resumed", TYPE_USER_STREAM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void user_stream_instance_init (UserStream * self) {
	GString* _tmp0_ = NULL;
	self->priv = USER_STREAM_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->priv->data = _tmp0_;
	self->priv->receivers = NULL;
	self->priv->network_timeout_id = (guint) 0;
	self->priv->heartbeat_timeout_id = (guint) 0;
	self->priv->running = FALSE;
}


static void user_stream_finalize (GObject* obj) {
	UserStream * self;
	const gchar* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_STREAM, UserStream);
	_tmp0_ = self->priv->account_name;
	g_debug ("UserStream.vala:190: USERSTREAM for %s DESTROYED", _tmp0_);
	_g_object_unref0 (self->priv->proxy);
	_g_object_unref0 (self->priv->proxy_call);
	_g_string_free0 (self->priv->data);
	_g_slist_free0 (self->priv->receivers);
	_g_object_unref0 (self->priv->network_monitor);
	_g_free0 (self->priv->account_name);
	G_OBJECT_CLASS (user_stream_parent_class)->finalize (obj);
}


GType user_stream_get_type (void) {
	static volatile gsize user_stream_type_id__volatile = 0;
	if (g_once_init_enter (&user_stream_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserStreamClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_stream_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserStream), 0, (GInstanceInitFunc) user_stream_instance_init, NULL };
		GType user_stream_type_id;
		user_stream_type_id = g_type_register_static (G_TYPE_OBJECT, "UserStream", &g_define_type_info, 0);
		g_once_init_leave (&user_stream_type_id__volatile, user_stream_type_id);
	}
	return user_stream_type_id__volatile;
}


static void _vala_user_stream_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UserStream * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_STREAM, UserStream);
	switch (property_id) {
		case USER_STREAM_TOKEN:
		user_stream_set_token (self, g_value_get_string (value));
		break;
		case USER_STREAM_TOKEN_SECRET:
		user_stream_set_token_secret (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



