/* ListStatusesPage.c generated by valac 0.26.2, the Vala compiler
 * generated from ListStatusesPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_LIST_STATUSES_PAGE (list_statuses_page_get_type ())
#define LIST_STATUSES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_STATUSES_PAGE, ListStatusesPage))
#define LIST_STATUSES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_STATUSES_PAGE, ListStatusesPageClass))
#define IS_LIST_STATUSES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_STATUSES_PAGE))
#define IS_LIST_STATUSES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_STATUSES_PAGE))
#define LIST_STATUSES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_STATUSES_PAGE, ListStatusesPageClass))

typedef struct _ListStatusesPage ListStatusesPage;
typedef struct _ListStatusesPageClass ListStatusesPageClass;
typedef struct _ListStatusesPagePrivate ListStatusesPagePrivate;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_MAX_SIZE_CONTAINER (max_size_container_get_type ())
#define MAX_SIZE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainer))
#define MAX_SIZE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainerClass))
#define IS_MAX_SIZE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAX_SIZE_CONTAINER))
#define IS_MAX_SIZE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAX_SIZE_CONTAINER))
#define MAX_SIZE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainerClass))

typedef struct _MaxSizeContainer MaxSizeContainer;
typedef struct _MaxSizeContainerClass MaxSizeContainerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

#define TWEET_UTILS_TYPE_WORKER_RESULT (tweet_utils_worker_result_get_type ())
typedef struct _TweetUtilsWorkerResult TweetUtilsWorkerResult;
typedef struct _ListStatusesPageLoadNewestData ListStatusesPageLoadNewestData;
typedef struct _ListStatusesPageLoadOlderData ListStatusesPageLoadOlderData;
typedef struct _Block33Data Block33Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block34Data Block34Data;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
typedef struct _Block35Data Block35Data;
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
typedef struct _ListStatusesPageLoadNewerData ListStatusesPageLoadNewerData;
typedef struct _Block36Data Block36Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

struct _ListStatusesPage {
	ScrollWidget parent_instance;
	ListStatusesPagePrivate * priv;
};

struct _ListStatusesPageClass {
	ScrollWidgetClass parent_class;
};

struct _ListStatusesPagePrivate {
	gint _id;
	MainWindow* _main_window;
	Account* _account;
	DeltaUpdater* _delta_updater;
	gint64 list_id;
	gint64 lowest_id;
	gint64 max_id;
	guint tweet_remove_timeout;
	TweetListBox* tweet_list;
	MaxSizeContainer* max_size_container;
	GtkMenuButton* delete_button;
	GtkButton* edit_button;
	GtkLabel* description_label;
	GtkLabel* name_label;
	GtkLabel* creator_label;
	GtkLabel* subscribers_label;
	GtkLabel* members_label;
	GtkLabel* created_at_label;
	GtkStack* name_stack;
	GtkEntry* name_entry;
	GtkStack* description_stack;
	GtkEntry* description_entry;
	GtkStack* delete_stack;
	GtkButton* cancel_button;
	GtkStack* edit_stack;
	GtkButton* save_button;
	GtkStack* mode_stack;
	GtkLabel* mode_label;
	GtkComboBoxText* mode_combo_box;
	GtkButton* refresh_button;
	gboolean loading;
};

struct _TweetUtilsWorkerResult {
	gint64 max_id;
	gint64 min_id;
};

struct _ListStatusesPageLoadNewestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ListStatusesPage* self;
	TweetListBox* _tmp0_;
	guint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	OAuthProxy* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	gint64 _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	RestProxyCall* _tmp11_;
	gint64 _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	RestProxyCall* _tmp15_;
	guint _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	JsonNode* root;
	RestProxyCall* _tmp19_;
	JsonNode* _tmp20_;
	JsonNode* _tmp21_;
	JsonArray* root_array;
	JsonNode* _tmp22_;
	JsonArray* _tmp23_;
	JsonArray* _tmp24_;
	JsonArray* _tmp25_;
	guint _tmp26_;
	TweetListBox* _tmp27_;
	TweetUtilsWorkerResult res;
	JsonArray* _tmp28_;
	guint _tmp29_;
	DeltaUpdater* _tmp30_;
	TweetListBox* _tmp31_;
	MainWindow* _tmp32_;
	MainWindow* _tmp33_;
	Account* _tmp34_;
	Account* _tmp35_;
	TweetUtilsWorkerResult _tmp36_;
	TweetUtilsWorkerResult _tmp37_;
	gint64 _tmp38_;
	gint64 _tmp39_;
	TweetUtilsWorkerResult _tmp40_;
	gint64 _tmp41_;
	TweetUtilsWorkerResult _tmp42_;
	gint64 _tmp43_;
	gint64 _tmp44_;
	TweetUtilsWorkerResult _tmp45_;
	gint64 _tmp46_;
};

struct _ListStatusesPageLoadOlderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ListStatusesPage* self;
	gboolean _tmp0_;
	guint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	OAuthProxy* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	RestProxyCall* _tmp8_;
	gint64 _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	RestProxyCall* _tmp12_;
	gint64 _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	RestProxyCall* _tmp16_;
	guint _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	JsonNode* root;
	RestProxyCall* _tmp20_;
	JsonNode* _tmp21_;
	JsonNode* _tmp22_;
	JsonArray* root_array;
	JsonNode* _tmp23_;
	JsonArray* _tmp24_;
	JsonArray* _tmp25_;
	TweetUtilsWorkerResult res;
	JsonArray* _tmp26_;
	guint _tmp27_;
	DeltaUpdater* _tmp28_;
	TweetListBox* _tmp29_;
	MainWindow* _tmp30_;
	MainWindow* _tmp31_;
	Account* _tmp32_;
	Account* _tmp33_;
	TweetUtilsWorkerResult _tmp34_;
	TweetUtilsWorkerResult _tmp35_;
	gint64 _tmp36_;
	gint64 _tmp37_;
	TweetUtilsWorkerResult _tmp38_;
	gint64 _tmp39_;
	TweetUtilsWorkerResult _tmp40_;
	gint64 _tmp41_;
	gint64 _tmp42_;
	TweetUtilsWorkerResult _tmp43_;
	gint64 _tmp44_;
};

struct _Block33Data {
	int _ref_count_;
	ListStatusesPage* self;
	RestProxyCall* call;
};

struct _Block34Data {
	int _ref_count_;
	ListStatusesPage* self;
	RestProxyCall* call;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
	gboolean (*get_seen) (ITwitterItem* self);
	void (*set_seen) (ITwitterItem* self, gboolean value);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	gchar* notification_id;
	Tweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _Block35Data {
	int _ref_count_;
	ListStatusesPage* self;
	GDateTime* now;
	gpointer _async_data_;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	gint64 id;
	gint64 rt_id;
	gchar* text;
	gint64 user_id;
	gchar* user_name;
	gchar* retweeted_by;
	gchar* rt_by_screen_name;
	gint64 rt_by_id;
	gboolean is_retweet;
	GdkPixbuf* inline_media;
	gchar* time_delta;
	gchar* avatar_url;
	gchar* avatar_name;
	gchar* screen_name;
	gint64 created_at;
	gint64 rt_created_at;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gint64 reply_id;
	Media** medias;
	gint medias_length1;
	gint retweet_count;
	gint favorite_count;
	gchar** mentions;
	gint mentions_length1;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _ListStatusesPageLoadNewerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ListStatusesPage* self;
	Block35Data* _data35_;
	gint64 _tmp0_;
	RestProxyCall* call;
	Account* _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	OAuthProxy* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	RestProxyCall* _tmp8_;
	gint64 _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	RestProxyCall* _tmp12_;
	gint64 _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gint64 _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	RestProxyCall* _tmp21_;
	GError* e;
	RestProxyCall* _tmp22_;
	const gchar* _tmp23_;
	GError* _tmp24_;
	const gchar* _tmp25_;
	JsonParser* parser;
	JsonParser* _tmp26_;
	JsonParser* _tmp27_;
	RestProxyCall* _tmp28_;
	const gchar* _tmp29_;
	GError* _vala1_e;
	GError* _tmp30_;
	const gchar* _tmp31_;
	JsonArray* root_arr;
	JsonParser* _tmp32_;
	JsonNode* _tmp33_;
	JsonArray* _tmp34_;
	JsonArray* _tmp35_;
	GDateTime* _tmp36_;
	JsonArray* _tmp37_;
	GError * _inner_error_;
};

struct _Block36Data {
	int _ref_count_;
	ListStatusesPage* self;
	guint item_count;
};


static gpointer list_statuses_page_parent_class = NULL;
static IPageIface* list_statuses_page_ipage_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType list_statuses_page_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType max_size_container_get_type (void) G_GNUC_CONST;
#define LIST_STATUSES_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIST_STATUSES_PAGE, ListStatusesPagePrivate))
enum  {
	LIST_STATUSES_PAGE_DUMMY_PROPERTY,
	LIST_STATUSES_PAGE_ID,
	LIST_STATUSES_PAGE_MAIN_WINDOW,
	LIST_STATUSES_PAGE_ACCOUNT,
	LIST_STATUSES_PAGE_DELTA_UPDATER
};
ListStatusesPage* list_statuses_page_new (gint id);
ListStatusesPage* list_statuses_page_construct (GType object_type, gint id);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
static gboolean list_statuses_page_scroll_event_cb (ListStatusesPage* self, GdkEventScroll* evt);
static gboolean _list_statuses_page_scroll_event_cb_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
static void list_statuses_page_load_older (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void list_statuses_page_load_older_finish (ListStatusesPage* self, GAsyncResult* _res_);
static void _list_statuses_page_load_older_scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self);
void list_statuses_page_handle_scrolled_to_start (ListStatusesPage* self);
static void _list_statuses_page_handle_scrolled_to_start_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self);
gint itwitter_item_sort_func (GtkListBoxRow* a, GtkListBoxRow* b);
static gint _itwitter_item_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
gint max_size_container_get_max_size (MaxSizeContainer* self);
void max_size_container_set_max_size (MaxSizeContainer* self, gint value);
static void list_statuses_page_real_on_join (IPage* base, gint page_id, Bundle* args);
gint64 bundle_get_int64 (Bundle* self, const gchar* key);
gchar* bundle_get_string (Bundle* self, const gchar* key);
gboolean bundle_get_bool (Bundle* self, const gchar* key);
gint bundle_get_int (Bundle* self, const gchar* key);
gchar* utils_capitalize (const gchar* s);
static void list_statuses_page_load_newer (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void list_statuses_page_load_newer_finish (ListStatusesPage* self, GAsyncResult* _res_);
void tweet_list_box_remove_all (TweetListBox* self);
static void list_statuses_page_load_newest (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void list_statuses_page_load_newest_finish (ListStatusesPage* self, GAsyncResult* _res_);
static void list_statuses_page_real_on_leave (IPage* base);
static void list_statuses_page_load_newest_data_free (gpointer _data);
static gboolean list_statuses_page_load_newest_co (ListStatusesPageLoadNewestData* _data_);
void tweet_list_box_set_unempty (TweetListBox* self);
Account* ipage_get_account (IPage* self);
OAuthProxy* account_get_proxy (Account* self);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_);
static void list_statuses_page_load_newest_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_JsonNode_free (JsonNode* self);
void tweet_list_box_set_empty (TweetListBox* self);
GType tweet_utils_worker_result_get_type (void) G_GNUC_CONST;
TweetUtilsWorkerResult* tweet_utils_worker_result_dup (const TweetUtilsWorkerResult* self);
void tweet_utils_worker_result_free (TweetUtilsWorkerResult* self);
void tweet_utils_work_array (JsonArray* json_array, guint requested_tweet_count, DeltaUpdater* delta_updater, TweetListBox* tweet_list, MainWindow* main_window, Account* account, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_work_array_finish (GAsyncResult* _res_, TweetUtilsWorkerResult* result);
DeltaUpdater* list_statuses_page_get_delta_updater (ListStatusesPage* self);
MainWindow* ipage_get_main_window (IPage* self);
static void list_statuses_page_load_older_data_free (gpointer _data);
static gboolean list_statuses_page_load_older_co (ListStatusesPageLoadOlderData* _data_);
static void list_statuses_page_load_older_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void list_statuses_page_edit_button_clicked_cb (ListStatusesPage* self);
static gchar* list_statuses_page_real_list_name (ListStatusesPage* self);
static void _list_statuses_page_edit_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_statuses_page_cancel_button_clicked_cb (ListStatusesPage* self);
static void _list_statuses_page_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_statuses_page_save_button_clicked_cb (ListStatusesPage* self);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
static void __lambda201_ (Block33Data* _data33_, GObject* o, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file);
static void ___lambda201__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _list_statuses_page_save_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_statuses_page_delete_confirmation_item_clicked_cb (ListStatusesPage* self);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
static void __lambda202_ (Block34Data* _data34_, GObject* o, GAsyncResult* res);
static void ___lambda202__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int (Bundle* self, const gchar* key, gint value);
#define LISTS_PAGE_MODE_DELETE 1
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void _list_statuses_page_delete_confirmation_item_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void list_statuses_page_refresh_button_clicked_cb (ListStatusesPage* self);
static void __lambda203_ (ListStatusesPage* self);
static void ___lambda203__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _list_statuses_page_refresh_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_statuses_page_tweet_activated_cb (ListStatusesPage* self, GtkListBoxRow* row);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
#define TWEET_INFO_PAGE_BY_INSTANCE 1
void bundle_put_object (Bundle* self, const gchar* key, GObject* object);
GType itwitter_item_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
static void _list_statuses_page_tweet_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void list_statuses_page_load_newer_data_free (gpointer _data);
static gboolean list_statuses_page_load_newer_co (ListStatusesPageLoadNewerData* _data_);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
static void list_statuses_page_load_newer_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda200_ (Block35Data* _data35_, JsonArray* array, guint index, JsonNode* node);
Tweet* tweet_new (void);
Tweet* tweet_construct (GType object_type);
void tweet_load_from_json (Tweet* self, JsonNode* status_node, GDateTime* now, Account* account);
GType media_get_type (void) G_GNUC_CONST;
TweetListEntry* tweet_list_entry_new (Tweet* tweet, MainWindow* window, Account* account);
TweetListEntry* tweet_list_entry_construct (GType object_type, Tweet* tweet, MainWindow* window, Account* account);
static void ___lambda200__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
#define ITIMELINE_REST 25
static gboolean ___lambda199_ (Block36Data* _data36_);
gboolean scroll_widget_get_scrolled_up (ScrollWidget* self);
static gboolean ____lambda199__gsource_func (gpointer self);
static gchar* list_statuses_page_real_get_title (IPage* base);
static void list_statuses_page_real_create_tool_button (IPage* base, GtkRadioButton* group);
static GtkRadioButton* list_statuses_page_real_get_tool_button (IPage* base);
void list_statuses_page_set_delta_updater (ListStatusesPage* self, DeltaUpdater* value);
static void list_statuses_page_finalize (GObject* obj);
gint ipage_get_id (IPage* self);
static void _vala_list_statuses_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_main_window (IPage* self, MainWindow* value);
void ipage_set_account (IPage* self, Account* value);
static void _vala_list_statuses_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gboolean _list_statuses_page_scroll_event_cb_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
	gboolean result;
	result = list_statuses_page_scroll_event_cb ((ListStatusesPage*) self, event);
	return result;
}


static void _list_statuses_page_load_older_scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self) {
	list_statuses_page_load_older ((ListStatusesPage*) self, NULL, NULL);
}


static void _list_statuses_page_handle_scrolled_to_start_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self) {
	list_statuses_page_handle_scrolled_to_start ((ListStatusesPage*) self);
}


static gint _itwitter_item_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = itwitter_item_sort_func (row1, row2);
	return result;
}


ListStatusesPage* list_statuses_page_construct (GType object_type, gint id) {
	ListStatusesPage * self = NULL;
	gint _tmp0_ = 0;
	TweetListBox* _tmp1_ = NULL;
	TweetListBox* _tmp2_ = NULL;
	GtkAdjustment* _tmp3_ = NULL;
	self = (ListStatusesPage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "scroll-event", (GCallback) _list_statuses_page_scroll_event_cb_gtk_widget_scroll_event, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), "scrolled-to-end", (GCallback) _list_statuses_page_load_older_scroll_widget_scrolled_to_end, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), "scrolled-to-start", (GCallback) _list_statuses_page_handle_scrolled_to_start_scroll_widget_scrolled_to_start, self, 0);
	_tmp1_ = self->priv->tweet_list;
	gtk_list_box_set_sort_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_list_box_get_type (), GtkListBox), _itwitter_item_sort_func_gtk_list_box_sort_func, NULL, NULL);
	_tmp2_ = self->priv->tweet_list;
	_tmp3_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	gtk_list_box_set_adjustment (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_box_get_type (), GtkListBox), _tmp3_);
	return self;
}


ListStatusesPage* list_statuses_page_new (gint id) {
	return list_statuses_page_construct (TYPE_LIST_STATUSES_PAGE, id);
}


static gboolean list_statuses_page_scroll_event_cb (ListStatusesPage* self, GdkEventScroll* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventScroll* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	g_return_val_if_fail (IS_LIST_STATUSES_PAGE (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->delta_y;
	if (_tmp2_ < ((gdouble) 0)) {
		GtkAdjustment* _tmp3_ = NULL;
		GtkAdjustment* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		_tmp3_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp4_ = _tmp3_;
		_tmp5_ = gtk_adjustment_get_value (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == ((gdouble) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint inc = 0;
		GtkAdjustment* _tmp7_ = NULL;
		GtkAdjustment* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
		gdouble _tmp10_ = 0.0;
		GdkEventScroll* _tmp11_ = NULL;
		gdouble _tmp12_ = 0.0;
		MaxSizeContainer* _tmp13_ = NULL;
		MaxSizeContainer* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		MaxSizeContainer* _tmp18_ = NULL;
		_tmp7_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp8_ = _tmp7_;
		_tmp9_ = gtk_adjustment_get_step_increment (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = evt;
		_tmp12_ = _tmp11_->delta_y;
		inc = (gint) (_tmp10_ * (-_tmp12_));
		_tmp13_ = self->priv->max_size_container;
		_tmp14_ = self->priv->max_size_container;
		_tmp15_ = max_size_container_get_max_size (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = inc;
		max_size_container_set_max_size (_tmp14_, _tmp16_ + _tmp17_);
		_tmp18_ = self->priv->max_size_container;
		gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


/**
   *
   *
   * va_list params:
   *  - int64 list_id - The id of the list to show
   *  - string name - The lists's name
   *  - bool user_list - true if the list belongs to the user, false otherwise
   *  - string description - the lists's description
   *  - string creator
   *  - int subscribers_count
   *  - int memebers_count
   *  - int64 created_at
   *  - string mode
   */
static void list_statuses_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	ListStatusesPage * self;
	gint64 list_id = 0LL;
	Bundle* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gchar* list_name = NULL;
	Bundle* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint64 _tmp49_ = 0LL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gint64 _tmp54_ = 0LL;
	gint64 _tmp55_ = 0LL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_tmp0_ = args;
	_tmp1_ = bundle_get_int64 (_tmp0_, "list_id");
	list_id = _tmp1_;
	_tmp2_ = list_id;
	if (_tmp2_ == ((gint64) 0)) {
		gint64 _tmp3_ = 0LL;
		_tmp3_ = self->priv->list_id;
		list_id = _tmp3_;
		return;
	}
	_tmp4_ = args;
	_tmp5_ = bundle_get_string (_tmp4_, "name");
	list_name = _tmp5_;
	_tmp6_ = list_name;
	if (_tmp6_ != NULL) {
		gboolean user_list = FALSE;
		Bundle* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gchar* description = NULL;
		Bundle* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* creator = NULL;
		Bundle* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gint n_subscribers = 0;
		Bundle* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint n_members = 0;
		Bundle* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint64 created_at = 0LL;
		Bundle* _tmp17_ = NULL;
		gint64 _tmp18_ = 0LL;
		gchar* mode = NULL;
		Bundle* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GtkMenuButton* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		GtkButton* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
		GtkLabel* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		GtkLabel* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		GtkLabel* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		GtkLabel* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		GtkLabel* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		GtkLabel* _tmp39_ = NULL;
		gint64 _tmp40_ = 0LL;
		GDateTime* _tmp41_ = NULL;
		GDateTime* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		GtkLabel* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		_tmp7_ = args;
		_tmp8_ = bundle_get_bool (_tmp7_, "user_list");
		user_list = _tmp8_;
		_tmp9_ = args;
		_tmp10_ = bundle_get_string (_tmp9_, "description");
		description = _tmp10_;
		_tmp11_ = args;
		_tmp12_ = bundle_get_string (_tmp11_, "creator");
		creator = _tmp12_;
		_tmp13_ = args;
		_tmp14_ = bundle_get_int (_tmp13_, "n_subscribers");
		n_subscribers = _tmp14_;
		_tmp15_ = args;
		_tmp16_ = bundle_get_int (_tmp15_, "n_members");
		n_members = _tmp16_;
		_tmp17_ = args;
		_tmp18_ = bundle_get_int64 (_tmp17_, "created_at");
		created_at = _tmp18_;
		_tmp19_ = args;
		_tmp20_ = bundle_get_string (_tmp19_, "mode");
		mode = _tmp20_;
		_tmp21_ = self->priv->delete_button;
		_tmp22_ = user_list;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), _tmp22_);
		_tmp23_ = self->priv->edit_button;
		_tmp24_ = user_list;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), _tmp24_);
		_tmp25_ = self->priv->name_label;
		_tmp26_ = list_name;
		gtk_label_set_label (_tmp25_, _tmp26_);
		_tmp27_ = self->priv->description_label;
		_tmp28_ = description;
		gtk_label_set_label (_tmp27_, _tmp28_);
		_tmp29_ = self->priv->creator_label;
		_tmp30_ = creator;
		gtk_label_set_label (_tmp29_, _tmp30_);
		_tmp31_ = self->priv->members_label;
		_tmp32_ = n_members;
		_tmp33_ = g_strdup_printf ("%'d", _tmp32_);
		_tmp34_ = _tmp33_;
		gtk_label_set_label (_tmp31_, _tmp34_);
		_g_free0 (_tmp34_);
		_tmp35_ = self->priv->subscribers_label;
		_tmp36_ = n_subscribers;
		_tmp37_ = g_strdup_printf ("%'d", _tmp36_);
		_tmp38_ = _tmp37_;
		gtk_label_set_label (_tmp35_, _tmp38_);
		_g_free0 (_tmp38_);
		_tmp39_ = self->priv->created_at_label;
		_tmp40_ = created_at;
		_tmp41_ = g_date_time_new_from_unix_local (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_date_time_format (_tmp42_, "%x, %X");
		_tmp44_ = _tmp43_;
		gtk_label_set_label (_tmp39_, _tmp44_);
		_g_free0 (_tmp44_);
		_g_date_time_unref0 (_tmp42_);
		_tmp45_ = self->priv->mode_label;
		_tmp46_ = mode;
		_tmp47_ = utils_capitalize (_tmp46_);
		_tmp48_ = _tmp47_;
		gtk_label_set_label (_tmp45_, _tmp48_);
		_g_free0 (_tmp48_);
		_g_free0 (mode);
		_g_free0 (creator);
		_g_free0 (description);
	}
	_tmp49_ = list_id;
	_tmp50_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_strconcat ("Showing list with id ", _tmp51_, NULL);
	_tmp53_ = _tmp52_;
	g_debug ("ListStatusesPage.vala:138: %s", _tmp53_);
	_g_free0 (_tmp53_);
	_g_free0 (_tmp51_);
	_tmp54_ = list_id;
	_tmp55_ = self->priv->list_id;
	if (_tmp54_ == _tmp55_) {
		gint64 _tmp56_ = 0LL;
		_tmp56_ = list_id;
		self->priv->list_id = _tmp56_;
		list_statuses_page_load_newer (self, NULL, NULL);
	} else {
		MaxSizeContainer* _tmp57_ = NULL;
		gint64 _tmp58_ = 0LL;
		TweetListBox* _tmp59_ = NULL;
		_tmp57_ = self->priv->max_size_container;
		max_size_container_set_max_size (_tmp57_, 0);
		_tmp58_ = list_id;
		self->priv->list_id = _tmp58_;
		_tmp59_ = self->priv->tweet_list;
		tweet_list_box_remove_all (_tmp59_);
		list_statuses_page_load_newest (self, NULL, NULL);
	}
	_g_free0 (list_name);
}


static void list_statuses_page_real_on_leave (IPage* base) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
}


static void list_statuses_page_load_newest_data_free (gpointer _data) {
	ListStatusesPageLoadNewestData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ListStatusesPageLoadNewestData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void list_statuses_page_load_newest (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ListStatusesPageLoadNewestData* _data_;
	ListStatusesPage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ListStatusesPageLoadNewestData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, list_statuses_page_load_newest);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, list_statuses_page_load_newest_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	list_statuses_page_load_newest_co (_data_);
}


static void list_statuses_page_load_newest_finish (ListStatusesPage* self, GAsyncResult* _res_) {
	ListStatusesPageLoadNewestData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void list_statuses_page_load_newest_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ListStatusesPageLoadNewestData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	list_statuses_page_load_newest_co (_data_);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gboolean list_statuses_page_load_newest_co (ListStatusesPageLoadNewestData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->tweet_list;
	tweet_list_box_set_unempty (_data_->_tmp0_);
	_data_->requested_tweet_count = (guint) 25;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = account_get_proxy (_data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp6_, "1.1/lists/statuses.json");
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp7_, "GET");
	_data_->_tmp8_ = 0LL;
	_data_->_tmp8_ = _data_->self->priv->list_id;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp8_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_tmp9_;
	g_debug ("ListStatusesPage.vala:159: USING LIST ID %s", _data_->_tmp10_);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->call;
	_data_->_tmp12_ = 0LL;
	_data_->_tmp12_ = _data_->self->priv->list_id;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp12_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->_tmp13_;
	rest_proxy_call_add_param (_data_->_tmp11_, "list_id", _data_->_tmp14_);
	_g_free0 (_data_->_tmp14_);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->call;
	_data_->_tmp16_ = 0U;
	_data_->_tmp16_ = _data_->requested_tweet_count;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = g_strdup_printf ("%u", _data_->_tmp16_);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->_tmp17_;
	rest_proxy_call_add_param (_data_->_tmp15_, "count", _data_->_tmp18_);
	_g_free0 (_data_->_tmp18_);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->call;
	_data_->_state_ = 1;
	tweet_utils_load_threaded (_data_->_tmp19_, list_statuses_page_load_newest_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = tweet_utils_load_threaded_finish (_data_->_res_);
	_data_->root = _data_->_tmp20_;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->root;
	if (_data_->_tmp21_ == NULL) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->root;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = json_node_get_array (_data_->_tmp22_);
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _json_array_ref0 (_data_->_tmp23_);
	_data_->root_array = _data_->_tmp24_;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->root_array;
	_data_->_tmp26_ = 0U;
	_data_->_tmp26_ = json_array_get_length (_data_->_tmp25_);
	if (_data_->_tmp26_ == ((guint) 0)) {
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->self->priv->tweet_list;
		tweet_list_box_set_empty (_data_->_tmp27_);
		_json_array_unref0 (_data_->root_array);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->root_array;
	_data_->_tmp29_ = 0U;
	_data_->_tmp29_ = _data_->requested_tweet_count;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->self->priv->_delta_updater;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->self->priv->tweet_list;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _data_->_tmp32_;
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = _data_->_tmp34_;
	memset (&_data_->_tmp36_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_state_ = 2;
	tweet_utils_work_array (_data_->_tmp28_, _data_->_tmp29_, _data_->_tmp30_, _data_->_tmp31_, _data_->_tmp33_, _data_->_tmp35_, list_statuses_page_load_newest_ready, _data_);
	return FALSE;
	_state_2:
	tweet_utils_work_array_finish (_data_->_res_, &_data_->_tmp36_);
	_data_->res = _data_->_tmp36_;
	memset (&_data_->_tmp37_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_tmp37_ = _data_->res;
	_data_->_tmp38_ = 0LL;
	_data_->_tmp38_ = _data_->_tmp37_.max_id;
	_data_->_tmp39_ = 0LL;
	_data_->_tmp39_ = _data_->self->priv->max_id;
	if (_data_->_tmp38_ > _data_->_tmp39_) {
		memset (&_data_->_tmp40_, 0, sizeof (TweetUtilsWorkerResult));
		_data_->_tmp40_ = _data_->res;
		_data_->_tmp41_ = 0LL;
		_data_->_tmp41_ = _data_->_tmp40_.max_id;
		_data_->self->priv->max_id = _data_->_tmp41_;
	}
	memset (&_data_->_tmp42_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_tmp42_ = _data_->res;
	_data_->_tmp43_ = 0LL;
	_data_->_tmp43_ = _data_->_tmp42_.min_id;
	_data_->_tmp44_ = 0LL;
	_data_->_tmp44_ = _data_->self->priv->lowest_id;
	if (_data_->_tmp43_ < _data_->_tmp44_) {
		memset (&_data_->_tmp45_, 0, sizeof (TweetUtilsWorkerResult));
		_data_->_tmp45_ = _data_->res;
		_data_->_tmp46_ = 0LL;
		_data_->_tmp46_ = _data_->_tmp45_.min_id;
		_data_->self->priv->lowest_id = _data_->_tmp46_;
	}
	_json_array_unref0 (_data_->root_array);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void list_statuses_page_load_older_data_free (gpointer _data) {
	ListStatusesPageLoadOlderData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ListStatusesPageLoadOlderData, _data_);
}


static void list_statuses_page_load_older (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ListStatusesPageLoadOlderData* _data_;
	ListStatusesPage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ListStatusesPageLoadOlderData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, list_statuses_page_load_older);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, list_statuses_page_load_older_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	list_statuses_page_load_older_co (_data_);
}


static void list_statuses_page_load_older_finish (ListStatusesPage* self, GAsyncResult* _res_) {
	ListStatusesPageLoadOlderData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void list_statuses_page_load_older_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ListStatusesPageLoadOlderData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	list_statuses_page_load_older_co (_data_);
}


static gboolean list_statuses_page_load_older_co (ListStatusesPageLoadOlderData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->self->priv->loading;
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->loading = TRUE;
	_data_->requested_tweet_count = (guint) 25;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = account_get_proxy (_data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp6_, "1.1/lists/statuses.json");
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp7_, "GET");
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->call;
	_data_->_tmp9_ = 0LL;
	_data_->_tmp9_ = _data_->self->priv->list_id;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp9_);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_;
	rest_proxy_call_add_param (_data_->_tmp8_, "list_id", _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->call;
	_data_->_tmp13_ = 0LL;
	_data_->_tmp13_ = _data_->self->priv->lowest_id;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp13_ - 1);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_tmp14_;
	rest_proxy_call_add_param (_data_->_tmp12_, "max_id", _data_->_tmp15_);
	_g_free0 (_data_->_tmp15_);
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->call;
	_data_->_tmp17_ = 0U;
	_data_->_tmp17_ = _data_->requested_tweet_count;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = g_strdup_printf ("%u", _data_->_tmp17_);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->_tmp18_;
	rest_proxy_call_add_param (_data_->_tmp16_, "count", _data_->_tmp19_);
	_g_free0 (_data_->_tmp19_);
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->call;
	_data_->_state_ = 1;
	tweet_utils_load_threaded (_data_->_tmp20_, list_statuses_page_load_older_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = tweet_utils_load_threaded_finish (_data_->_res_);
	_data_->root = _data_->_tmp21_;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->root;
	if (_data_->_tmp22_ == NULL) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->root;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = json_node_get_array (_data_->_tmp23_);
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _json_array_ref0 (_data_->_tmp24_);
	_data_->root_array = _data_->_tmp25_;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->root_array;
	_data_->_tmp27_ = 0U;
	_data_->_tmp27_ = _data_->requested_tweet_count;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->self->priv->_delta_updater;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->self->priv->tweet_list;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->_tmp30_;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _data_->_tmp32_;
	memset (&_data_->_tmp34_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_state_ = 2;
	tweet_utils_work_array (_data_->_tmp26_, _data_->_tmp27_, _data_->_tmp28_, _data_->_tmp29_, _data_->_tmp31_, _data_->_tmp33_, list_statuses_page_load_older_ready, _data_);
	return FALSE;
	_state_2:
	tweet_utils_work_array_finish (_data_->_res_, &_data_->_tmp34_);
	_data_->res = _data_->_tmp34_;
	memset (&_data_->_tmp35_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_tmp35_ = _data_->res;
	_data_->_tmp36_ = 0LL;
	_data_->_tmp36_ = _data_->_tmp35_.max_id;
	_data_->_tmp37_ = 0LL;
	_data_->_tmp37_ = _data_->self->priv->max_id;
	if (_data_->_tmp36_ > _data_->_tmp37_) {
		memset (&_data_->_tmp38_, 0, sizeof (TweetUtilsWorkerResult));
		_data_->_tmp38_ = _data_->res;
		_data_->_tmp39_ = 0LL;
		_data_->_tmp39_ = _data_->_tmp38_.max_id;
		_data_->self->priv->max_id = _data_->_tmp39_;
	}
	memset (&_data_->_tmp40_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_tmp40_ = _data_->res;
	_data_->_tmp41_ = 0LL;
	_data_->_tmp41_ = _data_->_tmp40_.min_id;
	_data_->_tmp42_ = 0LL;
	_data_->_tmp42_ = _data_->self->priv->lowest_id;
	if (_data_->_tmp41_ < _data_->_tmp42_) {
		memset (&_data_->_tmp43_, 0, sizeof (TweetUtilsWorkerResult));
		_data_->_tmp43_ = _data_->res;
		_data_->_tmp44_ = 0LL;
		_data_->_tmp44_ = _data_->_tmp43_.min_id;
		_data_->self->priv->lowest_id = _data_->_tmp44_;
	}
	_data_->self->priv->loading = FALSE;
	_json_array_unref0 (_data_->root_array);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void list_statuses_page_edit_button_clicked_cb (ListStatusesPage* self) {
	GtkStack* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	GtkStack* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkStack* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	GtkStack* _tmp8_ = NULL;
	GtkComboBoxText* _tmp9_ = NULL;
	GtkEntry* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GtkEntry* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkComboBoxText* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_tmp0_ = self->priv->name_stack;
	_tmp1_ = self->priv->name_entry;
	gtk_stack_set_visible_child (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = self->priv->description_stack;
	_tmp3_ = self->priv->description_entry;
	gtk_stack_set_visible_child (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	_tmp4_ = self->priv->delete_stack;
	_tmp5_ = self->priv->cancel_button;
	gtk_stack_set_visible_child (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = self->priv->edit_stack;
	_tmp7_ = self->priv->save_button;
	gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp8_ = self->priv->mode_stack;
	_tmp9_ = self->priv->mode_combo_box;
	gtk_stack_set_visible_child (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	_tmp10_ = self->priv->name_entry;
	_tmp11_ = list_statuses_page_real_list_name (self);
	_tmp12_ = _tmp11_;
	gtk_entry_set_text (_tmp10_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->description_entry;
	_tmp14_ = self->priv->description_label;
	_tmp15_ = gtk_label_get_label (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_entry_set_text (_tmp13_, _tmp16_);
	_tmp17_ = self->priv->mode_combo_box;
	_tmp18_ = self->priv->mode_label;
	_tmp19_ = gtk_label_get_label (_tmp18_);
	_tmp20_ = _tmp19_;
	gtk_combo_box_set_active_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_combo_box_get_type (), GtkComboBox), _tmp20_);
}


static void _list_statuses_page_edit_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_statuses_page_edit_button_clicked_cb ((ListStatusesPage*) self);
}


static void list_statuses_page_cancel_button_clicked_cb (ListStatusesPage* self) {
	GtkStack* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkStack* _tmp4_ = NULL;
	GtkMenuButton* _tmp5_ = NULL;
	GtkStack* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	GtkStack* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_tmp0_ = self->priv->name_stack;
	_tmp1_ = self->priv->name_label;
	gtk_stack_set_visible_child (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = self->priv->description_stack;
	_tmp3_ = self->priv->description_label;
	gtk_stack_set_visible_child (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	_tmp4_ = self->priv->delete_stack;
	_tmp5_ = self->priv->delete_button;
	gtk_stack_set_visible_child (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = self->priv->edit_stack;
	_tmp7_ = self->priv->edit_button;
	gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp8_ = self->priv->mode_stack;
	_tmp9_ = self->priv->mode_label;
	gtk_stack_set_visible_child (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
}


static void _list_statuses_page_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_statuses_page_cancel_button_clicked_cb ((ListStatusesPage*) self);
}


static Block33Data* block33_data_ref (Block33Data* _data33_) {
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}


static void block33_data_unref (void * _userdata_) {
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		ListStatusesPage* self;
		self = _data33_->self;
		_g_object_unref0 (_data33_->call);
		_g_object_unref0 (self);
		g_slice_free (Block33Data, _data33_);
	}
}


static void __lambda201_ (Block33Data* _data33_, GObject* o, GAsyncResult* res) {
	ListStatusesPage* self;
	GtkButton* _tmp4_ = NULL;
	GtkMenuButton* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data33_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data33_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch38_g_error;
		}
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data33_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		utils_show_error_object (_tmp1_, _tmp3_, 264, "ListStatusesPage.vala");
		_g_error_free0 (e);
	}
	__finally38:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = self->priv->edit_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp5_ = self->priv->delete_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda201__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda201_ (self, source_object, res);
	block33_data_unref (self);
}


static void list_statuses_page_save_button_clicked_cb (ListStatusesPage* self) {
	Block33Data* _data33_;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkEntry* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkEntry* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkComboBoxText* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	GtkMenuButton* _tmp17_ = NULL;
	Account* _tmp18_ = NULL;
	Account* _tmp19_ = NULL;
	OAuthProxy* _tmp20_ = NULL;
	OAuthProxy* _tmp21_ = NULL;
	RestProxyCall* _tmp22_ = NULL;
	gint64 _tmp23_ = 0LL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GtkLabel* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GtkLabel* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_data33_ = g_slice_new0 (Block33Data);
	_data33_->_ref_count_ = 1;
	_data33_->self = g_object_ref (self);
	_tmp0_ = self->priv->name_label;
	_tmp1_ = self->priv->creator_label;
	_tmp2_ = gtk_label_get_label (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->name_entry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = g_strdup_printf ("@%s/%s", _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_label (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->description_label;
	_tmp9_ = self->priv->description_entry;
	_tmp10_ = gtk_entry_get_text (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_label_set_label (_tmp8_, _tmp11_);
	_tmp12_ = self->priv->mode_label;
	_tmp13_ = self->priv->mode_combo_box;
	_tmp14_ = gtk_combo_box_get_active_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_combo_box_get_type (), GtkComboBox));
	_tmp15_ = _tmp14_;
	gtk_label_set_label (_tmp12_, _tmp15_);
	list_statuses_page_cancel_button_clicked_cb (self);
	_tmp16_ = self->priv->edit_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp17_ = self->priv->delete_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp18_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp19_ = _tmp18_;
	_tmp20_ = account_get_proxy (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, rest_proxy_get_type (), RestProxy));
	_data33_->call = _tmp22_;
	rest_proxy_call_set_function (_data33_->call, "1.1/lists/update.json");
	rest_proxy_call_set_method (_data33_->call, "POST");
	_tmp23_ = self->priv->list_id;
	_tmp24_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp23_);
	_tmp25_ = _tmp24_;
	rest_proxy_call_add_param (_data33_->call, "list_id", _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = list_statuses_page_real_list_name (self);
	_tmp27_ = _tmp26_;
	rest_proxy_call_add_param (_data33_->call, "name", _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = self->priv->mode_label;
	_tmp29_ = gtk_label_get_label (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_utf8_strdown (_tmp30_, (gssize) (-1));
	_tmp32_ = _tmp31_;
	rest_proxy_call_add_param (_data33_->call, "mode", _tmp32_);
	_g_free0 (_tmp32_);
	_tmp33_ = self->priv->description_label;
	_tmp34_ = gtk_label_get_label (_tmp33_);
	_tmp35_ = _tmp34_;
	rest_proxy_call_add_param (_data33_->call, "description", _tmp35_);
	rest_proxy_call_invoke_async (_data33_->call, NULL, ___lambda201__gasync_ready_callback, block33_data_ref (_data33_));
	block33_data_unref (_data33_);
	_data33_ = NULL;
}


static void _list_statuses_page_save_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_statuses_page_save_button_clicked_cb ((ListStatusesPage*) self);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* list_statuses_page_real_list_name (ListStatusesPage* self) {
	gchar* result = NULL;
	gchar* cur_name = NULL;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint slash_index = 0;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (IS_LIST_STATUSES_PAGE (self), NULL);
	_tmp0_ = self->priv->name_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	cur_name = _tmp3_;
	_tmp4_ = string_index_of (cur_name, "/", 0);
	slash_index = _tmp4_;
	_tmp5_ = string_substring (cur_name, (glong) (slash_index + 1), (glong) (-1));
	result = _tmp5_;
	_g_free0 (cur_name);
	return result;
}


static Block34Data* block34_data_ref (Block34Data* _data34_) {
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}


static void block34_data_unref (void * _userdata_) {
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		ListStatusesPage* self;
		self = _data34_->self;
		_g_object_unref0 (_data34_->call);
		_g_object_unref0 (self);
		g_slice_free (Block34Data, _data34_);
	}
}


static void __lambda202_ (Block34Data* _data34_, GObject* o, GAsyncResult* res) {
	ListStatusesPage* self;
	GError * _inner_error_ = NULL;
	self = _data34_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data34_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch39_g_error;
		}
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data34_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		utils_show_error_object (_tmp1_, _tmp3_, 288, "ListStatusesPage.vala");
		_g_error_free0 (e);
	}
	__finally39:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda202__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda202_ (self, source_object, res);
	block34_data_unref (self);
}


static void list_statuses_page_delete_confirmation_item_clicked_cb (ListStatusesPage* self) {
	Block34Data* _data34_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	OAuthProxy* _tmp2_ = NULL;
	OAuthProxy* _tmp3_ = NULL;
	RestProxyCall* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	Bundle* bundle = NULL;
	Bundle* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	MainWindow* _tmp10_ = NULL;
	MainWindow* _tmp11_ = NULL;
	MainWidget* _tmp12_ = NULL;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_data34_ = g_slice_new0 (Block34Data);
	_data34_->_ref_count_ = 1;
	_data34_->self = g_object_ref (self);
	_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = account_get_proxy (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, rest_proxy_get_type (), RestProxy));
	_data34_->call = _tmp4_;
	rest_proxy_call_set_function (_data34_->call, "1.1/lists/destroy.json");
	_tmp5_ = self->priv->list_id;
	_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp5_);
	_tmp7_ = _tmp6_;
	rest_proxy_call_add_param (_data34_->call, "list_id", _tmp7_);
	_g_free0 (_tmp7_);
	rest_proxy_call_set_method (_data34_->call, "POST");
	rest_proxy_call_invoke_async (_data34_->call, NULL, ___lambda202__gasync_ready_callback, block34_data_ref (_data34_));
	_tmp8_ = bundle_new ();
	bundle = _tmp8_;
	bundle_put_int (bundle, "mode", LISTS_PAGE_MODE_DELETE);
	_tmp9_ = self->priv->list_id;
	bundle_put_int64 (bundle, "list_id", _tmp9_);
	_tmp10_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_->main_widget;
	main_widget_switch_page (_tmp12_, (gint) PAGE_LISTS, bundle);
	_g_object_unref0 (bundle);
	block34_data_unref (_data34_);
	_data34_ = NULL;
}


static void _list_statuses_page_delete_confirmation_item_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	list_statuses_page_delete_confirmation_item_clicked_cb ((ListStatusesPage*) self);
}


static void __lambda203_ (ListStatusesPage* self) {
	GtkButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->refresh_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda203__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda203_ ((ListStatusesPage*) self);
	g_object_unref (self);
}


static void list_statuses_page_refresh_button_clicked_cb (ListStatusesPage* self) {
	GtkButton* _tmp0_ = NULL;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_tmp0_ = self->priv->refresh_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), FALSE);
	list_statuses_page_load_newer (self, ___lambda203__gasync_ready_callback, g_object_ref (self));
}


static void _list_statuses_page_refresh_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_statuses_page_refresh_button_clicked_cb ((ListStatusesPage*) self);
}


static void list_statuses_page_tweet_activated_cb (ListStatusesPage* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_ = NULL;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_TWEET_LIST_ENTRY)) {
		Bundle* bundle = NULL;
		Bundle* _tmp1_ = NULL;
		Bundle* _tmp2_ = NULL;
		Bundle* _tmp3_ = NULL;
		GtkListBoxRow* _tmp4_ = NULL;
		Tweet* _tmp5_ = NULL;
		MainWindow* _tmp6_ = NULL;
		MainWindow* _tmp7_ = NULL;
		MainWidget* _tmp8_ = NULL;
		Bundle* _tmp9_ = NULL;
		_tmp1_ = bundle_new ();
		bundle = _tmp1_;
		_tmp2_ = bundle;
		bundle_put_int (_tmp2_, "mode", TWEET_INFO_PAGE_BY_INSTANCE);
		_tmp3_ = bundle;
		_tmp4_ = row;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
		bundle_put_object (_tmp3_, "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_OBJECT, GObject));
		_tmp6_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->main_widget;
		_tmp9_ = bundle;
		main_widget_switch_page (_tmp8_, (gint) PAGE_TWEET_INFO, _tmp9_);
		_g_object_unref0 (bundle);
	} else {
		g_warning ("ListStatusesPage.vala:315: row is of unknown type");
	}
}


static void _list_statuses_page_tweet_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	list_statuses_page_tweet_activated_cb ((ListStatusesPage*) self, row);
}


static void list_statuses_page_load_newer_data_free (gpointer _data) {
	ListStatusesPageLoadNewerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ListStatusesPageLoadNewerData, _data_);
}


static void list_statuses_page_load_newer (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ListStatusesPageLoadNewerData* _data_;
	ListStatusesPage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ListStatusesPageLoadNewerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, list_statuses_page_load_newer);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, list_statuses_page_load_newer_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	list_statuses_page_load_newer_co (_data_);
}


static void list_statuses_page_load_newer_finish (ListStatusesPage* self, GAsyncResult* _res_) {
	ListStatusesPageLoadNewerData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block35Data* block35_data_ref (Block35Data* _data35_) {
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}


static void block35_data_unref (void * _userdata_) {
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		ListStatusesPage* self;
		self = _data35_->self;
		_g_date_time_unref0 (_data35_->now);
		_g_object_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}


static void list_statuses_page_load_newer_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ListStatusesPageLoadNewerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	list_statuses_page_load_newer_co (_data_);
}


static void __lambda200_ (Block35Data* _data35_, JsonArray* array, guint index, JsonNode* node) {
	ListStatusesPage* self;
	Tweet* t = NULL;
	Tweet* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	JsonNode* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	Account* _tmp5_ = NULL;
	Tweet* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	TweetListEntry* entry = NULL;
	Tweet* _tmp11_ = NULL;
	Tweet* _tmp12_ = NULL;
	MainWindow* _tmp13_ = NULL;
	MainWindow* _tmp14_ = NULL;
	Account* _tmp15_ = NULL;
	Account* _tmp16_ = NULL;
	TweetListEntry* _tmp17_ = NULL;
	TweetListBox* _tmp18_ = NULL;
	self = _data35_->self;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = tweet_new ();
	t = _tmp0_;
	_tmp1_ = t;
	_tmp2_ = node;
	_tmp3_ = _data35_->now;
	_tmp4_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp5_ = _tmp4_;
	tweet_load_from_json (_tmp1_, _tmp2_, _tmp3_, _tmp5_);
	_tmp6_ = t;
	_tmp7_ = _tmp6_->id;
	_tmp8_ = self->priv->max_id;
	if (_tmp7_ > _tmp8_) {
		Tweet* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
		_tmp9_ = t;
		_tmp10_ = _tmp9_->id;
		self->priv->max_id = _tmp10_;
	}
	_tmp11_ = t;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_tmp13_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp14_ = _tmp13_;
	_tmp15_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp16_ = _tmp15_;
	_tmp17_ = tweet_list_entry_new (_tmp12_, _tmp14_, _tmp16_);
	g_object_ref_sink (_tmp17_);
	entry = _tmp17_;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	_tmp18_ = self->priv->tweet_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (entry);
	_g_object_unref0 (t);
}


static void ___lambda200__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda200_ (self, array, index_, element_node);
}


static gboolean list_statuses_page_load_newer_co (ListStatusesPageLoadNewerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data35_ = g_slice_new0 (Block35Data);
	_data_->_data35_->_ref_count_ = 1;
	_data_->_data35_->self = g_object_ref (_data_->self);
	_data_->_data35_->_async_data_ = _data_;
	_data_->_tmp0_ = 0LL;
	_data_->_tmp0_ = _data_->self->priv->max_id;
	if (_data_->_tmp0_ == ((gint64) 0)) {
		_data_->_state_ = 1;
		list_statuses_page_load_newest (_data_->self, list_statuses_page_load_newer_ready, _data_);
		return FALSE;
		_state_1:
		list_statuses_page_load_newest_finish (_data_->self, _data_->_res_);
		block35_data_unref (_data_->_data35_);
		_data_->_data35_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = account_get_proxy (_data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp6_, "1.1/lists/statuses.json");
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp7_, "GET");
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->call;
	_data_->_tmp9_ = 0LL;
	_data_->_tmp9_ = _data_->self->priv->list_id;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp9_);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_;
	rest_proxy_call_add_param (_data_->_tmp8_, "list_id", _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->call;
	_data_->_tmp13_ = 0LL;
	_data_->_tmp13_ = _data_->self->priv->max_id;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp13_);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_tmp14_;
	rest_proxy_call_add_param (_data_->_tmp12_, "since_id", _data_->_tmp15_);
	_g_free0 (_data_->_tmp15_);
	_data_->_tmp16_ = 0LL;
	_data_->_tmp16_ = _data_->self->priv->max_id;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp16_);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = g_strconcat ("Using max_id ", _data_->_tmp18_, NULL);
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->_tmp19_;
	g_message ("ListStatusesPage.vala:329: %s", _data_->_tmp20_);
	_g_free0 (_data_->_tmp20_);
	_g_free0 (_data_->_tmp18_);
	{
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->call;
		_data_->_state_ = 2;
		rest_proxy_call_invoke_async (_data_->_tmp21_, NULL, list_statuses_page_load_newer_ready, _data_);
		return FALSE;
		_state_2:
		rest_proxy_call_invoke_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch40_g_error;
		}
	}
	goto __finally40;
	__catch40_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->call;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = rest_proxy_call_get_payload (_data_->_tmp22_);
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->e;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->_tmp24_->message;
		utils_show_error_object (_data_->_tmp23_, _data_->_tmp25_, 334, "ListStatusesPage.vala");
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->call);
		block35_data_unref (_data_->_data35_);
		_data_->_data35_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally40:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->call);
		block35_data_unref (_data_->_data35_);
		_data_->_data35_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = json_parser_new ();
	_data_->parser = _data_->_tmp26_;
	{
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->parser;
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->call;
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = rest_proxy_call_get_payload (_data_->_tmp28_);
		json_parser_load_from_data (_data_->_tmp27_, _data_->_tmp29_, (gssize) (-1), &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch41_g_error;
		}
	}
	goto __finally41;
	__catch41_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = _data_->_vala1_e;
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = _data_->_tmp30_->message;
		g_critical ("ListStatusesPage.vala:342: %s", _data_->_tmp31_);
		_g_error_free0 (_data_->_vala1_e);
		_g_object_unref0 (_data_->parser);
		_g_object_unref0 (_data_->call);
		block35_data_unref (_data_->_data35_);
		_data_->_data35_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally41:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->parser);
		_g_object_unref0 (_data_->call);
		block35_data_unref (_data_->_data35_);
		_data_->_data35_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->parser;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = json_parser_get_root (_data_->_tmp32_);
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = json_node_get_array (_data_->_tmp33_);
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = _json_array_ref0 (_data_->_tmp34_);
	_data_->root_arr = _data_->_tmp35_;
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = g_date_time_new_now_local ();
	_data_->_data35_->now = _data_->_tmp36_;
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->root_arr;
	json_array_foreach_element (_data_->_tmp37_, ___lambda200__json_array_foreach, _data_->_data35_);
	_json_array_unref0 (_data_->root_arr);
	_g_object_unref0 (_data_->parser);
	_g_object_unref0 (_data_->call);
	block35_data_unref (_data_->_data35_);
	_data_->_data35_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block36Data* block36_data_ref (Block36Data* _data36_) {
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}


static void block36_data_unref (void * _userdata_) {
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		ListStatusesPage* self;
		self = _data36_->self;
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}


static gboolean ___lambda199_ (Block36Data* _data36_) {
	ListStatusesPage* self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	TweetListBox* _tmp7_ = NULL;
	GtkListBoxRow* _tmp8_ = NULL;
	Tweet* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	self = _data36_->self;
	_tmp0_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		self->priv->tweet_remove_timeout = (guint) 0;
		result = FALSE;
		return result;
	}
	while (TRUE) {
		guint _tmp2_ = 0U;
		TweetListBox* _tmp3_ = NULL;
		TweetListBox* _tmp4_ = NULL;
		GtkListBoxRow* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		_tmp2_ = _data36_->item_count;
		if (!(_tmp2_ > ((guint) ITIMELINE_REST))) {
			break;
		}
		_tmp3_ = self->priv->tweet_list;
		_tmp4_ = self->priv->tweet_list;
		_tmp5_ = gtk_list_box_get_row_at_index (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_list_box_get_type (), GtkListBox), ITIMELINE_REST);
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
		_tmp6_ = _data36_->item_count;
		_data36_->item_count = _tmp6_ - 1;
	}
	self->priv->tweet_remove_timeout = (guint) 0;
	_tmp7_ = self->priv->tweet_list;
	_tmp8_ = gtk_list_box_get_row_at_index (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_list_box_get_type (), GtkListBox), ITIMELINE_REST - 1);
	_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
	_tmp10_ = _tmp9_->id;
	self->priv->lowest_id = _tmp10_;
	result = FALSE;
	return result;
}


static gboolean ____lambda199__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda199_ (self);
	return result;
}


void list_statuses_page_handle_scrolled_to_start (ListStatusesPage* self) {
	Block36Data* _data36_;
	guint _tmp0_ = 0U;
	GList* entries = NULL;
	TweetListBox* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_data36_->self = g_object_ref (self);
	_tmp0_ = self->priv->tweet_remove_timeout;
	if (_tmp0_ != ((guint) 0)) {
		block36_data_unref (_data36_);
		_data36_ = NULL;
		return;
	}
	_tmp1_ = self->priv->tweet_list;
	_tmp2_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer));
	entries = _tmp2_;
	_tmp3_ = entries;
	_tmp4_ = g_list_length (_tmp3_);
	_data36_->item_count = _tmp4_;
	_tmp5_ = _data36_->item_count;
	if (_tmp5_ > ((guint) ITIMELINE_REST)) {
		guint _tmp6_ = 0U;
		_tmp6_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 5000, ____lambda199__gsource_func, block36_data_ref (_data36_), block36_data_unref);
		self->priv->tweet_remove_timeout = _tmp6_;
	} else {
		guint _tmp7_ = 0U;
		_tmp7_ = self->priv->tweet_remove_timeout;
		if (_tmp7_ != ((guint) 0)) {
			guint _tmp8_ = 0U;
			_tmp8_ = self->priv->tweet_remove_timeout;
			g_source_remove (_tmp8_);
			self->priv->tweet_remove_timeout = (guint) 0;
		}
	}
	_g_list_free0 (entries);
	block36_data_unref (_data36_);
	_data36_ = NULL;
}


static gchar* list_statuses_page_real_get_title (IPage* base) {
	ListStatusesPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_tmp0_ = _ ("List");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void list_statuses_page_real_create_tool_button (IPage* base, GtkRadioButton* group) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


static GtkRadioButton* list_statuses_page_real_get_tool_button (IPage* base) {
	ListStatusesPage * self;
	GtkRadioButton* result = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	result = NULL;
	return result;
}


static gint list_statuses_page_real_get_id (IPage* base) {
	gint result;
	ListStatusesPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void list_statuses_page_real_set_id (IPage* base, gint value) {
	ListStatusesPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static MainWindow* list_statuses_page_real_get_main_window (IPage* base) {
	MainWindow* result;
	ListStatusesPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}


static void list_statuses_page_real_set_main_window (IPage* base, MainWindow* value) {
	ListStatusesPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_tmp0_ = value;
	self->priv->_main_window = _tmp0_;
	g_object_notify ((GObject *) self, "main-window");
}


static Account* list_statuses_page_real_get_account (IPage* base) {
	Account* result;
	ListStatusesPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void list_statuses_page_real_set_account (IPage* base, Account* value) {
	ListStatusesPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_tmp0_ = value;
	self->priv->_account = _tmp0_;
	g_object_notify ((GObject *) self, "account");
}


DeltaUpdater* list_statuses_page_get_delta_updater (ListStatusesPage* self) {
	DeltaUpdater* result;
	DeltaUpdater* _tmp0_ = NULL;
	g_return_val_if_fail (IS_LIST_STATUSES_PAGE (self), NULL);
	_tmp0_ = self->priv->_delta_updater;
	result = _tmp0_;
	return result;
}


void list_statuses_page_set_delta_updater (ListStatusesPage* self, DeltaUpdater* value) {
	DeltaUpdater* _tmp0_ = NULL;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_tmp0_ = value;
	self->priv->_delta_updater = _tmp0_;
	g_object_notify ((GObject *) self, "delta-updater");
}


static void list_statuses_page_class_init (ListStatusesPageClass * klass) {
	gint ListStatusesPage_private_offset;
	list_statuses_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ListStatusesPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_list_statuses_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_list_statuses_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = list_statuses_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIST_STATUSES_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIST_STATUSES_PAGE_MAIN_WINDOW, g_param_spec_object ("main-window", "main-window", "main-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIST_STATUSES_PAGE_ACCOUNT, g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIST_STATUSES_PAGE_DELTA_UPDATER, g_param_spec_object ("delta-updater", "delta-updater", "delta-updater", TYPE_DELTA_UPDATER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	ListStatusesPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/list-statuses-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweet_list", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, tweet_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "max_size_container", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, max_size_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, delete_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "edit_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, edit_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, description_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "creator_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, creator_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "subscribers_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, subscribers_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "members_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, members_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "created_at_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, created_at_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, name_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_entry", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, name_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, description_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_entry", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, description_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, delete_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cancel_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "edit_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, edit_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "save_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, save_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mode_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, mode_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mode_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, mode_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mode_combo_box", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, mode_combo_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "refresh_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, refresh_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "edit_button_clicked_cb", G_CALLBACK(_list_statuses_page_edit_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_button_clicked_cb", G_CALLBACK(_list_statuses_page_cancel_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "save_button_clicked_cb", G_CALLBACK(_list_statuses_page_save_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_confirmation_item_clicked_cb", G_CALLBACK(_list_statuses_page_delete_confirmation_item_clicked_cb_gtk_menu_item_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "refresh_button_clicked_cb", G_CALLBACK(_list_statuses_page_refresh_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "tweet_activated_cb", G_CALLBACK(_list_statuses_page_tweet_activated_cb_gtk_list_box_row_activated));
}


static void list_statuses_page_ipage_interface_init (IPageIface * iface) {
	list_statuses_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) list_statuses_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) list_statuses_page_real_on_leave;
	iface->get_title = (gchar* (*)(IPage*)) list_statuses_page_real_get_title;
	iface->create_tool_button = (void (*)(IPage*, GtkRadioButton*)) list_statuses_page_real_create_tool_button;
	iface->get_tool_button = (GtkRadioButton* (*)(IPage*)) list_statuses_page_real_get_tool_button;
	iface->get_id = list_statuses_page_real_get_id;
	iface->set_id = list_statuses_page_real_set_id;
	iface->get_main_window = list_statuses_page_real_get_main_window;
	iface->set_main_window = list_statuses_page_real_set_main_window;
	iface->get_account = list_statuses_page_real_get_account;
	iface->set_account = list_statuses_page_real_set_account;
}


static void list_statuses_page_instance_init (ListStatusesPage * self) {
	self->priv = LIST_STATUSES_PAGE_GET_PRIVATE (self);
	self->priv->lowest_id = G_MAXINT64;
	self->priv->max_id = (gint64) 0;
	self->priv->tweet_remove_timeout = (guint) 0;
	self->priv->loading = FALSE;
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_MAX_SIZE_CONTAINER);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void list_statuses_page_finalize (GObject* obj) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_g_object_unref0 (self->priv->tweet_list);
	_g_object_unref0 (self->priv->max_size_container);
	_g_object_unref0 (self->priv->delete_button);
	_g_object_unref0 (self->priv->edit_button);
	_g_object_unref0 (self->priv->description_label);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->creator_label);
	_g_object_unref0 (self->priv->subscribers_label);
	_g_object_unref0 (self->priv->members_label);
	_g_object_unref0 (self->priv->created_at_label);
	_g_object_unref0 (self->priv->name_stack);
	_g_object_unref0 (self->priv->name_entry);
	_g_object_unref0 (self->priv->description_stack);
	_g_object_unref0 (self->priv->description_entry);
	_g_object_unref0 (self->priv->delete_stack);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->edit_stack);
	_g_object_unref0 (self->priv->save_button);
	_g_object_unref0 (self->priv->mode_stack);
	_g_object_unref0 (self->priv->mode_label);
	_g_object_unref0 (self->priv->mode_combo_box);
	_g_object_unref0 (self->priv->refresh_button);
	G_OBJECT_CLASS (list_statuses_page_parent_class)->finalize (obj);
}


GType list_statuses_page_get_type (void) {
	static volatile gsize list_statuses_page_type_id__volatile = 0;
	if (g_once_init_enter (&list_statuses_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ListStatusesPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) list_statuses_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListStatusesPage), 0, (GInstanceInitFunc) list_statuses_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) list_statuses_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType list_statuses_page_type_id;
		list_statuses_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "ListStatusesPage", &g_define_type_info, 0);
		g_type_add_interface_static (list_statuses_page_type_id, TYPE_IPAGE, &ipage_info);
		g_once_init_leave (&list_statuses_page_type_id__volatile, list_statuses_page_type_id);
	}
	return list_statuses_page_type_id__volatile;
}


static void _vala_list_statuses_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	switch (property_id) {
		case LIST_STATUSES_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case LIST_STATUSES_PAGE_MAIN_WINDOW:
		g_value_set_object (value, ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case LIST_STATUSES_PAGE_ACCOUNT:
		g_value_set_object (value, ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case LIST_STATUSES_PAGE_DELTA_UPDATER:
		g_value_set_object (value, list_statuses_page_get_delta_updater (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_list_statuses_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	switch (property_id) {
		case LIST_STATUSES_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case LIST_STATUSES_PAGE_MAIN_WINDOW:
		ipage_set_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case LIST_STATUSES_PAGE_ACCOUNT:
		ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case LIST_STATUSES_PAGE_DELTA_UPDATER:
		list_statuses_page_set_delta_updater (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



