#!perl
# $Id: test.pl,v 1.20 2004/09/30 16:09:27 jlinoff Exp $
use strict;

my $s_total = 0;
my $s_failed = 0;
my $s_passed = 0;
my $s_verbose = 0;

&Main;

# ================================================
# MAIN
# ================================================
sub Main {
    if( $#ARGV < 0 ) {
	print STDERR "ERROR: missing the program argument. \n";
	return 1;
    }
    my $prog = $ARGV[0];
    while( $#ARGV >= 0 ) {
        my $arg = shift @ARGV;
	if( $arg eq "-v" ) {
	    $main::s_verbose = 1;
	    next;
	}
	$prog = $arg;
    }

    # Initialize
    $main::s_total = 0;
    $main::s_passed = 0;
    $main::s_failed = 0;

    # Clean out the old stuff.
    mkdir "../test/logs",0777;
    opendir(DIR, "../test/logs") || die "can't opendir test: $!";
    my @test_files = grep { /^[^\.]/ && -f "test/logs/$_" } readdir(DIR);
    closedir DIR;
    my $test_file;
    foreach $test_file ( @test_files ) {
	unlink "DEBUG: $test_file\n";
    }
    &DeleteFiles("logs/t*");

    # Run the tests
    &Test01($prog); # -help, -log
    &Test02($prog); # basic parsing tests
    &Test03($prog); # javadoc style comments
    &Test04($prog); # C++ style comments
    &Test05($prog); # pre-processing tests
    &Test06($prog); # category tests
    &Test07($prog); # verify package specifications
    &Test08($prog); # verify extern processing
    &Test09($prog); # verify root package documentation
    &Test10($prog); # verify fixes for issues 001, 002 and 003
    &Test11($prog); # verify that -cdsm works.
    &Test12($prog); # verify that -nocdsm works.
    &Test13($prog); # verify fix for issue 0014.
    &Test14($prog); # verify fix for issue 0015.
    &Test15($prog); # verify fix for issue 0025.
    &Test16($prog); # verify fix for issue 0033.
    &Test17($prog); # verify fix for issue 0036.
    &Test18($prog); # verify fix for issue 0042.
    &Test19($prog); # verify fix for issue 0043.
    &Test20($prog); # verify fix for issue 0044.
    &Test21($prog); # verify fix for issue 0045.
    &Test22($prog); # verify fix for issue 0046.
    &Test23($prog); # verify fix for issue 0048.
    &Test24($prog); # verify fix for issue 0050.
    &Test25($prog); # verify fix for issue 0052.
    &Test26($prog); # verify fix for issue 0054.
    &Test27($prog); # verify fix for issue 0063.
    &Test28($prog); # verify fix for issue 0064.
    &Test29($prog); # verify fix for issue 0069.
    &Test30($prog); # verify fix for issue 0073.
    &Test31($prog); # verify fix for issue 0074.
    &Test32($prog); # verify fix for issue 0072.
    &Test33($prog); # verify fix for issue 0075.
    &Test34($prog); # verify fix for issue 0076.
    &Test35($prog); # verify fix for issue 0077.
    &Test36($prog); # verify fix for issue 0078.
    &Test37($prog); # verify -putenv
    &Test38($prog); # verify fix for issue 0080.
    &TestHtmlX1("39",$prog); # verify fix for issues 0082,0084,0087,0088.
    &TestHtmlX1("40",$prog); # verify fix for issue 0089.
    &TestHtmlX1("41",$prog); # verify fix for issue 0091.
    &TestHtmlX1("42",$prog); # verify fix for issue 0085.
    &TestHtmlX1("43",$prog); # verify fix for issue 0083.
    &TestHtmlX1("44",$prog); # verify fix for issues 0090, 0092.
    &Test45($prog); # verify fix for issue 0095.
    &TestHtmlX1("46",$prog); # verify fix for issue 0097.
    &TestHtmlX1("47",$prog); # verify fix for issues 0103, 0104.
    &Test48($prog); # verify fix for issue 0112.
    &TestHtmlX1("49",$prog); # verify fix for issue 0114.
    &TestHtmlX1("50",$prog); # verify fix for issue 0116.
    &TestHtmlX1("51",$prog); # verify fix for issue 0117.
    &TestHtmlX1("52",$prog); # verify fix for issue 0118.
    &TestHtmlX1("53",$prog); # verify fix for issue 0086.
    &TestHtmlX1("54",$prog); # verify fix for issue 0101.
    &TestHtmlX1("55",$prog); # verify fix for issue 0099.
    &Test56($prog); # verify the @pkgdoctid directive
    &TestHtmlX1("57",$prog); # verify fix for issue 0127.
    &TestHtmlX1("58",$prog); # verify fix for issue 0123.
    &TestHtmlX1("59",$prog); # verify fix for issue 0120.
    &TestHtmlX1("60",$prog); # verify fix for issue 0125.
    &Test61($prog); # verify issue 0133.
    &Test62($prog); # verify issue 0133 corner case.
    &TestHtmlX1("63",$prog); # verify fix for issue 0136 (outer).
    &Test64($prog); # verify fix for issue 0136 (inner).
    &Test65($prog); # verify issue 0138.
    &TestHtmlX1("66",$prog); # verify fix for issue 0139.
    &TestHtmlX1("67",$prog); # verify fix for issue 0145.
    &Test68($prog); # verify issue 0146.
    &Test69($prog); # verify that -notcms works (and issue 157).
    &Test70($prog); # verify that static and template detection works.
    &Test71($prog); # verify issue 0152
    &Test72($prog); # verify issue 0153
    &Test73($prog); # verify issue 0109
    &Test74($prog); # verify -notcms corner case
    &Test75($prog); # verify issue 0155.
    &Test76($prog); # verify issue 0156.
    &Test77($prog); # verify issue 0158.
    &Test78($prog); # verify issue 0159 (pkg).
    &Test79($prog); # verify issue 0159 (nsp).
    &Test80($prog); # verify issue 0159 (cls).
    &Test81($prog); # verify issues 0160 and 161.
    &Test82($prog); # verify issues 0162 and 0163.
    &Test83($prog); # verify issue 0166.
    &Test84($prog); # verify issue 0167.
    &Test85($prog); # verify issue 0171.
    &Test86($prog); # verify issue 0152 for different packages.
    &TestHtmlX1("87",$prog); # verify fix for issue 0172.
    &Test88($prog); # verify issue 0183

    # ================================================
    # Report the test summary.
    # ================================================
    my $total  = $main::s_total;
    my $passed = $main::s_passed;  my $failed = $main::s_failed;
    print ":summary:${total}:${passed}:${failed}\n";
    print ":FAILED\n" if ( $failed );
    print ":PASSED\n" if ( ! $failed );
    exit $failed;
}
# ================================================
# Test the help message.
# ================================================
sub Test01
{
    my $prog = shift;
    my $id = "01";

    my $log = "../test/logs/test${id}.log";
    my $ok = "../test/test${id}.ok";

    &Run("$prog -nocout -log $log -help");
    my $errcnt = &FilterAndCompareOk("$log",
				     "$ok",
				     "../test/test_filter1.pl");
}
# ================================================
# Basic C++ token parsing tests.
# ================================================
sub Test02
{
    my $prog = shift;
    my $id = "02";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $sws = "-nocout -rptmac -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src}");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# Javadoc style comment parsing tests.
# ================================================
sub Test03
{
    my $prog = shift;
    my $id = "03";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $sws = "-nocout -log $log -nojdsds";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src}");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# C++ style comment parsing tests.
# ================================================
sub Test04
{
    my $prog = shift;
    my $id = "04";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $sws = "-nocout -log $log -nojdsds";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src}");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# Pre-processing tests
# ================================================
sub Test05
{
    my $prog = shift;
    my $id = "05";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $sws = "-nocout -rptmac -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src}");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# Category tests
# ================================================
sub Test06
{
    my $prog = shift;
    my $id = "06";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $sws = "-nocout -rptmac -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src}");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify package specifications
# ================================================
sub Test07
{
    my $prog = shift;
    my $id = "07";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $sws = "-nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src}");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify extern processing
# ================================================
sub Test08
{
    my $prog = shift;
    my $id = "08";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $sws = "-nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src}");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify root package documentation
# ================================================
sub Test09
{
    my $prog = shift;
    my $id = "09";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $sws = "-nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src}");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fixes for issues 001, 002 and 003
# ================================================
sub Test10
{
    my $prog = shift;
    my $id = "10";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}.root";
    my $sws = "-args -nocout -nojdsds -log $log -meta ${tdir}/test10-meta.txt -rootfile $rootfile";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws -html $html ${src}");
    my $errcnt = &FilterAndCompareOk("../src/$rootfile",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles("../src/$rootfile") if ( $errcnt == 0 );
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify that -cdsm works
# ================================================
sub Test11
{
    my $prog = shift;
    my $id = "11";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -cdsm -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src}");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify that -nocdsm works
# ================================================
sub Test12
{
    my $prog = shift;
    my $id = "12";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -nocdsm -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src}");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0014
# ================================================
sub Test13
{
    my $prog = shift;
    my $id = "13";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log -nojdsds";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src}");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0015
# ================================================
sub Test14
{
    my $prog = shift;
    my $id = "14";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src}");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0025
# ================================================
sub Test15
{
    my $prog = shift;
    my $id = "15";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src}");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0033
# ================================================
sub Test16
{
    my $prog = shift;
    my $id = "16";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src}");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0036
# ================================================
sub Test17
{
    my $prog = shift;
    my $id = "17";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test17.ccdoc.root.pkg.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0042.
# ================================================
sub Test18
{
    my $prog = shift;
    my $id = "18";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log -nojdsds";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test18.ccdoc.root.g_bConnected.var.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0043.
# ================================================
sub Test19
{
    my $prog = shift;
    my $id = "19";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test19.ccdoc.root.test19.cls.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0044.
# ================================================
sub Test20
{
    my $prog = shift;
    my $id = "20";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -rptcsi 2 -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test20.ccdoc.class_summary.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0045.
# ================================================
sub Test21
{
    my $prog = shift;
    my $id = "21";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -rptfwcf -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test21.ccdoc.root.test21.cls.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0046.
# ================================================
sub Test22
{
    my $prog = shift;
    my $id = "22";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -rptfwcf -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test22.ccdoc.root.test22.cls.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0048.
# ================================================
sub Test23
{
    my $prog = shift;
    my $id = "23";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -rptfwcf -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test23.ccdoc.root.ccdoc_test23.class_one.cls.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0050.
# ================================================
sub Test24
{
    my $prog = shift;
    my $id = "24";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -rptfwcf -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test24.ccdoc.root.test24.cls.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0052.
# ================================================
sub Test25
{
    my $prog = shift;
    my $id = "25";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -rptfwcf -index -html $html");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0054.
# ================================================
sub Test26
{
    my $prog = shift;
    my $id = "26";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -rptfwcf -index -html $html");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0063.
# ================================================
sub Test27
{
    my $prog = shift;
    my $id = "27";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -rptdefa w -rptdefasd x -rptdefsd \"\" -rptdefv z -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test27.ccdoc.root.test27.cls.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0064.
# ================================================
sub Test28
{
    my $prog = shift;
    my $id = "28";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test28.ccdoc.root.test028.some_other_class.cls.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0069.
# ================================================
sub Test29
{
    my $prog = shift;
    my $id = "29";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -index -html $html");
    my $errcnt = &CompareOk($db,$ok);
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0073.
# ================================================
sub Test30
{
    my $prog = shift;
    my $id = "30";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test30.ccdoc.root.test30.cls.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0074.
# ================================================
sub Test31
{
    my $prog = shift;
    my $id = "31";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log -rptctcs iso-8859-2";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test31.ccdoc.root.pkg.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0072.
# ================================================
sub Test32
{
    my $prog = shift;
    my $id = "32";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log -norptsci";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test32.ccdoc.root.test32.cls.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify fix for issue 0075.
# ================================================
sub Test33
{
    my $prog = shift;
    my $id = "33";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-args -nocout -log $log -norptsci";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test33.ccdoc.root.fct33.tyf.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# Test the fix for issue 0076.
# ================================================
sub Test34
{
    my $prog = shift;
    my $id = "34";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-nocout -log $log -rptctcs foo -meta ${tdir}/${tid}-meta.txt";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -index -html $html");
    my $errcnt = &FilterAndCompareOk("$log",
				     "$ok",
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# Test the fix for issue 0077.
# ================================================
sub Test35
{
    my $prog = shift;
    my $id = "35";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/test35.ccdoc.root.test35.cls.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# Test the fix for issue 0078.
# ================================================
sub Test36
{
    my $prog = shift;
    my $id = "36";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -index -html $html");
    my $errcnt = &FilterAndCompareOk("${ldir}/test36.ccdoc.root.test36.var.html",
				     $ok,
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# Test the -putenv switch.
# ================================================
sub Test37
{
    my $prog = shift;
    my $id = "37";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -putenv CCDOC_PHASE1_DEBUG=1 -db $db $sws ${src} -index -html $html");
    my $errcnt = &FilterAndCompareOk("$log",
				     "$ok",
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# Test the fix for issue 0080.
# ================================================
sub Test38
{
    my $prog = shift;
    my $id = "38";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.${tid}_B.cls.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# Test the fix for issue 0095.
# ================================================
sub Test45
{
    my $prog = shift;
    my $id = "45";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.${tid}.Test.void.Test.-28.-29.fct.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# Test the fix for issue 0112.
# ================================================
sub Test48
{
    my $prog = shift;
    my $id = "48";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.${tid}.operator-20-7c.int.operator.-7c.-28.int.-2c.int.-29.opr.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# verify the @pkgdoctid directive
# ================================================
sub Test56
{
    my $prog = shift;
    my $id = "56";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.pkg.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# verify issue 0133
# This is challenging because the test requires
# two input files.
# ================================================
sub Test61
{
    my $prog = shift;
    my $id = "61";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src1 = "${tdir}/${tid}_1.h";
    my $src2 = "${tdir}/${tid}_2.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-nocout -log $log -v";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.-anonymous-.s_test61_fct.checksum.cd8fdd2c.fct.html";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src1}");
    &Run("$prog -db $db $sws ${src2}");
    &Run("$prog -db $db $sws -index");
    &Run("$prog -db $db $sws -html $html");
    my $errcnt = &FilterAndCompareOk("$htmlfile",
				     "$ok",
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify issue 0133 corner case
# ================================================
sub Test62
{
    my $prog = shift;
    my $id = "62";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.${tid}.nsp.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# verify verify fix for issue 0136 (inner)
# ================================================
sub Test64
{
    my $prog = shift;
    my $id = "64";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.${tid}.A.Test.str.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# verify issue 0138
# This is challenging because the test requires
# two input files.
# ================================================
sub Test65
{
    my $prog = shift;
    my $id = "65";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src1 = "${tdir}/${tid}_1.h";
    my $src2 = "${tdir}/${tid}_2.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-nocout -log $log -v";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.A.B.C.foo.void.foo.-28.void.-29.fct.html";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src1}");
    &Run("$prog -db $db $sws ${src2}");
    &Run("$prog -db $db $sws -index");
    &Run("$prog -db $db $sws -html $html");
    my $errcnt = &FilterAndCompareOk("$htmlfile",
				     "$ok",
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify issue 0146
# This is challenging because the test requires
# two input files.
# ================================================
sub Test68
{
    my $prog = shift;
    my $id = "68";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src1 = "${tdir}/${tid}_1.h";
    my $src2 = "${tdir}/${tid}_2.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-nocout -log $log -v";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.${tid}.nsp.html";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src1}");
    &Run("$prog -db $db $sws ${src2}");
    &Run("$prog -db $db $sws -index");
    &Run("$prog -db $db $sws -html $html");
    my $errcnt = &FilterAndCompareOk("$htmlfile",
				     "$ok",
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify that -notcms works
# ================================================
sub Test69
{
    my $prog = shift;
    my $id = "69";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.pkg.html";

    &TestHtmlFile($id,$prog,$htmlfile,"-notcms");
}
# ================================================
# verify that static and template detection works.
# ================================================
sub Test70
{
    my $prog = shift;
    my $id = "70";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.pkg.html";

    &TestHtmlFile($id,$prog,$htmlfile,"-notcms");
}
# ================================================
# verify issue 0152
# ================================================
sub Test71
{
    my $prog = shift;
    my $id = "71";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.pkg.html";

    &TestHtmlFile($id,$prog,$htmlfile,"-rptmac");
}
# ================================================
# verify issue 0153
# ================================================
sub Test72
{
    my $prog = shift;
    my $id = "72";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.pkg.html";

    &TestHtmlFile($id,$prog,$htmlfile,"-rptmac1");
}
# ================================================
# verify issue 0109
# ================================================
sub Test73
{
    my $prog = shift;
    my $id = "73";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-nocout -log $log";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src} -index -html $html");
    my $errcnt = &FilterAndCompareOk("$log",
				     "$ok",
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify -notcms corner case
# ================================================
sub Test74
{
    my $prog = shift;
    my $id = "74";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.Test.cls.html";

    &TestHtmlFile($id,$prog,$htmlfile,"-notcms");
}
# ================================================
# verify issue 0155
# This is challenging because the test requires
# two input files.
# ================================================
sub Test75
{
    my $prog = shift;
    my $id = "75";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src1 = "${tdir}/${tid}_1.h";
    my $src2 = "${tdir}/${tid}_2.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-nocout -log $log -v";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.${tid}.nsp.html";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src1}");
    &Run("$prog -db $db $sws ${src2}");
    &Run("$prog -db $db $sws -index");
    &Run("$prog -db $db $sws -html $html");
    my $errcnt = &FilterAndCompareOk("$htmlfile",
				     "$ok",
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify issue 0156
# This is challenging because the test requires
# two input files.
# ================================================
sub Test76
{
    my $prog = shift;
    my $id = "76";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src1 = "${tdir}/${tid}_1.h";
    my $src2 = "${tdir}/${tid}_2.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-nocout -log $log -v";

    my $htmlfile = "${ldir}/${tid}.ccdoc.class_summary.html";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws ${src1}");
    &Run("$prog -db $db $sws ${src2}");
    &Run("$prog -db $db $sws -index");
    &Run("$prog -db $db $sws -html $html");
    my $errcnt = &FilterAndCompareOk("$htmlfile",
				     "$ok",
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify issue 158
# ================================================
sub Test77
{
    my $prog = shift;
    my $id = "77";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.pkg.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# verify issue 159 (pkg)
# ================================================
sub Test78
{
    my $prog = shift;
    my $id = "78";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.pkg.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# verify issue 159 (nsp)
# ================================================
sub Test79
{
    my $prog = shift;
    my $id = "79";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.very_big_123456789012345678901234567890123456789012345678901234567890.nsp.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# verify issue 159 (cls)
# ================================================
sub Test80
{
    my $prog = shift;
    my $id = "80";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.very_big_123456789012345678901234567890123456789012345678901234567890.very_big2_123456789012345678901234567890123456789012345678901234567890.checksum.abc930d0.cls.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# verify issues 160 and 161
# ================================================
sub Test81
{
    my $prog = shift;
    my $id = "81";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.Test.cls.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# verify issues 162 and 163
# ================================================
sub Test82
{
    my $prog = shift;
    my $id = "82";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.pkg.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# verify issues 166
# ================================================
sub Test83
{
    my $prog = shift;
    my $id = "83";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.s_id.var.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# verify issues 167
# ================================================
sub Test84
{
    my $prog = shift;
    my $id = "84";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.pkg.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# verify issues 171
# ================================================
sub Test85
{
    my $prog = shift;
    my $id = "85";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.Test.cls.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# verify issues 152 for different packages.
# ================================================
sub Test86
{
    my $prog = shift;
    my $id = "86";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src1 = "${tdir}/${tid}_1.h";
    my $src2 = "${tdir}/${tid}_2.h";
    my $rootfile = "${tid}-root.html";
    my $sws = "-nocout -log $log -v";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.${tid}.pkg.html";

    &DeleteFiles($df);
    &Run("$prog -db $db $sws $pkg ${src1}");
    &Run("$prog -db $db $sws $pkg ${src2}");
    &Run("$prog -db $db $sws -index");
    &Run("$prog -db $db $sws -rptmac1 -html $html");
    my $errcnt = &FilterAndCompareOk("$htmlfile",
				     "$ok",
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# verify issue 0183
# ================================================
sub Test88
{
    my $prog = shift;
    my $id = "88";

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.test88.cls.html";
    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# TestHtmlX1
# ================================================
sub TestHtmlX1
{
    my $id = shift;;
    my $prog = shift;

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";

    my $htmlfile = "${ldir}/${tid}.ccdoc.root.${tid}.Test.cls.html";

    &TestHtmlFile($id,$prog,$htmlfile,"");
}
# ================================================
# TestHtmlFile
# ================================================
sub TestHtmlFile
{
    my $id = shift;;
    my $prog = shift;
    my $htmlfile = shift;
    my $sws = shift;

    my $tid = "test${id}";
    my $tdir = "../test";
    my $ldir = "${tdir}/logs";
    my $tpath = "${ldir}/${tid}";

    my $db = "${tpath}.db";
    my $df = "${tpath}*";
    my $html = "${tpath}.";
    my $log = "${tpath}.log";
    my $ok = "${tdir}/${tid}.ok";
    my $pkg = "-pkg ${tid}";
    my $src = "${tdir}/${tid}.h";
    my $rootfile = "${tid}-root.html";

    &DeleteFiles($df);
    &Run("$prog -nocout -log $log -db $db $sws ${src} -index -html $html");
    my $errcnt = &FilterAndCompareOk("$htmlfile",
				     "$ok",
				     "../test/test_filter1.pl");
    &DeleteFiles($df) if ( $errcnt == 0 );
}
# ================================================
# Delete files
# ================================================
sub DeleteFiles
{
    my $pattern = shift;
    &Run("rm -f $pattern");
}
# ================================================
# Run a command.
# ================================================
sub Run
{
    my $cmd = shift;

    print "CMD: $cmd\n"  if( $main::s_verbose );
    my $st = system("$cmd");
    $st = $st >> 8;
    return $st;
}
# ================================================
# Filter and Compare with an OK file.
# ================================================
sub FilterAndCompareOk
{
    my $file = shift;
    my $okfile = shift;
    my $filter = shift;

    my $err = 0;

    $err += &Exists("$filter");
    $err += &Exists("$file");
    $err += &Exists("$okfile");

    $err += &Filter("${file}","$filter");
    $err += &Filter("${okfile}","$filter");

    if ( ! $err ) {
	my $st = &Run("diff -q -w ${file}.tmp ${okfile}.tmp");
	if( $st == 0 ) {
	    &Passed("compareok-${file}");
	    unlink("$file");
	    unlink("$file.tmp");
	    unlink("$okfile.tmp");
	}
	else {
	    &Failed("compareok-${file}");
	    $err++;
	}
    }
    else {
	&Failed("compareok-${file}");
	$err++;
    }
    return $err;
}
# ================================================
# Compare with an OK file.
# ================================================
sub CompareOk
{
    my $file = shift;
    my $okfile = shift;

    my $err = 0;
    $err += &Exists("$file");
    $err += &Exists("$okfile");

    if ( ! $err ) {
	my $st = &Run("diff -q -w ${file} ${okfile}");
	if( $st == 0 ) {
	    &Passed("compareok-${file}");
	    unlink("$file");
	}
	else {
	    $err++;
	    &Failed("compareok-${file}");
	}
    }
    else {
	$err++;
	&Failed("compareok-${file}");
    }
    return $err;
}
# ================================================
# Filter
# ================================================
sub Filter
{
    my $file = shift;
    my $filter = shift;

    if ( ! -e "$filter" ) {
	&Failed("filter-${file}");
	return 1;
    }

    if ( ! -e "$file" ) {
	&Failed("filter-${file}");
	return 1;
    }

    my $st = &Run("perl $filter $file $file.tmp");
    if ( $st ) {
	&Failed("filter-${file}");
	return 1;
    }

    &Passed("filter-${file}");
    return 0;
}
# ================================================
# Test for file existence.
# ================================================
sub Exists
{
    my $file = shift;
    if( ! -e $file ) {
	&Failed("exists-${file}");
	return 1;
    }
    &Passed("exists-${file}");
    return 0;
}
# ================================================
# failed
# ================================================
sub Failed
{
    my $id = shift;
    print ":test:${id}:failed\n";
    $main::s_failed++;
    $main::s_total++;
}
# ================================================
# passed
# ================================================
sub Passed
{
    my $id = shift;
    print ":test:${id}:passed\n" if( $main::s_verbose );
    $main::s_passed++;
    $main::s_total++;
}
