//@copyright_begin
// ================================================================
// Copyright Notice
// Copyright (C) 1998-2004 by Joe Linoff
// 
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL JOE LINOFF BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Comments and suggestions are always welcome.
// Please report bugs to http://ccdoc.sourceforge.net/ccdoc
// ================================================================
//@copyright_end

// MULTIPLE INCLUSION GUARD
#ifndef ccdoc_exceptions_h
#define ccdoc_exceptions_h

/**
 * This variable allows the header version
 * to be queried at runtime.
 */
namespace {
   char ccdoc_exceptions_h_rcsid[] = "$Id: exceptions.h,v 1.6 2004/09/30 04:16:01 jlinoff Exp $";
}

#if defined(_MSC_VER)
#pragma warning ( disable : 4786 4251 )
#endif

#include <string>

using namespace std;

namespace ccdoc {
  namespace exceptions {
    /**
     * Base exception class.
     * @author Joe Linoff
     * @version $Id: exceptions.h,v 1.6 2004/09/30 04:16:01 jlinoff Exp $
     */
    class base {
    public:
      /**
       * Default constructor.
       */
      base();
      /**
       * Id based constructor.
       * @param id The exception id.
       * @param file __FILE__.
       * @param lineno __LINE__.
       * @param msg Additional message text.
       */
      base(const char* id,const char* file,int lineno,const char* msg);
      /**
       * Destructor.
       */
      virtual ~base();
      /**
       * Report the exception.
       */
      virtual void report() const;
    protected:
      string m_msg;
    };
    /**
     * Assertion exception.
     * @author Joe Linoff
     * @version $Id: exceptions.h,v 1.6 2004/09/30 04:16:01 jlinoff Exp $
     */
    class assert_true : public ccdoc::exceptions::base {
    public:
      /**
       * Constructor.
       * @param file __FILE__
       * @param lineni __LINE__
       * @param expr The expression that resolved to false.
       */
      assert_true(const char* file,int lineno,const char* expr);
    };
    /**
     * Invalid database exception.
     * @author Joe Linoff
     * @version $Id: exceptions.h,v 1.6 2004/09/30 04:16:01 jlinoff Exp $
     */
    class invalid_database : public ccdoc::exceptions::base {
    public:
      /**
       * @param file __FILE__
       * @param lineno __LINE__
       * @param dbfile The db file.
       * @param msg Additional information about the error.
       */
      invalid_database(const char* file,
		       int lineno,
		       const char* dbfile,
		       const char* msg);
    };
    /**
     * Duplicate_name exception.
     * @author Joe Linoff
     * @version $Id: exceptions.h,v 1.6 2004/09/30 04:16:01 jlinoff Exp $
     */
    class duplicate_name : public ccdoc::exceptions::base {
    public:
      /**
       * @param file __FILE__
       * @param lineno __LINE__
       * @param name The duplicate name file.
       * @param msg Additional information about the error.
       */
      duplicate_name(const char* file,
		     int lineno,
		     const char* name,
		     const char* msg);
    };
    /**
     * Unwriteable output file.
     * @author Joe Linoff
     * @version $Id: exceptions.h,v 1.6 2004/09/30 04:16:01 jlinoff Exp $
     */
    class unwriteable_output_file : public ccdoc::exceptions::base {
    public:
      /**
       * @param file __FILE__
       * @param lineno __LINE__
       * @param name The file name.
       */
      unwriteable_output_file(const char* file,
			      int lineno,
			      const char* name);
    };
  }
}

/**
 * assertion macro.
 */
#define ccdoc_assert(expr) \
  if( !(expr) ) { throw ccdoc::exceptions::assert_true(__FILE__,__LINE__,#expr); }

#endif
