#!/bin/bash
DESTDIR=/tmp/install/INSTALL
PACKDIR=/tmp/install/catgets

SRCPATH="${PWD}"
SRCDIR=$(basename "${PWD}")
PACKVERS=$(echo "${SRCDIR}" | sed -e 's/catgets-//')
mkdir -p "${DESTDIR}"
make install DESTDIR="${DESTDIR}"

mkdir -p "${PACKDIR}"
mkdir -p "${PACKDIR}"/libcatgets1
mkdir -p "${PACKDIR}"/libcatgets-devel

cd "${PACKDIR}"
tar -cjf catgets-"${PACKVERS}"-src.tar.bz2 --exclude='*.[oisa]' --exclude='*.dll' --exclude='*.exe' --exclude=tags -C "${SRCPATH}/.." "${SRCDIR}"
tar -cjf catgets-"${PACKVERS}".tar.bz2 -C ${DESTDIR} usr/bin/gencat.exe
tar -cjf libcatgets1/libcatgets1-"${PACKVERS}".tar.bz2 -C ${DESTDIR} usr/bin/cygcatgets1.dll
tar -cjf libcatgets-devel/libcatgets-devel-"${PACKVERS}".tar.bz2 -C ${DESTDIR} usr/include usr/lib

cat > setup.hint <<EOF
sdesc: "catgets message catalog API; gencat"
ldesc: "catgets message catalog API; gencat"
category: Devel Text
requires: cygwin libiconv2 libintl8 libcatgets1
EOF

cat > libcatgets1/setup.hint <<EOF
sdesc: "catgets message catalog API; runtime"
ldesc: "catgets message catalog API; runtime"
category: Libs
requires: cygwin libgcc1
external-source: catgets
EOF

cat > libcatgets-devel/setup.hint <<EOF
sdesc: "catgets message catalog API; development"
ldesc: "catgets message catalog API; development"
category: Devel
requires: catgets
external-source: catgets
EOF

rm -rf "${DESTDIR}"/*
