/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core;

import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreNSAwareElement;
import org.apache.axiom.core.CoreNSUnawareElement;

public interface ElementMatcher<T extends CoreElement> {
    public static final ElementMatcher<CoreElement> ANY = new ElementMatcher<CoreElement>(){

        @Override
        public boolean matches(CoreElement element, String namespaceURI, String name) {
            return true;
        }
    };
    public static final ElementMatcher<CoreNSAwareElement> BY_QNAME = new ElementMatcher<CoreNSAwareElement>(){

        @Override
        public boolean matches(CoreNSAwareElement element, String namespaceURI, String name) {
            return name.equals(element.coreGetLocalName()) && namespaceURI.equals(element.coreGetNamespaceURI());
        }
    };
    public static final ElementMatcher<CoreNSAwareElement> BY_NAMESPACE_URI = new ElementMatcher<CoreNSAwareElement>(){

        @Override
        public boolean matches(CoreNSAwareElement element, String namespaceURI, String name) {
            return namespaceURI.equals(element.coreGetNamespaceURI());
        }
    };
    public static final ElementMatcher<CoreNSAwareElement> BY_LOCAL_NAME = new ElementMatcher<CoreNSAwareElement>(){

        @Override
        public boolean matches(CoreNSAwareElement element, String namespaceURI, String name) {
            return name.equals(element.coreGetLocalName());
        }
    };
    public static final ElementMatcher<CoreElement> BY_NAME = new ElementMatcher<CoreElement>(){

        @Override
        public boolean matches(CoreElement element, String namespaceURI, String name) {
            if (element instanceof CoreNSUnawareElement) {
                return name.equals(((CoreNSUnawareElement)element).coreGetName());
            }
            CoreNSAwareElement nsAwareElement = (CoreNSAwareElement)element;
            String prefix = nsAwareElement.coreGetPrefix();
            int prefixLength = prefix.length();
            String localName = nsAwareElement.coreGetLocalName();
            if (prefixLength == 0) {
                return name.equals(localName);
            }
            int localNameLength = localName.length();
            if (prefixLength + localNameLength + 1 == name.length()) {
                int i;
                if (name.charAt(prefixLength) != ':') {
                    return false;
                }
                for (i = 0; i < localNameLength; ++i) {
                    if (name.charAt(prefixLength + i + 1) == localName.charAt(i)) continue;
                    return false;
                }
                for (i = 0; i < prefix.length(); ++i) {
                    if (name.charAt(i) == prefix.charAt(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    public boolean matches(T var1, String var2, String var3);
}

