/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.segment;

import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.segment.FixedSizeSegmentSplitter;
import org.apache.uniffle.common.segment.LocalOrderSegmentSplitter;
import org.apache.uniffle.common.segment.SegmentSplitter;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class SegmentSplitterFactory {
    private SegmentSplitterFactory() {
    }

    public SegmentSplitter get(ShuffleDataDistributionType distributionType, Roaring64NavigableMap expectTaskIds, int readBufferSize) {
        switch (distributionType) {
            case LOCAL_ORDER: {
                return new LocalOrderSegmentSplitter(expectTaskIds, readBufferSize);
            }
        }
        return new FixedSizeSegmentSplitter(readBufferSize);
    }

    public static SegmentSplitterFactory getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static class LazyHolder {
        static final SegmentSplitterFactory INSTANCE = new SegmentSplitterFactory();

        private LazyHolder() {
        }
    }
}

