/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ExceptionReporter;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MapOutput;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeManager;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.RssTezBypassWriter;
import org.apache.uniffle.client.api.ShuffleReadClient;
import org.apache.uniffle.client.response.CompressedShuffleBlock;
import org.apache.uniffle.common.compression.Codec;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssTezShuffleDataFetcher
extends CallableWithNdc<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(RssTezShuffleDataFetcher.class);
    private static final String SHUFFLE_ERR_GRP_NAME = "Shuffle Errors";
    private final TezCounter ioErrs;
    private final MergeManager merger;
    private final long totalBlockCount;
    private long copyBlockCount = 0L;
    private volatile boolean stopped = false;
    private final ShuffleReadClient shuffleReadClient;
    private long readTime = 0L;
    private long decompressTime = 0L;
    private long serializeTime = 0L;
    private long waitTime = 0L;
    private long copyTime = 0L;
    private long unCompressionLength = 0L;
    private final InputAttemptIdentifier inputAttemptIdentifier;
    private static int uniqueMapId = 0;
    private boolean hasPendingData = false;
    private long startWait;
    private int waitCount = 0;
    private byte[] uncompressedData = null;
    private final Codec rssCodec;
    private Integer partitionId;
    private final ExceptionReporter exceptionReporter;
    private final AtomicInteger issuedCnt = new AtomicInteger(0);

    public RssTezShuffleDataFetcher(InputAttemptIdentifier inputAttemptIdentifier, Integer partitionId, MergeManager merger, TezCounters tezCounters, ShuffleReadClient shuffleReadClient, long totalBlockCount, RssConf rssConf, ExceptionReporter exceptionReporter) {
        this.merger = merger;
        this.partitionId = partitionId;
        this.inputAttemptIdentifier = inputAttemptIdentifier;
        this.exceptionReporter = exceptionReporter;
        this.ioErrs = tezCounters.findCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.IO_ERROR.toString());
        this.shuffleReadClient = shuffleReadClient;
        this.totalBlockCount = totalBlockCount;
        this.rssCodec = Codec.newInstance(rssConf);
        LOG.info("RssTezShuffleDataFetcher, partitionId:{}, inputAttemptIdentifier:{}.", (Object)this.partitionId, (Object)this.inputAttemptIdentifier);
    }

    public Void callInternal() {
        try {
            this.fetchAllRssBlocks();
        }
        catch (InterruptedException ie) {
            LOG.warn(ie.getMessage(), (Throwable)ie);
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Throwable t) {
            LOG.warn(t.getMessage(), t);
            this.exceptionReporter.reportException(t);
        }
        return null;
    }

    public void fetchAllRssBlocks() throws IOException, InterruptedException {
        while (!this.stopped) {
            try {
                this.merger.waitForInMemoryMerge();
                this.copyFromRssServer();
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    @VisibleForTesting
    public void copyFromRssServer() throws IOException {
        CompressedShuffleBlock compressedBlock = null;
        ByteBuffer compressedData = null;
        if (!this.hasPendingData) {
            long startFetch = System.currentTimeMillis();
            compressedBlock = this.shuffleReadClient.readShuffleBlockData();
            if (compressedBlock != null) {
                compressedData = compressedBlock.getByteBuffer();
            }
            long fetchDuration = System.currentTimeMillis() - startFetch;
            this.readTime += fetchDuration;
        }
        if (!this.hasPendingData && compressedData != null) {
            long startDecompress = System.currentTimeMillis();
            int uncompressedLen = compressedBlock.getUncompressLength();
            ByteBuffer decompressedBuffer = ByteBuffer.allocate(uncompressedLen);
            this.rssCodec.decompress(compressedData, uncompressedLen, decompressedBuffer, 0);
            this.uncompressedData = decompressedBuffer.array();
            this.unCompressionLength += (long)compressedBlock.getUncompressLength();
            long decompressDuration = System.currentTimeMillis() - startDecompress;
            this.decompressTime += decompressDuration;
        }
        if (this.uncompressedData != null) {
            long startSerialization = System.currentTimeMillis();
            if (this.issueMapOutputMerge()) {
                long serializationDuration = System.currentTimeMillis() - startSerialization;
                this.serializeTime += serializationDuration;
                if (this.hasPendingData) {
                    this.waitTime += System.currentTimeMillis() - this.startWait;
                }
            } else {
                this.startWait = System.currentTimeMillis();
                return;
            }
            this.hasPendingData = false;
            this.uncompressedData = null;
            ++this.copyBlockCount;
            this.copyTime = this.readTime + this.decompressTime + this.serializeTime + this.waitTime;
            this.updateStatus();
        } else {
            this.shuffleReadClient.close();
            this.shuffleReadClient.checkProcessedBlockIds();
            this.shuffleReadClient.logStatics();
            LOG.info("Reduce task " + this.inputAttemptIdentifier + " read block cnt: " + this.copyBlockCount + " cost " + this.readTime + " ms to fetch and " + this.decompressTime + " ms to decompress with unCompressionLength[" + this.unCompressionLength + "] and " + this.serializeTime + " ms to serialize and " + this.waitTime + " ms to wait resource, copy time:" + this.copyTime);
            this.stopFetch();
        }
    }

    public Integer getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(Integer partitionId) {
        this.partitionId = partitionId;
    }

    private boolean issueMapOutputMerge() throws IOException {
        InputAttemptIdentifier uniqueInputAttemptIdentifier = this.getNextUniqueInputAttemptIdentifier();
        MapOutput mapOutput = null;
        try {
            this.issuedCnt.incrementAndGet();
            LOG.info("IssueMapOutputMerge, uncompressedData length:{}, issueCnt:{}, totalBlockCount:{}", new Object[]{this.uncompressedData.length, this.issuedCnt.get(), this.totalBlockCount});
            mapOutput = this.merger.reserve(uniqueInputAttemptIdentifier, (long)this.uncompressedData.length, 0L, 1);
        }
        catch (IOException ioe) {
            this.ioErrs.increment(1L);
            throw ioe;
        }
        if (mapOutput == null || mapOutput.getType() == MapOutput.Type.WAIT) {
            LOG.info("RssMRFetcher - MergeManager returned status WAIT ...");
            this.hasPendingData = true;
            ++this.waitCount;
            return false;
        }
        try {
            RssTezBypassWriter.write(mapOutput, this.uncompressedData);
            mapOutput.commit();
        }
        catch (Throwable t) {
            this.ioErrs.increment(1L);
            mapOutput.abort();
            throw new RssException("Reduce: " + this.inputAttemptIdentifier + " cannot write block to " + mapOutput.getClass().getSimpleName() + " due to: " + t.getClass().getName());
        }
        return true;
    }

    private InputAttemptIdentifier getNextUniqueInputAttemptIdentifier() {
        return new InputAttemptIdentifier(uniqueMapId++, 0);
    }

    private void updateStatus() {
    }

    @VisibleForTesting
    public int getRetryCount() {
        return this.waitCount;
    }

    private void stopFetch() {
        LOG.info("RssTezShuffleDataFetcher stop fetch");
        this.stopped = true;
    }

    public void shutDown() {
        this.stopFetch();
        LOG.info("RssTezShuffleDataFetcher shutdown");
    }

    private static enum ShuffleErrors {
        IO_ERROR,
        WRONG_LENGTH,
        BAD_ID,
        WRONG_MAP,
        CONNECTION,
        WRONG_REDUCE;

    }
}

