/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb.core.ivm.naming;

import org.apache.openejb.core.ivm.EjbObjectInputStream;
import org.apache.openejb.core.ivm.IntraVmCopyMonitor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CrossClassLoaderJndiReference extends IntraVmJndiReference {
    public CrossClassLoaderJndiReference(final String jndiName) {
        super(jndiName);
    }

    public Object getObject() throws javax.naming.NamingException {
        Object o = super.getObject();
        try {
            o = copy(o);
        } catch (final Exception e) {
            throw new NamingException("Error copying object into local class loader", e);
        }
        return o;
    }

    private static Object copy(final Object source) throws Exception {
        IntraVmCopyMonitor.preCrossClassLoaderOperation();
        try {
            final ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            final ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(source);
            out.close();

            final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            final ObjectInputStream in = new EjbObjectInputStream(bais);
            return in.readObject();
        } finally {
            IntraVmCopyMonitor.postCrossClassLoaderOperation();
        }
    }
}
