/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.TraverserGenerator;
import org.apache.tinkerpop.gremlin.process.traversal.step.FromToModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.PopContaining;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.Writing;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.EventUtil;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.ListCallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

public class AddEdgeStartStep
extends AbstractStep<Edge, Edge>
implements Writing<Event.EdgeAddedEvent>,
TraversalParent,
Scoping,
FromToModulating {
    private static final String FROM = Graph.Hidden.hide("from");
    private static final String TO = Graph.Hidden.hide("to");
    private boolean first = true;
    private Parameters parameters = new Parameters();
    private CallbackRegistry<Event.EdgeAddedEvent> callbackRegistry;

    public AddEdgeStartStep(Traversal.Admin traversal, String edgeLabel) {
        super(traversal);
        this.parameters.set(this, T.label, edgeLabel);
    }

    public AddEdgeStartStep(Traversal.Admin traversal, Traversal<?, String> edgeLabelTraversal) {
        super(traversal);
        this.parameters.set(this, T.label, edgeLabelTraversal);
    }

    @Override
    public <S, E> List<Traversal.Admin<S, E>> getLocalChildren() {
        return this.parameters.getTraversals();
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public Set<String> getScopeKeys() {
        return this.parameters.getReferencedLabels();
    }

    @Override
    public HashSet<PopContaining.PopInstruction> getPopInstructions() {
        HashSet<PopContaining.PopInstruction> popInstructions = new HashSet<PopContaining.PopInstruction>();
        popInstructions.addAll(TraversalParent.super.getPopInstructions());
        return popInstructions;
    }

    @Override
    public void configure(Object ... keyValues) {
        this.parameters.set(this, keyValues);
    }

    @Override
    public void addTo(Traversal.Admin<?, ?> toObject) {
        this.parameters.set(this, TO, toObject);
    }

    @Override
    public void addFrom(Traversal.Admin<?, ?> fromObject) {
        this.parameters.set(this, FROM, fromObject);
    }

    @Override
    protected Traverser.Admin<Edge> processNextStart() {
        if (this.first) {
            this.first = false;
            TraverserGenerator generator = this.getTraversal().getTraverserGenerator();
            Traverser.Admin<Edge> traverser = generator.generate(1, this, 1L);
            String edgeLabel = this.parameters.get(traverser, T.label, () -> "edge").get(0);
            Object theTo = this.parameters.get(traverser, TO, () -> null).get(0);
            if (!(theTo instanceof Vertex)) {
                throw new IllegalStateException(String.format("The value given to addE(%s).to() must resolve to a Vertex but %s was specified instead", edgeLabel, null == theTo ? "null" : theTo.getClass().getSimpleName()));
            }
            Object theFrom = this.parameters.get(traverser, FROM, () -> null).get(0);
            if (!(theFrom instanceof Vertex)) {
                throw new IllegalStateException(String.format("The value given to addE(%s).from() must resolve to a Vertex but %s was specified instead", edgeLabel, null == theFrom ? "null" : theFrom.getClass().getSimpleName()));
            }
            Vertex toVertex = (Vertex)theTo;
            Vertex fromVertex = (Vertex)theFrom;
            if (toVertex instanceof Attachable) {
                toVertex = (Vertex)((Attachable)((Object)toVertex)).attach(Attachable.Method.get(this.getTraversal().getGraph().orElse(EmptyGraph.instance())));
            }
            if (fromVertex instanceof Attachable) {
                fromVertex = (Vertex)((Attachable)((Object)fromVertex)).attach(Attachable.Method.get(this.getTraversal().getGraph().orElse(EmptyGraph.instance())));
            }
            Edge edge = fromVertex.addEdge(edgeLabel, toVertex, this.parameters.getKeyValues(traverser, TO, FROM, T.label));
            EventUtil.registerEdgeCreation(this.callbackRegistry, this.getTraversal(), edge);
            return generator.generate(edge, this, 1L);
        }
        throw FastNoSuchElementException.instance();
    }

    @Override
    public CallbackRegistry<Event.EdgeAddedEvent> getMutatingCallbackRegistry() {
        if (null == this.callbackRegistry) {
            this.callbackRegistry = new ListCallbackRegistry<Event.EdgeAddedEvent>();
        }
        return this.callbackRegistry;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.parameters.hashCode();
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.parameters.toString());
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.parameters.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public AddEdgeStartStep clone() {
        AddEdgeStartStep clone = (AddEdgeStartStep)super.clone();
        clone.parameters = this.parameters.clone();
        return clone;
    }
}

