/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.MeasurementParseException;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultAddress;
import org.apache.sis.metadata.iso.citation.DefaultContact;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.util.AxisDirections;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.storage.netcdf.base.Axis;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.Grid;
import org.apache.sis.storage.netcdf.base.Variable;
import org.apache.sis.storage.netcdf.base.VariableRole;
import org.apache.sis.storage.wkt.StoreFormat;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.identification.KeywordType;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

final class MetadataReader
extends MetadataBuilder {
    private static final boolean EXPERIMENTAL = true;
    private static final String[] SERVICES = new String[]{"wms_service", "wcs_service"};
    private static final char SEPARATOR = ',';
    private static final char QUOTE = '\"';
    private final Decoder decoder;
    private final String[] searchPath;
    private transient ResponsibleParty pointOfContact;
    private VerticalCRS verticalCRS;
    private boolean hasGridCoverages;

    MetadataReader(Decoder decoder) {
        this.decoder = decoder;
        decoder.setSearchPath(decoder.convention().getSearchPath());
        this.searchPath = decoder.getSearchPath();
    }

    private void warning(Exception e) {
        this.decoder.listeners.warning(e);
    }

    private void warning(short key, Object p1, Object p2, Exception e) {
        StoreListeners listeners = this.decoder.listeners;
        listeners.warning(Errors.getResources(listeners.getLocale()).getString(key, p1, p2), e);
    }

    static List<String> split(String value) {
        if (value == null) {
            return List.of();
        }
        ArrayList<String> items = new ArrayList<String>();
        int start = 0;
        int length = CharSequences.skipTrailingWhitespaces(value, 0, value.length());
        while ((start = CharSequences.skipLeadingWhitespaces(value, start, length)) < length) {
            int end;
            int next;
            block6: {
                if (value.charAt(start) == '\"') {
                    next = ++start;
                    while ((end = value.indexOf(34, next)) >= 0) {
                        next = CharSequences.skipLeadingWhitespaces(value, end + 1, length);
                        if (next < length && value.charAt(next) != ',') continue;
                        break block6;
                    }
                    break;
                }
                next = value.indexOf(44, start);
                if (next < 0) break;
                end = CharSequences.skipTrailingWhitespaces(value, start, next);
            }
            if (start != end) {
                items.add(value.substring(start, end));
            }
            start = next + 1;
        }
        if (start < length) {
            items.add(value.substring(start, length));
        }
        return items;
    }

    private String stringValue(String name) {
        return Strings.trimOrNull(this.decoder.stringValue(name));
    }

    private double numericValue(String name) {
        Number v = this.decoder.numericValue(name);
        return v != null ? v.doubleValue() : Double.NaN;
    }

    private <T extends Enum<T>> T forEnumName(Class<T> enumType, String name) {
        T code = Types.forEnumName(enumType, name);
        if (code == null && name != null) {
            this.warning((short)146, enumType, name, null);
        }
        return code;
    }

    private <T extends CodeList<T>> T forCodeName(Class<T> codeType, String name) {
        T code = Types.forCodeName(codeType, name, false);
        if (code == null && name != null) {
            this.warning((short)146, codeType, name, null);
        }
        return code;
    }

    private static <T> Set<T> addIfNonNull(Set<T> collection, T element) {
        if (element != null) {
            if (collection == null) {
                collection = new LinkedHashSet<T>(4);
            }
            collection.add(element);
        }
        return collection;
    }

    private static boolean canShare(CharSequence metadata, String attribute) {
        return attribute == null || metadata != null && metadata.toString().equals(attribute);
    }

    private static boolean canShare(Collection<String> metadata, String attribute) {
        return attribute == null || metadata.contains(attribute);
    }

    private static boolean canShare(OnlineResource resource, String url) {
        return url == null || resource != null && MetadataReader.canShare(resource.getLinkage().toString(), url);
    }

    private static boolean canShare(Address address, String email) {
        return email == null || address != null && MetadataReader.canShare(address.getElectronicMailAddresses(), email);
    }

    private URI createURI(String url) {
        if (url != null) {
            try {
                return new URI(url);
            }
            catch (URISyntaxException e) {
                this.warning(e);
            }
        }
        return null;
    }

    private OnlineResource createOnlineResource(String url) {
        URI uri = this.createURI(url);
        if (uri == null) {
            return null;
        }
        DefaultOnlineResource resource = new DefaultOnlineResource(uri);
        String protocol = uri.getScheme();
        resource.setProtocol(protocol);
        if (IOUtilities.isHTTP(protocol)) {
            resource.setApplicationProfile("web browser");
        }
        resource.setFunction(OnLineFunction.INFORMATION);
        return resource;
    }

    private static Address createAddress(String email) {
        if (email != null) {
            DefaultAddress address = new DefaultAddress();
            address.setElectronicMailAddresses(Set.of(email));
            return address;
        }
        return null;
    }

    private static Contact createContact(Address address, OnlineResource url) {
        if (address != null || url != null) {
            DefaultContact contact = new DefaultContact();
            if (address != null) {
                contact.setAddresses(Set.of(address));
            }
            if (url != null) {
                contact.setOnlineResources(Set.of(url));
            }
            return contact;
        }
        return null;
    }

    private ResponsibleParty createResponsibleParty(AttributeNames.Responsible keys, boolean isPointOfContact) {
        Role role;
        String individualName = this.stringValue(keys.NAME);
        String organisationName = this.stringValue(keys.INSTITUTION);
        String email = this.stringValue(keys.EMAIL);
        String url = this.stringValue(keys.URL);
        if (organisationName == null && isPointOfContact) {
            organisationName = this.stringValue("institution");
        }
        if (individualName == null && organisationName == null && email == null && url == null) {
            return null;
        }
        if (organisationName == null) {
            if (this.isOrganisation(keys)) {
                organisationName = individualName;
                individualName = null;
            }
        } else if (organisationName.equalsIgnoreCase(individualName)) {
            individualName = null;
        }
        if ((role = this.forCodeName(Role.class, this.stringValue(keys.ROLE))) == null) {
            role = isPointOfContact ? Role.POINT_OF_CONTACT : keys.DEFAULT_ROLE;
        }
        ResponsibleParty responsibility = this.pointOfContact;
        Contact contact = null;
        Address address = null;
        OnlineResource resource = null;
        if (responsibility != null) {
            contact = responsibility.getContactInfo();
            if (contact != null) {
                address = contact.getAddress();
                resource = contact.getOnlineResource();
            }
            if (!MetadataReader.canShare(resource, url)) {
                resource = null;
                contact = null;
                responsibility = null;
            }
            if (!MetadataReader.canShare(address, email)) {
                address = null;
                contact = null;
                responsibility = null;
            }
            if (!(responsibility == null || MetadataReader.canShare(responsibility.getOrganisationName(), organisationName) && MetadataReader.canShare(responsibility.getIndividualName(), individualName))) {
                responsibility = null;
            }
        }
        if (responsibility == null) {
            if (contact == null) {
                if (address == null) {
                    address = MetadataReader.createAddress(email);
                }
                if (resource == null) {
                    resource = this.createOnlineResource(url);
                }
                contact = MetadataReader.createContact(address, resource);
            }
            if (individualName != null || organisationName != null || contact != null) {
                AbstractParty party = null;
                if (individualName != null) {
                    party = new DefaultIndividual(individualName, null, null);
                }
                if (organisationName != null) {
                    party = new DefaultOrganisation(organisationName, null, (DefaultIndividual)party, null);
                }
                if (party == null) {
                    AbstractParty abstractParty = party = this.isOrganisation(keys) ? new DefaultOrganisation() : new DefaultIndividual();
                }
                if (contact != null) {
                    party.setContactInfo(Set.of(contact));
                }
                responsibility = new DefaultResponsibleParty(role);
                if (party != null) {
                    ((DefaultResponsibleParty)responsibility).setParties(Set.of(party));
                }
            }
        }
        return responsibility;
    }

    private boolean isOrganisation(AttributeNames.Responsible keys) {
        String type = this.stringValue(keys.TYPE);
        return "institution".equalsIgnoreCase(type) || "group".equalsIgnoreCase(type);
    }

    private Set<InternationalString> addCitation() {
        String title = this.stringValue("title");
        if (title == null && (title = this.stringValue("full_name")) == null && (title = this.stringValue("name")) == null) {
            title = this.decoder.getTitle();
        }
        this.addTitle(title);
        this.addEdition(this.stringValue("product_version"));
        this.addOtherCitationDetails(this.stringValue("references"));
        this.addCitationDate(this.decoder.dateValue("metadata_creation"), DateType.CREATION, MetadataBuilder.Scope.ALL);
        this.addCitationDate(this.decoder.dateValue("date_metadata_modified"), DateType.REVISION, MetadataBuilder.Scope.ALL);
        this.addCitationDate(this.decoder.dateValue("date_created"), DateType.CREATION, MetadataBuilder.Scope.RESOURCE);
        this.addCitationDate(this.decoder.dateValue("date_modified"), DateType.REVISION, MetadataBuilder.Scope.RESOURCE);
        this.addCitationDate(this.decoder.dateValue("date_issued"), DateType.PUBLICATION, MetadataBuilder.Scope.RESOURCE);
        for (String path : this.searchPath) {
            this.decoder.setSearchPath(path);
            ResponsibleParty party = this.createResponsibleParty(AttributeNames.CREATOR, true);
            if (party == this.pointOfContact) continue;
            this.addPointOfContact(party, MetadataBuilder.Scope.RESOURCE);
            if (this.pointOfContact != null) continue;
            this.pointOfContact = party;
        }
        this.addCitedResponsibleParty(this.pointOfContact, Role.ORIGINATOR);
        Set<InternationalString> publisher = null;
        for (String path : this.searchPath) {
            ResponsibleParty r;
            this.decoder.setSearchPath(path);
            ResponsibleParty contributor = this.createResponsibleParty(AttributeNames.CONTRIBUTOR, false);
            if (contributor != this.pointOfContact) {
                this.addCitedResponsibleParty(contributor, null);
            }
            if (!((r = this.createResponsibleParty(AttributeNames.PUBLISHER, false)) instanceof DefaultResponsibility)) continue;
            this.addDistributor(r);
            for (AbstractParty party : ((DefaultResponsibility)((Object)r)).getParties()) {
                publisher = MetadataReader.addIfNonNull(publisher, party.getName());
            }
        }
        this.decoder.setSearchPath(this.searchPath);
        return publisher;
    }

    private void addIdentificationInfo(Set<InternationalString> publisher) throws IOException, DataStoreException {
        String[] format;
        String id;
        boolean hasExtent = false;
        Set<String> project = null;
        Set<String> standard = null;
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        for (String path : this.searchPath) {
            this.decoder.setSearchPath(path);
            keywords.addAll(MetadataReader.split(this.stringValue(AttributeNames.KEYWORDS.TEXT)));
            standard = MetadataReader.addIfNonNull(standard, this.stringValue(AttributeNames.STANDARD_NAME.TEXT));
            project = MetadataReader.addIfNonNull(project, this.stringValue("project"));
            for (String keyword : MetadataReader.split(this.stringValue("acces_constraint"))) {
                this.addAccessConstraint(this.forCodeName(Restriction.class, keyword));
            }
            this.addTopicCategory(this.forCodeName(TopicCategory.class, this.stringValue("topic_category")));
            this.addSpatialRepresentation(this.forCodeName(SpatialRepresentationType.class, this.stringValue("cdm_data_type")));
            if (hasExtent) continue;
            hasExtent = this.addExtent();
        }
        this.decoder.setSearchPath(this.searchPath);
        this.addAbstract(this.stringValue("summary"));
        this.addPurpose(this.stringValue("purpose"));
        this.addSupplementalInformation(this.stringValue("comment"));
        this.addCredits(this.stringValue("acknowledgement"));
        this.addCredits(this.stringValue("acknowledgment"));
        this.addUseLimitation(this.stringValue("license"));
        this.addKeywords(standard, KeywordType.THEME, this.stringValue(AttributeNames.STANDARD_NAME.VOCABULARY));
        this.addKeywords(keywords, KeywordType.THEME, this.stringValue(AttributeNames.KEYWORDS.VOCABULARY));
        this.addKeywords(project, KeywordType.valueOf("PROJECT"), null);
        this.addKeywords(publisher, KeywordType.valueOf("DATA_CENTRE"), null);
        String wkt = this.stringValue("geospatial_bounds");
        if (wkt != null) {
            this.addBoundingPolygon(new StoreFormat(null, null, this.decoder.geomlib, this.decoder.listeners).parseGeometry(wkt, this.stringValue("geospatial_bounds_crs"), this.stringValue("geospatial_bounds_vertical_crs")));
        }
        if ("NetCDF".equalsIgnoreCase(id = (format = this.decoder.getFormatDescription())[0])) {
            try {
                this.setPredefinedFormat("NetCDF");
                id = null;
            }
            catch (MetadataStoreException e) {
                this.warning(e);
            }
        }
        if (format.length >= 2) {
            this.addFormatName(format[1]);
            if (format.length >= 3) {
                this.setFormatEdition(format[2]);
            }
        }
        this.addFormatName(id);
    }

    private void addSpatialRepresentationInfo(Axis[] axes) throws IOException, DataStoreException {
        block10: for (int i = 0; i < axes.length; ++i) {
            AttributeNames.Dimension attributeNames;
            Axis axis = axes[i];
            int d = i;
            axis.getMainSize().ifPresent(s -> this.setAxisSize(d, s));
            switch (axis.abbreviation) {
                case '\u03b8': 
                case '\u03bb': {
                    attributeNames = AttributeNames.LONGITUDE;
                    break;
                }
                case '\u03a9': 
                case '\u03c6': {
                    attributeNames = AttributeNames.LATITUDE;
                    break;
                }
                case 'D': 
                case 'H': 
                case 'h': {
                    attributeNames = AttributeNames.VERTICAL;
                    break;
                }
                case 'T': 
                case 't': {
                    attributeNames = AttributeNames.TIME;
                    break;
                }
                default: {
                    continue block10;
                }
            }
            DimensionNameType name = attributeNames.DEFAULT_NAME_TYPE;
            this.setAxisName(i, name);
            String res = this.stringValue(attributeNames.RESOLUTION);
            if (res == null) continue;
            try {
                double value;
                int s2 = res.indexOf(32);
                Unit<?> units = null;
                if (s2 < 0) {
                    value = this.numericValue(attributeNames.RESOLUTION);
                } else {
                    value = Double.parseDouble(res.substring(0, s2).trim());
                    String symbol = res.substring(s2 + 1).trim();
                    if (!symbol.isEmpty()) {
                        try {
                            units = Units.valueOf(symbol);
                        }
                        catch (MeasurementParseException e) {
                            this.warning((short)3, name, units, e);
                        }
                    }
                }
                this.setAxisResolution(i, value, units);
                continue;
            }
            catch (NumberFormatException e) {
                this.warning(e);
            }
        }
        this.setCellGeometry(CellGeometry.AREA);
    }

    private boolean addExtent() {
        this.addExtent(this.stringValue("geographic_identifier"));
        double[] extent = new double[4];
        boolean hasExtent = this.fillExtent(AttributeNames.LONGITUDE, Units.DEGREE, AxisDirection.EAST, extent, 0);
        if (hasExtent |= this.fillExtent(AttributeNames.LATITUDE, Units.DEGREE, AxisDirection.NORTH, extent, 2)) {
            this.addExtent(extent, 0);
            hasExtent = true;
        }
        if (this.fillExtent(AttributeNames.VERTICAL, Units.METRE, null, extent, 0)) {
            this.addVerticalExtent(extent[0], extent[1], this.verticalCRS);
            hasExtent = true;
        }
        Date startTime = this.decoder.dateValue(AttributeNames.TIME.MINIMUM);
        Date endTime = this.decoder.dateValue(AttributeNames.TIME.MAXIMUM);
        if (startTime == null && endTime == null) {
            String symbol;
            Number tmin = this.decoder.numericValue(AttributeNames.TIME.MINIMUM);
            Number tmax = this.decoder.numericValue(AttributeNames.TIME.MAXIMUM);
            if ((tmin != null || tmax != null) && (symbol = this.stringValue(AttributeNames.TIME.UNITS)) != null) {
                Date[] dates = this.decoder.numberToDate(symbol, tmin, tmax);
                startTime = dates[0];
                endTime = dates[1];
            }
        }
        if (startTime != null || endTime != null) {
            this.addTemporalExtent(startTime, endTime);
            hasExtent = true;
        }
        return hasExtent;
    }

    private boolean fillExtent(AttributeNames.Dimension dim, Unit<?> targetUnit, AxisDirection positive, double[] extent, int index) {
        String symbol;
        boolean hasExtent;
        double min = this.numericValue(dim.MINIMUM);
        double max = this.numericValue(dim.MAXIMUM);
        boolean bl = hasExtent = !Double.isNaN(min) || !Double.isNaN(max);
        if (hasExtent && (symbol = this.stringValue(dim.UNITS)) != null) {
            try {
                UnitConverter c = Units.valueOf(symbol).getConverterToAny(targetUnit);
                min = c.convert(min);
                max = c.convert(max);
            }
            catch (IncommensurableException | MeasurementParseException e) {
                this.warning(e);
            }
            boolean reverse = false;
            if (positive != null) {
                reverse = AxisDirections.opposite(positive).equals(Axis.direction(symbol));
            } else if (dim.POSITIVE != null) {
                reverse = "down".equals(this.stringValue(dim.POSITIVE));
            }
            if (reverse) {
                double tmp = min;
                min = -max;
                max = -tmp;
            }
        }
        extent[index] = min;
        extent[index + 1] = max;
        return hasExtent;
    }

    private void addAcquisitionInfo() {
        AttributeNames.Term[] attributes = new AttributeNames.Term[]{AttributeNames.PROGRAM, AttributeNames.PLATFORM, AttributeNames.INSTRUMENT};
        for (int i = 0; i < attributes.length; ++i) {
            AttributeNames.Term at = attributes[i];
            String authority = this.stringValue(at.VOCABULARY);
            for (String keyword : MetadataReader.split(this.stringValue(at.TEXT))) {
                switch (i) {
                    case 0: {
                        this.addAcquisitionOperation(authority, keyword);
                        break;
                    }
                    case 1: {
                        this.addPlatform(authority, keyword);
                        break;
                    }
                    case 2: {
                        this.addInstrument(authority, keyword);
                    }
                }
            }
        }
    }

    private void addContentInfo() {
        CharSequence[] names;
        LinkedHashSet<Dimension> features = new LinkedHashSet<Dimension>();
        LinkedHashMap coverages = new LinkedHashMap(4);
        for (Variable variable : this.decoder.getVariables()) {
            if (VariableRole.isCoverage(variable)) {
                List<Dimension> dimensions = variable.getGridDimensions();
                names = new String[dimensions.size()];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = dimensions.get(i).getName();
                }
                CollectionsExt.addToMultiValuesMap(coverages, Arrays.asList(names), variable);
                this.hasGridCoverages = true;
                continue;
            }
            if (variable.getRole() != VariableRole.FEATURE_PROPERTY) continue;
            features.add(variable.getGridDimensions().get(0));
        }
        if (!features.isEmpty()) {
            this.addSpatialRepresentation(SpatialRepresentationType.TEXT_TABLE);
        }
        if (!coverages.isEmpty()) {
            this.addSpatialRepresentation(SpatialRepresentationType.GRID);
        }
        for (Dimension feature : features) {
            String name = feature.getName();
            if (name == null) continue;
            this.addFeatureType(this.decoder.nameFactory.createLocalName(this.decoder.namespace, name), feature.length());
        }
        String processingLevel = this.stringValue("processing_level");
        for (List group : coverages.values()) {
            this.newCoverage(false);
            this.setProcessingLevelCode(null, processingLevel);
            for (Variable variable : group) {
                this.addSampleDimension(variable);
                names = variable.getAttributeAsStrings("flag_names", ' ');
                CharSequence[] meanings = variable.getAttributeAsStrings("flag_meanings", ' ');
                Vector masks = variable.getAttributeAsVector("flag_masks");
                Vector values = variable.getAttributeAsVector("flag_values");
                int s1 = names != null ? names.length : 0;
                int s2 = meanings != null ? meanings.length : 0;
                int s3 = masks != null ? masks.size() : 0;
                int s4 = values != null ? values.size() : 0;
                int length = Math.max(s1, Math.max(s2, Math.max(s3, s4)));
                for (int i = 0; i < length; ++i) {
                    this.addSampleValueDescription(variable, i < s1 ? names[i] : null, i < s2 ? meanings[i] : null, i < s3 ? (Number)masks.get(i) : (Number)null, i < s4 ? (Number)values.get(i) : (Number)null);
                }
            }
        }
    }

    private void addSampleDimension(Variable variable) {
        String description;
        String id;
        this.newSampleDimension();
        String name = Strings.trimOrNull(variable.getName());
        if (name != null) {
            DefaultNameFactory f = this.decoder.nameFactory;
            StringBuilder buffer = new StringBuilder(20);
            variable.writeDataTypeName(buffer);
            this.setBandIdentifier(f.createMemberName(null, name, f.createTypeName(null, buffer.toString())));
        }
        if (!(id = Strings.trimOrNull(variable.getStandardName())).equals(name)) {
            this.addBandName(variable.getAttributeAsString("standard_name_vocabulary"), id);
        }
        if ((description = Strings.trimOrNull(variable.getDescription())) != null && !description.equals(name) && !description.equals(id)) {
            this.addBandDescription(description);
        }
        this.setSampleUnits(variable.getUnit());
        this.setTransferFunction(variable.getAttributeAsDouble("scale_factor"), variable.getAttributeAsDouble("add_offset"));
        this.addContentType(this.forCodeName(CoverageContentType.class, this.stringValue("coverage_content_type")));
    }

    private void addSampleValueDescription(Variable variable, CharSequence name, CharSequence meaning, Number mask, Number value) {
        this.addSampleValueDescription(name, meaning);
    }

    private void addFileIdentifier() {
        String authority;
        String identifier = this.stringValue(AttributeNames.IDENTIFIER.TEXT);
        if (identifier != null) {
            authority = this.stringValue(AttributeNames.IDENTIFIER.VOCABULARY);
        } else {
            identifier = this.decoder.getId();
            if (identifier == null && (identifier = IOUtilities.filenameWithoutExtension(this.decoder.getFilename())) == null) {
                return;
            }
            authority = null;
        }
        if (authority == null) {
            this.addTitleOrIdentifier(identifier, MetadataBuilder.Scope.RESOURCE);
        } else {
            this.addIdentifier(authority, identifier, MetadataBuilder.Scope.RESOURCE);
        }
    }

    public Metadata read() throws IOException, DataStoreException {
        for (CoordinateReferenceSystem crs : this.decoder.getReferenceSystemInfo()) {
            this.addReferenceSystem(crs);
            if (this.verticalCRS != null) continue;
            this.verticalCRS = CRS.getVerticalComponent(crs, false);
        }
        this.addResourceScope(ScopeCode.DATASET, null);
        this.addIdentificationInfo(this.addCitation());
        for (String service : SERVICES) {
            String name = this.stringValue(service);
            if (name == null) continue;
            this.addResourceScope(ScopeCode.SERVICE, name);
        }
        this.addAcquisitionInfo();
        this.addContentInfo();
        for (Grid cs : this.decoder.getGridCandidates()) {
            Axis[] axes;
            if (cs.getSourceDimensions() < 2 || (axes = cs.getAxes(this.decoder)).length < 2) continue;
            this.addSpatialRepresentationInfo(axes);
        }
        this.setISOStandards(this.hasGridCoverages);
        this.addFileIdentifier();
        for (String path : this.searchPath) {
            this.decoder.setSearchPath(path);
            this.addLineage(this.stringValue("history"));
            this.addSource(this.stringValue("source"), null, null);
        }
        this.decoder.setSearchPath(this.searchPath);
        DefaultMetadata metadata = this.build();
        this.addCompleteMetadata(this.createURI(this.stringValue("metadata_link")));
        metadata.transitionTo(ModifiableMetadata.State.FINAL);
        return metadata;
    }
}

