/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.content.RangeElementDescription;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;

@TitleProperty(name="name")
@XmlType(name="MI_RangeElementDescription_Type", propOrder={"name", "definition", "rangeElements"})
@XmlRootElement(name="MI_RangeElementDescription")
public class DefaultRangeElementDescription
extends ISOMetadata
implements RangeElementDescription {
    private static final long serialVersionUID = -8891149098619355114L;
    private InternationalString name;
    private InternationalString definition;
    private Collection<Record> rangeElements;

    public DefaultRangeElementDescription() {
    }

    public DefaultRangeElementDescription(RangeElementDescription object) {
        super(object);
        if (object != null) {
            this.name = object.getName();
            this.definition = object.getDefinition();
            this.rangeElements = this.copyCollection(object.getRangeElements(), Record.class);
        }
    }

    public static DefaultRangeElementDescription castOrCopy(RangeElementDescription object) {
        if (object == null || object instanceof DefaultRangeElementDescription) {
            return (DefaultRangeElementDescription)object;
        }
        return new DefaultRangeElementDescription(object);
    }

    @Override
    @XmlElement(name="name", required=true)
    public InternationalString getName() {
        return this.name;
    }

    public void setName(InternationalString newValue) {
        this.checkWritePermission(this.name);
        this.name = newValue;
    }

    @Override
    @XmlElement(name="definition", required=true)
    public InternationalString getDefinition() {
        return this.definition;
    }

    public void setDefinition(InternationalString newValue) {
        this.checkWritePermission(this.definition);
        this.definition = newValue;
    }

    @XmlElement(name="rangeElement", required=true)
    public Collection<Record> getRangeElements() {
        this.rangeElements = this.nonNullCollection(this.rangeElements, Record.class);
        return this.rangeElements;
    }

    public void setRangeElements(Collection<? extends Record> newValues) {
        this.rangeElements = this.writeCollection(newValues, this.rangeElements, Record.class);
    }
}

