/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.internal;

import java.util.Date;
import java.util.ServiceLoader;
import org.apache.sis.pending.geoapi.temporal.Instant;
import org.apache.sis.pending.geoapi.temporal.Period;
import org.apache.sis.pending.geoapi.temporal.TemporalFactory;
import org.apache.sis.pending.temporal.DefaultTemporalFactory;
import org.apache.sis.system.Reflect;
import org.apache.sis.system.SystemListener;
import org.opengis.temporal.TemporalPrimitive;

public final class TemporalUtilities
extends SystemListener {
    private static volatile TemporalFactory implementation;

    private TemporalUtilities() {
        super("org.apache.sis.metadata");
    }

    @Override
    protected void classpathChanged() {
        implementation = null;
    }

    public static TemporalFactory getTemporalFactory() {
        TemporalFactory factory = implementation;
        if (factory == null) {
            implementation = factory = ServiceLoader.load(TemporalFactory.class, Reflect.getContextClassLoader()).findFirst().orElseGet(DefaultTemporalFactory::provider);
        }
        return factory;
    }

    private static Instant createInstant(TemporalFactory factory, Date date) {
        return factory.createInstant(date);
    }

    public static Instant createInstant(Date time) throws UnsupportedOperationException {
        return time != null ? TemporalUtilities.createInstant(TemporalUtilities.getTemporalFactory(), time) : null;
    }

    public static Period createPeriod(Date begin, Date end) throws UnsupportedOperationException {
        TemporalFactory factory = TemporalUtilities.getTemporalFactory();
        return factory.createPeriod(TemporalUtilities.createInstant(factory, begin), TemporalUtilities.createInstant(factory, end));
    }

    public static Date getDate(TemporalPrimitive time) {
        Instant instant;
        if (time instanceof Instant) {
            instant = (Instant)time;
        } else if (time instanceof Period) {
            instant = ((Period)time).getEnding();
            if (instant == null) {
                instant = ((Period)time).getBeginning();
            }
        } else {
            return null;
        }
        return instant.getDate();
    }

    public static Date toDate(java.time.Instant instant) {
        return instant != null ? Date.from(instant) : null;
    }

    static {
        SystemListener.add(new TemporalUtilities());
    }
}

