/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.j2d;

import java.awt.geom.PathIterator;

final class DecimatedPathIterator
implements PathIterator {
    private final PathIterator source;
    private final double xRes;
    private final double yRes;
    private double px;
    private double py;

    DecimatedPathIterator(PathIterator source, double xRes, double yRes) {
        this.source = source;
        this.xRes = xRes;
        this.yRes = yRes;
        this.py = Double.NaN;
        this.px = Double.NaN;
    }

    @Override
    public void next() {
        this.source.next();
    }

    @Override
    public boolean isDone() {
        return this.source.isDone();
    }

    @Override
    public int getWindingRule() {
        return this.source.getWindingRule();
    }

    @Override
    public int currentSegment(double[] coords) {
        do {
            int type = this.source.currentSegment(coords);
            switch (type) {
                default: {
                    this.py = Double.NaN;
                    this.px = Double.NaN;
                    return type;
                }
                case 0: {
                    this.px = coords[0];
                    this.py = coords[1];
                    return 0;
                }
                case 1: 
            }
            if (this.include(coords[0], coords[1])) {
                return 1;
            }
            this.source.next();
        } while (!this.source.isDone());
        coords[0] = this.px;
        coords[1] = this.py;
        return 1;
    }

    @Override
    public int currentSegment(float[] coords) {
        do {
            int type = this.source.currentSegment(coords);
            switch (type) {
                default: {
                    this.py = Double.NaN;
                    this.px = Double.NaN;
                    return type;
                }
                case 0: {
                    this.px = coords[0];
                    this.py = coords[1];
                    return 0;
                }
                case 1: 
            }
            if (this.include(coords[0], coords[1])) {
                return 1;
            }
            this.source.next();
        } while (!this.source.isDone());
        coords[0] = (float)this.px;
        coords[1] = (float)this.py;
        return 1;
    }

    private boolean include(double x, double y) {
        if (Math.abs(this.px - x) < this.xRes && Math.abs(this.py - y) < this.yRes) {
            return false;
        }
        this.px = x;
        this.py = y;
        return true;
    }
}

