/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.pending.geoapi.filter.SortBy;
import org.apache.sis.pending.geoapi.filter.SortProperty;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.UnmodifiableArrayList;

public final class SortByComparator<R>
implements SortBy<R>,
Serializable {
    private static final long serialVersionUID = -7964849249532212389L;
    private final SortProperty<R>[] properties;

    private SortByComparator(SortProperty<R> p) {
        ArgumentChecks.ensureNonNullElement("properties", 0, p);
        this.properties = new SortProperty[]{p};
    }

    private SortByComparator(Map<?, SortProperty<R>> merged) {
        this.properties = (SortProperty[])merged.values().toArray(SortProperty[]::new);
    }

    public static <R> SortByComparator<R> create(SortProperty<R>[] properties) {
        switch (properties.length) {
            case 0: {
                return null;
            }
            case 1: {
                return new SortByComparator<R>(properties[0]);
            }
        }
        LinkedHashMap merged = new LinkedHashMap();
        SortByComparator.addAll(Arrays.asList(properties), merged);
        return new SortByComparator<R>(merged);
    }

    public static <R> SortBy<? super R> concatenate(SortBy<? super R> sort, Comparator<? super R> comparator) {
        SortByComparator<R> other;
        if (comparator instanceof SortBy) {
            other = (SortByComparator<R>)comparator;
        } else if (comparator instanceof SortProperty) {
            other = new SortByComparator<R>((SortProperty)comparator);
        } else {
            return null;
        }
        if (sort == null) {
            return other;
        }
        return SortByComparator.concatenate(sort, other);
    }

    public static <R> SortBy<R> concatenate(SortBy<R> s1, SortBy<R> s2) {
        LinkedHashMap merged = new LinkedHashMap();
        SortByComparator.addAll(s1.getSortProperties(), merged);
        SortByComparator.addAll(s2.getSortProperties(), merged);
        return new SortByComparator<R>(merged);
    }

    private static <R> void addAll(List<SortProperty<R>> properties, Map<ValueReference<R, ?>, SortProperty<R>> merged) {
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            SortProperty<R> p = properties.get(i);
            ArgumentChecks.ensureNonNullElement("properties", i, p);
            merged.putIfAbsent(p.getValueReference(), p);
        }
    }

    @Override
    public List<SortProperty<R>> getSortProperties() {
        return UnmodifiableArrayList.wrap(this.properties);
    }

    @Override
    public int compare(R r1, R r2) {
        for (SortProperty<R> p : this.properties) {
            int c = p.compare(r1, r2);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public Comparator<R> thenComparing(Comparator<? super R> other) {
        if (other instanceof SortBy) {
            return SortByComparator.concatenate(this, (SortBy)other);
        }
        return SortBy.super.thenComparing(other);
    }
}

