/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import opennlp.tools.commons.Internal;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringUtil;

@Internal
public class EvalitaNameSampleStream
implements ObjectStream<NameSample> {
    public static final int GENERATE_PERSON_ENTITIES = 1;
    public static final int GENERATE_ORGANIZATION_ENTITIES = 2;
    public static final int GENERATE_LOCATION_ENTITIES = 4;
    public static final int GENERATE_GPE_ENTITIES = 8;
    public static final String DOCSTART = "-DOCSTART-";
    private final LANGUAGE lang;
    private final ObjectStream<String> lineStream;
    private final int types;

    public EvalitaNameSampleStream(LANGUAGE lang, ObjectStream<String> lineStream, int types) {
        this.lang = lang;
        this.lineStream = lineStream;
        this.types = types;
    }

    public EvalitaNameSampleStream(LANGUAGE lang, InputStreamFactory in, int types) throws IOException {
        this(lang, new PlainTextByLineStream(in, StandardCharsets.UTF_8), types);
    }

    private static Span extract(int begin, int end, String beginTag) throws InvalidFormatException {
        String type;
        switch (type = beginTag.substring(2)) {
            case "PER": {
                type = "person";
                break;
            }
            case "LOC": {
                type = "location";
                break;
            }
            case "GPE": {
                type = "gpe";
                break;
            }
            case "ORG": {
                type = "organization";
                break;
            }
            default: {
                throw new InvalidFormatException("Unknown type: " + type);
            }
        }
        return new Span(begin, end, type);
    }

    @Override
    public NameSample read() throws IOException {
        String line;
        ArrayList<String> sentence = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        boolean isClearAdaptiveData = false;
        while ((line = this.lineStream.read()) != null && !StringUtil.isEmpty(line)) {
            if (line.startsWith(DOCSTART)) {
                isClearAdaptiveData = true;
                String emptyLine = this.lineStream.read();
                if (StringUtil.isEmpty(emptyLine)) continue;
                throw new IOException("Empty line after -DOCSTART- not empty: '" + emptyLine + "'!");
            }
            String[] fields = line.split(" ");
            if (LANGUAGE.IT.equals((Object)this.lang) && fields.length == 4) {
                sentence.add(fields[0]);
                tags.add(fields[3]);
                continue;
            }
            throw new IOException("Incorrect number of fields per line for language: '" + line + "'!");
        }
        if (LANGUAGE.IT.equals((Object)this.lang)) {
            isClearAdaptiveData = true;
        }
        if (sentence.size() > 0) {
            ArrayList<Span> names = new ArrayList<Span>();
            int beginIndex = -1;
            int endIndex = -1;
            for (int i = 0; i < tags.size(); ++i) {
                String tag = (String)tags.get(i);
                if (tag.endsWith("PER") && (this.types & 1) == 0) {
                    tag = "O";
                }
                if (tag.endsWith("ORG") && (this.types & 2) == 0) {
                    tag = "O";
                }
                if (tag.endsWith("LOC") && (this.types & 4) == 0) {
                    tag = "O";
                }
                if (tag.endsWith("GPE") && (this.types & 8) == 0) {
                    tag = "O";
                }
                if (tag.startsWith("B-")) {
                    if (beginIndex != -1) {
                        names.add(EvalitaNameSampleStream.extract(beginIndex, endIndex, (String)tags.get(beginIndex)));
                        beginIndex = -1;
                        endIndex = -1;
                    }
                    beginIndex = i;
                    endIndex = i + 1;
                    continue;
                }
                if (tag.startsWith("I-")) {
                    ++endIndex;
                    continue;
                }
                if (tag.equals("O")) {
                    if (beginIndex == -1) continue;
                    names.add(EvalitaNameSampleStream.extract(beginIndex, endIndex, (String)tags.get(beginIndex)));
                    beginIndex = -1;
                    endIndex = -1;
                    continue;
                }
                throw new IOException("Invalid tag: " + tag);
            }
            if (beginIndex != -1) {
                names.add(EvalitaNameSampleStream.extract(beginIndex, endIndex, (String)tags.get(beginIndex)));
            }
            return new NameSample(sentence.toArray(new String[0]), names.toArray(new Span[0]), isClearAdaptiveData);
        }
        if (line != null) {
            return this.read();
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.lineStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.lineStream.close();
    }

    public static enum LANGUAGE {
        IT;

    }
}

