/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data.sketch;

import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.sketch.MatrixSketch;
import org.apache.sysds.runtime.matrix.operators.CountDistinctOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;

public abstract class CountDistinctSketch
implements MatrixSketch {
    public final CountDistinctOperator op;

    public CountDistinctSketch(Operator op) {
        if (!(op instanceof CountDistinctOperator)) {
            throw new DMLRuntimeException(String.format("Cannot create %s with given operator", CountDistinctSketch.class.getSimpleName()));
        }
        this.op = (CountDistinctOperator)op;
        if (this.op.getDirection() == null) {
            throw new DMLRuntimeException("No direction was set for the operator");
        }
        if (!(this.op.getDirection().isRow() || this.op.getDirection().isCol() || this.op.getDirection().isRowCol())) {
            throw new DMLRuntimeException(String.format("Unexpected direction: %s", new Object[]{this.op.getDirection()}));
        }
    }

    protected void validateSketchMetadata(MatrixBlock corrBlock) {
        if (corrBlock.getNumColumns() < 3 || corrBlock.get(0, 0) < 0.0 || corrBlock.get(0, 1) < 0.0 || corrBlock.get(0, 2) < 0.0) {
            throw new DMLRuntimeException("Sketch metadata is corrupt");
        }
    }
}

