/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.thirdparty.protobuf.MessageOrBuilder;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.proto.YarnSecurityTokenProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerCredentialTokenIdentifier
extends TokenIdentifier {
    private static final Logger LOG = LoggerFactory.getLogger(DockerCredentialTokenIdentifier.class);
    private YarnSecurityTokenProtos.DockerCredentialTokenIdentifierProto proto;
    public static final Text KIND = new Text("DOCKER_CLIENT_CREDENTIAL_TOKEN");

    public DockerCredentialTokenIdentifier(String registryUrl, String applicationId) {
        YarnSecurityTokenProtos.DockerCredentialTokenIdentifierProto.Builder builder = YarnSecurityTokenProtos.DockerCredentialTokenIdentifierProto.newBuilder();
        if (registryUrl != null) {
            builder.setRegistryUrl(registryUrl);
        }
        if (applicationId != null) {
            builder.setApplicationId(applicationId);
        }
        this.proto = builder.build();
    }

    public DockerCredentialTokenIdentifier() {
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.proto.toByteArray());
    }

    public void readFields(DataInput in) throws IOException {
        this.proto = YarnSecurityTokenProtos.DockerCredentialTokenIdentifierProto.parseFrom((DataInputStream)in);
    }

    public YarnSecurityTokenProtos.DockerCredentialTokenIdentifierProto getProto() {
        return this.proto;
    }

    public Text getKind() {
        return KIND;
    }

    public UserGroupInformation getUser() {
        return UserGroupInformation.createRemoteUser((String)(this.getRegistryUrl() + "-" + this.getApplicationId()));
    }

    public String getRegistryUrl() {
        String registryUrl = null;
        if (this.proto.hasRegistryUrl()) {
            registryUrl = this.proto.getRegistryUrl();
        }
        return registryUrl;
    }

    public String getApplicationId() {
        String applicationId = null;
        if (this.proto.hasApplicationId()) {
            applicationId = this.proto.getApplicationId();
        }
        return applicationId;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals(((DockerCredentialTokenIdentifier)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }
}

