/*
 * Decompiled with CFR 0.152.
 */
package jcuda.runtime;

import jcuda.Pointer;
import jcuda.runtime.cudaArray;
import jcuda.runtime.cudaChannelFormatDesc;
import jcuda.runtime.cudaMipmappedArray;

public class cudaResourceDesc {
    public int resType;
    public cudaArray array_array = new cudaArray();
    public cudaMipmappedArray mipmap_mipmap = new cudaMipmappedArray();
    public Pointer linear_devPtr = new Pointer();
    public cudaChannelFormatDesc linear_desc = new cudaChannelFormatDesc();
    public long linear_sizeInBytes;
    public Pointer pitch2D_devPtr = new Pointer();
    public cudaChannelFormatDesc pitch2D_desc = new cudaChannelFormatDesc();
    public long pitch2D_width;
    public long pitch2D_height;
    public long pitch2D_pitchInBytes;

    public String toString() {
        return "cudaResourceDesc[" + this.createString(",") + "]";
    }

    public String toFormattedString() {
        return "CUDA resource descriptor:\n    " + this.createString("\n    ");
    }

    private String createString(String f) {
        StringBuilder sb = new StringBuilder();
        switch (this.resType) {
            case 0: {
                sb.append("array=" + this.array_array + f);
                break;
            }
            case 1: {
                sb.append("mipmap=" + this.mipmap_mipmap + f);
                break;
            }
            case 2: {
                sb.append("devPtr=" + this.linear_devPtr + f);
                sb.append("format=" + this.linear_desc + f);
                sb.append("sizeInBytes=" + this.linear_sizeInBytes + f);
                break;
            }
            case 3: {
                sb.append("devPtr=" + this.pitch2D_devPtr + f);
                sb.append("format=" + this.pitch2D_desc + f);
                sb.append("width=" + this.pitch2D_width + f);
                sb.append("height=" + this.pitch2D_height + f);
                sb.append("pitchInBytes=" + this.pitch2D_pitchInBytes + f);
                break;
            }
            default: {
                sb.append("INVALID");
            }
        }
        return sb.toString();
    }
}

