/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.util.collection.SortDataFormat;
import org.apache.spark.util.collection.unsafe.sort.RecordPointerAndKeyPrefix;

public final class UnsafeSortDataFormat
extends SortDataFormat<RecordPointerAndKeyPrefix, LongArray> {
    private final LongArray buffer;

    public UnsafeSortDataFormat(LongArray buffer) {
        this.buffer = buffer;
    }

    @Override
    public RecordPointerAndKeyPrefix getKey(LongArray data, int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RecordPointerAndKeyPrefix newKey() {
        return new RecordPointerAndKeyPrefix();
    }

    @Override
    public RecordPointerAndKeyPrefix getKey(LongArray data, int pos, RecordPointerAndKeyPrefix reuse) {
        reuse.recordPointer = data.get(pos * 2);
        reuse.keyPrefix = data.get(pos * 2 + 1);
        return reuse;
    }

    @Override
    public void swap(LongArray data, int pos0, int pos1) {
        long tempPointer = data.get(pos0 * 2);
        long tempKeyPrefix = data.get(pos0 * 2 + 1);
        data.set(pos0 * 2, data.get(pos1 * 2));
        data.set(pos0 * 2 + 1, data.get(pos1 * 2 + 1));
        data.set(pos1 * 2, tempPointer);
        data.set(pos1 * 2 + 1, tempKeyPrefix);
    }

    @Override
    public void copyElement(LongArray src, int srcPos, LongArray dst, int dstPos) {
        dst.set(dstPos * 2, src.get(srcPos * 2));
        dst.set(dstPos * 2 + 1, src.get(srcPos * 2 + 1));
    }

    @Override
    public void copyRange(LongArray src, int srcPos, LongArray dst, int dstPos, int length) {
        Platform.copyMemory((Object)src.getBaseObject(), (long)(src.getBaseOffset() + (long)srcPos * 16L), (Object)dst.getBaseObject(), (long)(dst.getBaseOffset() + (long)dstPos * 16L), (long)((long)length * 16L));
    }

    @Override
    public LongArray allocate(int length) {
        assert ((long)length * 2L <= this.buffer.size()) : "the buffer is smaller than required: " + this.buffer.size() + " < " + length * 2;
        return this.buffer;
    }
}

