/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml.print;

import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.xml.print.BoxLoader;
import net.sf.jasperreports.engine.xml.print.ParagraphsLoader;
import net.sf.jasperreports.engine.xml.print.PenLoader;
import net.sf.jasperreports.engine.xml.print.XmlLoader;

public class StyleLoader {
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_REPORT_STYLE = "xml.base.factory.unknown.report.style";
    private static final StyleLoader INSTANCE = new StyleLoader();

    public static StyleLoader instance() {
        return INSTANCE;
    }

    public void loadStyle(XmlLoader xmlLoader, JasperPrint jasperPrint) {
        JRDesignStyle style = new JRDesignStyle(jasperPrint.getDefaultStyleProvider());
        xmlLoader.setAttribute("name", style::setName);
        xmlLoader.setBooleanAttribute("isDefault", style::setDefault);
        String parentStyle = xmlLoader.getAttribute("style");
        if (parentStyle != null) {
            Map<String, JRStyle> stylesMap = jasperPrint.getStylesMap();
            JRStyle parent = stylesMap.get(parentStyle);
            if (parent == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_REPORT_STYLE, parentStyle);
            }
            style.setParentStyle(parent);
        }
        xmlLoader.setEnumAttribute("mode", ModeEnum::getByName, style::setMode);
        xmlLoader.setColorAttribute("forecolor", style::setForecolor);
        xmlLoader.setColorAttribute("backcolor", style::setBackcolor);
        xmlLoader.setEnumAttribute("fill", FillEnum::getByName, style::setFill);
        xmlLoader.setIntAttribute("radius", style::setRadius);
        xmlLoader.setEnumAttribute("scaleImage", ScaleImageEnum::getByName, style::setScaleImage);
        xmlLoader.setEnumAttribute("hTextAlign", HorizontalTextAlignEnum::getByName, style::setHorizontalTextAlign);
        xmlLoader.setEnumAttribute("vTextAlign", VerticalTextAlignEnum::getByName, style::setVerticalTextAlign);
        xmlLoader.setEnumAttribute("hImageAlign", HorizontalImageAlignEnum::getByName, style::setHorizontalImageAlign);
        xmlLoader.setEnumAttribute("vImageAlign", VerticalImageAlignEnum::getByName, style::setVerticalImageAlign);
        xmlLoader.setEnumAttribute("rotation", RotationEnum::getByName, style::setRotation);
        xmlLoader.setAttribute("markup", style::setMarkup);
        xmlLoader.setAttribute("pattern", style::setPattern);
        xmlLoader.setBooleanAttribute("isBlankWhenNull", style::setBlankWhenNull);
        xmlLoader.setAttribute("fontName", style::setFontName);
        xmlLoader.setBooleanAttribute("isBold", style::setBold);
        xmlLoader.setBooleanAttribute("isItalic", style::setItalic);
        xmlLoader.setBooleanAttribute("isUnderline", style::setUnderline);
        xmlLoader.setBooleanAttribute("isStrikeThrough", style::setStrikeThrough);
        xmlLoader.setFloatAttribute("fontSize", style::setFontSize);
        xmlLoader.setAttribute("pdfFontName", style::setPdfFontName);
        xmlLoader.setAttribute("pdfEncoding", style::setPdfEncoding);
        xmlLoader.setBooleanAttribute("isPdfEmbedded", style::setPdfEmbedded);
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "pen": {
                    PenLoader.instance().loadPen(xmlLoader, style.getLinePen());
                    break;
                }
                case "box": {
                    BoxLoader.instance().loadBox(xmlLoader, style.getLineBox());
                    break;
                }
                case "paragraph": {
                    ParagraphsLoader.instance().loadParagraph(xmlLoader, style.getParagraph());
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
        try {
            jasperPrint.addStyle(style);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }
}

