/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.core.definition.pattern;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tiles.api.Attribute;
import org.apache.tiles.api.Definition;
import org.apache.tiles.api.Expression;
import org.apache.tiles.api.ListAttribute;

public final class PatternUtil {
    private static final Locale ROOT_LOCALE = new Locale("", "");
    private static final Pattern INVALID_FORMAT_ELEMENT = Pattern.compile("\\{[^}0-9]+}");

    private PatternUtil() {
    }

    public static Definition replacePlaceholders(Definition d, String name, Object ... varsOrig) {
        Attribute nuattr;
        Attribute attr;
        Set<String> attributeNames;
        Object[] vars = PatternUtil.replaceNullsWithBlank(varsOrig);
        Definition nudef = new Definition();
        nudef.setExtends(PatternUtil.replace(d.getExtends(), vars));
        nudef.setName(name);
        nudef.setPreparer(PatternUtil.replace(d.getPreparer(), vars));
        Attribute templateAttribute = d.getTemplateAttribute();
        if (templateAttribute != null) {
            nudef.setTemplateAttribute(PatternUtil.replaceVarsInAttribute(templateAttribute, vars));
        }
        if ((attributeNames = d.getLocalAttributeNames()) != null && !attributeNames.isEmpty()) {
            for (String attributeName : attributeNames) {
                attr = d.getLocalAttribute(attributeName);
                nuattr = PatternUtil.replaceVarsInAttribute(attr, vars);
                nudef.putAttribute(PatternUtil.replace(attributeName, vars), nuattr);
            }
        }
        if ((attributeNames = d.getCascadedAttributeNames()) != null && !attributeNames.isEmpty()) {
            for (String attributeName : attributeNames) {
                attr = d.getCascadedAttribute(attributeName);
                nuattr = PatternUtil.replaceVarsInAttribute(attr, vars);
                nudef.putAttribute(PatternUtil.replace(attributeName, vars), nuattr, true);
            }
        }
        return nudef;
    }

    public static <K, V> Map<K, V> createExtractedMap(Map<K, V> map, Set<K> keys) {
        LinkedHashMap<K, V> retValue = new LinkedHashMap<K, V>();
        for (K key : keys) {
            retValue.put(key, map.get(key));
        }
        return retValue;
    }

    private static Attribute replaceVarsInAttribute(Attribute attr, Object ... vars) {
        Attribute nuattr = attr instanceof ListAttribute ? PatternUtil.replaceVarsInListAttribute((ListAttribute)attr, vars) : PatternUtil.replaceVarsInSimpleAttribute(attr, vars);
        return nuattr;
    }

    private static Attribute replaceVarsInSimpleAttribute(Attribute attr, Object ... vars) {
        Object value;
        Attribute nuattr = new Attribute();
        nuattr.setRole(PatternUtil.replace(attr.getRole(), vars));
        nuattr.setRenderer(attr.getRenderer());
        Expression expressionObject = attr.getExpressionObject();
        if (expressionObject != null) {
            Expression newExpressionObject = Expression.createExpression(PatternUtil.replace(expressionObject.getExpression(), vars), expressionObject.getLanguage());
            nuattr.setExpressionObject(newExpressionObject);
        }
        if ((value = attr.getValue()) instanceof String) {
            value = PatternUtil.replace((String)value, vars);
        }
        nuattr.setValue(value);
        return nuattr;
    }

    private static Attribute replaceVarsInListAttribute(ListAttribute listAttr, Object ... vars) {
        ListAttribute nuListAttr = new ListAttribute();
        nuListAttr.setInherit(listAttr.isInherit());
        Object nuItems = nuListAttr.getValue();
        Iterator iterator = listAttr.getValue().iterator();
        while (iterator.hasNext()) {
            Attribute item;
            Attribute child = item = (Attribute)iterator.next();
            child = PatternUtil.replaceVarsInAttribute(child, vars);
            nuItems.add(child);
        }
        ListAttribute nuattr = nuListAttr;
        return nuattr;
    }

    private static String replace(String st, Object ... vars) {
        if (st != null && st.indexOf(123) >= 0) {
            ArrayList<String> originals = new ArrayList<String>();
            Matcher m = INVALID_FORMAT_ELEMENT.matcher(st);
            while (m.find()) {
                originals.add(m.group());
                st = m.replaceFirst("INVALID_FORMAT_ELEMENT");
                m = INVALID_FORMAT_ELEMENT.matcher(st);
            }
            st = new MessageFormat(st.replaceAll("'", "'''"), ROOT_LOCALE).format(vars, new StringBuffer(), (FieldPosition)null).toString();
            for (String original : originals) {
                st = st.replaceFirst("INVALID_FORMAT_ELEMENT", original);
            }
        }
        return st;
    }

    private static Object[] replaceNullsWithBlank(Object[] varsOrig) {
        Object[] vars = new Object[varsOrig.length];
        for (int i = 0; i < varsOrig.length; ++i) {
            vars[i] = null != varsOrig[i] ? varsOrig[i] : "";
        }
        return vars;
    }
}

