/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.fs;

import com.google.gxp.compiler.fs.AbstractFileSystem;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.fs.FileStore;
import com.google.gxp.compiler.fs.FileSystem;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class DummyFileSystem
extends AbstractFileSystem {
    public static final FileSystem INSTANCE = new DummyFileSystem();
    private final FileStore store = new FileStore(){

        @Override
        public Charset getDefaultCharset() {
            return DummyFileSystem.this.getDefaultCharset();
        }

        @Override
        public URI toUri(FileRef fileRef) {
            return URI.create("dummy://" + fileRef.getName());
        }

        @Override
        public InputStream openInputStream(FileRef fileRef) {
            throw new UnsupportedOperationException();
        }

        @Override
        public OutputStream openOutputStream(FileRef fileRef) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toFilename(FileRef fileRef) {
            return fileRef.getName();
        }

        @Override
        public String toRelativeFilename(FileRef fileRef) {
            return this.toFilename(fileRef);
        }

        @Override
        public long getLastModified(FileRef fileRef) {
            return 0L;
        }

        @Override
        public boolean delete(FileRef fileRef) {
            return false;
        }
    };
    private static Pattern LIST_DELIMITER_PATTERN = Pattern.compile(":");

    private DummyFileSystem() {
    }

    @Override
    protected FileStore getFileStore() {
        return this.store;
    }

    @Override
    public FileRef parseFilename(String filename) {
        return new FileRef(this.store, filename);
    }

    @Override
    protected Pattern getFilenameListDelimiter() {
        return LIST_DELIMITER_PATTERN;
    }
}

