/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.servlet;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.collection.ReadOnlyEnumerationMap;
import org.apache.tiles.request.collection.ScopeMap;
import org.apache.tiles.request.locale.URLApplicationResource;
import org.apache.tiles.request.servlet.extractor.ApplicationScopeExtractor;
import org.apache.tiles.request.servlet.extractor.InitParameterExtractor;

public class ServletApplicationContext
implements ApplicationContext {
    private final ServletContext servletContext;
    private Map<String, Object> applicationScope = null;
    private Map<String, String> initParam = null;

    public ServletApplicationContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public Object getContext() {
        return this.servletContext;
    }

    @Override
    public Map<String, Object> getApplicationScope() {
        if (this.applicationScope == null && this.servletContext != null) {
            this.applicationScope = new ScopeMap(new ApplicationScopeExtractor(this.servletContext));
        }
        return this.applicationScope;
    }

    @Override
    public Map<String, String> getInitParams() {
        if (this.initParam == null && this.servletContext != null) {
            this.initParam = new ReadOnlyEnumerationMap<String>(new InitParameterExtractor(this.servletContext));
        }
        return this.initParam;
    }

    @Override
    public ApplicationResource getResource(String localePath) {
        try {
            URL url = this.servletContext.getResource(localePath);
            if (url != null) {
                return new URLApplicationResource(localePath, url);
            }
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public ApplicationResource getResource(ApplicationResource base, Locale locale) {
        try {
            URL url = this.servletContext.getResource(base.getLocalePath(locale));
            if (url != null) {
                return new URLApplicationResource(base.getPath(), locale, url);
            }
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public Collection<ApplicationResource> getResources(String path) {
        ArrayList<ApplicationResource> resources = new ArrayList<ApplicationResource>();
        resources.add(this.getResource(path));
        return resources;
    }
}

