/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.schema;

import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.compiler.schema.Schema;
import com.google.gxp.compiler.schema.SchemaFactory;
import java.util.List;

public class DelegatingSchemaFactory
implements SchemaFactory {
    private final List<SchemaFactory> delegates;

    public DelegatingSchemaFactory(SchemaFactory ... delegates) {
        this.delegates = ImmutableList.of(delegates);
    }

    @Override
    public Schema fromNamespaceUri(String nsUri) {
        Schema result = null;
        for (int i = 0; i < this.delegates.size() && result == null; ++i) {
            result = this.delegates.get(i).fromNamespaceUri(nsUri);
        }
        return result;
    }

    @Override
    public Schema fromContentTypeName(String contentTypeName) {
        Schema result = null;
        for (int i = 0; i < this.delegates.size() && result == null; ++i) {
            result = this.delegates.get(i).fromContentTypeName(contentTypeName);
        }
        return result;
    }
}

