/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.FormalParameter;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.base.Util;
import com.google.gxp.compiler.schema.Schema;
import java.util.List;
import java.util.Map;

public abstract class AbstractCallable
implements Callable {
    private final TemplateName.FullyQualified name;
    private final Schema schema;
    private final ImmutableList<FormalParameter> parameters;
    private final Map<String, FormalParameter> parameterMap;
    private final Map<String, FormalParameter> parameterPrimaryMap;
    private final FormalParameter contentConsumingParameter;

    protected AbstractCallable(TemplateName.FullyQualified name, Schema schema, List<Parameter> parameters) {
        this.name = Preconditions.checkNotNull(name);
        this.schema = Preconditions.checkNotNull(schema);
        this.parameters = Util.map(Preconditions.checkNotNull(parameters), Parameter.GET_FORMAL);
        this.parameterPrimaryMap = Maps.newHashMap();
        this.parameterMap = Maps.newHashMap();
        FormalParameter contentConsumer = null;
        for (FormalParameter param : this.parameters) {
            this.parameterPrimaryMap.put(param.getPrimaryName(), param);
            for (String paramName : param.getNames()) {
                this.parameterMap.put(paramName, param);
            }
            if (!param.consumesContent()) continue;
            contentConsumer = param;
        }
        this.contentConsumingParameter = contentConsumer;
    }

    @Override
    public TemplateName.FullyQualified getName() {
        return this.name;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public List<FormalParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public FormalParameter getParameter(String name) {
        return this.parameterMap.get(name);
    }

    @Override
    public FormalParameter getParameterByPrimary(String name) {
        return this.parameterPrimaryMap.get(name);
    }

    @Override
    public FormalParameter getContentConsumingParameter() {
        return this.contentConsumingParameter;
    }

    public abstract boolean equals(Object var1);

    protected final boolean equalsAbstractCallable(AbstractCallable that) {
        return Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getSchema(), that.getSchema()) && Objects.equal(this.getParameters(), that.getParameters());
    }

    public abstract int hashCode();

    protected int abstractCallableHashCode() {
        return Objects.hashCode(this.getName(), this.getSchema(), this.getParameters());
    }
}

